﻿/*
 * PaletteToolServer.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;
using System.Reflection;
using System.CodeDom.Compiler;
using System.Drawing;
using System.Xml.Serialization;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    public static class PaletteToolServer {
        public static Dictionary<string, object> LoadedTools = new Dictionary<string, object>();

        public static void Init() {
            string path = Path.Combine( Application.StartupPath, "tool" );
            if ( !Directory.Exists( path ) ) {
                return;
            }

            FileInfo[] files = new DirectoryInfo( path ).GetFiles( "*.txt" );
            foreach ( FileInfo file in files ) {
                string code = "";
                using ( StreamReader sr = new StreamReader( file.FullName ) ){
                    code += sr.ReadToEnd();
                }
                CompilerResults results;
                Assembly asm = AppManager.CompileScript( code, out results );
                foreach ( Type t in asm.GetTypes() ) {
                    if ( t.IsClass && t.IsPublic && !t.IsAbstract && t.GetInterface( typeof( IPaletteTool ).FullName ) != null ) {
                        try {
#if DEBUG
                            Common.DebugWriteLine( "t.FullName=" + t.FullName );
#endif
                            object instance = asm.CreateInstance( t.FullName );
                            string dir = Path.Combine( AppManager.ApplicationDataPath, "tool" );
                            string cfg = Path.GetFileNameWithoutExtension( file.FullName ) + ".config";
                            string config = Path.Combine( dir, cfg );
                            if ( File.Exists( config ) ) {
                                XmlStaticMemberSerializer xsms = new XmlStaticMemberSerializer( instance.GetType() );
                                using ( FileStream fs = new FileStream( config, FileMode.Open ) ) {
                                    xsms.Deserialize( fs );
                                }
                            }
                            string id = Path.GetFileNameWithoutExtension( file.FullName );
                            LoadedTools.Add( id, instance );
#if DEBUG
                            Common.DebugWriteLine( "PaletteToolServer.Init; id=" + id );
#endif
                        } catch {
                        }
                    }
                }
            }
        }

        public static bool InvokePaletteTool( string id, EditorManager manager, int track, int[] vsq_event_intrenal_ids, MouseButtons button ) {
            if ( LoadedTools.ContainsKey( id ) ) {
                VsqTrack item = (VsqTrack)manager.VsqFile.Track[track].Clone();
                bool edited = ((IPaletteTool)LoadedTools[id]).edit( item, manager, vsq_event_intrenal_ids, button );
                if ( edited ) {
                    CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( track, item, manager.VsqFile.AttachedCurves[track - 1], manager.VsqFile.getPitchCurve( track ) );
                    manager.Register( manager.VsqFile.executeCommand( run ) );
                }
                return edited;
            } else {
                return false;
            }
        }
    }

}
