﻿/*
 * vstildr.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
namespace Boare.Cadencii {

    public delegate void WaveIncomingEventHandler( double[] L, double[] R );
    public delegate void FirstBufferWrittenEventHandler();
    public delegate void RenderingFinishedEventHandler();

    public unsafe interface vstildr {
        event WaveIncomingEventHandler WaveIncoming;
        void SetFirstBufferWrittenCallback( FirstBufferWrittenEventHandler handler );
        event RenderingFinishedEventHandler RenderingFinished;

        void Terminate();
        bool Init( char[] dll_path, int block_size, int sample_rate );
        int SendEvent( byte* src, int* deltaFrames, int numEvents, int targetTrack );
        int StartRendering( long total_samples,
                            double amplify_left,
                            double amplify_right,
                            int error_samples,
                            bool event_enabled,
                            bool direct_play_enabled,
                            string[] files,
                            double wave_read_offset_seconds,
                            bool mode_infinite );
        void AbortRendering();
        double GetProgress();
        float GetPlayTime();
        void WaveOutReset();
        int JoyInit();
        bool JoyGetStatus( int index, out byte[] buttons, out int pov );
        int JoyGetNumJoyDev();
    }

}
