﻿/*
 * FormBezierPointEdit.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace Boare.Cadencii {
    
    partial class FormBezierPointEdit : Form {
        private PointD m_base;
        private PointD m_control_left;
        private PointD m_control_right;
        private int m_min;
        private int m_max;

        public FormBezierPointEdit( PointD base_point, PointD control_left, PointD control_right, bool smooth_enabled, CurveType curve_type ) {
            InitializeComponent();
            ApplyLanguage();
            m_base = base_point;
            m_control_left = control_left;
            m_control_right = control_right;
            txtDataPointClock.Text = m_base.X.ToString();
            txtDataPointValue.Text = m_base.Y.ToString();
            txtLeftClock.Text = m_control_left.X.ToString();
            txtLeftValue.Text = m_control_left.Y.ToString();
            txtRightClock.Text = m_control_right.X.ToString();
            txtRightValue.Text = m_control_right.Y.ToString();
            SmoothEnabled = smooth_enabled;
            m_min = curve_type.Minimum;
            m_max = curve_type.Maximum;
        }

        private static string _( string message ) {
            return Messaging.GetMessage( message );
        }

        public void ApplyLanguage() {
            Text = _( "Edit Bezier Data Point" );
            
            groupDataPoint.Text = _( "Data Poin" );
            lblDataPointClock.Text = _( "Clock" );
            lblDataPointValue.Text = _( "Value" );

            groupLeft.Text = _( "Left Control Point" );
            lblLeftClock.Text = _( "Clock" );
            lblLeftValue.Text = _( "Value" );

            groupRight.Text = _( "Right Control Point" );
            lblRightClock.Text = _( "Clock" );
            lblRightValue.Text = _( "Value" );

            chkEnableSmooth.Text = _( "Smooth" );
        }
        
        public bool SmoothEnabled {
            get {
                return chkEnableSmooth.Checked;
            }
            set {
                chkEnableSmooth.Checked = value;
            }
        }
        
        public PointD DataPoint {
            get {
                int x, y;
                try {
                    x = int.Parse( txtDataPointClock.Text );
                    y = int.Parse( txtDataPointValue.Text );
                    return new PointD( x, y );
                } catch {
                    return m_base;
                }
            }
        }
        
        public PointD ControlLeft {
            get {
                int x, y;
                try {
                    x = int.Parse( txtLeftClock.Text );
                    y = int.Parse( txtLeftValue.Text );
                    return new PointD( x, y );
                } catch {
                    return m_control_left;
                }
            }
        }

        public PointD ControlRight {
            get {
                int x, y;
                try {
                    x = int.Parse( txtRightClock.Text );
                    y = int.Parse( txtRightValue.Text );
                    return new PointD( x, y );
                } catch {
                    return m_control_right;
                }
            }
        }
        
        private void btnOK_Click( object sender, EventArgs e ) {
            try {
                int x, y;
                x = int.Parse( txtDataPointClock.Text );
                y = int.Parse( txtDataPointValue.Text );
                if ( y < m_min || m_max < y ) {
                    MessageBox.Show( _( "Invalid value" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Error );
                    return;
                }
                if ( chkEnableSmooth.Checked ) {
                    x = int.Parse( txtLeftClock.Text );
                    y = int.Parse( txtLeftValue.Text );
                    x = int.Parse( txtRightClock.Text );
                    y = int.Parse( txtRightValue.Text );
                }
                DialogResult = DialogResult.OK;
            } catch {
                MessageBox.Show( _( "Integer format error" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Error );
            }
        }
        
        private void chkEnableSmooth_CheckedChanged( object sender, EventArgs e ) {
            bool value = chkEnableSmooth.Checked;
            txtLeftClock.Enabled = value;
            txtLeftValue.Enabled = value;
            txtRightClock.Enabled = value;
            txtRightValue.Enabled = value;
        }
    }

}
