/*
 * TextMemoryStream.cpp
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "TextMemoryStream.h"

namespace Boare{ namespace Lib{ namespace Vsq{

/// <summary>
/// 
/// </summary>
/// <param name="s"></param>
void TextMemoryStream_t::Write( string value ) {
    m_ms << value;
}

void TextMemoryStream_t::Rewind() {
    m_ms.seekg( 0, ios::beg );
}

void TextMemoryStream_t::WriteLine( string s ) {
    m_ms << s << "\x0d\x0a";
}

void TextMemoryStream_t::Close() {
    m_ms.str( "" );
}

int TextMemoryStream_t::Peek() {
    long current = m_ms.tellg();
    int ret = m_ms.get();
    if( m_ms.gcount() <= 0 ){
        m_ms.seekg( current, ios::beg );
        return -1;
    }
    m_ms.seekg( current, ios::beg );
    return ret;
}

string TextMemoryStream_t::ReadLine() {
    ostringstream buffer;
    char value;
    char ret;
    ret = m_ms.get();
    while ( ret >= 0 ) {
        value = (char)ret;
        if ( value == NEW_LINE[0] ) {
            char next;
            long current = m_ms.tellg(); //0x0Dを検出した直後のストリームの位置
            for ( int i = 1; i < 2; i++ ) {
                ret = m_ms.get();
                if ( ret >= 0 ) {
                    next = ret;
                    if ( next != NEW_LINE[i] ) {
                        m_ms.seekg( current, ios::beg );
                        break;
                    }
                }
            }
            break;
        }
        buffer << value;
        ret = m_ms.get();
    }
    return buffer.str();
}

void TextMemoryStream_t::Dispose() {
    m_ms.str( "" );
}

TextMemoryStream_t::TextMemoryStream_t( string path ) {
    m_ms.str( "" );
    //if ( File.Exists( path ) ) {
    Boare::Lib::Vsq::StreamReader sr( path );
    while( sr.Peek() >= 0 ){
        string line = sr.ReadLine();
        m_ms << line << "\x0d\x0a";
    }
    sr.Close();
    m_ms.seekg( 0, ios::beg );
    NEW_LINE[0] = '\x0d';
    NEW_LINE[1] = '\x0a';
}

TextMemoryStream_t::TextMemoryStream_t(){
    m_ms.str( "" );
    NEW_LINE[0] = '\x0d';
    NEW_LINE[1] = '\x0a';
}

} } }
