/*
 * ITextWriter.cs
 * Copyright © 2009-2011 kbinani
 *
 * This file is part of org.kbinani.vsq.
 *
 * org.kbinani.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * org.kbinani.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.vsq;

import java.io.*;
#else

namespace org{
    namespace kbinani{
        namespace vsq{

#if CSHARP
using System;
#endif

#endif

#if __cplusplus
            class ITextWriter
#else
            public interface ITextWriter
#endif
            {
#if JAVA
                void write( String value ) throws IOException;
                void writeLine( String value ) throws IOException;
                void close() throws IOException;
                void newLine() throws IOException;
#elif __cplusplus
                virtual void write( string value ) = 0;
                virtual void writeLine( string value ) = 0;
                virtual void close() = 0;
                virtual void newLine() = 0;
#else
                void write( String value );
                void writeLine( String value );
                void close();
                void newLine();
#endif
        }

#if !JAVA
        }
    }
}
#endif
