/*
 * FormMain.cs
 * Copyright (c) 2008-2010 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.Cadencii;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import org.kbinani.*;
import org.kbinani.apputil.*;
import org.kbinani.componentModel.*;
import org.kbinani.media.*;
import org.kbinani.vsq.*;
import org.kbinani.windows.forms.*;
#else
//#define MONITOR_FPS
#define AUTHOR_LIST_SAVE_BUTTON_VISIBLE
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Media;
using System.Threading;
using System.Windows.Forms;
using Boare.Lib.AppUtil;
using Boare.Lib.Media;
using Boare.Lib.Vsq;
using bocoree;
using bocoree.awt;
using bocoree.awt.event_;
using bocoree.io;
using bocoree.util;
using bocoree.windows.forms;
using bocoree.xml;

namespace Boare.Cadencii {
    using BEventArgs = System.EventArgs;
    using BEventHandler = System.EventHandler;
    using BKeyEventArgs = System.Windows.Forms.KeyEventArgs;
    using BMouseButtons = System.Windows.Forms.MouseButtons;
    using BMouseEventArgs = System.Windows.Forms.MouseEventArgs;
    using boolean = System.Boolean;
    using Integer = System.Int32;
    using java = bocoree;
    using Long = System.Int64;
#endif

#if JAVA
    public class FormMain extends BForm{
#else
    public class FormMain : BForm {
#endif
        #region Static Readonly Field
        private readonly Color s_pen_105_105_105 = new Color( 105, 105, 105 );
        private readonly Color s_pen_187_187_255 = new Color( 187, 187, 255 );
        private readonly Color s_pen_007_007_151 = new Color( 7, 7, 151 );
        private readonly Color s_pen_065_065_065 = new Color( 65, 65, 65 );
        private readonly Color s_txtbox_backcolor = new Color( 128, 128, 128 );
        private readonly Color s_note_fill = new Color( 181, 220, 86 );
        private readonly AuthorListEntry[] _CREDIT = new AuthorListEntry[]{
            new AuthorListEntry( "is developped by:", 2 ),
            new AuthorListEntry( "kbinani (@kbinani)" ),
            new AuthorListEntry( "修羅場P (@shurabaP)" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Special Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "tool icons designer:", 2 ),
            new AuthorListEntry( "Yusuke KAMIYAMANE (@ykamiyamane)" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of STRAIGHT LIBRARY:", 2 ),
            new AuthorListEntry( "Hideki KAWAHARA" ),
            new AuthorListEntry( "Tetsu TAKAHASHI" ),
            new AuthorListEntry( "Hideki BANNO" ),
            new AuthorListEntry( "Masanori MORISE (@m_morise)" ),
            new AuthorListEntry( "(sorry, list is not complete)", 2 ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of v.Connect:", 2 ),
            new AuthorListEntry( "修羅場P (@shurabaP)" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of UTAU:", 2 ),
            new AuthorListEntry( "飴屋/菖蒲 (@ameyaP_)" ),
            new AuthorListEntry(),
            new AuthorListEntry( "promoter:", 2 ),
            new AuthorListEntry( "zhuo (@zhuop)" ),
            new AuthorListEntry(),
            new AuthorListEntry( "library tester:", 2 ),
            new AuthorListEntry( "evm" ),
            new AuthorListEntry( "そろそろP" ),
            new AuthorListEntry( "めがね１１０" ),
            new AuthorListEntry( "上総" ),
            new AuthorListEntry( "NOIKE" ),
            new AuthorListEntry( "逃亡者" ),
            new AuthorListEntry(),
            new AuthorListEntry( "translator:", 2 ),
            new AuthorListEntry( "Eji (zh-TW translation, @ejiwarp)" ),
            new AuthorListEntry( "kankan (zh-TW translation)" ),
            new AuthorListEntry( "yxmline (zh-CN translation)" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "ないしょの人" ),
            new AuthorListEntry( "naquadah" ),
            new AuthorListEntry( "1zo" ),
            new AuthorListEntry( "Amby" ),
            new AuthorListEntry( "ケロッグ" ),
            new AuthorListEntry( "beginner" ),
            new AuthorListEntry( "b2ox (@b2ox)" ),
            new AuthorListEntry( "麻太郎" ),
            new AuthorListEntry( "もみじぱん (@momijipan)" ),
            new AuthorListEntry( "PEX (@pex_zeo)" ),
            new AuthorListEntry( "やなぎがうら" ),
            new AuthorListEntry( "cocoonP (@cocoonP)" ),
            new AuthorListEntry( "かつ" ),
            new AuthorListEntry( "ちゃそ" ),
            new AuthorListEntry( "ちょむ" ),
            new AuthorListEntry( "whimsoft" ),
            new AuthorListEntry( "kitiketao (@okoktaokokta)" ),
            new AuthorListEntry( "カプチ２" ),
            new AuthorListEntry( "あにぃ" ),
            new AuthorListEntry( "tomo" ),
            new AuthorListEntry( "ナウ□マP (@now_romaP)" ),
            new AuthorListEntry( "内藤　魅亜 (@mianaito)" ),
            new AuthorListEntry( "空茶 (@maizeziam)" ),
            new AuthorListEntry( "いぬくま" ),
            new AuthorListEntry( "shu-t (@shu_sonicwave)" ),
            new AuthorListEntry( "さささ (@sasasa3396)" ),
            new AuthorListEntry( "kotoi" ),
            new AuthorListEntry( "げっぺータロー (@geppeitaro)" ),
            new AuthorListEntry( "みけCAT" ),
            new AuthorListEntry( "all members of Cadencii bbs", 2 ),
            new AuthorListEntry(),
            new AuthorListEntry( "     ... and you !", 3 ),
        };
        private readonly Font s_F9PT = new Font( java.awt.Font.SANS_SERIF, java.awt.Font.PLAIN, 9 );
        #endregion

        #region Constants and internal enums
        /// <summary>
        /// カーブエディタ画面の編集モード
        /// </summary>
        enum CurveEditMode {
            /// <summary>
            /// 何もしていない
            /// </summary>
            NONE,
            /// <summary>
            /// 鉛筆ツールで編集するモード
            /// </summary>
            EDIT,
            /// <summary>
            /// ラインツールで編集するモード
            /// </summary>
            LINE,
            /// <summary>
            /// 鉛筆ツールでVELを編集するモード
            /// </summary>
            EDIT_VEL,
            /// <summary>
            /// ラインツールでVELを編集するモード
            /// </summary>
            LINE_VEL,
            /// <summary>
            /// 真ん中ボタンでドラッグ中
            /// </summary>
            MIDDLE_DRAG,
        }

        enum ExtDragXMode {
            RIGHT,
            LEFT,
            NONE,
        }

        enum ExtDragYMode {
            UP,
            DOWN,
            NONE,
        }

        enum GameControlMode {
            DISABLED,
            NORMAL,
            KEYBOARD,
            CURSOR,
        }

        enum OverviewMouseDownMode {
            NONE,
            LEFT,
            MIDDLE,
        }

        enum PositionIndicatorMouseDownMode {
            NONE,
            MARK_START,
            MARK_END,
            TEMPO,
            TIMESIG,
        }

        /// <summary>
        /// スクロールバーの最小サイズ(ピクセル)
        /// </summary>
        private const int MIN_BAR_ACTUAL_LENGTH = 17;
        /// <summary>
        /// エントリの端を移動する時の、ハンドル許容範囲の幅
        /// </summary>
        private const int _EDIT_HANDLE_WIDTH = 7;
        private const int _TOOL_BAR_HEIGHT = 46;
        /// <summary>
        /// 単音プレビュー時に、wave生成完了を待つ最大の秒数
        /// </summary>
        private const double _WAIT_LIMIT = 5.0;
        public const String _APP_NAME = "Cadencii";
        /// <summary>
        /// 表情線の先頭部分のピクセル幅
        /// </summary>
        private const int _PX_ACCENT_HEADER = 21;
        /// <summary>
        /// パフォーマンスカウンタ用バッファの容量
        /// </summary>
        private const int _NUM_PCOUNTER = 50;
        private const String _VERSION_HISTORY_URL = "http://www.ne.jp/asahi/kbinani/home/cadencii/version_history.xml";
        /// <summary>
        /// コントロールカーブが不可視状態における、splitContainer1.Panel2の最小サイズ
        /// </summary>
        private const int _SPL1_PANEL2_MIN_HEIGHT = 34;
        /// <summary>
        /// splitContainer2.Panel2の最小サイズ
        /// </summary>
        private const int _SPL2_PANEL2_MIN_HEIGHT = 25;
        /// <summary>
        /// splitContainer*で使用するSplitterWidthプロパティの値
        /// </summary>
        private const int _SPL_SPLITTER_WIDTH = 4;
        const int _PICT_POSITION_INDICATOR_HEIGHT = 48;
        const int _SCROLL_WIDTH = 16;
        /// <summary>
        /// Overviewペインの高さ
        /// </summary>
        const int _OVERVIEW_HEIGHT = 50;
        /// <summary>
        /// splitContainerPropertyの最小幅
        /// </summary>
        const int _PROPERTY_DOCK_MIN_WIDTH = 50;
        /// <summary>
        /// Overviewに描く音符を表す円の直径
        /// </summary>
        const int _OVERVIEW_DOT_DIAM = 2;
        /// <summary>
        /// btnLeft, btnRightを押した時の、スクロール速度(px/sec)。
        /// </summary>
        const float _OVERVIEW_SCROLL_SPEED = 500.0f;
        const int _OVERVIEW_SCALE_COUNT_MAX = 7;
        const int _OVERVIEW_SCALE_COUNT_MIN = 3;
        #endregion

        #region Static Field
        /// <summary>
        /// CTRLキー。MacOSXの場合はMenu
        /// </summary>
        private int s_modifier_key = java.awt.event_.InputEvent.CTRL_MASK;
        #endregion

        #region Fields
        private VersionInfo m_versioninfo = null;
        private Cursor HAND;
        /// <summary>
        /// ボタンがDownされた位置。(座標はpictureBox基準)
        /// </summary>
        private Point m_button_initial;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのvscrollのvalue値
        /// </summary>
        private int m_middle_button_vscroll;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのhscrollのvalue値
        /// </summary>
        private int m_middle_button_hscroll;
        private boolean m_edited = false;
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        private float[] m_performance = new float[_NUM_PCOUNTER];
        /// <summary>
        /// 最後にメイン画面が更新された時刻(秒単位)
        /// </summary>
        private double _last_screen_refreshed_sec;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        private float m_fps = 0f;
        /// <summary>
        /// カーブエディタの編集モード
        /// </summary>
        private CurveEditMode m_edit_curve_mode = CurveEditMode.NONE;
        /// <summary>
        /// ピアノロールの右クリックが表示される直前のマウスの位置
        /// </summary>
        private Point m_cMenuOpenedPosition;
        /// <summary>
        /// トラック名の入力に使用するテキストボックス
        /// </summary>
        private TextBoxEx m_txtbox_track_name;
        /// <summary>
        /// ピアノロールの画面外へのドラッグ時、前回自動スクロール操作を行った時刻
        /// </summary>
        private double m_timer_drag_last_ignitted;
        /// <summary>
        /// 画面外への自動スクロールモード
        /// </summary>
        private ExtDragXMode m_ext_dragx = ExtDragXMode.NONE;
        private ExtDragYMode m_ext_dragy = ExtDragYMode.NONE;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの仮想スクリーン上の位置
        /// </summary>
        private Point m_mouse_move_init;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの位置と，音符の先頭との距離(ピクセル)
        /// </summary>
        private int m_mouse_move_offset;
        /// <summary>
        /// マウスが降りているかどうかを表すフラグ．AppManager.isPointerDownedとは別なので注意
        /// </summary>
        private boolean m_mouse_downed = false;
        /*/// <summary>
        /// テンポ変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private boolean m_tempo_dragging = false;*/
        private int m_tempo_dragging_deltaclock = 0;
        /* /// <summary>
        /// 拍子変更の位置を、マウスドラッグで移動させているかどうかを表すフラグ
        /// </summary>
        private boolean m_timesig_dragging = false;*/
        private int m_timesig_dragging_deltaclock = 0;
        private boolean m_mouse_downed_trackselector = false;
        private ExtDragXMode m_ext_dragx_trackselector = ExtDragXMode.NONE;
        private boolean m_mouse_moved = false;
        /// <summary>
        /// マウスホバーを発生させるスレッド
        /// </summary>
        private Thread m_mouse_hover_thread = null;
        private boolean m_last_is_imemode_on = true;
        private boolean m_last_symbol_edit_mode = false;
        /// <summary>
        /// 鉛筆のモード
        /// </summary>
        private PencilMode m_pencil_mode = new PencilMode();
        /*private boolean m_startmark_dragging = false;
        private boolean m_endmark_dragging = false;*/
        /// <summary>
        /// ビブラート範囲を編集中の音符のInternalID
        /// </summary>
        private int m_vibrato_editing_id = -1;
        private TrackSelector trackSelector;
        /// <summary>
        /// このフォームがアクティブ化されているかどうか
        /// </summary>
        private boolean m_form_activated = true;
        private GameControlMode m_game_mode = GameControlMode.DISABLED;
        /// <summary>
        /// 直接再生モード時の、再生開始した位置の曲頭からの秒数
        /// </summary>
        private float m_direct_play_shift = 0.0f;
        /// <summary>
        /// プレビュー再生の長さ
        /// </summary>
        private double m_preview_ending_time;
        private System.Windows.Forms.Timer m_timer;
        private boolean m_last_pov_r = false;
        private boolean m_last_pov_l = false;
        private boolean m_last_pov_u = false;
        private boolean m_last_pov_d = false;
        private boolean m_last_btn_x = false;
        private boolean m_last_btn_o = false;
        private boolean m_last_btn_re = false;
        private boolean m_last_btn_tr = false;
        private boolean m_last_select = false;
        /// <summary>
        /// 前回ゲームコントローラのイベントを処理した時刻
        /// </summary>
        private DateTime m_last_event_processed;
        /// <summary>
        /// splitContainer2.Panel2を最小化する直前の、splitContainer2.SplitterDistance
        /// </summary>
        private int m_last_splitcontainer2_split_distance = -1;
        private boolean m_spacekey_downed = false;
        private MidiInDevice m_midi_in = null;
        private FormMidiImExport m_midi_imexport_dialog = null;
        private TreeMap<EditTool, Cursor> m_cursor = new TreeMap<EditTool, Cursor>();
        private Preference m_preference_dlg;
        private ToolStripButton m_strip_ddbtn_metronome;
        //private FormUtauVoiceConfig m_utau_voice_dialog = null;
        private PropertyPanelContainer m_property_panel_container;
        private Vector<ToolStripItem> m_palette_tools = new Vector<ToolStripItem>();

        private int m_overview_direction = 1;
        private Thread m_overview_update_thread = null;
        private int m_overview_start_to_draw_clock_initial_value;
        /// <summary>
        /// btnLeftまたはbtnRightが下りた時刻
        /// </summary>
        private DateTime m_overview_btn_downed;
        /// <summary>
        /// Overview画面左端でのクロック
        /// </summary>
        private int m_overview_start_to_draw_clock = 0;
        /// <summary>
        /// Overview画面の表示倍率
        /// </summary>
        private float m_overview_px_per_clock = 0.01f;
        /// <summary>
        /// Overview画面に表示されている音符の，平均ノートナンバー．これが，縦方向の中心線に反映される
        /// </summary>
        private float m_overview_average_note = 60.0f;
        /// <summary>
        /// Overview画面でマウスが降りている状態かどうか
        /// </summary>
        private OverviewMouseDownMode m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
        /// <summary>
        /// PositionIndicatorのマウスモード
        /// </summary>
        private PositionIndicatorMouseDownMode m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
        /// <summary>
        /// Overview画面で、マウスが下りた位置のx座標
        /// </summary>
        private int m_overview_mouse_downed_locationx;
        private PictureBox pictKeyLengthSplitter;
        private int m_overview_scale_count = 5;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入ったかどうか
        /// </summary>
        private boolean m_key_length_splitter_mouse_downed = false;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、マウスのスクリーン座標
        /// </summary>
        private Point m_key_length_splitter_initial_mouse;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、keyWidthの値
        /// </summary>
        private int m_key_length_init_value = 68;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、trackSelectorのgetRowsPerColumn()の値
        /// </summary>
        private int m_key_length_trackselector_rowspercolumn = 1;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、splitContainer1のSplitterLocationの値
        /// </summary>
        private int m_key_length_splitter_distance = 0;
        /// <summary>
        /// AppManager.inputTextBoxがhideInputTextBoxによって隠された後、何回目のEnterキーの入力を受けたかを表すカウンター。
        /// </summary>
        private int numEnterKeyAfterHideInputTextBox = 0;
        /// <summary>
        /// Deleteキーがショートカットとして割り当てられているアイテム．
        /// </summary>
        private BMenuItem deleteShortcutHolder = null;
        #endregion

        public FormMain( String file ) {
#if DEBUG
            bocoree.debug.push_log( "FormMain..ctor()" );
            bocoree.debug.push_log( "    " + Environment.OSVersion.ToString() );
            bocoree.debug.push_log( "    FormID=" + AppManager.getID() );
            AppManager.debugWriteLine( "FormMain..ctor()" );
#endif
            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, 10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 );

            s_modifier_key = ((AppManager.editorConfig.Platform == Platform.Macintosh) ? InputEvent.META_MASK : InputEvent.CTRL_MASK);

            VsqFileEx tvsq = new VsqFileEx( AppManager.editorConfig.DefaultSingerName,
                                           AppManager.editorConfig.DefaultPreMeasure,
                                           4,
                                           4,
                                           500000 );
            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            tvsq.Track.get( 1 ).changeRenderer( renderer, singers );
            AppManager.setVsqFile( tvsq );
#if JAVA
            initialize();
#else
            InitializeComponent();
#endif

            m_overview_scale_count = AppManager.editorConfig.OverviewScaleCount;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );

            menuVisualOverview.setSelected( AppManager.editorConfig.OverviewEnabled );
            m_property_panel_container = new PropertyPanelContainer();

            m_strip_ddbtn_metronome = new ToolStripButton( "Metronome", Properties.Resources.alarm_clock );
            m_strip_ddbtn_metronome.Name = "m_strip_ddbtn_metronome";
            m_strip_ddbtn_metronome.CheckOnClick = true;
            m_strip_ddbtn_metronome.Checked = AppManager.editorConfig.MetronomeEnabled;
            m_strip_ddbtn_metronome.CheckedChanged += new EventHandler( m_strip_ddbtn_metronome_CheckedChanged );
            toolStripBottom.Items.Add( m_strip_ddbtn_metronome );

            trackSelector = new TrackSelector();
            updateTrackSelectorVisibleCurve();
            trackSelector.setBackground( new Color( 108, 108, 108 ) );
            trackSelector.setCurveVisible( true );
            trackSelector.setLocation( new Point( 0, 242 ) );
            trackSelector.Margin = new Padding( 0 );
            trackSelector.Name = "trackSelector";
            trackSelector.setSelectedCurve( CurveType.VEL );
            trackSelector.setSize( 446, 250 );
            trackSelector.TabIndex = 0;
            trackSelector.MouseClick += new MouseEventHandler( this.trackSelector_MouseClick );
            trackSelector.SelectedTrackChanged += new SelectedTrackChangedEventHandler( this.trackSelector_SelectedTrackChanged );
            trackSelector.MouseUp += new MouseEventHandler( this.trackSelector_MouseUp );
            trackSelector.MouseDown += new MouseEventHandler( trackSelector_MouseDown );
            trackSelector.SelectedCurveChanged += new SelectedCurveChangedEventHandler( this.trackSelector_SelectedCurveChanged );
            trackSelector.MouseMove += new MouseEventHandler( this.trackSelector_MouseMove );
            trackSelector.RenderRequired += new RenderRequiredEventHandler( this.trackSelector_RenderRequired );
            trackSelector.PreviewKeyDown += new PreviewKeyDownEventHandler( this.trackSelector_PreviewKeyDown );
            trackSelector.KeyDown += new KeyEventHandler( commonCaptureSpaceKeyDown );
            trackSelector.KeyUp += new KeyEventHandler( commonCaptureSpaceKeyUp );
            trackSelector.PreferredMinHeightChanged += new EventHandler( trackSelector_PreferredMinHeightChanged );
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            this.setMinimumSize( getWindowMinimumSize() );

            stripBtnScroll.Checked = AppManager.autoScroll;
            applySelectedTool();
            applyQuantizeMode();

            // Palette Toolの読み込み
            updatePaletteTool();

            // toolStipの位置を，前回終了時の位置に戻す
            Vector<ToolStrip> top = new Vector<ToolStrip>();
            Vector<ToolStrip> bottom = new Vector<ToolStrip>();
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripTool );
                    top.add( toolStripTool );
                } else if ( toolStripTool.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripTool );
                    bottom.add( toolStripTool );
                }
            }
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripMeasure );
                    top.add( toolStripMeasure );
                } else if ( toolStripMeasure.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripMeasure );
                    bottom.add( toolStripMeasure );
                }
            }
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPosition );
                    top.add( toolStripPosition );
                } else if ( toolStripPosition.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPosition );
                    bottom.add( toolStripPosition );
                }
            }
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripFile );
                    top.add( toolStripFile );
                } else if ( toolStripFile.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripFile );
                    bottom.add( toolStripFile );
                }
            }
            /*if ( toolStripPaletteTools.Parent != null ) {
                if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    toolStripContainer.TopToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        top.Add( toolStripPaletteTools );
                    }
                } else if ( toolStripPaletteTools.Parent.Equals( toolStripContainer.BottomToolStripPanel ) ) {
                    toolStripContainer.BottomToolStripPanel.Controls.Remove( toolStripPaletteTools );
                    if ( toolStripPaletteTools.Visible ) {
                        bottom.Add( toolStripPaletteTools );
                    }
                }
            }*/

            splitContainer1.Panel1.BorderStyle = BorderStyle.None;
            splitContainer1.Panel2.BorderStyle = BorderStyle.None;
            splitContainer1.BackColor = System.Drawing.Color.FromArgb( 212, 212, 212 );
            splitContainer2.Panel1.Controls.Add( panel1 );
            panel1.Dock = DockStyle.Fill;
            splitContainer2.Panel2.Controls.Add( panel2 );
            splitContainer2.Panel2.BorderStyle = BorderStyle.FixedSingle;
            splitContainer2.Panel2.BorderColor = System.Drawing.Color.FromArgb( 112, 112, 112 );
            splitContainer1.Panel1.Controls.Add( splitContainer2 );
            panel2.Dock = DockStyle.Fill;
            splitContainer2.Dock = DockStyle.Fill;
            splitContainer1.Panel2.Controls.Add( trackSelector );
            trackSelector.Dock = DockStyle.Fill;
            splitContainer1.Dock = DockStyle.Fill;
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            splitContainerProperty.FixedPanel = FixedPanel.Panel1;
            splitContainerProperty.Panel1.Controls.Add( m_property_panel_container );
            m_property_panel_container.Dock = DockStyle.Fill;
            splitContainerProperty.Panel2.Controls.Add( splitContainer1 );
            splitContainerProperty.Dock = DockStyle.Fill;

            // コントロールの位置・サイズを調節
            splitContainer2.Panel1.SuspendLayout();
            panel1.SuspendLayout();
            pictPianoRoll.SuspendLayout();
            vScroll.SuspendLayout();
            // panel1の中身は
            // picturePositionIndicator
            picturePositionIndicator.Left = 0;
            picturePositionIndicator.Top = 0;
            picturePositionIndicator.Width = panel1.Width;
            // pictPianoRoll
            pictPianoRoll.Left = 0;
            pictPianoRoll.Top = picturePositionIndicator.Height;
            pictPianoRoll.Width = panel1.Width - vScroll.Width;
            pictPianoRoll.Height = panel1.Height - picturePositionIndicator.Height - hScroll.Height;
            // vScroll
            vScroll.Left = pictPianoRoll.Width;
            vScroll.Top = picturePositionIndicator.Height;
            vScroll.Height = pictPianoRoll.Height;
            // pictureBox3
            pictureBox3.Left = 0;
            pictureBox3.Top = panel1.Height - hScroll.Height;
            pictureBox3.Height = hScroll.Height;
            // hScroll
            hScroll.Left = pictureBox3.Width;
            hScroll.Top = panel1.Height - hScroll.Height;
            hScroll.Width = panel1.Width - pictureBox3.Width - trackBar.Width - pictureBox2.Width;
            // trackBar
            trackBar.Left = pictureBox3.Width + hScroll.Width;
            trackBar.Top = panel1.Height - hScroll.Height;
            // pictureBox2
            pictureBox2.Left = panel1.Width - vScroll.Width;
            pictureBox2.Top = panel1.Height - hScroll.Height;

            vScroll.ResumeLayout();
            pictPianoRoll.ResumeLayout();
            panel1.ResumeLayout();
            splitContainer2.Panel1.ResumeLayout();

            pictPianoRoll.MouseWheel += new MouseEventHandler( pictPianoRoll_MouseWheel );
            trackSelector.MouseWheel += new MouseEventHandler( trackSelector_MouseWheel );
            picturePositionIndicator.MouseWheel += new MouseEventHandler( picturePositionIndicator_MouseWheel );
            menuVisualOverview.CheckedChanged += new EventHandler( menuVisualOverview_CheckedChanged );

            hScroll.Maximum = AppManager.getVsqFile().TotalClocks + 240;
            hScroll.SmallChange = 240;
            hScroll.LargeChange = 240 * 4;

            vScroll.Maximum = AppManager.editorConfig.PxTrackHeight * 128;
            vScroll.SmallChange = 24;
            vScroll.LargeChange = 24 * 4;

            trackSelector.setCurveVisible( true );

            // 左上のやつから順に登録
            XmlPoint p = AppManager.editorConfig.ToolEditTool.Location;
            toolStripTool.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolMeasureLocation.Location;
            toolStripMeasure.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolPositionLocation.Location;
            toolStripPosition.Location = new System.Drawing.Point( p.x, p.y );
            p = AppManager.editorConfig.ToolFileLocation.Location;
            toolStripFile.Location = new System.Drawing.Point( p.x, p.y );

            addToolStripInPositionOrder( toolStripContainer.TopToolStripPanel, top );
            addToolStripInPositionOrder( toolStripContainer.BottomToolStripPanel, bottom );

            toolStripTool.ParentChanged += new System.EventHandler( this.toolStripEdit_ParentChanged );
            toolStripTool.Move += new System.EventHandler( this.toolStripEdit_Move );
            toolStripMeasure.ParentChanged += new System.EventHandler( this.toolStripMeasure_ParentChanged );
            toolStripMeasure.Move += new System.EventHandler( this.toolStripMeasure_Move );
            toolStripPosition.ParentChanged += new System.EventHandler( this.toolStripPosition_ParentChanged );
            toolStripPosition.Move += new System.EventHandler( this.toolStripPosition_Move );
            toolStripFile.ParentChanged += new EventHandler( toolStripFile_ParentChanged );
            toolStripFile.Move += new EventHandler( toolStripFile_Move );

            AppManager.inputTextBox = new TextBoxEx();
            AppManager.inputTextBox.Visible = false;
            AppManager.inputTextBox.BorderStyle = BorderStyle.None;
            AppManager.inputTextBox.Width = 80;
            AppManager.inputTextBox.setBackground( Color.white );
            AppManager.inputTextBox.AcceptsReturn = true;
            AppManager.inputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 ) );
            AppManager.inputTextBox.Enabled = false;
            AppManager.inputTextBox.KeyPress += m_input_textbox_KeyPress;
            panel1.Controls.Add( AppManager.inputTextBox );
            AppManager.inputTextBox.Parent = pictPianoRoll;

            int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
            timer.Interval = (fps <= 0) ? 1 : fps;
            menuTrackManager.Visible = false;
#if DEBUG
            menuHelpDebug.Visible = true;
#endif

#if !JAVA
            String _HAND = "AAACAAEAICAAABAAEADoAgAAFgAAACgAAAAgAAAAQAAAAAEABAAAAAAAgAIAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAgAAAAACAAACAgAAAAACAAIAAgAAAgIAAwMDAAICAgAD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wD///8AAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAD" +
                "//wAAAAAAAAAAAAAAAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAA" +
                "A//AAAAAP/wAAAAAAAAAAAP/wAAAAD/8AAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAA//8AAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD////////////////////////////////////////////+f////" +
                "D////gf///4H////D///8/z//+H4f//B+D//wfg//+H4f//z/P///w////4H///+B////w////+f//////////////////////////" +
                "//////////////////w==";
            using ( System.IO.MemoryStream ms = new System.IO.MemoryStream( Base64.decode( _HAND ) ) ) {
                HAND = new Cursor( ms );
            }
#endif

            applyShortcut();

            // ファイルを開く
            if ( !file.Equals( "" ) ) {
                if ( PortUtil.isFileExists( file ) ) {
                    String low_file = file.ToLower();
                    if ( low_file.EndsWith( ".xvsq" ) ) {
                        AppManager.readVsq( file );
                    } else if ( low_file.EndsWith( ".vsq" ) ) {
                        VsqFileEx vsq = null;
                        try {
                            vsq = new VsqFileEx( file, "Shift_JIS" );
                            AppManager.setVsqFile( vsq );
                            updateBgmMenuState();
                        } catch ( Exception ex ) {
                            PortUtil.println( "FormMain#.ctor; ex=" + ex );
                        }
                    }
                }
            }
        }

        private void panelOverview_Enter( object sender, EventArgs e ) {
            pictPianoRoll.Focus();
        }

        private void m_strip_ddbtn_metronome_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.MetronomeEnabled = m_strip_ddbtn_metronome.Checked;
            if ( AppManager.editorConfig.MetronomeEnabled && AppManager.getEditMode() == EditMode.REALTIME ) {
                MidiPlayer.RestartMetronome();
            }
        }

        private void commonStripPaletteTool_Clicked( Object sender, BEventArgs e ) {
            String id = "";  //選択されたツールのID
            if ( sender is BToolStripButton ) {
                BToolStripButton tsb = (BToolStripButton)sender;
                if ( tsb.getTag() != null && tsb.getTag() is String ) {
                    id = (String)tsb.getTag();
                    AppManager.selectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsb.setSelected( true );
                }
            } else if ( sender is BMenuItem ) {
                BMenuItem tsmi = (BMenuItem)sender;
                if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                    id = (String)tsmi.getTag();
                    AppManager.selectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsmi.setSelected( true );
                }
            }

            int count = toolStripTool.getComponentCount();
            for ( int i = 0; i < count; i++ ) {
                Object item = toolStripTool.getComponentAt( i );
                if ( item is BToolStripButton ) {
                    BToolStripButton button = (BToolStripButton)item;
                    if ( button.Tag != null && button.Tag is String ) {
                        if ( ((String)button.Tag).Equals( id ) ) {
                            button.Checked = true;
                        } else {
                            button.Checked = false;
                        }
                    }
                }
            }

            MenuElement[] sub_cmenu_piano_palette_tool = cMenuPianoPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_piano_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_piano_palette_tool[i];
                if ( item is BMenuItem ) {
                    BMenuItem menu = (BMenuItem)item;
                    if ( menu.getTag() != null && menu.getTag() is String ) {
                        if ( ((String)menu.getTag()).Equals( id ) ) {
                            menu.setSelected( true );
                        } else {
                            menu.setSelected( false );
                        }
                    }
                }
            }

            MenuElement[] sub_cmenu_track_selectro_palette_tool = cMenuTrackSelectorPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_track_selectro_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_track_selectro_palette_tool[i];
                if ( item is BMenuItem ) {
                    BMenuItem menu = (BMenuItem)item;
                    if ( menu.getTag() != null && menu.getTag() is String ) {
                        if ( ((String)menu.getTag()).Equals( id ) ) {
                            menu.setSelected( true );
                        } else {
                            menu.setSelected( false );
                        }
                    }
                }
            }
        }

        #region AppManager.inputTextBox
        private void m_input_textbox_KeyDown( Object sender, BKeyEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "m_input_textbox_KeyDown" );
            AppManager.debugWriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab || e.KeyCode == Keys.Return ) {
                executeLyricChangeCommand();
                int selected = AppManager.getSelected();
                int index = -1;
                VsqTrack track = AppManager.getVsqFile().Track.get( selected );
                track.sortEvent();
                if ( e.KeyCode == Keys.Tab ) {
                    int clock = 0;
                    for ( int i = 0; i < track.getEventCount(); i++ ) {
                        VsqEvent item = track.getEvent( i );
                        if ( item.InternalID == AppManager.getLastSelectedEvent().original.InternalID ) {
                            index = i;
                            clock = item.Clock;
                            break;
                        }
                    }
                    if ( (e.Modifiers & Keys.Shift) == Keys.Shift ) {
                        // 1個前の音符イベントを検索
                        int tindex = -1;
                        for ( int i = track.getEventCount() - 1; i >= 0; i-- ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock <= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    } else {
                        // 1個後の音符イベントを検索
                        int tindex = -1;
                        for ( int i = 0; i < track.getEventCount(); i++ ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock >= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    }
                }
                if ( 0 <= index && index < track.getEventCount() ) {
                    AppManager.clearSelectedEvent();
                    VsqEvent item = track.getEvent( index );
                    AppManager.addSelectedEvent( item.InternalID );
                    int x = AppManager.xCoordFromClocks( item.Clock );
                    int y = yCoordFromNote( item.ID.Note );
                    boolean phonetic_symbol_edit_mode = ((TagLyricTextBox)AppManager.inputTextBox.Tag).PhoneticSymbolEditMode;
                    showInputTextBox( item.ID.LyricHandle.L0.Phrase,
                                            item.ID.LyricHandle.L0.getPhoneticSymbol(),
                                            new Point( x, y ),
                                            phonetic_symbol_edit_mode );
                    int clWidth = (int)(AppManager.inputTextBox.Width / AppManager.scaleX);
#if DEBUG
                    System.Diagnostics.Debug.WriteLine( "    clWidth=" + clWidth );
#endif
                    // 画面上にAppManager.inputTextBoxが見えるように，移動
                    int SPACE = 20;
                    if ( x < AppManager.keyWidth || pictPianoRoll.Width < x + AppManager.inputTextBox.Width ) {
                        int clock, clock_x;
                        if ( x < AppManager.keyWidth ) {
                            clock = item.Clock;
                            clock_x = AppManager.keyWidth + SPACE;
                        } else {
                            clock = item.Clock + clWidth;
                            clock_x = pictPianoRoll.Width - SPACE;
                        }
                        double draft_d = (73 - clock_x) / AppManager.scaleX + clock;
                        if ( draft_d < 0.0 ) {
                            draft_d = 0.0;
                        }
                        int draft = (int)draft_d;
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        hScroll.Value = draft;
                    } else {
                        refreshScreen();
                    }
                } else {
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( id );
                    hideInputTextBox();
                }
            }
        }

        private void m_input_textbox_KeyUp( Object sender, BKeyEventArgs e ) {
            if ( (e.KeyCode == Keys.Up || e.KeyCode == Keys.Down) && (Control.ModifierKeys == Keys.Alt) ) {
                if ( AppManager.inputTextBox.Enabled ) {
                    flipInputTextBoxMode();
                }
            } else if ( e.KeyCode == Keys.Escape ) {
                hideInputTextBox();
            }
        }

        private void m_input_textbox_ImeModeChanged( Object sender, BEventArgs e ) {
#if DEBUG
            Console.WriteLine( "FormMain#m_input_textbox_ImeModeChanged; imemode=" + AppManager.inputTextBox.ImeMode );
#endif
            m_last_is_imemode_on = AppManager.inputTextBox.isImeModeOn();
        }

        private void m_input_textbox_KeyPress( Object sender, KeyPressEventArgs e ) {
            //           Enter                                  Tab
            e.Handled = (e.KeyChar == Convert.ToChar( 13 )) || (e.KeyChar == Convert.ToChar( 09 ));
        }
        #endregion

        private void m_toolbar_edit_SelectedToolChanged( EditTool tool ) {
            AppManager.setSelectedTool( tool );
        }

        private void m_toolbar_measure_EndMarkerClick( Object sender, BEventArgs e ) {
            AppManager.endMarkerEnabled = !AppManager.endMarkerEnabled;
#if DEBUG
            AppManager.debugWriteLine( "m_toolbar_measure_EndMarkerClick" );
            AppManager.debugWriteLine( "    m_config.EndMarkerEnabled=" + AppManager.endMarkerEnabled );
#endif
            refreshScreen();
        }

        private void m_toolbar_measure_StartMarkerClick( Object sender, BEventArgs e ) {
            AppManager.startMarkerEnabled = !AppManager.startMarkerEnabled;
#if DEBUG
            AppManager.debugWriteLine( "m_toolbar_measure_StartMarkerClick" );
            AppManager.debugWriteLine( "    m_config.StartMarkerEnabled=" + AppManager.startMarkerEnabled );
#endif
            refreshScreen();
        }

        private void itm_Click( Object sender, BEventArgs e ) {
            if ( sender is ToolStripItem ) {
                ToolStripItem item = (ToolStripItem)sender;
                if ( item.Tag is String ) {
                    String filename = (String)item.Tag;
                    openVsqCor( filename );
                    refreshScreen();
                }
            }
        }

        private void itm_MouseEnter( Object sender, BEventArgs e ) {
            if ( sender is ToolStripItem ) {
                ToolStripItem item = (ToolStripItem)sender;
                statusLabel.Text = item.ToolTipText;
            }
        }

        #region AppManager
        private void AppManager_CurrentClockChanged( Object sender, BEventArgs e ) {
            stripLblBeat.Text = AppManager.getPlayPosition().numerator + "/" + AppManager.getPlayPosition().denominator;
            stripLblTempo.Text = (60e6 / (float)AppManager.getPlayPosition().tempo).ToString( "#.00" );
            stripLblCursor.Text = AppManager.getPlayPosition().barCount + " : " + AppManager.getPlayPosition().beat + " : " + AppManager.getPlayPosition().clock.ToString( "000" );
        }

        private void AppManager_GridVisibleChanged( Object sender, BEventArgs e ) {
            menuVisualGridline.Checked = AppManager.isGridVisible();
            stripBtnGrid.Checked = AppManager.isGridVisible();
            cMenuPianoGrid.Checked = AppManager.isGridVisible();
        }

        private void AppManager_PreviewAborted( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "AppManager_PreviewAborted" );
#endif
            timer.Stop();
            PlaySound.exit();

            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                menuJobRealTime.setText( _( "Start Realtime Input" ) );
                AppManager.setEditMode( EditMode.NONE );
            }
#if DEBUG
            PortUtil.println( "  calling VSTiProxy.abortRendering..." );
#endif
            VSTiProxy.abortRendering();
#if DEBUG
            PortUtil.println( "  done" );
#endif
            AppManager.firstBufferWritten = false;
            if ( m_midi_in != null ) {
                m_midi_in.Stop();
            }

            for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                AppManager.drawStartIndex[i] = 0;
            }
            MidiPlayer.Stop();
        }

        private void AppManager_PreviewStarted( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "m_config_PreviewStarted" );
#endif
            PlaySound.prepare( VSTiProxy.SAMPLE_RATE );

            VsqFileEx vsq = AppManager.getVsqFile();
            String renderer = vsq.Track.get( AppManager.getSelected() ).getCommon().Version;
            int clock = AppManager.getCurrentClock();
            m_direct_play_shift = (float)vsq.getSecFromClock( clock );
            if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                int selected = AppManager.getSelected();
                String tmppath = AppManager.getTempWaveDir();

                double amp_master = VocaloSysUtil.getAmplifyCoeffFromFeder( vsq.Mixer.MasterFeder );
                double pan_left_master = VocaloSysUtil.getAmplifyCoeffFromPanLeft( vsq.Mixer.MasterPanpot );
                double pan_right_master = VocaloSysUtil.getAmplifyCoeffFromPanRight( vsq.Mixer.MasterPanpot );

                // 選択されたトラック以外のレンダリングを行う
                Vector<Integer> render_all = new Vector<Integer>();
                int track_count = vsq.Track.size();
                for ( int track = 1; track < track_count; track++ ) {
                    if ( track == selected || !(vsq.Track.get( track ).getCommon().PlayMode >= 0) ) {
                        continue;
                    }
                    String file = PortUtil.combinePath( tmppath, track + ".wav" );
                    if ( !PortUtil.isFileExists( file ) ) {
                        render_all.add( track );
                    }
                }
                if ( render_all.size() > 0 ) {
                    render( render_all.toArray( new Integer[] { } ) );
                }

                Vector<WaveReader> sounds = new Vector<WaveReader>();
                track_count = vsq.Track.size();
                for ( int track = 1; track < track_count; track++ ) {
                    VsqTrack vsq_track = vsq.Track.get( track );
                    if ( track == selected || !(vsq_track.getCommon().PlayMode >= 0) ) {
                        continue;
                    }

                    String file = PortUtil.combinePath( tmppath, track + ".wav" );
                    String tmpfile = PortUtil.combinePath( tmppath, "temp.wav" );
                    int t_start = vsq_track.getEditedStart();
                    int t_end = vsq_track.getEditedEnd();
                    int start = t_start;
                    int end = t_end;

                    // 編集が施された範囲に存在している音符を探し、（音符の末尾と次の音符の先頭の接続を無視した場合の）最長一致範囲を決める
                    int index_start = -1; //startから始まっている音符のインデックス
                    int event_count = vsq_track.getEventCount();
                    for ( int i = 0; i < event_count; i++ ) {
                        VsqEvent item = vsq_track.getEvent( i );
                        if ( item.Clock <= t_start && t_start <= item.Clock + item.ID.Length ) {
                            start = item.Clock;
                            index_start = i;
                            break;
                        }
                    }
                    int index_end = -1;
                    for ( int i = event_count - 1; i >= 0; i-- ) {
                        VsqEvent item = vsq_track.getEvent( i );
                        if ( item.Clock <= t_end && t_end <= item.Clock + item.ID.Length ) {
                            end = item.Clock + item.ID.Length;
                            index_end = i;
                            break;
                        }
                    }

                    // 音符の末尾と次の音符の先頭がつながっている場合、レンダリング範囲を広げる
                    if ( index_start >= 0 ) {
                        for ( int i = index_start - 1; i >= 0; i-- ) {
                            VsqEvent ve = vsq_track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int endpoint = ve.Clock + ve.ID.Length;
                                if ( endpoint == start ) {
                                    start = ve.Clock;
                                    index_start = i;
                                } else if ( endpoint < start ) {
                                    break;
                                }
                            }
                        }
                    }
                    if ( index_end >= 0 ) {
                        for ( int i = index_end + 1; i < event_count; i++ ) {
                            VsqEvent ve = vsq_track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote ) {
                                int startpoint = ve.Clock;
                                if ( end == ve.Clock ) {
                                    end = ve.Clock + ve.ID.Length;
                                    index_end = i;
                                } else if ( end < startpoint ) {
                                    break;
                                }
                            }
                        }
                    }

                    if ( start < end ) {
#if DEBUG
                        AppManager.debugWriteLine( "    partial rendering!" );
#endif
                        int temp_premeasure = AppManager.getVsqFile().getPresendClockAt( start, AppManager.editorConfig.PreSendTime ) * 2;
                        boolean successed = false;
                        FormSynthesize dlg = null;
                        try {
                            dlg = new FormSynthesize( vsq,
                                                      AppManager.editorConfig.PreSendTime,
                                                      track,
                                                      tmpfile,
                                                      start,
                                                      end,
                                                      temp_premeasure,
                                                      false );
                            if ( dlg.showDialog() == BDialogResult.OK ) {
                                successed = true;
                            }
                        } catch ( Exception ex ) {
                        } finally {
                            if ( dlg != null ) {
                                try {
#if !JAVA
                                    dlg.Dispose();
#endif
                                } catch ( Exception ex2 ) {
                                }
                            }
                        }
                        if ( successed ) {
                            vsq_track.resetEditedArea();
                            Wave main = null;
                            Wave temp = null;
                            try {
                                main = new Wave( file );
                                temp = new Wave( tmpfile );
                                double sec_start = vsq.getSecFromClock( start );
                                double sec_end = vsq.getSecFromClock( end );

                                main.replace( temp,
                                              0,
                                              (int)(sec_start * main.getSampleRate()),
                                              (int)((sec_end - sec_start) * temp.getSampleRate()) );
                                main.write( file );
                            } catch ( Exception ex ) {
                            } finally {
                                if ( main != null ) {
                                    try {
#if !JAVA
                                        main.Dispose();
#endif
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                                if ( temp != null ) {
                                    try {
#if !JAVA
                                        temp.Dispose();
#endif
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                    }

                    WaveReader wr = new WaveReader( file );
                    wr.Tag = track;
                    sounds.add( wr );
                }

                // リアルタイム再生用のデータを準備
                m_preview_ending_time = vsq.getSecFromClock( AppManager.getVsqFile().TotalClocks ) + 1.0;

                // clock以降に音符があるかどうかを調べる
                int count = 0;
                for ( Iterator<VsqEvent> itr = vsq.Track.get( AppManager.getSelected() ).getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = itr.next();
                    if ( ve.Clock >= clock ) {
                        count++;
                        break;
                    }
                }

                int bgm_count = AppManager.getBgmCount();
                double pre_measure_sec = vsq.getSecFromClock( vsq.getPreMeasureClocks() );
                for ( int i = 0; i < bgm_count; i++ ) {
                    BgmFile bgm = AppManager.getBgm( i );
                    WaveReader wr = new WaveReader( bgm.file );
                    wr.Tag = (int)(-i - 1);
                    double offset = bgm.readOffsetSeconds;
                    if ( bgm.startAfterPremeasure ) {
                        offset -= pre_measure_sec;
                    }
                    wr.OffsetSeconds = offset;
                    sounds.add( wr );
                }

                boolean mode_infinite = AppManager.getEditMode() == EditMode.REALTIME;
                if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().PlayMode >= 0 && count > 0 ) {
                    int ms_presend = AppManager.editorConfig.PreSendTime;
                    if ( renderer.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                        ms_presend = 0;
                    }
#if DEBUG
                    PortUtil.println( "FormMain#AppManager_PreviewStarted; m_direct_play_shift=" + m_direct_play_shift );
                    PortUtil.println( "FormMain#AppManager_PreviewStarted; m_preview_ending_time=" + m_preview_ending_time );
#endif
                    VSTiProxy.render( AppManager.getVsqFile(),
                                      selected,
                                      null,
                                      m_direct_play_shift,
                                      m_preview_ending_time,
                                      ms_presend,
                                      true,
                                      sounds.toArray( new WaveReader[] { } ),
                                      m_direct_play_shift,
                                      mode_infinite,
                                      AppManager.getTempWaveDir(),
                                      false );

                    for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                        AppManager.drawStartIndex[i] = 0;
                    }
                    int clock_now = AppManager.getCurrentClock();
                    double sec_now = AppManager.getVsqFile().getSecFromClock( clock_now );
                } else {
                    VSTiProxy.render( new VsqFileEx( "Miku", AppManager.getVsqFile().getPreMeasure(), 4, 4, 500000 ),
                                      1,
                                      null,
                                      0,
                                      m_preview_ending_time,
                                      AppManager.editorConfig.PreSendTime,
                                      true,
                                      sounds.toArray( new WaveReader[] { } ),
                                      m_direct_play_shift,
                                      mode_infinite,
                                      AppManager.getTempWaveDir(),
                                      false );
                }
            }

            double now = PortUtil.getCurrentTime();
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                menuJobRealTime.setText( _( "Stop Realtime Input" ) );
                if ( m_midi_in != null ) {
                    m_midi_in.Start();
                }
                AppManager.rendererAvailable = false;
                MidiPlayer.SetSpeed( AppManager.editorConfig.RealtimeInputSpeed, now );
                MidiPlayer.Start( AppManager.getVsqFile(), clock, now );
            } else {
                AppManager.rendererAvailable = VSTiProxy.isRendererAvailable( renderer );
            }
            AppManager.firstBufferWritten = true;
            AppManager.previewStartedTime = now;
#if DEBUG
            AppManager.debugWriteLine( "    m_config.VsqFile.TotalClocks=" + AppManager.getVsqFile().TotalClocks );
            AppManager.debugWriteLine( "    total seconds=" + AppManager.getVsqFile().getSecFromClock( (int)AppManager.getVsqFile().TotalClocks ) );
#endif
            timer.Enabled = true;
        }

        private void AppManager_SelectedToolChanged( Object sender, BEventArgs e ) {
            applySelectedTool();
        }

        private void AppManager_SelectedEventChanged( Object sender, boolean selected_event_is_null ) {
            menuEditCut.Enabled = !selected_event_is_null;
            menuEditPaste.Enabled = !selected_event_is_null;
            menuEditDelete.Enabled = !selected_event_is_null;
            cMenuPianoCut.Enabled = !selected_event_is_null;
            cMenuPianoCopy.Enabled = !selected_event_is_null;
            cMenuPianoDelete.Enabled = !selected_event_is_null;
            cMenuPianoExpressionProperty.Enabled = !selected_event_is_null;
            menuLyricVibratoProperty.Enabled = !selected_event_is_null;
            menuLyricExpressionProperty.Enabled = !selected_event_is_null;
            stripBtnCut.Enabled = !selected_event_is_null;
            stripBtnCopy.Enabled = !selected_event_is_null;
        }
        #endregion

        #region pictPianoRoll
        private void pictPianoRoll_KeyUp( object sender, KeyEventArgs e ) {
            processSpecialShortcutKey( e, false );
        }

        private void pictPianoRoll_MouseClick( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseClick" );
#endif
            int modefier = PortUtil.getModifierFromKeys( Control.ModifierKeys );
            EditMode edit_mode = AppManager.getEditMode();

            if ( e.Button == BMouseButtons.Left ) {
                if ( m_mouse_hover_thread != null ) {
                    m_mouse_hover_thread.Abort();
                }

                // クリック位置にIDが無いかどうかを検査
                ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>( new Rectangle() );
                VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                Rectangle id_rect = out_id_rect.value;
#if DEBUG
                AppManager.debugWriteLine( "    (item==null)=" + (item == null) );
#endif
                if ( item != null &&
                     edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                     edit_mode != EditMode.EDIT_LEFT_EDGE &&
                     edit_mode != EditMode.EDIT_RIGHT_EDGE &&
                     edit_mode != EditMode.MIDDLE_DRAG ) {
                    if ( (modefier & InputEvent.SHIFT_MASK) != InputEvent.SHIFT_MASK && (modefier & s_modifier_key) != s_modifier_key ) {
                        AppManager.clearSelectedEvent();
                    }
                    AppManager.addSelectedEvent( item.InternalID );
                    int selected = AppManager.getSelected();
                    int internal_id = item.InternalID;
                    hideInputTextBox();
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventDelete( selected, internal_id ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                        AppManager.clearSelectedEvent();
                        return;
                    } else if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                        Vector<Integer> internal_ids = new Vector<Integer>();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry see = itr.next();
                            internal_ids.add( see.original.InternalID );
                        }
                        BMouseButtons btn = e.Button;
                        if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == MouseButtons.Left ) {
                            btn = BMouseButtons.Middle;
                        }
                        boolean result = PaletteToolServer.InvokePaletteTool( AppManager.selectedPaletteTool,
                                                                           AppManager.getSelected(),
                                                                           internal_ids.toArray( new Integer[] { } ),
                                                                           btn );
                        if ( result ) {
                            setEdited( true );
                            AppManager.clearSelectedEvent();
                            return;
                        }
                    }
                } else {
                    if ( edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                         edit_mode != EditMode.EDIT_LEFT_EDGE &&
                         edit_mode != EditMode.EDIT_RIGHT_EDGE ) {
                        if ( !AppManager.isPointerDowned ) {
                            AppManager.clearSelectedEvent();
                        }
                        hideInputTextBox();
                    }
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        // マウス位置にビブラートの波波があったら削除する
                        int stdx = AppManager.startToDrawX;
                        int stdy = getStartToDrawY();
#if USE_DOBJ
                        for ( int i = 0; i < AppManager.drawObjects.get( AppManager.getSelected() - 1 ).size(); i++ ) {
                            DrawObject dobj = AppManager.drawObjects.get( AppManager.getSelected() - 1 ).get( i );
                            if ( dobj.pxRectangle.x + AppManager.startToDrawX + dobj.pxRectangle.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.x + AppManager.keyWidth - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxVibratoDelay - stdx,
                                                          dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                          dobj.pxRectangle.width - dobj.pxVibratoDelay,
                                                          AppManager.editorConfig.PxTrackHeight );
#else
                        VsqTrack vsq_track = AppManager.VsqFile.getTrack( AppManager.Selected );
                        float scalex = AppManager.ScaleX;
                        for( Iterator itr0 = vsq_track.getNoteEventIterator(); itr0.hasNext();){
                            VsqEvent evnt = (VsqEvent)itr0.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length);
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                            Rectangle rc = new Rectangle( vib_sx,
                                                          YCoordFromNote( evnt.ID.Note, stdy ),
                                                          event_ex - vib_sx,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                //ビブラートの範囲なのでビブラートを消す
                                VsqID item2 = null;
                                int internal_id = -1;
#if USE_DOBJ
                                internal_id = dobj.internalID;
                                for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    if ( ve.InternalID == dobj.internalID ) {
                                        item2 = (VsqID)ve.ID.clone();
                                        break;
                                    }
                                }
#else
                                item2 = evnt.ID;
                                internal_id = evnt.InternalID;
#endif
                                if ( item2 != null ) {
                                    item2.VibratoHandle = null;
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(),
                                                                                          internal_id,
                                                                                          item2 ) );
                                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                    setEdited( true );
                                }
                                break;
                            }
                        }
                    }
                }
            } else if ( e.Button == BMouseButtons.Right ) {
                boolean show_context_menu = (e.X > AppManager.keyWidth);
                if ( m_mouse_hover_thread != null ) {
                    if ( !m_mouse_hover_thread.IsAlive && AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                } else {
                    if ( AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                }
                show_context_menu = show_context_menu && !m_mouse_moved;
                if ( show_context_menu ) {
                    if ( m_mouse_hover_thread != null ) {
                        m_mouse_hover_thread.Abort();
                    }
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        if ( !AppManager.isSelectedEventContains( AppManager.getSelected(), item.InternalID ) ) {
                            AppManager.clearSelectedEvent();
                        }
                        AppManager.addSelectedEvent( item.InternalID );
                    }
                    boolean item_is_null = (item == null);
                    cMenuPianoCopy.Enabled = !item_is_null;
                    cMenuPianoCut.Enabled = !item_is_null;
                    cMenuPianoDelete.Enabled = !item_is_null;
                    cMenuPianoImportLyric.Enabled = !item_is_null;
                    cMenuPianoExpressionProperty.Enabled = !item_is_null;

                    int clock = AppManager.clockFromXCoord( e.X );
                    cMenuPianoPaste.Enabled = ((AppManager.getCopiedItems().events.size() != 0) && (clock >= AppManager.getVsqFile().getPreMeasureClocks()));
                    refreshScreen();

                    m_cMenuOpenedPosition = new Point( e.X, e.Y );
                    cMenuPiano.Show( pictPianoRoll, e.Location );
                } else {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( m_button_initial, out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
#if DEBUG
                    AppManager.debugWriteLine( "pitcPianoRoll_MouseClick; button is right; (item==null)=" + (item == null) );
#endif
                    if ( item != null ) {
                        int itemx = AppManager.xCoordFromClocks( item.Clock );
                        int itemy = yCoordFromNote( item.ID.Note );
                    }
                }
            } else if ( e.Button == BMouseButtons.Middle ) {
                if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                            AppManager.clearSelectedEvent();
                            AppManager.addSelectedEvent( item.InternalID );
                            Vector<Integer> internal_ids = new Vector<Integer>();
                            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                                SelectedEventEntry see = itr.next();
                                internal_ids.add( see.original.InternalID );
                            }
                            boolean result = PaletteToolServer.InvokePaletteTool( AppManager.selectedPaletteTool,
                                                                               AppManager.getSelected(),
                                                                               internal_ids.toArray( new Integer[] { } ),
                                                                               e.Button );
                            if ( result ) {
                                setEdited( true );
                                AppManager.clearSelectedEvent();
                                return;
                            }
                        }
                    }
                }
            }
        }

        private void pictPianoRoll_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictureBox1_MouseDoubleClick" );
#endif
            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;
            if ( item != null ) {
                if ( AppManager.getSelectedTool() != EditTool.PALETTE_TOOL ) {
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( item.InternalID );
                    m_mouse_hover_thread.Abort();
                    if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                        m_last_symbol_edit_mode = false;
                    }
                    showInputTextBox( item.ID.LyricHandle.L0.Phrase, item.ID.LyricHandle.L0.getPhoneticSymbol(), new Point( rect.x, rect.y ), m_last_symbol_edit_mode );
                    refreshScreen();
                    return;
                }
            } else {
                AppManager.clearSelectedEvent();
                hideInputTextBox();
                if ( AppManager.editorConfig.ShowExpLine && AppManager.keyWidth <= e.X ) {
                    int stdx = AppManager.startToDrawX;
                    int stdy = getStartToDrawY();
#if USE_DOBJ
                    for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( AppManager.getSelected() - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        // 表情コントロールプロパティを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                            dobj.pxRectangle.y - stdy + AppManager.editorConfig.PxTrackHeight,
                            21,
                            AppManager.editorConfig.PxTrackHeight );
#else
                    for( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay);
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );
                        rect = new Rectangle( event_sx, event_sy, 21, AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator<VsqEvent> itr2 = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.internalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormNoteExpressionConfig dlg = null;
                                try {
                                    dlg = new FormNoteExpressionConfig( type, selected.ID.NoteHeadHandle );
                                    dlg.PMBendDepth = selected.ID.PMBendDepth;
                                    dlg.PMBendLength = selected.ID.PMBendLength;
                                    dlg.PMbPortamentoUse = selected.ID.PMbPortamentoUse;
                                    dlg.DEMdecGainRate = selected.ID.DEMdecGainRate;
                                    dlg.DEMaccent = selected.ID.DEMaccent;
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID id = (VsqID)selected.ID.clone();
                                        id.PMBendDepth = dlg.PMBendDepth;
                                        id.PMBendLength = dlg.PMBendLength;
                                        id.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                        id.DEMdecGainRate = dlg.DEMdecGainRate;
                                        id.DEMaccent = dlg.DEMaccent;
                                        id.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(), selected.InternalID, id ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                } finally {
                                    if ( dlg != null ) {
                                        try {
#if !JAVA
                                            dlg.Dispose();
#endif
                                        } catch ( Exception ex2 ) {
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                        // ビブラートプロパティダイアログを表示するかどうかを決める
#if USE_DOBJ
                        rect = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth - stdx + 21,
                                              dobj.pxRectangle.y - stdy + AppManager.editorConfig.PxTrackHeight,
                                              dobj.pxRectangle.width - 21,
                                              AppManager.editorConfig.PxTrackHeight );
#else
                        if ( evnt.ID.VibratoHandle == null ){
                            continue;
                        }
                        rect = new Rectangle( event_sx + 21, 
                                              event_sy + AppManager.EditorConfig.PxTrackHeight,
                                              event_ex - event_sx - 21,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selected = null;
#if USE_DOBJ
                            for ( Iterator<VsqEvent> itr2 = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.internalID ) {
                                    selected = ev;
                                    break;
                                }
                            }
#else
                            selected = evnt;
#endif
                            if ( selected != null ) {
                                if ( m_mouse_hover_thread != null ) {
                                    m_mouse_hover_thread.Abort();
                                }
                                SynthesizerType type = SynthesizerType.VOCALOID2;
#if DEBUG
                                PortUtil.println( "FormMain#pictPianoRoll_MouseDoubleClick; version=" + AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version );
#endif
                                if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormVibratoConfig dlg = null;
                                try {
                                    dlg = new FormVibratoConfig( selected.ID.VibratoHandle, selected.ID.Length, AppManager.editorConfig.DefaultVibratoLength, type );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                                        VsqID t = (VsqID)selected.ID.clone();
                                        t.VibratoHandle = dlg.VibratoHandle;
                                        if ( t.VibratoHandle != null ) {
                                            int vibrato_length = t.VibratoHandle.Length;
                                            int note_length = selected.ID.Length;
                                            t.VibratoDelay = note_length - vibrato_length;
                                            //t.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                                            //t.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                                        }
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(),
                                                                                    selected.InternalID,
                                                                                    t ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                } finally {
                                    if ( dlg != null ) {
                                        try {
#if !JAVA
                                            dlg.Dispose();
#endif
                                        } catch ( Exception ex2 ) {
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                    }
                }
            }

            // 必要な操作が何も無ければ，クリック位置にソングポジションを移動
            if ( e.Button == BMouseButtons.Left && AppManager.keyWidth < e.X ) {
                int unit = AppManager.getPositionQuantizeClock();
                int clock = AppManager.clockFromXCoord( e.X );
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                AppManager.setCurrentClock( clock );
            }
        }

        private void pictPianoRoll_MouseDown( Object sender, BMouseEventArgs e0 ) {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseDown" );
#endif
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                return;
            }

            BMouseButtons btn0 = e0.Button;
            if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e0.Button == MouseButtons.Left ){
                btn0 = MouseButtons.Middle;
            }
            BMouseEventArgs e = new MouseEventArgs( btn0, e0.Clicks, e0.X, e0.Y, e0.Delta );

            m_mouse_moved = false;
            if ( !AppManager.isPlaying() && 0 <= e.X && e.X <= AppManager.keyWidth ) {
                int note = noteFromYCoord( e.Y );
                if ( 0 <= note && note <= 126 ) {
                    if ( e.Button == BMouseButtons.Left ) {
                        KeySoundPlayer.Play( note );
                    }
                    return;
                }
            }

            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            /*if ( e.Button == BMouseButtons.Left ) {
                AppManager.selectedRegionEnabled = false;
            }*/

            m_mouse_downed = true;
            m_button_initial = new Point( e.X, e.Y );
            int modefier = PortUtil.getModifierFromKeys( Control.ModifierKeys );
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            EditTool selected_tool = AppManager.getSelectedTool();
            if ( selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Middle ) {
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                m_middle_button_vscroll = vScroll.Value;
                m_middle_button_hscroll = hScroll.Value;
                return;
            }

            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;

            if ( selected_tool == EditTool.PALETTE_TOOL && item == null && e.Button == MouseButtons.Middle ) {
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                m_middle_button_vscroll = vScroll.Value;
                m_middle_button_hscroll = hScroll.Value;
                return;
            }

            int selected_track = AppManager.getSelected();

            // マウス位置にある音符を検索
            if ( item == null ) {
                if ( e.Button == BMouseButtons.Left ) {
                    AppManager.setWholeSelectedIntervalEnabled( false );
                }
                #region 音符がなかった時
#if DEBUG
                AppManager.debugWriteLine( "    No Event" );
#endif
                if ( AppManager.getLastSelectedEvent() != null ) {
                    executeLyricChangeCommand();
                }
                boolean start_mouse_hover_generator = true;

                // CTRLキーを押しながら範囲選択
                if ( (modefier & s_modifier_key) == s_modifier_key ) {
                    AppManager.setWholeSelectedIntervalEnabled( true );
                    AppManager.setCurveSelectedIntervalEnabled( false );
                    AppManager.clearSelectedPoint();
                    int stdx = AppManager.startToDrawX;
                    int startClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        int odd = startClock % unit;
                        int nclock = startClock;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        startClock = nclock;
                    }
                    AppManager.wholeSelectedInterval = new SelectedRegion( startClock );
                    AppManager.wholeSelectedInterval.SetEnd( startClock );
                    AppManager.isPointerDowned = true;
                } else {
                    boolean vibrato_found = false;
                    if ( selected_tool == EditTool.LINE || selected_tool == EditTool.PENCIL ) {
                        // ビブラート範囲の編集
                        int px_vibrato_length = 0;
                        int stdx = AppManager.startToDrawX;
                        int stdy = getStartToDrawY();
                        m_vibrato_editing_id = -1;
#if USE_DOBJ
                        Rectangle pxFound = new Rectangle();
                        Vector<DrawObject> target_list = AppManager.drawObjects.get( selected_track - 1 );
                        int count = target_list.size();
                        for ( int i = 0; i < count; i++ ) {
                            DrawObject dobj = target_list.get( i );
                            if ( dobj.pxRectangle.width <= dobj.pxVibratoDelay ) {
                                continue;
                            }
                            if ( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.Width < dobj.pxRectangle.x + AppManager.keyWidth - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.editorConfig.PxTrackHeight );
#else
                        int clock = 0;
                        int note = 0;
                        int length = 0;
                        for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                            VsqEvent evnt = (VsqEvent)itr.next();
                            if ( evnt.ID.VibratoHandle == null ){
                                continue;
                            }
                            int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                            if ( event_ex < 0 ) {
                                continue;
                            }
                            int event_sx = XCoordFromClocks( evnt.Clock );
                            if ( pictPianoRoll.Width < event_sx ) {
                                break;
                            }
                            int vib_sx = XCoordFromClocks( evnt.Clock + evnt.ID.VibratoDelay );
                            Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2,
                                                          YCoordFromNote( evnt.ID.Note ) + AppManager.EditorConfig.PxTrackHeight,
                                                          _EDIT_HANDLE_WIDTH,
                                                          AppManager.EditorConfig.PxTrackHeight );
#endif
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                vibrato_found = true;
#if USE_DOBJ
                                m_vibrato_editing_id = dobj.internalID;
                                pxFound = dobj.pxRectangle;
                                pxFound.x += AppManager.keyWidth;
                                px_vibrato_length = dobj.pxRectangle.width - dobj.pxVibratoDelay;
#else
                                m_vibrato_editing_id = evnt.InternalID;
                                clock = evnt.Clock + evnt.ID.VibratoDelay;
                                note = evnt.ID.Note - 1;
                                length = evnt.ID.Length;
                                px_vibrato_length = event_ex - vib_sx;
#endif
                                break;
                            }
                        }
                        if ( vibrato_found ) {
#if USE_DOBJ
                            int clock = AppManager.clockFromXCoord( pxFound.x + pxFound.width - px_vibrato_length - stdx );
                            int note = noteFromYCoord( pxFound.y + AppManager.editorConfig.PxTrackHeight - stdy );
                            int length = (int)(pxFound.width / AppManager.scaleX);
#endif
                            AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Note = note;
                            AppManager.addingEvent.ID.Length = (int)(px_vibrato_length / AppManager.scaleX);
                            AppManager.addingEventLength = length;
                            AppManager.addingEvent.ID.VibratoDelay = length - (int)(px_vibrato_length / AppManager.scaleX);
                            AppManager.setEditMode( EditMode.EDIT_VIBRATO_DELAY );
                            start_mouse_hover_generator = false;
                        }
                    }
                    if ( !vibrato_found ) {
                        if ( (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE) &&
                            e.Button == BMouseButtons.Left &&
                            e.X >= AppManager.keyWidth ) {
                            int clock = AppManager.clockFromXCoord( e.X );
                            if ( AppManager.getVsqFile().getPreMeasureClocks() - AppManager.editorConfig.PxTolerance / AppManager.scaleX <= clock ) {
                                //10ピクセルまでは許容範囲
                                if ( AppManager.getVsqFile().getPreMeasureClocks() > clock ) { //だけど矯正するよ。
                                    clock = AppManager.getVsqFile().getPreMeasureClocks();
                                }
                                int note = noteFromYCoord( e.Y );
                                AppManager.clearSelectedEvent();
                                int unit = AppManager.getPositionQuantizeClock();
                                int odd = clock % unit;
                                int new_clock = clock - odd;
                                if ( odd > unit / 2 ) {
                                    new_clock += unit;
                                }
                                AppManager.addingEvent = new VsqEvent( new_clock, new VsqID( 0 ) );
                                AppManager.addingEvent.ID.PMBendDepth = AppManager.editorConfig.DefaultPMBendDepth;
                                AppManager.addingEvent.ID.PMBendLength = AppManager.editorConfig.DefaultPMBendLength;
                                AppManager.addingEvent.ID.PMbPortamentoUse = AppManager.editorConfig.DefaultPMbPortamentoUse;
                                AppManager.addingEvent.ID.DEMdecGainRate = AppManager.editorConfig.DefaultDEMdecGainRate;
                                AppManager.addingEvent.ID.DEMaccent = AppManager.editorConfig.DefaultDEMaccent;
                                if ( m_pencil_mode.getMode() == PencilModeEnum.Off ) {
                                    AppManager.setEditMode( EditMode.ADD_ENTRY );
                                    m_button_initial = new Point( e.X, e.Y );
                                    AppManager.addingEvent.ID.Length = 0;
                                    AppManager.addingEvent.ID.Note = note;
                                    Cursor = Cursors.Arrow;
#if DEBUG
                                    AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                                } else {
                                    AppManager.setEditMode( EditMode.ADD_FIXED_LENGTH_ENTRY );
                                    AppManager.addingEvent.ID.Length = m_pencil_mode.getUnitLength();
                                    AppManager.addingEvent.ID.Note = note;
                                    Cursor = Cursors.Arrow;
                                }
                            } else {
                                SystemSounds.Asterisk.Play();
                            }
                        } else if ( (selected_tool == EditTool.ARROW || selected_tool == EditTool.PALETTE_TOOL) && e.Button == BMouseButtons.Left ) {
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.clearSelectedEvent();
                            AppManager.mouseDownLocation = new Point( e.X + AppManager.startToDrawX, e.Y + getStartToDrawY() );
                            AppManager.isPointerDowned = true;
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                        }
                    }
                }
                if ( e.Button == BMouseButtons.Right && !AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                    start_mouse_hover_generator = false;
                }
                if ( start_mouse_hover_generator ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( noteFromYCoord( e.Y ) );
                }
                #endregion
            } else {
                #region 音符があった時
#if DEBUG
                AppManager.debugWriteLine( "    Event Found" );
#endif
                if ( AppManager.isSelectedEventContains( AppManager.getSelected(), item.InternalID ) ) {
                    executeLyricChangeCommand();
                }
                hideInputTextBox();
                if ( selected_tool != EditTool.ERASER ) {
                    m_mouse_hover_thread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    m_mouse_hover_thread.Start( item.ID.Note );
                }
                // まず、両端の編集モードに移行可能かどうか調べる
                if ( selected_tool != EditTool.ERASER && selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Left ) {
                    int stdx = AppManager.startToDrawX;
                    int stdy = getStartToDrawY();
                    int min_width = 4 * _EDIT_HANDLE_WIDTH;
#if USE_DOBJ
                    for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( selected_track - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();

                        int edit_handle_width = _EDIT_HANDLE_WIDTH;
                        if ( dobj.pxRectangle.width < min_width ) {
                            edit_handle_width = dobj.pxRectangle.width / 4;
                        }
                        Rectangle rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth - stdx, dobj.pxRectangle.y - stdy, edit_handle_width, dobj.pxRectangle.height );
#else
                    for( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int event_ex = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        if ( event_ex < 0 ) {
                            continue;
                        }
                        int event_sx = XCoordFromClocks( evnt.Clock );
                        if ( pictPianoRoll.Width < event_sx ) {
                            break;
                        }
                        int event_sy = YCoordFromNote( evnt.ID.Note, stdy );

                        // 左端
                        Rectangle rc = new Rectangle( event_sx - _EDIT_HANDLE_WIDTH / 2, 
                                                      event_sy,
                                                      _EDIT_HANDLE_WIDTH,
                                                      AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.setEditMode( EditMode.EDIT_LEFT_EDGE );
                            if ( !AppManager.isSelectedEventContains( selected_track, item.InternalID ) ) {
                                AppManager.clearSelectedEvent();
                            }
                            AppManager.addSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            refreshScreen();
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                            return;
                        }
#if USE_DOBJ
                        rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width - stdx - edit_handle_width,
                                            dobj.pxRectangle.y - stdy,
                                            edit_handle_width,
                                            dobj.pxRectangle.height );
#else
                        rect = new Rectangle( event_ex - _EDIT_HANDLE_WIDTH / 2,
                                              event_sy,
                                              _EDIT_HANDLE_WIDTH,
                                              AppManager.EditorConfig.PxTrackHeight );
#endif
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.setEditMode( EditMode.EDIT_RIGHT_EDGE );
                            if ( !AppManager.isSelectedEventContains( selected_track, item.InternalID ) ) {
                                AppManager.clearSelectedEvent();
                            }
                            AppManager.addSelectedEvent( item.InternalID );
                            this.Cursor = Cursors.VSplit;
                            refreshScreen();
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                            return;
                        }
                    }
                }
                if ( e.Button == BMouseButtons.Left || e.Button == BMouseButtons.Middle ) {
                    if ( selected_tool == EditTool.PALETTE_TOOL ) {
                        AppManager.setWholeSelectedIntervalEnabled( false );
                        AppManager.setEditMode( EditMode.NONE );
                        AppManager.clearSelectedEvent();
                        AppManager.addSelectedEvent( item.InternalID );
                    } else if ( selected_tool != EditTool.ERASER ) {
                        m_mouse_move_init = new Point( e.X + AppManager.startToDrawX, e.Y + getStartToDrawY() );
                        int head_x = AppManager.xCoordFromClocks( item.Clock );
                        m_mouse_move_offset = e.X - head_x;
                        if ( (modefier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            // 範囲選択
                            int last_id = AppManager.getLastSelectedEvent().original.InternalID;
                            int last_clock = 0;
                            int this_clock = 0;
                            boolean this_found = false, last_found = false;
                            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected_track ).getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = itr.next();
                                if ( ev.InternalID == last_id ) {
                                    last_clock = ev.Clock;
                                    last_found = true;
                                } else if ( ev.InternalID == item.InternalID ) {
                                    this_clock = ev.Clock;
                                    this_found = true;
                                }
                                if ( last_found && this_found ) {
                                    break;
                                }
                            }
                            int start = Math.Min( last_clock, this_clock );
                            int end = Math.Max( last_clock, this_clock );
                            Vector<Integer> add_required = new Vector<Integer>();
                            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected_track ).getEventIterator(); itr.hasNext(); ) {
                                VsqEvent ev = itr.next();
                                if ( start <= ev.Clock && ev.Clock <= end ) {
                                    if ( !add_required.contains( ev.InternalID ) ) {
                                        add_required.add( ev.InternalID );
                                    }
                                }
                            }
                            if ( !add_required.contains( item.InternalID ) ) {
                                add_required.add( item.InternalID );
                            }
                            AppManager.addSelectedEventAll( add_required.toArray( new Integer[] { } ) );
                        } else if ( (modefier & s_modifier_key) == s_modifier_key ) {
                            // CTRLキーを押しながら選択／選択解除
                            if ( AppManager.isSelectedEventContains( selected_track, item.InternalID ) ) {
                                AppManager.removeSelectedEvent( item.InternalID );
                            } else {
                                AppManager.addSelectedEvent( item.InternalID );
                            }
                        } else {
                            if ( !AppManager.isSelectedEventContains( selected_track, item.InternalID ) ) {
                                // MouseDownしたアイテムが、まだ選択されていなかった場合。当該アイテム単独に選択しなおす
                                AppManager.clearSelectedEvent();
                            }
                            AppManager.addSelectedEvent( item.InternalID );
                        }

                        // 範囲選択モードで、かつマウス位置の音符がその範囲に入っていた場合にのみ、MOVE_ENTRY_WHOLE_WAIT_MOVEに移行
                        if ( AppManager.isWholeSelectedIntervalEnabled() &&
                             AppManager.wholeSelectedInterval.Start <= item.Clock && item.Clock <= AppManager.wholeSelectedInterval.End ) {
                            AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE );
                            AppManager.wholeSelectedIntervalStartForMoving = AppManager.wholeSelectedInterval.Start;
                        } else {
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.setEditMode( EditMode.MOVE_ENTRY_WAIT_MOVE );
                        }

                        this.Cursor = Cursors.Hand;
#if DEBUG
                        AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
                        AppManager.debugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.getSelectedEventCount() );
#endif
                    }
                }
                #endregion
            }
            refreshScreen();
        }

        private void pictPianoRoll_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_form_activated ) {
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.Visible && !AppManager.propertyPanel.Editing ) {
                    pictPianoRoll.Focus();
                }
            }
            EditMode edit_mode = AppManager.getEditMode();
            if ( !m_mouse_moved && edit_mode == EditMode.MIDDLE_DRAG ) {
                this.Cursor = HAND;
            }

            if ( e.Location.X != m_button_initial.x || e.Location.Y != m_button_initial.y ) {
                m_mouse_moved = true;
            }
            if ( !(edit_mode == EditMode.MIDDLE_DRAG) && AppManager.isPlaying() ) {
                return;
            }

            if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ||
                 edit_mode == EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE ) {
                int x = e.X + AppManager.startToDrawX;
                int y = e.Y + getStartToDrawY();
                if ( m_mouse_move_init.x != x || m_mouse_move_init.y != y ) {
                    if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ) {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY );
                        edit_mode = EditMode.MOVE_ENTRY;
                    } else {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE );
                        edit_mode = EditMode.MOVE_ENTRY_WHOLE;
                    }
                }
            }

            if ( m_mouse_moved && m_mouse_hover_thread != null ) {
                m_mouse_hover_thread.Abort();
            }

            int clock = AppManager.clockFromXCoord( e.X );
            if ( m_mouse_downed ) {
                if ( m_ext_dragx == ExtDragXMode.NONE ) {
                    if ( AppManager.keyWidth > e.X ) {
                        m_ext_dragx = ExtDragXMode.LEFT;
                    } else if ( pictPianoRoll.Width < e.X ) {
                        m_ext_dragx = ExtDragXMode.RIGHT;
                    }
                } else {
                    if ( AppManager.keyWidth <= e.X && e.X <= pictPianoRoll.Width ) {
                        m_ext_dragx = ExtDragXMode.NONE;
                    }
                }

                if ( m_ext_dragy == ExtDragYMode.NONE ) {
                    if ( 0 > e.Y ) {
                        m_ext_dragy = ExtDragYMode.UP;
                    } else if ( pictPianoRoll.Height < e.Y ) {
                        m_ext_dragy = ExtDragYMode.DOWN;
                    }
                } else {
                    if ( 0 <= e.Y && e.Y <= pictPianoRoll.Height ) {
                        m_ext_dragy = ExtDragYMode.NONE;
                    }
                }
            } else {
                m_ext_dragx = ExtDragXMode.NONE;
                m_ext_dragy = ExtDragYMode.NONE;
            }

            double now = 0, dt = 0;
            if ( m_ext_dragx != ExtDragXMode.NONE || m_ext_dragy != ExtDragYMode.NONE ) {
                now = PortUtil.getCurrentTime();
                dt = now - m_timer_drag_last_ignitted;
            }
            if ( m_ext_dragx == ExtDragXMode.RIGHT || m_ext_dragx == ExtDragXMode.LEFT ) {
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                double d_draft;
                if ( m_ext_dragx == ExtDragXMode.LEFT ) {
                    px_move *= -1;
                }
                int left_clock = AppManager.clockFromXCoord( AppManager.keyWidth );
                int dclock = (int)(px_move / AppManager.scaleX);
                d_draft = 5 / AppManager.scaleX + left_clock + dclock;
                if ( d_draft < 0.0 ) {
                    d_draft = 0.0;
                }
                int draft = (int)d_draft;
                if ( hScroll.Maximum < draft ) {
                    if ( edit_mode == EditMode.ADD_ENTRY || edit_mode == EditMode.MOVE_ENTRY || edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                        hScroll.Maximum = draft;
                    } else {
                        draft = hScroll.Maximum;
                    }
                }
                if ( draft < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                }
                hScroll.Value = draft;
            }
            if ( m_ext_dragy == ExtDragYMode.UP || m_ext_dragy == ExtDragYMode.DOWN ) {
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                if ( m_ext_dragy == ExtDragYMode.UP ) {
                    px_move *= -1;
                }
                int draft_stdy = getStartToDrawY() + px_move;
                int draft = (int)((draft_stdy * (double)vScroll.Maximum) / (128.0 * AppManager.editorConfig.PxTrackHeight - vScroll.Height));
                if ( draft < 0 ) {
                    draft = 0;
                }
                int df = (int)draft;
                if ( df < vScroll.Minimum ) {
                    df = vScroll.Minimum;
                } else if ( vScroll.Maximum < df ) {
                    df = vScroll.Maximum;
                }
                vScroll.Value = df;
            }
            if ( m_ext_dragx != ExtDragXMode.NONE || m_ext_dragy != ExtDragYMode.NONE ) {
                m_timer_drag_last_ignitted = now;
            }

            // 選択範囲にあるイベントを選択．
            int stdy = getStartToDrawY();
            if ( AppManager.isPointerDowned ) {
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    int endClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        int odd = endClock % unit;
                        int nclock = endClock;
                        nclock -= odd;
                        if ( odd > unit / 2 ) {
                            nclock += unit;
                        }
                        endClock = nclock;
                    }
                    AppManager.wholeSelectedInterval.SetEnd( endClock );
                } else {
                    Point mouse = new Point( e.X + AppManager.startToDrawX, e.Y + getStartToDrawY() );
                    int tx, ty, twidth, theight;
                    int lx = AppManager.mouseDownLocation.x;
                    if ( lx < mouse.x ) {
                        tx = lx;
                        twidth = mouse.x - lx;
                    } else {
                        tx = mouse.x;
                        twidth = lx - mouse.x;
                    }
                    int ly = AppManager.mouseDownLocation.y;
                    if ( ly < mouse.y ) {
                        ty = ly;
                        theight = mouse.y - ly;
                    } else {
                        ty = mouse.y;
                        theight = ly - mouse.y;
                    }

                    Rectangle rect = new Rectangle( tx, ty, twidth, theight );
                    Vector<Integer> add_required = new Vector<Integer>();
                    int internal_id = -1;
#if USE_DOBJ
                    for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( AppManager.getSelected() - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        int x0 = dobj.pxRectangle.x + AppManager.keyWidth;
                        int x1 = dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width;
                        int y0 = dobj.pxRectangle.y;
                        int y1 = dobj.pxRectangle.y + dobj.pxRectangle.height;
                        internal_id = dobj.internalID;
#else
                    //int stdy = StartToDrawY;
                    for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){
                        VsqEvent evnt = (VsqEvent)itr.next();
                        int x0 = XCoordFromClocks( evnt.Clock );
                        int x1 = XCoordFromClocks( evnt.Clock + evnt.ID.Length );
                        int y0 = YCoordFromNote( evnt.ID.Note, stdy );
                        int y1 = y0 + AppManager.EditorConfig.PxTrackHeight;
                        internal_id = evnt.InternalID;
#endif
                        if ( x1 < tx ) {
                            continue;
                        }
                        if ( tx + twidth < x0 ) {
                            break;
                        }
                        boolean found = isInRect( new Point( x0, y0 ), rect ) | isInRect( new Point( x0, y1 ), rect ) | isInRect( new Point( x1, y0 ), rect ) | isInRect( new Point( x1, y1 ), rect );
                        if ( found ) {
                            add_required.add( internal_id );
                        } else {
                            if ( x0 <= tx && tx + twidth <= x1 ) {
                                if ( ty < y0 ) {
                                    if ( y0 <= ty + theight ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( y0 <= ty && ty < y1 ) {
                                    add_required.add( internal_id );
                                }
                            } else if ( y0 <= ty && ty + theight <= y1 ) {
                                if ( tx < x0 ) {
                                    if ( x0 <= tx + twidth ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( x0 <= tx && tx < x1 ) {
                                    add_required.add( internal_id );
                                }
                            }
                        }
                    }
                    Vector<Integer> remove_required = new Vector<Integer>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry selected = itr.next();
                        if ( !add_required.contains( selected.original.InternalID ) ) {
                            remove_required.add( selected.original.InternalID );
                        }
                    }
                    if ( remove_required.size() > 0 ) {
                        AppManager.removeSelectedEventRange( remove_required.toArray( new Integer[] { } ) );
                    }
                    for ( Iterator<Integer> itr = add_required.iterator(); itr.hasNext(); ) {
                        int id = itr.next();
                        if ( AppManager.isSelectedEventContains( AppManager.getSelected(), id ) ) {
                            itr.remove();
                        }
                    }
                    AppManager.addSelectedEventAll( add_required.toArray( new Integer[] { } ) );
                }
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                #region MiddleDrag
                int dx = e.X - m_button_initial.x;
                int dy = e.Y - m_button_initial.y;
                double new_vscroll_value = (double)m_middle_button_vscroll - dy * (double)vScroll.Maximum / (128.0 * AppManager.editorConfig.PxTrackHeight - (double)vScroll.Height);
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / AppManager.scaleX;
                if ( new_vscroll_value < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else if ( vScroll.Maximum < new_vscroll_value ) {
                    vScroll.Value = vScroll.Maximum;
                } else {
                    vScroll.Value = (int)new_vscroll_value;
                }
                if ( new_hscroll_value < hScroll.Minimum ) {
                    hScroll.Value = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    hScroll.Value = hScroll.Maximum;
                } else {
                    hScroll.Value = (int)new_hscroll_value;
                }
                if ( AppManager.isPlaying() ) {
                    return;
                }
                #endregion
                return;
            } else if ( edit_mode == EditMode.ADD_ENTRY ) {
                #region AddEntry
                int unit = AppManager.getLengthQuantizeClock();
                int length = clock - AppManager.addingEvent.Clock;
                int odd = length % unit;
                int new_length = length - odd;

                if ( unit * AppManager.scaleX > 10 ) { //これをしないと、グリッド2個分増えることがある
                    int next_clock = AppManager.clockFromXCoord( e.X + 10 );
                    int next_length = next_clock - AppManager.addingEvent.Clock;
                    int next_new_length = next_length - (next_length % unit);
                    if ( next_new_length == new_length + unit ) {
                        new_length = next_new_length;
                    }
                }

                if ( new_length <= 0 ) {
                    new_length = 0;
                }
                AppManager.addingEvent.ID.Length = new_length;
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY || edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
                #region MOVE_ENTRY, MOVE_ENTRY_WHOLE
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    int note = noteFromYCoord( e.Y );                           // 現在のマウス位置でのnote
                    int note_init = original.ID.Note;
                    int dnote = (edit_mode == EditMode.MOVE_ENTRY) ? note - note_init : 0;

                    int tclock = AppManager.clockFromXCoord( e.X - m_mouse_move_offset );
                    int clock_init = original.Clock;

                    int dclock = tclock - clock_init;

                    if ( AppManager.editorConfig.PositionQuantize != QuantizeMode.off ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        int new_clock = original.Clock + dclock;
                        int odd = new_clock % unit;
                        new_clock -= odd;
                        if ( odd > unit / 2 ) {
                            new_clock += unit;
                        }
                        dclock = new_clock - clock_init;
                    }

                    AppManager.wholeSelectedIntervalStartForMoving = AppManager.wholeSelectedInterval.Start + dclock;

                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int new_clock = item.original.Clock + dclock;
                        int new_note = item.original.ID.Note + dnote;
                        item.editing.Clock = new_clock;
                        item.editing.ID.Note = new_note;
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE ) {
                #region EditLeftEdge
                int unit = AppManager.getLengthQuantizeClock();
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock_init = original.Clock;
                int dclock = clock - clock_init;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int end_clock = item.original.Clock + item.original.ID.Length;
                    int new_clock = item.original.Clock + dclock;
                    int length = end_clock - new_clock;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.editing.Clock = end_clock - new_length;
                    item.editing.ID.Length = new_length;
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EditRightEdge
                int unit = AppManager.getLengthQuantizeClock();

                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int dlength = clock - (original.Clock + original.ID.Length);
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int length = item.original.ID.Length + dlength;
                    int odd = length % unit;
                    int new_length = length - odd;
                    if ( odd > unit / 2 ) {
                        new_length += unit;
                    }
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.editing.ID.Length = new_length;
                }
                #endregion
            } else if ( edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddFixedLengthEntry
                int note = noteFromYCoord( e.Y );
                int unit = AppManager.getPositionQuantizeClock();
                int new_clock = AppManager.clockFromXCoord( e.X );
                int odd = new_clock % unit;
                new_clock -= odd;
                if ( odd > unit / 2 ) {
                    new_clock += unit;
                }
                AppManager.addingEvent.ID.Note = note;
                AppManager.addingEvent.Clock = new_clock;
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                int new_vibrato_start = clock;
                int old_vibrato_end = AppManager.addingEvent.Clock + AppManager.addingEvent.ID.Length;
                int new_vibrato_length = old_vibrato_end - new_vibrato_start;
                int max_length = (int)(AppManager.addingEventLength - _PX_ACCENT_HEADER / AppManager.scaleX);
                if ( max_length < 0 ) {
                    max_length = 0;
                }
                if ( new_vibrato_length > max_length ) {
                    new_vibrato_start = old_vibrato_end - max_length;
                    new_vibrato_length = max_length;
                }
                if ( new_vibrato_length < 0 ) {
                    new_vibrato_start = old_vibrato_end;
                    new_vibrato_length = 0;
                }
                AppManager.addingEvent.Clock = new_vibrato_start;
                AppManager.addingEvent.ID.Length = new_vibrato_length;
                updatePositionViewFromMousePosition( clock );
                if ( !timer.Enabled ) {
                    refreshScreen();
                }
                #endregion
                return;
            }
            updatePositionViewFromMousePosition( clock );

            // カーソルの形を決める
            if ( !m_mouse_downed ) {
                boolean split_cursor = false;
                boolean hand_cursor = false;
                int stdx = AppManager.startToDrawX;
                int min_width = 4 * _EDIT_HANDLE_WIDTH;
#if USE_DOBJ
                for ( Iterator<DrawObject> itr = AppManager.drawObjects.get( AppManager.getSelected() - 1 ).iterator(); itr.hasNext(); ) {
                    DrawObject dobj = itr.next();

                    int edit_handle_width = _EDIT_HANDLE_WIDTH;
                    if ( dobj.pxRectangle.width < min_width ) {
                        edit_handle_width = dobj.pxRectangle.width / 4;
                    }

                    // 音符左側の編集領域
#else
                for ( Iterator itr = AppManager.VsqFile.getTrack( AppManager.Selected ).getNoteEventIterator(); itr.hasNext(); ){

#endif
                    Rectangle rc = new Rectangle(
                                        dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                                        dobj.pxRectangle.y - stdy,
                                        edit_handle_width,
                                        AppManager.editorConfig.PxTrackHeight );
                    if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符右側の編集領域
                    rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxRectangle.width - stdx - edit_handle_width,
                                        dobj.pxRectangle.y - stdy,
                                        edit_handle_width,
                                        AppManager.editorConfig.PxTrackHeight );
                    if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                        split_cursor = true;
                        break;
                    }

                    // 音符本体
                    rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth - stdx,
                                        dobj.pxRectangle.y - stdy,
                                        dobj.pxRectangle.width,
                                        dobj.pxRectangle.height );
                    if ( AppManager.editorConfig.ShowExpLine && !dobj.overlappe ) {
                        rc.height *= 2;
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            // ビブラートの開始位置
                            rc = new Rectangle( dobj.pxRectangle.x + AppManager.keyWidth + dobj.pxVibratoDelay - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.pxRectangle.y + AppManager.editorConfig.PxTrackHeight - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                AppManager.editorConfig.PxTrackHeight );
                            if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                                split_cursor = true;
                                break;
                            } else {
                                hand_cursor = true;
                                break;
                            }
                        }
                    } else {
                        if ( isInRect( new Point( e.X, e.Y ), rc ) ) {
                            hand_cursor = true;
                            break;
                        }
                    }
                }

                if ( split_cursor ) {
                    this.Cursor = Cursors.VSplit;
                } else if ( hand_cursor ) {
                    this.Cursor = Cursors.Hand;
                } else {
                    this.Cursor = Cursors.Default;
                }
            }
            if ( !timer.Enabled ) {
                refreshScreen();
            }
        }

        private void pictPianoRoll_MouseUp( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "pictureBox1_MouseUp" );
            AppManager.debugWriteLine( "    m_config.EditMode=" + AppManager.getEditMode() );
#endif
            AppManager.isPointerDowned = false;
            m_mouse_downed = false;

            Keys modefier = Control.ModifierKeys;

            EditMode edit_mode = AppManager.getEditMode();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( AppManager.getSelected() );
            CurveType selected_curve = trackSelector.getSelectedCurve();

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                this.Cursor = Cursors.Default;
            } else if ( edit_mode == EditMode.ADD_ENTRY || edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddEntry || AddFixedLengthEntry
                if ( AppManager.getSelected() >= 0 ) {
                    if ( (AppManager.getEditMode() == EditMode.ADD_FIXED_LENGTH_ENTRY) ||
                         (AppManager.getEditMode() == EditMode.ADD_ENTRY && (m_button_initial.x != e.X || m_button_initial.y != e.Y) && AppManager.addingEvent.ID.Length > 0) ) {
                        LyricHandle lyric = new LyricHandle( "a", "a" );
                        VibratoHandle vibrato = null;
                        int vibrato_delay = 0;
                        if ( AppManager.editorConfig.EnableAutoVibrato ) {
                            int note_length = AppManager.addingEvent.ID.Length;
                            // 音符位置での拍子を調べる
                            //int denom, numer;
                            Timesig timesig = AppManager.getVsqFile().getTimesigAt( AppManager.addingEvent.Clock );

                            // ビブラートを自動追加するかどうかを決める閾値
                            int autovib = AutoVibratoMinLengthUtil.getValue( AppManager.editorConfig.AutoVibratoMinimumLength );
                            int threshold = 480 * 4 / timesig.denominator * autovib;
                            if ( note_length >= threshold ) {
                                int vibrato_clocks = 0;
                                switch ( AppManager.editorConfig.DefaultVibratoLength ) {
                                    case DefaultVibratoLength.L100:
                                        vibrato_clocks = note_length;
                                        break;
                                    case DefaultVibratoLength.L50:
                                        vibrato_clocks = note_length / 2;
                                        break;
                                    case DefaultVibratoLength.L66:
                                        vibrato_clocks = note_length * 2 / 3;
                                        break;
                                    case DefaultVibratoLength.L75:
                                        vibrato_clocks = note_length * 3 / 4;
                                        break;
                                }
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                String default_icon_id = AppManager.editorConfig.AutoVibratoType2;
                                if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.Equals( VSTiProxy.RENDERER_DSB2 ) ) {
                                    type = SynthesizerType.VOCALOID1;
                                    default_icon_id = AppManager.editorConfig.AutoVibratoType1;
                                }
                                vibrato = VocaloSysUtil.getDefaultVibratoHandle( default_icon_id, vibrato_clocks, type );
                                //vibrato.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                                //vibrato.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                                vibrato_delay = note_length - vibrato_clocks;
                            }
                        }

                        // 自動ノーマライズのモードで、処理を分岐
                        if ( AppManager.autoNormalize ) {
                            VsqTrack work = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            AppManager.addingEvent.ID.VibratoHandle = vibrato;
                            AppManager.addingEvent.ID.LyricHandle = lyric;
                            AppManager.addingEvent.ID.VibratoDelay = vibrato_delay;
                            //AppManager.addingEvent.InternalID = work.GetNextId( 0 );
                            boolean changed = true;
                            while ( changed ) {
                                changed = false;
                                for ( int i = 0; i < work.getEventCount(); i++ ) {
                                    int start_clock = work.getEvent( i ).Clock;
                                    int end_clock = work.getEvent( i ).ID.Length + start_clock;
                                    if ( start_clock < AppManager.addingEvent.Clock && AppManager.addingEvent.Clock < end_clock ) {
                                        work.getEvent( i ).ID.Length = AppManager.addingEvent.Clock - start_clock;
                                        changed = true;
                                    } else if ( start_clock == AppManager.addingEvent.Clock ) {
                                        work.removeEvent( i );
                                        changed = true;
                                        break;
                                    } else if ( AppManager.addingEvent.Clock < start_clock && start_clock < AppManager.addingEvent.Clock + AppManager.addingEvent.ID.Length ) {
                                        AppManager.addingEvent.ID.Length = start_clock - AppManager.addingEvent.Clock;
                                        changed = true;
                                    }
                                }
                            }
                            work.addEvent( (VsqEvent)AppManager.addingEvent.clone() );
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                                         work,
                                                                                         AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                        } else {
                            VsqEvent[] items = new VsqEvent[1];
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            items[0] = new VsqEvent( 0, AppManager.addingEvent.ID );
                            items[0].Clock = AppManager.addingEvent.Clock;
                            items[0].ID.LyricHandle = lyric;
                            items[0].ID.VibratoDelay = vibrato_delay;
                            items[0].ID.VibratoHandle = vibrato;
#if DEBUG
                            AppManager.debugWriteLine( "        items[0].ID.ToString()=" + items[0].ID.ToString() );
#endif
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAddRange( AppManager.getSelected(), items ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                        }
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY ) {
                #region MoveEntry
#if DEBUG
                AppManager.debugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.getSelectedEventCount() );
#endif
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    if ( original.Clock != AppManager.getLastSelectedEvent().editing.Clock || original.ID.Note != AppManager.getLastSelectedEvent().editing.ID.Note ) {
                        int count = AppManager.getSelectedEventCount();
                        int[] ids = new int[count];
                        int[] clocks = new int[count];
                        VsqID[] values = new VsqID[count];
                        int i = -1;
                        boolean out_of_range = false;
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry ev = itr.next();
                            i++;
                            ids[i] = ev.original.InternalID;
                            clocks[i] = ev.editing.Clock;
                            if ( clocks[i] < AppManager.getVsqFile().getPreMeasureClocks() ) {
                                out_of_range = true;
                            }
                            values[i] = ev.editing.ID;
                            if ( values[i].Note < 0 || 128 < values[i].Note ) {
                                out_of_range = true;
                            }
                        }
                        if ( !out_of_range ) {
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.getSelected(),
                                                                                               ids,
                                                                                               clocks,
                                                                                               values ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                        } else {
                            SystemSounds.Asterisk.Play();
                        }
                    } else {
                        /*if ( (modefier & Keys.Shift) == Keys.Shift || (modefier & Keys.Control) == Keys.Control ) {
                            Rectangle rc;
                            VsqEvent select = IdOfClickedPosition( e.Location, out rc );
                            if ( select != null ) {
                                m_config.addSelectedEvent( item.InternalID );
                            }
                        }*/
                    }
                    lock ( AppManager.drawObjects ) {
                        Collections.sort( AppManager.drawObjects.get( AppManager.getSelected() - 1 ) );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE ) {
                #region EditLeftEdge
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                if ( original.Clock != AppManager.getLastSelectedEvent().editing.Clock ||
                    original.ID.Length != original.ID.Length ) {
                    int count = AppManager.getSelectedEventCount();
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry ev = itr.next();
                        i++;
                        if ( ev.editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.original.InternalID;
                            clocks[i] = ev.editing.Clock;
                            values[i] = ev.editing.ID;
                        } else {
                            int draft_vibrato_length = ev.editing.ID.Length - ev.editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.editing.ID.VibratoHandle = null;
                                ev.editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.original.InternalID;
                            clocks[i] = ev.editing.Clock;
                            values[i] = ev.editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.getSelected(),
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EditRightEdge
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                if ( original.ID.Length != AppManager.getLastSelectedEvent().editing.ID.Length ) {
                    int count = AppManager.getSelectedEventCount();
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry ev = itr.next();
                        i++;
                        if ( ev.editing.ID.VibratoHandle == null ) {
                            ids[i] = ev.original.InternalID;
                            clocks[i] = ev.editing.Clock;
                            values[i] = ev.editing.ID;
                        } else {
                            int draft_vibrato_length = ev.editing.ID.Length - ev.editing.ID.VibratoDelay;
                            if ( draft_vibrato_length <= 0 ) {
                                // ビブラートを削除
                                ev.editing.ID.VibratoHandle = null;
                                ev.editing.ID.VibratoDelay = 0;
                            } else {
                                // ビブラートは温存
                                ev.editing.ID.VibratoHandle.Length = draft_vibrato_length;
                            }
                            ids[i] = ev.original.InternalID;
                            clocks[i] = ev.editing.Clock;
                            values[i] = ev.editing.ID;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( AppManager.getSelected(),
                                                                             ids,
                                                                             clocks,
                                                                             values ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                if ( m_mouse_moved ) {
                    double max_length = AppManager.addingEventLength - _PX_ACCENT_HEADER / AppManager.scaleX;
                    double rate = AppManager.addingEvent.ID.Length / max_length;
                    if ( rate > 0.99 ) {
                        rate = 1.0;
                    }
                    int vibrato_length = (int)(AppManager.addingEventLength * rate);
                    VsqEvent item = null;
                    for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent ve = itr.next();
                        if ( ve.InternalID == m_vibrato_editing_id ) {
                            item = (VsqEvent)ve.clone();
                            break;
                        }
                    }
                    if ( item != null ) {
                        if ( vibrato_length <= 0 ) {
                            item.ID.VibratoHandle = null;
                            item.ID.VibratoDelay = item.ID.Length;
                        } else {
                            item.ID.VibratoHandle.Length = vibrato_length;
                            item.ID.VibratoDelay = item.ID.Length - vibrato_length;
                        }
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(), m_vibrato_editing_id, item.ID ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
#if DEBUG
                PortUtil.println( "FormMain#pictPianoRoll_MouseUp; EditMode.MOVE_ENTRY_WHOLE" );
#endif
                #region MOVE_ENTRY_WHOLE
                int src_clock_start = AppManager.wholeSelectedInterval.Start;
                int src_clock_end = AppManager.wholeSelectedInterval.End;
                int dst_clock_start = AppManager.wholeSelectedIntervalStartForMoving;
                int dst_clock_end = dst_clock_start + (src_clock_end - src_clock_start);
                int dclock = dst_clock_start - src_clock_start;

                int num = AppManager.getSelectedEventCount();
                int[] selected_ids = new int[num]; // 後段での再選択用のInternalIDのリスト
                int last_selected_id = AppManager.getLastSelectedEvent().original.InternalID;

                // 音符イベントを移動
                VsqTrack work = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                int k = 0;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int internal_id = item.original.InternalID;
                    selected_ids[k] = internal_id;
                    k++;
#if DEBUG
                    PortUtil.println( "FormMain#pictPianoRoll_MouseUp; internal_id=" + internal_id );
#endif
                    for ( Iterator<VsqEvent> itr2 = work.getNoteEventIterator(); itr2.hasNext(); ) {
                        VsqEvent vsq_event = itr2.next();
                        if ( internal_id == vsq_event.InternalID ) {
#if DEBUG
                            PortUtil.println( "FormMain#pictPianoRoll_MouseUp; before: clock=" + vsq_event.Clock + "; after: clock=" + item.editing.Clock );
#endif
                            vsq_event.Clock = item.editing.Clock;
                            break;
                        }
                    }
                }

                // 全てのコントロールカーブのデータ点を移動
                for ( int i = 0; i < AppManager.CURVE_USAGE.Length; i++ ) {
                    CurveType curve_type = AppManager.CURVE_USAGE[i];
                    VsqBPList bplist = work.getCurve( curve_type.getName() );
                    if ( bplist == null ) {
                        continue;
                    }

                    // src_clock_startからsrc_clock_endの範囲にあるデータ点をコピー＆削除
                    VsqBPList copied = new VsqBPList( bplist.getDefault(), bplist.getMinimum(), bplist.getMaximum() );
                    int size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( src_clock_start <= clock && clock <= src_clock_end ) {
                            VsqBPPair bppair = bplist.getElementB( j );
                            copied.add( clock, bppair.value );
                            bplist.removeElementAt( j );
                        }
                    }

                    // dst_clock_startからdst_clock_endの範囲にあるコントロールカーブのデータ点をすべて削除
                    size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( dst_clock_start <= clock && clock <= dst_clock_end ) {
                            bplist.removeElementAt( j );
                        }
                    }

                    // コピーしたデータを、クロックをずらしながら追加
                    size = copied.size();
                    for ( int j = 0; j < size; j++ ) {
                        int clock = copied.getKeyClock( j );
                        VsqBPPair bppair = copied.getElementB( j );
                        bplist.add( clock + dclock, bppair.value );
                    }
                }

                // コマンドを作成＆実行
                int track_num = AppManager.getSelected();
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( track_num,
                                                                             work,
                                                                             AppManager.getVsqFile().AttachedCurves.get( track_num - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );

                // 選択範囲を更新
                AppManager.wholeSelectedInterval = new SelectedRegion( dst_clock_start );
                AppManager.wholeSelectedInterval.SetEnd( dst_clock_end );
                AppManager.wholeSelectedIntervalStartForMoving = dst_clock_start;

                // 音符の再選択
                AppManager.clearSelectedEvent();
                AppManager.addSelectedEventAll( selected_ids );
                AppManager.addSelectedEvent( last_selected_id );

                setEdited( true );
                #endregion
            } else if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                int start = AppManager.wholeSelectedInterval.Start;
                int end = AppManager.wholeSelectedInterval.End;
                AppManager.clearSelectedEvent();

                // 音符の選択状態を更新
                Vector<Integer> add_required_event = new Vector<Integer>();
                for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = itr.next();
                    if ( start <= ve.Clock && ve.Clock + ve.ID.Length <= end ) {
                        add_required_event.add( ve.InternalID );
                    }
                }
                AppManager.addSelectedEventAll( add_required_event.toArray( new Integer[] { } ) );

                // コントロールカーブ点の選択状態を更新
                Vector<Long> add_required_point = new Vector<Long>();
                VsqBPList list = vsq_track.getCurve( selected_curve.getName() );
                if ( list != null ) {
                    int count = list.size();
                    for ( int i = 0; i < count; i++ ) {
                        int clock = list.getKeyClock( i );
                        if ( clock < start ) {
                            continue;
                        } else if ( end < clock ) {
                            break;
                        } else {
                            VsqBPPair v = list.getElementB( i );
                            add_required_point.add( v.id );
                        }
                    }
                }
                if ( add_required_point.size() > 0 ) {
                    AppManager.addSelectedPointAll( selected_curve,
                                                    PortUtil.convertLongArray( add_required_point.toArray( new Long[] { } ) ) );
                }
            }
            refreshScreen();
            if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                AppManager.setEditMode( EditMode.NONE );
            }
        }

        private void pictPianoRoll_MouseWheel( Object sender, BMouseEventArgs e ) {
            boolean horizontal = (Control.ModifierKeys & Keys.Shift) == Keys.Shift;
            if ( AppManager.editorConfig.ScrollHorizontalOnWheel ) {
                horizontal = !horizontal;
            }
            if ( horizontal ) {
                hScroll.Value = computeScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            refreshScreen();
        }

        private void pictPianoRoll_PreviewKeyDown( Object sender, PreviewKeyDownEventArgs e ) {
#if DEBUG
            System.Diagnostics.Debug.WriteLine( "pictureBox1_PreviewKeyDown" );
            System.Diagnostics.Debug.WriteLine( "    e.KeyCode=" + e.KeyCode );
#endif
            if ( e.KeyCode == Keys.Tab && AppManager.getSelectedEventCount() > 0 ) {
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                if ( original == null ) {
                    return;
                }
                int x = AppManager.xCoordFromClocks( original.Clock );
                int y = yCoordFromNote( original.ID.Note );
                if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                showInputTextBox( original.ID.LyricHandle.L0.Phrase,
                                  original.ID.LyricHandle.L0.getPhoneticSymbol(),
                                  new Point( x, y ),
                                  m_last_symbol_edit_mode );
                e.IsInputKey = true;
                refreshScreen();
            }
            BKeyEventArgs e0 = new KeyEventArgs( e.KeyData );
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        #region menuVisual*
        private void menuVisualMixer_Click( Object sender, BEventArgs e ) {
            menuVisualMixer.Checked = !menuVisualMixer.Checked;
            AppManager.editorConfig.MixerVisible = menuVisualMixer.Checked;
            AppManager.mixerWindow.Visible = AppManager.editorConfig.MixerVisible;
            this.Focus();
        }

        private void menuVisualGridline_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.setGridVisible( menuVisualGridline.Checked );
            refreshScreen();
        }

        private void menuVisualLyrics_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ShowLyric = menuVisualLyrics.Checked;
        }

        private void menuVisualNoteProperty_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ShowExpLine = menuVisualNoteProperty.Checked;
            refreshScreen();
        }

        private void menuVisualPitchLine_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ViewAtcualPitch = menuVisualPitchLine.Checked;
        }

        private void menuVisualControlTrack_CheckedChanged( Object sender, BEventArgs e ) {
            trackSelector.setCurveVisible( menuVisualControlTrack.isSelected() );
            if ( menuVisualControlTrack.isSelected() ) {
                splitContainer1.IsSplitterFixed = false;
                splitContainer1.SplitterDistance = splitContainer1.Height - AppManager.lastTrackSelectorHeight - splitContainer1.SplitterWidth;
                splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            } else {
                AppManager.lastTrackSelectorHeight = splitContainer1.Height - splitContainer1.SplitterDistance - splitContainer1.SplitterWidth;
                splitContainer1.IsSplitterFixed = true;
                splitContainer1.Panel2MinSize = _SPL1_PANEL2_MIN_HEIGHT;
                splitContainer1.SplitterDistance = splitContainer1.Height - _SPL1_PANEL2_MIN_HEIGHT - splitContainer1.SplitterWidth;
            }
            refreshScreen();
        }

        private void menuHiddenVisualForwardParameter_Click( Object sender, BEventArgs e ) {
            trackSelector.SelectNextCurve();
        }

        private void menuHiddenVisualBackwardParameter_Click( Object sender, BEventArgs e ) {
            trackSelector.SelectPreviousCurve();
        }

        private void menuVisualWaveform_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ViewWaveform = menuVisualWaveform.Checked;
            updateSplitContainer2Size();
        }

        private void menuVisualControlTrack_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide control curves." );
        }

        private void menuVisualMixer_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide mixer window." );
        }

        private void menuVisualWaveform_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide waveform." );
        }

        private void menuVisualProperty_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide property window." );
        }

        private void menuVisualGridline_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide grid line." );
        }

        private void menuVisualStartMarker_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Enable/Disable start marker." );
        }

        private void menuVisualEndMarker_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Enable/Disable end marker." );
        }

        private void menuVisualLyrics_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide lyrics." );
        }

        private void menuVisualNoteProperty_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide expression lines." );
        }

        private void menuVisualPitchLine_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show/Hide pitch bend lines." );
        }
        #endregion

        #region m_mixer_dlg
        private void m_mixer_dlg_SoloChanged( int track, boolean solo ) {
#if DEBUG
            AppManager.debugWriteLine( "m_mixer_dlg_SoloChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    solo=" + solo );
#endif
            if ( track == 0 ) {
                // ここはなし
            } else if ( track > 0 ) {
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Solo = solo ? 1 : 0;
            } else {
                // ここもなし
            }
        }

        private void m_mixer_dlg_MuteChanged( int track, boolean mute ) {
#if DEBUG
            AppManager.debugWriteLine( "m_mixer_dlg_MuteChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    mute=" + mute );
#endif
            if ( track == 0 ) {
                AppManager.getVsqFile().Mixer.MasterMute = mute ? 1 : 0;
            } else if ( track > 0 ) {
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Mute = mute ? 1 : 0;
            } else {
                AppManager.getBgm( -track - 1 ).mute = mute ? 1 : 0;
            }
        }

        private void m_mixer_dlg_PanpotChanged( int track, int panpot ) {
            if ( track == 0 ) {
                // master
                AppManager.getVsqFile().Mixer.MasterPanpot = panpot;
            } else if ( track > 0 ) {
                // slave
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Panpot = panpot;
            } else {
                AppManager.getBgm( -track - 1 ).panpot = panpot;
            }
        }

        private void m_mixer_dlg_FederChanged( int track, int feder ) {
#if DEBUG
            PortUtil.println( "FormMain#m_mixer_dlg_FederChanged; track=" + track + "; feder=" + feder );
#endif
            if ( track == 0 ) {
                AppManager.getVsqFile().Mixer.MasterFeder = feder;
            } else if ( track > 0 ) {
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Feder = feder;
            } else {
                AppManager.getBgm( -track - 1 ).feder = feder;
            }
        }

        private void m_mixer_dlg_TopMostChanged( Object sender, boolean arg ) {
            AppManager.editorConfig.MixerTopMost = arg;
        }
        #endregion

        #region FormMain
        private void FormMain_FormClosed( Object sender, FormClosedEventArgs e ) {
            clearTempWave();
            String tempdir = AppManager.getTempWaveDir();
            String log = PortUtil.combinePath( tempdir, "run.log" );
            bocoree.debug.close();
            try {
                if ( PortUtil.isFileExists( log ) ) {
                    PortUtil.deleteFile( log );
                }
                PortUtil.deleteDirectory( tempdir, true );
            } catch ( Exception ex ) {
            }
            VSTiProxy.abortRendering();
            VSTiProxy.terminate();
            MidiPlayer.Stop();
            PlaySound.kill();
        }

        private void FormMain_FormClosing( Object sender, FormClosingEventArgs e ) {
            if ( isEdited() ) {
                String file = AppManager.getFileName();
                if ( file.Equals( "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult ret = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                               _( "Affirmation" ),
                                                               MessageBoxButtons.YesNoCancel,
                                                               MessageBoxIcon.Question );
                if ( ret == BDialogResult.YES ) {
                    if ( AppManager.getFileName().Equals( "" ) ) {
                        DialogResult dr = DialogResult.Cancel;
                        if ( AppManager.editorConfig.UseCustomFileDialog ) {
                            FileDialog fd = null;
                            try {
                                fd = new FileDialog( FileDialog.DialogMode.Save );
                                if ( saveXmlVsqDialog.FileName != "" ) {
                                    fd.FileName = saveXmlVsqDialog.FileName;
                                }
                                fd.Filter = saveXmlVsqDialog.Filter;
                                dr = fd.ShowDialog();
                                if ( dr == DialogResult.OK ) {
                                    saveXmlVsqDialog.FileName = fd.FileName;
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( fd != null ) {
                                    try {
#if !JAVA
                                        fd.Dispose();
#endif
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        } else {
                            dr = saveXmlVsqDialog.ShowDialog();
                        }
                        if ( dr == DialogResult.OK ) {
                            AppManager.saveTo( saveXmlVsqDialog.FileName );
                        } else {
                            e.Cancel = true;
                            return;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                    }

                } else if ( ret == BDialogResult.CANCEL ) {
                    e.Cancel = true;
                    return;
                }
            }
            AppManager.editorConfig.WindowMaximized = (this.WindowState == FormWindowState.Maximized);
            AppManager.saveConfig();
            UtauRenderingRunner.clearCache();
            StraightRenderingRunner.clearCache();
            if ( m_midi_in != null ) {
                m_midi_in.Dispose();
            }
            bgWorkScreen.Dispose();
            e.Cancel = false;
        }

        private void FormMain_Load( Object sender, BEventArgs e ) {
            applyLanguage();
            trackBar.Value = AppManager.editorConfig.DefaultXScale;
            AppManager.setCurrentClock( 0 );
            setEdited( false );

            AppManager.PreviewStarted += new EventHandler( AppManager_PreviewStarted );
            AppManager.PreviewAborted += new EventHandler( AppManager_PreviewAborted );
            AppManager.GridVisibleChanged += new EventHandler( AppManager_GridVisibleChanged );
            AppManager.SelectedEventChanged += new SelectedEventChangedEventHandler( AppManager_SelectedEventChanged );
            AppManager.CurrentClockChanged += new EventHandler( AppManager_CurrentClockChanged );
            AppManager.SelectedToolChanged += new EventHandler( AppManager_SelectedToolChanged );
            EditorConfig.QuantizeModeChanged += new EventHandler( EditorConfig_QuantizeModeChanged );
            m_property_panel_container.StateChangeRequired += new StateChangeRequiredEventHandler( m_property_panel_container_StateChangeRequired );

            updateRecentFileMenu();

            // C3が画面中央に来るように調整
            int draft_start_to_draw_y = 68 * AppManager.editorConfig.PxTrackHeight - pictPianoRoll.Height / 2;
            int draft_vscroll_value = (int)((draft_start_to_draw_y * (double)vScroll.Maximum) / (128 * AppManager.editorConfig.PxTrackHeight - vScroll.Height));
            try {
                vScroll.Value = draft_vscroll_value;
            } catch ( Exception ex ) {
            }

            // x=97がプリメジャークロックになるように調整
            int cp = AppManager.getVsqFile().getPreMeasureClocks();
            int draft_hscroll_value = (int)(cp - 24.0 / AppManager.scaleX);
            try {
                hScroll.Value = draft_hscroll_value;
            } catch ( Exception ex ) {
            }

            //s_pen_dashed_171_171_171.DashPattern = new float[] { 3, 3 };
            //s_pen_dashed_209_204_172.DashPattern = new float[] { 3, 3 };

            menuVisualNoteProperty.Checked = AppManager.editorConfig.ShowExpLine;
            menuVisualLyrics.Checked = AppManager.editorConfig.ShowLyric;
            menuVisualMixer.Checked = AppManager.editorConfig.MixerVisible;
            menuVisualPitchLine.Checked = AppManager.editorConfig.ViewAtcualPitch;

            AppManager.mixerWindow = new FormMixer( this );

            updateMenuFonts();

            AppManager.mixerWindow.FederChanged += new FormMixer.FederChangedEventHandler( m_mixer_dlg_FederChanged );
            AppManager.mixerWindow.PanpotChanged += new FormMixer.PanpotChangedEventHandler( m_mixer_dlg_PanpotChanged );
            AppManager.mixerWindow.MuteChanged += new FormMixer.MuteChangedEventHandler( m_mixer_dlg_MuteChanged );
            AppManager.mixerWindow.SoloChanged += new FormMixer.SoloChangedEventHandler( m_mixer_dlg_SoloChanged );
            AppManager.mixerWindow.TopMostChanged += new TopMostChangedEventHandler( m_mixer_dlg_TopMostChanged );
            AppManager.mixerWindow.ShowTopMost = AppManager.editorConfig.MixerTopMost;
            AppManager.mixerWindow.updateStatus();
            if ( AppManager.editorConfig.MixerVisible ) {
                AppManager.mixerWindow.Show();
            }

            trackSelector.CommandExecuted += new EventHandler( trackSelector_CommandExecuted );

            updateScriptShortcut();

            clearTempWave();
            setHScrollRange( AppManager.getVsqFile().TotalClocks );
            setVScrollRange( vScroll.Maximum );
            m_pencil_mode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
            loadGameControler();
            reloadMidiIn();
            menuVisualWaveform.Checked = AppManager.editorConfig.ViewWaveform;
            updateSplitContainer2Size();

            updateRendererMenu();

            if ( AppManager.editorConfig.WindowMaximized ) {
                this.WindowState = FormWindowState.Maximized;
            } else {
                this.WindowState = FormWindowState.Normal;
            }
            this.setBounds( AppManager.editorConfig.WindowRect );

            // プロパティウィンドウの位置を復元
            System.Drawing.Rectangle rc1 = Screen.GetWorkingArea( this );
            Rectangle rcScreen = new Rectangle( rc1.X, rc1.Y, rc1.Width, rc1.Height );
            Point p = this.getLocation();
            XmlRectangle xr = AppManager.editorConfig.PropertyWindowStatus.Bounds;
            Point p0 = new Point( xr.x, xr.y );
            Point a = new Point( p.x + p0.x, p.y + p0.y );
            Rectangle rc = new Rectangle( a.x,
                                          a.y,
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.Width,
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.Height );

            if ( a.y > rcScreen.y + rcScreen.height ) {
                a = new Point( a.x, rcScreen.y + rcScreen.height - rc.height );
            }
            if ( a.y < rcScreen.y ) {
                a = new Point( a.x, rcScreen.y );
            }
            if ( a.x > rcScreen.x + rcScreen.width ) {
                a = new Point( rcScreen.x + rcScreen.width - rc.width, a.y );
            }
            if ( a.x < rcScreen.x ) {
                a = new Point( rcScreen.x, a.y );
            }
#if DEBUG
            AppManager.debugWriteLine( "FormMain_Load; a=" + a );
#endif
            AppManager.propertyWindow.setBounds( a.x, a.y, rc.width, rc.height );
            AppManager.propertyWindow.LocationChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.propertyWindow.SizeChanged += new EventHandler( m_note_proerty_dlg_LocationOrSizeChanged );
            AppManager.propertyWindow.FormClosing += new FormClosingEventHandler( m_note_proerty_dlg_FormClosing );
            AppManager.propertyPanel.CommandExecuteRequired += new CommandExecuteRequiredEventHandler( m_note_proerty_dlg_CommandExecuteRequired );
            AppManager.propertyWindow.setFormCloseShortcutKey( AppManager.editorConfig.getShortcutKeyFor( menuVisualProperty ) );
            updatePropertyPanelState( AppManager.editorConfig.PropertyWindowStatus.State );
            updateBgmMenuState();

            this.SizeChanged += new System.EventHandler( this.FormMain_SizeChanged );
            this.LocationChanged += new System.EventHandler( this.FormMain_LocationChanged );

            updateLayout();

            Refresh();
#if DEBUG
            //VocaloSysUtil_DRAFT.getLanguageFromName( "" );
            /*ExpressionConfigSys exp_config_sys = new ExpressionConfigSys( @"C:\Program Files\VOCALOID2\expdbdir" );
            PortUtil.println( "vibrato:" );
            for ( Iterator itr = exp_config_sys.vibratoConfigIterator(); itr.hasNext(); ) {
                VibratoConfig vc = (VibratoConfig)itr.next();
                PortUtil.println( "file=" + vc.file );
            }
            PortUtil.println( "attack:" );
            for ( Iterator itr = exp_config_sys.attackConfigIterator(); itr.hasNext(); ) {
                AttackConfig ac = (AttackConfig)itr.next();
                PortUtil.println( "file=" + ac.file );
            }

            byte[] dat = BitConverter.GetBytes( 4 );
            using ( StreamWriter sw = new StreamWriter( @"C:\get_bytes.txt" ) ) {
                for ( int i = 0; i < dat.Length; i++ ) {
                    sw.WriteLine( dat[i] );
                }
            }
            using ( TextMemoryStream tms = new TextMemoryStream( @"C:\a.txt", Encoding.ASCII ) ) {
                tms.rewind();
                while ( tms.peek() >= 0 ) {
                    PortUtil.println( tms.readLine() );
                }
            }
            WaveDrawContext wdc = new WaveDrawContext( @"C:\ぴょ.wav" );
            using ( Bitmap b = new Bitmap( 500, 200 ) ) {
                using ( Graphics g = Graphics.FromImage( b ) ) {
                    wdc.Draw( g, Pens.Black, new Rectangle( 0, 0, 500, 200 ), 0.0f, 0.5f );
                }
                b.Save( @"C:\ぴょ.wav.png", System.Drawing.Imaging.ImageFormat.Png );
            }
            try {
                UtauFreq uf = UtauFreq.FromFrq( @"C:\あ_wav.frq" );
                uf.Write( new FileStream( @"C:\regenerated.frq", FileMode.Create, FileAccess.Write ) );
            } catch {
            }*/
            menuHidden.Visible = true;
            /*using ( StreamWriter sw = new StreamWriter( PortUtil.combinePath( Application.StartupPath, "Keys.txt" ) ) ) {
                foreach ( Keys key in Enum.GetValues( typeof( Keys ) ) ) {
                    sw.WriteLine( (int)key + "\t" + key.ToString() );
                }
            }*/
            /*OpenFileDialog ofd = new OpenFileDialog();
            XmlSerializer xs = new XmlSerializer( typeof( VsqFileEx ) );
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFileEx vsq = new VsqFileEx( ofd.FileName );
                vsq.Track.get( 1 ).getEvent( 1 ).UstEvent = new UstEvent();
                using ( FileStream fs = new FileStream( ofd.FileName + "_regen.xml", FileMode.Create ) ) {
                    xs.Serialize( fs, vsq );
                }
            }*/
            /*Cursor c = SynthCursor( Properties.Resources.arrow_135 );
            if ( c != null ) {
                HAND = c;
            }*/
            /*MessageBody mb = new MessageBody( "ja", PortUtil.combinePath( Application.StartupPath, "ja.po" ) );
            mb.Write( PortUtil.combinePath( Application.StartupPath, "foo.po" ) );*/
            /*OpenFileDialog ofd = new OpenFileDialog();
            Wave.TestEnabled = true;
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                String file = PortUtil.combinePath( Path.GetDirectoryName( ofd.FileName ), PortUtil.getFileNameWithoutExtension( ofd.FileName ) + ".txt" );
                using ( StreamWriter sw = new StreamWriter( file ) )
                using ( Wave w = new Wave( ofd.FileName ) ) {
                    w.TrimSilence();
                    int WID = 2048;
                    double[] wind = new double[WID];
                    for ( int j = 0; j < WID; j++ ) {
                        wind[j] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)j / (double)WID );
                    }
                    uint i = w.SampleRate;
                    //for ( uint i = 0; i < w.TotalSamples; i+=10 ) {
                        double f0 = w.TEST_GetF0( i, wind );
                        double n = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69.0;
                        sw.WriteLine( i / (double)w.SampleRate + "\t" + n + "\t" + f0 );
                    //}
                }
            }*/
            /*bocoree.debug.push_log( "installed singers 1" );
            SingerConfig[] s1 = VocaloSysUtil.getInstalledSingers1();
            foreach ( SingerConfig sc in s1 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            bocoree.debug.push_log( "installed singers 2" );
            SingerConfig[] s2 = VocaloSysUtil.getInstalledSingers2();
            foreach ( SingerConfig sc in s2 ) {
                bocoree.debug.push_log( "    " + sc );
            }
            if ( AppManager.EditorConfig.PathUtauVSTi != "" ) {
                bocoree.debug.push_log( "installed singers utau" );
                UtauSingerConfigSys uscs = new UtauSingerConfigSys( Path.GetDirectoryName( AppManager.EditorConfig.PathUtauVSTi ) );
                s2 = uscs.getInstalledSingers();
                foreach ( SingerConfig sc in s2 ) {
                    bocoree.debug.push_log( "    " + sc );
                }
            }
            PortUtil.println( VocaloSysUtil.getLanguage2( 0 ) );*/

            /*OpenFileDialog ofd = new OpenFileDialog();
                const String format = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2} 0x{4:X2}";
                const String format0 = "    {0,8} 0x{1:X4} {2,-32} 0x{3:X2}";
            while ( ofd.ShowDialog() == DialogResult.OK ) {
                VsqFile vf = new VsqFile( ofd.FileName );
                vf.getTrack( 1 ).getCommon().Version = "UTU000";
                VsqNrpn[] nrpns = VsqFile.generateNRPN( vf, 1, 500 );
                String file = PortUtil.combinePath( Path.GetDirectoryName( ofd.FileName ), PortUtil.getFileNameWithoutExtension( ofd.FileName ) + "_regen.txt" );
                using ( StreamWriter sw = new StreamWriter( file ) ) {
                    for ( int i = 0; i < nrpns.Length; i++ ) {
                        VsqNrpn vn = nrpns[i];
                        if ( vn.DataLsbSpecified ) {
                            sw.WriteLine( String.Format( format, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb, vn.DataLsb ) );
                        } else {
                            sw.WriteLine( String.Format( format0, vn.Clock, vn.Nrpn, NRPN.getName( vn.Nrpn ), vn.DataMsb ) );
                        }
                    }
                }
            }*/
            /*unsafe {
                WavePlay w = new WavePlay( 44100, 44100 );
                w.on_your_mark( new String[] { }, 0 );
                float* left = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float* right = (float*)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float ) * 10000 );
                float** buf = (float**)System.Runtime.InteropServices.Marshal.AllocHGlobal( sizeof( float* ) * 2 );
                buf[0] = left;
                buf[1] = right;
                float wv = 0.0f;
                for ( int i = 0; i < 10000; i++ ) {
                    wv += 0.002f;
                    if ( wv > 0.2f ) {
                        wv = -0.2f;
                    }
                    left[i] = wv;
                    right[i] = -wv;
                }
                for ( int i = 0; i < 100; i++ ) {
                    w.append( buf, 10000, 0.2, 0.2 );
                }
                w.flush_and_exit( 0.2, 0.2 );
                while ( w.is_alive() ) {
                }
            }*/
#endif
        }

        private void m_property_panel_container_StateChangeRequired( Object sender, PanelState arg ) {
            updatePropertyPanelState( arg );
        }

        private void m_note_proerty_dlg_CommandExecuteRequired( CadenciiCommand command ) {
#if DEBUG
            AppManager.debugWriteLine( "m_note_property_dlg_CommandExecuteRequired" );
#endif
            AppManager.register( AppManager.getVsqFile().executeCommand( command ) );
            updateDrawObjectList();
            refreshScreen();
            setEdited( true );
        }

        private void m_note_proerty_dlg_FormClosing( Object sender, FormClosingEventArgs e ) {
            if ( e.CloseReason == CloseReason.UserClosing ) {
                e.Cancel = true;
                updatePropertyPanelState( PanelState.Hidden );
            }
        }

        private void m_note_proerty_dlg_LocationOrSizeChanged( Object sender, BEventArgs e ) {
#if DEBUG
            PortUtil.println( "m_note_proeprty_dlg_LocationOrSizeChanged; WindowState=" + AppManager.propertyWindow.WindowState );
#endif
            if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window ) {
                if ( AppManager.propertyWindow.WindowState == FormWindowState.Minimized ) {
                    updatePropertyPanelState( PanelState.Docked );
                } else {
                    Point parent = this.getLocation();
                    Point proeprty = AppManager.propertyWindow.getLocation();
                    AppManager.editorConfig.PropertyWindowStatus.Bounds = new XmlRectangle( proeprty.x - parent.x,
                                                                                            proeprty.y - parent.y,
                                                                                            AppManager.propertyWindow.Width,
                                                                                            AppManager.propertyWindow.Height );
                }
            }
        }

        private void FormMain_LocationChanged( Object sender, BEventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.editorConfig.WindowRect = this.getBounds();
            }
        }

        private void FormMain_SizeChanged( Object sender, BEventArgs e ) {
            if ( this.WindowState == FormWindowState.Normal ) {
                AppManager.editorConfig.WindowRect = this.getBounds();
                AppManager.propertyWindow.WindowState = FormWindowState.Normal;
                AppManager.propertyWindow.Visible = AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window;
                AppManager.mixerWindow.Visible = AppManager.editorConfig.MixerVisible;
                updateLayout();
            } else if ( this.WindowState == FormWindowState.Minimized ) {
                AppManager.propertyWindow.Visible = false;
                AppManager.mixerWindow.Visible = false;
            } else if ( this.WindowState == FormWindowState.Maximized ) {
                AppManager.propertyWindow.WindowState = FormWindowState.Normal;
                AppManager.propertyWindow.Visible = AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window;
                AppManager.mixerWindow.Visible = AppManager.editorConfig.MixerVisible;
            }
        }

        private void FormMain_MouseWheel( Object sender, BMouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                hScroll.Value = computeScrollValueFromWheelDelta( e.Delta );
            } else {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            }
            refreshScreen();
        }

        private void FormMain_PreviewKeyDown( Object sender, PreviewKeyDownEventArgs e ) {
            BKeyEventArgs e0 = new KeyEventArgs( e.KeyData );
            processSpecialShortcutKey( e0, true );
        }

        private void FormMain_Deactivate( Object sender, BEventArgs e ) {
            m_form_activated = false;
        }

        private void FormMain_Activated( Object sender, BEventArgs e ) {
            m_form_activated = true;
        }
        #endregion

        private void m_timer_Tick( Object sender, BEventArgs e ) {
            if ( !m_form_activated ) {
                return;
            }
            try {
                DateTime now = DateTime.Now;
                byte[] buttons;
                int pov0;
#if !JAVA
                winmmhelp.JoyGetStatus( 0, out buttons, out pov0 );
#endif
                boolean event_processed = false;
                double dt_ms = now.Subtract( m_last_event_processed ).TotalMilliseconds;

                EditorConfig m = AppManager.editorConfig;
                boolean btn_x = (0 <= m.GameControlerCross && m.GameControlerCross < buttons.Length && buttons[m.GameControlerCross] > 0x00);
                boolean btn_o = (0 <= m.GameControlerCircle && m.GameControlerCircle < buttons.Length && buttons[m.GameControlerCircle] > 0x00);
                boolean btn_tr = (0 <= m.GameControlerTriangle && m.GameControlerTriangle < buttons.Length && buttons[m.GameControlerTriangle] > 0x00);
                boolean btn_re = (0 <= m.GameControlerRectangle && m.GameControlerRectangle < buttons.Length && buttons[m.GameControlerRectangle] > 0x00);
                boolean pov_r = pov0 == m.GameControlPovRight;
                boolean pov_l = pov0 == m.GameControlPovLeft;
                boolean pov_u = pov0 == m.GameControlPovUp;
                boolean pov_d = pov0 == m.GameControlPovDown;
                boolean L1 = (0 <= m.GameControlL1 && m.GameControlL1 < buttons.Length && buttons[m.GameControlL1] > 0x00);
                boolean R1 = (0 <= m.GameControlL2 && m.GameControlL2 < buttons.Length && buttons[m.GameControlR1] > 0x00);
                boolean L2 = (0 <= m.GameControlR1 && m.GameControlR1 < buttons.Length && buttons[m.GameControlL2] > 0x00);
                boolean R2 = (0 <= m.GameControlR2 && m.GameControlR2 < buttons.Length && buttons[m.GameControlR2] > 0x00);
                boolean SELECT = (0 <= m.GameControlSelect && m.GameControlSelect <= buttons.Length && buttons[m.GameControlSelect] > 0x00);
                if ( m_game_mode == GameControlMode.NORMAL ) {
                    m_last_btn_x = btn_x;

                    if ( !event_processed && !btn_o && m_last_btn_o ) {
                        if ( AppManager.isPlaying() ) {
                            timer.Stop();
                        }
                        AppManager.setPlaying( !AppManager.isPlaying() );
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_btn_o = btn_o;

                    if ( !event_processed && pov_r && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        forward();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_r = pov_r;

                    if ( !event_processed && pov_l && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        rewind();
                        m_last_event_processed = now;
                        event_processed = true;
                    }
                    m_last_pov_l = pov_l;

                    if ( !event_processed && pov_u && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value - AppManager.editorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll < vScroll.Minimum ) {
                            draft_vscroll = vScroll.Minimum;
                        }
                        vScroll.Value = draft_vscroll;
                        refreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && pov_d && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.Value + AppManager.editorConfig.PxTrackHeight * 3;
                        if ( draft_vscroll > vScroll.Maximum ) {
                            draft_vscroll = vScroll.Maximum;
                        }
                        vScroll.Value = draft_vscroll;
                        refreshScreen();
                        m_last_event_processed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.KEYBOARD;
                        stripLblGameCtrlMode.Text = m_game_mode.ToString();
                        stripLblGameCtrlMode.Image = Properties.Resources.piano;
                    }
                    m_last_select = SELECT;
                } else if ( m_game_mode == GameControlMode.KEYBOARD ) {
                    if ( !event_processed && !SELECT && m_last_select ) {
                        event_processed = true;
                        m_game_mode = GameControlMode.NORMAL;
                        updateGameControlerStatus( null, null );
                        m_last_select = SELECT;
                        return;
                    }
                    m_last_select = SELECT;
                    if ( L1 && R1 && L2 && R2 && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        if ( AppManager.isPlaying() ) {
                            AppManager.setEditMode( EditMode.NONE );
                            AppManager.setPlaying( false );
                            timer.Stop();
                        } else {
                            m_timer.Enabled = false;
                            FormRealtimeConfig frc = null;
                            try {
                                frc = new FormRealtimeConfig();
                                if ( frc.ShowDialog() == DialogResult.OK ) {
                                    AppManager.addingEvent = null;
                                    AppManager.setEditMode( EditMode.REALTIME );
                                    AppManager.editorConfig.RealtimeInputSpeed = frc.Speed;
                                    AppManager.setPlaying( true );
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                try {
#if !JAVA
                                    frc.Dispose();
#endif
                                } catch ( Exception ex2 ) {
                                }
                            }
                            m_timer.Enabled = true;
                        }
                        m_last_btn_o = btn_o;
                        m_last_btn_x = btn_x;
                        m_last_btn_re = btn_re;
                        m_last_btn_tr = btn_tr;
                        m_last_pov_l = pov_l;
                        m_last_pov_d = pov_d;
                        m_last_pov_r = pov_r;
                        m_last_pov_u = pov_u;
                        return;
                    }

                    int note = -1;
                    if ( pov_r && !m_last_pov_r ) {
                        note = 60;
                    } else if ( btn_re && !m_last_btn_re ) {
                        note = 62;
                    } else if ( btn_tr && !m_last_btn_tr ) {
                        note = 64;
                    } else if ( btn_o && !m_last_btn_o ) {
                        note = 65;
                    } else if ( btn_x && !m_last_btn_x ) {
                        note = 67;
                    } else if ( pov_u && !m_last_pov_u ) {
                        note = 59;
                    } else if ( pov_l && !m_last_pov_l ) {
                        note = 57;
                    } else if ( pov_d && !m_last_pov_d ) {
                        note = 55;
                    }
                    if ( note >= 0 ) {
                        if ( L1 ) {
                            note += 12;
                        } else if ( L2 ) {
                            note -= 12;
                        }
                        if ( R1 ) {
                            note += 1;
                        } else if ( R2 ) {
                            note -= 1;
                        }
                    }
                    m_last_btn_o = btn_o;
                    m_last_btn_x = btn_x;
                    m_last_btn_re = btn_re;
                    m_last_btn_tr = btn_tr;
                    m_last_pov_l = pov_l;
                    m_last_pov_d = pov_d;
                    m_last_pov_r = pov_r;
                    m_last_pov_u = pov_u;
                    if ( note >= 0 ) {
#if DEBUG
                        AppManager.debugWriteLine( "FormMain+m_timer_Tick" );
                        AppManager.debugWriteLine( "    note=" + note );
#endif
                        if ( AppManager.isPlaying() ) {
                            int clock = AppManager.getCurrentClock();
                            if ( AppManager.addingEvent != null ) {
                                AppManager.addingEvent.ID.Length = clock - AppManager.addingEvent.Clock;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( AppManager.getSelected(),
                                                                                                        AppManager.addingEvent ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                if ( !isEdited() ) {
                                    setEdited( true );
                                }
#if USE_DOBJ
                                updateDrawObjectList();
#endif
                            }
                            AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.addingEvent.ID.type = VsqIDType.Anote;
                            AppManager.addingEvent.ID.Dynamics = 64;
                            AppManager.addingEvent.ID.VibratoHandle = null;
                            AppManager.addingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                            AppManager.addingEvent.ID.Note = note;
                        }
                        if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                            MidiPlayer.PlayImmediate( (byte)note );
                        } else {
                            KeySoundPlayer.Play( note );
                        }
                    } else {
                        if ( AppManager.isPlaying() && AppManager.addingEvent != null ) {
                            AppManager.addingEvent.ID.Length = AppManager.getCurrentClock() - AppManager.addingEvent.Clock;
                        }
                    }
                }
            } catch ( Exception ex ) {
#if DEBUG
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
                m_game_mode = GameControlMode.DISABLED;
                updateGameControlerStatus( null, null );
                if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                    AppManager.setPlaying( false );
                    AppManager.setEditMode( EditMode.NONE );
                    AppManager.addingEvent = null;
                }
                m_timer.Stop();
            }
        }

        private void EditorConfig_QuantizeModeChanged( Object sender, BEventArgs e ) {
            applyQuantizeMode();
        }

        #region menuFile*
        private void menuFileSaveNamed_Click( Object sender, BEventArgs e ) {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.getVsqFile().Track.get( track ).getName()
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( saveXmlVsqDialog.FileName != "" ) {
                        fd.FileName = saveXmlVsqDialog.FileName;
                    }
                    fd.Filter = saveXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        saveXmlVsqDialog.FileName = fd.FileName;
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                dr = saveXmlVsqDialog.ShowDialog();
            }

            if ( dr == DialogResult.OK ) {
                String file = saveXmlVsqDialog.FileName;
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        private void commonFileSave_Click( Object sender, BEventArgs e ) {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        String.Format(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.getVsqFile().Track.get( track ).getName()
                        ),
                        _APP_NAME,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation );
                    return;
                }
            }
            String file = AppManager.getFileName();
            if ( AppManager.getFileName().Equals( "" ) ) {
                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.editorConfig.UseCustomFileDialog ) {
                    FileDialog fd = null;
                    try {
                        fd = new FileDialog( FileDialog.DialogMode.Open );
                        if ( saveXmlVsqDialog.FileName != "" ) {
                            fd.FileName = saveXmlVsqDialog.FileName;
                        }
                        fd.Filter = saveXmlVsqDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveXmlVsqDialog.FileName = fd.FileName;
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( fd != null ) {
                            try {
#if !JAVA
                                fd.Dispose();
#endif
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                } else {
                    dr = saveXmlVsqDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    file = saveXmlVsqDialog.FileName;
                }
            }
            if ( file != "" ) {
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        private void menuFileQuit_Click( Object sender, BEventArgs e ) {
            this.Close();
        }

        private void menuFileExportWave_Click( Object sender, BEventArgs e ) {
            DialogResult dr = DialogResult.Cancel;
            String filename = "";
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Save );
                    fd.Title = _( "Wave Export" );
                    try {
                        fd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch ( Exception ex ) {
                        fd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = fd.ShowDialog();
                    filename = fd.FileName;
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                SaveFileDialog sfd = null;
                try {
                    sfd = new SaveFileDialog();
                    sfd.Title = _( "Wave Export" );
                    try {
                        sfd.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
                    } catch ( Exception ex ) {
                        sfd.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
                    }
                    dr = sfd.ShowDialog();
                    filename = sfd.FileName;
                } catch ( Exception ex ) {
                } finally {
                    if ( sfd != null ) {
                        try {
#if !JAVA
                            sfd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            }

            if ( dr == DialogResult.OK ) {
                FormSynthesize fs = null;
                try {
                    fs = new FormSynthesize(
                    AppManager.getVsqFile(),
                    AppManager.editorConfig.PreSendTime,
                    new int[] { AppManager.getSelected() },
                    new String[] { filename },
                    AppManager.getVsqFile().TotalClocks + 240,
                    true );

                    DateTime started = DateTime.Now;
                    fs.ShowDialog();
#if DEBUG
                    bocoree.debug.push_log( "elapsed time=" + DateTime.Now.Subtract( started ).TotalSeconds + "sec" );
#endif
                } catch ( Exception ex ) {
                } finally {
                    if ( fs != null ) {
                        try {
#if !JAVA
                            fs.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            }
        }

        private void menuFileExport_DropDownOpening( Object sender, BEventArgs e ) {
            menuFileExportWave.Enabled = (AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount() > 0) && VSTiProxy.CurrentUser.Equals( "" );
        }

        private void menuFileImportMidi_Click( Object sender, BEventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.IMPORT );

            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    Point p = getFormPreferedLocation( fd );
                    fd.setLocation( p );
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                dr = openMidiDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            MidiFile mf = null;
            try {
                mf = new MidiFile( openMidiDialog.FileName );
            } catch ( Exception ex ) {
                AppManager.showMessageBox( _( "Invalid MIDI file." ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                return;
            }
            if ( mf == null ) {
                AppManager.showMessageBox( _( "Invalid MIDI file." ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                return;
            }
            int count = mf.getTrackCount();
            for ( int i = 0; i < count; i++ ) {
                String track_name = "";
                int notes = 0;
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                int events_count = events.size();

                // トラック名を取得
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( item.firstByte == 0xff && item.data.Length >= 2 && item.data[0] == 0x03 ) {
                        track_name = PortUtil.getDecodedString( "Shift_JIS", item.data, 1, item.data.Length - 1 );
                        break;
                    }
                }

                // イベント数を数える
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( (item.firstByte & 0xf0) == 0x90 && item.data.Length > 1 && item.data[1] > 0x00 ) {
                        notes++;
                    }
                }
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new String[] { i.ToString(), track_name, notes.ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[i].Checked = true;
            }

            if ( m_midi_imexport_dialog.ShowDialog() != DialogResult.OK ) {
                return;
            }

            // インポートするしないにかかわらずテンポと拍子を取得
            VsqFileEx tempo = new VsqFileEx( "Miku", 2, 4, 4, 500000 ); //テンポリスト用のVsqFile。テンポの部分のみ使用
            tempo.executeCommand( VsqCommand.generateCommandChangePreMeasure( 0 ) );
            boolean tempo_added = false;
            boolean timesig_added = false;
            tempo.TempoTable.clear();
            tempo.TimesigTable.clear();
            int mf_getTrackCount = mf.getTrackCount();
            for ( int i = 0; i < mf_getTrackCount; i++ ) {
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                boolean t_tempo_added = false;   //第iトラックからテンポをインポートしたかどうか
                boolean t_timesig_added = false; //第iトラックから拍子をインポートしたかどうか
                int last_timesig_clock = 0; // 最後に拍子変更を検出したゲートタイム
                int last_num = 4; // 最後に検出した拍子変更の分子
                int last_den = 4; // 最後に検出した拍子変更の分母
                int last_barcount = 0;
                int events_Count = events.size();
                for ( int j = 0; j < events_Count; j++ ) {
                    MidiEvent itemj = events.get( j );
                    if ( !tempo_added && itemj.firstByte == 0xff && itemj.data.Length >= 4 && itemj.data[0] == 0x51 ) {
                        boolean contains_same_clock = false;
                        int size = tempo.TempoTable.size();
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TempoTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            int vtempo = itemj.data[1] << 16 | itemj.data[2] << 8 | itemj.data[3];
                            tempo.TempoTable.add( new TempoTableEntry( (int)itemj.clock, vtempo, 0.0 ) );
                            t_tempo_added = true;
                        }
                    }
                    if ( !timesig_added && itemj.firstByte == 0xff && itemj.data.Length >= 5 && itemj.data[0] == 0x58 ) {
                        int num = itemj.data[1];
                        int den = 1;
                        for ( int k = 0; k < itemj.data[2]; k++ ) {
                            den = den * 2;
                        }
                        int clock_per_bar = last_num * 480 * 4 / last_den;
                        int barcount_at_itemj = last_barcount + ((int)itemj.clock - last_timesig_clock) / clock_per_bar;
                        int size = tempo.TimesigTable.size();
                        boolean contains_same_clock = false;
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TimesigTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            tempo.TimesigTable.add( new TimeSigTableEntry( (int)itemj.clock, num, den, barcount_at_itemj ) );
                            last_timesig_clock = (int)itemj.clock;
                            last_den = den;
                            last_num = num;
                            last_barcount = barcount_at_itemj;
                            t_timesig_added = true;
                        }
                    }
                }
                if ( t_tempo_added ) {
                    tempo_added = true;
                }
                if ( t_timesig_added ) {
                    timesig_added = true;
                }
                if ( timesig_added && tempo_added ) {
                    // 両方ともインポート済みならexit。2個以上のトラックから、重複してテンポや拍子をインポートするのはNG（たぶん）
                    break;
                }
            }
            boolean contains_zero = false;
            int c = tempo.TempoTable.size();
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TempoTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TempoTable.add( new TempoTableEntry( 0, 500000, 0.0 ) );
            }
            contains_zero = false;
            // =>
            // Thanks, げっぺータロー.
            // BEFORE:
            // c = tempo.TempoTable.size();
            // AFTER:
            c = tempo.TimesigTable.size();
            // <=
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TimesigTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TimesigTable.add( new TimeSigTableEntry( 0, 4, 4, 0 ) );
            }
            VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone(); //後でReplaceコマンドを発行するための作業用
            double sec_at_premeasure = work.getSecFromClock( work.getPreMeasureClocks() );
            if ( !m_midi_imexport_dialog.isPreMeasure() ) {
                sec_at_premeasure = 0.0;
            }
            VsqFileEx copy_src = (VsqFileEx)tempo.clone();
            if ( sec_at_premeasure != 0.0 ) {
                int t = work.TempoTable.get( 0 ).Tempo;
                VsqFileEx.shift( copy_src, sec_at_premeasure, t );
            }
            tempo.updateTempoInfo();
            tempo.updateTimesigInfo();

            // tempoをインポート
            boolean import_tempo = m_midi_imexport_dialog.isTempo();
            if ( import_tempo ) {
                // 最初に、workにある全てのイベント・コントロールカーブ・ベジエ曲線をtempoのテンポテーブルに合うように、シフトする
                shiftClockToMatchWith( work, copy_src, sec_at_premeasure );

                work.TempoTable.clear();
                Vector<TempoTableEntry> list = copy_src.TempoTable;
                int list_count = list.size();
                for ( int i = 0; i < list_count; i++ ) {
                    TempoTableEntry item = list.get( i );
                    work.TempoTable.add( new TempoTableEntry( item.Clock, item.Tempo, item.Time ) );
                }
                work.updateTempoInfo();
            }

            // timesig
            if ( m_midi_imexport_dialog.isTimesig() ) {
                work.TimesigTable.clear();
                Vector<TimeSigTableEntry> list = tempo.TimesigTable;
                int list_count = list.size();
                for ( int i = 0; i < list_count; i++ ) {
                    TimeSigTableEntry item = list.get( i );
                    work.TimesigTable.add( new TimeSigTableEntry( item.Clock,
                                                                  item.Numerator,
                                                                  item.Denominator,
                                                                  item.BarCount ) );
                }
                Collections.sort( work.TimesigTable );
                work.updateTimesigInfo();
            }

            for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                if ( !m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                    continue;
                }
                if ( work.Track.size() + 1 > 16 ) {
                    break;
                }
                VsqTrack work_track = new VsqTrack( m_midi_imexport_dialog.ListTrack.Items[i].SubItems[1].Text, "Miku" );

                // デフォルトの音声合成システムに切り替え
                RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
                String renderer = AppManager.getVersionStringFromRendererKind( kind );
                Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
                work_track.changeRenderer( renderer, singers );
                
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                Collections.sort( events );
                int events_count = events.size();

                // note
                if ( m_midi_imexport_dialog.isNotes() ) {
                    int[] onclock_each_note = new int[128];
                    int[] velocity_each_note = new int[128];
                    for ( int j = 0; j < 128; j++ ) {
                        onclock_each_note[j] = -1;
                        velocity_each_note[j] = 64;
                    }
                    int last_note = -1;
                    for ( int j = 0; j < events_count; j++ ) {
                        MidiEvent itemj = events.get( j );
                        int not_closed_note = -1;
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            for ( int m = 0; m < 128; m++ ) {
                                if ( onclock_each_note[m] >= 0 ) {
                                    not_closed_note = m;
                                    break;
                                }
                            }
                        }
                        if ( ((itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] == 0) ||
                             ((itemj.firstByte & 0xf0) == 0x80 && itemj.data.Length >= 2) ||
                             not_closed_note >= 0 ) {
                            int clock_off = (int)itemj.clock;
                            int note = (int)itemj.data[0];
                            if ( not_closed_note >= 0 ) {
                                note = not_closed_note;
                            }
                            if ( onclock_each_note[note] >= 0 ) {
                                double time_clock_on = tempo.getSecFromClock( onclock_each_note[note] ) + sec_at_premeasure;
                                double time_clock_off = tempo.getSecFromClock( clock_off ) + sec_at_premeasure;
                                int add_clock_on = (int)work.getClockFromSec( time_clock_on );
                                int add_clock_off = (int)work.getClockFromSec( time_clock_off );
                                VsqID vid = new VsqID( 0 );
                                vid.type = VsqIDType.Anote;
                                vid.Length = add_clock_off - add_clock_on;
                                String phrase = "a";
                                if ( m_midi_imexport_dialog.isLyric() ) {
                                    for ( int k = 0; k < events_count; k++ ) {
                                        MidiEvent itemk = events.get( k );
                                        if ( onclock_each_note[note] <= (int)itemk.clock && (int)itemk.clock <= clock_off ) {
                                            if ( itemk.firstByte == 0xff && itemk.data.Length >= 2 && itemk.data[0] == 0x05 ) {
                                                phrase = PortUtil.getDecodedString( "Shift_JIS", itemk.data, 1, itemk.data.Length - 1 );
                                                break;
                                            }
                                        }
                                    }
                                }
                                vid.LyricHandle = new LyricHandle( phrase, "a" );
                                vid.Note = note;
                                vid.Dynamics = velocity_each_note[note];
                                vid.DEMaccent = 50;
                                vid.DEMdecGainRate = 50;

                                // ビブラート
                                if ( AppManager.editorConfig.EnableAutoVibrato ) {
                                    int note_length = vid.Length;
                                    // 音符位置での拍子を調べる
                                    Timesig timesig = work.getTimesigAt( add_clock_on );

                                    // ビブラートを自動追加するかどうかを決める閾値
                                    int autovib = AutoVibratoMinLengthUtil.getValue( AppManager.editorConfig.AutoVibratoMinimumLength );
                                    int threshold = 480 * 4 / timesig.denominator * autovib;
                                    if ( note_length >= threshold ) {
                                        int vibrato_clocks = 0;
                                        DefaultVibratoLength vib_length = AppManager.editorConfig.DefaultVibratoLength;
                                        if ( vib_length == DefaultVibratoLength.L100 ) {
                                            vibrato_clocks = note_length;
                                        } else if ( vib_length == DefaultVibratoLength.L50 ) {
                                            vibrato_clocks = note_length / 2;
                                        } else if ( vib_length == DefaultVibratoLength.L66 ) {
                                            vibrato_clocks = note_length * 2 / 3;
                                        } else if ( vib_length == DefaultVibratoLength.L75 ) {
                                            vibrato_clocks = note_length * 3 / 4;
                                        }
                                        // とりあえずVOCALOID2のデフォルトビブラートの設定を使用
                                        vid.VibratoHandle = VocaloSysUtil.getDefaultVibratoHandle( AppManager.editorConfig.AutoVibratoType2,
                                                                                                   vibrato_clocks,
                                                                                                   SynthesizerType.VOCALOID2 );
                                        vid.VibratoDelay = note_length - vibrato_clocks;
                                        //vid.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                                        //vid.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                                    }
                                }

                                VsqEvent ve = new VsqEvent( add_clock_on, vid );
                                work_track.addEvent( ve );
                                onclock_each_note[note] = -1;
                            }
                        }
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            int note = itemj.data[0];
                            onclock_each_note[note] = (int)itemj.clock;
                            int vel = itemj.data[1];
                            velocity_each_note[note] = vel;
                            last_note = note;
                        }
                    }

                    int track = work.Track.size();
                    CadenciiCommand run_add = VsqFileEx.generateCommandAddTrack( work_track,
                                                                                 new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                                 track,
                                                                                 new BezierCurves() );
                    work.executeCommand( run_add );
                }
            }

            CadenciiCommand lastrun = VsqFileEx.generateCommandReplace( work );
            AppManager.register( AppManager.getVsqFile().executeCommand( lastrun ) );
            setEdited( true );
            refreshScreen();
        }

        private void menuFileExportMidi_Click( Object sender, BEventArgs e ) {
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().clone();

            for ( int i = 0; i < vsq.Track.size(); i++ ) {
                VsqTrack track = vsq.Track.get( i );
                int notes = 0;
                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent obj = itr.next();
                    notes++;
                }
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new String[] { i.ToString(), track.getName(), notes.ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[i].Checked = true;// i != 0;
            }
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.EXPORT );
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            if ( m_midi_imexport_dialog.ShowDialog() == DialogResult.OK ) {
                if ( !m_midi_imexport_dialog.isPreMeasure() ) {
                    vsq.removePart( 0, vsq.getPreMeasureClocks() );
                }
                int track_count = 0;
                for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                    if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                        track_count++;
                    }
                }
                if ( track_count == 0 ) {
                    return;
                }

                DialogResult dr = DialogResult.Cancel;
                if ( AppManager.editorConfig.UseCustomFileDialog ) {
                    FileDialog fd = null;
                    try {
                        fd = new FileDialog( FileDialog.DialogMode.Save );
                        if ( saveMidiDialog.FileName != "" ) {
                            fd.FileName = saveMidiDialog.FileName;
                        }
                        fd.Filter = saveMidiDialog.Filter;
                        dr = fd.ShowDialog();
                        if ( dr == DialogResult.OK ) {
                            saveMidiDialog.FileName = fd.FileName;
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( fd != null ) {
                            try {
#if !JAVA
                                fd.Dispose();
#endif
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                } else {
                    dr = saveMidiDialog.ShowDialog();
                }

                if ( dr == DialogResult.OK ) {
                    //System.Text.Encoding def_enc = System.Text.Encoding.GetEncoding( 0 ); // システムのデフォルトエンコーディング
                    RandomAccessFile fs = null;
                    try {
                        fs = new RandomAccessFile( saveMidiDialog.FileName, "rw" );
                        // ヘッダー
                        fs.write( new byte[] { 0x4d, 0x54, 0x68, 0x64 }, 0, 4 );
                        //データ長
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x06 );
                        //フォーマット
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x01 );
                        //トラック数
                        VsqFile.writeUnsignedShort( fs, (ushort)track_count );
                        //時間単位
                        fs.write( (byte)0x01 );
                        fs.write( (byte)0xe0 );
                        int count = -1;
                        for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                            if ( !m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                                continue;
                            }
                            VsqTrack track = vsq.Track.get( i );
                            count++;
                            fs.write( new byte[] { 0x4d, 0x54, 0x72, 0x6b }, 0, 4 );
                            //データ長。とりあえず0を入れておく
                            fs.write( new byte[] { 0x00, 0x00, 0x00, 0x00 }, 0, 4 );
                            long first_position = fs.getFilePointer();
                            //トラック名
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );//デルタタイム
                            fs.write( (byte)0xff );//ステータスタイプ
                            fs.write( (byte)0x03 );//イベントタイプSequence/Track Name
                            byte[] track_name = PortUtil.getEncodedByte( "Shift_JIS", track.getName() );
                            fs.write( (byte)track_name.Length );
                            fs.write( track_name, 0, track_name.Length );

                            Vector<MidiEvent> events = new Vector<MidiEvent>();

                            // tempo
                            boolean print_tempo = m_midi_imexport_dialog.isTempo();
                            if ( print_tempo && count == 0 ) {
                                Vector<MidiEvent> tempo_events = vsq.generateTempoChange();
                                for ( int j = 0; j < tempo_events.size(); j++ ) {
                                    events.add( tempo_events.get( j ) );
                                }
                            }

                            // timesig
                            if ( m_midi_imexport_dialog.isTimesig() && count == 0 ) {
                                Vector<MidiEvent> timesig_events = vsq.generateTimeSig();
                                for ( int j = 0; j < timesig_events.size(); j++ ) {
                                    events.add( timesig_events.get( j ) );
                                }
                            }

                            // Notes
                            if ( m_midi_imexport_dialog.isNotes() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    int clock_off = ve.Clock + ve.ID.Length;
                                    if ( !print_tempo ) {
                                        // テンポを出力しない場合、テンポを500000（120）と見なしてクロックを再計算
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        double time_off = vsq.getSecFromClock( clock_off );
                                        clock_on = (int)(960.0 * time_on);
                                        clock_off = (int)(960.0 * time_off);
                                    }
                                    MidiEvent noteon = new MidiEvent();
                                    noteon.clock = clock_on;
                                    noteon.firstByte = 0x90;
                                    noteon.data = new byte[2];
                                    noteon.data[0] = (byte)ve.ID.Note;
                                    noteon.data[1] = (byte)ve.ID.Dynamics;
                                    events.add( noteon );
                                    MidiEvent noteoff = new MidiEvent();
                                    noteoff.clock = clock_off;
                                    noteoff.firstByte = 0x80;
                                    noteoff.data = new byte[2];
                                    noteoff.data[0] = (byte)ve.ID.Note;
                                    noteoff.data[1] = 0x7f;
                                    events.add( noteoff );
                                }
                            }

                            // lyric
                            if ( m_midi_imexport_dialog.isLyric() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    if ( !print_tempo ) {
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        clock_on = (int)(960.0 * time_on);
                                    }
                                    MidiEvent add = new MidiEvent();
                                    add.clock = clock_on;
                                    add.firstByte = 0xff;
                                    byte[] lyric = PortUtil.getEncodedByte( "Shift_JIS", ve.ID.LyricHandle.L0.Phrase );
                                    add.data = new byte[lyric.Length + 1];
                                    add.data[0] = 0x05;
                                    for ( int j = 0; j < lyric.Length; j++ ) {
                                        add.data[j + 1] = lyric[j];
                                    }
                                    events.add( add );
                                }
                            }

                            // vocaloid metatext
                            Vector<MidiEvent> meta;
                            if ( m_midi_imexport_dialog.isVocaloidMetatext() && i > 0 ) {
                                meta = vsq.generateMetaTextEvent( i, "Shift_JIS" );
                            } else {
                                meta = new Vector<MidiEvent>();
                            }

                            // vocaloid nrpn
                            Vector<MidiEvent> vocaloid_nrpn_midievent;
                            if ( m_midi_imexport_dialog.isVocaloidNrpn() && i > 0 ) {
                                VsqNrpn[] vsqnrpn = VsqFileEx.generateNRPN( (VsqFile)vsq, i, AppManager.editorConfig.PreSendTime );
                                NrpnData[] nrpn = VsqNrpn.convert( vsqnrpn );

                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                                for ( int j = 0; j < nrpn.Length; j++ ) {
                                    MidiEvent me = new MidiEvent();
                                    me.clock = nrpn[j].getClock();
                                    me.firstByte = 0xb0;
                                    me.data = new byte[2];
                                    me.data[0] = nrpn[j].getParameter();
                                    me.data[1] = nrpn[j].Value;
                                    vocaloid_nrpn_midievent.add( me );
                                }
                            } else {
                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                            }
#if DEBUG
                            PortUtil.println( "menuFileExportMidi_Click" );
                            PortUtil.println( "    vocaloid_nrpn_midievent.size()=" + vocaloid_nrpn_midievent.size() );
#endif

                            // midi eventを出力
                            Collections.sort( events );
                            long last_clock = 0;
                            int events_count = events.size();
                            if ( events_count > 0 ) {
                                for ( int j = 0; j < events_count; j++ ) {
                                    if ( events.get( j ).clock > 0 && meta.size() > 0 ) {
                                        for ( int k = 0; k < meta.size(); k++ ) {
                                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                            meta.get( k ).writeData( fs );
                                        }
                                        meta.clear();
                                        last_clock = 0;
                                    }
                                    long clock = events.get( j ).clock;
                                    while ( vocaloid_nrpn_midievent.size() > 0 && vocaloid_nrpn_midievent.get( 0 ).clock < clock ) {
                                        VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(vocaloid_nrpn_midievent.get( 0 ).clock - last_clock) );
                                        last_clock = vocaloid_nrpn_midievent.get( 0 ).clock;
                                        vocaloid_nrpn_midievent.get( 0 ).writeData( fs );
                                        vocaloid_nrpn_midievent.removeElementAt( 0 );
                                    }
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(events.get( j ).clock - last_clock) );
                                    events.get( j ).writeData( fs );
                                    last_clock = events.get( j ).clock;
                                }
                            } else {
                                int c = vocaloid_nrpn_midievent.size();
                                for ( int k = 0; k < meta.size(); k++ ) {
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                    meta.get( k ).writeData( fs );
                                }
                                meta.clear();
                                last_clock = 0;
                                for ( int j = 0; j < c; j++ ) {
                                    MidiEvent item = vocaloid_nrpn_midievent.get( j );
                                    long clock = item.clock;
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(clock - last_clock) );
                                    item.writeData( fs );
                                    last_clock = clock;
                                }
                            }

                            // トラックエンドを記入し、
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)0 );
                            fs.write( (byte)0xff );
                            fs.write( (byte)0x2f );
                            fs.write( (byte)0x00 );
                            // チャンクの先頭に戻ってチャンクのサイズを記入
                            long pos = fs.getFilePointer();
                            fs.seek( first_position - 4 );
                            VsqFile.writeUnsignedInt( fs, (uint)(pos - first_position) );
                            // ファイルを元の位置にseek
                            fs.seek( pos );
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( fs != null ) {
                            try {
                                fs.close();
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                }
            }
        }

        private void menuFileOpenVsq_Click( Object sender, BEventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }

            DialogResult dr = DialogResult.Cancel;
            int filterindex = 1;
            if ( AppManager.editorConfig.LastUsedExtension.Equals( ".vsq" ) ) {
                filterindex = 2;
            }
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    fd.FilterIndex = filterindex;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                        if ( fd.FilterIndex == 1 ) {
                            AppManager.editorConfig.LastUsedExtension = ".mid";
                        } else if ( fd.FilterIndex == 2 ) {
                            AppManager.editorConfig.LastUsedExtension = ".vsq";
                        }
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                openMidiDialog.FilterIndex = filterindex;
                dr = openMidiDialog.ShowDialog();
                if ( dr == DialogResult.OK ) {
#if DEBUG
                    AppManager.debugWriteLine( "openMidiDialog.FilterIndex=" + openMidiDialog.FilterIndex );
#endif
                    if ( openMidiDialog.FilterIndex == 1 ) {
                        AppManager.editorConfig.LastUsedExtension = ".mid";
                    } else if ( openMidiDialog.FilterIndex == 2 ) {
                        AppManager.editorConfig.LastUsedExtension = ".vsq";
                    }
                }
            }
            if ( dr != DialogResult.OK ) {
                return;
            }
            try {
                VsqFileEx vsq = new VsqFileEx( openMidiDialog.FileName, "Shift_JIS" );
                AppManager.setVsqFile( vsq );
            } catch ( Exception ex ) {
#if DEBUG
                PortUtil.println( "FormMain#menuFileOpenVsq_Click; ex=" + ex );
#endif
                AppManager.showMessageBox( _( "Invalid VSQ/VOCALOID MIDI file" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                return;
            }
            AppManager.setSelected( 1 );
            clearExistingData();
            setEdited( false );
            AppManager.mixerWindow.updateStatus();
            clearTempWave();
#if USE_DOBJ
            updateDrawObjectList();
#endif
            refreshScreen();
        }

        private void menuFileOpenUst_Click( Object sender, BEventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( openUstDialog.FileName != "" ) {
                        fd.FileName = openUstDialog.FileName;
                    }
                    fd.Filter = openUstDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openUstDialog.FileName = fd.FileName;
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                dr = openUstDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }

            try {
                UstFile ust = new UstFile( openUstDialog.FileName );
                VsqFileEx vsq = new VsqFileEx( ust );
                clearExistingData();
                AppManager.setVsqFile( vsq );
                setEdited( false );
                AppManager.mixerWindow.updateStatus();
                clearTempWave();
#if USE_DOBJ
                updateDrawObjectList();
#endif
                refreshScreen();
            } catch ( Exception ex ) {
            }
        }

        private void menuFileImportVsq_Click( Object sender, BEventArgs e ) {
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( openMidiDialog.FileName != "" ) {
                        fd.FileName = openMidiDialog.FileName;
                    }
                    fd.Filter = openMidiDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openMidiDialog.FileName = fd.FileName;
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            } else {
                dr = openMidiDialog.ShowDialog();
            }

            if ( dr != DialogResult.OK ) {
                return;
            }
            VsqFileEx vsq = null;
            try {
                vsq = new VsqFileEx( openMidiDialog.FileName, "Shift_JIS" );
            } catch ( Exception ex ) {
                AppManager.showMessageBox( _( "Invalid VSQ/VOCALOID MIDI file" ), _( "Error" ), MessageBoxButtons.OK, MessageBoxIcon.Exclamation );
                return;
            }
            if ( m_midi_imexport_dialog == null ) {
                m_midi_imexport_dialog = new FormMidiImExport();
            }
            m_midi_imexport_dialog.ListTrack.Items.Clear();
            for ( int track = 1; track < vsq.Track.size(); track++ ) {
                m_midi_imexport_dialog.ListTrack.Items.Add( new ListViewItem( new String[] { track.ToString(), 
                                                                                             vsq.Track.get( track ).getName(),
                                                                                             vsq.Track.get( track ).getEventCount().ToString() } ) );
                m_midi_imexport_dialog.ListTrack.Items[track - 1].Checked = true;
            }
            m_midi_imexport_dialog.setMode( FormMidiImExport.FormMidiMode.IMPORT_VSQ );
            m_midi_imexport_dialog.setTempo( false );
            m_midi_imexport_dialog.setTimesig( false );
            m_midi_imexport_dialog.setLocation( getFormPreferedLocation( m_midi_imexport_dialog ) );
            if ( m_midi_imexport_dialog.ShowDialog() != DialogResult.OK ) {
                return;
            }

            Vector<Integer> add_track = new Vector<Integer>();
            for ( int i = 0; i < m_midi_imexport_dialog.ListTrack.Items.Count; i++ ) {
                if ( m_midi_imexport_dialog.ListTrack.Items[i].Checked ) {
                    add_track.add( i + 1 );
                }
            }
            if ( add_track.size() <= 0 ) {
                return;
            }

            VsqFileEx replace = (VsqFileEx)AppManager.getVsqFile().Clone();
            double premeasure_sec_replace = replace.getSecFromClock( replace.getPreMeasureClocks() );
            double premeasure_sec_vsq = vsq.getSecFromClock( vsq.getPreMeasureClocks() );

            if ( m_midi_imexport_dialog.isTempo() ) {
                shiftClockToMatchWith( replace, vsq, premeasure_sec_replace - premeasure_sec_vsq );
                // テンポテーブルを置き換え
                replace.TempoTable.clear();
                for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                    replace.TempoTable.add( (TempoTableEntry)vsq.TempoTable.get( i ).clone() );
                }
                replace.updateTempoInfo();
                replace.updateTotalClocks();
            }

            if ( m_midi_imexport_dialog.isTimesig() ) {
                // 拍子をリプレースする場合
                replace.TimesigTable.clear();
                for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                    replace.TimesigTable.add( (TimeSigTableEntry)vsq.TimesigTable.get( i ).clone() );
                }
                replace.updateTimesigInfo();
            }

            for ( Iterator<Integer> itr = add_track.iterator(); itr.hasNext(); ) {
                int track = itr.next();
                if ( replace.Track.size() + 1 >= 16 ) {
                    break;
                }
                if ( !m_midi_imexport_dialog.isTempo() ) {
                    // テンポをリプレースしない場合。インポートするトラックのクロックを調節する
                    for ( Iterator<VsqEvent> itr2 = vsq.Track.get( track ).getEventIterator(); itr2.hasNext(); ) {
                        VsqEvent item = itr2.next();
                        if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                            continue;
                        }
                        int clock = item.Clock;
                        double sec_start = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                        double sec_end = vsq.getSecFromClock( clock + item.ID.Length ) - premeasure_sec_vsq + premeasure_sec_replace;
                        int clock_start = (int)replace.getClockFromSec( sec_start );
                        int clock_end = (int)replace.getClockFromSec( sec_end );
                        item.Clock = clock_start;
                        item.ID.Length = clock_end - clock_start;
                        if ( item.ID.VibratoHandle != null ) {
                            double sec_vib_start = vsq.getSecFromClock( clock + item.ID.VibratoDelay ) - premeasure_sec_vsq + premeasure_sec_replace;
                            int clock_vib_start = (int)replace.getClockFromSec( sec_vib_start );
                            item.ID.VibratoDelay = clock_vib_start - clock_start;
                            item.ID.VibratoHandle.Length = clock_end - clock_vib_start;
                        }
                    }

                    // コントロールカーブをシフト
                    foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                        VsqBPList item = vsq.Track.get( track ).getCurve( ct.getName() );
                        if ( item == null ) {
                            continue;
                        }
                        VsqBPList repl = new VsqBPList( item.getDefault(), item.getMinimum(), item.getMaximum() );
                        for ( int i = 0; i < item.size(); i++ ) {
                            int clock = item.getKeyClock( i );
                            int value = item.getElement( i );
                            double sec = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                            if ( sec >= premeasure_sec_replace ) {
                                int clock_new = (int)replace.getClockFromSec( sec );
                                repl.add( clock_new, value );
                            }
                        }
                        vsq.Track.get( track ).setCurve( ct.getName(), repl );
                    }

                    // ベジエカーブをシフト
                    foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                        Vector<BezierChain> list = vsq.AttachedCurves.get( track - 1 ).get( ct );
                        if ( list == null ) {
                            continue;
                        }
                        for ( Iterator<BezierChain> itr2 = list.iterator(); itr2.hasNext(); ) {
                            BezierChain chain = itr2.next();
                            for ( Iterator<BezierPoint> itr3 = chain.points.iterator(); itr3.hasNext(); ) {
                                BezierPoint point = itr3.next();
                                PointD bse = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.getBase().getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                         point.getBase().getY() );
                                PointD ctrl_r = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlLeft.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlLeft.getY() );
                                PointD ctrl_l = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlRight.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlRight.getY() );
                                point.setBase( bse );
                                point.controlLeft = ctrl_l;
                                point.controlRight = ctrl_r;
                            }
                        }
                    }
                }
                replace.Mixer.Slave.add( new VsqMixerEntry() );
                replace.Track.add( vsq.Track.get( track ) );
                replace.AttachedCurves.add( vsq.AttachedCurves.get( track - 1 ) );
            }

            // コマンドを発行し、実行
            CadenciiCommand run = VsqFileEx.generateCommandReplace( replace );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        private void commonFileOpen_Click( Object sender, BEventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            DialogResult dr = DialogResult.Cancel;
            if ( AppManager.editorConfig.UseCustomFileDialog ) {
                FileDialog fd = null;
                try {
                    fd = new FileDialog( FileDialog.DialogMode.Open );
                    if ( openXmlVsqDialog.FileName != "" ) {
                        fd.FileName = openXmlVsqDialog.FileName;
                    }
                    fd.Filter = openXmlVsqDialog.Filter;
                    dr = fd.ShowDialog();
                    if ( dr == DialogResult.OK ) {
                        openXmlVsqDialog.FileName = fd.FileName;
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( fd != null ) {
                        try {
#if !JAVA
                            fd.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }

                }
            } else {
                //openXmlVsqDialog
                dr = openXmlVsqDialog.ShowDialog();
            }
            if ( dr == DialogResult.OK ) {
                if ( AppManager.isPlaying() ) {
                    AppManager.setPlaying( false );
                }
                openVsqCor( openXmlVsqDialog.FileName );
                clearExistingData();
                setEdited( false );
                AppManager.mixerWindow.updateStatus();
                clearTempWave();
#if USE_DOBJ
                updateDrawObjectList();
#endif
                refreshScreen();
            }
        }

        private void commonFileNew_Click( Object sender, BEventArgs e ) {
            if ( !dirtyCheck() ) {
                return;
            }
            AppManager.setSelected( 1 );
            VsqFileEx vsq = new VsqFileEx( AppManager.editorConfig.DefaultSingerName, AppManager.editorConfig.DefaultPreMeasure, 4, 4, 500000 );

            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            vsq.Track.get( 1 ).changeRenderer( renderer, singers );

            AppManager.setVsqFile( vsq );
            clearExistingData();
            setEdited( false );
            AppManager.mixerWindow.updateStatus();
            clearTempWave();
#if USE_DOBJ
            updateDrawObjectList();
#endif
            refreshScreen();
        }

        private void menuFileNew_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Create new project." );
        }

        private void menuFileOpen_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Open Cadencii project." );
        }

        private void menuFileSave_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Save current project." );
        }

        private void menuFileSaveNamed_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Save current project with new name." );
        }

        private void menuFileOpenVsq_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Open VSQ / VOCALOID MIDI and create new project." );
        }

        private void menuFileOpenUst_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Open UTAU project and create new project." );
        }

        private void menuFileImport_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Import." );
        }

        private void menuFileImportVsq_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Import VSQ / VOCALOID MIDI." );
        }

        private void menuFileImportMidi_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Import Standard MIDI." );
        }

        private void menuFileExportWave_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Export to WAVE file." );
        }

        private void menuFileExportMidi_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Export to Standard MIDI." );
        }

        private void menuFileRecent_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Recent projects." );
        }

        private void menuFileQuit_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Close this window." );
        }
        #endregion

        #region menuSetting*
        private void menuSettingDefaultSingerStyle_Click( Object sender, BEventArgs e ) {
            FormSingerStyleConfig dlg = null;
            try {
                dlg = new FormSingerStyleConfig();
                dlg.PMBendDepth = AppManager.editorConfig.DefaultPMBendDepth;
                dlg.PMBendLength = AppManager.editorConfig.DefaultPMBendLength;
                dlg.PMbPortamentoUse = AppManager.editorConfig.DefaultPMbPortamentoUse;
                dlg.DEMdecGainRate = AppManager.editorConfig.DefaultDEMdecGainRate;
                dlg.DEMaccent = AppManager.editorConfig.DefaultDEMaccent;

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    if ( dlg.ApplyCurrentTrack ) {
                        VsqTrack copy = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                        boolean changed = false;
                        for ( int i = 0; i < copy.getEventCount(); i++ ) {
                            if ( copy.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                copy.getEvent( i ).ID.PMBendDepth = dlg.PMBendDepth;
                                copy.getEvent( i ).ID.PMBendLength = dlg.PMBendLength;
                                copy.getEvent( i ).ID.PMbPortamentoUse = dlg.PMbPortamentoUse;
                                copy.getEvent( i ).ID.DEMdecGainRate = dlg.DEMdecGainRate;
                                copy.getEvent( i ).ID.DEMaccent = dlg.DEMaccent;
                                changed = true;
                            }
                        }
                        if ( changed ) {
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                                         copy,
                                                                                         AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
#if USE_DOBJ
                            updateDrawObjectList();
#endif
                            refreshScreen();
                        }
                    }
                    AppManager.editorConfig.DefaultPMBendDepth = dlg.PMBendDepth;
                    AppManager.editorConfig.DefaultPMBendLength = dlg.PMBendLength;
                    AppManager.editorConfig.DefaultPMbPortamentoUse = dlg.PMbPortamentoUse;
                    AppManager.editorConfig.DefaultDEMdecGainRate = dlg.DEMdecGainRate;
                    AppManager.editorConfig.DefaultDEMaccent = dlg.DEMaccent;
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuSettingMidi_Click( Object sender, BEventArgs e ) {
            FormMidiConfig form = null;
            try {
                form = new FormMidiConfig();
                form.setLocation( getFormPreferedLocation( form ) );
                if ( form.ShowDialog() == DialogResult.OK ) {

                }
            } catch ( Exception ex ) {
            } finally {
                if ( form != null ) {
                    try {
                        form.Dispose();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuSettingPreference_Click( Object sender, BEventArgs e ) {
            if ( m_preference_dlg == null ) {
                m_preference_dlg = new Preference();
            }
            m_preference_dlg.setBaseFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 ) );
            m_preference_dlg.ScreenFont = new System.Drawing.Font( AppManager.editorConfig.ScreenFontName, 9 );
            m_preference_dlg.WheelOrder = AppManager.editorConfig.WheelOrder;
            m_preference_dlg.CursorFixed = AppManager.editorConfig.CursorFixed;
            m_preference_dlg.DefaultVibratoLength = AppManager.editorConfig.DefaultVibratoLength;
            m_preference_dlg.AutoVibratoMinimumLength = AppManager.editorConfig.AutoVibratoMinimumLength;
            m_preference_dlg.AutoVibratoType1 = AppManager.editorConfig.AutoVibratoType1;
            m_preference_dlg.AutoVibratoType2 = AppManager.editorConfig.AutoVibratoType2;
            m_preference_dlg.EnableAutoVibrato = AppManager.editorConfig.EnableAutoVibrato;
            m_preference_dlg.PreMeasure = AppManager.getVsqFile().getPreMeasure();
            m_preference_dlg.PreSendTime = AppManager.editorConfig.PreSendTime;
            m_preference_dlg.ControlCurveResolution = AppManager.editorConfig.ControlCurveResolution;
            m_preference_dlg.DefaultSingerName = AppManager.editorConfig.DefaultSingerName;
            m_preference_dlg.ScrollHorizontalOnWheel = AppManager.editorConfig.ScrollHorizontalOnWheel;
            m_preference_dlg.MaximumFrameRate = AppManager.editorConfig.MaximumFrameRate;
            m_preference_dlg.Platform = AppManager.editorConfig.Platform;
            m_preference_dlg.KeepLyricInputMode = AppManager.editorConfig.KeepLyricInputMode;
            m_preference_dlg.PxTrackHeight = AppManager.editorConfig.PxTrackHeight;
            m_preference_dlg.MouseHoverTime = AppManager.editorConfig.MouseHoverTime;
            m_preference_dlg.PlayPreviewWhenRightClick = AppManager.editorConfig.PlayPreviewWhenRightClick;
            m_preference_dlg.CurveSelectingQuantized = AppManager.editorConfig.CurveSelectingQuantized;
            m_preference_dlg.CurveVisibleAccent = AppManager.editorConfig.CurveVisibleAccent;
            m_preference_dlg.CurveVisibleBre = AppManager.editorConfig.CurveVisibleBreathiness;
            m_preference_dlg.CurveVisibleBri = AppManager.editorConfig.CurveVisibleBrightness;
            m_preference_dlg.CurveVisibleCle = AppManager.editorConfig.CurveVisibleClearness;
            m_preference_dlg.CurveVisibleDecay = AppManager.editorConfig.CurveVisibleDecay;
            m_preference_dlg.CurveVisibleDyn = AppManager.editorConfig.CurveVisibleDynamics;
            m_preference_dlg.CurveVisibleGen = AppManager.editorConfig.CurveVisibleGendorfactor;
            m_preference_dlg.CurveVisibleOpe = AppManager.editorConfig.CurveVisibleOpening;
            m_preference_dlg.CurveVisiblePit = AppManager.editorConfig.CurveVisiblePit;
            m_preference_dlg.CurveVisiblePbs = AppManager.editorConfig.CurveVisiblePbs;
            m_preference_dlg.CurveVisiblePor = AppManager.editorConfig.CurveVisiblePortamento;
            m_preference_dlg.CurveVisibleVel = AppManager.editorConfig.CurveVisibleVelocity;
            m_preference_dlg.CurveVisibleVibratoDepth = AppManager.editorConfig.CurveVisibleVibratoDepth;
            m_preference_dlg.CurveVisibleVibratoRate = AppManager.editorConfig.CurveVisibleVibratoRate;
            m_preference_dlg.CurveVisibleFx2Depth = AppManager.editorConfig.CurveVisibleFx2Depth;
            m_preference_dlg.CurveVisibleHarmonics = AppManager.editorConfig.CurveVisibleHarmonics;
            m_preference_dlg.CurveVisibleReso1 = AppManager.editorConfig.CurveVisibleReso1;
            m_preference_dlg.CurveVisibleReso2 = AppManager.editorConfig.CurveVisibleReso2;
            m_preference_dlg.CurveVisibleReso3 = AppManager.editorConfig.CurveVisibleReso3;
            m_preference_dlg.CurveVisibleReso4 = AppManager.editorConfig.CurveVisibleReso4;
            m_preference_dlg.CurveVisibleEnvelope = AppManager.editorConfig.CurveVisibleEnvelope;
            m_preference_dlg.MidiInPort = AppManager.editorConfig.MidiInPort.PortNumber;
            m_preference_dlg.InvokeWithWine = AppManager.editorConfig.InvokeUtauCoreWithWine;
            m_preference_dlg.PathResampler = AppManager.editorConfig.PathResampler;
            m_preference_dlg.PathWavtool = AppManager.editorConfig.PathWavtool;
            m_preference_dlg.UtauSingers = AppManager.editorConfig.UtauSingers;
            m_preference_dlg.UseCustomFileDialog = AppManager.editorConfig.UseCustomFileDialog;
            m_preference_dlg.SelfDeRomantization = AppManager.editorConfig.SelfDeRomanization;
            m_preference_dlg.AutoBackupIntervalMinutes = AppManager.editorConfig.AutoBackupIntervalMinutes;
            m_preference_dlg.setUseSpaceKeyAsMiddleButtonModifier( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier );
            m_preference_dlg.setDefaultSynthesizer( AppManager.editorConfig.DefaultSynthesizer );

            m_preference_dlg.setLocation( getFormPreferedLocation( m_preference_dlg ) );

            if ( m_preference_dlg.ShowDialog() == DialogResult.OK ) {
                AppManager.editorConfig.BaseFontName = m_preference_dlg.getBaseFont().getName();
                AppManager.editorConfig.BaseFontSize = m_preference_dlg.getBaseFont().getSize2D();
                updateMenuFonts();

                AppManager.editorConfig.ScreenFontName = m_preference_dlg.ScreenFont.Name;
                //AppManager.EditorConfig.CounterFontName = m_preference_dlg.CounterFont.Name;
                AppManager.editorConfig.WheelOrder = m_preference_dlg.WheelOrder;
                AppManager.editorConfig.CursorFixed = m_preference_dlg.CursorFixed;

                AppManager.editorConfig.DefaultVibratoLength = m_preference_dlg.DefaultVibratoLength;
                AppManager.editorConfig.AutoVibratoMinimumLength = m_preference_dlg.AutoVibratoMinimumLength;
                AppManager.editorConfig.AutoVibratoType1 = m_preference_dlg.AutoVibratoType1;
                AppManager.editorConfig.AutoVibratoType2 = m_preference_dlg.AutoVibratoType2;

                AppManager.editorConfig.EnableAutoVibrato = m_preference_dlg.EnableAutoVibrato;
                AppManager.editorConfig.PreSendTime = m_preference_dlg.PreSendTime;
                AppManager.editorConfig.DefaultPreMeasure = m_preference_dlg.PreMeasure;
                if ( m_preference_dlg.PreMeasure != AppManager.getVsqFile().getPreMeasure() ) {
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandChangePreMeasure( m_preference_dlg.PreMeasure ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                }
                AppManager.editorConfig.Language = m_preference_dlg.Language;
                if ( !Messaging.getLanguage().Equals( AppManager.editorConfig.Language ) ) {
                    Messaging.setLanguage( AppManager.editorConfig.Language );
                    applyLanguage();
                    m_preference_dlg.ApplyLanguage();
                    AppManager.mixerWindow.ApplyLanguage();
                    if ( m_versioninfo != null && !m_versioninfo.IsDisposed ) {
                        m_versioninfo.ApplyLanguage();
                    }
                    AppManager.propertyWindow.ApplyLanguage();
                    AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
                }

                AppManager.editorConfig.ControlCurveResolution = m_preference_dlg.ControlCurveResolution;
                AppManager.editorConfig.DefaultSingerName = m_preference_dlg.DefaultSingerName;
                AppManager.editorConfig.ScrollHorizontalOnWheel = m_preference_dlg.ScrollHorizontalOnWheel;
                AppManager.editorConfig.MaximumFrameRate = m_preference_dlg.MaximumFrameRate;
                int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
                timer.Interval = (fps <= 0) ? 1 : fps;
                AppManager.editorConfig.Platform = m_preference_dlg.Platform;
                s_modifier_key = ((AppManager.editorConfig.Platform == Platform.Macintosh) ? InputEvent.META_MASK : InputEvent.CTRL_MASK);
                applyShortcut();
                AppManager.editorConfig.KeepLyricInputMode = m_preference_dlg.KeepLyricInputMode;
                if ( AppManager.editorConfig.PxTrackHeight != m_preference_dlg.PxTrackHeight ) {
                    AppManager.editorConfig.PxTrackHeight = m_preference_dlg.PxTrackHeight;
#if USE_DOBJ
                    updateDrawObjectList();
#endif
                }
                AppManager.editorConfig.MouseHoverTime = m_preference_dlg.MouseHoverTime;
                AppManager.editorConfig.PlayPreviewWhenRightClick = m_preference_dlg.PlayPreviewWhenRightClick;
                AppManager.editorConfig.CurveSelectingQuantized = m_preference_dlg.CurveSelectingQuantized;

                AppManager.editorConfig.CurveVisibleAccent = m_preference_dlg.CurveVisibleAccent;
                AppManager.editorConfig.CurveVisibleBreathiness = m_preference_dlg.CurveVisibleBre;
                AppManager.editorConfig.CurveVisibleBrightness = m_preference_dlg.CurveVisibleBri;
                AppManager.editorConfig.CurveVisibleClearness = m_preference_dlg.CurveVisibleCle;
                AppManager.editorConfig.CurveVisibleDecay = m_preference_dlg.CurveVisibleDecay;
                AppManager.editorConfig.CurveVisibleDynamics = m_preference_dlg.CurveVisibleDyn;
                AppManager.editorConfig.CurveVisibleGendorfactor = m_preference_dlg.CurveVisibleGen;
                AppManager.editorConfig.CurveVisibleOpening = m_preference_dlg.CurveVisibleOpe;
                AppManager.editorConfig.CurveVisiblePit = m_preference_dlg.CurveVisiblePit;
                AppManager.editorConfig.CurveVisiblePbs = m_preference_dlg.CurveVisiblePbs;
                AppManager.editorConfig.CurveVisiblePortamento = m_preference_dlg.CurveVisiblePor;
                AppManager.editorConfig.CurveVisibleVelocity = m_preference_dlg.CurveVisibleVel;
                AppManager.editorConfig.CurveVisibleVibratoDepth = m_preference_dlg.CurveVisibleVibratoDepth;
                AppManager.editorConfig.CurveVisibleVibratoRate = m_preference_dlg.CurveVisibleVibratoRate;
                AppManager.editorConfig.CurveVisibleFx2Depth = m_preference_dlg.CurveVisibleFx2Depth;
                AppManager.editorConfig.CurveVisibleHarmonics = m_preference_dlg.CurveVisibleHarmonics;
                AppManager.editorConfig.CurveVisibleReso1 = m_preference_dlg.CurveVisibleReso1;
                AppManager.editorConfig.CurveVisibleReso2 = m_preference_dlg.CurveVisibleReso2;
                AppManager.editorConfig.CurveVisibleReso3 = m_preference_dlg.CurveVisibleReso3;
                AppManager.editorConfig.CurveVisibleReso4 = m_preference_dlg.CurveVisibleReso4;
                AppManager.editorConfig.CurveVisibleEnvelope = m_preference_dlg.CurveVisibleEnvelope;

                AppManager.editorConfig.MidiInPort.PortNumber = m_preference_dlg.MidiInPort;
                updateMidiInStatus();
                reloadMidiIn();

                AppManager.editorConfig.InvokeUtauCoreWithWine = m_preference_dlg.InvokeWithWine;
                AppManager.editorConfig.PathResampler = m_preference_dlg.PathResampler;
                AppManager.editorConfig.PathWavtool = m_preference_dlg.PathWavtool;
                AppManager.editorConfig.UtauSingers.clear();
                for ( Iterator<SingerConfig> itr = m_preference_dlg.UtauSingers.iterator(); itr.hasNext(); ) {
                    SingerConfig sc = itr.next();
                    AppManager.editorConfig.UtauSingers.add( (SingerConfig)sc.clone() );
                }
                AppManager.editorConfig.UseCustomFileDialog = m_preference_dlg.UseCustomFileDialog;
                AppManager.editorConfig.SelfDeRomanization = m_preference_dlg.SelfDeRomantization;
                AppManager.editorConfig.AutoBackupIntervalMinutes = m_preference_dlg.AutoBackupIntervalMinutes;
                AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier = m_preference_dlg.isUseSpaceKeyAsMiddleButtonModifier();
                AppManager.editorConfig.DefaultSynthesizer = m_preference_dlg.getDefaultSynthesizer();

                Vector<CurveType> visible_curves = new Vector<CurveType>();
                trackSelector.clearViewingCurve();
                trackSelector.prepareSingerMenu( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version );

                updateTrackSelectorVisibleCurve();
                updateRendererMenu();
                AppManager.updateAutoBackupTimerStatus();

                if ( menuVisualControlTrack.isSelected() ) {
                    splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
                }

                AppManager.saveConfig();
                applyLanguage();
                updateScriptShortcut();
#if USE_DOBJ
                updateDrawObjectList();
#endif
                refreshScreen();
            }
        }

        private void menuSettingShortcut_Click( Object sender, BEventArgs e ) {
            TreeMap<String, ValuePair<String, BKeys[]>> dict = new TreeMap<String, ValuePair<String, BKeys[]>>();
            TreeMap<String, BKeys[]> configured = AppManager.editorConfig.getShortcutKeysDictionary();

            // スクリプトのToolStripMenuITemを蒐集
            Vector<String> script_shortcut = new Vector<String>();
            MenuElement[] sub_menu_script = menuScript.getSubElements();
            for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                MenuElement tsi = sub_menu_script[i];
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    MenuElement[] sub_tsmi = tsmi.getSubElements();
                    if ( sub_tsmi.Length == 1 && sub_tsmi[0] is BMenuItem ) {
                        BMenuItem item = (BMenuItem)sub_tsmi[0];
                        script_shortcut.add( item.getName() );
                        if ( !configured.containsKey( item.getName() ) ) {
                            configured.put( item.getName(), new BKeys[] { } );
                        }
                    }
                }
            }

            for ( Iterator<String> itr = configured.keySet().iterator(); itr.hasNext(); ) {
                String name = itr.next();
                MenuElement menu = searchMenuItemFromName( name );
                if ( menu != null ) {
                    String parent = "";
                    MenuElement owner_item = null;
                    Object pa = menu.getParent();
                    if ( pa != null && pa is MenuElement ) {
                        owner_item = (MenuElement)pa;
                    }
                    if ( owner_item != null && !owner_item.getName().Equals( menuHidden.getName() ) ) {
                        String s = owner_item.getText();
                        int i = s.IndexOf( "(&" );
                        if ( i > 0 ) {
                            s = s.Substring( 0, i );
                        }
                        parent = s + " -> ";
                    }
                    String s1 = menu.getText();
                    int i1 = s1.IndexOf( "(&" );
                    if ( i1 > 0 ) {
                        s1 = s1.Substring( 0, i1 );
                    }
                    if ( script_shortcut.contains( name ) ) {
                        String s2 = menuScript.Text;
                        int i2 = s2.IndexOf( "(&" );
                        if ( i2 > 0 ) {
                            s2 = s2.Substring( 0, i2 );
                        }
                        parent = s2 + " -> " + parent;
                    }
                    dict.put( parent + s1, new ValuePair<String, BKeys[]>( name, configured.get( name ) ) );
                }
            }

            FormShortcutKeys form = null;
            try {
                form = new FormShortcutKeys( dict );
                form.setLocation( getFormPreferedLocation( form ) );
                if ( form.ShowDialog() == DialogResult.OK ) {
                    TreeMap<String, ValuePair<String, BKeys[]>> res = form.Result;
                    for ( Iterator<String> itr = res.keySet().iterator(); itr.hasNext(); ) {
                        String display = itr.next();
                        String name = res.get( display ).Key;
                        BKeys[] keys = res.get( display ).Value;
                        boolean found = false;
                        for ( int i = 0; i < AppManager.editorConfig.ShortcutKeys.size(); i++ ) {
                            if ( AppManager.editorConfig.ShortcutKeys.get( i ).Key.Equals( name ) ) {
                                AppManager.editorConfig.ShortcutKeys.get( i ).Value = keys;
                                found = true;
                                break;
                            }
                        }
                        if ( !found ) {
                            AppManager.editorConfig.ShortcutKeys.add( new ValuePairOfStringArrayOfKeys( name, keys ) );
                        }
                    }
                    applyShortcut();
                    AppManager.propertyWindow.setFormCloseShortcutKey( AppManager.editorConfig.getShortcutKeyFor( menuVisualProperty ) );
                }
            } catch ( Exception ex ) {
            } finally {
                if ( form != null ) {
                    try {
                        form.Dispose();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuSettingGameControlerLoad_Click( Object sender, BEventArgs e ) {
            loadGameControler();
        }

        private void menuSettingGameControlerRemove_Click( Object sender, BEventArgs e ) {
            removeGameControler();
        }

        private void menuSettingGameControlerSetting_Click( Object sender, BEventArgs e ) {
            FormGameControlerConfig dlg = null;
            try {
                dlg = new FormGameControlerConfig();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    AppManager.editorConfig.GameControlerRectangle = dlg.getRectangle();
                    AppManager.editorConfig.GameControlerTriangle = dlg.getTriangle();
                    AppManager.editorConfig.GameControlerCircle = dlg.getCircle();
                    AppManager.editorConfig.GameControlerCross = dlg.getCross();
                    AppManager.editorConfig.GameControlL1 = dlg.getL1();
                    AppManager.editorConfig.GameControlL2 = dlg.getL2();
                    AppManager.editorConfig.GameControlR1 = dlg.getR1();
                    AppManager.editorConfig.GameControlR2 = dlg.getR2();
                    AppManager.editorConfig.GameControlSelect = dlg.getSelect();
                    AppManager.editorConfig.GameControlStart = dlg.getStart();
                    AppManager.editorConfig.GameControlPovDown = dlg.getPovDown();
                    AppManager.editorConfig.GameControlPovLeft = dlg.getPovLeft();
                    AppManager.editorConfig.GameControlPovUp = dlg.getPovUp();
                    AppManager.editorConfig.GameControlPovRight = dlg.getPovRight();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }
        #endregion

        #region menuEdit*
        private void menuEditDelete_Click( Object sender, BEventArgs e ) {
            deleteEvent();
        }

        private void commonEditPaste_Click( Object sender, BEventArgs e ) {
            pasteEvent();
        }

        private void commonEditCopy_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "commonEditCopy_Click" );
#endif
            copyEvent();
        }

        private void commonEditCut_Click( Object sender, BEventArgs e ) {
            cutEvent();
        }

        private void menuEdit_DropDownOpening( Object sender, BEventArgs e ) {
            updateCopyAndPasteButtonStatus();
        }

        private void commonEditUndo_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "menuEditUndo_Click" );
#endif
            undo();
            refreshScreen();
        }


        private void commonEditRedo_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "menuEditRedo_Click" );
#endif
            redo();
            refreshScreen();
        }

        private void menuEditSelectAllEvents_Click( Object sender, BEventArgs e ) {
            selectAllEvent();
        }

        private void menuEditSelectAll_Click( Object sender, BEventArgs e ) {
            selectAll();
        }

        private void menuEditAutoNormalizeMode_Click( Object sender, BEventArgs e ) {
            AppManager.autoNormalize = !AppManager.autoNormalize;
            menuEditAutoNormalizeMode.Checked = AppManager.autoNormalize;
        }

        private void menuEditUndo_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Undo." );
        }

        private void menuEditRedo_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Redo." );
        }

        private void menuEditCut_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Cut selected items." );
        }

        private void menuEditCopy_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Copy selected items." );
        }

        private void menuEditPaste_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Paste copied items to current song position." );
        }

        private void menuEditDelete_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Delete selected items." );
        }

        private void menuEditAutoNormalizeMode_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Avoid automaticaly polyphonic editing." );
        }

        private void menuEditSelectAll_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Select all items and control curves of current track." );
        }

        private void menuEditSelectAllEvents_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Select all items of current track." );
        }
        #endregion

        #region menuLyric*
        private void menuLyricExpressionProperty_Click( Object sender, BEventArgs e ) {
            editNoteExpressionProperty();
        }

        private void menuLyricDictionary_Click( Object sender, BEventArgs e ) {
            FormWordDictionary dlg = null;
            try {
                dlg = new FormWordDictionary();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    Vector<ValuePair<String, Boolean>> result = dlg.Result;
                    SymbolTable.changeOrder( result );
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuLyricVibratoProperty_Click( Object sender, BEventArgs e ) {
            editNoteVibratoProperty();
        }
        #endregion

        #region menuJob
        private void menuJobRealTime_Click( Object sender, BEventArgs e ) {
            if ( !AppManager.isPlaying() ) {
                AppManager.addingEvent = null;
                AppManager.setEditMode( EditMode.REALTIME );
                AppManager.setPlaying( true );
                //menuJobRealTime.Text = _( "Stop Realtime Input" );
            } else {
                timer.Stop();
                AppManager.setPlaying( false );
                AppManager.setEditMode( EditMode.NONE );
                //menuJobRealTime.Text = _( "Start Realtime Input" );
            }
        }

        private void menuJobReloadVsti_Click( Object sender, BEventArgs e ) {
            //VSTiProxy.ReloadPlugin(); //todo: FormMain+menuJobReloadVsti_Click
        }

        private void menuJob_DropDownOpening( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "menuJob_DropDownOpening" );
            AppManager.debugWriteLine( "    menuJob.Bounds=" + menuJob.Bounds );
#endif
            if ( AppManager.getSelectedEventCount() <= 1 ) {
                menuJobConnect.Enabled = false;
            } else {
                // menuJobConnect(音符の結合)がEnableされるかどうかは、選択されている音符がピアノロール上で連続かどうかで決まる
                int[] list = new int[AppManager.getSelectedEventCount()];
                for ( int i = 0; i < AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount(); i++ ) {
                    int count = -1;
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int key = item.original.InternalID;
                        count++;
                        if ( key == AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEvent( i ).InternalID ) {
                            list[count] = i;
                            break;
                        }
                    }
                }
                boolean changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < list.Length - 1; i++ ) {
                        if ( list[i] > list[i + 1] ) {
                            int b = list[i];
                            list[i] = list[i + 1];
                            list[i + 1] = b;
                            changed = true;
                        }
                    }
                }
                boolean continued = true;
                for ( int i = 0; i < list.Length - 1; i++ ) {
                    if ( list[i] + 1 != list[i + 1] ) {
                        continued = false;
                        break;
                    }
                }
                menuJobConnect.Enabled = continued;
            }

            menuJobLyric.Enabled = AppManager.getLastSelectedEvent() != null;
        }

        private void menuJobLyric_Click( Object sender, BEventArgs e ) {
            importLyric();
        }

        private void menuJobConnect_Click( Object sender, BEventArgs e ) {
            int count = AppManager.getSelectedEventCount();
            int[] clocks = new int[count];
            VsqID[] ids = new VsqID[count];
            int[] internalids = new int[count];
            int i = -1;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                i++;
                clocks[i] = item.original.Clock;
                ids[i] = (VsqID)item.original.ID.clone();
                internalids[i] = item.original.InternalID;
            }
            boolean changed = true;
            while ( changed ) {
                changed = false;
                for ( int j = 0; j < clocks.Length - 1; j++ ) {
                    if ( clocks[j] > clocks[j + 1] ) {
                        int b = clocks[j];
                        clocks[j] = clocks[j + 1];
                        clocks[j + 1] = b;
                        VsqID a = ids[j];
                        ids[j] = ids[j + 1];
                        ids[j + 1] = a;
                        changed = true;
                        b = internalids[j];
                        internalids[j] = internalids[j + 1];
                        internalids[j + 1] = b;
                    }
                }
            }

            for ( int j = 0; j < ids.Length - 1; j++ ) {
                ids[j].Length = clocks[j + 1] - clocks[j];
            }
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventChangeIDContaintsRange( AppManager.getSelected(), internalids, ids ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            this.Refresh();
        }

        private void menuJobInsertBar_Click( Object sender, BEventArgs e ) {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            FormInsertBar dlg = null;
            try {
                dlg = new FormInsertBar( total_barcount );
                int current_clock = AppManager.getCurrentClock();
                int barcount = AppManager.getVsqFile().getBarCountFromClock( current_clock );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setPosition( draft );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    int pos = dlg.getPosition() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int length = dlg.getLength();

                    int clock_start = AppManager.getVsqFile().getClockFromBarCount( pos );
                    int clock_end = AppManager.getVsqFile().getClockFromBarCount( pos + length );
                    int dclock = clock_end - clock_start;
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().Clone();

                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in AppManager.CURVE_USAGE ) {
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start <= chain_start ) {
                                    for ( int i = 0; i < bc.points.size(); i++ ) {
                                        PointD t = bc.points.get( i ).getBase();
                                        bc.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    list.add( bc );
                                } else if ( chain_start < clock_start && clock_start < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_start, chain_end );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        PointD t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    //PointD t2 = adding1.points[adding1.points.Count - 1].Base;
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    /*BezierPoint bp = new BezierPoint( t2.X + dclock, t2.Y );
                                    bp.ControlLeftType = BezierControlType.None;
                                    bp.ControlRightType = BezierControlType.None;
                                    adding1.points.Add( bp );*/
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    adding1.id = bc.id;
                                    list.add( adding1 );
                                } else {
                                    list.add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                        for ( int i = 0; i < temp.Track.get( track ).getEventCount(); i++ ) {
                            if ( temp.Track.get( track ).getEvent( i ).Clock >= clock_start ) {
                                temp.Track.get( track ).getEvent( i ).Clock += dclock;
                            }
                        }
                        foreach ( CurveType curve in AppManager.CURVE_USAGE ) {
                            if ( curve.isScalar() || curve.isAttachNote() ) {
                                continue;
                            }
                            VsqBPList target = temp.Track.get( track ).getCurve( curve.getName() );
                            VsqBPList src = AppManager.getVsqFile().Track.get( track ).getCurve( curve.getName() );
                            target.clear();
                            for ( Iterator<Integer> itr = src.keyClockIterator(); itr.hasNext(); ) {
                                int key = itr.next();
                                if ( key >= clock_start ) {
                                    target.add( key + dclock, src.getValue( key ) );
                                } else {
                                    target.add( key, src.getValue( key ) );
                                }
                            }
                        }
                    }
                    for ( int i = 0; i < temp.TempoTable.size(); i++ ) {
                        if ( temp.TempoTable.get( i ).Clock >= clock_start ) {
                            temp.TempoTable.get( i ).Clock = temp.TempoTable.get( i ).Clock + dclock;
                        }
                    }
                    for ( int i = 0; i < temp.TimesigTable.size(); i++ ) {
                        if ( temp.TimesigTable.get( i ).Clock >= clock_start ) {
                            temp.TimesigTable.get( i ).Clock = temp.TimesigTable.get( i ).Clock + dclock;
                        }
                    }
                    temp.updateTempoInfo();
                    temp.updateTimesigInfo();

                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    this.Refresh();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuJobDeleteBar_Click( Object sender, BEventArgs e ) {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            int clock = AppManager.getCurrentClock();
            int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
            FormDeleteBar dlg = null;
            try {
                dlg = new FormDeleteBar( total_barcount );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setStart( draft );
                dlg.setEnd( draft + 1 );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().Clone();
                    int start = dlg.getStart() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int end = dlg.getEnd() + AppManager.getVsqFile().getPreMeasure() - 1;
#if DEBUG
                    AppManager.debugWriteLine( "FormMain+menuJobDeleteBar_Click" );
                    AppManager.debugWriteLine( "    start,end=" + start + "," + end );
#endif
                    int clock_start = temp.getClockFromBarCount( start );
                    int clock_end = temp.getClockFromBarCount( end );
                    int dclock = clock_end - clock_start;
                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        for ( int j = 0; j < AppManager.CURVE_USAGE.Length; j++ ) {
                            CurveType ct = AppManager.CURVE_USAGE[j];
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start < chain_start && chain_start < clock_end && clock_end < chain_end ) {
                                    BezierChain adding = bc.extractPartialBezier( clock_end, chain_end );
                                    adding.id = bc.id;
                                    for ( int i = 0; i < adding.points.size(); i++ ) {
                                        PointD t = adding.points.get( i ).getBase();
                                        adding.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    }
                                    list.add( adding );
                                } else if ( chain_start < clock_start && clock_end < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    adding1.id = bc.id;
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_end, chain_end );
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    PointD t = adding2.points.get( 0 ).getBase();
                                    adding2.points.get( 0 ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    adding1.points.add( adding2.points.get( 0 ) );
                                    for ( int i = 1; i < adding2.points.size(); i++ ) {
                                        t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    list.add( adding1 );
                                } else if ( chain_start < clock_start && clock_start < chain_end && chain_end < clock_end ) {
                                    BezierChain adding = bc.extractPartialBezier( chain_start, clock_start );
                                    adding.id = bc.id;
                                    list.add( adding );
                                } else if ( clock_end <= chain_start || chain_end <= clock_start ) {
                                    if ( clock_end <= chain_start ) {
                                        for ( int i = 0; i < bc.points.size(); i++ ) {
                                            PointD t = bc.points.get( i ).getBase();
                                            bc.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        }
                                    }
                                    list.add( (BezierChain)bc.Clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    temp.removePart( clock_start, clock_end );
                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    this.Refresh();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void menuJobNormalize_Click( Object sender, BEventArgs e ) {
            VsqFile work = (VsqFile)AppManager.getVsqFile().Clone();
            int track = AppManager.getSelected();
            boolean changed = true;
            boolean total_changed = false;

            // 最初、開始時刻が同じになっている奴を削除
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int clock = work.Track.get( track ).getEvent( i ).Clock;
                    int id = work.Track.get( track ).getEvent( i ).InternalID;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        if ( clock == work.Track.get( track ).getEvent( j ).Clock ) {
                            if ( id < work.Track.get( track ).getEvent( j ).InternalID ) { //内部IDが小さい＝より高年齢（音符追加時刻が古い）
                                work.Track.get( track ).removeEvent( i );
                            } else {
                                work.Track.get( track ).removeEvent( j );
                            }
                            changed = true;
                            total_changed = true;
                            break;
                        }
                    }
                    if ( changed ) {
                        break;
                    }
                }
            }

            changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int start_clock = work.Track.get( track ).getEvent( i ).Clock;
                    int end_clock = work.Track.get( track ).getEvent( i ).ID.Length + start_clock;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        int this_start_clock = work.Track.get( track ).getEvent( j ).Clock;
                        if ( this_start_clock < end_clock ) {
                            work.Track.get( track ).getEvent( i ).ID.Length = this_start_clock - start_clock;
                            changed = true;
                            total_changed = true;
                        }
                    }
                }
            }

            if ( total_changed ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
            }
        }

        private void menuJobNormalize_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Correct overlapped item." );
        }

        private void menuJobInsertBar_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Insert bar." );
        }

        private void menuJobDeleteBar_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Delete bar." );
        }

        private void menuJobRandomize_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Randomize items." ) + _( "(not implemented)" );
        }

        private void menuJobConnect_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Lengthen note end to neighboring note." );
        }

        private void menuJobLyric_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Import lyric." );
        }

        private void menuJobRewire_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Import tempo from ReWire host." ) + _( "(not implemented)" );
        }

        private void menuJobRealTime_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Start realtime input." );
        }

        private void menuJobReloadVsti_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Reload VSTi dll." ) + _( "(not implemented)" );
        }
        #endregion

        #region menuScript
        private void menuScriptUpdate_Click( Object sender, BEventArgs e ) {
            updateScriptShortcut();
            applyShortcut();
        }
        #endregion

        #region vScroll
        private void vScroll_Enter( Object sender, BEventArgs e ) {
            pictPianoRoll.Select();
        }

        private void vScroll_Resize( Object sender, BEventArgs e ) {
            setVScrollRange( vScroll.Maximum );
        }

        private void vScroll_ValueChanged( Object sender, BEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            refreshScreen();
        }
        #endregion

        #region hScroll
        private void hScroll_Enter( Object sender, BEventArgs e ) {
            pictPianoRoll.Select();
        }

        private void hScroll_Resize( Object sender, BEventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#hScroll_Resize" );
#endif
            if ( this.WindowState != FormWindowState.Minimized ) {
                setHScrollRange( AppManager.getVsqFile().TotalClocks );
            }
        }

        private void hScroll_ValueChanged( Object sender, BEventArgs e ) {
#if DEBUG
            //PortUtil.println( "hScroll_ValueChanged" );
            //PortUtil.println( "    Value/Maximum=" + hScroll.Value + "/" + hScroll.Maximum );
            //PortUtil.println( "    LargeChange=" + hScroll.LargeChange );
#endif
            AppManager.startToDrawX = (int)(hScroll.Value * AppManager.scaleX);
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            refreshScreen();
        }
        #endregion

        #region picturePositionIndicator
        private void picturePositionIndicator_MouseWheel( Object sender, BMouseEventArgs e ) {
            hScroll.Value = computeScrollValueFromWheelDelta( e.Delta );
        }

        public void picturePositionIndicator_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
            if ( e.X < AppManager.keyWidth || getWidth() - 3 < e.X ) {
                return;
            }
            if ( e.Button == BMouseButtons.Left ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
#if DEBUG
                    AppManager.debugWriteLine( "TempoChange" );
#endif
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTimesig();

                    if ( AppManager.getSelectedTempoCount() > 0 ) {
                        #region テンポ変更があった場合
                        int index = -1;
                        int clock = AppManager.getLastSelectedTempoClock();
                        for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                            if ( clock == vsq.TempoTable.get( i ).Clock ) {
                                index = i;
                                break;
                            }
                        }
                        if ( index >= 0 ) {
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TempoTable.get( index ).Clock == 0 ) {
                                    statusLabel.Text = _( "Cannot remove first symbol of track!" );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( vsq.TempoTable.get( index ).Clock,
                                                                           vsq.TempoTable.get( index ).Clock,
                                                                           -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            } else {
                                #region ツールがEraser以外
                                TempoTableEntry tte = vsq.TempoTable.get( index );
                                AppManager.clearSelectedTempo();
                                AppManager.addSelectedTempo( tte.Clock );
                                int bar_count = vsq.getBarCountFromClock( tte.Clock );
                                int bar_top_clock = vsq.getClockFromBarCount( bar_count );
                                //int local_denominator, local_numerator;
                                Timesig timesig = vsq.getTimesigAt( tte.Clock );
                                int clock_per_beat = 480 * 4 / timesig.denominator;
                                int clocks_in_bar = tte.Clock - bar_top_clock;
                                int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                FormTempoConfig dlg = null;
                                try {
                                    dlg = new FormTempoConfig( bar_count, beat_in_bar, timesig.numerator, clocks_in_beat, clock_per_beat, (decimal)(6e7 / tte.Tempo), AppManager.getVsqFile().getPreMeasure() );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    if ( dlg.showDialog() == BDialogResult.OK ) {
                                        int new_beat = dlg.getBeatCount();
                                        int new_clocks_in_beat = dlg.getClock();
                                        int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    PortUtil.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.Close();
                                        } catch ( Exception ex2 ) {
                                            PortUtil.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex2=" + ex2 );
                                        }
                                    }
                                }
                                #endregion
                            }
                        }
                        #endregion
                    } else {
                        #region テンポ変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int changing_clock = AppManager.clockFromXCoord( e.X );
                            int changing_tempo = vsq.getTempoAt( changing_clock );
                            int bar_count;
                            int bar_top_clock;
                            int local_denominator, local_numerator;
                            bar_count = vsq.getBarCountFromClock( changing_clock );
                            bar_top_clock = vsq.getClockFromBarCount( bar_count );
                            int index2 = -1;
                            for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                                if ( vsq.TimesigTable.get( i ).BarCount > bar_count ) {
                                    index2 = i;
                                    break;
                                }
                            }
                            if ( index2 >= 1 ) {
                                local_denominator = vsq.TimesigTable.get( index2 - 1 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( index2 - 1 ).Numerator;
                            } else {
                                local_denominator = vsq.TimesigTable.get( 0 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( 0 ).Numerator;
                            }
                            int clock_per_beat = 480 * 4 / local_denominator;
                            int clocks_in_bar = changing_clock - bar_top_clock;
                            int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                            int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                            FormTempoConfig dlg = null;
                            try {
                                dlg = new FormTempoConfig( bar_count - vsq.getPreMeasure() + 1,
                                                           beat_in_bar,
                                                           local_numerator,
                                                           clocks_in_beat,
                                                           clock_per_beat,
                                                           (decimal)(6e7 / changing_tempo),
                                                           vsq.getPreMeasure() );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                if ( dlg.showDialog() == BDialogResult.OK ) {
                                    int new_beat = dlg.getBeatCount();
                                    int new_clocks_in_beat = dlg.getClock();
                                    int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                    AppManager.debugWriteLine( "    new_beat=" + new_beat );
                                    AppManager.debugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                    AppManager.debugWriteLine( "    changing_clock=" + changing_clock );
                                    AppManager.debugWriteLine( "    new_clock=" + new_clock );
#endif
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                    AppManager.register( vsq.executeCommand( run ) );
                                    setEdited( true );
                                    refreshScreen();
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.Close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子の変更
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTempo();
                    if ( AppManager.getSelectedTimesigCount() > 0 ) {
                        #region 拍子変更があった場合
                        int index = 0;
                        int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                        for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                            if ( vsq.TimesigTable.get( i ).BarCount == last_barcount ) {
                                index = i;
                                break;
                            }
                        }
                        if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                            #region ツールがEraser
                            if ( vsq.TimesigTable.get( index ).Clock == 0 ) {
                                statusLabel.Text = _( "Cannot remove first symbol of track!" );
#if !JAVA
                                SystemSounds.Asterisk.Play();
#endif
                                return;
                            }
                            int barcount = vsq.TimesigTable.get( index ).BarCount;
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            setEdited( true );
                            #endregion
                        } else {
                            #region ツールがEraser以外
                            int pre_measure = vsq.getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = vsq.getBarCountFromClock( clock );
                            int total_clock = vsq.TotalClocks;
                            Timesig timesig = vsq.getTimesigAt( clock );
                            boolean num_enabled = !(bar_count == 0);
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, num_enabled, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                if ( dlg.showDialog() == BDialogResult.OK ) {
                                    if ( dlg.EndSpecified ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.Start + pre_measure - 1;
                                        new_barcounts[1] = dlg.End + pre_measure - 1;
                                        numerators[0] = dlg.Numerator;
                                        denominators[0] = dlg.Denominator;
                                        numerators[1] = timesig.numerator;
                                        denominators[1] = timesig.denominator;
                                        barcounts[0] = bar_count;
                                        barcounts[1] = dlg.End + pre_measure - 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    } else {
#if DEBUG
                                        PortUtil.println( "picturePositionIndicator_MouseDoubleClick" );
                                        PortUtil.println( "    bar_count=" + bar_count );
                                        PortUtil.println( "    dlg.Start+pre_measure-1=" + (dlg.Start + pre_measure - 1) );
#endif
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                                     dlg.Start + pre_measure - 1,
                                                                                     dlg.Numerator,
                                                                                     dlg.Denominator ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                                PortUtil.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.Close();
                                    } catch ( Exception ex2 ) {
                                        PortUtil.println( "FormMain#picturePositionIndicator_MouseDoubleClic; ex2=" + ex2 );
                                    }
                                }
                            }
                            #endregion
                        }
                        #endregion
                    } else {
                        #region 拍子変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int pre_measure = AppManager.getVsqFile().getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                            int numerator, denominator;
                            Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
                            int total_clock = AppManager.getVsqFile().TotalClocks;
                            //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) - pre_measure + 1;
                            //int min_barcount = 1;
#if DEBUG
                            AppManager.debugWriteLine( "FormMain.picturePositionIndicator_MouseClick; bar_count=" + (bar_count - pre_measure + 1) );
#endif
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, true, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                if ( dlg.showDialog() == BDialogResult.OK ) {
                                    if ( dlg.EndSpecified ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.Start + pre_measure - 1;
                                        new_barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                        numerators[0] = dlg.Numerator;
                                        numerators[1] = timesig.numerator;

                                        denominators[0] = dlg.Denominator;
                                        denominators[1] = timesig.denominator;

                                        barcounts[0] = dlg.Start + pre_measure - 1;
                                        barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    } else {
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                           dlg.Start + pre_measure - 1,
                                                                           dlg.Numerator,
                                                                           dlg.Denominator ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.Close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                }
                picturePositionIndicator.Refresh();
                pictPianoRoll.Refresh();
            }
        }

        private void picturePositionIndicator_MouseDoubleClick_OLD( Object sender, BMouseEventArgs e ) {
            if ( e.X < AppManager.keyWidth || Width - 3 < e.X ) {
                return;
            }
            if ( e.Button == BMouseButtons.Left ) {
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
                    int index = -1;
                    for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        String s = (60e6 / (float)AppManager.getVsqFile().TempoTable.get( i ).Tempo).ToString( "#.00" );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 14, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    TempoTableEntry tte = AppManager.getVsqFile().TempoTable.get( index );
                    AppManager.clearSelectedTempo();
                    AppManager.addSelectedTempo( tte.Clock );
                    int bar_count = AppManager.getVsqFile().getBarCountFromClock( tte.Clock );
                    int bar_top_clock = AppManager.getVsqFile().getClockFromBarCount( bar_count );
                    //int local_denominator, local_numerator;
                    Timesig timesig = AppManager.getVsqFile().getTimesigAt( tte.Clock );
                    int clock_per_beat = 480 * 4 / timesig.denominator;
                    int clocks_in_bar = tte.Clock - bar_top_clock;
                    int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                    int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                    FormTempoConfig dlg = null;
                    try {
                        dlg = new FormTempoConfig( bar_count, beat_in_bar, timesig.numerator, clocks_in_beat, clock_per_beat, (decimal)(6e7 / tte.Tempo), AppManager.getVsqFile().getPreMeasure() );
                        dlg.setLocation( getFormPreferedLocation( dlg ) );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            int new_beat = dlg.BeatCount;
                            int new_clocks_in_beat = dlg.Clock;
                            int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                            CadenciiCommand run = new CadenciiCommand(
                                VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.Tempo) ) );
                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                            setEdited( true );
                            refreshScreen();
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( dlg != null ) {
                            try {
#if !JAVA
                                dlg.Dispose();
#endif
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }

                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子の変更
                    int index = -1;
                    // クリック位置に拍子が表示されているかどうか検査
                    for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                        String s = AppManager.getVsqFile().TimesigTable.get( i ).Numerator + "/" + AppManager.getVsqFile().TimesigTable.get( i ).Denominator;
                        int x = AppManager.xCoordFromClocks( AppManager.getVsqFile().TimesigTable.get( i ).Clock );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 28, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index < 0 ) {
                        return;
                    }

                    int pre_measure = AppManager.getVsqFile().getPreMeasure();
                    int clock = AppManager.clockFromXCoord( e.X );
                    int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                    //int numerator, denominator;
                    int total_clock = AppManager.getVsqFile().TotalClocks;
                    //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock );
                    //int min_barcount = 1 - pre_measure;
                    Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
                    boolean num_enabled = !(bar_count == 0);
                    FormBeatConfig dlg = null;
                    try {
                        dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, num_enabled, pre_measure );
                        dlg.setLocation( getFormPreferedLocation( dlg ) );
                        if ( dlg.ShowDialog() == DialogResult.OK ) {
                            if ( dlg.EndSpecified ) {
                                int[] new_barcounts = new int[2];
                                int[] numerators = new int[2];
                                int[] denominators = new int[2];
                                int[] barcounts = new int[2];
                                new_barcounts[0] = dlg.Start + pre_measure - 1;
                                new_barcounts[1] = dlg.End + pre_measure - 1;
                                numerators[0] = dlg.Numerator;
                                denominators[0] = dlg.Denominator;
                                numerators[1] = timesig.numerator;
                                denominators[1] = timesig.denominator;
                                barcounts[0] = bar_count;
                                barcounts[1] = dlg.End + pre_measure - 1;
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                setEdited( true );
                            } else {
#if DEBUG
                                PortUtil.println( "picturePositionIndicator_MouseDoubleClick" );
                                PortUtil.println( "    bar_count=" + bar_count );
                                PortUtil.println( "    dlg.Start+pre_measure-1=" + (dlg.Start + pre_measure - 1) );
#endif
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTimesig( bar_count, dlg.Start + pre_measure - 1, dlg.Numerator, dlg.Denominator ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                setEdited( true );
                            }
                        }
                    } catch ( Exception ex ) {
                    } finally {
                        if ( dlg != null ) {
                            try {
#if !JAVA
                                dlg.Dispose();
#endif
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                    #endregion
                }
                picturePositionIndicator.Refresh();
                pictPianoRoll.Refresh();
            }
        }

        private void picturePositionIndicator_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }

            if ( e.X < AppManager.keyWidth || Width - 3 < e.X ) {
                return;
            }

            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
            int modifier = PortUtil.getModifierFromKeys( Control.ModifierKeys );
            if ( e.Button == BMouseButtons.Left ) {
                if ( 0 <= e.Y && e.Y <= 18 ) {
                    #region スタート/エンドマーク
                    if ( AppManager.startMarkerEnabled ) {
                        int startx = AppManager.xCoordFromClocks( AppManager.startMarker ) - AppManager.editorConfig.PxTolerance;
                        if ( startx <= e.X && e.X <= startx + AppManager.editorConfig.PxTolerance * 2 + Properties.Resources.start_marker.Width ) {
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.MARK_START;
                        }
                    }
                    if ( AppManager.endMarkerEnabled && m_position_indicator_mouse_down_mode != PositionIndicatorMouseDownMode.MARK_START ) {
                        int marker_width = Properties.Resources.end_marker.Width;
                        int endx = AppManager.xCoordFromClocks( AppManager.endMarker ) - marker_width - AppManager.editorConfig.PxTolerance;
                        if ( endx <= e.X && e.X <= endx + AppManager.editorConfig.PxTolerance * 2 + marker_width ) {
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.MARK_END;
                        }
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポ
                    int index = -1;
                    for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( Width < x ) {
                            break;
                        }
                        String s = (60e6 / (float)AppManager.getVsqFile().TempoTable.get( i ).Tempo).ToString( "#.00" );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 14, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( index ).Clock;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            m_tempo_dragging_deltaclock = mouse_clock - clock;
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.TEMPO;
                        }
                        if ( (modifier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTempoCount() > 0 ) {
                                int last_clock = AppManager.getLastSelectedTempoClock();
                                int start = Math.Min( last_clock, clock );
                                int end = Math.Max( last_clock, clock );
                                for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                                    int tclock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                                    if ( tclock < start ) {
                                        continue;
                                    } else if ( end < tclock ) {
                                        break;
                                    }
                                    if ( start <= tclock && tclock <= end ) {
                                        AppManager.addSelectedTempo( tclock );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.removeSelectedTempo( clock );
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else {
                            if ( !AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.clearSelectedTempo();
                            }
                            AppManager.addSelectedTempo( clock );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                    #region 拍子
                    // クリック位置に拍子が表示されているかどうか検査
                    int index = -1;
                    for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                        String s = AppManager.getVsqFile().TimesigTable.get( i ).Numerator + "/" + AppManager.getVsqFile().TimesigTable.get( i ).Denominator;
                        int x = AppManager.xCoordFromClocks( AppManager.getVsqFile().TimesigTable.get( i ).Clock );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 ) );
                        if ( isInRect( new Point( e.X, e.Y ), new Rectangle( x, 28, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int barcount = AppManager.getVsqFile().TimesigTable.get( index ).BarCount;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int barcount_clock = AppManager.getVsqFile().getClockFromBarCount( barcount );
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            m_timesig_dragging_deltaclock = mouse_clock - barcount_clock;
                            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.TIMESIG;
                        }
                        if ( (modifier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTimesigCount() > 0 ) {
                                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                                int start = Math.Min( last_barcount, barcount );
                                int end = Math.Max( last_barcount, barcount );
                                for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                                    int tbarcount = AppManager.getVsqFile().TimesigTable.get( i ).BarCount;
                                    if ( tbarcount < start ) {
                                        continue;
                                    } else if ( end < tbarcount ) {
                                        break;
                                    }
                                    if ( start <= tbarcount && tbarcount <= end ) {
                                        AppManager.addSelectedTimesig( AppManager.getVsqFile().TimesigTable.get( i ).BarCount );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else if ( (modifier & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.removeSelectedTimesig( barcount );
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else {
                            if ( !AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.clearSelectedTimesig();
                            }
                            AppManager.addSelectedTimesig( barcount );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                }
            }
            refreshScreen();
        }

        public void picturePositionIndicator_MouseUp( Object sender, BMouseEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "picturePositionIndicator_MouseClick" );
#endif
            if ( e.Button == BMouseButtons.Left ) {
                if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.NONE ) {
                    if ( 4 <= e.Y && e.Y <= 18 ) {
                        #region マーカー位置の変更
                        int clock = AppManager.clockFromXCoord( e.X );
                        if ( AppManager.editorConfig.getPositionQuantize() != QuantizeMode.off ) {
                            int unit = AppManager.getPositionQuantizeClock();
                            int odd = clock % unit;
                            clock -= odd;
                            if ( odd > unit / 2 ) {
                                clock += unit;
                            }
                        }
                        AppManager.setCurrentClock( clock );
                        refreshScreen();
                        #endregion
                    } else if ( 18 < e.Y && e.Y <= 32 ) {
                        #region テンポの変更
#if DEBUG
                        AppManager.debugWriteLine( "TempoChange" );
#endif
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTimesig();
                        if ( AppManager.getSelectedTempoCount() > 0 ) {
                            #region テンポ変更があった場合
                            int index = -1;
                            int clock = AppManager.getLastSelectedTempoClock();
                            for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                                if ( clock == AppManager.getVsqFile().TempoTable.get( i ).Clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( index >= 0 && AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( AppManager.getVsqFile().TempoTable.get( index ).Clock == 0 ) {
                                    statusLabel.Text = _( "Cannot remove first symbol of track!" );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( AppManager.getVsqFile().TempoTable.get( index ).Clock,
                                                                 AppManager.getVsqFile().TempoTable.get( index ).Clock,
                                                                 -1 ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        } else {
                            #region テンポ変更がなかった場合
                            AppManager.clearSelectedEvent();
                            AppManager.clearSelectedTempo();
                            AppManager.clearSelectedTimesig();
                            EditTool selected = AppManager.getSelectedTool();
                            if ( selected == EditTool.PENCIL ||
                                selected == EditTool.LINE ) {
                                int changing_clock = AppManager.clockFromXCoord( e.X );
                                int changing_tempo = AppManager.getVsqFile().getTempoAt( changing_clock );
                                int bar_count;
                                int bar_top_clock;
                                int local_denominator, local_numerator;
                                bar_count = AppManager.getVsqFile().getBarCountFromClock( changing_clock );
                                bar_top_clock = AppManager.getVsqFile().getClockFromBarCount( bar_count );
                                int index2 = -1;
                                for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                                    if ( AppManager.getVsqFile().TimesigTable.get( i ).BarCount > bar_count ) {
                                        index2 = i;
                                        break;
                                    }
                                }
                                if ( index2 >= 1 ) {
                                    local_denominator = AppManager.getVsqFile().TimesigTable.get( index2 - 1 ).Denominator;
                                    local_numerator = AppManager.getVsqFile().TimesigTable.get( index2 - 1 ).Numerator;
                                } else {
                                    local_denominator = AppManager.getVsqFile().TimesigTable.get( 0 ).Denominator;
                                    local_numerator = AppManager.getVsqFile().TimesigTable.get( 0 ).Numerator;
                                }
                                int clock_per_beat = 480 * 4 / local_denominator;
                                int clocks_in_bar = changing_clock - bar_top_clock;
                                int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                FormTempoConfig dlg = null;
                                try {
                                    dlg = new FormTempoConfig( bar_count - AppManager.getVsqFile().getPreMeasure() + 1,
                                                               beat_in_bar,
                                                               local_numerator,
                                                               clocks_in_beat,
                                                               clock_per_beat,
                                                               (decimal)(6e7 / changing_tempo),
                                                               AppManager.getVsqFile().getPreMeasure() );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    if ( dlg.showDialog() == BDialogResult.OK ) {
                                        int new_beat = dlg.getBeatCount();
                                        int new_clocks_in_beat = dlg.getClock();
                                        int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                        AppManager.debugWriteLine( "    new_beat=" + new_beat );
                                        AppManager.debugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                        AppManager.debugWriteLine( "    changing_clock=" + changing_clock );
                                        AppManager.debugWriteLine( "    new_clock=" + new_clock );
#endif
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.Dispose();
                                        } catch ( Exception ex2 ) {
                                        }
                                    }
                                }
                            }
                            #endregion
                        }
                        m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                        #endregion
                    } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.Height - 1 ) {
                        #region 拍子の変更
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        if ( AppManager.getSelectedTimesigCount() > 0 ) {
                            #region 拍子変更があった場合
                            int index = 0;
                            int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                            for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                                if ( AppManager.getVsqFile().TimesigTable.get( i ).BarCount == last_barcount ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( AppManager.getVsqFile().TimesigTable.get( index ).Clock == 0 ) {
                                    statusLabel.Text = _( "Cannot remove first symbol of track!" );
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                int barcount = AppManager.getVsqFile().TimesigTable.get( index ).BarCount;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        } else {
                            #region 拍子変更がなかった場合
                            AppManager.clearSelectedEvent();
                            AppManager.clearSelectedTempo();
                            AppManager.clearSelectedTimesig();
                            EditTool selected = AppManager.getSelectedTool();
                            if ( selected == EditTool.PENCIL ||
                                selected == EditTool.LINE ) {
                                int pre_measure = AppManager.getVsqFile().getPreMeasure();
                                int clock = AppManager.clockFromXCoord( e.X );
                                int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                                int numerator, denominator;
                                Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
                                int total_clock = AppManager.getVsqFile().TotalClocks;
                                //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) - pre_measure + 1;
                                //int min_barcount = 1;
#if DEBUG
                                AppManager.debugWriteLine( "FormMain.picturePositionIndicator_MouseClick; bar_count=" + (bar_count - pre_measure + 1) );
#endif
                                FormBeatConfig dlg = null;
                                try {
                                    dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, true, pre_measure );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    if ( dlg.showDialog() == BDialogResult.OK ) {
                                        if ( dlg.EndSpecified ) {
                                            int[] new_barcounts = new int[2];
                                            int[] numerators = new int[2];
                                            int[] denominators = new int[2];
                                            int[] barcounts = new int[2];
                                            new_barcounts[0] = dlg.Start + pre_measure - 1;
                                            new_barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                            numerators[0] = dlg.Numerator;
                                            numerators[1] = timesig.numerator;

                                            denominators[0] = dlg.Denominator;
                                            denominators[1] = timesig.denominator;

                                            barcounts[0] = dlg.Start + pre_measure - 1;
                                            barcounts[1] = dlg.End + pre_measure - 1 + 1;
                                            CadenciiCommand run = new CadenciiCommand(
                                                VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                            setEdited( true );
                                        } else {
                                            CadenciiCommand run = new CadenciiCommand(
                                                VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                               dlg.Start + pre_measure - 1,
                                                                               dlg.Numerator,
                                                                               dlg.Denominator ) );
                                            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                            setEdited( true );
                                        }
                                    }
                                } catch ( Exception ex ) {
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.Dispose();
                                        } catch ( Exception ex2 ) {
                                        }
                                    }
                                }
                            }
                            #endregion
                        }
                        m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                        #endregion
                    }
                } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ) {
                    int count = AppManager.getSelectedTempoCount();
                    int[] clocks = new int[count];
                    int[] new_clocks = new int[count];
                    int[] tempos = new int[count];
                    int i = -1;
                    boolean contains_first_tempo = false;
                    for ( Iterator<ValuePair<Integer ,SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                        int clock = item.getKey();
                        i++;
                        clocks[i] = clock;
                        if ( clock == 0 ) {
                            contains_first_tempo = true;
                            break;
                        }
                        TempoTableEntry editing = AppManager.getSelectedTempo( clock ).editing;
                        new_clocks[i] = editing.Clock;
                        tempos[i] = editing.Tempo;
                    }
                    if ( contains_first_tempo ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, new_clocks, tempos ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                    int count = AppManager.getSelectedTimesigCount();
                    int[] barcounts = new int[count];
                    int[] new_barcounts = new int[count];
                    int[] numerators = new int[count];
                    int[] denominators = new int[count];
                    int i = -1;
                    boolean contains_first_bar = false;
                    for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                        int bar = item.getKey();
                        i++;
                        barcounts[i] = bar;
                        if ( bar == 0 ) {
                            contains_first_bar = true;
                            break;
                        }
                        TimeSigTableEntry editing = AppManager.getSelectedTimesig( bar ).editing;
                        new_barcounts[i] = editing.BarCount;
                        numerators[i] = editing.Numerator;
                        denominators[i] = editing.Denominator;
                    }
                    if ( contains_first_bar ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    }
                    m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
                }
            }
            m_position_indicator_mouse_down_mode = PositionIndicatorMouseDownMode.NONE;
            pictPianoRoll.Refresh();
            picturePositionIndicator.Refresh();
        }

        public void picturePositionIndicator_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ) {
                int clock = AppManager.clockFromXCoord( e.X ) - m_tempo_dragging_deltaclock;
                int step = AppManager.getPositionQuantizeClock();
                int odd = clock % step;
                clock -= odd;
                if ( odd > step / 2 ) {
                    clock += step;
                }
                int last_clock = AppManager.getLastSelectedTempoClock();
                int dclock = clock - last_clock;
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    AppManager.getSelectedTempo( key ).editing.Clock = AppManager.getSelectedTempo( key ).original.Clock + dclock;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                int clock = AppManager.clockFromXCoord( e.X ) - m_timesig_dragging_deltaclock;
                int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                int dbarcount = barcount - last_barcount;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int bar = item.getKey();
                    AppManager.getSelectedTimesig( bar ).editing.BarCount = AppManager.getSelectedTimesig( bar ).original.BarCount + dbarcount;
                }
                picturePositionIndicator.Refresh();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.MARK_START ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, AppManager.endMarker );
                int draft_end = Math.Max( clock, AppManager.endMarker );
                if ( draft_start != AppManager.startMarker ) {
                    AppManager.startMarker = draft_start;
                }
                if ( draft_end != AppManager.endMarker ) {
                    AppManager.endMarker = draft_end;
                }
                refreshScreen();
            } else if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.MARK_END ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                int odd = clock % unit;
                clock -= odd;
                if ( odd > unit / 2 ) {
                    clock += unit;
                }
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, AppManager.startMarker );
                int draft_end = Math.Max( clock, AppManager.startMarker );
                if ( draft_start != AppManager.startMarker ) {
                    AppManager.startMarker = draft_start;
                }
                if ( draft_end != AppManager.endMarker ) {
                    AppManager.endMarker = draft_end;
                }
                refreshScreen();
            }
        }

        private void picturePositionIndicator_Paint( Object sender, PaintEventArgs e ) {
            picturePositionIndicatorDrawTo( new Graphics2D( e.Graphics ) );
        }

        private void picturePositionIndicator_PreviewKeyDown( Object sender, PreviewKeyDownEventArgs e ) {
            BKeyEventArgs e0 = new KeyEventArgs( e.KeyData );
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        #region trackBar
        private void trackBar_Enter( Object sender, BEventArgs e ) {
            pictPianoRoll.Select();
        }

        private void trackBar_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackBar_ValueChanged( Object sender, BEventArgs e ) {
            AppManager.scaleX = trackBar.Value / 480f;
            AppManager.startToDrawX = (int)(hScroll.Value * AppManager.scaleX);
#if USE_DOBJ
            updateDrawObjectList();
#endif
            this.Refresh();
        }
        #endregion

        #region menuHelp
        private void menuHelpAbout_Click( Object sender, BEventArgs e ) {
            String version_str = AppManager.getVersion();
            if ( m_versioninfo == null || (m_versioninfo != null && m_versioninfo.IsDisposed) ) {
                m_versioninfo = new Boare.Cadencii.VersionInfo( _APP_NAME, version_str );
                m_versioninfo.setAuthorList( _CREDIT );
#if DEBUG
#if AUTHOR_LIST_SAVE_BUTTON_VISIBLE
                m_versioninfo.setSaveAuthorListVisible( true );
#else
                m_versioninfo.setSaveAuthorListVisible( false );
#endif
#else
                m_versioninfo.setSaveAuthorListVisible( false );
#endif
            }
            m_versioninfo.Show();
        }

        private void menuHelpDebug_Click( Object sender, BEventArgs e ) {
            PortUtil.println( "menuHelpDebug_Click" );
#if DEBUG
            /*InputBox ib = new InputBox( "input shift seconds" );
            if ( ib.ShowDialog() == DialogResult.OK ) {
                VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().Clone();
                VsqFileEx.shift( vsq, double.Parse( ib.Result ) );
                CadenciiCommand run = VsqFileEx.generateCommandReplace( vsq );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                Edited = true;
            }*/
            /*DialogResult dr = DialogResult.OK;
            while ( dr == DialogResult.OK ) {
                FileDialog fd = new FileDialog( FileDialog.DialogMode.Open );
                fd.Filter = "All Files(*.*)|*.*|VSQ Format(*.vsq)|*.vsq";
                dr = fd.ShowDialog();
                AppManager.DebugWriteLine( "fd.FileName=" + fd.FileName );
            }*/
            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( SaveFileDialog sfd = new SaveFileDialog() ) {
                        sfd.InitialDirectory = Path.GetDirectoryName( ofd.FileName );
                        sfd.FileName = PortUtil.getFileNameWithoutExtension( ofd.FileName ) + ".txt";
                        if ( sfd.ShowDialog() == DialogResult.OK ) {
                            using ( Wave w = new Wave( ofd.FileName ) ) {
                                w.PrintToText( sfd.FileName );
                            }
                        }
                    }
                }
            }*/

            /*using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    String file = ofd.FileName;
                    using ( Wave wv = new Wave( file ) ) {
                        const double sec_dt = 0.0025;
                        uint samples = wv.TotalSamples;
                        const int _WINDOW_WIDTH = 2048;
                        uint spl_dt = (uint)(sec_dt * wv.SampleRate);
                        double[] window_func = new double[_WINDOW_WIDTH];
                        for ( int i = 0; i < _WINDOW_WIDTH; i++ ) {
                            window_func[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, i / (double)_WINDOW_WIDTH );
                        }
                        Wave.TestEnabled = false;

                        InputBox ib = new InputBox( "input clock count" );
                        if ( ib.ShowDialog() == DialogResult.OK ) {
                            int count = 0;
                            if ( int.TryParse( ib.Result, out count ) ) {
                                Wave.TestEnabled = true;
                                double f0 = wv.GetF0( (uint)count, window_func );
                                AppManager.showMessageBox( "f0=" + f0 + " at sample=" + count );
                                Wave.TestEnabled = false;
                            }
                        }
                        if ( AppManager.showMessageBox( "calculate all formant profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_formanto.txt" ) ) {
                                FormantoDetectionArguments fda = new FormantoDetectionArguments();
                                fda.PeakDetectionThreshold = 0.05;
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double f0 = wv.GetF0( spl_i, window_func, fda );
                                    double note;
                                    if ( f0 > 0.0 ) {
                                        note = 12.0 * Math.Log( f0 / 440.0, 2.0 ) + 69;
                                    } else {
                                        note = 0.0;
                                    }
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + f0 + "\t" + note + "\t" + Math.Round( note, 0, MidpointRounding.AwayFromZero ) );
                                }
                            }
                        }
                        if ( AppManager.showMessageBox( "calculate volume profile?", "Cadencii", MessageBoxButtons.YesNo ) == DialogResult.Yes ) {
                            using ( StreamWriter sw = new StreamWriter( ofd.FileName + "_volume.txt" ) ) {
                                for ( uint spl_i = 0; spl_i < samples; spl_i += spl_dt ) {
                                    double volume = wv.GetVolume( (int)spl_i, window_func );
                                    sw.WriteLine( spl_i + "\t" + (spl_i / (double)wv.SampleRate) + "\t" + volume );
                                }
                            }
                        }
                    }
                }
            }*/
#endif
#if FOO
            using ( OpenFileDialog ofd = new OpenFileDialog() ) {
                if ( ofd.ShowDialog() == DialogResult.OK ) {
                    using ( Wave wv = new Wave( ofd.FileName ) ) {
                        wv.TrimSilence();
                        const int _WIN_LEN = 441;
                        double[] window = new double[_WIN_LEN];
                        for ( int i = 0; i < _WIN_LEN; i++ ) {
                            window[i] = bocoree.math.window_func( bocoree.math.WindowFunctionType.Hamming, (double)i / (double)_WIN_LEN );
                        }
                        using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            for ( int i = 0; i < wv.TotalSamples - _WIN_LEN / 10; i += _WIN_LEN / 10 ) {
                                sw.WriteLine( i / (double)wv.SampleRate + "\t" + wv.GetVolume( i, window ) );
                            }
                        }
                        /*using ( StreamWriter sw = new StreamWriter( ofd.FileName + ".txt" ) ) {
                            double to = 7000.0 * 2.0 / (double)wv.SampleRate;
                            int jmax = (int)(to * _WIN_LEN);
                            double resolution = 1e-3;
                            uint di = (uint)(resolution * wv.SampleRate);
                            for ( uint i = 0; i < wv.TotalSamples; i += di ) {
                                double[] formanto = wv.GetFormanto( i, window );
                                for ( int j = 1; j < _WIN_LEN && j < jmax; j++ ) {
                                    //double f = (double)j / (double)_WIN_LEN * (double)wv.SampleRate / 2.0;
                                    sw.Write( "{0:f4}\t", Math.Abs( formanto[j] ) );
                                }
                                sw.WriteLine();
                            }
                        }*/
                    }
                }
            }
#endif
        }
        #endregion

        #region trackSelector
        private void trackSelector_CommandExecuted( Object sender, BEventArgs e ) {
            setEdited( true );
            refreshScreen();
        }

        private void trackSelector_MouseClick( Object sender, BMouseEventArgs e ) {
            if ( e.Button == BMouseButtons.Right ) {
                if ( AppManager.keyWidth < e.X && e.X < trackSelector.Width ) {
                    if ( trackSelector.Height - TrackSelector.OFFSET_TRACK_TAB <= e.Y && e.Y <= trackSelector.Height ) {
                        cMenuTrackTab.Show( trackSelector, e.Location );
                    } else {
                        cMenuTrackSelector.Show( trackSelector, e.Location );
                    }
                }
            }
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void trackSelector_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( AppManager.keyWidth < e.X ) {
                m_mouse_downed_trackselector = true;
                BMouseButtons btn = e.Button;
                if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == MouseButtons.Left ) {
                    btn = MouseButtons.Middle;
                }
                if ( btn == BMouseButtons.Middle ) {
                    m_edit_curve_mode = CurveEditMode.MIDDLE_DRAG;
                    m_button_initial = new Point( e.X, e.Y );
                    m_middle_button_hscroll = hScroll.Value;
                    this.Cursor = HAND;
                }
            }
        }

        private void trackSelector_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_form_activated ) {
                if ( AppManager.inputTextBox != null && !AppManager.inputTextBox.IsDisposed && !AppManager.inputTextBox.Visible && !AppManager.propertyPanel.Editing ) {
                    trackSelector.Focus();
                }
            }
            if ( e.Button == BMouseButtons.None ) {
                int cl = AppManager.clockFromXCoord( e.X );
                updatePositionViewFromMousePosition( cl );
                refreshScreen();
                return;
            }
            int parent_width = ((TrackSelector)sender).Width;
            if ( m_edit_curve_mode == CurveEditMode.MIDDLE_DRAG ) {
                int dx = e.X - m_button_initial.x;
                int dy = e.Y - m_button_initial.y;
                double new_hscroll_value = (double)m_middle_button_hscroll - (double)dx / AppManager.scaleX;
                int draft;
                if ( new_hscroll_value < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                } else if ( hScroll.Maximum < new_hscroll_value ) {
                    draft = hScroll.Maximum;
                } else {
                    draft = (int)new_hscroll_value;
                }
                if ( AppManager.isPlaying() ) {
                    return;
                }
                if ( hScroll.Value != draft ) {
                    hScroll.Value = draft;
                }
            } else {
                if ( m_mouse_downed_trackselector ) {
                    if ( m_ext_dragx_trackselector == ExtDragXMode.NONE ) {
                        if ( AppManager.keyWidth > e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.LEFT;
                        } else if ( parent_width < e.X ) {
                            m_ext_dragx_trackselector = ExtDragXMode.RIGHT;
                        }
                    } else {
                        if ( AppManager.keyWidth <= e.X && e.X <= parent_width ) {
                            m_ext_dragx_trackselector = ExtDragXMode.NONE;
                        }
                    }
                } else {
                    m_ext_dragx_trackselector = ExtDragXMode.NONE;
                }

                if ( m_ext_dragx_trackselector != ExtDragXMode.NONE ) {
                    double now = PortUtil.getCurrentTime();
                    double dt = now - m_timer_drag_last_ignitted;
                    m_timer_drag_last_ignitted = now;
                    int px_move = AppManager.editorConfig.MouseDragIncrement;
                    if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                        px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                    }
                    px_move += 5;
                    if ( m_ext_dragx_trackselector == ExtDragXMode.LEFT ) {
                        px_move *= -1;
                    }
                    double d_draft = hScroll.Value + px_move / AppManager.scaleX;
                    if ( d_draft < 0.0 ) {
                        d_draft = 0.0;
                    }
                    int draft = (int)d_draft;
                    if ( hScroll.Maximum < draft ) {
                        hScroll.Maximum = draft;
                    }
                    if ( draft < hScroll.Minimum ) {
                        draft = hScroll.Minimum;
                    }
                    hScroll.Value = draft;
                }
            }
            int clock = AppManager.clockFromXCoord( e.X );
            updatePositionViewFromMousePosition( clock );
            refreshScreen();
        }

        private void trackSelector_MouseUp( Object sender, BMouseEventArgs e ) {
            m_mouse_downed_trackselector = false;
            if ( m_edit_curve_mode == CurveEditMode.MIDDLE_DRAG ) {
                m_edit_curve_mode = CurveEditMode.NONE;
                this.Cursor = Cursors.Default;
            }
        }

        private void trackSelector_MouseWheel( Object sender, BMouseEventArgs e ) {
            if ( (Control.ModifierKeys & Keys.Shift) == Keys.Shift ) {
                double new_val = (double)vScroll.Value - e.Delta;
                if ( new_val > vScroll.Maximum ) {
                    vScroll.Value = vScroll.Maximum;
                } else if ( new_val < vScroll.Minimum ) {
                    vScroll.Value = vScroll.Minimum;
                } else {
                    vScroll.Value = (int)new_val;
                }
            } else {
                hScroll.Value = computeScrollValueFromWheelDelta( e.Delta );
            }
            refreshScreen();
        }

        private void trackSelector_PreferredMinHeightChanged( object sender, EventArgs e ) {
            if ( menuVisualControlTrack.Checked ) {
                splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
#if DEBUG
                PortUtil.println( "FormMain#trackSelector_PreferredMinHeightChanged; splitContainer1.Panel2MinSize changed" );
#endif
            }
        }

        private void trackSelector_PreviewKeyDown( Object sender, PreviewKeyDownEventArgs e ) {
            BKeyEventArgs e0 = new KeyEventArgs( e.KeyData );
            processSpecialShortcutKey( e0, true );
        }

        private void trackSelector_RenderRequired( Object sender, int[] tracks ) {
            render( tracks );
            Vector<Integer> t = new Vector<Integer>( tracks );
            if ( t.contains( AppManager.getSelected() ) ) {
                String file = PortUtil.combinePath( AppManager.getTempWaveDir(), AppManager.getSelected() + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
                    Thread loadwave_thread = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    loadwave_thread.IsBackground = true;
                    loadwave_thread.Start( file );
                }
            }
        }

        private void trackSelector_SelectedCurveChanged( Object sender, CurveType type ) {
            refreshScreen();
        }

        private void trackSelector_SelectedTrackChanged( Object sender, int selected ) {
            if ( menuVisualWaveform.Checked ) {
                waveView.Clear();
                String file = PortUtil.combinePath( AppManager.getTempWaveDir(), selected + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
                    Thread load_wave = new Thread( new ParameterizedThreadStart( this.LoadWaveThreadProc ) );
                    load_wave.IsBackground = true;
                    load_wave.Start( (Object)file );
                }
            }
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
#if USE_DOBJ
            updateDrawObjectList();
#endif
            refreshScreen();
        }
        #endregion

        #region cMenuPiano*
        private void cMenuPianoDelete_Click( Object sender, BEventArgs e ) {
            deleteEvent();
        }

        private void cMenuPianoVibratoProperty_Click( Object sender, BEventArgs e ) {
            editNoteVibratoProperty();
        }

        private void cMenuPianoPaste_Click( Object sender, BEventArgs e ) {
            pasteEvent();
        }

        private void cMenuPianoCopy_Click( Object sender, BEventArgs e ) {
            copyEvent();
        }

        private void cMenuPianoCut_Click( Object sender, BEventArgs e ) {
            cutEvent();
        }

        private void cMenuPianoExpression_Click( Object sender, BEventArgs e ) {
            if ( AppManager.getSelectedEventCount() > 0 ) {
                SynthesizerType type = SynthesizerType.VOCALOID2;
                if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                    type = SynthesizerType.VOCALOID1;
                }
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                FormNoteExpressionConfig dlg = null;
                try {
                    dlg = new FormNoteExpressionConfig( type, original.ID.NoteHeadHandle );
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    dlg.PMBendDepth = original.ID.PMBendDepth;
                    dlg.PMBendLength = original.ID.PMBendLength;
                    dlg.PMbPortamentoUse = original.ID.PMbPortamentoUse;
                    dlg.DEMdecGainRate = original.ID.DEMdecGainRate;
                    dlg.DEMaccent = original.ID.DEMaccent;
                    if ( dlg.ShowDialog() == DialogResult.OK ) {
                        VsqID copy = (VsqID)original.ID.clone();
                        copy.PMBendDepth = dlg.PMBendDepth;
                        copy.PMBendLength = dlg.PMBendLength;
                        copy.PMbPortamentoUse = dlg.PMbPortamentoUse;
                        copy.DEMdecGainRate = dlg.DEMdecGainRate;
                        copy.DEMaccent = dlg.DEMaccent;
                        copy.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(), id, copy ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    }
                } catch ( Exception ex ) {
                } finally {
                    if ( dlg != null ) {
                        try {
#if !JAVA
                            dlg.Dispose();
#endif
                        } catch ( Exception ex2 ) {
                        }
                    }
                }
            }
        }

        private void cMenuPianoPointer_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        private void cMenuPianoPencil_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        private void cMenuPianoEraser_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        private void handlePositionQuantize( Object sender, BEventArgs e ) {
            QuantizeMode qm = AppManager.editorConfig.PositionQuantize;
            if ( sender == stripDDBtnQuantize04 || sender == cMenuPianoQuantize04 || sender == menuSettingPositionQuantize04 ) {
                qm = QuantizeMode.p4;
            } else if ( sender == stripDDBtnQuantize08 || sender == cMenuPianoQuantize08 || sender == menuSettingPositionQuantize08 ) {
                qm = QuantizeMode.p8;
            } else if ( sender == stripDDBtnQuantize16 || sender == cMenuPianoQuantize16 || sender == menuSettingPositionQuantize16 ) {
                qm = QuantizeMode.p16;
            } else if ( sender == stripDDBtnQuantize32 || sender == cMenuPianoQuantize32 || sender == menuSettingPositionQuantize32 ) {
                qm = QuantizeMode.p32;
            } else if ( sender == stripDDBtnQuantize64 || sender == cMenuPianoQuantize64 || sender == menuSettingPositionQuantize64 ) {
                qm = QuantizeMode.p64;
            } else if ( sender == stripDDBtnQuantize128 || sender == cMenuPianoQuantize128 || sender == menuSettingPositionQuantize128 ) {
                qm = QuantizeMode.p128;
            } else if ( sender == stripDDBtnQuantizeOff || sender == cMenuPianoQuantizeOff || sender == menuSettingPositionQuantizeOff ) {
                qm = QuantizeMode.off;
            }
            AppManager.editorConfig.PositionQuantize = qm;
            refreshScreen();
        }

        private void h_positionQuantizeTriplet( Object sender, BEventArgs e ) {
            AppManager.editorConfig.PositionQuantizeTriplet = !AppManager.editorConfig.PositionQuantizeTriplet;
            refreshScreen();
        }

        private void h_lengthQuantize04( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p4;
        }

        private void h_lengthQuantize08( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p8;
        }

        private void h_lengthQuantize16( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p16;
        }

        private void h_lengthQuantize32( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p32;
        }

        private void h_lengthQuantize64( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p64;
        }

        private void h_lengthQuantize128( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.p128;
        }

        private void h_lengthQuantizeOff( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantize = QuantizeMode.off;
        }

        private void h_lengthQuantizeTriplet( Object sender, BEventArgs e ) {
            AppManager.editorConfig.LengthQuantizeTriplet = !AppManager.editorConfig.LengthQuantizeTriplet;
        }

        private void cMenuPianoGrid_Click( Object sender, BEventArgs e ) {
            cMenuPianoGrid.Checked = !cMenuPianoGrid.Checked;
            AppManager.setGridVisible( cMenuPianoGrid.Checked );
        }

        private void cMenuPianoUndo_Click( Object sender, BEventArgs e ) {
            undo();
        }

        private void cMenuPianoRedo_Click( Object sender, BEventArgs e ) {
            redo();
        }

        private void cMenuPianoSelectAllEvents_Click( Object sender, BEventArgs e ) {
            selectAllEvent();
        }

        private void cMenuPianoProperty_Click( Object sender, BEventArgs e ) {
            editNoteExpressionProperty();
        }

        private void cMenuPianoImportLyric_Click( Object sender, BEventArgs e ) {
            importLyric();
        }

        private void cMenuPiano_Opening( Object sender, CancelEventArgs e ) {
            updateCopyAndPasteButtonStatus();
            cMenuPianoImportLyric.Enabled = AppManager.getLastSelectedEvent() != null;
        }

        private void cMenuPianoSelectAll_Click( Object sender, BEventArgs e ) {
            selectAll();
        }

        private void cMenuPianoFixed01_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L1 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed02_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L2 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed04_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L4 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed08_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L8 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed16_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L16 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed32_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L32 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed64_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L64 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixed128_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.L128 );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixedOff_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixedTriplet_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setTriplet( !m_pencil_mode.isTriplet() );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoFixedDotted_Click( Object sender, BEventArgs e ) {
            m_pencil_mode.setDot( !m_pencil_mode.isDot() );
            updateCMenuPianoFixed();
        }

        private void cMenuPianoCurve_Click( Object sender, BEventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
            applySelectedTool();
        }
        #endregion

        #region menuTrack*
        private void menuTrack_DropDownOpening( Object sender, BEventArgs e ) {
            updateTrackMenuStatus();
        }

        private void menuTrackCopy_Click( Object sender, BEventArgs e ) {
            copyTrackCore();
        }

        private void menuTrackChangeName_Click( Object sender, BEventArgs e ) {
            changeTrackNameCore();
        }

        private void menuTrackDelete_Click( Object sender, BEventArgs e ) {
            deleteTrackCore();
        }

        private void menuTrackOn_Click( Object sender, BEventArgs e ) {
            menuTrackOn.Checked = !menuTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( AppManager.getSelected(),
                                                                                                      menuTrackOn.Checked ? 1 : -1 ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            refreshScreen();
        }

        private void menuTrackAdd_Click( Object sender, BEventArgs e ) {
            addTrackCore();
        }

        private void menuTrackOverlay_Click( Object sender, BEventArgs e ) {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        private void menuTrackRenderCurrent_Click( Object sender, BEventArgs e ) {
            render( new int[] { AppManager.getSelected() } );
        }

        private void commonTrackRenderAll_Click( Object sender, BEventArgs e ) {
            Vector<Integer> list = new Vector<int>();
            int c = AppManager.getVsqFile().Track.size();
            for ( int i = 1; i < c; i++ ) {
                if ( AppManager.getRenderRequired( i ) ) {
                    list.add( i );
                }
            }
            if ( list.size() <= 0 ) {
                return;
            }
            render( list.toArray( new int[] { } ) );
        }

        private void menuTrackRenderer_DropDownOpening( Object sender, BEventArgs e ) {
            updateRendererMenu();
        }

        private void menuTrackOn_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Enable current track." );
        }

        private void menuTrackAdd_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Add new track." );
        }

        private void menuTrackCopy_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Copy current track." );
        }

        private void menuTrackChangeName_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Change track name." );
        }

        private void menuTrackDelete_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Delete current track." );
        }

        private void menuTrackRenderCurrent_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Render current track." );
        }

        private void menuTrackRenderAll_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Render all tracks." );
        }

        private void menuTrackOverlay_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Show background items." );
        }

        private void menuTrackRenderer_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Select voice synthesis engine." );
        }

        private void menuTrackRendererVOCALOID1_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "VOCALOID1" );
        }

        private void menuTrackRendererVOCALOID2_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "VOCALOID2" );
        }

        private void menuTrackRendererUtau_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "UTAU" );
        }

        private void menuTrackMasterTuning_MouseEnter( Object sender, BEventArgs e ) {
            statusLabel.Text = _( "Set global pitch shift." );
        }
        #endregion

        #region menuHidden*
        private void menuHiddenTrackNext_Click( Object sender, BEventArgs e ) {
            if ( AppManager.getSelected() == AppManager.getVsqFile().Track.size() - 1 ) {
                AppManager.setSelected( 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() + 1 );
            }
            refreshScreen();
        }

        private void menuHiddenTrackBack_Click( Object sender, BEventArgs e ) {
            if ( AppManager.getSelected() == 1 ) {
                AppManager.setSelected( AppManager.getVsqFile().Track.size() - 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() - 1 );
            }
            refreshScreen();
        }

        private void menuHiddenEditPaste_Click( Object sender, BEventArgs e ) {
            pasteEvent();
        }

        private void menuHiddenEditFlipToolPointerPencil_Click( Object sender, BEventArgs e ) {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.PENCIL );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        private void menuHiddenEditFlipToolPointerEraser_Click( Object sender, BEventArgs e ) {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.ERASER );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        private void menuHiddenEditLyric_Click( Object sender, BEventArgs e ) {
            if ( !AppManager.inputTextBox.Enabled && AppManager.getSelectedEventCount() > 0 ) {
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock = original.Clock;
                int note = original.ID.Note;
                Point pos = new Point( AppManager.xCoordFromClocks( clock ), yCoordFromNote( note ) );
                if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                    m_last_symbol_edit_mode = false;
                }
                showInputTextBox( original.ID.LyricHandle.L0.Phrase,
                                  original.ID.LyricHandle.L0.getPhoneticSymbol(),
                                  pos, m_last_symbol_edit_mode );
            } else if ( AppManager.inputTextBox.Enabled ) {
                TagLyricTextBox tltb = (TagLyricTextBox)AppManager.inputTextBox.Tag;
                if ( tltb.PhoneticSymbolEditMode ) {
                    flipInputTextBoxMode();
                }
            }
        }
        #endregion

        #region cMenuTrackTab
        private void cMenuTrackTabCopy_Click( Object sender, BEventArgs e ) {
            copyTrackCore();
        }

        private void cMenuTrackTabChangeName_Click( Object sender, BEventArgs e ) {
            changeTrackNameCore();
        }

        private void cMenuTrackTabTrackOn_Click( Object sender, BEventArgs e ) {
            cMenuTrackTabTrackOn.Checked = !cMenuTrackTabTrackOn.Checked;
            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackChangePlayMode( AppManager.getSelected(),
                                                                                                      cMenuTrackTabTrackOn.Checked ? 1 : -1 ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            refreshScreen();
        }

        private void cMenuTrackTabDelete_Click( Object sender, BEventArgs e ) {
            deleteTrackCore();
        }

        private void cMenuTrackTabAdd_Click( Object sender, BEventArgs e ) {
            addTrackCore();
        }

        private void cMenuTrackTab_Opening( Object sender, CancelEventArgs e ) {
            updateTrackMenuStatus();
        }

        private void updateTrackMenuStatus() {
            cMenuTrackTabDelete.Enabled = menuTrackDelete.Enabled = (AppManager.getVsqFile().Track.size() >= 3);
            cMenuTrackTabAdd.Enabled = menuTrackAdd.Enabled = (AppManager.getVsqFile().Track.size() <= 16);
            cMenuTrackTabCopy.Enabled = menuTrackCopy.Enabled = (AppManager.getVsqFile().Track.size() <= 16);
            cMenuTrackTabTrackOn.Checked = menuTrackOn.Checked = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().PlayMode >= 0;
            if ( AppManager.getVsqFile().Track.size() > 2 ) {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = true;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = AppManager.isOverlay();
            } else {
                cMenuTrackTabOverlay.Enabled = menuTrackOverlay.Enabled = false;
                cMenuTrackTabOverlay.Checked = menuTrackOverlay.Checked = false;
            }
            cMenuTrackTabRenderCurrent.Enabled = menuTrackRenderCurrent.Enabled = !AppManager.isPlaying();
            cMenuTrackTabRenderAll.Enabled = menuTrackRenderAll.Enabled = !AppManager.isPlaying();
            cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = false;
            cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = false;
            cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = false;
            cMenuTrackTabRendererStraight.Checked = menuTrackRendererStraight.Checked = false;

            String version = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version;
            if ( version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                cMenuTrackTabRendererVOCALOID1.Checked = menuTrackRendererVOCALOID1.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                cMenuTrackTabRendererVOCALOID2.Checked = menuTrackRendererVOCALOID2.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                cMenuTrackTabRendererUtau.Checked = menuTrackRendererUtau.Checked = true;
            } else if ( version.StartsWith( VSTiProxy.RENDERER_STR0 ) ) {
                cMenuTrackTabRendererStraight.Checked = menuTrackRendererStraight.Checked = true;
            }
        }

        private void cMenuTrackTabOverlay_Click( Object sender, BEventArgs e ) {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        private void cMenuTrackTabRenderCurrent_Click( Object sender, BEventArgs e ) {
            render( new int[] { AppManager.getSelected() } );
        }

        private void cMenuTrackTabRenderer_DropDownOpening( Object sender, BEventArgs e ) {
            updateRendererMenu();
        }
        #endregion

        #region m_txtbox_track_name
        private void m_txtbox_track_name_KeyUp( Object sender, BKeyEventArgs e ) {
            if ( e.KeyCode == Keys.Enter ) {
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandTrackChangeName( AppManager.getSelected(), m_txtbox_track_name.Text ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
                refreshScreen();
            } else if ( e.KeyCode == Keys.Escape ) {
                m_txtbox_track_name.Dispose();
                m_txtbox_track_name = null;
            }
        }
        #endregion

        #region cMenuTrackSelector
        private void cMenuTrackSelector_Opening( Object sender, CancelEventArgs e ) {
            updateCopyAndPasteButtonStatus();

            // 選択ツールの状態に合わせて表示を更新
            cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
            cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;
            switch ( AppManager.getSelectedTool() ) {
                case EditTool.ARROW:
                    cMenuTrackSelectorPointer.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.PENCIL:
                    cMenuTrackSelectorPencil.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.LINE:
                    cMenuTrackSelectorLine.CheckState = CheckState.Indeterminate;
                    break;
                case EditTool.ERASER:
                    cMenuTrackSelectorEraser.CheckState = CheckState.Indeterminate;
                    break;
            }
            cMenuTrackSelectorCurve.Checked = AppManager.isCurveMode();
        }

        private void cMenuTrackSelectorPointer_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
            refreshScreen();
        }

        private void cMenuTrackSelectorPencil_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
            refreshScreen();
        }

        private void cMenuTrackSelectorLine_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        private void cMenuTrackSelectorEraser_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        private void cMenuTrackSelectorCurve_Click( Object sender, BEventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        private void cMenuTrackSelectorSelectAll_Click( Object sender, BEventArgs e ) {
            selectAllEvent();
        }

        private void cMenuTrackSelectorCut_Click( Object sender, BEventArgs e ) {
            cutEvent();
        }

        private void cMenuTrackSelectorCopy_Click( Object sender, BEventArgs e ) {
            copyEvent();
        }

        private void cMenuTrackSelectorDelete_Click( Object sender, BEventArgs e ) {
            deleteEvent();
        }

        private void cMenuTrackSelectorDeleteBezier_Click( Object sender, BEventArgs e ) {
            for ( Iterator<SelectedBezierPoint> itr = AppManager.getSelectedBezierEnumerator(); itr.hasNext(); ) {
                SelectedBezierPoint sbp = itr.next();
                int chain_id = sbp.chainID;
                int point_id = sbp.pointID;
                BezierChain chain = (BezierChain)AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ).getBezierChain( trackSelector.getSelectedCurve(), chain_id ).Clone();
                int index = -1;
                for ( int i = 0; i < chain.points.size(); i++ ) {
                    if ( chain.points.get( i ).getID() == point_id ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    chain.points.removeElementAt( index );
                    if ( chain.points.size() == 0 ) {
                        CadenciiCommand run = VsqFileEx.generateCommandDeleteBezierChain( AppManager.getSelected(),
                                                                                   trackSelector.getSelectedCurve(),
                                                                                   chain_id,
                                                                                   AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    } else {
                        CadenciiCommand run = VsqFileEx.generateCommandReplaceBezierChain( AppManager.getSelected(),
                                                                                    trackSelector.getSelectedCurve(),
                                                                                    chain_id,
                                                                                    chain,
                                                                                    AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    }
                    setEdited( true );
                    refreshScreen();
                    break;
                }
            }
        }

        private void cMenuTrackSelectorPaste_Click( Object sender, BEventArgs e ) {
            pasteEvent();
        }

        private void cMenuTrackSelectorUndo_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorUndo_Click" );
#endif
            undo();
            refreshScreen();
        }

        private void cMenuTrackSelectorRedo_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorRedo_Click" );
#endif
            redo();
            refreshScreen();
        }
        #endregion

        private void pictureBox3_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void pictureBox2_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void menuStrip1_MouseDown( Object sender, BMouseEventArgs e ) {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
        }

        private void timer_Tick( Object sender, BEventArgs e ) {
            float play_time = -1.0f;
            if ( AppManager.rendererAvailable ) {
                // レンダリング用VSTiが利用可能な状態でAppManager_PreviewStartedした場合
                if ( !AppManager.firstBufferWritten ) {
                    return;
                }
                play_time = VSTiProxy.getPlayTime();
            } else {
                play_time = (float)(PortUtil.getCurrentTime() - AppManager.previewStartedTime);
            }
            if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                play_time = play_time * AppManager.editorConfig.RealtimeInputSpeed;
            }
            float now = (float)(play_time + m_direct_play_shift);
#if DEBUG
            //PortUtil.println( "FormMain#timer_Tick; now=" + now + "; play_time=" + play_time + "; m_preview_ending_time=" + m_preview_ending_time );
#endif

            if ( (play_time < 0.0 || m_preview_ending_time < now) && AppManager.getEditMode() != EditMode.REALTIME ) {
#if DEBUG
                PortUtil.println( "FormMain#timer_Tick; setPlaying(false); A" );
#endif
                AppManager.setPlaying( false );
                timer.Stop();
                if ( AppManager.startMarkerEnabled ) {
                    AppManager.setCurrentClock( AppManager.startMarker );
                }
                ensureCursorVisible();
                return;
            }
            int clock = (int)AppManager.getVsqFile().getClockFromSec( now );
            if ( clock > hScroll.Maximum ) {
                if ( AppManager.getEditMode() == EditMode.REALTIME ) {
                    hScroll.Maximum = clock + (int)((pictPianoRoll.Width - AppManager.keyWidth) / 2.0f / AppManager.scaleX);
                } else {
                    //AppManager.CurrentClock = 0;
                    //EnsureCursorVisible();
#if DEBUG
                    PortUtil.println( "FormMain#timer_Tick; AppManager.isRepeatMode()=" + AppManager.isRepeatMode() );
#endif
                    if ( !AppManager.isRepeatMode() ) {
#if DEBUG
                        PortUtil.println( "FormMain#timer_Tick; setPlaying(false); B" );
#endif
                        timer.Stop();
                        AppManager.setPlaying( false );
                    }
                }
            } else if ( AppManager.endMarkerEnabled && clock > (int)AppManager.endMarker && AppManager.getEditMode() != EditMode.REALTIME ) {
                AppManager.setCurrentClock( (AppManager.startMarkerEnabled) ? AppManager.startMarker : 0 );
                ensureCursorVisible();
                AppManager.setPlaying( false );
                if ( AppManager.isRepeatMode() ) {
                    AppManager.setPlaying( true );
                } else {
                    timer.Stop();
                }
            } else {
                AppManager.setCurrentClock( (int)clock );
                if ( AppManager.autoScroll ) {
                    if ( AppManager.editorConfig.CursorFixed ) {
                        float f_draft = clock - (pictPianoRoll.Width / 2 + 34 - 70) / AppManager.scaleX;
                        if ( f_draft < 0f ) {
                            f_draft = 0;
                        }
                        int draft = (int)(f_draft);
                        if ( draft < hScroll.Minimum ) {
                            draft = hScroll.Minimum;
                        } else if ( hScroll.Maximum < draft ) {
                            draft = hScroll.Maximum;
                        }
                        if ( hScroll.Value != draft ) {
                            hScroll.Value = draft;
                        }
                    } else {
                        ensureCursorVisible();
                    }
                }
            }
            refreshScreen();
        }

        private void bgWorkScreen_DoWork( Object sender, DoWorkEventArgs e ) {
            try {
                this.Invoke( new EventHandler( this.refreshScreenCore ) );
            } catch ( Exception ex ) {
            }
        }

        private void toolStripEdit_Move( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ToolEditTool.Location = new XmlPoint( toolStripTool.Location.X, toolStripTool.Location.Y );
        }

        private void toolStripEdit_ParentChanged( Object sender, BEventArgs e ) {
            if ( toolStripTool.Parent != null ) {
                if ( toolStripTool.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolEditTool.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripPosition_Move( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ToolPositionLocation.Location = new XmlPoint( toolStripPosition.Location.X, toolStripPosition.Location.Y );
        }

        private void toolStripPosition_ParentChanged( Object sender, BEventArgs e ) {
            if ( toolStripPosition.Parent != null ) {
                if ( toolStripPosition.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolPositionLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        private void toolStripMeasure_Move( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ToolMeasureLocation.Location = new XmlPoint( toolStripMeasure.Location.X, toolStripMeasure.Location.Y );
        }

        private void toolStripMeasure_ParentChanged( Object sender, BEventArgs e ) {
            if ( toolStripMeasure.Parent != null ) {
                if ( toolStripMeasure.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolMeasureLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        void toolStripFile_Move( Object sender, BEventArgs e ) {
            AppManager.editorConfig.ToolFileLocation.Location = new XmlPoint( toolStripFile.Location.X, toolStripFile.Location.Y );
        }

        void toolStripFile_ParentChanged( Object sender, BEventArgs e ) {
            if ( toolStripFile.Parent != null ) {
                if ( toolStripFile.Parent.Equals( toolStripContainer.TopToolStripPanel ) ) {
                    AppManager.editorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Top;
                } else {
                    AppManager.editorConfig.ToolFileLocation.Parent = ToolStripLocation.ParentPanel.Bottom;
                }
            }
        }

        #region stripBtn*
        private void stripBtnGrid_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.setGridVisible( stripBtnGrid.Checked );
        }

        private void stripBtnArrow_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        private void stripBtnPencil_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        private void stripBtnLine_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        private void stripBtnEraser_Click( Object sender, BEventArgs e ) {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        private void stripBtnCurve_Click( Object sender, BEventArgs e ) {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        private void stripBtnPlay_Click( Object sender, BEventArgs e ) {
            if ( !AppManager.isPlaying() ) {
                AppManager.setPlaying( true );
            }
            pictPianoRoll.Focus();
        }

        private void stripBtnScroll_Click( Object sender, BEventArgs e ) {
            stripBtnScroll.Checked = !stripBtnScroll.Checked;
            AppManager.autoScroll = stripBtnScroll.Checked;
            pictPianoRoll.Focus();
        }

        private void stripBtnLoop_Click( Object sender, BEventArgs e ) {
            stripBtnLoop.Checked = !stripBtnLoop.Checked;
            AppManager.setRepeatMode( stripBtnLoop.Checked );
            pictPianoRoll.Focus();
        }

        private void stripBtnStop_Click( Object sender, BEventArgs e ) {
            AppManager.setPlaying( false );
            timer.Stop();
            pictPianoRoll.Focus();
        }

        private void handleStartMarker_Click( Object sender, BEventArgs e ) {
            AppManager.startMarkerEnabled = !AppManager.startMarkerEnabled;
            stripBtnStartMarker.Checked = AppManager.startMarkerEnabled;
            menuVisualStartMarker.Checked = AppManager.startMarkerEnabled;
            pictPianoRoll.Focus();
            refreshScreen();
        }

        private void handleEndMarker_Click( Object sender, BEventArgs e ) {
            AppManager.endMarkerEnabled = !AppManager.endMarkerEnabled;
            stripBtnEndMarker.Checked = AppManager.endMarkerEnabled;
            menuVisualEndMarker.Checked = AppManager.endMarkerEnabled;
            pictPianoRoll.Focus();
            refreshScreen();
        }

        private void stripBtnMoveEnd_Click( Object sender, BEventArgs e ) {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
            AppManager.setCurrentClock( AppManager.getVsqFile().TotalClocks );
            ensureCursorVisible();
            refreshScreen();
        }

        private void stripBtnMoveTop_Click( Object sender, BEventArgs e ) {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
            AppManager.setCurrentClock( 0 );
            ensureCursorVisible();
            refreshScreen();
        }

        private void stripBtnRewind_Click( Object sender, BEventArgs e ) {
            rewind();
        }

        private void stripBtnForward_Click( Object sender, BEventArgs e ) {
            forward();
        }
        #endregion

        private void commonCaptureSpaceKeyDown( Object sender, BKeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = true;
            }
        }

        private void commonCaptureSpaceKeyUp( Object sender, BKeyEventArgs e ) {
            if ( (e.KeyCode & Keys.Space) == Keys.Space ) {
                m_spacekey_downed = false;
            }
        }

        private void commonRendererVOCALOID1_Click( Object sender, BEventArgs e ) {
            String old = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                VsqTrack item = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                Vector<VsqID> singers = new Vector<VsqID>();
                SingerConfig[] configs = VocaloSysUtil.getSingerConfigs( SynthesizerType.VOCALOID1 );
                for( int i = 0; i < configs.Length; i++ ){
                    SingerConfig sc = configs[i];
                    singers.add( VocaloSysUtil.getSingerID( sc.Language, sc.Program, SynthesizerType.VOCALOID1 ) );
                }
                item.changeRenderer( "DSB202", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                             item,
                                                                             AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedStart( 0 );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedEnd( AppManager.getVsqFile().TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = true;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = false;
                cMenuTrackTabRendererStraight.Checked = false;
                menuTrackRendererVOCALOID1.Checked = true;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = false;
                menuTrackRendererStraight.Checked = false;
                setEdited( true );
                refreshScreen();
            }
        }

        private void commonRendererVOCALOID2_Click( Object sender, BEventArgs e ) {
            String old = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_DSB3 ) ) {
                VsqTrack item = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                Vector<VsqID> singers = new Vector<VsqID>();
                SingerConfig[] configs = VocaloSysUtil.getSingerConfigs( SynthesizerType.VOCALOID2 );
                for( int i = 0; i < configs.Length; i++ ){
                    SingerConfig sc = configs[i];
                    singers.add( VocaloSysUtil.getSingerID( sc.Language, sc.Program, SynthesizerType.VOCALOID2 ) );
                }
                item.changeRenderer( "DSB301", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                             item,
                                                                             AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedStart( 0 );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedEnd( AppManager.getVsqFile().TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = true;
                cMenuTrackTabRendererUtau.Checked = false;
                cMenuTrackTabRendererStraight.Checked = false;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = true;
                menuTrackRendererUtau.Checked = false;
                menuTrackRendererStraight.Checked = false;
                setEdited( true );
                refreshScreen();
            }
        }

        private void commonRendererUtau_Click( Object sender, BEventArgs e ) {
            String old = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_UTU0 ) ) {
                VsqTrack item = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                Vector<SingerConfig> list = AppManager.editorConfig.UtauSingers;
                Vector<VsqID> singers = new Vector<VsqID>();
                for ( Iterator<SingerConfig> itr = list.iterator(); itr.hasNext(); ) {
                    SingerConfig sc = itr.next();
                    singers.add( AppManager.getSingerIDUtau( sc.Language, sc.Program ) );
                }
                item.changeRenderer( "UTU000", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                             item,
                                                                             AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedStart( 0 );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedEnd( AppManager.getVsqFile().TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = true;
                cMenuTrackTabRendererStraight.Checked = false;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = true;
                menuTrackRendererStraight.Checked = false;
                setEdited( true );
                refreshScreen();
            }
        }

        private void commonRendererStraight_Click( Object sender, BEventArgs e ) {
            String old = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version;
            if ( !old.StartsWith( VSTiProxy.RENDERER_STR0 ) ) {
                VsqTrack item = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
                Vector<SingerConfig> list = AppManager.editorConfig.UtauSingers;
                Vector<VsqID> singers = new Vector<VsqID>();
                for ( Iterator<SingerConfig> itr = list.iterator(); itr.hasNext(); ) {
                    SingerConfig sc = itr.next();
                    singers.add( AppManager.getSingerIDUtau( sc.Language, sc.Program ) );
                }
                item.changeRenderer( "STR000", singers );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( AppManager.getSelected(),
                                                                             item,
                                                                             AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedStart( 0 );
                AppManager.getVsqFile().Track.get( AppManager.getSelected() ).setEditedEnd( AppManager.getVsqFile().TotalClocks );
                cMenuTrackTabRendererVOCALOID1.Checked = false;
                cMenuTrackTabRendererVOCALOID2.Checked = false;
                cMenuTrackTabRendererUtau.Checked = false;
                cMenuTrackTabRendererStraight.Checked = true;
                menuTrackRendererVOCALOID1.Checked = false;
                menuTrackRendererVOCALOID2.Checked = false;
                menuTrackRendererUtau.Checked = false;
                menuTrackRendererStraight.Checked = true;
                setEdited( true );
                refreshScreen();
            }
        }

        private void toolStripContainer_TopToolStripPanel_SizeChanged( Object sender, BEventArgs e ) {
            if ( this.WindowState == FormWindowState.Minimized ) {
                return;
            }
            Dimension minsize = getWindowMinimumSize();
            int wid = this.Width;
            int hei = this.Height;
            boolean change_size_required = false;
            if ( minsize.width > wid ) {
                wid = minsize.width;
                change_size_required = true;
            }
            if ( minsize.height > hei ) {
                hei = minsize.height;
                change_size_required = true;
            }
            this.setMinimumSize( getWindowMinimumSize() );
            if ( change_size_required ) {
                this.setSize( wid, hei );
            }
        }

        private void stripDDBtnSpeed_DropDownOpening( Object sender, BEventArgs e ) {
            if ( AppManager.editorConfig.RealtimeInputSpeed == 1.0f ) {
                stripDDBtnSpeed100.Checked = true;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = "100";
            } else if ( AppManager.editorConfig.RealtimeInputSpeed == 0.5f ) {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = true;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = "50";
            } else if ( AppManager.editorConfig.RealtimeInputSpeed == 1.0f / 3.0f ) {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = true;
                stripDDBtnSpeedTextbox.Text = "33.333";
            } else {
                stripDDBtnSpeed100.Checked = false;
                stripDDBtnSpeed050.Checked = false;
                stripDDBtnSpeed033.Checked = false;
                stripDDBtnSpeedTextbox.Text = (AppManager.editorConfig.RealtimeInputSpeed * 100.0f).ToString();
            }
        }

        private void stripDDBtnSpeed100_Click( Object sender, BEventArgs e ) {
            changeRealtimeInputSpeed( 1.0f );
            AppManager.editorConfig.RealtimeInputSpeed = 1.0f;
            updateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeed050_Click( Object sender, BEventArgs e ) {
            changeRealtimeInputSpeed( 0.5f );
            AppManager.editorConfig.RealtimeInputSpeed = 0.5f;
            updateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeed033_Click( Object sender, BEventArgs e ) {
            changeRealtimeInputSpeed( 1.0f / 3.0f );
            AppManager.editorConfig.RealtimeInputSpeed = 1.0f / 3.0f;
            updateStripDDBtnSpeed();
        }

        private void stripDDBtnSpeedTextbox_KeyDown( Object sender, BKeyEventArgs e ) {
            if ( e.KeyCode == Keys.Enter ) {
                float v;
                try {
                    v = PortUtil.parseFloat( stripDDBtnSpeedTextbox.Text );
                    changeRealtimeInputSpeed( v / 100.0f );
                    AppManager.editorConfig.RealtimeInputSpeed = v / 100.0f;
                    stripDDBtnSpeed.HideDropDown();
                    updateStripDDBtnSpeed();
                } catch ( Exception ex ) {
                }
            }
        }

        public void changeRealtimeInputSpeed( float newv ) {
            float old = AppManager.editorConfig.RealtimeInputSpeed;
            double now = PortUtil.getCurrentTime();
            float play_time = (float)(now - AppManager.previewStartedTime) * old / newv;
            int sec = (int)(Math.Floor( play_time ) + 0.1);
            int millisec = (int)((play_time - sec) * 1000);
            AppManager.previewStartedTime = now - (sec + millisec / 1000.0);
            MidiPlayer.SetSpeed( newv, AppManager.previewStartedTime );
        }

        /// <summary>
        /// stripDDBtnSpeedの表示状態を更新します
        /// </summary>
        private void updateStripDDBtnSpeed() {
            stripDDBtnSpeed.Text = _( "Speed" ) + " " + (AppManager.editorConfig.RealtimeInputSpeed * 100) + "%";
        }

        private void menuSetting_DropDownOpening( Object sender, BEventArgs e ) {
            menuSettingMidi.Enabled = AppManager.getEditMode() != EditMode.REALTIME;
        }

        private void menuVisualProperty_Click( Object sender, BEventArgs e ) {
            if ( menuVisualProperty.Checked ) {
                if ( AppManager.editorConfig.PropertyWindowStatus.WindowState == BFormWindowState.Minimized ) {
                    updatePropertyPanelState( PanelState.Docked );
                } else {
                    updatePropertyPanelState( PanelState.Window );
                }
            } else {
                updatePropertyPanelState( PanelState.Hidden );
            }
        }

        private void menuSettingUtauVoiceDB_Click( Object sender, BEventArgs e ) {
            String edit_oto_ini = PortUtil.combinePath( Application.StartupPath, "EditOtoIni.exe" );
            if ( !PortUtil.isFileExists( edit_oto_ini ) ) {
                return;
            }

            ProcessStartInfo psi = new ProcessStartInfo();
            psi.FileName = Environment.GetEnvironmentVariable( "ComSpec" );
            psi.Arguments = "/c \"" + edit_oto_ini + "\"";
            psi.WindowStyle = ProcessWindowStyle.Hidden;
            psi.CreateNoWindow = true;
            psi.UseShellExecute = false;
            Process.Start( psi );
        }

        private void menuVisualOverview_CheckedChanged( Object sender, BEventArgs e ) {
            AppManager.editorConfig.OverviewEnabled = menuVisualOverview.Checked;
            updateLayout();
        }

        private void pictOverview_MouseMove( Object sender, BMouseEventArgs e ) {
            if ( m_overview_mouse_down_mode == OverviewMouseDownMode.LEFT ) {
                int draft = getOverviewStartToDrawX( e.X );
                if ( draft < 0 ) {
                    draft = 0;
                }
                AppManager.startToDrawX = draft;
                refreshScreen();
            } else if ( m_overview_mouse_down_mode == OverviewMouseDownMode.MIDDLE ) {
                int dx = e.X - m_overview_mouse_downed_locationx;
                int draft = m_overview_start_to_draw_clock_initial_value - (int)(dx / m_overview_px_per_clock);
                int clock = getOverviewClockFromXCoord( pictOverview.Width, draft );
                if ( AppManager.getVsqFile().TotalClocks < clock ) {
                    draft = AppManager.getVsqFile().TotalClocks - (int)(pictOverview.Width / m_overview_px_per_clock);
                }
                if ( draft < 0 ) {
                    draft = 0;
                }
                m_overview_start_to_draw_clock = draft;
                refreshScreen();
            }
        }

        private int getOverviewStartToDrawX( int mouse_x ) {
            float clock = mouse_x / m_overview_px_per_clock + m_overview_start_to_draw_clock;
            int clock_at_left = (int)(clock - (pictPianoRoll.Width - AppManager.keyWidth) / AppManager.scaleX / 2);
            return (int)(clock_at_left * AppManager.scaleX);
        }

        private void pictOverview_MouseDown( Object sender, BMouseEventArgs e ) {
            BMouseButtons btn = e.Button;
            if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier && m_spacekey_downed && e.Button == MouseButtons.Left ) {
                btn = MouseButtons.Middle;
            }
            if ( btn == BMouseButtons.Middle ) {
                m_overview_mouse_down_mode = OverviewMouseDownMode.MIDDLE;
                m_overview_mouse_downed_locationx = e.X;
                m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            } else if ( e.Button == BMouseButtons.Left ) {
                if ( e.Clicks == 1 ) {
                    m_overview_mouse_down_mode = OverviewMouseDownMode.LEFT;
                    int draft = getOverviewStartToDrawX( e.X );
                    if ( draft < 0 ) {
                        draft = 0;
                    }
                    AppManager.startToDrawX = draft;
                    refreshScreen();
                }
            }
        }

        private void pictOverview_MouseUp( Object sender, BMouseEventArgs e ) {
            if ( m_overview_mouse_down_mode == OverviewMouseDownMode.LEFT ) {
                AppManager.startToDrawX = (int)(hScroll.Value * AppManager.scaleX);
            }
            m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
            refreshScreen();
        }

        private void pictOverview_Paint( Object sender, PaintEventArgs e ) {
            Graphics2D g = new bocoree.awt.Graphics2D( e.Graphics );
            int count = 0;
            int sum = 0;
            int height = pictOverview.Height;
            BasicStroke pen = new bocoree.awt.BasicStroke( _OVERVIEW_DOT_DIAM );
            g.setStroke( pen );
            g.setColor( s_note_fill );
            //using ( Pen pen = new Pen( s_note_fill, _OVERVIEW_DOT_DIAM ) ) {
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getNoteEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                int x = getOverviewXCoordFromClock( item.Clock );
                if ( x < 0 ) {
                    continue;
                }
                if ( pictOverview.Width < x ) {
                    break;
                }
                count++;
                sum += item.ID.Note;
                int y = height - (height / 2 + (int)((item.ID.Note - m_overview_average_note) * _OVERVIEW_DOT_DIAM));
                int length = (int)(item.ID.Length * m_overview_px_per_clock);
                if ( length < _OVERVIEW_DOT_DIAM ) {
                    length = _OVERVIEW_DOT_DIAM;
                }
                g.drawLine( x, y, x + length, y );
            }
            g.setStroke( new BasicStroke() );
            //}
            int current_start = AppManager.clockFromXCoord( AppManager.keyWidth );
            int current_end = AppManager.clockFromXCoord( pictPianoRoll.Width );
            int x_start = getOverviewXCoordFromClock( current_start );
            int x_end = getOverviewXCoordFromClock( current_end );

            // 小節ごとの線
            int clock_start = getOverviewClockFromXCoord( 0 );
            int clock_end = getOverviewClockFromXCoord( pictOverview.Width );
            int premeasure = AppManager.getVsqFile().getPreMeasure();
            g.setClip( null );
            BasicStroke pen_bold = new bocoree.awt.BasicStroke( 2 );
            Color pen_color = new bocoree.awt.Color( 0, 0, 0, 130 );

            int barcountx = 0;
            String barcountstr = "";
            for ( Iterator<VsqBarLineType> itr = AppManager.getVsqFile().getBarLineIterator( clock_end * 3 / 2 ); itr.hasNext(); ) {
                VsqBarLineType bar = itr.next();
                if ( bar.clock() < clock_start ) {
                    continue;
                }
                if ( pictOverview.Width < barcountx ) {
                    break;
                }
                if ( bar.isSeparator() ) {
                    int barcount = bar.getBarCount() - premeasure + 1;
                    int x = getOverviewXCoordFromClock( bar.clock() );
                    if ( (barcount % 5 == 0 && barcount > 0) || barcount == 1 ) {
                        g.setColor( pen_color );
                        g.setStroke( pen_bold );
                        g.drawLine( x, 0, x, pictOverview.Height );

                        g.setStroke( new BasicStroke() );
                        if ( !barcountstr.Equals( "" ) ) {
                            g.setColor( Color.white );
                            g.setFont( AppManager.baseFont9 );
                            g.drawString( barcountstr, barcountx + 1, 1 );
                        }
                        barcountstr = barcount + "";
                        barcountx = x;
                    } else {
                        g.setColor( pen_color );
                        g.drawLine( x, 0, x, pictOverview.Height );
                    }
                }
            }
            g.setClip( null );

            // 移動中している最中に，移動開始直前の部分を影付で表示する
            int act_start_to_draw_x = (int)(hScroll.Value * AppManager.scaleX);
            if ( act_start_to_draw_x != AppManager.startToDrawX ) {
                int act_start_clock = AppManager.clockFromXCoord( AppManager.keyWidth - AppManager.startToDrawX + act_start_to_draw_x );
                int act_end_clock = AppManager.clockFromXCoord( pictPianoRoll.Width - AppManager.startToDrawX + act_start_to_draw_x );
                int act_start_x = getOverviewXCoordFromClock( act_start_clock );
                int act_end_x = getOverviewXCoordFromClock( act_end_clock );
                Rectangle rcm = new Rectangle( act_start_x, 0, act_end_x - act_start_x, height );
                g.setColor( new Color( 0, 0, 0, 100 ) );
                g.fillRect( rcm.x, rcm.y, rcm.width, rcm.height );
            }

            // 現在の表示範囲
            Rectangle rc = new Rectangle( x_start, 0, x_end - x_start, height - 1 );
            g.setColor( new Color( 255, 255, 255, 50 ) );
            g.fillRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( AppManager.getHilightColor() );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            if ( count > 0 ) {
                m_overview_average_note = sum / (float)count;
            }

            // ソングポジション
            int px_current_clock = (int)((AppManager.getCurrentClock() - m_overview_start_to_draw_clock) * m_overview_px_per_clock);
            g.setStroke( new BasicStroke( 2 ) );
            g.setColor( Color.white );
            g.drawLine( px_current_clock, 0, px_current_clock, pictOverview.Height );
            g.setStroke( new BasicStroke() );
        }

        private int getOverviewXCoordFromClock( int clock ) {
            return (int)((clock - m_overview_start_to_draw_clock) * m_overview_px_per_clock);
        }

        private int getOverviewClockFromXCoord( int x, int start_to_draw_clock ) {
            return (int)(x / m_overview_px_per_clock) + start_to_draw_clock;
        }

        private int getOverviewClockFromXCoord( int x ) {
            return getOverviewClockFromXCoord( x, m_overview_start_to_draw_clock );
        }

        private void pictOverview_MouseDoubleClick( Object sender, BMouseEventArgs e ) {
            m_overview_mouse_down_mode = OverviewMouseDownMode.NONE;
            int draft_stdx = getOverviewStartToDrawX( e.X );
            int draft = (int)(draft_stdx / AppManager.scaleX);
            if ( draft < hScroll.Minimum ) {
                draft = hScroll.Minimum;
            } else if ( hScroll.Maximum < draft ) {
                draft = hScroll.Maximum;
            }
            hScroll.Value = draft;
            refreshScreen();
        }

        private void btnLeft_MouseDown( Object sender, BMouseEventArgs e ) {
            m_overview_btn_downed = DateTime.Now;
            m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            if ( m_overview_update_thread != null ) {
                try {
                    m_overview_update_thread.Abort();
                    while ( m_overview_update_thread.IsAlive ) {
                        Application.DoEvents();
                    }
                } catch ( Exception ex ) {
                }
                m_overview_update_thread = null;
            }
            m_overview_direction = -1;
            m_overview_update_thread = new Thread( new ThreadStart( updateOverview ) );
            m_overview_update_thread.Start();
        }

        private void btnLeft_MouseUp( Object sender, BMouseEventArgs e ) {
            overviewStopThread();
        }

        private void btnRight_MouseDown( Object sender, BMouseEventArgs e ) {
            m_overview_btn_downed = DateTime.Now;
            m_overview_start_to_draw_clock_initial_value = m_overview_start_to_draw_clock;
            if ( m_overview_update_thread != null ) {
                try {
                    while ( m_overview_update_thread.IsAlive ) {
                        Application.DoEvents();
                    }
                } catch ( Exception ex ) {
                }
                m_overview_update_thread = null;
            }
            m_overview_direction = 1;
            m_overview_update_thread = new Thread( new ThreadStart( updateOverview ) );
            m_overview_update_thread.Start();
        }

        private void btnRight_MouseUp( Object sender, BMouseEventArgs e ) {
            overviewStopThread();
        }

        private void updateOverview() {
            while ( true ) {
#if DEBUG
                PortUtil.println( "updateOverview" );
#endif
                Thread.Sleep( 100 );
                double dt = DateTime.Now.Subtract( m_overview_btn_downed ).TotalSeconds;
                int draft = (int)(m_overview_start_to_draw_clock_initial_value + m_overview_direction * dt * _OVERVIEW_SCROLL_SPEED / m_overview_px_per_clock);
                int clock = getOverviewClockFromXCoord( pictOverview.Width, draft );
                if ( AppManager.getVsqFile().TotalClocks < clock ) {
                    draft = AppManager.getVsqFile().TotalClocks - (int)(pictOverview.Width / m_overview_px_per_clock);
                }
                if ( draft < 0 ) {
                    draft = 0;
                }
                m_overview_start_to_draw_clock = draft;
                if ( this == null || (this != null && this.IsDisposed) ) {
                    break;
                }
                this.Invoke( new BEventHandler( invalidatePictOverview ) );
            }
        }

        private void invalidatePictOverview( Object sender, BEventArgs e ) {
            pictOverview.Invalidate();
        }

        private void btnMooz_Click( Object sender, BEventArgs e ) {
            int draft = m_overview_scale_count - 1;
            if ( draft < _OVERVIEW_SCALE_COUNT_MIN ) {
                draft = _OVERVIEW_SCALE_COUNT_MIN;
            }
            m_overview_scale_count = draft;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );
            AppManager.editorConfig.OverviewScaleCount = m_overview_scale_count;
            refreshScreen();
        }

        private void btnZoom_Click( Object sender, BEventArgs e ) {
            int draft = m_overview_scale_count + 1;
            if ( _OVERVIEW_SCALE_COUNT_MAX < draft ) {
                draft = _OVERVIEW_SCALE_COUNT_MAX;
            }
            m_overview_scale_count = draft;
            m_overview_px_per_clock = getOverviewScaleX( m_overview_scale_count );
            AppManager.editorConfig.OverviewScaleCount = m_overview_scale_count;
            refreshScreen();
        }

        private float getOverviewScaleX( int scale_count ) {
            return (float)Math.Pow( 10.0, 0.2 * scale_count - 3.0 );
        }

        public void updateBgmMenuState() {
            menuTrackBgm.DropDown.Items.Clear();
            int count = AppManager.getBgmCount();
            if ( count > 0 ) {
                for ( int i = 0; i < count; i++ ) {
                    BgmFile item = AppManager.getBgm( i );
                    ToolStripMenuItem menu = new ToolStripMenuItem( PortUtil.getFileName( item.file ) );
                    menu.ToolTipText = item.file;

                    ToolStripMenuItem menu_remove = new ToolStripMenuItem( _( "Remove" ) );
                    menu_remove.ToolTipText = item.file;
                    menu_remove.Tag = (int)i;
                    menu_remove.Click += new EventHandler( handleBgmRemove_Click );
                    menu.DropDown.Items.Add( menu_remove );

                    ToolStripMenuItem menu_start_after_premeasure = new ToolStripMenuItem( _( "Start After Premeasure" ) );
                    menu_start_after_premeasure.Name = "menu_start_after_premeasure" + i;
                    menu_start_after_premeasure.Tag = (int)i;
                    menu_start_after_premeasure.CheckOnClick = true;
                    menu_start_after_premeasure.Checked = item.startAfterPremeasure;
                    menu_start_after_premeasure.CheckedChanged += new EventHandler( handleBgmStartAfterPremeasure_CheckedChanged );
                    menu.DropDown.Items.Add( menu_start_after_premeasure );

                    ToolStripMenuItem menu_offset_second = new ToolStripMenuItem( _( "Set Offset Seconds" ) );
                    menu_offset_second.Tag = (int)i;
                    menu_offset_second.ToolTipText = item.readOffsetSeconds + " " + _( "seconds" );
                    menu_offset_second.Click += new EventHandler( handleBgmOffsetSeconds_Click );
                    menu.DropDown.Items.Add( menu_offset_second );

                    menuTrackBgm.DropDown.Items.Add( menu );
                }
                menuTrackBgm.DropDown.Items.Add( new ToolStripSeparator() );
            }
            ToolStripMenuItem menu_add = new ToolStripMenuItem( _( "Add" ) );
            menu_add.Click += new EventHandler( handleBgmAdd_Click );
            menuTrackBgm.DropDown.Items.Add( menu_add );
        }

        private void handleBgmOffsetSeconds_Click( Object sender, BEventArgs e ) {
            if ( !(sender is ToolStripMenuItem) ) {
                return;
            }
            ToolStripMenuItem parent = (ToolStripMenuItem)sender;
            if ( parent.Tag == null ) {
                return;
            }
            if ( !(parent.Tag is int) ) {
                return;
            }
            int index = (int)parent.Tag;
            InputBox ib = null;
            try {
                ib = new InputBox( _( "Input Offset Seconds" ) );
                ib.setLocation( getFormPreferedLocation( ib ) );
                ib.setResult( AppManager.getBgm( index ).readOffsetSeconds + "" );
                if ( ib.ShowDialog() != DialogResult.OK ) {
                    return;
                }
                Vector<BgmFile> list = new Vector<BgmFile>();
                int count = AppManager.getBgmCount();
                BgmFile item = null;
                for ( int i = 0; i < count; i++ ) {
                    if ( i == index ) {
                        item = (BgmFile)AppManager.getBgm( i ).clone();
                        list.add( item );
                    } else {
                        list.add( AppManager.getBgm( i ) );
                    }
                }
                double draft;
                try {
                    draft = PortUtil.parseDouble( ib.getResult() );
                    item.readOffsetSeconds = draft;
                    parent.ToolTipText = draft + " " + _( "seconds" );
                } catch ( Exception ex3 ) {
                }
                CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            } catch ( Exception ex ) {
            } finally {
                if ( ib != null ) {
                    try {
#if !JAVA
                        ib.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void handleBgmStartAfterPremeasure_CheckedChanged( Object sender, BEventArgs e ) {
            if ( !(sender is ToolStripMenuItem) ) {
                return;
            }
            ToolStripMenuItem parent = (ToolStripMenuItem)sender;
            if ( parent.Tag == null ) {
                return;
            }
            if ( !(parent.Tag is int) ) {
                return;
            }
            int index = (int)parent.Tag;
            Vector<BgmFile> list = new Vector<BgmFile>();
            int count = AppManager.getBgmCount();
            for ( int i = 0; i < count; i++ ) {
                if ( i == index ) {
                    BgmFile item = (BgmFile)AppManager.getBgm( i ).clone();
                    item.startAfterPremeasure = parent.Checked;
                    list.add( item );
                } else {
                    list.add( AppManager.getBgm( i ) );
                }
            }
            CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        private void handleBgmAdd_Click( Object sender, BEventArgs e ) {
            if ( openWaveDialog.ShowDialog() != DialogResult.OK ) {
                return;
            }

            String file = openWaveDialog.FileName;

            // 既に開かれていたらキャンセル
            int count = AppManager.getBgmCount();
            boolean found = false;
            for ( int i = 0; i < count; i++ ) {
                BgmFile item = AppManager.getBgm( i );
                if ( file.Equals( item.file ) ) {
                    found = true;
                    break;
                }
            }
            if ( found ) {
                AppManager.showMessageBox( string.Format( _( "file '{0}' is already registered as BGM." ), file ),
                                 _( "Error" ),
                                 MessageBoxButtons.OK,
                                 MessageBoxIcon.Exclamation );
                return;
            }

            // 登録
            AppManager.addBgm( file );
            setEdited( true );
            updateBgmMenuState();
        }

        private void handleBgmRemove_Click( Object sender, BEventArgs e ) {
            if ( !(sender is ToolStripMenuItem) ) {
                return;
            }
            ToolStripMenuItem parent = (ToolStripMenuItem)sender;
            if ( parent.Tag == null ) {
                return;
            }
            if ( !(parent.Tag is int) ) {
                return;
            }
            int index = (int)parent.Tag;
            BgmFile bgm = AppManager.getBgm( index );
            if ( AppManager.showMessageBox( string.Format( _( "remove '{0}'?" ), bgm.file ),
                                  "Cadencii",
                                  MessageBoxButtons.YesNo,
                                  MessageBoxIcon.Question ) != BDialogResult.YES ) {
                return;
            }
            AppManager.removeBgm( index );
            setEdited( true );
            updateBgmMenuState();
        }

        private void updatePropertyPanelState( PanelState state ) {
            if ( state == PanelState.Docked ) {
                m_property_panel_container.Add( AppManager.propertyPanel );
                AppManager.propertyWindow.Visible = false;
                menuVisualProperty.Checked = true;
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Docked;
                splitContainerProperty.IsSplitterFixed = false;
                splitContainerProperty.Panel1MinSize = _PROPERTY_DOCK_MIN_WIDTH;
                splitContainerProperty.SplitterDistance = AppManager.editorConfig.PropertyWindowStatus.DockWidth;
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Minimized;
                AppManager.propertyWindow.WindowState = FormWindowState.Minimized;
            } else if ( state == PanelState.Hidden ) {
                AppManager.propertyWindow.Visible = false;
                menuVisualProperty.Checked = false;
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.SplitterDistance;
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Hidden;
                splitContainerProperty.Panel1MinSize = 0;
                splitContainerProperty.SplitterDistance = 0;
                splitContainerProperty.IsSplitterFixed = true;
            } else if ( state == PanelState.Window ) {
#if DEBUG
                PortUtil.println( "UpatePropertyPanelState; state=Window; AppManager.PropertyWindow.WindowState=" + AppManager.propertyWindow.WindowState );
#endif
                AppManager.propertyWindow.Visible = true;
                if ( AppManager.propertyWindow.WindowState != FormWindowState.Normal ) {
                    AppManager.propertyWindow.WindowState = FormWindowState.Normal;
                }
                AppManager.propertyWindow.Controls.Add( AppManager.propertyPanel );
                Point parent = this.getLocation();
                XmlRectangle rc = AppManager.editorConfig.PropertyWindowStatus.Bounds;
                Point property = new Point( rc.x, rc.y );
                AppManager.propertyWindow.Bounds = new System.Drawing.Rectangle( parent.x + property.x, parent.y + property.y, rc.Width, rc.Height );
                normalizeFormLocation( AppManager.propertyWindow );
                menuVisualProperty.Checked = true;
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.SplitterDistance;
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Window;
                splitContainerProperty.Panel1MinSize = 0;
                splitContainerProperty.SplitterDistance = 0;
                splitContainerProperty.IsSplitterFixed = true;
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Normal;
            }
        }

        /// <summary>
        /// VsqEvent, VsqBPList, BezierCurvesの全てのクロックを、tempoに格納されているテンポテーブルに
        /// 合致するようにシフトします．ただし，このメソッド内ではtargetのテンポテーブルは変更せず，クロック値だけが変更される．
        /// </summary>
        /// <param name="work"></param>
        /// <param name="tempo"></param>
        private static void shiftClockToMatchWith( VsqFileEx target, VsqFile tempo, double shift_seconds ) {
            // テンポをリプレースする場合。
            // まずクロック値を、リプレース後のモノに置き換え
            for ( int track = 1; track < target.Track.size(); track++ ) {
                // ノート・歌手イベントをシフト
                for ( Iterator<VsqEvent> itr = target.Track.get( track ).getEventIterator(); itr.hasNext(); ) {
                    VsqEvent item = itr.next();
                    if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                        continue;
                    }
                    int clock = item.Clock;
                    double sec_start = target.getSecFromClock( clock ) + shift_seconds;
                    double sec_end = target.getSecFromClock( clock + item.ID.Length ) + shift_seconds;
                    int clock_start = (int)tempo.getClockFromSec( sec_start );
                    int clock_end = (int)tempo.getClockFromSec( sec_end );
                    item.Clock = clock_start;
                    item.ID.Length = clock_end - clock_start;
                    if ( item.ID.VibratoHandle != null ) {
                        double sec_vib_start = target.getSecFromClock( clock + item.ID.VibratoDelay ) + shift_seconds;
                        int clock_vib_start = (int)tempo.getClockFromSec( sec_vib_start );
                        item.ID.VibratoDelay = clock_vib_start - clock_start;
                        item.ID.VibratoHandle.Length = clock_end - clock_vib_start;
                    }
                }

                // コントロールカーブをシフト
                for ( int j = 0; j < AppManager.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = AppManager.CURVE_USAGE[j];
                    VsqBPList item = target.Track.get( track ).getCurve( ct.getName() );
                    if ( item == null ) {
                        continue;
                    }
                    VsqBPList repl = new VsqBPList( item.getDefault(), item.getMinimum(), item.getMaximum() );
                    for ( int i = 0; i < item.size(); i++ ) {
                        int clock = item.getKeyClock( i );
                        int value = item.getElement( i );
                        double sec = target.getSecFromClock( clock ) + shift_seconds;
                        if ( sec >= 0 ) {
                            int clock_new = (int)tempo.getClockFromSec( sec );
                            repl.add( clock_new, value );
                        }
                    }
                    target.Track.get( track ).setCurve( ct.getName(), repl );
                }

                // ベジエカーブをシフト
                for ( int j = 0; j < AppManager.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = AppManager.CURVE_USAGE[j];
                    Vector<BezierChain> list = target.AttachedCurves.get( track - 1 ).get( ct );
                    if ( list == null ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr = list.iterator(); itr.hasNext(); ) {
                        BezierChain chain = itr.next();
                        for ( Iterator<BezierPoint> itr2 = chain.points.iterator(); itr2.hasNext(); ) {
                            BezierPoint point = itr2.next();
                            PointD bse = new PointD( tempo.getClockFromSec( target.getSecFromClock( point.getBase().getX() ) + shift_seconds ),
                                                     point.getBase().getY() );
                            double rx = point.getBase().getX() + point.controlRight.getX();
                            double new_rx = tempo.getClockFromSec( target.getSecFromClock( rx ) + shift_seconds );
                            PointD ctrl_r = new PointD( new_rx - bse.getX(), point.controlRight.getY() );

                            double lx = point.getBase().getX() + point.controlLeft.getX();
                            double new_lx = tempo.getClockFromSec( target.getSecFromClock( lx ) + shift_seconds );
                            PointD ctrl_l = new PointD( new_lx - bse.getX(), point.controlLeft.getY() );
                            point.setBase( bse );
                            point.controlLeft = ctrl_l;
                            point.controlRight = ctrl_r;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// メインメニュー項目の中から，Nameプロパティがnameであるものを検索します．見つからなければnullを返す．
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        private MenuElement searchMenuItemFromName( String name ) {
            MenuElement[] subitems = menuStripMain.getSubElements();
            for ( int i = 0; i < subitems.Length; i++ ) {
                MenuElement tsi = subitems[i];
                MenuElement ret = searchMenuItemRecurse( name, tsi );
                if ( ret != null ) {
                    return ret;
                }
            }
            return null;
        }

        /// <summary>
        /// 指定されたメニューアイテムから，Nameプロパティがnameであるものを再帰的に検索します．見つからなければnullを返す
        /// </summary>
        /// <param name="name"></param>
        /// <param name="tree"></param>
        /// <returns></returns>
        private MenuElement searchMenuItemRecurse( String name, MenuElement tree ) {
            if ( tree.getName().Equals( name ) ) {
                return tree;
            } else {
                MenuElement[] subitems = tree.getSubElements();
                for ( int i = 0; i < subitems.Length; i++ ) {
                    MenuElement tsi = subitems[i];
                    if ( tsi.getName().Equals( name ) ) {
                        return tsi;
                    }
                    MenuElement ret = searchMenuItemRecurse( name, tsi );
                    if ( ret != null ) {
                        return ret;
                    }
                }
                return null;
            }
        }

        /// <summary>
        /// フォームのタイトルバーが画面内に入るよう、Locationを正規化します
        /// </summary>
        /// <param name="form"></param>
        public static void normalizeFormLocation( Form dlg ) {
            Rectangle rcScreen = PortUtil.getWorkingArea( dlg );
            int top = dlg.Top;
            if ( top + dlg.Height > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.Height;
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = dlg.Left;
            if ( left + dlg.Width > rcScreen.x + rcScreen.width ) {
                left = rcScreen.x + rcScreen.width - dlg.Width;
            }
            if ( left < rcScreen.x ) {
                left = rcScreen.x;
            }
            dlg.Top = top;
            dlg.Left = left;
        }

        /// <summary>
        /// フォームをマウス位置に出す場合に推奨されるフォーム位置を計算します
        /// </summary>
        /// <param name="dlg"></param>
        /// <returns></returns>
        private Point getFormPreferedLocation( BForm dlg ) {
            Point mouse = PortUtil.getMousePosition();
            Rectangle rcScreen = PortUtil.getWorkingArea( this );
            int top = mouse.y - dlg.Height / 2;
            if ( top + dlg.getHeight() > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.getHeight();
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = mouse.x - dlg.getWidth() / 2;
            if ( left + dlg.getWidth() > rcScreen.x + rcScreen.width ) {
                left = rcScreen.x + rcScreen.width - dlg.getWidth();
            }
            return new Point( left, top );
        }

        private void updateLayout() {
            int width = panel1.Width;
            int height = panel1.Height;

            // splitContainter1.Panel1->splitContainer2.Panel1
            if ( AppManager.editorConfig.OverviewEnabled ) {
                panelOverview.Height = _OVERVIEW_HEIGHT;
            } else {
                panelOverview.Height = 0;
            }
            panelOverview.Width = width;
            pictOverview.Left = AppManager.keyWidth;
            pictOverview.Width = panelOverview.Width - AppManager.keyWidth;
            pictOverview.Top = 0;
            pictOverview.Height = panelOverview.Height;

            picturePositionIndicator.Width = width;
            picturePositionIndicator.Height = _PICT_POSITION_INDICATOR_HEIGHT;

            hScroll.Top = 0;
            hScroll.Left = AppManager.keyWidth;
            hScroll.Width = width - AppManager.keyWidth - _SCROLL_WIDTH - trackBar.Width;
            hScroll.Height = _SCROLL_WIDTH;

            vScroll.Width = _SCROLL_WIDTH;
            vScroll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH - panelOverview.Height;

            pictPianoRoll.Width = width - _SCROLL_WIDTH;
            pictPianoRoll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH - panelOverview.Height;

            pictureBox3.Width = AppManager.keyWidth - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Width = _SCROLL_WIDTH;
            pictureBox3.Height = _SCROLL_WIDTH;
            pictureBox2.Height = _SCROLL_WIDTH;
            trackBar.Height = _SCROLL_WIDTH;

            panelOverview.Top = 0;
            panelOverview.Left = 0;

            picturePositionIndicator.Top = panelOverview.Height;
            picturePositionIndicator.Left = 0;

            pictPianoRoll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            pictPianoRoll.Left = 0;

            vScroll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            vScroll.Left = width - _SCROLL_WIDTH;

            pictureBox3.Top = height - _SCROLL_WIDTH;
            pictureBox3.Left = 0;
            pictKeyLengthSplitter.Top = height - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Left = pictureBox3.Width;

            hScroll.Top = height - _SCROLL_WIDTH;
            hScroll.Left = pictureBox3.Width + pictKeyLengthSplitter.Width;

            trackBar.Top = height - _SCROLL_WIDTH;
            trackBar.Left = width - _SCROLL_WIDTH - trackBar.Width;

            pictureBox2.Top = height - _SCROLL_WIDTH;
            pictureBox2.Left = width - _SCROLL_WIDTH;

            // splitContainer1.Panel2
            //trackSelector.Width = splitContainer1.Panel2.Width - _SCROLL_WIDTH;
            //trackSelector.Height = splitContainer1.Panel2.Height;
        }

        public void updateRendererMenu() {
            if ( !VSTiProxy.isRendererAvailable( VSTiProxy.RENDERER_DSB2 ) ) {
                cMenuTrackTabRendererVOCALOID1.Image = Boare.Cadencii.Properties.Resources.slash;
                menuTrackRendererVOCALOID1.Image = Boare.Cadencii.Properties.Resources.slash;
            } else {
                cMenuTrackTabRendererVOCALOID1.Image = null;
                menuTrackRendererVOCALOID1.Image = null;
            }
            if ( !VSTiProxy.isRendererAvailable( VSTiProxy.RENDERER_DSB3 ) ) {
                cMenuTrackTabRendererVOCALOID2.Image = Boare.Cadencii.Properties.Resources.slash;
                menuTrackRendererVOCALOID2.Image = Boare.Cadencii.Properties.Resources.slash;
            } else {
                cMenuTrackTabRendererVOCALOID2.Image = null;
                menuTrackRendererVOCALOID2.Image = null;
            }
            if ( !VSTiProxy.isRendererAvailable( VSTiProxy.RENDERER_UTU0 ) ) {
                cMenuTrackTabRendererUtau.Image = Boare.Cadencii.Properties.Resources.slash;
                menuTrackRendererUtau.Image = Boare.Cadencii.Properties.Resources.slash;
            } else {
                cMenuTrackTabRendererUtau.Image = null;
                menuTrackRendererUtau.Image = null;
            }
            if ( !VSTiProxy.isRendererAvailable( VSTiProxy.RENDERER_STR0 ) ) {
                cMenuTrackTabRendererStraight.Image = Boare.Cadencii.Properties.Resources.slash;
                menuTrackRendererStraight.Image = Boare.Cadencii.Properties.Resources.slash;
            } else {
                cMenuTrackTabRendererStraight.Image = null;
                menuTrackRendererStraight.Image = null;
            }
        }

        private void drawUtauVibrato( Graphics2D g, UstVibrato vibrato, int note, int clock_start, int clock_width ) {
            //SmoothingMode old = g.SmoothingMode;
            //g.SmoothingMode = SmoothingMode.AntiAlias;
            // 魚雷を描いてみる
            int y0 = yCoordFromNote( note - 0.5f );
            int x0 = AppManager.xCoordFromClocks( clock_start );
            int px_width = AppManager.xCoordFromClocks( clock_start + clock_width ) - x0;
            int boxheight = (int)(vibrato.Depth * 2 / 100.0f * AppManager.editorConfig.PxTrackHeight);
            int px_shift = (int)(vibrato.Shift / 100.0 * vibrato.Depth / 100.0 * AppManager.editorConfig.PxTrackHeight);

            // vibrato in
            int cl_vibin_end = clock_start + (int)(clock_width * vibrato.In / 100.0);
            int x_vibin_end = AppManager.xCoordFromClocks( cl_vibin_end );
            Point ul = new Point( x_vibin_end, y0 - boxheight / 2 - px_shift );
            Point dl = new Point( x_vibin_end, y0 + boxheight / 2 - px_shift );
            g.setColor( Color.black );
            g.drawPolygon( new int[] { x0, ul.x, dl.x },
                           new int[] { y0, ul.y, dl.y },
                           3 );

            // vibrato out
            int cl_vibout_start = clock_start + clock_width - (int)(clock_width * vibrato.Out / 100.0);
            int x_vibout_start = AppManager.xCoordFromClocks( cl_vibout_start );
            Point ur = new Point( x_vibout_start, y0 - boxheight / 2 - px_shift );
            Point dr = new Point( x_vibout_start, y0 + boxheight / 2 - px_shift );
            g.drawPolygon( new int[] { x0 + px_width, ur.x, dr.x },
                           new int[] { y0, ur.y, dr.y },
                           3 );

            // box
            int boxwidth = x_vibout_start - x_vibin_end;
            if ( boxwidth > 0 ) {
                g.drawPolygon( new int[] { ul.x, dl.x, dr.x, ur.x },
                               new int[] { ul.y, dl.y, dr.y, ur.y },
                               4 );
            }

#if DEBUG
            BufferedWriter sw = new BufferedWriter( new FileWriter( "list.txt" ) );
#endif
            // buf1に、vibrato in/outによる増幅率を代入
            float[] buf1 = new float[clock_width + 1];
            for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                buf1[clock - clock_start] = 1.0f;
            }
            // vibin
            if ( cl_vibin_end - clock_start > 0 ) {
                for ( int clock = clock_start; clock <= cl_vibin_end; clock++ ) {
                    int i = clock - clock_start;
                    buf1[i] *= i / (float)(cl_vibin_end - clock_start);
#if DEBUG
                    sw.write( "vibin: " + i + "\t" + buf1[i] );
                    sw.newLine();
#endif
                }
            }
            if ( clock_start + clock_width - cl_vibout_start > 0 ) {
                for ( int clock = clock_start + clock_width; clock >= cl_vibout_start; clock-- ) {
                    int i = clock - clock_start;
                    float v = (clock_start + clock_width - clock) / (float)(clock_start + clock_width - cl_vibout_start);
                    buf1[i] = buf1[i] * v;
#if DEBUG
                    sw.write( "vibout: " + i + "\t" + buf1[i] );
                    sw.newLine();
#endif
                }
            }

            // buf2に、shiftによるy座標のシフト量を代入
            float[] buf2 = new float[clock_width + 1];
            for ( int i = 0; i < clock_width; i++ ) {
                buf2[i] = px_shift * buf1[i];
            }
            try {
                double phase = 2.0 * Math.PI * vibrato.Phase / 100.0;
                double omega = 2.0 * Math.PI / vibrato.Period;   //角速度(rad/msec)
                double msec = AppManager.getVsqFile().getSecFromClock( clock_start - 1 ) * 1000.0;
                float px_track_height = AppManager.editorConfig.PxTrackHeight;
                phase -= (AppManager.getVsqFile().getSecFromClock( clock_start ) * 1000.0 - msec) * omega;
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    double t_msec = AppManager.getVsqFile().getSecFromClock( clock ) * 1000.0;
                    phase += (t_msec - msec) * omega;
                    msec = t_msec;
                    buf2[i] += (float)(vibrato.Depth * 0.01f * px_track_height * buf1[i] * Math.Sin( phase ));
                }
                int[] listx = new int[clock_width + 1];
                int[] listy = new int[clock_width + 1];
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    listx[i] = AppManager.xCoordFromClocks( clock );
                    listy[i] = (int)(y0 + buf2[i]);
                }
#if DEBUG
                AppManager.debugWriteLine( "DrawUtauVibrato" );
                for ( int i = 0; i < listx.Length; i++ ) {
                    sw.write( listx[i] + "\t" + listy[i] );
                    sw.newLine();
                }
                sw.close();
                sw = null;
#endif
                if ( listx.Length >= 2 ) {
                    g.setColor( Color.red );
                    g.drawPolygon( listx, listy, listx.Length );
                }
                //g.SmoothingMode = old;
            } catch ( OverflowException oex ) {
#if DEBUG
                AppManager.debugWriteLine( "DrawUtauVibrato; oex=" + oex );
#endif
            }
        }

        /// <summary>
        /// ビブラート用のデータ点のリストを取得します。返却されるリストは、{秒, ビブラートの振幅(ノートナンバー単位)}の値ペアとなっています
        /// </summary>
        /// <param name="rate"></param>
        /// <param name="start_rate"></param>
        /// <param name="depth"></param>
        /// <param name="start_depth"></param>
        /// <param name="clock_start"></param>
        /// <param name="clock_width"></param>
        /// <returns></returns>
        public static Vector<PointD> getVibratoPoints( VsqFileEx vsq,
                                                       VibratoBPList rate,
                                                       int start_rate,
                                                       VibratoBPList depth,
                                                       int start_depth,
                                                       int clock_start,
                                                       int clock_width,
                                                       float sec_resolution ) {
            Vector<PointD> ret = new Vector<PointD>();
            double sec0 = vsq.getSecFromClock( clock_start );
            double sec1 = vsq.getSecFromClock( clock_start + clock_width );
            int count = (int)((sec1 - sec0) / sec_resolution);
            double phase = 0;
            start_rate = rate.getValue( 0.0f, start_rate );
            start_depth = depth.getValue( 0.0f, start_depth );
            float amplitude = start_depth * 2.5f / 127.0f / 2.0f; // ビブラートの振幅。
            float period = (float)Math.Exp( 5.24 - 1.07e-2 * start_rate ) * 2.0f / 1000.0f; //ビブラートの周期、秒
            float omega = (float)(2.0 * Math.PI / period); // 角速度(rad/sec)
            ret.add( new PointD( sec0, 0 ) );
            double sec = sec0;
            float fadewidth = (float)(sec1 - sec0) * 0.2f;
            for ( int i = 1; i < count; i++ ) {
                double t_sec = sec0 + sec_resolution * i;
                double clock = vsq.getClockFromSec( t_sec );
                if ( sec0 <= t_sec && t_sec <= sec0 + fadewidth ) {
                    amplitude *= (float)(t_sec - sec0) / fadewidth;
                }
                if ( sec1 - fadewidth <= t_sec && t_sec <= sec1 ) {
                    amplitude *= (float)(sec1 - t_sec) / fadewidth;
                }
                phase += omega * (t_sec - sec);
                ret.add( new PointD( t_sec, amplitude * Math.Sin( phase ) ) );
                float v = (float)(clock - clock_start) / (float)clock_width;
                int r = rate.getValue( v, start_rate );
                int d = depth.getValue( v, start_depth );
                amplitude = d * 2.5f / 127.0f / 2.0f;
                period = (float)Math.Exp( 5.24 - 1.07e-2 * r ) * 2.0f / 1000.0f;
                omega = (float)(2.0 * Math.PI / period);
                sec = t_sec;
            }
            return ret;
        }

        /// <summary>
        /// listに登録されているToolStripを，座標の若い順にcontainerに追加します
        /// </summary>
        /// <param name="panel"></param>
        /// <param name="list"></param>
        private void addToolStripInPositionOrder( ToolStripPanel panel, Vector<ToolStrip> list ) {
            boolean[] reg = new boolean[list.size()];
            for ( int i = 0; i < reg.Length; i++ ) {
                reg[i] = false;
            }
            for ( int i = 0; i < list.size(); i++ ) {
                Point p = new Point( int.MaxValue, int.MaxValue );
                int index = -1;

                // x座標の小さいやつを探す
                for ( int j = 0; j < list.size(); j++ ) {
                    if ( !reg[j] ) {
                        ToolStrip ts = list.get( j );
                        if ( p.y > ts.Location.Y ) {
                            index = j;
                            p = new Point( ts.Location.X, ts.Location.Y );
                        }
                        if ( p.y >= ts.Location.Y && p.x > ts.Location.X ) {
                            index = j;
                            p = new Point( ts.Location.X, ts.Location.Y );
                        }
                    }
                }

                // コントロールを登録
                panel.Join( list.get( index ), list.get( index ).Location );
                reg[index] = true;
            }
        }

        /// <summary>
        /// Palette Toolの表示を更新します
        /// </summary>
        public void updatePaletteTool() {
            int count = 0;
            int num_has_dialog = 0;
            for ( Iterator<ToolStripItem> itr = m_palette_tools.iterator(); itr.hasNext(); ) {
                ToolStripItem item = itr.next();
                toolStripTool.Items.Remove( item );
            }
            String lang = Messaging.getLanguage();
            boolean first = true;
            for ( Iterator<String> itr = PaletteToolServer.LoadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = itr.next();
                count++;
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
#if !JAVA
                System.Drawing.Bitmap icon = ipt.getIcon();
#endif
                String name = ipt.getName( lang );
                String desc = ipt.getDescription( lang );

                // toolStripPaletteTools
                BToolStripButton tsb = new BToolStripButton();
#if !JAVA
                if ( icon != null ) {
                    tsb.Image = icon;
                }
#endif
                tsb.setText( name );
                tsb.setToolTipText( desc );
                tsb.setTag( id );
                tsb.setCheckOnClick( false );
#if JAVA
                tsb.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsb.Click += new EventHandler( commonStripPaletteTool_Clicked );
                tsb.DisplayStyle = ToolStripItemDisplayStyle.ImageAndText;
#endif
                if ( first ) {
                    ToolStripSeparator separator = new ToolStripSeparator();
                    m_palette_tools.add( separator );
                    toolStripTool.Items.Add( separator );
                    first = false;
                }
                m_palette_tools.add( tsb );
                toolStripTool.Items.Add( tsb );

                // cMenuTrackSelector
                BMenuItem tsmi = new BMenuItem();
                tsmi.setText( name );
                tsmi.setToolTipText( desc );
                tsmi.setTag( id );
#if JAVA
                tsmi.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsmi.Click += new BEventHandler( commonStripPaletteTool_Clicked );
#endif
                cMenuTrackSelectorPaletteTool.add( tsmi );

                // cMenuPiano
                BMenuItem tsmi2 = new BMenuItem();
                tsmi2.setText( name );
                tsmi2.setToolTipText( desc );
                tsmi2.setTag( id );
#if JAVA
                tsmi2.clickEvent.add( new BEventHandler( this, "commonStripPaletteTool_Clicked" ) );
#else
                tsmi2.Click += new EventHandler( commonStripPaletteTool_Clicked );
#endif
                cMenuPianoPaletteTool.add( tsmi2 );

                // menuSettingPaletteTool
                if ( ipt.hasDialog() ) {
                    BMenuItem tsmi3 = new BMenuItem();
                    tsmi3.setText( name );
                    tsmi3.setTag( id );
#if JAVA
                    tsmi3.clickEvent.add( new BEventHandler( this, "commonSettingPaletteTool" ) );
#else
                    tsmi3.Click += new EventHandler( commonSettingPaletteTool );
#endif
                    menuSettingPaletteTool.add( tsmi3 );
                    num_has_dialog++;
                }
            }
            if ( count == 0 ) {
                cMenuTrackSelectorPaletteTool.setVisible( false );
                cMenuPianoPaletteTool.setVisible( false );
            }
            if ( num_has_dialog == 0 ) {
                menuSettingPaletteTool.setVisible( false );
            }
        }

        private void commonSettingPaletteTool( Object sender, BEventArgs e ) {
            if ( sender is ToolStripMenuItem ) {
                ToolStripMenuItem tsmi = (ToolStripMenuItem)sender;
                if ( tsmi.Tag != null && tsmi.Tag is String ) {
                    String id = (String)tsmi.Tag;
                    if ( PaletteToolServer.LoadedTools.containsKey( id ) ) {
                        Object instance = PaletteToolServer.LoadedTools.get( id );
                        IPaletteTool ipt = (IPaletteTool)instance;
                        if ( ipt.openDialog() == DialogResult.OK ) {
                            XmlSerializer xsms = new XmlSerializer( instance.GetType(), true );
                            String dir = PortUtil.combinePath( AppManager.getApplicationDataPath(), "tool" );
                            if ( !PortUtil.isDirectoryExists( dir ) ) {
                                PortUtil.createDirectory( dir );
                            }
                            String cfg = id + ".config";
                            String config = PortUtil.combinePath( dir, cfg );
                            FileOutputStream fs = null;
                            try {
                                fs = new FileOutputStream( config );
                                xsms.serialize( fs, null );
                            } catch ( Exception ex ) {
                            } finally {
                                if ( fs != null ) {
                                    try {
                                        fs.close();
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public void updateCopyAndPasteButtonStatus() {
            // copy cut deleteの表示状態更新
            boolean selected_is_null = (AppManager.getSelectedEventCount() == 0) &&
                                       (AppManager.getSelectedTempoCount() == 0) &&
                                       (AppManager.getSelectedTimesigCount() == 0) &&
                                       (AppManager.getSelectedPointIDCount() == 0);

            cMenuTrackSelectorCopy.Enabled = AppManager.getSelectedPointIDCount() > 0;
            cMenuTrackSelectorCut.Enabled = AppManager.getSelectedPointIDCount() > 0;
            cMenuTrackSelectorDeleteBezier.Enabled = (AppManager.isCurveMode() && AppManager.getLastSelectedBezier() != null);
            cMenuTrackSelectorDelete.Enabled = AppManager.getSelectedPointIDCount() > 0; //todo: このへん。右クリック位置にベジエ制御点などがあった場合eneble=trueにする

            cMenuPianoCopy.Enabled = !selected_is_null;
            cMenuPianoCut.Enabled = !selected_is_null;
            cMenuPianoDelete.Enabled = !selected_is_null;

            menuEditCopy.Enabled = !selected_is_null;
            menuEditCut.Enabled = !selected_is_null;
            menuEditDelete.Enabled = !selected_is_null;

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
            boolean copied_is_null = (ce.events.size() == 0) &&
                                  (ce.tempo.size() == 0) &&
                                  (ce.timesig.size() == 0) &&
                                  (copied_curve.size() == 0) &&
                                  (copied_bezier.size() == 0);
            boolean enabled = !copied_is_null;
            if ( copied_curve.size() == 1 ) {
                // 1種類のカーブがコピーされている場合→コピーされているカーブの種類と、現在選択されているカーブの種類とで、最大値と最小値が一致している場合のみ、ペースト可能
                CurveType ct = CurveType.Empty;
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType c = itr.next();
                    ct = c;
                }
                CurveType selected = trackSelector.getSelectedCurve();
                if ( ct.getMaximum() == selected.getMaximum() &&
                     ct.getMinimum() == selected.getMinimum() &&
                     !selected.isScalar() && !selected.isAttachNote() ) {
                    enabled = true;
                } else {
                    enabled = false;
                }
            } else if ( copied_curve.size() >= 2 ) {
                // 複数種類のカーブがコピーされている場合→そのままペーストすればOK
                enabled = true;
            }
            cMenuTrackSelectorPaste.Enabled = enabled;
            cMenuPianoPaste.Enabled = enabled;
            menuEditPaste.Enabled = enabled;

            /*int copy_started_clock;
            boolean copied_is_null = (AppManager.GetCopiedEvent().Count == 0) &&
                                  (AppManager.GetCopiedTempo( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedTimesig( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedCurve( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedBezier( out copy_started_clock ).Count == 0);
            menuEditCut.Enabled = !selected_is_null;
            menuEditCopy.Enabled = !selected_is_null;
            menuEditDelete.Enabled = !selected_is_null;
            //stripBtnCopy.Enabled = !selected_is_null;
            //stripBtnCut.Enabled = !selected_is_null;

            if ( AppManager.GetCopiedEvent().Count != 0 ) {
                menuEditPaste.Enabled = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
                //stripBtnPaste.Enabled = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
            } else {
                menuEditPaste.Enabled = !copied_is_null;
                //stripBtnPaste.Enabled = !copied_is_null;
            }*/
        }

        /// <summary>
        /// 現在の編集データを全て破棄する。DirtyCheckは行われない。
        /// </summary>
        private void clearExistingData() {
            AppManager.clearCommandBuffer();
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false );
            }
        }

        /// <summary>
        /// 保存されていない編集内容があるかどうかチェックし、必要なら確認ダイアログを出す。
        /// </summary>
        /// <returns>保存されていない保存内容などない場合、または、保存する必要がある場合で（保存しなくてよいと指定された場合または保存が行われた場合）にtrueを返す</returns>
        private boolean dirtyCheck() {
            if ( m_edited ) {
                String file = AppManager.getFileName();
                if ( file.Equals( "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult dr = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                              _( "Affirmation" ),
                                                              MessageBoxButtons.YesNoCancel,
                                                              MessageBoxIcon.Question );
                if ( dr == BDialogResult.YES ) {
                    if ( AppManager.getFileName().Equals( "" ) ) {
                        DialogResult dr2 = DialogResult.Cancel;
                        if ( AppManager.editorConfig.UseCustomFileDialog ) {
                            FileDialog fd = null;
                            try {
                                fd = new FileDialog( FileDialog.DialogMode.Open );
                                if ( saveXmlVsqDialog.FileName != "" ) {
                                    fd.FileName = saveXmlVsqDialog.FileName;
                                }
                                fd.Filter = saveXmlVsqDialog.Filter;
                                dr2 = fd.ShowDialog();
                                if ( dr2 == DialogResult.OK ) {
                                    saveXmlVsqDialog.FileName = fd.FileName;
                                }
                            } catch ( Exception ex ) {
                            } finally {
                                if ( fd != null ) {
                                    try {
#if !JAVA
                                        fd.Dispose();
#endif
                                    } catch ( Exception ex2 ) {
                                    }
                                }
                            }
                        } else {
                            dr2 = saveXmlVsqDialog.ShowDialog();
                        }

                        if ( dr2 == DialogResult.OK ) {
                            AppManager.saveTo( saveXmlVsqDialog.FileName );
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                        return true;
                    }
                } else if ( dr == BDialogResult.NO ) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }

        /// <summary>
        /// waveView用のwaveファイルを読込むスレッドで使用する
        /// </summary>
        /// <param name="arg"></param>
        private void LoadWaveThreadProc( Object arg ) {
            String file = (String)arg;
            waveView.LoadWave( file );
        }

        /// <summary>
        /// menuVisualWaveform.Checkedの値をもとに、splitterContainer2の表示状態を更新します
        /// </summary>
        private void updateSplitContainer2Size() {
            if ( menuVisualWaveform.Checked ) {
                splitContainer2.Panel2MinSize = _SPL2_PANEL2_MIN_HEIGHT;
                splitContainer2.IsSplitterFixed = false;
                splitContainer2.SplitterWidth = _SPL_SPLITTER_WIDTH;
                if ( m_last_splitcontainer2_split_distance <= 0 || m_last_splitcontainer2_split_distance > splitContainer2.Height ) {
                    splitContainer2.SplitterDistance = (int)(splitContainer2.Height * 0.9);
                } else {
                    splitContainer2.SplitterDistance = m_last_splitcontainer2_split_distance;
                }
            } else {
                m_last_splitcontainer2_split_distance = splitContainer2.SplitterDistance;
                splitContainer2.Panel2MinSize = 0;
                splitContainer2.SplitterWidth = 0;
                splitContainer2.SplitterDistance = splitContainer2.Height;
                splitContainer2.IsSplitterFixed = true;
            }
        }

        /// <summary>
        /// trackSelectorに表示するコントロールのカーブの種類を、AppManager.EditorConfigの設定に応じて更新します
        /// </summary>
        private void updateTrackSelectorVisibleCurve() {
            if ( AppManager.editorConfig.CurveVisibleVelocity ) {
                trackSelector.addViewingCurve( CurveType.VEL );
            }
            if ( AppManager.editorConfig.CurveVisibleAccent ) {
                trackSelector.addViewingCurve( CurveType.Accent );
            }
            if ( AppManager.editorConfig.CurveVisibleDecay ) {
                trackSelector.addViewingCurve( CurveType.Decay );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoRate ) {
                trackSelector.addViewingCurve( CurveType.VibratoRate );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoDepth ) {
                trackSelector.addViewingCurve( CurveType.VibratoDepth );
            }
            if ( AppManager.editorConfig.CurveVisibleDynamics ) {
                trackSelector.addViewingCurve( CurveType.DYN );
            }
            if ( AppManager.editorConfig.CurveVisibleBreathiness ) {
                trackSelector.addViewingCurve( CurveType.BRE );
            }
            if ( AppManager.editorConfig.CurveVisibleBrightness ) {
                trackSelector.addViewingCurve( CurveType.BRI );
            }
            if ( AppManager.editorConfig.CurveVisibleClearness ) {
                trackSelector.addViewingCurve( CurveType.CLE );
            }
            if ( AppManager.editorConfig.CurveVisibleOpening ) {
                trackSelector.addViewingCurve( CurveType.OPE );
            }
            if ( AppManager.editorConfig.CurveVisibleGendorfactor ) {
                trackSelector.addViewingCurve( CurveType.GEN );
            }
            if ( AppManager.editorConfig.CurveVisiblePortamento ) {
                trackSelector.addViewingCurve( CurveType.POR );
            }
            if ( AppManager.editorConfig.CurveVisiblePit ) {
                trackSelector.addViewingCurve( CurveType.PIT );
            }
            if ( AppManager.editorConfig.CurveVisiblePbs ) {
                trackSelector.addViewingCurve( CurveType.PBS );
            }
            if ( AppManager.editorConfig.CurveVisibleHarmonics ) {
                trackSelector.addViewingCurve( CurveType.harmonics );
            }
            if ( AppManager.editorConfig.CurveVisibleFx2Depth ) {
                trackSelector.addViewingCurve( CurveType.fx2depth );
            }
            if ( AppManager.editorConfig.CurveVisibleReso1 ) {
                trackSelector.addViewingCurve( CurveType.reso1freq );
                trackSelector.addViewingCurve( CurveType.reso1bw );
                trackSelector.addViewingCurve( CurveType.reso1amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso2 ) {
                trackSelector.addViewingCurve( CurveType.reso2freq );
                trackSelector.addViewingCurve( CurveType.reso2bw );
                trackSelector.addViewingCurve( CurveType.reso2amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso3 ) {
                trackSelector.addViewingCurve( CurveType.reso3freq );
                trackSelector.addViewingCurve( CurveType.reso3bw );
                trackSelector.addViewingCurve( CurveType.reso3amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso4 ) {
                trackSelector.addViewingCurve( CurveType.reso4freq );
                trackSelector.addViewingCurve( CurveType.reso4bw );
                trackSelector.addViewingCurve( CurveType.reso4amp );
            }
            if ( AppManager.editorConfig.CurveVisibleEnvelope ) {
                trackSelector.addViewingCurve( CurveType.Env );
            }
        }

        /// <summary>
        /// ウィンドウの表示内容に応じて、ウィンドウサイズの最小値を計算します
        /// </summary>
        /// <returns></returns>
        private Dimension getWindowMinimumSize() {
            Dimension current_minsize = new Dimension( this.MinimumSize.Width, this.MinimumSize.Height );
            Dimension client = new Dimension( this.ClientSize.Width, this.ClientSize.Height );
            Dimension current = new Dimension( this.Size.Width, this.Size.Height );
            return new Dimension( current_minsize.width,
                                  splitContainer1.Panel2MinSize +
                                     _SCROLL_WIDTH + _PICT_POSITION_INDICATOR_HEIGHT + pictPianoRoll.MinimumSize.Height +
                                     toolStripContainer.TopToolStripPanel.Height +
                                     menuStripMain.Height + statusStrip1.Height +
                                     (current.height - client.height) +
                                     20 );
        }

        /// <summary>
        /// 現在のAppManager.inputTextBoxの状態を元に、歌詞の変更を反映させるコマンドを実行します
        /// </summary>
        public void executeLyricChangeCommand() {
#if JAVA
            if ( !AppManager.inputTextBox.isVisible() ) {
#else
            if ( !AppManager.inputTextBox.Enabled ) {
#endif
                return;
            }
#if !JAVA
            if ( AppManager.inputTextBox.IsDisposed ) {
                return;
            }
#endif
            SelectedEventEntry last_selected_event = AppManager.getLastSelectedEvent();
            boolean phonetic_symbol_edit_mode = ((TagLyricTextBox)AppManager.inputTextBox.Tag).PhoneticSymbolEditMode;

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 後続に、連続している音符が何個あるか検査
            int maxcount = SymbolTable.getMaxDivisions();
#if DEBUG
            PortUtil.println( "FormMain#executeLyricChangeCommand; maxcount=" + maxcount );
#endif
            boolean check_started = false;
            int endclock = 0;  // 直前の音符の終了クロック
            int count = 0;     // 後続音符の連続個数
            int start_index = -1;
            int indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                indx = itr.next();
                VsqEvent itemi = vsq_track.getEvent( indx );
                if ( itemi.InternalID == last_selected_event.original.InternalID ) {
                    check_started = true;
                    endclock = itemi.Clock + itemi.ID.getLength();
                    count = 1;
                    start_index = indx;
                    continue;
                }
                if ( check_started ) {
                    if ( count + 1 > maxcount ) {
                        break;
                    }
                    if ( itemi.Clock <= endclock ) {
                        count++;
                        endclock = itemi.Clock + itemi.ID.getLength();
                    } else {
                        break;
                    }
                }
            }
#if DEBUG
            PortUtil.println( "FormMain#executeLyricChangeCommand; count=" + count );
#endif

            // 後続の音符をリストアップ
            VsqEvent[] items = new VsqEvent[count];
            String[] original_symbol = new String[count];
            String[] original_phrase = new String[count];
            boolean[] symbol_protected = new boolean[count];
            indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                int index = itr.next();
                if ( index < start_index ) {
                    continue;
                }
                indx++;
                if ( count <= indx ) {
                    break;
                }
                VsqEvent ve = vsq_track.getEvent( index );
                items[indx] = (VsqEvent)ve.clone();
                original_symbol[indx] = ve.ID.LyricHandle.L0.getPhoneticSymbol();
                original_phrase[indx] = ve.ID.LyricHandle.L0.Phrase;
                symbol_protected[indx] = ve.ID.LyricHandle.L0.PhoneticSymbolProtected;
            }

#if DEBUG
            AppManager.debugWriteLine( "    original_phase,symbol=" + original_phrase + "," + original_symbol[0] );
            AppManager.debugWriteLine( "    phonetic_symbol_edit_mode=" + phonetic_symbol_edit_mode );
            AppManager.debugWriteLine( "    AppManager.inputTextBox.setText(=" + AppManager.inputTextBox.getText() );
#endif
            String[] phrase = new String[count];
            String[] phonetic_symbol = new String[count];
            for ( int i = 0; i < count; i++ ) {
                phrase[i] = original_phrase[i];
                phonetic_symbol[i] = original_symbol[i];
            }
            phrase[0] = AppManager.inputTextBox.getText().Replace( "-", "" );
            if ( !phonetic_symbol_edit_mode ) {
                // 歌詞を編集するモードで、
                if ( AppManager.editorConfig.SelfDeRomanization ) {
                    // かつローマ字の入力を自動でひらがなに展開する設定だった場合。
                    // ローマ字をひらがなに展開
                    phrase[0] = KanaDeRomanization.Attach( phrase[0] );
                }
            }

            // 発音記号または歌詞が変更された場合の処理
            if ( (phonetic_symbol_edit_mode && !AppManager.inputTextBox.getText().Equals( original_symbol[0] )) ||
                 (!phonetic_symbol_edit_mode && !phrase[0].Equals( original_phrase[0] )) ) {
                TagLyricTextBox kvp = (TagLyricTextBox)AppManager.inputTextBox.Tag;
                if ( phonetic_symbol_edit_mode ) {
                    // 発音記号を編集するモード
                    phrase[0] = kvp.BufferText;
                    phonetic_symbol[0] = AppManager.inputTextBox.getText();

                    // 入力された発音記号のうち、有効なものだけをピックアップ
                    String[] spl = PortUtil.splitString( phonetic_symbol[0], new char[] { ' ' }, true );
                    Vector<String> list = new Vector<String>();
                    for ( int i = 0; i < spl.Length; i++ ) {
                        String s = spl[i];
                        if ( VsqPhoneticSymbol.isValidSymbol( s ) ) {
                            list.add( s );
                        }
                    }

                    // ピックアップした発音記号をスペース区切りで結合
                    phonetic_symbol[0] = "";
                    boolean first = true;
                    for ( Iterator<String> itr = list.iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        if ( first ) {
                            phonetic_symbol[0] += s;
                            first = false;
                        } else {
                            phonetic_symbol[0] += " " + s;
                        }
                    }

                    // 発音記号を編集すると、自動で「発音記号をプロテクトする」モードになるよ
                    symbol_protected[0] = true;
                } else {
                    // 歌詞を編集するモード
                    if ( !symbol_protected[0] ) {
                        // 発音記号をプロテクトしない場合、歌詞から発音記号を引当てる
                        SymbolTableEntry entry = SymbolTable.attatch( phrase[0] );
                        if ( entry == null ) {
                            phonetic_symbol[0] = "a";
                        } else {
                            phonetic_symbol[0] = entry.getParsedSymbol();
                            // 分節の分割記号'-'が入っている場合
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                String[] spl_phrase = PortUtil.splitString( entry.Word, '\t' );
                                if ( spl_phrase.Length <= count ) {
                                    // 分節の分割数が，後続の音符数と同じか少ない場合
                                    String[] spl_symbol = PortUtil.splitString( entry.Symbol, '\t' );
                                    for ( int i = 0; i < spl_phrase.Length; i++ ) {
                                        phrase[i] = spl_phrase[i];
                                        phonetic_symbol[i] = spl_symbol[i];
                                    }
                                } else {
                                    // 後続の音符の個数が足りない
                                    phrase[0] = entry.Word.Replace( "\t", "" );
                                }
                            }
                        }
                    } else {
                        // 発音記号をプロテクトする場合、発音記号は最初のやつを使う
                        phonetic_symbol[0] = original_symbol[0];
                    }
                }
#if DEBUG
                AppManager.debugWriteLine( "    phrase,phonetic_symbol=" + phrase + "," + phonetic_symbol );
#endif

                for ( int j = 0; j < count; j++ ) {
                    if ( phonetic_symbol_edit_mode ) {
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                    } else {
                        items[j].ID.LyricHandle.L0.Phrase = phrase[j];
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                        /*VsqEvent singer = vsq_track.getSingerEventAt( items[j].Clock );
                        SingerConfig sc = AppManager.getSingerInfoUtau( singer.ID.IconHandle.Language, singer.ID.IconHandle.Program );
                        if ( sc != null && AppManager.utauVoiceDB.containsKey( sc.VOICEIDSTR ) ) {
                            UtauVoiceDB db = AppManager.utauVoiceDB.get( sc.VOICEIDSTR );
                            OtoArgs oa = db.attachFileNameFromLyric( phrase[j] );
                            items[j].UstEvent.PreUtterance = oa.msPreUtterance;
                            items[j].UstEvent.VoiceOverlap = oa.msOverlap;
                        }*/
                    }
                    /*if ( !original_symbol[j].Equals( phonetic_symbol[j] ) ) {
                        String[] spl = items[j].ID.LyricHandle.L0.getPhoneticSymbolList();
                        int[] adjustment = new int[spl.Length];
                        for ( int i = 0; i < adjustment.Length; i++ ) {
                            adjustment[i] = VsqPhoneticSymbol.isConsonant( spl[i] ) ? 64 : 0;
                        }
                        items[j].ID.LyricHandle.L0.setConsonantAdjustmentList( adjustment );
                    }*/
                }

                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventReplaceRange( selected, items ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
            }
        }

        private void removeGameControler() {
            if ( m_timer != null ) {
                m_timer.Stop();
                m_timer.Dispose();
                m_timer = null;
            }
            m_game_mode = GameControlMode.DISABLED;
            updateGameControlerStatus( null, null );
        }

        private void loadGameControler() {
            try {
                boolean init_success = false;
                int num_joydev = winmmhelp.JoyInit();
                if ( num_joydev <= 0 ) {
                    init_success = false;
                } else {
                    init_success = true;
                }
                if ( init_success ) {
                    m_game_mode = GameControlMode.NORMAL;
                    stripLblGameCtrlMode.Image = null;
                    stripLblGameCtrlMode.Text = m_game_mode.ToString();
                    m_timer = new System.Windows.Forms.Timer();
                    m_timer.Interval = 10;
                    m_timer.Tick += new EventHandler( m_timer_Tick );
                    m_timer.Start();
                } else {
                    m_game_mode = GameControlMode.DISABLED;
                }
            } catch ( Exception ex ) {
                m_game_mode = GameControlMode.DISABLED;
#if DEBUG
                AppManager.debugWriteLine( "FormMain+ReloadGameControler" );
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
            }
            updateGameControlerStatus( null, null );
        }

        private void reloadMidiIn() {
#if DEBUG
            AppManager.debugWriteLine( "FormMain.ReloadMidiIn" );
#endif
            if ( m_midi_in != null ) {
                m_midi_in.MidiReceived -= m_midi_in_MidiReceived;
                m_midi_in.Dispose();
            }
            try {
                m_midi_in = new MidiInDevice( AppManager.editorConfig.MidiInPort.PortNumber );
                m_midi_in.MidiReceived += m_midi_in_MidiReceived;
            } catch ( Exception ex ) {
#if DEBUG
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
            }
            updateMidiInStatus();
        }

        private void m_midi_in_MidiReceived( DateTime time, byte[] data ) {
            if ( data.Length <= 2 ) {
                return;
            }
            if ( !AppManager.isPlaying() ) {
                return;
            }
            int code = data[0] & 0xf0;
#if DEBUG
            AppManager.debugWriteLine( "m_midi_in_MidiReceived" );
            AppManager.debugWriteLine( "    code=0x" + Convert.ToString( code, 16 ) );
#endif
            if ( code != 0x80 && code != 0x90 ) {
                return;
            }
            if ( code == 0x90 && data[2] == 0x00 ) {
                code = 0x80;//ベロシティ0のNoteOnはNoteOff
            }

            byte note = data[1];
            if ( code == 0x90 && AppManager.getEditMode() == EditMode.REALTIME ) {
                MidiPlayer.PlayImmediate( note );
            }

            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            if ( unit > 1 ) {
                int odd = clock % unit;
                int nclock = clock;
                nclock -= odd;
                if ( odd > unit / 2 ) {
                    nclock += unit;
                }
                clock = nclock;
            }

            if ( code == 0x80 ) {
                if ( AppManager.addingEvent != null ) {
                    int len = clock - AppManager.addingEvent.Clock;
                    if ( len <= 0 ) {
                        len = unit;
                    }
                    AppManager.addingEvent.ID.Length = len;
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( AppManager.getSelected(),
                                                                                                   AppManager.addingEvent ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    if ( !isEdited() ) {
                        setEdited( true );
                    }
#if USE_DOBJ
                    updateDrawObjectList();
#endif
                }
            } else if ( code == 0x90 ) {
                AppManager.addingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                AppManager.addingEvent.ID.type = VsqIDType.Anote;
                AppManager.addingEvent.ID.Dynamics = 64;
                AppManager.addingEvent.ID.VibratoHandle = null;
                AppManager.addingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                AppManager.addingEvent.ID.Note = note;
                if ( AppManager.getEditMode() != EditMode.REALTIME ) {
                    KeySoundPlayer.Play( note );
                }
            }
        }

        /// <summary>
        /// 現在のゲームコントローラのモードに応じてstripLblGameCtrlModeの表示状態を更新します。
        /// </summary>
        private void updateGameControlerStatus( Object sender, BEventArgs e ) {
            if ( m_game_mode == GameControlMode.DISABLED ) {
                stripLblGameCtrlMode.Text = _( "Disabled" );
                stripLblGameCtrlMode.Image = (System.Drawing.Bitmap)Properties.Resources.slash.Clone();
            } else if ( m_game_mode == GameControlMode.CURSOR ) {
                stripLblGameCtrlMode.Text = _( "Cursor" );
                stripLblGameCtrlMode.Image = null;
            } else if ( m_game_mode == GameControlMode.KEYBOARD ) {
                stripLblGameCtrlMode.Text = _( "Keyboard" );
                stripLblGameCtrlMode.Image = (System.Drawing.Bitmap)Properties.Resources.piano.Clone();
            } else if ( m_game_mode == GameControlMode.NORMAL ) {
                stripLblGameCtrlMode.Text = _( "Normal" );
                stripLblGameCtrlMode.Image = null;
            }
        }

        private void updateMidiInStatus() {
            int midiport = AppManager.editorConfig.MidiInPort.PortNumber;
            bocoree.MIDIINCAPS[] devices = MidiInDevice.GetMidiInDevices();
            if ( midiport < 0 || devices.Length <= 0 ) {
                stripLblMidiIn.Text = _( "Disabled" );
                stripLblMidiIn.Image = (System.Drawing.Bitmap)Properties.Resources.slash.Clone();
            } else {
                if ( midiport >= devices.Length ) {
                    midiport = 0;
                    AppManager.editorConfig.MidiInPort.PortNumber = midiport;
                }
                stripLblMidiIn.Text = devices[midiport].szPname;
                stripLblMidiIn.Image = (System.Drawing.Bitmap)Properties.Resources.piano.Clone();
            }
        }

        /// <summary>
        /// スクリプトフォルダ中のスクリプトへのショートカットを作成する
        /// </summary>
        private void updateScriptShortcut() {
            TreeMap<String, ScriptInvoker> old = new TreeMap<String, ScriptInvoker>();
            MenuElement[] sub_menu_script = menuScript.getSubElements();
            for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                MenuElement item = sub_menu_script[i];
                if ( !(item is BMenuItem) ) {
                    continue;
                }
                BMenuItem tsmi = (BMenuItem)item;
                MenuElement[] sub_tsmi = tsmi.getSubElements();
                if ( sub_tsmi.Length <= 0 ) {
                    continue;
                }
                if ( !(sub_tsmi[0] is BMenuItem) ) {
                    continue;
                }
                BMenuItem sub_tsmi0 = (BMenuItem)sub_tsmi[0];
                if ( sub_tsmi0.getTag() != null && sub_tsmi0.getTag() is ScriptInvoker ) {
                    ScriptInvoker si = (ScriptInvoker)sub_tsmi0.getTag();
                    old.put( si.ScriptFile, si );
                }
            }
            menuScript.removeAll();
            String script_path = PortUtil.combinePath( PortUtil.getApplicationStartupPath(), "script" );
            if ( !PortUtil.isDirectoryExists( script_path ) ) {
                System.IO.Directory.CreateDirectory( script_path );
            }

            System.IO.DirectoryInfo current = new System.IO.DirectoryInfo( script_path );
            int count = 0;
            Vector<System.IO.FileInfo> files = new Vector<System.IO.FileInfo>( current.GetFiles( "*.txt" ) );
            files.addAll( Arrays.asList( current.GetFiles( "*.cs" ) ) );
            for ( Iterator<System.IO.FileInfo> itr = files.iterator(); itr.hasNext(); ) {
                System.IO.FileInfo fi = itr.next();
                count++;
                String fname = fi.FullName;
                String scriptname = PortUtil.getFileNameWithoutExtension( fname );
                BMenuItem item = new BMenuItem();
                item.setText( scriptname );
                BMenuItem dd_run = new BMenuItem();
                dd_run.setText( _( "Run" ) + "(&R)" );
                dd_run.setName( "menuScript" + scriptname + "Run" );
                if ( old.containsKey( fname ) && old.get( fname ) != null ) {
                    dd_run.setTag( old.get( fname ) );
                } else {
                    ScriptInvoker si2 = new ScriptInvoker();
                    si2.FileTimestamp = DateTime.MinValue;
                    si2.ScriptFile = fname;
                    dd_run.setTag( si2 );
                }
                dd_run.Click += new EventHandler( dd_run_Click );
                item.add( dd_run );
                menuScript.add( item );
            }
            old.clear();
            if ( count > 0 ) {
                menuScript.DropDownItems.Add( new ToolStripSeparator() );
            }
            menuScript.add( menuScriptUpdate );
            Util.applyToolStripFontRecurse( menuScript, AppManager.editorConfig.getBaseFont() );
            applyShortcut();
        }

        private void dd_run_Click( Object sender, BEventArgs e ) {
#if DEBUG
            AppManager.debugWriteLine( "dd_run_Click" );
#endif
            try {
                ScriptInvoker si = (ScriptInvoker)((ToolStripMenuItem)sender).Tag;
                String script_file = si.ScriptFile;
#if DEBUG
                AppManager.debugWriteLine( "    si.FileTimestamp=" + si.FileTimestamp );
                AppManager.debugWriteLine( "    File.GetLastWriteTimeUtc( script_file )=" + System.IO.File.GetLastWriteTimeUtc( script_file ) );
#endif
                if ( si.FileTimestamp != System.IO.File.GetLastWriteTimeUtc( script_file ) ||
                     si.ScriptType == null ||
                     si.Serializer == null ||
                     si.scriptDelegate == null ) {

                    si = AppManager.loadScript( script_file );
                    ((ToolStripMenuItem)sender).Tag = si;
#if DEBUG
                    AppManager.debugWriteLine( "    err_msg=" + si.ErrorMessage );
#endif
                }
                if ( si.scriptDelegate != null ) {
                    if ( AppManager.invokeScript( si ) ) {
                        setEdited( true );
#if USE_DOBJ
                        updateDrawObjectList();
#endif
                        refreshScreen();
                    }
                } else {
                    FormCompileResult dlg = null;
                    try {
                        dlg = new FormCompileResult( _( "Failed loading script." ), si.ErrorMessage );
                        dlg.ShowDialog();
                    } catch ( Exception ex ) {
                    } finally {
                        if ( dlg != null ) {
                            try {
#if !JAVA
                                dlg.Dispose();
#endif
                            } catch ( Exception ex2 ) {
                            }
                        }
                    }
                }
            } catch ( Exception ex3 ) {
#if DEBUG
                PortUtil.println( "AppManager#dd_run_Click; ex3=" + ex3 );
#endif
            }
        }

        public void ensureVisible( int clock ) {
            // カーソルが画面内にあるかどうか検査
            int clock_left = AppManager.clockFromXCoord( AppManager.keyWidth );
            int clock_right = AppManager.clockFromXCoord( pictPianoRoll.Width );
            int uwidth = clock_right - clock_left;
            if ( clock < clock_left || clock_right < clock ) {
                int cl_new_center = (clock / uwidth) * uwidth + uwidth / 2;
                float f_draft = cl_new_center - (pictPianoRoll.Width / 2 + 34 - 70) / AppManager.scaleX;
                if ( f_draft < 0f ) {
                    f_draft = 0;
                }
                int draft = (int)(f_draft);
                if ( draft < hScroll.Minimum ) {
                    draft = hScroll.Minimum;
                } else if ( hScroll.Maximum < draft ) {
                    draft = hScroll.Maximum;
                }
                if ( hScroll.Value != draft ) {
                    AppManager.drawStartIndex[AppManager.getSelected() - 1] = 0;
                    hScroll.Value = draft;
                }
            }
        }

        /// <summary>
        /// プレイカーソルが見えるようスクロールする
        /// </summary>
        public void ensureCursorVisible() {
            ensureVisible( AppManager.getCurrentClock() );
        }

        /// <summary>
        /// 特殊なショートカットキーを処理します。
        /// </summary>
        /// <param name="e"></param>
        /// <param name="onPreviewKeyDown">PreviewKeyDownイベントから送信されてきた場合、true（送る側が設定する）</param>
        public void processSpecialShortcutKey( BKeyEventArgs e, boolean onPreviewKeyDown ) {
            boolean flipPlaying = false; // 再生/停止状態の切り替えが要求されたらtrue
#if JAVA
            if ( !AppManager.inputTextBox.isVisible() ) {
#else
            if ( !AppManager.inputTextBox.Enabled ) {
#endif

#if JAVA
                if ( e.KeyValue == KeyEvent.VK_DELETE ) {
#else
                if ( e.KeyCode == System.Windows.Forms.Keys.Delete ) {
#endif
                    if ( deleteShortcutHolder != null ) {
                        deleteShortcutHolder.doClick( new EventArgs() );
                    }
                }

#if JAVA
                if ( e.KeyValue == KeyEvent.VK_ENTER ) {
#else
                if ( e.KeyCode == System.Windows.Forms.Keys.Return ) {
#endif
                    numEnterKeyAfterHideInputTextBox++;
                    if ( numEnterKeyAfterHideInputTextBox >= 2 ) {
                        // 2回目以降しか受け付けないことにする
                        flipPlaying = true;
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_SPACE ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Space ) {
#endif
                    if ( !AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier ) {
                        flipPlaying = true;
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_PERIOD ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.OemPeriod ) {
#endif
                    if ( !onPreviewKeyDown ) {

                        if ( AppManager.isPlaying() ) {
                            AppManager.setPlaying( false );
                        } else {
                            if ( !AppManager.startMarkerEnabled ) {
                                AppManager.setCurrentClock( 0 );
                            } else {
                                AppManager.setCurrentClock( AppManager.startMarker );
                            }
                            refreshScreen();
                        }
                    }
#if JAVA
                } else if( e.KeyValue == KeyEvent.VK_ADD || e.KeyValue == KeyEvent.VK_PLUS || e.KeyValue == KeyEvent.VK_RIGHT ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Add || e.KeyCode == System.Windows.Forms.Keys.Oemplus || e.KeyCode == System.Windows.Forms.Keys.Right ) {
#endif
                    if ( onPreviewKeyDown ) {
                        forward();
                    }
#if JAVA
                } else if ( e.KeyValue == KeyEvent.VK_MINUS || e.KeyValue == KeyEvent.VK_LEFT ) {
#else
                } else if ( e.KeyCode == System.Windows.Forms.Keys.Subtract || e.KeyCode == System.Windows.Forms.Keys.OemMinus || e.KeyCode == System.Windows.Forms.Keys.Left ) {
#endif
                    if ( onPreviewKeyDown ) {
                        rewind();
                    }
                }
                if ( !onPreviewKeyDown && flipPlaying ) {
                    if ( AppManager.isPlaying() ) {
                        double elapsed = PlaySound.getPosition();
                        double threshold = AppManager.forbidFlipPlayingThresholdSeconds;
                        if ( threshold < 0 ) {
                            threshold = 0.0;
                        }
                        if ( elapsed > threshold ) {
                            timer.Stop();
                            AppManager.setPlaying( false );
                        }
                    } else {
                        AppManager.setPlaying( true );
                    }
                }
            }
            return;
            #region OLD CODES DO NOT REMOVE
            /*if ( AppManager.EditorConfig.Platform == Platform.Macintosh ) {
                if ( AppManager.EditorConfig.CommandKeyAsControl ) {
                    #region menuStripMain
                    if ( e.Alt && e.KeyCode == Keys.N && menuFileNew.isEnabled() ) {
                        this.menuFileNew_Click( menuFileNew, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.O && menuFileOpen.isEnabled() ) {
                        this.menuFileOpen_Click( menuFileOpen, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.S && menuFileSave.isEnabled() ) {
                        this.menuFileSave_Click( menuFileSave, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.Q && menuFileQuit.isEnabled() ) {
                        this.menuFileQuit_Click( menuFileQuit, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.Z && menuEditUndo.isEnabled() ) {
                        this.menuEditUndo_Click( menuEditUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && menuEditRedo.isEnabled() ) {
                        this.menuEditRedo_Click( this.menuEditRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.menuEditCut.isEnabled() ) {
                        this.menuEditCut_Click( this.menuEditCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.menuEditCopy.isEnabled() ) {
                        this.menuEditCopy_Click( this.menuEditCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.menuEditPaste.isEnabled() ) {
                        this.menuEditPaste_Click( this.menuEditPaste, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                        this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                        return;
                    } else if ( e.Alt && e.Shift && this.menuEditSelectAllEvents.isEnabled() ) {
                        this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                        this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                        return;
                    } else if ( (e.KeyCode & Keys.Clear) == Keys.Clear && e.Alt && e.Shift && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                        this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                        return;
                    } else if ( (e.KeyCode & Keys.LButton) == Keys.LButton && (e.KeyCode & Keys.LineFeed) == Keys.LineFeed && e.Alt && e.Shift && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                        this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                        return;
                    } else if ( (e.KeyCode & Keys.Clear) == Keys.Clear && e.Alt && this.menuHiddenTrackNext.isEnabled() ) {
                        this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                        return;
                    } else if ( (e.KeyCode & Keys.LButton) == Keys.LButton && (e.KeyCode & Keys.LineFeed) == Keys.LineFeed && e.Alt && this.menuHiddenTrackBack.isEnabled() ) {
                        this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                        return;
                    }
                    #endregion

                    #region cMenuPiano
                    if ( e.Alt && e.KeyCode == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                        this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                        this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                        this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                        this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                        this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                        this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                        return;
                    }
                    #endregion

                    #region cMenuTrackSelector
                    if ( e.Alt && e.KeyCode == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                        this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                        this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                        this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                        this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                        return;
                    } else if ( e.Alt && e.KeyCode == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                        this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                        return;
                    } else if ( e.Alt && e.Shift && e.KeyCode == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                        this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                        return;
                    }
                    #endregion
                } else {
                    boolean RButton = (e.KeyCode & Keys.RButton) == Keys.RButton;
                    boolean Clear = (e.KeyCode & Keys.Clear) == Keys.Clear;
                    boolean Return = (e.KeyCode & Keys.Return) == Keys.Return;
                    boolean Pause = (e.KeyCode & Keys.Pause) == Keys.Pause;
                    boolean FinalMode = (e.KeyCode & Keys.FinalMode) == Keys.FinalMode;
                    boolean Cancel = (e.KeyCode & Keys.Cancel) == Keys.Cancel;
                    boolean CapsLock = (e.KeyCode & Keys.CapsLock) == Keys.CapsLock;
                    boolean LButton = (e.KeyCode & Keys.LButton) == Keys.LButton;
                    boolean JunjaMode = (e.KeyCode & Keys.JunjaMode) == Keys.JunjaMode;
                    boolean LineFeed = (e.KeyCode & Keys.LineFeed) == Keys.LineFeed;
                    boolean ControlKey = (e.KeyCode & Keys.ControlKey) == Keys.ControlKey;
                    boolean XButton1 = (e.KeyCode & Keys.XButton1) == Keys.XButton1;

                    #region menuStripMain
                    if ( RButton && Clear && (e.KeyCode & Keys.N) == Keys.N && menuFileNew.isEnabled() ) {
                        this.menuFileNew_Click( menuFileNew, null );
                        return;
                    } else if ( RButton && Return && (e.KeyCode & Keys.O) == Keys.O && menuFileOpen.isEnabled() ) {
                        this.menuFileOpen_Click( menuFileOpen, null );
                        return;
                    } else if ( Pause && (e.KeyCode & Keys.S) == Keys.S && menuFileSave.isEnabled() ) {
                        this.menuFileSave_Click( menuFileSave, null );
                        return;
                    } else if ( ControlKey && (e.KeyCode & Keys.Q) == Keys.Q && menuFileQuit.isEnabled() ) {
                        this.menuFileQuit_Click( menuFileQuit, null );
                        return;
                    } else if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && menuEditUndo.isEnabled() ) {
                        this.menuEditUndo_Click( menuEditUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && menuEditRedo.isEnabled() ) {
                        this.menuEditRedo_Click( this.menuEditRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.menuEditCut.isEnabled() ) {
                        this.menuEditCut_Click( this.menuEditCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.menuEditCopy.isEnabled() ) {
                        this.menuEditCopy_Click( this.menuEditCopy, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.menuEditPaste.isEnabled() ) {
                        this.menuEditPaste_Click( this.menuEditPaste, null );
                        return;
                    } else if ( LButton && (e.KeyCode & Keys.A) == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                        this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && this.menuEditSelectAllEvents.isEnabled() ) {
                        this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                        this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                        return;
                    } else if ( JunjaMode && (e.KeyCode & Keys.W) == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                        return;
                    } else if ( XButton1 && (e.KeyCode & Keys.E) == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                        this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                        return;
                    } else if ( Clear && e.Control && e.Shift && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                        this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                        return;
                    } else if ( LButton && LineFeed && e.Control && e.Shift && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                        this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                        return;
                    } else if ( Clear && e.Control && this.menuHiddenTrackNext.isEnabled() ) {
                        this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                        return;
                    } else if ( LButton && LineFeed && e.Control && this.menuHiddenTrackBack.isEnabled() ) {
                        this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                        return;
                    }
                    #endregion

                    #region cMenuPiano
                    if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                        this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                        this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                        this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                        this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                        return;
                    } else if ( LButton && (e.KeyCode & Keys.A) == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                        this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                        this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                        return;
                    }
                    #endregion

                    #region cMenuTrackSelector
                    if ( RButton && FinalMode && (e.KeyCode & Keys.Z) == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                        this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                        return;
                    } else if ( RButton && FinalMode && e.Shift && (e.KeyCode & Keys.Z) == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                        this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                        return;
                    } else if ( FinalMode && (e.KeyCode & Keys.X) == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                        this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                        return;
                    } else if ( Cancel && (e.KeyCode & Keys.C) == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                        this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                        return;
                    } else if ( RButton && CapsLock && (e.KeyCode & Keys.V) == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                        this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                        return;
                    } else if ( LButton && e.Shift && (e.KeyCode & Keys.A) == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                        this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                        return;
                    }
                    #endregion
                }
            } else {
                #region menuStripMain
                if ( e.Control && e.KeyCode == Keys.N && menuFileNew.isEnabled() ) {
                    this.menuFileNew_Click( menuFileNew, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.O && menuFileOpen.isEnabled() ) {
                    this.menuFileOpen_Click( menuFileOpen, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.S && menuFileSave.isEnabled() ) {
                    this.menuFileSave_Click( menuFileSave, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.Q && menuFileQuit.isEnabled() ) {
                    this.menuFileQuit_Click( menuFileQuit, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.Z && menuEditUndo.isEnabled() ) {
                    this.menuEditUndo_Click( menuEditUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && menuEditRedo.isEnabled() ) {
                    this.menuEditRedo_Click( this.menuEditRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.menuEditCut.isEnabled() ) {
                    this.menuEditCut_Click( this.menuEditCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.menuEditCopy.isEnabled() ) {
                    this.menuEditCopy_Click( this.menuEditCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.menuEditPaste.isEnabled() ) {
                    this.menuEditPaste_Click( this.menuEditPaste, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.A && this.menuEditSelectAll.isEnabled() ) {
                    this.menuEditSelectAll_Click( this.menuEditSelectAll, null );
                    return;
                } else if ( e.Control && e.Shift && this.menuEditSelectAllEvents.isEnabled() ) {
                    this.menuEditSelectAllEvents_Click( this.menuEditSelectAllEvents, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.menuHiddenEditPaste.isEnabled() ) {
                    this.menuHiddenEditPaste_Click( this.menuHiddenEditPaste, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.W && this.menuHiddenEditFlipToolPointerPencil.isEnabled() ) {
                    this.menuHiddenEditFlipToolPointerPencil_Click( this.menuHiddenEditFlipToolPointerPencil, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.E && this.menuHiddenEditFlipToolPointerEraser.isEnabled() ) {
                    this.menuHiddenEditFlipToolPointerEraser_Click( this.menuHiddenEditFlipToolPointerEraser, null );
                    return;
                } else if ( e.Control && e.Alt && (e.KeyCode & Keys.PageDown) == Keys.PageDown && this.menuHiddenVisualForwardParameter.isEnabled() ) {
                    this.menuHiddenVisualForwardParameter_Click( this.menuHiddenVisualForwardParameter, null );
                    return;
                } else if ( e.Control && e.Alt && (e.KeyCode & Keys.PageUp) == Keys.PageUp && this.menuHiddenVisualBackwardParameter.isEnabled() ) {
                    this.menuHiddenVisualBackwardParameter_Click( this.menuHiddenVisualBackwardParameter, null );
                    return;
                } else if ( e.Control && (e.KeyCode & Keys.PageDown) == Keys.PageDown && this.menuHiddenTrackNext.isEnabled() ) {
                    this.menuHiddenTrackNext_Click( this.menuHiddenTrackNext, null );
                    return;
                } else if ( e.Control && (e.KeyCode & Keys.PageUp) == Keys.PageUp && this.menuHiddenTrackBack.isEnabled() ) {
                    this.menuHiddenTrackBack_Click( this.menuHiddenTrackBack, null );
                    return;
                }
                #endregion

                #region cMenuPiano
                if ( e.Control && e.KeyCode == Keys.Z && cMenuPianoUndo.isEnabled() ) {
                    this.cMenuPianoUndo_Click( this.cMenuPianoUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && this.cMenuPianoRedo.isEnabled() ) {
                    this.cMenuPianoRedo_Click( this.cMenuPianoRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.cMenuPianoCut.isEnabled() ) {
                    this.cMenuPianoCut_Click( this.cMenuPianoCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.cMenuPianoCopy.isEnabled() ) {
                    this.cMenuPianoCopy_Click( this.cMenuPianoCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.A && cMenuPianoSelectAll.isEnabled() ) {
                    this.cMenuPianoSelectAll_Click( this.cMenuPianoSelectAll, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.A && cMenuPianoSelectAllEvents.isEnabled() ) {
                    this.cMenuPianoSelectAllEvents_Click( this.cMenuPianoSelectAllEvents, null );
                    return;
                }
                #endregion

                #region cMenuTrackSelector
                if ( e.Control && e.KeyCode == Keys.Z && cMenuTrackSelectorUndo.isEnabled() ) {
                    this.cMenuTrackSelectorUndo_Click( this.cMenuTrackSelectorUndo, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.Z && this.cMenuTrackSelectorRedo.isEnabled() ) {
                    this.cMenuTrackSelectorRedo_Click( this.cMenuTrackSelectorRedo, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.X && this.cMenuTrackSelectorCut.isEnabled() ) {
                    this.cMenuTrackSelectorCut_Click( this.cMenuTrackSelectorCut, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.C && this.cMenuTrackSelectorCopy.isEnabled() ) {
                    this.cMenuTrackSelectorCopy_Click( this.cMenuTrackSelectorCopy, null );
                    return;
                } else if ( e.Control && e.KeyCode == Keys.V && this.cMenuTrackSelectorPaste.isEnabled() ) {
                    this.cMenuTrackSelectorPaste_Click( this.cMenuTrackSelectorPaste, null );
                    return;
                } else if ( e.Control && e.Shift && e.KeyCode == Keys.A && this.cMenuTrackSelectorSelectAll.isEnabled() ) {
                    this.cMenuTrackSelectorSelectAll_Click( this.cMenuTrackSelectorSelectAll, null );
                    return;
                }
                #endregion
            }*/
            #endregion
        }

        private void setHScrollRange( int draft_length ) {
            int _ARROWS = 40; // 両端の矢印の表示幅px（おおよその値）
            draft_length += 240;
            if ( draft_length > hScroll.Maximum ) {
                hScroll.Maximum = draft_length;
            }
            if ( pictPianoRoll.Width <= AppManager.keyWidth || hScroll.Width <= _ARROWS ) {
                return;
            }
            int large_change = (int)((pictPianoRoll.Width - AppManager.keyWidth) / (float)AppManager.scaleX);
            int box_width = (int)((hScroll.Width - _ARROWS) * (float)large_change / (float)(hScroll.Maximum + large_change));
            if ( box_width < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_width = AppManager.editorConfig.MinimumScrollHandleWidth;
                large_change = (int)((float)hScroll.Maximum * (float)box_width / (float)(hScroll.Width - _ARROWS - box_width));
            }
            if ( large_change > 0 ) {
                hScroll.LargeChange = large_change;
            }
        }

        private void setVScrollRange( int draft_length ) {
            int _ARROWS = 40; // 両端の矢印の表示幅px（おおよその値）
            if ( draft_length > vScroll.Maximum ) {
                vScroll.Maximum = draft_length;
            }
            int large_change = (int)pictPianoRoll.Height;
            int box_width = (int)((vScroll.Height - _ARROWS) * (float)large_change / (float)(vScroll.Maximum + large_change));
            if ( box_width < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_width = AppManager.editorConfig.MinimumScrollHandleWidth;
                large_change = (int)((float)vScroll.Maximum * (float)box_width / (float)(vScroll.Width - _ARROWS - box_width));
            }
            if ( large_change > 0 ) {
                vScroll.LargeChange = large_change;
            }
        }

        private void refreshScreenCore( Object sender, BEventArgs e ) {
            pictPianoRoll.Refresh();
            picturePositionIndicator.Refresh();
            trackSelector.Refresh();
            if ( menuVisualWaveform.Checked ) {
                waveView.Draw();
                waveView.Refresh();
            }
            if ( AppManager.editorConfig.OverviewEnabled ) {
                pictOverview.Refresh();
            }
        }

        public void refreshScreen() {
            //#if DEBUG
            //            RefreshScreenCore();
            //#else
            if ( !bgWorkScreen.IsBusy ) {
                double now = PortUtil.getCurrentTime();
                double dt = now - _last_screen_refreshed_sec;
                double mindt = 1.0 / AppManager.editorConfig.MaximumFrameRate;
                if ( dt > mindt ) {
                    _last_screen_refreshed_sec = now;
                    bgWorkScreen.RunWorkerAsync();
                }
            }
            //#endif
        }

        public void flipMixerDialogVisible( boolean visible ) {
            AppManager.mixerWindow.Visible = visible;
            AppManager.editorConfig.MixerVisible = visible;
            menuVisualMixer.Checked = visible;
        }

        /// <summary>
        /// メニューのショートカットキーを、AppManager.EditorConfig.ShorcutKeysの内容に応じて変更します
        /// </summary>
        private void applyShortcut() {
            deleteShortcutHolder = null;
            
            if ( AppManager.editorConfig.Platform == Platform.Macintosh ) {
                #region Platform.Macintosh
                String _CO = "";
                //if ( AppManager.EditorConfig.CommandKeyAsControl ) {
#if JAVA
                char[] arr = new char[]{ 0x2318 };
                _CO = new String( arr );
#else
                _CO = new String( '\x2318', 1 );
#endif
                //} else {
                //_CO = "^";
                //}
                String _SHIFT = "⇧";
                //if ( AppManager.EditorConfig.CommandKeyAsControl ) {
                #region menuStripMain
                menuFileNew.ShortcutKeys = Keys.Alt | Keys.N;
                menuFileOpen.ShortcutKeys = Keys.Alt | Keys.O;
                menuFileSave.ShortcutKeys = Keys.Alt | Keys.S;
                menuFileQuit.ShortcutKeys = Keys.Alt | Keys.Q;

                menuEditUndo.ShortcutKeys = Keys.Alt | Keys.Z;
                menuEditRedo.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.Z;
                menuEditCut.ShortcutKeys = Keys.Alt | Keys.X;
                menuEditCopy.ShortcutKeys = Keys.Alt | Keys.C;
                menuEditPaste.ShortcutKeys = Keys.Alt | Keys.V;
                menuEditSelectAll.ShortcutKeys = Keys.Alt | Keys.A;
                menuEditSelectAllEvents.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.A;

                menuHiddenEditFlipToolPointerPencil.ShortcutKeys = Keys.Alt | Keys.W;
                menuHiddenEditFlipToolPointerEraser.ShortcutKeys = Keys.Alt | Keys.E;
                menuHiddenVisualForwardParameter.ShortcutKeys = Keys.Clear | Keys.Alt | Keys.Shift;
                menuHiddenVisualBackwardParameter.ShortcutKeys = Keys.LButton | Keys.LineFeed | Keys.Alt | Keys.Shift;
                menuHiddenTrackNext.ShortcutKeys = Keys.Clear | Keys.Alt;
                menuHiddenTrackBack.ShortcutKeys = Keys.LButton | Keys.LineFeed | Keys.Alt;
                #endregion

                #region cMenuPiano
                cMenuPianoUndo.ShortcutKeys = Keys.Alt | Keys.Z;
                cMenuPianoRedo.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.Z;
                cMenuPianoCut.ShortcutKeys = Keys.Alt | Keys.X;
                cMenuPianoCopy.ShortcutKeys = Keys.Alt | Keys.C;
                cMenuPianoSelectAll.ShortcutKeys = Keys.Alt | Keys.A;
                cMenuPianoSelectAllEvents.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.A;
                #endregion

                #region cMenuTrackSelector
                cMenuTrackSelectorUndo.ShortcutKeys = Keys.Alt | Keys.Z;
                cMenuTrackSelectorRedo.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.Z;
                cMenuTrackSelectorCut.ShortcutKeys = Keys.Alt | Keys.X;
                cMenuTrackSelectorCopy.ShortcutKeys = Keys.Alt | Keys.C;
                cMenuTrackSelectorPaste.ShortcutKeys = Keys.Alt | Keys.V;
                cMenuTrackSelectorSelectAll.ShortcutKeys = Keys.Alt | Keys.Shift | Keys.A;
                #endregion
                /*} else {
                    #region menuStripMain
                    menuFileNew.ShortcutKeys = Keys.RButton | Keys.Clear | Keys.N;
                    menuFileOpen.ShortcutKeys = Keys.RButton | Keys.Return | Keys.O;
                    menuFileSave.ShortcutKeys = Keys.Pause | Keys.S;
                    menuFileQuit.ShortcutKeys = Keys.ControlKey | Keys.Q;

                    menuEditUndo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Z;
                    menuEditRedo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Shift | Keys.Z;
                    menuEditCut.ShortcutKeys = Keys.FinalMode | Keys.X;
                    menuEditCopy.ShortcutKeys = Keys.Cancel | Keys.C;
                    menuEditPaste.ShortcutKeys = Keys.RButton | Keys.CapsLock | Keys.V;
                    menuEditSelectAll.ShortcutKeys = Keys.LButton | Keys.A;
                    menuEditSelectAllEvents.ShortcutKeys = Keys.LButton | Keys.Shift | Keys.A;

                    menuHiddenEditPaste.ShortcutKeys = Keys.RButton | Keys.CapsLock | Keys.V;
                    menuHiddenEditFlipToolPointerPencil.ShortcutKeys = Keys.JunjaMode | Keys.W;
                    menuHiddenEditFlipToolPointerEraser.ShortcutKeys = Keys.XButton1 | Keys.E;
                    menuHiddenVisualForwardParameter.ShortcutKeys = Keys.Clear | Keys.Control | Keys.Shift;
                    menuHiddenVisualBackwardParameter.ShortcutKeys = Keys.LButton | Keys.LineFeed | Keys.Control | Keys.Shift;
                    menuHiddenTrackNext.ShortcutKeys = Keys.Clear | Keys.Control;
                    menuHiddenTrackBack.ShortcutKeys = Keys.LButton | Keys.LineFeed | Keys.Control;
                    #endregion

                    #region cMenuPiano
                    cMenuPianoUndo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Z;
                    cMenuPianoRedo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Shift | Keys.Z;
                    cMenuPianoCut.ShortcutKeys = Keys.FinalMode | Keys.X;
                    cMenuPianoCopy.ShortcutKeys = Keys.Cancel | Keys.C;
                    cMenuPianoSelectAll.ShortcutKeys = Keys.LButton | Keys.A;
                    cMenuPianoSelectAllEvents.ShortcutKeys = Keys.LButton | Keys.Shift | Keys.A;
                    #endregion

                    #region cMenuTrackSelector
                    cMenuTrackSelectorUndo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Z;
                    cMenuTrackSelectorRedo.ShortcutKeys = Keys.RButton | Keys.FinalMode | Keys.Shift | Keys.Z;
                    cMenuTrackSelectorCut.ShortcutKeys = Keys.FinalMode | Keys.X;
                    cMenuTrackSelectorCopy.ShortcutKeys = Keys.Cancel | Keys.C;
                    cMenuTrackSelectorPaste.ShortcutKeys = Keys.RButton | Keys.CapsLock | Keys.V;
                    cMenuTrackSelectorSelectAll.ShortcutKeys = Keys.LButton | Keys.Shift | Keys.A;
                    #endregion
                }*/
                menuFileNew.ShortcutKeyDisplayString = _CO + "N";
                menuFileOpen.ShortcutKeyDisplayString = _CO + "O";
                menuFileSave.ShortcutKeyDisplayString = _CO + "S";
                menuFileQuit.ShortcutKeyDisplayString = _CO + "Q";

                menuEditUndo.ShortcutKeyDisplayString = _CO + "Z";
                menuEditRedo.ShortcutKeyDisplayString = _SHIFT + _CO + "Z";
                menuEditCut.ShortcutKeyDisplayString = _CO + "X";
                menuEditCopy.ShortcutKeyDisplayString = _CO + "C";
                menuEditPaste.ShortcutKeyDisplayString = _CO + "V";
                menuEditSelectAll.ShortcutKeyDisplayString = _CO + "A";
                menuEditSelectAllEvents.ShortcutKeyDisplayString = _SHIFT + _CO + "A";

                cMenuPianoUndo.ShortcutKeyDisplayString = _CO + "Z";
                cMenuPianoRedo.ShortcutKeyDisplayString = _SHIFT + _CO + "Z";
                cMenuPianoCut.ShortcutKeyDisplayString = _CO + "X";
                cMenuPianoCopy.ShortcutKeyDisplayString = _CO + "C";
                cMenuPianoSelectAll.ShortcutKeyDisplayString = _CO + "A";
                cMenuPianoSelectAllEvents.ShortcutKeyDisplayString = _SHIFT + _CO + "A";

                cMenuTrackSelectorUndo.ShortcutKeyDisplayString = _CO + "Z";
                cMenuTrackSelectorRedo.ShortcutKeyDisplayString = _SHIFT + _CO + "Z";
                cMenuTrackSelectorCut.ShortcutKeyDisplayString = _CO + "X";
                cMenuTrackSelectorCopy.ShortcutKeyDisplayString = _CO + "C";
                cMenuTrackSelectorPaste.ShortcutKeyDisplayString = _CO + "V";
                cMenuTrackSelectorSelectAll.ShortcutKeyDisplayString = _SHIFT + _CO + "A";
                #endregion
            } else {
                TreeMap<String, BKeys[]> dict = AppManager.editorConfig.getShortcutKeysDictionary();
                #region menuStripMain
                for ( Iterator<String> itr = dict.keySet().iterator(); itr.hasNext(); ) {
                    String key = itr.next();
                    if ( key.Equals( "menuEditCopy" ) || key.Equals( "menuEditCut" ) || key.Equals( "menuEditPaste" ) ) {
                        continue;
                    }
                    MenuElement menu = searchMenuItemFromName( key );
                    if ( menu != null ) {
                        applyMenuItemShortcut( dict, menu, menu.getName() );
                    }
                }
                if ( dict.containsKey( "menuEditCopy" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenCopy, "menuEditCopy" );
                }
                if ( dict.containsKey( "menuEditCut" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenCut, "menuEditCut" );
                }
                if ( dict.containsKey( "menuEditCopy" ) ) {
                    applyMenuItemShortcut( dict, menuHiddenPaste, "menuEditPaste" );
                }
                #endregion

                ValuePair<String, ToolStripMenuItem[]>[] work = new ValuePair<String, ToolStripMenuItem[]>[]{
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditUndo", new ToolStripMenuItem[]{ cMenuPianoUndo, cMenuTrackSelectorUndo } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditRedo", new ToolStripMenuItem[]{ cMenuPianoRedo, cMenuTrackSelectorRedo } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditCut", new ToolStripMenuItem[]{ cMenuPianoCut, cMenuTrackSelectorCut, menuEditCut } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditCopy", new ToolStripMenuItem[]{ cMenuPianoCopy, cMenuTrackSelectorCopy, menuEditCopy } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditPaste", new ToolStripMenuItem[]{ cMenuPianoPaste, cMenuTrackSelectorPaste, menuEditPaste } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditSelectAll", new ToolStripMenuItem[]{ cMenuPianoSelectAll, cMenuTrackSelectorSelectAll } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditSelectAllEvents", new ToolStripMenuItem[]{ cMenuPianoSelectAllEvents } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuEditDelete", new ToolStripMenuItem[]{ menuEditDelete } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuVisualGridline", new ToolStripMenuItem[]{ cMenuPianoGrid } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuJobLyric", new ToolStripMenuItem[]{ cMenuPianoImportLyric } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuLyricExpressionProperty", new ToolStripMenuItem[]{ cMenuPianoExpressionProperty } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuLyricVibratoProperty", new ToolStripMenuItem[]{ cMenuPianoVibratoProperty } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackOn", new ToolStripMenuItem[]{ cMenuTrackTabTrackOn } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackAdd", new ToolStripMenuItem[]{ cMenuTrackTabAdd } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackCopy", new ToolStripMenuItem[]{ cMenuTrackTabCopy } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackDelete", new ToolStripMenuItem[]{ cMenuTrackTabDelete } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackRenderCurrent", new ToolStripMenuItem[]{ cMenuTrackTabRenderCurrent } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackRenderAll", new ToolStripMenuItem[]{ cMenuTrackTabRenderAll } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackOverlay", new ToolStripMenuItem[]{ cMenuTrackTabOverlay } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackRendererVOCALOID1", new ToolStripMenuItem[]{ cMenuTrackTabRendererVOCALOID1 } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackRendererVOCALOID2", new ToolStripMenuItem[]{ cMenuTrackTabRendererVOCALOID2 } ),
                    new ValuePair<String, ToolStripMenuItem[]>( "menuTrackRendererUtau", new ToolStripMenuItem[]{ cMenuTrackTabRendererUtau } ),
                };
                for ( int j = 0; j < work.Length; j++ ) {
                    ValuePair<String, ToolStripMenuItem[]> item = work[j];
                    if ( dict.containsKey( item.Key ) ) {
                        BKeys[] k = dict.get( item.Key );
                        String s = AppManager.getShortcutDisplayString( k );
                        if ( s != "" ) {
                            for ( int i = 0; i < item.Value.Length; i++ ) {
                                item.Value[i].ShortcutKeyDisplayString = s;
                            }
                        }
                    }
                }

                // スクリプトにショートカットを適用
#if DEBUG
                AppManager.debugWriteLine( "ApplyShortCut" );
#endif
                MenuElement[] sub_menu_script = menuScript.getSubElements();
                for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                    MenuElement tsi = sub_menu_script[i];
                    MenuElement[] sub_tsi = tsi.getSubElements();
                    if ( sub_tsi.Length == 1 ) {
                        MenuElement dd_run = sub_tsi[0];
#if DEBUG
                        AppManager.debugWriteLine( "    dd_run.name=" + dd_run.getName() );
#endif
                        if ( dict.containsKey( dd_run.getName() ) ) {
                            applyMenuItemShortcut( dict, tsi, tsi.getName() );
                        }
                    }
                }
            }
        }

        /// <summary>
        /// dictの中から
        /// </summary>
        /// <param name="dict"></param>
        /// <param name="item"></param>
        /// <param name="item_name"></param>
        /// <param name="default_shortcut"></param>
        private void applyMenuItemShortcut( TreeMap<String, BKeys[]> dict, MenuElement item, String item_name ) {
            try {
                if ( dict.containsKey( item_name ) ) {
                    if ( item is BMenuItem ) {
                        BMenuItem menu = (BMenuItem)item;
                        System.Windows.Forms.Keys shortcut = PortUtil.getKeyStrokeFromBKeys( dict.get( item_name ) ).keys;
                        if ( shortcut == System.Windows.Forms.Keys.Delete ) {
                            deleteShortcutHolder = menu;
                            menu.ShortcutKeyDisplayString = "Delete";
                            menu.ShortcutKeys = Keys.None;
                        } else {
                            menu.ShortcutKeyDisplayString = "";
                            menu.ShortcutKeys = shortcut;
                        }
                    }
                } else {
                    if ( item is BMenuItem ) {
                        ((BMenuItem)item).setAccelerator( PortUtil.getKeyStrokeFromBKeys( new BKeys[] { BKeys.None } ) );
                    }
                }
            } catch ( Exception ex ) {
            }
        }

        /// <summary>
        /// ソングポジションを1小節進めます
        /// </summary>
        private void forward() {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            int current = AppManager.getVsqFile().getBarCountFromClock( AppManager.getCurrentClock() ) + 1;
            int new_clock = AppManager.getVsqFile().getClockFromBarCount( current );
            if ( new_clock <= hScroll.Maximum + (pictPianoRoll.Width - AppManager.keyWidth) / AppManager.scaleX ) {
                AppManager.setCurrentClock( new_clock );
                ensureCursorVisible();
                AppManager.setPlaying( playing );
                refreshScreen();
            }
        }

        /// <summary>
        /// ソングポジションを1小節戻します
        /// </summary>
        private void rewind() {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            int current = AppManager.getVsqFile().getBarCountFromClock( AppManager.getCurrentClock() );
            if ( current > 0 ) {
                current--;
            }
            int new_clock = AppManager.getVsqFile().getClockFromBarCount( current );
            AppManager.setCurrentClock( new_clock );
            ensureCursorVisible();
            AppManager.setPlaying( playing );
            refreshScreen();
        }

        /// <summary>
        /// cMenuPianoの固定長音符入力の各メニューのチェック状態をm_pencil_modeを元に更新します
        /// </summary>
        private void updateCMenuPianoFixed() {
            cMenuPianoFixed01.CheckState = CheckState.Unchecked;
            cMenuPianoFixed02.CheckState = CheckState.Unchecked;
            cMenuPianoFixed04.CheckState = CheckState.Unchecked;
            cMenuPianoFixed08.CheckState = CheckState.Unchecked;
            cMenuPianoFixed16.CheckState = CheckState.Unchecked;
            cMenuPianoFixed32.CheckState = CheckState.Unchecked;
            cMenuPianoFixed64.CheckState = CheckState.Unchecked;
            cMenuPianoFixed128.CheckState = CheckState.Unchecked;
            cMenuPianoFixedOff.CheckState = CheckState.Unchecked;
            cMenuPianoFixedTriplet.CheckState = CheckState.Unchecked;
            cMenuPianoFixedDotted.CheckState = CheckState.Unchecked;
            switch ( m_pencil_mode.getMode() ) {
                case PencilModeEnum.L1:
                    cMenuPianoFixed01.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L2:
                    cMenuPianoFixed02.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L4:
                    cMenuPianoFixed04.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L8:
                    cMenuPianoFixed08.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L16:
                    cMenuPianoFixed16.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L32:
                    cMenuPianoFixed32.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L64:
                    cMenuPianoFixed64.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.L128:
                    cMenuPianoFixed128.CheckState = CheckState.Checked;
                    break;
                case PencilModeEnum.Off:
                    cMenuPianoFixedOff.CheckState = CheckState.Checked;
                    break;
            }
            cMenuPianoFixedTriplet.CheckState = (m_pencil_mode.isTriplet()) ? CheckState.Checked : CheckState.Unchecked;
            cMenuPianoFixedDotted.CheckState = (m_pencil_mode.isDot()) ? CheckState.Checked : CheckState.Unchecked;
        }

        private void clearTempWave() {
            String tmppath = AppManager.getTempWaveDir();

            for ( int i = 1; i <= 16; i++ ) {
                String file = PortUtil.combinePath( tmppath, i + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
                    for ( int error = 0; error < 100; error++ ) {
                        try {
                            PortUtil.deleteFile( file );
                            break;
                        } catch ( Exception ex ) {
#if DEBUG
                            bocoree.debug.push_log( "FormMain+ClearTempWave()" );
                            bocoree.debug.push_log( "    ex=" + ex.ToString() );
                            bocoree.debug.push_log( "    error_count=" + error );
#endif
                            System.Threading.Thread.Sleep( 100 );
                        }
                    }
                }
            }
            String whd = PortUtil.combinePath( tmppath, UtauRenderingRunner.FILEBASE + ".whd" );
            if ( PortUtil.isFileExists( whd ) ) {
                try {
                    PortUtil.deleteFile( whd );
                } catch ( Exception ex ) {
                }
            }
            String dat = PortUtil.combinePath( tmppath, UtauRenderingRunner.FILEBASE + ".dat" );
            if ( PortUtil.isFileExists( dat ) ) {
                try {
                    PortUtil.deleteFile( dat );
                } catch ( Exception ex ) {
                }
            }
        }

        private void render( int[] tracks ) {
            String tmppath = AppManager.getTempWaveDir();
            if ( !PortUtil.isDirectoryExists( tmppath ) ) {
                System.IO.Directory.CreateDirectory( tmppath );
            }
            String[] files = new String[tracks.Length];
            for ( int i = 0; i < tracks.Length; i++ ) {
                files[i] = PortUtil.combinePath( tmppath, tracks[i] + ".wav" );
            }
            FormSynthesize dlg = null;
            try {
                dlg = new FormSynthesize( AppManager.getVsqFile(), AppManager.editorConfig.PreSendTime, tracks, files, AppManager.getVsqFile().TotalClocks + 240, false );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    AppManager.getVsqFile().Track.get( AppManager.getSelected() ).resetEditedArea();
                }
                int[] finished = dlg.Finished;
                for ( int i = 0; i < finished.Length; i++ ) {
                    AppManager.setRenderRequired( finished[i], false );
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void playPreviewSound( int note ) {
            KeySoundPlayer.Play( note );
        }

        private void MouseHoverEventGenerator( Object arg ) {
            int note = (int)arg;
            if ( AppManager.editorConfig.MouseHoverTime > 0 ) {
                Thread.Sleep( AppManager.editorConfig.MouseHoverTime );
            }
            KeySoundPlayer.Play( note );
        }

        public static String _( String id ) {
            return Messaging.getMessage( id );
        }

        public void applyLanguage() {
            try {
                openXmlVsqDialog.Filter = _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                openXmlVsqDialog.Filter = "XML-VSQ Format(*.xvsq)|*.xvsq|All Files(*.*)|*.*";
            }
            try {
                saveXmlVsqDialog.Filter = _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                saveXmlVsqDialog.Filter = "XML-VSQ Format(*.xvsq)|*.xvsq|All Files(*.*)|*.*";
            }
            try {
                openUstDialog.Filter = _( "UTAU Script Format(*.ust)|*.ust" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                openUstDialog.Filter = "UTAU Script Format(*.ust)|*.ust|All Files(*.*)|*.*";
            }
            try {
                openMidiDialog.Filter = _( "MIDI Format(*.mid)|*.mid" ) + "|" + _( "VSQ Format(*.vsq)|*.vsq" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                openMidiDialog.Filter = "MIDI Format(*.mid)|*.mid|VSQ Format(*.vsq)|*.vsq|All Files(*.*)|*.*";
            }
            try {
                saveMidiDialog.Filter = _( "MIDI Format(*.mid)|*.mid" ) + "|" + _( "VSQ Format(*.vsq)|*.vsq" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                saveMidiDialog.Filter = "MIDI Format(*.mid)|*.mid|VSQ Format(*.vsq)|*.vsq|All Files(*.*)|*.*";
            }
            try {
                openWaveDialog.Filter = _( "Wave File(*.wav)|*.wav" ) + "|" + _( "All Files(*.*)|*.*" );
            } catch ( Exception ex ) {
                openWaveDialog.Filter = "Wave File(*.wav)|*.wav|All Files(*.*)|*.*";
            }

            stripLblGameCtrlMode.ToolTipText = _( "Game Controler" );
            this.Invoke( new BEventHandler( updateGameControlerStatus ) );

            stripBtnPointer.Text = _( "Pointer" );
            stripBtnPointer.ToolTipText = _( "Pointer" );
            stripBtnPencil.Text = _( "Pencil" );
            stripBtnPencil.ToolTipText = _( "Pencil" );
            stripBtnLine.Text = _( "Line" );
            stripBtnLine.ToolTipText = _( "Line" );
            stripBtnEraser.Text = _( "Eraser" );
            stripBtnEraser.ToolTipText = _( "Eraser" );
            stripBtnCurve.Text = _( "Curve" );
            stripBtnCurve.ToolTipText = _( "Curve" );
            stripBtnGrid.Text = _( "Grid" );
            stripBtnGrid.ToolTipText = _( "Grid" );

            #region main menu
            menuFile.Text = _( "File" ) + "(&F)";
            menuFileNew.Text = _( "New" ) + "(&N)";
            menuFileOpen.Text = _( "Open" ) + "(&O)";
            menuFileOpenVsq.Text = _( "Open VSQ/Vocaloid Midi" ) + "(&V)";
            menuFileOpenUst.Text = _( "Open UTAU Project File" ) + "(&U)";
            menuFileSave.Text = _( "Save" ) + "(&S)";
            menuFileSaveNamed.Text = _( "Save As" ) + "(&A)";
            menuFileImport.Text = _( "Import" ) + "(&I)";
            menuFileImportVsq.Text = _( "VSQ / Vocaloid Midi" );
            menuFileExport.Text = _( "Export" ) + "(&E)";
            menuFileRecent.Text = _( "Recent Files" ) + "(&R)";
            menuFileQuit.Text = _( "Quit" ) + "(&Q)";

            menuEdit.Text = _( "Edit" ) + "(&E)";
            menuEditUndo.Text = _( "Undo" ) + "(&U)";
            menuEditRedo.Text = _( "Redo" ) + "(&R)";
            menuEditCut.Text = _( "Cut" ) + "(&T)";
            menuEditCopy.Text = _( "Copy" ) + "(&C)";
            menuEditPaste.Text = _( "Paste" ) + "(&P)";
            menuEditDelete.Text = _( "Delete" ) + "(&D)";
            menuEditAutoNormalizeMode.Text = _( "Auto Normalize Mode" ) + "(&N)";
            menuEditSelectAll.Text = _( "Select All" ) + "(&A)";
            menuEditSelectAllEvents.Text = _( "Select All Events" ) + "(&E)";

            menuVisual.Text = _( "View" ) + "(&V)";
            menuVisualControlTrack.Text = _( "Control Track" ) + "(&C)";
            menuVisualMixer.Text = _( "Mixer" ) + "(&X)";
            menuVisualWaveform.Text = _( "Waveform" ) + "(&W)";
            menuVisualProperty.Text = _( "Property Window" );
            menuVisualOverview.Text = _( "Navigation" ) + "(&V)";
            menuVisualGridline.Text = _( "Grid Line" ) + "(&G)";
            menuVisualStartMarker.Text = _( "Start Marker" ) + "(&S)";
            menuVisualEndMarker.Text = _( "End Marker" ) + "(&E)";
            menuVisualLyrics.Text = _( "Lyrics/Phoneme" ) + "(&L)";
            menuVisualNoteProperty.Text = _( "Note Expression/Vibrato" ) + "(&N)";
            menuVisualPitchLine.Text = _( "Pitch Line" ) + "(&P)";

            menuJob.Text = _( "Job" ) + "(&J)";
            menuJobNormalize.Text = _( "Normalize Notes" ) + "(&N)";
            menuJobInsertBar.Text = _( "Insert Bars" ) + "(&I)";
            menuJobDeleteBar.Text = _( "Delete Bars" ) + "(&D)";
            menuJobRandomize.Text = _( "Randomize" ) + "(&R)";
            menuJobConnect.Text = _( "Connect Notes" ) + "(&C)";
            menuJobLyric.Text = _( "Insert Lyrics" ) + "(&L)";
            menuJobRewire.Text = _( "Import ReWire Host Tempo" ) + "(&T)";
            menuJobRealTime.Text = _( "Start Realtime Input" );
            menuJobReloadVsti.Text = _( "Reload VSTi" ) + "(&R)";

            menuTrack.Text = _( "Track" ) + "(&T)";
            menuTrackOn.Text = _( "Track On" ) + "(&K)";
            menuTrackAdd.Text = _( "Add Track" ) + "(&A)";
            menuTrackCopy.Text = _( "Copy Track" ) + "(&C)";
            menuTrackChangeName.Text = _( "Rename Track" ) + "(&R)";
            menuTrackDelete.Text = _( "Delete Track" ) + "(&D)";
            menuTrackRenderCurrent.Text = _( "Render Current Track" ) + "(&T)";
            menuTrackRenderAll.Text = _( "Render All Tracks" ) + "(&S)";
            menuTrackOverlay.Text = _( "Overlay" ) + "(&O)";
            menuTrackRenderer.Text = _( "Renderer" );

            menuLyric.Text = _( "Lyrics" ) + "(&L)";
            menuLyricExpressionProperty.Text = _( "Note Expression Property" ) + "(&E)";
            menuLyricVibratoProperty.Text = _( "Note Vibrato Property" ) + "(&V)";
            menuLyricSymbol.Text = _( "Phoneme Transformation" ) + "(&T)";
            menuLyricDictionary.Text = _( "User Word Dictionary" ) + "(&C)";

            menuScript.Text = _( "Script" ) + "(&C)";
            menuScriptUpdate.Text = _( "Update Script List" ) + "(&U)";

            menuSetting.Text = _( "Setting" ) + "(&S)";
            menuSettingPreference.Text = _( "Preference" ) + "(&P)";
            menuSettingGameControler.Text = _( "Game Controler" ) + "(&G)";
            menuSettingGameControlerLoad.Text = _( "Load" ) + "(&L)";
            menuSettingGameControlerRemove.Text = _( "Remove" ) + "(&R)";
            menuSettingGameControlerSetting.Text = _( "Setting" ) + "(&S)";
            menuSettingShortcut.Text = _( "Shortcut Key" ) + "(&S)";
            menuSettingUtauVoiceDB.Text = _( "UTAU Voice DB" ) + "(&U)";
            menuSettingDefaultSingerStyle.Text = _( "Singing Style Defaults" ) + "(&D)";
            menuSettingPositionQuantize.Text = _( "Quantize" ) + "(&Q)";
            menuSettingPositionQuantizeOff.Text = _( "Off" );
            menuSettingPositionQuantizeTriplet.Text = _( "Triplet" );
            menuSettingLengthQuantize.Text = _( "Length" ) + "(&L)";
            menuSettingLengthQuantizeOff.Text = _( "Off" );
            menuSettingLengthQuantizeTriplet.Text = _( "Triplet" );
            menuSettingSingerProperty.Text = _( "Singer Properties" ) + "(&S)";
            menuSettingPaletteTool.Text = _( "Palette Tool" ) + "(&T)";

            menuHelp.Text = _( "Help" ) + "(&H)";
            menuHelpAbout.Text = _( "About Cadencii" ) + "(&A)";

            menuHiddenEditLyric.Text = _( "Start Lyric Input" );
            menuHiddenEditFlipToolPointerEraser.Text = _( "Chagne Tool Pointer / Eraser" );
            menuHiddenEditFlipToolPointerPencil.Text = _( "Change Tool Pointer / Pencil" );
            menuHiddenTrackBack.Text = _( "Previous Track" );
            menuHiddenTrackNext.Text = _( "Next Track" );
            menuHiddenVisualBackwardParameter.Text = _( "Previous Control Curve" );
            menuHiddenVisualForwardParameter.Text = _( "Next Control Curve" );
            #endregion

            #region cMenuPiano
            cMenuPianoPointer.Text = _( "Arrow" ) + "(&A)";
            cMenuPianoPencil.Text = _( "Pencil" ) + "(&W)";
            cMenuPianoEraser.Text = _( "Eraser" ) + "(&E)";
            cMenuPianoPaletteTool.Text = _( "Palette Tool" );

            cMenuPianoCurve.Text = _( "Curve" ) + "(&V)";

            cMenuPianoFixed.Text = _( "Note Fixed Length" ) + "(&N)";
            cMenuPianoFixedTriplet.Text = _( "Triplet" );
            cMenuPianoFixedOff.Text = _( "Off" );
            cMenuPianoFixedDotted.Text = _( "Dot" );
            cMenuPianoQuantize.Text = _( "Quantize" ) + "(&Q)";
            cMenuPianoQuantizeTriplet.Text = _( "Triplet" );
            cMenuPianoQuantizeOff.Text = _( "Off" );
            cMenuPianoLength.Text = _( "Length" ) + "(&L)";
            cMenuPianoLengthTriplet.Text = _( "Triplet" );
            cMenuPianoLengthOff.Text = _( "Off" );
            cMenuPianoGrid.Text = _( "Show/Hide Grid Line" ) + "(&S)";

            cMenuPianoUndo.Text = _( "Undo" ) + "(&U)";
            cMenuPianoRedo.Text = _( "Redo" ) + "(&R)";

            cMenuPianoCut.Text = _( "Cut" ) + "(&T)";
            cMenuPianoPaste.Text = _( "Paste" ) + "(&P)";
            cMenuPianoCopy.Text = _( "Copy" ) + "(&C)";
            cMenuPianoDelete.Text = _( "Delete" ) + "(&D)";

            cMenuPianoSelectAll.Text = _( "Select All" ) + "(&A)";
            cMenuPianoSelectAllEvents.Text = _( "Select All Events" ) + "(&E)";

            cMenuPianoExpressionProperty.Text = _( "Note Expression Property" ) + "(&P)";
            cMenuPianoVibratoProperty.Text = _( "Note Vibrato Property" );
            cMenuPianoImportLyric.Text = _( "Insert Lyrics" ) + "(&P)";
            #endregion

            #region cMenuTrackTab
            cMenuTrackTabTrackOn.Text = _( "Track On" ) + "(&K)";
            cMenuTrackTabAdd.Text = _( "Add Track" ) + "(&A)";
            cMenuTrackTabCopy.Text = _( "Copy Track" ) + "(&C)";
            cMenuTrackTabChangeName.Text = _( "Rename Track" ) + "(&R)";
            cMenuTrackTabDelete.Text = _( "Delete Track" ) + "(&D)";

            cMenuTrackTabRenderCurrent.Text = _( "Render Current Track" ) + "(&T)";
            cMenuTrackTabRenderAll.Text = _( "Render All Tracks" ) + "(&S)";
            cMenuTrackTabOverlay.Text = _( "Overlay" ) + "(&O)";
            cMenuTrackTabRenderer.Text = _( "Renderer" );
            #endregion

            #region cMenuTrackSelector
            cMenuTrackSelectorPointer.Text = _( "Arrow" ) + "(&A)";
            cMenuTrackSelectorPencil.Text = _( "Pencil" ) + "(&W)";
            cMenuTrackSelectorLine.Text = _( "Line" ) + "(&L)";
            cMenuTrackSelectorEraser.Text = _( "Eraser" ) + "(&E)";
            cMenuTrackSelectorPaletteTool.Text = _( "Palette Tool" );

            cMenuTrackSelectorCurve.Text = _( "Curve" ) + "(&V)";

            cMenuTrackSelectorUndo.Text = _( "Undo" ) + "(&U)";
            cMenuTrackSelectorRedo.Text = _( "Redo" ) + "(&R)";

            cMenuTrackSelectorCut.Text = _( "Cut" ) + "(&T)";
            cMenuTrackSelectorCopy.Text = _( "Copy" ) + "(&C)";
            cMenuTrackSelectorPaste.Text = _( "Paste" ) + "(&P)";
            cMenuTrackSelectorDelete.Text = _( "Delete" ) + "(&D)";
            cMenuTrackSelectorDeleteBezier.Text = _( "Delete Bezier Point" ) + "(&B)";

            cMenuTrackSelectorSelectAll.Text = _( "Select All Events" ) + "(&E)";
            #endregion

            stripLblGameCtrlMode.ToolTipText = _( "Game Controler" );

            // Palette Tool
#if DEBUG
            AppManager.debugWriteLine( "FormMain.ApplyLanguage; Messaging.Language=" + Messaging.getLanguage() );
#endif
            foreach ( ToolStripItem tsi in toolStripTool.Items ) {
                if ( tsi is ToolStripButton ) {
                    ToolStripButton tsb = (ToolStripButton)tsi;
                    if ( tsb.Tag != null && tsb.Tag is String ) {
                        String id = (String)tsb.Tag;
                        if ( PaletteToolServer.LoadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
                            tsb.Text = ipt.getName( Messaging.getLanguage() );
                            tsb.ToolTipText = ipt.getDescription( Messaging.getLanguage() );
                        }
                    }
                }
            }

            foreach ( ToolStripItem tsi in cMenuPianoPaletteTool.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.Tag != null && tsmi.Tag is String ) {
                        String id = (String)tsmi.Tag;
                        if ( PaletteToolServer.LoadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
                            tsmi.Text = ipt.getName( Messaging.getLanguage() );
                            tsmi.ToolTipText = ipt.getDescription( Messaging.getLanguage() );
                        }
                    }
                }
            }

            foreach ( ToolStripItem tsi in cMenuTrackSelectorPaletteTool.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.Tag != null && tsmi.Tag is String ) {
                        String id = (String)tsmi.Tag;
                        if ( PaletteToolServer.LoadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
                            tsmi.Text = ipt.getName( Messaging.getLanguage() );
                            tsmi.ToolTipText = ipt.getDescription( Messaging.getLanguage() );
                        }
                    }
                }
            }

            foreach ( ToolStripItem tsi in menuSettingPaletteTool.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.Tag != null && tsmi.Tag is String ) {
                        String id = (String)tsmi.Tag;
                        if ( PaletteToolServer.LoadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
                            tsmi.Text = ipt.getName( Messaging.getLanguage() );
                        }
                    }
                }
            }

            for ( Iterator<String> itr = PaletteToolServer.LoadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = itr.next();
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.LoadedTools.get( id );
                ipt.applyLanguage( Messaging.getLanguage() );
            }

            updateStripDDBtnSpeed();
        }

        /// <summary>
        /// 歌詞の流し込みダイアログを開き，選択された音符を起点に歌詞を流し込みます
        /// </summary>
        public void importLyric() {
            int start = 0;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int selectedid = AppManager.getLastSelectedEvent().original.InternalID;
            int numEvents = vsq_track.getEventCount();
            for ( int i = 0; i < numEvents; i++ ) {
                if ( selectedid == vsq_track.getEvent( i ).InternalID ) {
                    start = i;
                    break;
                }
            }
            int count = vsq_track.getEventCount() - 1 - start + 1;
            FormImportLyric dlg = null;
            try {
                dlg = new FormImportLyric( count );
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                //dlg.Modal = true;
                //dlg.setVisible( true );
                if ( dlg.showDialog() == BDialogResult.OK ) {
                    String[] phrases = dlg.GetLetters();
#if DEBUG
                    foreach ( String s in phrases ) {
                        PortUtil.println( "FormMain#importLyric; phrases; s=" + s );
                    }
#endif
                    int min = Math.Min( count, phrases.Length );
                    Vector<String> new_phrases = new Vector<String>();
                    Vector<String> new_symbols = new Vector<String>();
                    for ( int i = 0; i < phrases.Length; i++ ) {
                        SymbolTableEntry entry = SymbolTable.attatch( phrases[i] );
                        if ( new_phrases.size() + 1 > count ) {
                            break;
                        }
                        if ( entry == null ) {
                            new_phrases.add( phrases[i] );
                            new_symbols.add( "a" );
                        } else {
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                // 分節に分割する必要がある
                                String[] spl = PortUtil.splitString( entry.Word, '\t' );
                                if ( new_phrases.size() + spl.Length > count ) {
                                    // 分節の全部を分割すると制限個数を超えてしまう
                                    // 分割せずにハイフンを付けたまま登録
                                    new_phrases.add( entry.Word.Replace( "\t", "" ) );
                                    new_symbols.add( entry.getParsedSymbol() );
                                } else {
                                    String[] spl_symbol = PortUtil.splitString( entry.Symbol, '\t' );
                                    for ( int j = 0; j < spl.Length; j++ ) {
                                        new_phrases.add( spl[j] );
                                        new_symbols.add( spl_symbol[j] );
                                    }
                                }
                            } else {
                                // 分節に分割しない
                                new_phrases.add( phrases[i] );
                                new_symbols.add( entry.getParsedSymbol() );
                            }
                        }
                    }
                    VsqID[] new_ids = new VsqID[new_phrases.size()];
                    int[] ids = new int[new_phrases.size()];
                    int indx = -1;
                    for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                        int index = itr.next();
                        if ( index < start ) {
                            continue;
                        }
                        indx++;
                        VsqEvent item = vsq_track.getEvent( index );
                        new_ids[indx] = (VsqID)item.ID.clone();
                        new_ids[indx].LyricHandle.L0.Phrase = new_phrases.get( indx );
                        new_ids[indx].LyricHandle.L0.setPhoneticSymbol( new_symbols.get( indx ) );
                        ids[indx] = item.InternalID;
                        if ( indx + 1 >= new_phrases.size() ) {
                            break;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaintsRange( selected, ids, new_ids ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    Refresh();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.Close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void editNoteVibratoProperty() {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            SynthesizerType type = SynthesizerType.VOCALOID2;
            if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormVibratoConfig dlg = null;
            try {
                dlg = new FormVibratoConfig( ev.ID.VibratoHandle, ev.ID.Length, AppManager.editorConfig.DefaultVibratoLength, type );
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    if ( dlg.VibratoHandle != null ) {
                        edited.ID.VibratoHandle = (VibratoHandle)dlg.VibratoHandle.clone();
                        edited.ID.VibratoDelay = ev.ID.Length - dlg.VibratoHandle.Length;
                        //edited.ID.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                        //edited.ID.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                    } else {
                        edited.ID.VibratoHandle = null;
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(), ev.InternalID, (VsqID)edited.ID.clone() ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private void editNoteExpressionProperty() {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            SynthesizerType type = SynthesizerType.VOCALOID2;
            if ( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCommon().Version.StartsWith( VSTiProxy.RENDERER_DSB2 ) ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormNoteExpressionConfig dlg = null;
            try {
                dlg = new FormNoteExpressionConfig( type, ev.ID.NoteHeadHandle );
                dlg.PMBendDepth = ev.ID.PMBendDepth;
                dlg.PMBendLength = ev.ID.PMBendLength;
                dlg.PMbPortamentoUse = ev.ID.PMbPortamentoUse;
                dlg.DEMdecGainRate = ev.ID.DEMdecGainRate;
                dlg.DEMaccent = ev.ID.DEMaccent;

                dlg.setLocation( getFormPreferedLocation( dlg ) );

                if ( dlg.ShowDialog() == DialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    edited.ID.PMBendDepth = dlg.PMBendDepth;
                    edited.ID.PMBendLength = dlg.PMBendLength;
                    edited.ID.PMbPortamentoUse = dlg.PMbPortamentoUse;
                    edited.ID.DEMdecGainRate = dlg.DEMdecGainRate;
                    edited.ID.DEMaccent = dlg.DEMaccent;
                    edited.ID.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( AppManager.getSelected(), ev.InternalID, (VsqID)edited.ID.clone() ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
            } finally {
                if ( dlg != null ) {
                    try {
#if !JAVA
                        dlg.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        private int computeScrollValueFromWheelDelta( int delta ) {
            double new_val = (double)hScroll.Value - delta * AppManager.editorConfig.WheelOrder / (5.0 * AppManager.scaleX);
            if ( new_val < 0.0 ) {
                new_val = 0;
            }
            int draft = (int)new_val;
            if ( draft > hScroll.Maximum ) {
                draft = hScroll.Maximum;
            } else if ( draft < hScroll.Minimum ) {
                draft = hScroll.Minimum;
            }
            return draft;
        }

        #region 音符の編集関連
        public void selectAll() {
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            int min = int.MaxValue;
            int max = int.MinValue;
            int premeasure = AppManager.getVsqFile().getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr.hasNext(); ) {
                VsqEvent ve = itr.next();
                if ( premeasure <= ve.Clock ) {
                    add_required.add( ve.InternalID );
                    min = Math.Min( min, ve.Clock );
                    max = Math.Max( max, ve.Clock + ve.ID.Length );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required.toArray( new Integer[] { } ) );
            }
            foreach ( CurveType vct in AppManager.CURVE_USAGE ) {
                if ( vct.isScalar() || vct.isAttachNote() ) {
                    continue;
                }
                VsqBPList target = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                int count = target.size();
                if ( count >= 1 ) {
                    //int[] keys = target.getKeys();
                    int max_key = target.getKeyClock( count - 1 );
                    max = Math.Max( max, target.getValue( max_key ) );
                    for ( int i = 0; i < count; i++ ) {
                        int key = target.getKeyClock( i );
                        if ( premeasure <= key ) {
                            min = Math.Min( min, key );
                            break;
                        }
                    }
                }
            }
            if ( min < premeasure ) {
                min = premeasure;
            }
            if ( min < max ) {
                //int stdx = AppManager.startToDrawX;
                //min = xCoordFromClocks( min ) + stdx;
                //max = xCoordFromClocks( max ) + stdx;
                AppManager.wholeSelectedInterval = new SelectedRegion( min );
                AppManager.wholeSelectedInterval.SetEnd( max );
                AppManager.setWholeSelectedIntervalEnabled( true );
            }
        }

        public void selectAllEvent() {
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
            int premeasureclock = AppManager.getVsqFile().getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr.hasNext(); ) {
                VsqEvent ev = itr.next();
                if ( ev.ID.type == VsqIDType.Anote && ev.Clock >= premeasureclock ) {
                    add_required.add( ev.InternalID );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required.toArray( new Integer[] { } ) );
            }
            refreshScreen();
        }

        private void deleteEvent() {
#if DEBUG
            AppManager.debugWriteLine( "DeleteEvent()" );
            AppManager.debugWriteLine( "    AppManager.inputTextBox.Enabled=" + AppManager.inputTextBox.Enabled );
#endif
            if ( !AppManager.inputTextBox.Enabled ) {
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    Vector<Integer> ids = new Vector<Integer>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry ev = itr.next();
                        ids.add( ev.original.InternalID );
                    }
                    VsqCommand run = VsqCommand.generateCommandEventDeleteRange( AppManager.getSelected(), ids );
                    if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                        VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().Clone();
                        work.executeCommand( run );
                        int stdx = AppManager.startToDrawX;
                        int start_clock = AppManager.wholeSelectedInterval.Start;
                        int end_clock = AppManager.wholeSelectedInterval.End;
                        Vector<Vector<BPPair>> curves = new Vector<Vector<BPPair>>();
                        Vector<CurveType> types = new Vector<CurveType>();
                        foreach ( CurveType vct in AppManager.CURVE_USAGE ) {
                            if ( vct.isScalar() || vct.isAttachNote() ) {
                                continue;
                            }
                            Vector<BPPair> t = new Vector<BPPair>();
                            t.add( new BPPair( start_clock, work.Track.get( AppManager.getSelected() ).getCurve( vct.getName() ).getValue( start_clock ) ) );
                            t.add( new BPPair( end_clock, work.Track.get( AppManager.getSelected() ).getCurve( vct.getName() ).getValue( end_clock ) ) );
                            curves.add( t );
                            types.add( vct );
                        }
                        Vector<String> strs = new Vector<String>();
                        for ( int i = 0; i < types.size(); i++ ) {
                            strs.add( types.get( i ).getName() );
                        }
                        CadenciiCommand delete_curve = new CadenciiCommand( VsqCommand.generateCommandTrackCurveEditRange( AppManager.getSelected(),
                                                                                                                           strs,
                                                                                                                           curves ) );
                        work.executeCommand( delete_curve );
                        CadenciiCommand run2 = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run2 ) );
                        setEdited( true );
                    } else {
                        CadenciiCommand run2 = new CadenciiCommand( run );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run2 ) );
                        setEdited( true );
                        AppManager.clearSelectedEvent();
                    }
                    this.Refresh();
                } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                    Vector<Integer> clocks = new Vector<Integer>();
                    for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                        //SelectedTempoEntry value = AppManager.getSelectedTempo().get( key );
                        if ( item.Key <= 0 ) {
                            statusLabel.Text = _( "Cannot remove first symbol of track!" );
                            SystemSounds.Asterisk.Play();
                            return;
                        }
                        clocks.add( item.Key );
                    }
                    int[] dum = new int[clocks.size()];
                    for ( int i = 0; i < dum.Length; i++ ) {
                        dum[i] = -1;
                    }
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks.toArray( new Integer[] { } ), clocks.toArray( new Integer[] { } ), dum ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    AppManager.clearSelectedTempo();
                    this.Refresh();
                } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
#if DEBUG
                    AppManager.debugWriteLine( "    Timesig" );
#endif
                    int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                    int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                    int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                    int count = -1;
                    for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                        int key = item.Key;
                        SelectedTimesigEntry value = item.Value;
                        count++;
                        barcounts[count] = key;
                        if ( key <= 0 ) {
                            statusLabel.Text = _( "Cannot remove first symbol of track!" );
                            SystemSounds.Asterisk.Play();
                            return;
                        }
                        numerators[count] = -1;
                        denominators[count] = -1;
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    AppManager.clearSelectedTimesig();
                    this.Refresh();
                }
                if ( AppManager.getSelectedPointIDCount() > 0 ) {
#if DEBUG
                    AppManager.debugWriteLine( "    Curve" );
#endif
                    String curve;
                    if ( !trackSelector.getSelectedCurve().isAttachNote() ) {
                        curve = trackSelector.getSelectedCurve().getName();
                        VsqBPList list = (VsqBPList)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve ).clone();
                        Vector<Integer> remove_clock_queue = new Vector<Integer>();
                        int count = list.size();
                        for ( int i = 0; i < count; i++ ) {
                            VsqBPPair item = list.getElementB( i );
                            if ( AppManager.isSelectedPointContains( item.id ) ) {
                                remove_clock_queue.add( list.getKeyClock( i ) );
                            }
                        }
                        count = remove_clock_queue.size();
                        for ( int i = 0; i < count; i++ ) {
                            list.remove( remove_clock_queue.get( i ) );
                        }
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandTrackCurveReplace( AppManager.getSelected(),
                                                                                                                trackSelector.getSelectedCurve().getName(),
                                                                                                                list ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                    } else {
                        //todo: FormMain+DeleteEvent; VibratoDepth, VibratoRateの場合
                    }
                    AppManager.clearSelectedPoint();
                    refreshScreen();
                }
            }
        }

        private void pasteEvent() {
            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            int odd = clock % unit;
            clock -= odd;
            if ( odd > unit / 2 ) {
                clock += unit;
            }

            VsqCommand add_event = null; // VsqEventを追加するコマンド

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            Vector<VsqEvent> copied_events = ce.events;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copy_started_clock=" + copy_started_clock );
            PortUtil.println( "FormMain#pasteEvent; copied_events.size()=" + copied_events.size() );
#endif
            if ( copied_events.size() != 0 ) {
                // VsqEventのペーストを行うコマンドを発行
                int dclock = clock - copy_started_clock;
                if ( clock >= AppManager.getVsqFile().getPreMeasureClocks() ) {
                    Vector<VsqEvent> paste = new Vector<VsqEvent>();
                    int count = copied_events.size();
                    for ( int i = 0; i < count; i++ ) {
                        VsqEvent item = (VsqEvent)copied_events.get( i ).clone();
                        item.Clock = copied_events.get( i ).Clock + dclock;
                        paste.add( item );
                    }
                    add_event = VsqCommand.generateCommandEventAddRange( AppManager.getSelected(), paste.toArray( new VsqEvent[] { } ) );
                }
            }
            Vector<TempoTableEntry> copied_tempo = ce.tempo;
            if ( copied_tempo.size() != 0 ) {
                // テンポ変更の貼付けを実行
                int dclock = clock - copy_started_clock;
                int count = copied_tempo.size();
                int[] clocks = new int[count];
                int[] tempos = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TempoTableEntry item = copied_tempo.get( i );
                    clocks[i] = item.Clock + dclock;
                    tempos[i] = item.Tempo;
                }
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, tempos ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }
            Vector<TimeSigTableEntry> copied_timesig = ce.timesig;
            if ( copied_timesig.size() > 0 ) {
                // 拍子変更の貼付けを実行
                int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                int min_barcount = copied_timesig.get( 0 ).BarCount;
                for ( Iterator<TimeSigTableEntry> itr = copied_timesig.iterator(); itr.hasNext(); ) {
                    TimeSigTableEntry tste = itr.next();
                    min_barcount = Math.Min( min_barcount, tste.BarCount );
                }
                int dbarcount = bar_count - min_barcount;
                int count = copied_timesig.size();
                int[] barcounts = new int[count];
                int[] numerators = new int[count];
                int[] denominators = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TimeSigTableEntry item = copied_timesig.get( i );
                    barcounts[i] = item.BarCount + dbarcount;
                    numerators[i] = item.Numerator;
                    denominators[i] = item.Denominator;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }

            // BPPairの貼付け
            VsqCommand edit_bpcurve = null; // BPListを変更するコマンド
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copied_curve.size()=" + copied_curve.size() );
#endif
            if ( copied_curve.size() > 0 ) {
                int dclock = clock - copy_started_clock;

                TreeMap<String, VsqBPList> work = new TreeMap<String, VsqBPList>();
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    VsqBPList list = copied_curve.get( curve );
#if DEBUG
                    AppManager.debugWriteLine( "FormMain#pasteEvent; curve=" + curve );
#endif
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    if ( list.size() <= 0 ) {
                        continue;
                    }
                    if ( curve.isAttachNote() ) {
                        //todo: FormMain+PasteEvent; VibratoRate, VibratoDepthカーブのペースト処理
                    } else {
                        VsqBPList target = (VsqBPList)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() ).clone();
                        int count = list.size();
#if DEBUG
                        PortUtil.println( "FormMain#pasteEvent; list.getCount()=" + count );
#endif
                        int min = list.getKeyClock( 0 ) + dclock;
                        int max = list.getKeyClock( count - 1 ) + dclock;
                        for ( int i = 0; i < target.size(); i++ ) {
                            int cl = target.getKeyClock( i );
                            if ( min <= cl && cl <= max ) {
                                target.removeElementAt( i );
                                i--;
                            }
                        }
                        for ( int i = 0; i < count; i++ ) {
                            target.add( list.getKeyClock( i ) + dclock, list.getElementA( i ) );
                        }
                        if ( copied_curve.size() == 1 ) {
                            work.put( trackSelector.getSelectedCurve().getName(), target );
                        } else {
                            work.put( curve.getName(), target );
                        }
                    }
                }
#if DEBUG
                PortUtil.println( "FormMain#pasteEvent; work.size()=" + work.size() );
#endif
                if ( work.size() > 0 ) {
                    String[] curves = new String[work.size()];
                    VsqBPList[] bplists = new VsqBPList[work.size()];
                    int count = -1;
                    for ( Iterator<String> itr = work.keySet().iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        count++;
                        curves[count] = s;
                        bplists[count] = work.get( s );
                    }
                    edit_bpcurve = VsqCommand.generateCommandTrackCurveReplaceRange( AppManager.getSelected(), curves, bplists );
                }
                AppManager.clearSelectedPoint();
            }

            // ベジエ曲線の貼付け
            CadenciiCommand edit_bezier = null;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
#if DEBUG
            PortUtil.println( "FormMain#pasteEvent; copied_bezier.size()=" + copied_bezier.size() );
#endif
            if ( copied_bezier.size() > 0 ) {
                int dclock = clock - copy_started_clock;
                BezierCurves attached_curve = (BezierCurves)AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ).clone();
                TreeMap<CurveType, Vector<BezierChain>> command_arg = new TreeMap<CurveType, Vector<BezierChain>>();
                for ( Iterator<CurveType> itr = copied_bezier.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr2 = copied_bezier.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        BezierChain bc_copy = (BezierChain)bc.Clone();
                        for ( Iterator<BezierPoint> itr3 = bc_copy.points.iterator(); itr3.hasNext(); ) {
                            BezierPoint bp = itr3.next();
                            bp.setBase( new PointD( bp.getBase().getX() + dclock, bp.getBase().getY() ) );
                        }
                        attached_curve.mergeBezierChain( curve, bc_copy );
                    }
                    Vector<BezierChain> arg = new Vector<BezierChain>();
                    for ( Iterator<BezierChain> itr2 = attached_curve.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        arg.add( bc );
                    }
                    command_arg.put( curve, arg );
                }
                edit_bezier = VsqFileEx.generateCommandReplaceAttachedCurveRange( AppManager.getSelected(), command_arg );
            }

            int commands = 0;
            commands += (add_event != null) ? 1 : 0;
            commands += (edit_bpcurve != null) ? 1 : 0;
            commands += (edit_bezier != null) ? 1 : 0;

#if DEBUG
            AppManager.debugWriteLine( "FormMain#pasteEvent; commands=" + commands );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (add_event != null)=" + (add_event != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bpcurve != null)=" + (edit_bpcurve != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bezier != null)=" + (edit_bezier != null) );
#endif
            if ( commands == 1 ) {
                if ( add_event != null ) {
                    CadenciiCommand run = new CadenciiCommand( add_event );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bpcurve != null ) {
                    CadenciiCommand run = new CadenciiCommand( edit_bpcurve );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bezier != null ) {
                    AppManager.register( AppManager.getVsqFile().executeCommand( edit_bezier ) );
                }
                setEdited( true );
                refreshScreen();
            } else if ( commands > 1 ) {
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().Clone();
                if ( add_event != null ) {
                    work.executeCommand( add_event );
                }
                if ( edit_bezier != null ) {
                    work.executeCommand( edit_bezier );
                }
                if ( edit_bpcurve != null ) {
                    // edit_bpcurveのVsqCommandTypeはTrackEditCurveRangeしかありえない
                    work.executeCommand( edit_bpcurve );
                }
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
            }
        }

        /// <summary>
        /// アイテムのコピーを行います
        /// </summary>
        private void copyEvent() {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#copyEvent" );
#endif
            AppManager.clearClipBoard();
            int min = int.MaxValue; // コピーされたアイテムの中で、最小の開始クロック

            if ( AppManager.isWholeSelectedIntervalEnabled() ) {
#if DEBUG
                PortUtil.println( "FormMain#copyEvent; selected with CTRL key" );
#endif
                int stdx = AppManager.startToDrawX;
                int start_clock = AppManager.wholeSelectedInterval.Start;
                int end_clock = AppManager.wholeSelectedInterval.End;
                ClipboardEntry ce = new ClipboardEntry();
                ce.copyStartedClock = start_clock;
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();
                for( int i = 0; i < AppManager.CURVE_USAGE.Length; i++ ){
                    CurveType vct = AppManager.CURVE_USAGE[i];
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                    if ( list == null ){
                        continue;
                    }
                    Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                    copyCurveCor( AppManager.getSelected(),
                                  vct,
                                  start_clock,
                                  end_clock,
                                  tmp_bezier );
                    VsqBPList tmp_bplist = new VsqBPList( list.getDefault(), list.getMinimum(), list.getMaximum() );
                    int c = list.size();
                    for ( int j = 0; j < c; j++ ) {
                        int clock = list.getKeyClock( j );
                        if ( start_clock <= clock && clock <= end_clock ) {
                            tmp_bplist.add( clock, list.getElement( j ) );
                        } else if ( end_clock < clock ) {
                            break;
                        }
                    }
                    ce.beziers.put( vct, tmp_bezier );
                    ce.points.put( vct, tmp_bplist );
                }

                if ( AppManager.getSelectedEventCount() > 0 ) {
                    Vector<VsqEvent> list = new Vector<VsqEvent>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        if ( item.original.ID.type == VsqIDType.Anote ) {
                            min = Math.Min( item.original.Clock, min );
                            list.add( (VsqEvent)item.original.clone() );
                        }
                    }
                    ce.events = list;
                }
                AppManager.setClipboard( ce );
            } else if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<VsqEvent> list = new Vector<VsqEvent>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    min = Math.Min( item.original.Clock, min );
                    list.add( (VsqEvent)item.original.clone() );
                }
                AppManager.setCopiedEvent( list, min );
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                Vector<TempoTableEntry> list = new Vector<TempoTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.Key;
                    SelectedTempoEntry value = item.Value;
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TempoTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTempo( list, min );
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                Vector<TimeSigTableEntry> list = new Vector<TimeSigTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.Key;
                    SelectedTimesigEntry value = item.Value;
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TimeSigTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTimesig( list, min );
            } else if ( AppManager.getSelectedPointIDCount() > 0 ) {
                ClipboardEntry ce = new ClipboardEntry();
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();

                ValuePair<Integer, Integer> t = trackSelector.getSelectedRegion();
                int start = t.Key;
                int end = t.Value;
                ce.copyStartedClock = start;
                Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                copyCurveCor( AppManager.getSelected(),
                              trackSelector.getSelectedCurve(),
                              start,
                              end,
                              tmp_bezier );
                if ( tmp_bezier.size() > 0 ) {
                    // ベジエ曲線が1個以上コピーされた場合
                    // 範囲内のデータ点を追加する
                    ce.beziers.put( trackSelector.getSelectedCurve(), tmp_bezier );
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( list.getDefault(), list.getMinimum(), list.getMaximum() );
                        int c = list.size();
                        for ( int i = 0; i < c; i++ ) {
                            int clock = list.getKeyClock( i );
                            if ( start <= clock && clock <= end ) {
                                tmp_bplist.add( clock, list.getElement( i ) );
                            } else if ( end < clock ) {
                                break;
                            }
                        }
                        ce.points.put( curve, tmp_bplist );
                    }
                } else {
                    // ベジエ曲線がコピーされなかった場合
                    // AppManager.selectedPointIDIteratorの中身のみを選択
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( curve.getDefault(), curve.getMinimum(), curve.getMaximum() );
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = itr.next();
                            VsqBPPairSearchContext cxt = list.findElement( id );
                            if ( cxt.index >= 0 ) {
                                tmp_bplist.add( cxt.clock, cxt.point.value );
                            }
                        }
                        if ( tmp_bplist.size() > 0 ) {
                            ce.copyStartedClock = tmp_bplist.getKeyClock( 0 );
                            ce.points.put( curve, tmp_bplist );
                        }
                    }
                }
                AppManager.setClipboard( ce );
            }
        }

        private void cutEvent() {
            // まずコピー
            copyEvent();

            int track = AppManager.getSelected();

            // 選択されたノートイベントがあれば、まず、削除を行うコマンドを発行
            VsqCommand delete_event = null;
            boolean other_command_executed = false;
            if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<Integer> ids = new Vector<Integer>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    ids.add( item.original.InternalID );
                }
                delete_event = VsqCommand.generateCommandEventDeleteRange( AppManager.getSelected(), ids );
            }

            // Ctrlキーを押しながらドラッグしたか、そうでないかで分岐
            if ( AppManager.isWholeSelectedIntervalEnabled() || AppManager.getSelectedPointIDCount() > 0 ) {
                int stdx = AppManager.startToDrawX;
                int start_clock, end_clock;
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    start_clock = AppManager.wholeSelectedInterval.Start;
                    end_clock = AppManager.wholeSelectedInterval.End;
                } else {
                    start_clock = trackSelector.getSelectedRegion().Key;
                    end_clock = trackSelector.getSelectedRegion().Value;
                }

                // クローンを作成
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().Clone();
                if ( delete_event != null ) {
                    // 選択されたノートイベントがあれば、クローンに対して削除を実行
                    work.executeCommand( delete_event );
                }

                // BPListに削除処理を施す
                for ( int i = 0; i < AppManager.CURVE_USAGE.Length; i++ ) {
                    CurveType curve = AppManager.CURVE_USAGE[i];
                    VsqBPList list = work.Track.get( track ).getCurve( curve.getName() );
                    if ( list == null ) {
                        continue;
                    }
                    int c = list.size();
                    Vector<Long> delete = new Vector<Long>();
                    if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                        // 一括選択モード
                        for ( int j = 0; j < c; j++ ) {
                            int clock = list.getKeyClock( j );
                            if ( start_clock <= clock && clock <= end_clock ) {
                                delete.add( list.getElementB( j ).id );
                            } else if ( end_clock < clock ) {
                                break;
                            }
                        }
                    } else {
                        // 普通の範囲選択
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = itr.next();
                            delete.add( id );
                        }
                    }
                    VsqCommand tmp = VsqCommand.generateCommandTrackCurveEdit2( track, curve.getName(), delete, new TreeMap<Integer, VsqBPPair>() );
                    work.executeCommand( tmp );
                }

                // ベジエ曲線に削除処理を施す
                Vector<CurveType> target_curve = new Vector<CurveType>();
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    // ctrlによる全選択モード
                    for ( int i = 0; i < AppManager.CURVE_USAGE.Length; i++ ) {
                        CurveType ct = AppManager.CURVE_USAGE[i];
                        if ( ct.isScalar() || ct.isAttachNote() ) {
                            continue;
                        }
                        target_curve.add( ct );
                    }
                } else {
                    // 普通の選択モード
                    target_curve.add( trackSelector.getSelectedCurve() );
                }
                work.AttachedCurves.get( AppManager.getSelected() - 1 ).deleteBeziers( target_curve, start_clock, end_clock );

                // コマンドを発行し、実行
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                this.setEdited( true );

                other_command_executed = true;
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                // テンポ変更のカット
                int count = -1;
                int[] dum = new int[AppManager.getSelectedTempoCount()];
                int[] clocks = new int[AppManager.getSelectedTempoCount()];
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.Key;
                    SelectedTempoEntry value = item.Value;
                    count++;
                    dum[count] = -1;
                    clocks[count] = value.original.Clock;
                }
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, dum ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                // 拍子変更のカット
                int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                int count = -1;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.Key;
                    SelectedTimesigEntry value = item.Value;
                    count++;
                    barcounts[count] = value.original.BarCount;
                    numerators[count] = -1;
                    denominators[count] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            }

            // 冒頭で作成した音符イベント削除以外に、コマンドが実行されなかった場合
            if ( delete_event != null && !other_command_executed ) {
                CadenciiCommand run = new CadenciiCommand( delete_event );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            }

            refreshScreen();
        }

        private void copyCurveCor(
            int track,
            CurveType curve_type,
            int start,
            int end,
            Vector<BezierChain> copied_chain
        ) {
            for ( Iterator<BezierChain> itr = AppManager.getVsqFile().AttachedCurves.get( track - 1 ).get( curve_type ).iterator(); itr.hasNext(); ) {
                BezierChain bc = itr.next();
                int len = bc.points.size();
                if ( len < 2 ) {
                    continue;
                }
                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                int chain_end = (int)bc.points.get( len - 1 ).getBase().getX();
                if ( start < chain_start && chain_start < end && end < chain_end ) {
                    // (1) chain_start ~ end をコピー
                    copied_chain.add( bc.extractPartialBezier( chain_start, end ) );
                } else if ( chain_start <= start && end <= chain_end ) {
                    // (2) start ~ endをコピー
                    copied_chain.add( bc.extractPartialBezier( start, end ) );
                } else if ( chain_start < start && start < chain_end && chain_end <= end ) {
                    // (3) start ~ chain_endをコピー
                    copied_chain.add( bc.extractPartialBezier( start, chain_end ) );
                } else if ( start <= chain_start && chain_end <= end ) {
                    // (4) 全部コピーでOK
                    copied_chain.add( (BezierChain)bc.Clone() );
                }
            }
        }
        #endregion

        #region トラックの編集関連
        private void copyTrackCore() {
            VsqTrack track = (VsqTrack)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).clone();
            track.setName( track.getName() + " (1)" );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( track,
                                                                     AppManager.getVsqFile().Mixer.Slave.get( AppManager.getSelected() - 1 ),
                                                                     AppManager.getVsqFile().Track.size(),
                                                                     AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ) ); ;
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            AppManager.mixerWindow.updateStatus();
            refreshScreen();
        }

        private void changeTrackNameCore() {
            if ( m_txtbox_track_name != null ) {
                if ( !m_txtbox_track_name.IsDisposed ) {
                    m_txtbox_track_name.Dispose();
                }
                m_txtbox_track_name = null;
            }
            m_txtbox_track_name = new TextBoxEx();
            m_txtbox_track_name.Visible = false;
            int selector_width = trackSelector.getSelectorWidth();
            int x = AppManager.keyWidth + (AppManager.getSelected() - 1) * selector_width;
            m_txtbox_track_name.setLocation( x, trackSelector.Height - TrackSelector.OFFSET_TRACK_TAB + 1 );
            m_txtbox_track_name.BorderStyle = BorderStyle.None;
            m_txtbox_track_name.Text = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getName();
            m_txtbox_track_name.KeyUp += new KeyEventHandler( m_txtbox_track_name_KeyUp );
            m_txtbox_track_name.setSize( selector_width, TrackSelector.OFFSET_TRACK_TAB );
            m_txtbox_track_name.Parent = trackSelector;
            m_txtbox_track_name.Visible = true;
            m_txtbox_track_name.Focus();
            m_txtbox_track_name.SelectAll();
        }

        private void deleteTrackCore() {
            int selected = AppManager.getSelected();
            if ( AppManager.showMessageBox(
                    String.Format( _( "Do you wish to remove track? {0} : '{1}'" ), selected, AppManager.getVsqFile().Track.get( selected ).getName() ),
                    _APP_NAME,
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question ) == BDialogResult.YES ) {
                //VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().Clone();
                CadenciiCommand run = VsqFileEx.generateCommandDeleteTrack( AppManager.getSelected() );
                //temp.executeCommand( run );
                //CadenciiCommand run2 = VsqFileEx.generateCommandReplace( temp );
                if ( AppManager.getSelected() >= 2 ) {
                    AppManager.setSelected( AppManager.getSelected() - 1 );
                }
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
#if USE_DOBJ
                updateDrawObjectList();
#endif
                setEdited( true );
                AppManager.mixerWindow.updateStatus();
                refreshScreen();
            }
        }

        private void addTrackCore() {
            VsqFileEx vsq = AppManager.getVsqFile();
            int i = vsq.Track.size();
            String name = "Voice" + i;
            String singer = AppManager.editorConfig.DefaultSingerName;
            VsqTrack vsq_track = new VsqTrack( name, singer );

            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );

            vsq_track.changeRenderer( renderer, singers );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( vsq_track,
                                                                     new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                     i,
                                                                     new BezierCurves() );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
#if USE_DOBJ
            updateDrawObjectList();
#endif
            setEdited( true );
            AppManager.setSelected( i );
            AppManager.mixerWindow.updateStatus();
            refreshScreen();
        }
        #endregion

        /// <summary>
        /// length, positionの各Quantizeモードに応じて、表示状態を更新します
        /// </summary>
        private void applyQuantizeMode() {
            cMenuPianoQuantize04.CheckState = CheckState.Unchecked;
            cMenuPianoQuantize08.CheckState = CheckState.Unchecked;
            cMenuPianoQuantize16.CheckState = CheckState.Unchecked;
            cMenuPianoQuantize32.CheckState = CheckState.Unchecked;
            cMenuPianoQuantize64.CheckState = CheckState.Unchecked;
            cMenuPianoQuantize128.CheckState = CheckState.Unchecked;
            cMenuPianoQuantizeOff.CheckState = CheckState.Unchecked;

            stripDDBtnQuantize04.CheckState = CheckState.Unchecked;
            stripDDBtnQuantize08.CheckState = CheckState.Unchecked;
            stripDDBtnQuantize16.CheckState = CheckState.Unchecked;
            stripDDBtnQuantize32.CheckState = CheckState.Unchecked;
            stripDDBtnQuantize64.CheckState = CheckState.Unchecked;
            stripDDBtnQuantize128.CheckState = CheckState.Unchecked;
            stripDDBtnQuantizeOff.CheckState = CheckState.Unchecked;

            menuSettingPositionQuantize04.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantize08.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantize16.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantize32.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantize64.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantize128.CheckState = CheckState.Unchecked;
            menuSettingPositionQuantizeOff.CheckState = CheckState.Unchecked;

            stripDDBtnQuantize.Text = "QUANTIZE " + QuantizeModeUtil.getString( AppManager.editorConfig.PositionQuantize );
            switch ( AppManager.editorConfig.PositionQuantize ) {
                case QuantizeMode.p4:
                    cMenuPianoQuantize04.CheckState = CheckState.Checked;
                    stripDDBtnQuantize04.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize04.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p8:
                    cMenuPianoQuantize08.CheckState = CheckState.Checked;
                    stripDDBtnQuantize08.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize08.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p16:
                    cMenuPianoQuantize16.CheckState = CheckState.Checked;
                    stripDDBtnQuantize16.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize16.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p32:
                    cMenuPianoQuantize32.CheckState = CheckState.Checked;
                    stripDDBtnQuantize32.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize32.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p64:
                    cMenuPianoQuantize64.CheckState = CheckState.Checked;
                    stripDDBtnQuantize64.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize64.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p128:
                    cMenuPianoQuantize128.CheckState = CheckState.Checked;
                    stripDDBtnQuantize128.CheckState = CheckState.Checked;
                    menuSettingPositionQuantize128.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.off:
                    cMenuPianoQuantizeOff.CheckState = CheckState.Checked;
                    stripDDBtnQuantizeOff.CheckState = CheckState.Checked;
                    menuSettingPositionQuantizeOff.CheckState = CheckState.Checked;
                    break;
            }
            cMenuPianoQuantizeTriplet.Checked = AppManager.editorConfig.PositionQuantizeTriplet;
            stripDDBtnQuantizeTriplet.Checked = AppManager.editorConfig.PositionQuantizeTriplet;
            menuSettingPositionQuantizeTriplet.Checked = AppManager.editorConfig.PositionQuantizeTriplet;

            cMenuPianoLength04.CheckState = CheckState.Unchecked;
            cMenuPianoLength08.CheckState = CheckState.Unchecked;
            cMenuPianoLength16.CheckState = CheckState.Unchecked;
            cMenuPianoLength32.CheckState = CheckState.Unchecked;
            cMenuPianoLength64.CheckState = CheckState.Unchecked;
            cMenuPianoLength128.CheckState = CheckState.Unchecked;
            cMenuPianoLengthOff.CheckState = CheckState.Unchecked;

            stripDDBtnLength04.CheckState = CheckState.Unchecked;
            stripDDBtnLength08.CheckState = CheckState.Unchecked;
            stripDDBtnLength16.CheckState = CheckState.Unchecked;
            stripDDBtnLength32.CheckState = CheckState.Unchecked;
            stripDDBtnLength64.CheckState = CheckState.Unchecked;
            stripDDBtnLength128.CheckState = CheckState.Unchecked;
            stripDDBtnLengthOff.CheckState = CheckState.Unchecked;

            menuSettingLengthQuantize04.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantize08.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantize16.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantize32.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantize64.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantize128.CheckState = CheckState.Unchecked;
            menuSettingLengthQuantizeOff.CheckState = CheckState.Unchecked;

            stripDDBtnLength.Text = "LENGTH " + QuantizeModeUtil.getString( AppManager.editorConfig.LengthQuantize );
            switch ( AppManager.editorConfig.LengthQuantize ) {
                case QuantizeMode.p4:
                    cMenuPianoLength04.CheckState = CheckState.Checked;
                    stripDDBtnLength04.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize04.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p8:
                    cMenuPianoLength08.CheckState = CheckState.Checked;
                    stripDDBtnLength08.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize08.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p16:
                    cMenuPianoLength16.CheckState = CheckState.Checked;
                    stripDDBtnLength16.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize16.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p32:
                    cMenuPianoLength32.CheckState = CheckState.Checked;
                    stripDDBtnLength32.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize32.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p64:
                    cMenuPianoLength64.CheckState = CheckState.Checked;
                    stripDDBtnLength64.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize64.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.p128:
                    cMenuPianoLength128.CheckState = CheckState.Checked;
                    stripDDBtnLength128.CheckState = CheckState.Checked;
                    menuSettingLengthQuantize128.CheckState = CheckState.Checked;
                    break;
                case QuantizeMode.off:
                    cMenuPianoLengthOff.CheckState = CheckState.Checked;
                    stripDDBtnLengthOff.CheckState = CheckState.Checked;
                    menuSettingLengthQuantizeOff.CheckState = CheckState.Checked;
                    break;
            }
            cMenuPianoLengthTriplet.Checked = AppManager.editorConfig.LengthQuantizeTriplet;
            stripDDBtnLengthTriplet.Checked = AppManager.editorConfig.LengthQuantizeTriplet;
            menuSettingLengthQuantizeTriplet.Checked = AppManager.editorConfig.LengthQuantizeTriplet;
        }

        /// <summary>
        /// 現在選択されている編集ツールに応じて、メニューのチェック状態を更新します
        /// </summary>
        private void applySelectedTool() {
            EditTool tool = AppManager.getSelectedTool();
            foreach ( ToolStripItem tsi in toolStripTool.Items ) {
                if ( tsi is BToolStripButton ) {
                    BToolStripButton tsb = (BToolStripButton)tsi;
                    Object tag = tsb.getTag();
                    if ( tag != null && tag is String ) {
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tag;
                            tsb.setSelected( (AppManager.selectedPaletteTool.Equals( id )) );
                        } else {
                            tsb.setSelected( false );
                        }
                    }
                }
            }
            foreach ( ToolStripItem tsi in cMenuTrackSelectorPaletteTool.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.Tag != null && tsmi.Tag is String ) {
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tsmi.Tag;
                            tsmi.Checked = (AppManager.selectedPaletteTool.Equals( id ));
                        } else {
                            tsmi.Checked = false;
                        }
                    }
                }
            }

            foreach ( ToolStripItem tsi in cMenuPianoPaletteTool.DropDownItems ) {
                if ( tsi is ToolStripMenuItem ) {
                    ToolStripMenuItem tsmi = (ToolStripMenuItem)tsi;
                    if ( tsmi.Tag != null && tsmi.Tag is String ) {
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tsmi.Tag;
                            tsmi.Checked = (AppManager.selectedPaletteTool.Equals( id ));
                        } else {
                            tsmi.Checked = false;
                        }
                    }
                }
            }

            switch ( AppManager.getSelectedTool() ) {
                case EditTool.ARROW:
                    cMenuPianoPointer.CheckState = CheckState.Checked;
                    cMenuPianoPencil.CheckState = CheckState.Unchecked;
                    cMenuPianoEraser.CheckState = CheckState.Unchecked;

                    cMenuTrackSelectorPointer.CheckState = CheckState.Checked;
                    cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;

                    stripBtnPointer.Checked = true;
                    stripBtnPencil.Checked = false;
                    stripBtnLine.Checked = false;
                    stripBtnEraser.Checked = false;
                    break;
                case EditTool.PENCIL:
                    cMenuPianoPointer.CheckState = CheckState.Unchecked;
                    cMenuPianoPencil.CheckState = CheckState.Checked;
                    cMenuPianoEraser.CheckState = CheckState.Unchecked;

                    cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorPencil.CheckState = CheckState.Checked;
                    cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;

                    stripBtnPointer.Checked = false;
                    stripBtnPencil.Checked = true;
                    stripBtnLine.Checked = false;
                    stripBtnEraser.Checked = false;
                    break;
                case EditTool.ERASER:
                    cMenuPianoPointer.CheckState = CheckState.Unchecked;
                    cMenuPianoPencil.CheckState = CheckState.Unchecked;
                    cMenuPianoEraser.CheckState = CheckState.Checked;

                    cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorEraser.CheckState = CheckState.Checked;

                    stripBtnPointer.Checked = false;
                    stripBtnPencil.Checked = false;
                    stripBtnLine.Checked = false;
                    stripBtnEraser.Checked = true;
                    break;
                case EditTool.LINE:
                    cMenuPianoPointer.CheckState = CheckState.Unchecked;
                    cMenuPianoPencil.CheckState = CheckState.Unchecked;
                    cMenuPianoEraser.CheckState = CheckState.Unchecked;

                    cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorLine.CheckState = CheckState.Checked;
                    cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;

                    stripBtnPointer.Checked = false;
                    stripBtnPencil.Checked = false;
                    stripBtnLine.Checked = true;
                    stripBtnEraser.Checked = false;
                    break;
                case EditTool.PALETTE_TOOL:
                    cMenuPianoPointer.CheckState = CheckState.Unchecked;
                    cMenuPianoPencil.CheckState = CheckState.Unchecked;
                    cMenuPianoEraser.CheckState = CheckState.Unchecked;

                    cMenuTrackSelectorPointer.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorPencil.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorLine.CheckState = CheckState.Unchecked;
                    cMenuTrackSelectorEraser.CheckState = CheckState.Unchecked;

                    stripBtnPointer.Checked = false;
                    stripBtnPencil.Checked = false;
                    stripBtnLine.Checked = false;
                    stripBtnEraser.Checked = false;
                    break;
            }
            cMenuPianoCurve.Checked = AppManager.isCurveMode();
            cMenuTrackSelectorCurve.Checked = AppManager.isCurveMode();
            stripBtnCurve.Checked = AppManager.isCurveMode();
        }

        /// <summary>
        /// 画面上のマウス位置におけるクロック値を元に，_toolbar_measureの場所表示文字列を更新します．
        /// </summary>
        /// <param name="mouse_pos_x"></param>
        private void updatePositionViewFromMousePosition( int clock ) {
            int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
            //int numerator, denominator;
            Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
            int clock_per_beat = 480 / 4 * timesig.denominator;
            int barcount_clock = AppManager.getVsqFile().getClockFromBarCount( barcount );
            int beat = (clock - barcount_clock) / clock_per_beat;
            int odd = clock - barcount_clock - beat * clock_per_beat;
#if OBSOLUTE
            m_toolbar_measure.Measure = (barcount - AppManager.VsqFile.PreMeasure + 1) + " : " + (beat + 1) + " : " + odd.ToString( "000" );
#else
            stripLblMeasure.Text = (barcount - AppManager.getVsqFile().getPreMeasure() + 1) + " : " + (beat + 1) + " : " + odd.ToString( "000" );
#endif
        }

        /// <summary>
        /// 描画すべきオブジェクトのリスト，AppManager.drawObjectsを更新します
        /// </summary>
        public void updateDrawObjectList() {
            // AppManager.m_draw_objects
            if ( AppManager.drawObjects == null ) {
                AppManager.drawObjects = new Vector<Vector<DrawObject>>();
            }
            lock ( AppManager.drawObjects ) {
                if ( AppManager.getVsqFile() == null ) {
                    return;
                }
                for ( int i = 0; i < AppManager.drawStartIndex.Length; i++ ) {
                    AppManager.drawStartIndex[i] = 0;
                }
                if ( AppManager.drawObjects != null ) {
                    for ( Iterator<Vector<DrawObject>> itr = AppManager.drawObjects.iterator(); itr.hasNext(); ) {
                        Vector<DrawObject> list = itr.next();
                        list.clear();
                    }
                    AppManager.drawObjects.clear();
                }

                int xoffset = 6;// 6 + AppManager.keyWidth;
                int yoffset = 127 * AppManager.editorConfig.PxTrackHeight;
                float scalex = AppManager.scaleX;
                Font SMALL_FONT = null;
                try {
                    SMALL_FONT = new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 );
                    for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                        Vector<DrawObject> tmp = new Vector<DrawObject>();
                        for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( track ).getEventIterator(); itr.hasNext(); ) {
                            VsqEvent ev = itr.next();
                            int timesig = ev.Clock;
                            if ( ev.ID.LyricHandle != null ) {
                                int length = ev.ID.Length;
                                int note = ev.ID.Note;
                                int x = (int)(timesig * scalex + xoffset);
                                int y = -note * AppManager.editorConfig.PxTrackHeight + yoffset;
                                int lyric_width = (int)(length * scalex);
                                String lyric_jp = ev.ID.LyricHandle.L0.Phrase;
                                String lyric_en = ev.ID.LyricHandle.L0.getPhoneticSymbol();
                                String title = AppManager.trimString( lyric_jp + " [" + lyric_en + "]", SMALL_FONT, lyric_width );
                                int accent = ev.ID.DEMaccent;
                                int vibrato_start = x + lyric_width;
                                int vibrato_end = x;
                                int vibrato_delay = lyric_width * 2;
                                if ( ev.ID.VibratoHandle != null ) {
                                    double rate = (double)ev.ID.VibratoDelay / (double)length;
                                    vibrato_delay = _PX_ACCENT_HEADER + (int)((lyric_width - _PX_ACCENT_HEADER) * rate);
                                }
                                VibratoBPList rate_bp = null;
                                VibratoBPList depth_bp = null;
                                int rate_start = 0;
                                int depth_start = 0;
                                if ( ev.ID.VibratoHandle != null ) {
                                    rate_bp = ev.ID.VibratoHandle.RateBP;
                                    depth_bp = ev.ID.VibratoHandle.DepthBP;
                                    rate_start = ev.ID.VibratoHandle.StartRate;
                                    depth_start = ev.ID.VibratoHandle.StartDepth;
                                }
                                tmp.add( new DrawObject( new Rectangle( x, y, lyric_width, AppManager.editorConfig.PxTrackHeight ),
                                                         title,
                                                         accent,
                                                         ev.InternalID,
                                                         vibrato_delay,
                                                         false,
                                                         ev.ID.LyricHandle.L0.PhoneticSymbolProtected,
                                                         rate_bp,
                                                         depth_bp,
                                                         rate_start,
                                                         depth_start,
                                                         ev.ID.Note,
                                                         ev.UstEvent.Envelope,
                                                         ev.ID.Length ) );
                            }
                        }

                        // 重複部分があるかどうかを判定
                        for ( int i = 0; i < tmp.size() - 1; i++ ) {
                            boolean overwrapped = false;
                            for ( int j = i + 1; j < tmp.size(); j++ ) {
                                int startx = tmp.get( j ).pxRectangle.x;
                                int endx = tmp.get( j ).pxRectangle.x + tmp.get( j ).pxRectangle.width;
                                if ( startx < tmp.get( i ).pxRectangle.x ) {
                                    if ( tmp.get( i ).pxRectangle.x < endx ) {
                                        overwrapped = true;
                                        tmp.get( j ).overlappe = true;
                                        // breakできない．2個以上の重複を検出する必要があるので．
                                    }
                                } else if ( tmp.get( i ).pxRectangle.x <= startx && startx < tmp.get( i ).pxRectangle.x + tmp.get( i ).pxRectangle.width ) {
                                    overwrapped = true;
                                    tmp.get( j ).overlappe = true;
                                }
                            }
                            if ( overwrapped ) {
                                tmp.get( i ).overlappe = true;
                            }
                        }
                        AppManager.drawObjects.add( tmp );
                    }
                } catch ( Exception ex ) {
                } finally {
#if !JAVA
                    if ( SMALL_FONT != null ) {
                        SMALL_FONT.font.Dispose();
                    }
#endif
                }
            }
        }

        /// <summary>
        /// _editor_configのRecentFilesを元に，menuFileRecentのドロップダウンアイテムを更新します
        /// </summary>
        private void updateRecentFileMenu() {
            int added = 0;
            menuFileRecent.DropDownItems.Clear();
            if ( AppManager.editorConfig.RecentFiles != null ) {
                for ( int i = 0; i < AppManager.editorConfig.RecentFiles.size(); i++ ) {
                    String item = AppManager.editorConfig.RecentFiles.get( i );
                    if ( item == null ) {
                        continue;
                    }
                    if ( item != "" ) {
                        String short_name = PortUtil.getFileName( item );
                        boolean available = PortUtil.isFileExists( item );
                        ToolStripItem itm = (ToolStripItem)(new ToolStripMenuItem( short_name ));
                        if ( !available ) {
                            itm.ToolTipText = _( "[file not found]" ) + " ";
                        }
                        itm.ToolTipText += item;
                        itm.Tag = item;
                        itm.Enabled = available;
                        itm.Click += new EventHandler( itm_Click );
                        itm.MouseEnter += new EventHandler( itm_MouseEnter );
                        menuFileRecent.DropDownItems.Add( itm );
                        added++;
                    }
                }
            } else {
                AppManager.editorConfig.pushRecentFiles( "" );
            }
            if ( added == 0 ) {
                menuFileRecent.Enabled = false;
            } else {
                menuFileRecent.Enabled = true;
            }
        }

        /// <summary>
        /// 最後に保存したときから変更されているかどうかを取得または設定します
        /// </summary>
        public boolean isEdited() {
            return m_edited;
        }

        public void setEdited( boolean value ) {
            m_edited = value;
            String file = AppManager.getFileName();
            if ( file.Equals( "" ) ) {
                file = "Untitled";
            } else {
                file = PortUtil.getFileNameWithoutExtension( file );
            }
            if ( m_edited ) {
                file += " *";
            }
            String title = file + " - " + _APP_NAME;
            if ( this.Text != title ) {
                this.Text = title;
            }
            boolean redo = AppManager.isRedoAvailable();
            boolean undo = AppManager.isUndoAvailable();
            menuEditRedo.Enabled = redo;
            menuEditUndo.Enabled = undo;
            cMenuPianoRedo.Enabled = redo;
            cMenuPianoUndo.Enabled = undo;
            cMenuTrackSelectorRedo.Enabled = redo;
            cMenuTrackSelectorUndo.Enabled = undo;
            stripBtnUndo.Enabled = undo;
            stripBtnRedo.Enabled = redo;
            //AppManager.setRenderRequired( AppManager.getSelected(), true );
            if ( AppManager.getVsqFile() != null ) {
                int draft = AppManager.getVsqFile().TotalClocks;
                if ( draft > hScroll.Maximum ) {
                    setHScrollRange( draft );
                }
            }
#if USE_DOBJ
            updateDrawObjectList();
#endif
            AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
        }

        /// <summary>
        /// 入力用のテキストボックスを初期化します
        /// </summary>
        private void showInputTextBox( String phrase, String phonetic_symbol, Point position, boolean phonetic_symbol_edit_mode ) {
#if DEBUG
            AppManager.debugWriteLine( "InitializeInputTextBox" );
#endif
            hideInputTextBox();
            AppManager.inputTextBox.KeyUp += m_input_textbox_KeyUp;
            AppManager.inputTextBox.KeyDown += m_input_textbox_KeyDown;
            AppManager.inputTextBox.ImeModeChanged += m_input_textbox_ImeModeChanged;
            AppManager.inputTextBox.setImeModeOn( m_last_is_imemode_on );
            if ( phonetic_symbol_edit_mode ) {
                AppManager.inputTextBox.Tag = new TagLyricTextBox( phrase, true );
                AppManager.inputTextBox.Text = phonetic_symbol;
                AppManager.inputTextBox.setBackground( s_txtbox_backcolor );
            } else {
                AppManager.inputTextBox.Tag = new TagLyricTextBox( phonetic_symbol, false );
                AppManager.inputTextBox.Text = phrase;
                AppManager.inputTextBox.setBackground( Color.white );
            }
            AppManager.inputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 ) );
            AppManager.inputTextBox.setLocation( position.x + 4, position.y + 2 );
            AppManager.inputTextBox.Parent = pictPianoRoll;
            AppManager.inputTextBox.Enabled = true;
            AppManager.inputTextBox.Visible = true;
            AppManager.inputTextBox.Focus();
            AppManager.inputTextBox.SelectAll();

        }

        private void hideInputTextBox() {
            AppManager.inputTextBox.KeyUp -= m_input_textbox_KeyUp;
            AppManager.inputTextBox.KeyDown -= m_input_textbox_KeyDown;
            AppManager.inputTextBox.ImeModeChanged -= m_input_textbox_ImeModeChanged;
            if ( AppManager.inputTextBox.Tag != null && AppManager.inputTextBox.Tag is TagLyricTextBox ) {
                TagLyricTextBox tltb = (TagLyricTextBox)AppManager.inputTextBox.Tag;
                m_last_symbol_edit_mode = tltb.PhoneticSymbolEditMode;
            }
            AppManager.inputTextBox.Visible = false;
            AppManager.inputTextBox.Parent = null;
            AppManager.inputTextBox.Enabled = false;
            pictPianoRoll.Focus();
            numEnterKeyAfterHideInputTextBox = 0;
        }

        /// <summary>
        /// 歌詞入力用テキストボックスのモード（歌詞/発音記号）を切り替えます
        /// </summary>
        private void flipInputTextBoxMode() {
            TagLyricTextBox kvp = (TagLyricTextBox)AppManager.inputTextBox.Tag;
            String new_value = AppManager.inputTextBox.Text;
            if ( !kvp.PhoneticSymbolEditMode ) {
                AppManager.inputTextBox.setBackground( s_txtbox_backcolor );
            } else {
                AppManager.inputTextBox.setBackground( Color.white );
            }
            AppManager.inputTextBox.Text = kvp.BufferText;
            AppManager.inputTextBox.Tag = new TagLyricTextBox( new_value, !kvp.PhoneticSymbolEditMode );
        }

        /// <summary>
        /// 音の高さを表すnoteから、画面に描くべきy座標を計算します
        /// </summary>
        /// <param name="note"></param>
        /// <returns></returns>
        public int yCoordFromNote( float note ) {
            return yCoordFromNote( note, getStartToDrawY() );
        }

        public int yCoordFromNote( float note, int start_to_draw_y ) {
            return (int)(-1 * (note - 127.0f) * AppManager.editorConfig.PxTrackHeight) - start_to_draw_y;
        }

        /// <summary>
        /// ピアノロール画面のy座標から、その位置における音の高さを取得します
        /// </summary>
        /// <param name="y"></param>
        /// <returns></returns>
        public int noteFromYCoord( int y ) {
            return 127 - (int)((double)(getStartToDrawY() + y) / (double)AppManager.editorConfig.PxTrackHeight);
        }

        /// <summary>
        /// 「選択されている」と登録されているオブジェクトのうち、Undo, Redoなどによって存在しなくなったものを登録解除する
        /// </summary>
        public void cleanupDeadSelection() {
            Vector<ValuePair<int, int>> list = new Vector<ValuePair<int, int>>();
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                list.add( new ValuePair<int, int>( item.track, item.original.InternalID ) );
            }

            for ( Iterator<ValuePair<Integer, Integer>> itr = list.iterator(); itr.hasNext(); ) {
                ValuePair<Integer, Integer> specif = itr.next();
                boolean found = false;
                for ( Iterator<VsqEvent> itr2 = AppManager.getVsqFile().Track.get( specif.Key ).getNoteEventIterator(); itr2.hasNext(); ) {
                    VsqEvent item = itr2.next();
                    if ( item.InternalID == specif.Value ) {
                        found = true;
                        break;
                    }
                }
                if ( !found ) {
                    AppManager.removeSelectedEvent( specif.Value );
                }
            }
        }

        /// <summary>
        /// アンドゥ処理を行います
        /// </summary>
        public void undo() {
            if ( AppManager.isUndoAvailable() ) {
                AppManager.undo();
                menuEditRedo.Enabled = AppManager.isRedoAvailable();
                menuEditUndo.Enabled = AppManager.isUndoAvailable();
                cMenuPianoRedo.Enabled = AppManager.isRedoAvailable();
                cMenuPianoUndo.Enabled = AppManager.isUndoAvailable();
                cMenuTrackSelectorRedo.Enabled = AppManager.isRedoAvailable();
                cMenuTrackSelectorUndo.Enabled = AppManager.isUndoAvailable();
                AppManager.mixerWindow.updateStatus();
                setEdited( true );
                cleanupDeadSelection();
#if USE_DOBJ
                updateDrawObjectList();
#endif
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
                }
            }
        }

        /// <summary>
        /// リドゥ処理を行います
        /// </summary>
        public void redo() {
            if ( AppManager.isRedoAvailable() ) {
                AppManager.redo();
                menuEditRedo.Enabled = AppManager.isRedoAvailable();
                menuEditUndo.Enabled = AppManager.isUndoAvailable();
                cMenuPianoRedo.Enabled = AppManager.isRedoAvailable();
                cMenuPianoUndo.Enabled = AppManager.isUndoAvailable();
                cMenuTrackSelectorRedo.Enabled = AppManager.isRedoAvailable();
                cMenuTrackSelectorUndo.Enabled = AppManager.isUndoAvailable();
                AppManager.mixerWindow.updateStatus();
                setEdited( true );
                cleanupDeadSelection();
#if USE_DOBJ
                updateDrawObjectList();
#endif
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.UpdateValue( AppManager.getSelected() );
                }
            }
        }

        public int getStartToDrawY() {
            return (int)((128 * AppManager.editorConfig.PxTrackHeight - vScroll.Height) * (float)vScroll.Value / ((float)vScroll.Maximum));
        }

        /// <summary>
        /// pがrcの中にあるかどうかを判定します
        /// </summary>
        /// <param name="p"></param>
        /// <param name="rc"></param>
        /// <returns></returns>
        static boolean isInRect( Point p, Rectangle rc ) {
            if ( rc.x <= p.x ) {
                if ( p.x <= rc.x + rc.width ) {
                    if ( rc.y <= p.y ) {
                        if ( p.y <= rc.y + rc.height ) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        /// <summary>
        /// マウス位置におけるIDを返します。該当するIDが無ければnullを返します
        /// rectには、該当するIDがあればその画面上での形状を、該当するIDがなければ、
        /// 画面上で最も近かったIDの画面上での形状を返します
        /// </summary>
        /// <param name="mouse_position"></param>
        /// <returns></returns>
        VsqEvent getItemAtClickedPosition( Point mouse_position, ByRef<Rectangle> rect ) {
            rect.value = new Rectangle();
            if ( AppManager.keyWidth <= mouse_position.x && mouse_position.x <= pictPianoRoll.Width ) {
                if ( 0 <= mouse_position.y && mouse_position.y <= pictPianoRoll.Height ) {
                    int selected = AppManager.getSelected();
                    if ( selected >= 1 ) {
                        for ( int j = 0; j < AppManager.getVsqFile().Track.get( selected ).getEventCount(); j++ ) {
                            int timesig = AppManager.getVsqFile().Track.get( selected ).getEvent( j ).Clock;
                            int internal_id = AppManager.getVsqFile().Track.get( selected ).getEvent( j ).InternalID;
                            // イベントで指定されたIDがLyricであった場合
                            if ( AppManager.getVsqFile().Track.get( selected ).getEvent( j ).ID.type == VsqIDType.Anote &&
                                AppManager.getVsqFile().Track.get( selected ).getEvent( j ).ID.LyricHandle != null ) {
                                // 発音長を取得
                                int length = AppManager.getVsqFile().Track.get( selected ).getEvent( j ).ID.Length;
                                int note = AppManager.getVsqFile().Track.get( selected ).getEvent( j ).ID.Note;
                                int x = AppManager.xCoordFromClocks( timesig );
                                int y = yCoordFromNote( note );
                                int lyric_width = (int)(length * AppManager.scaleX);
                                if ( x + lyric_width < 0 ) {
                                    continue;
                                } else if ( pictPianoRoll.Width < x ) {
                                    break;
                                }
                                if ( x <= mouse_position.x && mouse_position.x <= x + lyric_width ) {
                                    if ( y + 1 <= mouse_position.y && mouse_position.y <= y + AppManager.editorConfig.PxTrackHeight ) {
                                        rect.value = new Rectangle( x, y + 1, lyric_width, AppManager.editorConfig.PxTrackHeight );
                                        return AppManager.getVsqFile().Track.get( selected ).getEvent( j );
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }

        private void openVsqCor( String file ) {
            AppManager.readVsq( file );
            if ( AppManager.getVsqFile().Track.size() >= 2 ) {
                AppManager.setBaseTempo( AppManager.getVsqFile().getBaseTempo() );
                setHScrollRange( AppManager.getVsqFile().TotalClocks );
            }
            AppManager.editorConfig.pushRecentFiles( file );
            updateRecentFileMenu();
            setEdited( false );
            AppManager.clearCommandBuffer();
            AppManager.mixerWindow.updateStatus();
        }

        private void updateMenuFonts() {
            if ( AppManager.editorConfig.BaseFontName.Equals( "" ) ) {
                return;
            }
            Font font = AppManager.editorConfig.getBaseFont();
            Util.applyFontRecurse( this, font );
            Util.applyContextMenuFontRecurse( cMenuPiano, font );
            Util.applyContextMenuFontRecurse( cMenuTrackSelector, font );
            if ( AppManager.mixerWindow != null ) {
                Util.applyFontRecurse( AppManager.mixerWindow, font );
            }
            Util.applyContextMenuFontRecurse( cMenuTrackTab, font );
            trackSelector.applyFont( font );
            Util.applyToolStripFontRecurse( menuFile, font );
            Util.applyToolStripFontRecurse( menuEdit, font );
            Util.applyToolStripFontRecurse( menuVisual, font );
            Util.applyToolStripFontRecurse( menuJob, font );
            Util.applyToolStripFontRecurse( menuTrack, font );
            Util.applyToolStripFontRecurse( menuLyric, font );
            Util.applyToolStripFontRecurse( menuScript, font );
            Util.applyToolStripFontRecurse( menuSetting, font );
            Util.applyToolStripFontRecurse( menuHelp, font );
            foreach ( ToolStripItem tsi in toolStripFile.Items ) {
                Util.applyToolStripFontRecurse( tsi, font );
            }
            foreach ( ToolStripItem tsi in toolStripMeasure.Items ) {
                Util.applyToolStripFontRecurse( tsi, font );
            }
            foreach ( ToolStripItem tsi in toolStripPosition.Items ) {
                Util.applyToolStripFontRecurse( tsi, font );
            }
            foreach ( ToolStripItem tsi in toolStripTool.Items ) {
                Util.applyToolStripFontRecurse( tsi, font );
            }
            if ( m_preference_dlg != null ) {
                Util.applyFontRecurse( m_preference_dlg, font );
            }

            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, 10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 );
            AppManager.baseFont10OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont10 );
            AppManager.baseFont8OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont8 );
            AppManager.baseFont9OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont9 );
        }

        private void picturePositionIndicatorDrawTo( Graphics2D g ) {
            Font SMALL_FONT = null;
            try {
                SMALL_FONT = new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, 8 );
                int width = picturePositionIndicator.Width;
                int height = picturePositionIndicator.Height;

                #region 小節ごとの線
                int dashed_line_step = AppManager.getPositionQuantizeClock();
                for ( Iterator<VsqBarLineType> itr = AppManager.getVsqFile().getBarLineIterator( AppManager.clockFromXCoord( width ) ); itr.hasNext(); ) {
                    VsqBarLineType blt = itr.next();
                    int local_clock_step = 480 * 4 / blt.getLocalDenominator();
                    int x = AppManager.xCoordFromClocks( blt.clock() );
                    if ( blt.isSeparator() ) {
                        int current = blt.getBarCount() - AppManager.getVsqFile().getPreMeasure() + 1;
                        g.setColor( s_pen_105_105_105 );
                        g.drawLine( x, 3, x, 46 );
                        // 小節の数字
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                        g.setColor( Color.black );
                        g.setFont( SMALL_FONT );
                        g.drawString( current.ToString(), x + 4, 6 );
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                    } else {
                        g.setColor( s_pen_105_105_105 );
                        g.drawLine( x, 11, x, 16 );
                        g.drawLine( x, 26, x, 31 );
                        g.drawLine( x, 41, x, 46 );
                    }
                    if ( dashed_line_step > 1 && AppManager.isGridVisible() ) {
                        int numDashedLine = local_clock_step / dashed_line_step;
                        for ( int i = 1; i < numDashedLine; i++ ) {
                            int x2 = AppManager.xCoordFromClocks( blt.clock() + i * dashed_line_step );
                            g.setColor( s_pen_065_065_065 );
                            g.drawLine( x2, 9 + 5, x2, 14 + 3 );
                            g.drawLine( x2, 24 + 5, x2, 29 + 3 );
                            g.drawLine( x2, 39 + 5, x2, 44 + 3 );
                        }
                    }
                }
                #endregion

                if ( AppManager.getVsqFile() != null ) {
                    #region 拍子の変更
                    for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                        int clock = AppManager.getVsqFile().TimesigTable.get( i ).Clock;
                        int barcount = AppManager.getVsqFile().TimesigTable.get( i ).BarCount;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = AppManager.getVsqFile().TimesigTable.get( i ).Numerator + "/" + AppManager.getVsqFile().TimesigTable.get( i ).Denominator;
                        g.setFont( SMALL_FONT );
                        if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 36 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 36 );
                        }

                        if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TIMESIG ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( AppManager.getVsqFile().getClockFromBarCount( AppManager.getSelectedTimesig( barcount ).editing.BarCount ) );
                                g.setColor( s_pen_187_187_255 );
                                g.drawLine( edit_clock_x - 1, 32,
                                            edit_clock_x - 1, picturePositionIndicator.Height - 1 );
                                g.setColor( s_pen_007_007_151 );
                                g.drawLine( edit_clock_x, 32,
                                            edit_clock_x, picturePositionIndicator.Height - 1 );
                            }
                        }
                    }
                    #endregion

                    #region テンポの変更
                    g.setFont( SMALL_FONT );
                    for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = (60e6 / (float)AppManager.getVsqFile().TempoTable.get( i ).Tempo).ToString( "#.00" );
                        if ( AppManager.isSelectedTempoContains( clock ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 21 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 21 );
                        }

                        if ( m_position_indicator_mouse_down_mode == PositionIndicatorMouseDownMode.TEMPO ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( AppManager.getSelectedTempo( clock ).editing.Clock );
                                g.setColor( s_pen_187_187_255 );
                                g.drawLine( edit_clock_x - 1, 18,
                                            edit_clock_x - 1, 32 );
                                g.setColor( s_pen_007_007_151 );
                                g.drawLine( edit_clock_x, 18,
                                            edit_clock_x, 32 );
                            }
                        }
                    }
                    #endregion
                }

                #region 外枠
                /* 左(外側) */
                g.setColor( new Color( 160, 160, 160 ) );
                g.drawLine( 0, 0, 0, height - 1 );
                /* 左(内側) */
                g.setColor( new Color( 105, 105, 105 ) );
                g.drawLine( 1, 1, 1, height - 2 );
                /* 中(上側) */
                g.setColor( new Color( 160, 160, 160 ) );
                g.drawLine( 1, 47, width - 2, 47 );
                /* 中(下側) */
                g.setColor( new Color( 105, 105, 105 ) );
                g.drawLine( 2, 48, width - 3, 48 );
                // 右(外側)
                g.setColor( Color.white );
                g.drawLine( width - 1, 0, width - 1, height - 1 );
                // 右(内側)
                g.setColor( new Color( 241, 239, 226 ) );
                g.drawLine( width - 2, 1, width - 2, height - 1 );
                #endregion

                #region 現在のマーカー
                float xoffset = AppManager.keyWidth + 6 - AppManager.startToDrawX;
                int marker_x = (int)(AppManager.getCurrentClock() * AppManager.scaleX + xoffset);
                if ( AppManager.keyWidth <= marker_x && marker_x <= width ) {
                    g.setStroke( new BasicStroke( 2.0f ) );
                    g.setColor( Color.white );
                    g.drawLine( marker_x, 2, marker_x, height );
                    g.setStroke( new BasicStroke() );
                }
                if ( AppManager.startMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( AppManager.startMarker );
                    g.nativeGraphics.DrawImage(
                        Properties.Resources.start_marker, x, 3 );
                }
                if ( AppManager.endMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( AppManager.endMarker ) - 6;
                    g.nativeGraphics.DrawImage(
                        Properties.Resources.end_marker, x, 3 );
                }
                #endregion

                #region TEMPO & BEAT
                // TEMPO BEATの文字の部分。小節数が被っている可能性があるので、塗り潰す
                g.setColor( new Color( picturePositionIndicator.BackColor ) );
                g.fillRect( 2, 3, AppManager.keyWidth - 2, 45 );
                // 横ライン上
                g.setColor( new Color( 104, 104, 104 ) );
                g.drawLine( 2, 17, width - 3, 17 );
                // 横ライン中央
                g.drawLine( 2, 32, width - 3, 32 );
                // 横ライン下
                g.drawLine( 2, 47, width - 3, 47 );
                // 縦ライン
                g.drawLine( AppManager.keyWidth, 2, AppManager.keyWidth, 46 );
                /* TEMPO&BEATとピアノロールの境界 */
                g.drawLine( AppManager.keyWidth, 48, width - 18, 48 );
                g.setFont( SMALL_FONT );
                g.setColor( Color.black );
                g.drawString( "TEMPO", 11, 20 );
                g.drawString( "BEAT", 11, 35 );
                g.setColor( new Color( 172, 168, 153 ) );
                g.drawLine( 0, 0, width, 0 );
                g.setColor( new Color( 113, 111, 100 ) );
                g.drawLine( 1, 1, width - 1, 1 );

                #endregion
            } catch ( Exception ex ) {
            } finally {
#if !JAVA
                if ( SMALL_FONT != null && SMALL_FONT.font != null ) {
                    SMALL_FONT.font.Dispose();
                }
#endif
            }
        }

        private void menuTrackManager_Click( Object sender, BEventArgs e ) {

        }

        private void pictKeyLengthSplitter_MouseDown( object sender, MouseEventArgs e ) {
            m_key_length_splitter_mouse_downed = true;
            m_key_length_splitter_initial_mouse = PortUtil.getMousePosition();
            m_key_length_init_value = AppManager.keyWidth;
            m_key_length_trackselector_rowspercolumn = trackSelector.getRowsPerColumn();
            m_key_length_splitter_distance = splitContainer1.SplitterDistance;
        }

        private void pictKeyLengthSplitter_MouseMove( object sender, MouseEventArgs e ) {
            if ( !m_key_length_splitter_mouse_downed ) {
                return;
            }
            int dx = PortUtil.getMousePosition().x - m_key_length_splitter_initial_mouse.x;
            int draft = m_key_length_init_value + dx;
            if ( draft < AppManager.MIN_KEY_WIDTH ) {
                draft = AppManager.MIN_KEY_WIDTH;
            } else if ( AppManager.MAX_KEY_WIDTH < draft ) {
                draft = AppManager.MAX_KEY_WIDTH;
            }
            AppManager.keyWidth = draft;
            int current = trackSelector.getRowsPerColumn();
            if ( current >= m_key_length_trackselector_rowspercolumn ) {
                int max_divider_location = splitContainer1.Height - splitContainer1.SplitterWidth - splitContainer1.Panel2MinSize;
                if ( max_divider_location < m_key_length_splitter_distance ) {
                    splitContainer1.SplitterDistance = max_divider_location;
                } else {
                    splitContainer1.SplitterDistance = m_key_length_splitter_distance;
                }
            }
            updateLayout();
            refreshScreen();
        }

        private void pictKeyLengthSplitter_MouseUp( object sender, MouseEventArgs e ) {
            m_key_length_splitter_mouse_downed = false;
        }

        private void overviewCommon_MouseLeave( object sender, EventArgs e ) {
#if DEBUG
            PortUtil.println( "FormMain#overviewCommon_MouseLeave" );
#endif
            overviewStopThread();
        }

        private void overviewStopThread() {
            if ( m_overview_update_thread != null ) {
                try {
                    m_overview_update_thread.Abort();
                    while ( m_overview_update_thread != null && m_overview_update_thread.IsAlive ) {
                        Application.DoEvents();
                    }
                } catch ( Exception ex ) {
                }
                m_overview_update_thread = null;
            }
        }

#if JAVA
        #region UI Impl for Java
        private JMenuBar menuStripMain;
        private JMenu menuFile;
        private JMenu menuEdit;
        private JMenu menuVisual;
        private JMenu menuJob;
        private JMenu menuTrack;
        private JMenu menuLyric;
        private JMenu menuSetting;
        private JMenu menuHelp;
        private JCheckBoxMenuItem menuVisualControlTrack;
        private JCheckBoxMenuItem menuVisualMixer;
        private JCheckBoxMenuItem menuVisualGridline;
        private JCheckBoxMenuItem menuVisualStartMarker;
        private JCheckBoxMenuItem menuVisualEndMarker;
        private JCheckBoxMenuItem menuVisualLyrics;
        private JCheckBoxMenuItem menuVisualNoteProperty;
        private BMenuItem menuSettingPreference;
        private BMenuItem menuSettingDefaultSingerStyle;
        private JMenu menuSettingPositionQuantize;
        private JCheckBoxMenuItem menuSettingPositionQuantize04;
        private JCheckBoxMenuItem menuSettingPositionQuantize08;
        private JCheckBoxMenuItem menuSettingPositionQuantize16;
        private JCheckBoxMenuItem menuSettingPositionQuantize32;
        private JCheckBoxMenuItem menuSettingPositionQuantize64;
        private JCheckBoxMenuItem menuSettingPositionQuantizeOff;
        private BMenuItem menuSettingSingerProperty;
        private JCheckBoxMenuItem menuSettingPositionQuantizeTriplet;
        private JMenu menuSettingLengthQuantize;
        private JCheckBoxMenuItem menuSettingLengthQuantize04;
        private JCheckBoxMenuItem menuSettingLengthQuantize08;
        private JCheckBoxMenuItem menuSettingLengthQuantize16;
        private JCheckBoxMenuItem menuSettingLengthQuantize32;
        private JCheckBoxMenuItem menuSettingLengthQuantize64;
        private JCheckBoxMenuItem menuSettingLengthQuantizeOff;
        private JCheckBoxMenuItem menuSettingLengthQuantizeTriplet;
        private BMenuItem menuFileNew;
        private BMenuItem menuFileOpen;
        private BMenuItem menuFileSave;
        private BMenuItem menuFileSaveNamed;
        private JMenu menuFileImport;
        private JMenu menuFileExport;
        private BMenuItem menuFileQuit;
        private BMenuItem menuEditUndo;
        private BMenuItem menuEditRedo;
        private JPanel pictureBox2;
        private JPanel pictureBox3;
        private JPanel picturePositionIndicator;
        /*private System.Windows.Forms.SaveFileDialog saveXmlVsqDialog;
        private System.Windows.Forms.ContextMenuStrip cMenuPiano;
        private JMenu cMenuPianoPointer;
        private JMenu cMenuPianoPencil;
        private JMenu cMenuPianoEraser;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem13;
        private JMenu cMenuPianoFixed;
        private JMenu cMenuPianoQuantize;
        private JMenu cMenuPianoLength;
        private JMenu cMenuPianoGrid;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem14;
        private JMenu cMenuPianoUndo;
        private JMenu cMenuPianoRedo;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem15;
        private JMenu cMenuPianoCut;
        private JMenu cMenuPianoFixed01;
        private JMenu cMenuPianoFixed02;
        private JMenu cMenuPianoFixed04;
        private JMenu cMenuPianoFixed08;
        private JMenu cMenuPianoFixed16;
        private JMenu cMenuPianoFixed32;
        private JMenu cMenuPianoFixed64;
        private JMenu cMenuPianoFixedOff;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem18;
        private JMenu cMenuPianoFixedTriplet;
        private JMenu cMenuPianoFixedDotted;
        private JMenu cMenuPianoCopy;
        private JMenu cMenuPianoPaste;
        private JMenu cMenuPianoDelete;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem16;
        private JMenu cMenuPianoSelectAll;
        private JMenu cMenuPianoSelectAllEvents;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem17;
        private JMenu cMenuPianoImportLyric;
        private JMenu cMenuPianoExpressionProperty;
        private JMenu cMenuPianoQuantize04;
        private JMenu cMenuPianoQuantize08;
        private JMenu cMenuPianoQuantize16;
        private JMenu cMenuPianoQuantize32;
        private JMenu cMenuPianoQuantize64;
        private JMenu cMenuPianoQuantizeOff;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem26;
        private JMenu cMenuPianoQuantizeTriplet;
        private JMenu cMenuPianoLength04;
        private JMenu cMenuPianoLength08;
        private JMenu cMenuPianoLength16;
        private JMenu cMenuPianoLength32;
        private JMenu cMenuPianoLength64;
        private JMenu cMenuPianoLengthOff;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem32;
        private JMenu cMenuPianoLengthTriplet;*/
        private JMenu menuFileRecent;
        //private System.Windows.Forms.ToolTip toolTip;
        //private System.Windows.Forms.OpenFileDialog openXmlVsqDialog;
        private BMenuItem menuEditCut;
        private BMenuItem menuEditCopy;
        private BMenuItem menuEditPaste;
        private BMenuItem menuEditDelete;
        private BMenuItem menuEditAutoNormalizeMode;
        private BMenuItem menuEditSelectAll;
        private BMenuItem menuEditSelectAllEvents;
        public PictPianoRoll pictPianoRoll;
        private JCheckBoxMenuItem menuTrackOn;
        private BMenuItem menuTrackAdd;
        private BMenuItem menuTrackCopy;
        private BMenuItem menuTrackChangeName;
        private BMenuItem menuTrackDelete;
        private BMenuItem menuTrackRenderCurrent;
        private BMenuItem menuTrackRenderAll;
        private JCheckBoxMenuItem menuTrackOverlay;
        /*private JMenu cMenuTrackTabTrackOn;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem24;
        private JMenu cMenuTrackTabAdd;
        private JMenu cMenuTrackTabCopy;
        private JMenu cMenuTrackTabChangeName;
        private JMenu cMenuTrackTabDelete;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem25;
        private JMenu cMenuTrackTabRenderCurrent;
        private JMenu cMenuTrackTabRenderAll;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem27;
        private JMenu cMenuTrackTabOverlay;
        private System.Windows.Forms.ContextMenuStrip cMenuTrackSelector;
        private JMenu cMenuTrackSelectorPointer;
        private JMenu cMenuTrackSelectorPencil;
        private JMenu cMenuTrackSelectorLine;
        private JMenu cMenuTrackSelectorEraser;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem28;
        private JMenu cMenuTrackSelectorUndo;
        private JMenu cMenuTrackSelectorRedo;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem29;
        private JMenu cMenuTrackSelectorCut;
        private JMenu cMenuTrackSelectorCopy;
        private JMenu cMenuTrackSelectorPaste;
        private JMenu cMenuTrackSelectorDelete;
        private System.Windows.Forms.ToolStripSeparator toolStripMenuItem31;
        private JMenu cMenuTrackSelectorSelectAll;*/
        private BMenuItem menuJobNormalize;
        private BMenuItem menuJobInsertBar;
        private BMenuItem menuJobDeleteBar;
        private BMenuItem menuJobRandomize;
        private BMenuItem menuJobConnect;
        private BMenuItem menuJobLyric;
        private BMenuItem menuJobRewire;
        private BMenuItem menuLyricExpressionProperty;
        private BMenuItem menuLyricSymbol;
        private BMenuItem menuLyricDictionary;
        private BMenuItem menuHelpAbout;
        private BMenuItem menuHelpDebug;
        private BMenuItem menuFileExportWave;
        private BMenuItem menuFileExportMidi;
        private JMenu menuScript;
        private JMenu menuHidden;
        /*private JMenu menuHiddenEditLyric;
        private JMenu menuHiddenEditFlipToolPointerPencil;
        private JMenu menuHiddenEditFlipToolPointerEraser;
        private JMenu menuHiddenVisualForwardParameter;
        private JMenu menuHiddenVisualBackwardParameter;
        private JMenu menuHiddenTrackNext;
        private JMenu menuHiddenTrackBack;*/
        private BMenuItem menuJobReloadVsti;
        //private JMenu cMenuPianoCurve;
        //private JMenu cMenuTrackSelectorCurve;
        private JSplitPane splitContainer1;
        private JSlider trackBar;
        //private System.ComponentModel.BackgroundWorker bgWorkScreen;
        private JPanel panel1;
        private JToolBar toolStripTool;
        private JToggleButton stripBtnPointer;
        private BorderLayout toolStripContainer;
        private JToggleButton stripBtnLine;
        private JToggleButton stripBtnPencil;
        private JToggleButton stripBtnEraser;
        private JToggleButton stripBtnGrid;
        private JToggleButton stripBtnCurve;
        private JToolBar toolStripPosition;
        private JButton stripBtnMoveTop;
        private JButton stripBtnRewind;
        private JButton stripBtnForward;
        private JButton stripBtnMoveEnd;
        private JButton stripBtnPlay;
        private JButton stripBtnStop;
        private JToggleButton stripBtnScroll;
        private JToggleButton stripBtnLoop;
        /*private System.Windows.Forms.ToolStrip toolStripMeasure;
        private System.Windows.Forms.ToolStripLabel stripLblMeasure;
        private System.Windows.Forms.ToolStripSeparator toolStripButton1;
        private System.Windows.Forms.ToolStripDropDownButton stripDDBtnLength;
        private JMenu stripDDBtnLength04;
        private JMenu stripDDBtnLength08;
        private JMenu stripDDBtnLength16;
        private JMenu stripDDBtnLength32;
        private JMenu stripDDBtnLength64;
        private JMenu stripDDBtnLengthOff;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator2;
        private JMenu stripDDBtnLengthTriplet;
        private System.Windows.Forms.ToolStripDropDownButton stripDDBtnQuantize;
        private JMenu stripDDBtnQuantize04;
        private JMenu stripDDBtnQuantize08;
        private JMenu stripDDBtnQuantize16;
        private JMenu stripDDBtnQuantize32;
        private JMenu stripDDBtnQuantize64;
        private JMenu stripDDBtnQuantizeOff;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator3;
        private JMenu stripDDBtnQuantizeTriplet;
        private System.Windows.Forms.ToolStripLabel toolStripLabel5;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator5;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator6;
        private System.Windows.Forms.ToolStripButton stripBtnStartMarker;
        private System.Windows.Forms.ToolStripButton stripBtnEndMarker;*/
        private JScrollBar hScroll;
        private JScrollBar vScroll;
        private BMenuItem menuLyricVibratoProperty;
        //private JMenu cMenuPianoVibratoProperty;
        /*private System.Windows.Forms.ToolStripSeparator toolStripSeparator7;
        private System.Windows.Forms.StatusStrip statusStrip1;
        private System.Windows.Forms.ToolStripLabel toolStripLabel6;
        private System.Windows.Forms.ToolStripLabel stripLblCursor;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator8;
        private System.Windows.Forms.ToolStripLabel toolStripLabel8;
        private System.Windows.Forms.ToolStripLabel stripLblTempo;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator9;
        private System.Windows.Forms.ToolStripLabel toolStripLabel10;
        private System.Windows.Forms.ToolStripLabel stripLblBeat;*/
        private BMenuItem menuScriptUpdate;
        private JMenu menuSettingGameControler;
        /*private System.Windows.Forms.ToolStripSeparator toolStripSeparator4;
        private System.Windows.Forms.ToolStripStatusLabel stripLblGameCtrlMode;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator10;
        private System.Windows.Forms.ToolStripDropDownButton stripDDBtnSpeed;*/
        private BMenuItem menuSettingGameControlerSetting;
        private BMenuItem menuSettingGameControlerLoad;
        //private JMenu stripDDBtnLength128;
        //private JMenu stripDDBtnQuantize128;
        private JCheckBoxMenuItem menuSettingPositionQuantize128;
        private JCheckBoxMenuItem menuSettingLengthQuantize128;
        //private JMenu cMenuPianoQuantize128;
        //private JMenu cMenuPianoLength128;
        //private JMenu cMenuPianoFixed128;
        /*private System.Windows.Forms.Timer timer;
        private WaveView waveView;*/
        private JCheckBoxMenuItem menuVisualWaveform;
        private JSplitPane splitContainer2;
       /* private System.Windows.Forms.Panel panel2;
        private JMenu cMenuTrackSelectorDeleteBezier;
        private System.Windows.Forms.OpenFileDialog openUstDialog;
        private System.Windows.Forms.ToolStripStatusLabel stripLblMidiIn;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator11;*/
        private BMenuItem menuJobRealTime;
        /*private JMenu cMenuTrackTabRenderer;
        private JMenu cMenuTrackTabRendererVOCALOID1;
        private JMenu cMenuTrackTabRendererVOCALOID2;
        private JMenu cMenuTrackTabRendererUtau;*/
        private JCheckBoxMenuItem menuVisualPitchLine;
        /*private System.Windows.Forms.OpenFileDialog openMidiDialog;
        private System.Windows.Forms.SaveFileDialog saveMidiDialog;*/
        private BMenuItem menuFileImportMidi;
        /*private System.Windows.Forms.ToolStrip toolStripFile;
        private System.Windows.Forms.ToolStripStatusLabel toolStripStatusLabel1;
        private System.Windows.Forms.ToolStripStatusLabel toolStripStatusLabel2;
        private System.Windows.Forms.ToolStripButton stripBtnFileSave;
        private System.Windows.Forms.ToolStripButton stripBtnFileOpen;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator12;
        private System.Windows.Forms.ToolStripButton stripBtnCut;
        private System.Windows.Forms.ToolStripButton stripBtnCopy;
        private System.Windows.Forms.ToolStripButton stripBtnPaste;
        private System.Windows.Forms.ToolStripButton stripBtnFileNew;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator13;
        private System.Windows.Forms.ToolStripButton stripBtnUndo;
        private System.Windows.Forms.ToolStripButton stripBtnRedo;
        private System.Windows.Forms.ToolStrip toolStripPaletteTools;
        private JMenu cMenuTrackSelectorPaletteTool;
        private JMenu cMenuPianoPaletteTool;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator14;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator15;*/
        private BMenuItem menuSettingPaletteTool;
        private BMenuItem menuTrackMasterTuning;
        //private JMenu cMenuTrackTabMasterTuning;
        private JMenu menuTrackRenderer;
        private JCheckBoxMenuItem menuTrackRendererVOCALOID1;
        private JCheckBoxMenuItem menuTrackRendererVOCALOID2;
        private JCheckBoxMenuItem menuTrackRendererUtau;
        private BMenuItem menuFileImportVsq;
        private BMenuItem menuSettingShortcut;
        /*private System.Windows.Forms.ToolStripTextBox stripDDBtnSpeedTextbox;
        private JMenu stripDDBtnSpeed033;
        private JMenu stripDDBtnSpeed050;
        private JMenu stripDDBtnSpeed100;*/
        private BMenuItem menuSettingMidi;
        private JCheckBoxMenuItem menuVisualProperty;
        private BMenuItem menuFileOpenVsq;
        private BMenuItem menuFileOpenUst;
        private BMenuItem menuSettingGameControlerRemove;
        /*private JMenu menuHiddenCopy;
        private JMenu menuHiddenPaste;
        private JMenu menuHiddenCut;*/
        private BMenuItem menuSettingUtauVoiceDB;
        //private System.Windows.Forms.ToolStrip toolStripBottom;
        private JLabel statusLabel;

        private void initialize() {
            menuStripMain = new JMenuBar();
            menuFile = new JMenu();
            menuFileNew = new BMenuItem();
            menuFileOpen = new BMenuItem();
            menuFileSave = new BMenuItem();
            menuFileSaveNamed = new BMenuItem();
            menuFileOpenVsq = new BMenuItem();
            menuFileOpenUst = new BMenuItem();
            menuFileImport = new JMenu();
            menuFileImportVsq = new BMenuItem();
            menuFileImportMidi = new BMenuItem();
            menuFileExport = new JMenu();
            menuFileExportWave = new BMenuItem();
            menuFileExportMidi = new BMenuItem();
            menuFileRecent = new JMenu();
            menuFileQuit = new BMenuItem();
            menuEdit = new JMenu();
            menuEditUndo = new BMenuItem();
            menuEditRedo = new BMenuItem();
            menuEditCut = new BMenuItem();
            menuEditCopy = new BMenuItem();
            menuEditPaste = new BMenuItem();
            menuEditDelete = new BMenuItem();
            menuEditAutoNormalizeMode = new BMenuItem();
            menuEditSelectAll = new BMenuItem();
            menuEditSelectAllEvents = new BMenuItem();
            menuVisual = new JMenu();
            menuVisualControlTrack = new JCheckBoxMenuItem();
            menuVisualMixer = new JCheckBoxMenuItem();
            menuVisualWaveform = new JCheckBoxMenuItem();
            menuVisualProperty = new JCheckBoxMenuItem();
            menuVisualGridline = new JCheckBoxMenuItem();
            menuVisualStartMarker = new JCheckBoxMenuItem();
            menuVisualEndMarker = new JCheckBoxMenuItem();
            menuVisualLyrics = new JCheckBoxMenuItem();
            menuVisualNoteProperty = new JCheckBoxMenuItem();
            menuVisualPitchLine = new JCheckBoxMenuItem();
            menuJob = new JMenu();
            menuJobNormalize = new BMenuItem();
            menuJobInsertBar = new BMenuItem();
            menuJobDeleteBar = new BMenuItem();
            menuJobRandomize = new BMenuItem();
            menuJobConnect = new BMenuItem();
            menuJobLyric = new BMenuItem();
            menuJobRewire = new BMenuItem();
            menuJobRealTime = new BMenuItem();
            menuJobReloadVsti = new BMenuItem();
            menuTrack = new JMenu();
            menuTrackOn = new JCheckBoxMenuItem();
            menuTrackAdd = new BMenuItem();
            menuTrackCopy = new BMenuItem();
            menuTrackChangeName = new BMenuItem();
            menuTrackDelete = new BMenuItem();
            menuTrackRenderCurrent = new BMenuItem();
            menuTrackRenderAll = new BMenuItem();
            menuTrackOverlay = new JCheckBoxMenuItem();
            menuTrackRenderer = new JMenu();
            menuTrackRendererVOCALOID1 = new JCheckBoxMenuItem();
            menuTrackRendererVOCALOID2 = new JCheckBoxMenuItem();
            menuTrackRendererUtau = new JCheckBoxMenuItem();
            menuTrackMasterTuning = new BMenuItem();
            menuLyric = new JMenu();
            menuLyricExpressionProperty = new BMenuItem();
            menuLyricVibratoProperty = new BMenuItem();
            menuLyricSymbol = new BMenuItem();
            menuLyricDictionary = new BMenuItem();
            menuScript = new JMenu();
            menuScriptUpdate = new BMenuItem();
            menuSetting = new JMenu();
            menuSettingPreference = new BMenuItem();
            menuSettingGameControler = new JMenu();
            menuSettingGameControlerSetting = new BMenuItem();
            menuSettingGameControlerLoad = new BMenuItem();
            menuSettingGameControlerRemove = new BMenuItem();
            menuSettingPaletteTool = new BMenuItem();
            menuSettingShortcut = new BMenuItem();
            menuSettingMidi = new BMenuItem();
            menuSettingUtauVoiceDB = new BMenuItem();
            menuSettingDefaultSingerStyle = new BMenuItem();
            menuSettingPositionQuantize = new JMenu();
            menuSettingPositionQuantize04 = new JCheckBoxMenuItem();
            menuSettingPositionQuantize08 = new JCheckBoxMenuItem();
            menuSettingPositionQuantize16 = new JCheckBoxMenuItem();
            menuSettingPositionQuantize32 = new JCheckBoxMenuItem();
            menuSettingPositionQuantize64 = new JCheckBoxMenuItem();
            menuSettingPositionQuantize128 = new JCheckBoxMenuItem();
            menuSettingPositionQuantizeOff = new JCheckBoxMenuItem();
            menuSettingPositionQuantizeTriplet = new JCheckBoxMenuItem();
            menuSettingLengthQuantize = new JMenu();
            menuSettingLengthQuantize04 = new JCheckBoxMenuItem();
            menuSettingLengthQuantize08 = new JCheckBoxMenuItem();
            menuSettingLengthQuantize16 = new JCheckBoxMenuItem();
            menuSettingLengthQuantize32 = new JCheckBoxMenuItem();
            menuSettingLengthQuantize64 = new JCheckBoxMenuItem();
            menuSettingLengthQuantize128 = new JCheckBoxMenuItem();
            menuSettingLengthQuantizeOff = new JCheckBoxMenuItem();
            menuSettingLengthQuantizeTriplet = new JCheckBoxMenuItem();
            menuSettingSingerProperty = new BMenuItem();
            menuHelp = new JMenu();
            menuHelpAbout = new BMenuItem();
            menuHelpDebug = new BMenuItem();
            menuHidden = new JMenu();
            /*menuHiddenEditLyric = new JMenu();
            menuHiddenEditFlipToolPointerPencil = new JMenu();
            menuHiddenEditFlipToolPointerEraser = new JMenu();
            menuHiddenVisualForwardParameter = new JMenu();
            menuHiddenVisualBackwardParameter = new JMenu();
            menuHiddenTrackNext = new JMenu();
            menuHiddenTrackBack = new JMenu();
            menuHiddenCopy = new JMenu();
            menuHiddenPaste = new JMenu();
            menuHiddenCut = new JMenu();
            saveXmlVsqDialog = new System.Windows.Forms.SaveFileDialog();
            cMenuPiano = new System.Windows.Forms.ContextMenuStrip( components );
            cMenuPianoPointer = new JMenu();
            cMenuPianoPencil = new JMenu();
            cMenuPianoEraser = new JMenu();
            cMenuPianoPaletteTool = new JMenu();
            toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoCurve = new JMenu();
            toolStripMenuItem13 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoFixed = new JMenu();
            cMenuPianoFixed01 = new JMenu();
            cMenuPianoFixed02 = new JMenu();
            cMenuPianoFixed04 = new JMenu();
            cMenuPianoFixed08 = new JMenu();
            cMenuPianoFixed16 = new JMenu();
            cMenuPianoFixed32 = new JMenu();
            cMenuPianoFixed64 = new JMenu();
            cMenuPianoFixed128 = new JMenu();
            cMenuPianoFixedOff = new JMenu();
            toolStripMenuItem18 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoFixedTriplet = new JMenu();
            cMenuPianoFixedDotted = new JMenu();
            cMenuPianoQuantize = new JMenu();
            cMenuPianoQuantize04 = new JMenu();
            cMenuPianoQuantize08 = new JMenu();
            cMenuPianoQuantize16 = new JMenu();
            cMenuPianoQuantize32 = new JMenu();
            cMenuPianoQuantize64 = new JMenu();
            cMenuPianoQuantize128 = new JMenu();
            cMenuPianoQuantizeOff = new JMenu();
            toolStripMenuItem26 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoQuantizeTriplet = new JMenu();
            cMenuPianoLength = new JMenu();
            cMenuPianoLength04 = new JMenu();
            cMenuPianoLength08 = new JMenu();
            cMenuPianoLength16 = new JMenu();
            cMenuPianoLength32 = new JMenu();
            cMenuPianoLength64 = new JMenu();
            cMenuPianoLength128 = new JMenu();
            cMenuPianoLengthOff = new JMenu();
            toolStripMenuItem32 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoLengthTriplet = new JMenu();
            cMenuPianoGrid = new JMenu();
            toolStripMenuItem14 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoUndo = new JMenu();
            cMenuPianoRedo = new JMenu();
            toolStripMenuItem15 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoCut = new JMenu();
            cMenuPianoCopy = new JMenu();
            cMenuPianoPaste = new JMenu();
            cMenuPianoDelete = new JMenu();
            toolStripMenuItem16 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoSelectAll = new JMenu();
            cMenuPianoSelectAllEvents = new JMenu();
            toolStripMenuItem17 = new System.Windows.Forms.ToolStripSeparator();
            cMenuPianoImportLyric = new JMenu();
            cMenuPianoExpressionProperty = new JMenu();
            cMenuPianoVibratoProperty = new JMenu();
            toolTip = new System.Windows.Forms.ToolTip( components );
            openXmlVsqDialog = new System.Windows.Forms.OpenFileDialog();
            cMenuTrackTab = new System.Windows.Forms.ContextMenuStrip( components );
            cMenuTrackTabTrackOn = new JMenu();
            toolStripMenuItem24 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackTabAdd = new JMenu();
            cMenuTrackTabCopy = new JMenu();
            cMenuTrackTabChangeName = new JMenu();
            cMenuTrackTabDelete = new JMenu();
            toolStripMenuItem25 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackTabRenderCurrent = new JMenu();
            cMenuTrackTabRenderAll = new JMenu();
            toolStripMenuItem27 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackTabOverlay = new JMenu();
            cMenuTrackTabRenderer = new JMenu();
            cMenuTrackTabRendererVOCALOID1 = new JMenu();
            cMenuTrackTabRendererVOCALOID2 = new JMenu();
            cMenuTrackTabRendererUtau = new JMenu();
            cMenuTrackTabMasterTuning = new JMenu();
            cMenuTrackSelector = new System.Windows.Forms.ContextMenuStrip( components );
            cMenuTrackSelectorPointer = new JMenu();
            cMenuTrackSelectorPencil = new JMenu();
            cMenuTrackSelectorLine = new JMenu();
            cMenuTrackSelectorEraser = new JMenu();
            cMenuTrackSelectorPaletteTool = new JMenu();
            toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackSelectorCurve = new JMenu();
            toolStripMenuItem28 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackSelectorUndo = new JMenu();
            cMenuTrackSelectorRedo = new JMenu();
            toolStripMenuItem29 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackSelectorCut = new JMenu();
            cMenuTrackSelectorCopy = new JMenu();
            cMenuTrackSelectorPaste = new JMenu();
            cMenuTrackSelectorDelete = new JMenu();
            cMenuTrackSelectorDeleteBezier = new JMenu();
            toolStripMenuItem31 = new System.Windows.Forms.ToolStripSeparator();
            cMenuTrackSelectorSelectAll = new JMenu();*/
            trackBar = new JSlider();
            /*bgWorkScreen = new System.ComponentModel.BackgroundWorker();
            timer = new System.Windows.Forms.Timer( components );*/
            panel1 = new JPanel();
            vScroll = new JScrollBar();
            hScroll = new JScrollBar();
            picturePositionIndicator = new JPanel();
            pictPianoRoll = new PictPianoRoll();
            pictureBox3 = new JPanel();
            pictureBox2 = new JPanel();
            toolStripTool = new JToolBar();
            stripBtnPointer = new JToggleButton();
            stripBtnPencil = new JToggleButton();
            stripBtnLine = new JToggleButton();
            stripBtnEraser = new JToggleButton();
            stripBtnGrid = new JToggleButton();
            stripBtnCurve = new JToggleButton();
            toolStripContainer = new BorderLayout();
            /*toolStripBottom = new System.Windows.Forms.ToolStrip();
            toolStripLabel6 = new System.Windows.Forms.ToolStripLabel();
            stripLblCursor = new System.Windows.Forms.ToolStripLabel();
            toolStripSeparator8 = new System.Windows.Forms.ToolStripSeparator();
            toolStripLabel8 = new System.Windows.Forms.ToolStripLabel();
            stripLblTempo = new System.Windows.Forms.ToolStripLabel();
            toolStripSeparator9 = new System.Windows.Forms.ToolStripSeparator();
            toolStripLabel10 = new System.Windows.Forms.ToolStripLabel();
            stripLblBeat = new System.Windows.Forms.ToolStripLabel();
            toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            toolStripStatusLabel1 = new System.Windows.Forms.ToolStripStatusLabel();
            stripLblGameCtrlMode = new System.Windows.Forms.ToolStripStatusLabel();
            toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            toolStripStatusLabel2 = new System.Windows.Forms.ToolStripStatusLabel();
            stripLblMidiIn = new System.Windows.Forms.ToolStripStatusLabel();
            toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            stripDDBtnSpeed = new System.Windows.Forms.ToolStripDropDownButton();
            stripDDBtnSpeedTextbox = new System.Windows.Forms.ToolStripTextBox();
            stripDDBtnSpeed033 = new JMenu();
            stripDDBtnSpeed050 = new JMenu();
            stripDDBtnSpeed100 = new JMenu();
            statusStrip1 = new System.Windows.Forms.StatusStrip();*/
            statusLabel = new JLabel();
            //panel2 = new System.Windows.Forms.Panel();
            //waveView = new Boare.Cadencii.WaveView();
            splitContainer2 = new JSplitPane( JSplitPane.VERTICAL_SPLIT );
            splitContainer1 = new JSplitPane( JSplitPane.VERTICAL_SPLIT );
            toolStripPosition = new JToolBar();
            stripBtnMoveTop = new JButton();
            stripBtnRewind = new JButton();
            stripBtnForward = new JButton();
            stripBtnMoveEnd = new JButton();
            stripBtnPlay = new JButton();
            stripBtnStop = new JButton();
            //toolStripSeparator7 = new System.Windows.Forms.ToolStripSeparator();
            stripBtnScroll = new JToggleButton();
            stripBtnLoop = new JToggleButton();
            /*toolStripMeasure = new System.Windows.Forms.ToolStrip();
            toolStripLabel5 = new System.Windows.Forms.ToolStripLabel();
            stripLblMeasure = new System.Windows.Forms.ToolStripLabel();
            toolStripButton1 = new System.Windows.Forms.ToolStripSeparator();
            stripDDBtnLength = new System.Windows.Forms.ToolStripDropDownButton();
            stripDDBtnLength04 = new JMenu();
            stripDDBtnLength08 = new JMenu();
            stripDDBtnLength16 = new JMenu();
            stripDDBtnLength32 = new JMenu();
            stripDDBtnLength64 = new JMenu();
            stripDDBtnLength128 = new JMenu();
            stripDDBtnLengthOff = new JMenu();
            toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            stripDDBtnLengthTriplet = new JMenu();
            stripDDBtnQuantize = new System.Windows.Forms.ToolStripDropDownButton();
            stripDDBtnQuantize04 = new JMenu();
            stripDDBtnQuantize08 = new JMenu();
            stripDDBtnQuantize16 = new JMenu();
            stripDDBtnQuantize32 = new JMenu();
            stripDDBtnQuantize64 = new JMenu();
            stripDDBtnQuantize128 = new JMenu();
            stripDDBtnQuantizeOff = new JMenu();
            toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            stripDDBtnQuantizeTriplet = new JMenu();
            toolStripSeparator6 = new System.Windows.Forms.ToolStripSeparator();
            stripBtnStartMarker = new System.Windows.Forms.ToolStripButton();
            stripBtnEndMarker = new System.Windows.Forms.ToolStripButton();
            toolStripFile = new System.Windows.Forms.ToolStrip();
            stripBtnFileNew = new System.Windows.Forms.ToolStripButton();
            stripBtnFileOpen = new System.Windows.Forms.ToolStripButton();
            stripBtnFileSave = new System.Windows.Forms.ToolStripButton();
            toolStripSeparator12 = new System.Windows.Forms.ToolStripSeparator();
            stripBtnCut = new System.Windows.Forms.ToolStripButton();
            stripBtnCopy = new System.Windows.Forms.ToolStripButton();
            stripBtnPaste = new System.Windows.Forms.ToolStripButton();
            toolStripSeparator13 = new System.Windows.Forms.ToolStripSeparator();
            stripBtnUndo = new System.Windows.Forms.ToolStripButton();
            stripBtnRedo = new System.Windows.Forms.ToolStripButton();
            toolStripPaletteTools = new System.Windows.Forms.ToolStrip();
            openUstDialog = new System.Windows.Forms.OpenFileDialog();
            openMidiDialog = new System.Windows.Forms.OpenFileDialog();
            saveMidiDialog = new System.Windows.Forms.SaveFileDialog();
            menuStripMain.SuspendLayout();
            cMenuPiano.SuspendLayout();
            cMenuTrackTab.SuspendLayout();
            cMenuTrackSelector.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(trackBar)).BeginInit();
            panel1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(picturePositionIndicator)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(pictPianoRoll)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(pictureBox3)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(pictureBox2)).BeginInit();
            toolStripTool.SuspendLayout();
            toolStripContainer.BottomToolStripPanel.SuspendLayout();
            toolStripContainer.ContentPanel.SuspendLayout();
            toolStripContainer.TopToolStripPanel.SuspendLayout();
            toolStripContainer.SuspendLayout();
            toolStripBottom.SuspendLayout();
            statusStrip1.SuspendLayout();
            panel2.SuspendLayout();
            toolStripPosition.SuspendLayout();
            toolStripMeasure.SuspendLayout();
            toolStripFile.SuspendLayout();
            SuspendLayout();*/
            // 
            // menuStripMain
            // 
            menuStripMain.add( menuFile );
            menuStripMain.add( menuEdit );
            menuStripMain.add( menuVisual );
            menuStripMain.add( menuJob );
            menuStripMain.add( menuTrack );
            menuStripMain.add( menuLyric );
            menuStripMain.add( menuScript );
            menuStripMain.add( menuSetting );
            menuStripMain.add( menuHelp );
            menuStripMain.add( menuHidden );
            //menuStripMain.Location = new System.Drawing.Point( 0, 0 );
            menuStripMain.setName( "menuStripMain" );
            //menuStripMain.setSize( 962, 26 );
            //menuStripMain.TabIndex = 0;
            //menuStripMain.MouseDown += new System.Windows.Forms.MouseEventHandler( menuStrip1_MouseDown );*/
            // 
            // menuFile
            // 
            menuFile.add( menuFileNew );
            menuFile.add( menuFileOpen );
            menuFile.add( menuFileSave );
            menuFile.add( menuFileSaveNamed );
            menuFile.addSeparator();
            menuFile.add( menuFileOpenVsq );
            menuFile.add( menuFileOpenUst );
            menuFile.add( menuFileImport );
            menuFile.add( menuFileExport );
            menuFile.addSeparator();
            menuFile.add( menuFileRecent );
            menuFile.addSeparator();
            menuFile.add( menuFileQuit );
            menuFile.setName( "menuFile" );
            menuFile.setText( "File(F)" );
            // 
            // menuFileNew
            // 
            menuFileNew.setName( "menuFileNew" );
            menuFileNew.setText( "New(N)" );
            menuFileNew.setActionCommand( "commonFileNew_Click" );
            menuFileNew.addMouseListener( new MenuDescriptionActivator( statusLabel, "Create new project." ) );
            menuFileNew.addActionListener( this );
            // 
            // menuFileOpen
            // 
            menuFileOpen.setName( "menuFileOpen" );
            menuFileOpen.setText( "Open(O)" );
            menuFileOpen.addMouseListener( new MenuDescriptionActivator( statusLabel, "Open Cadencii project." ) );
            menuFileOpen.clickEvent.add( new BEventHandler( this, "commonFileOpen_Click" ) );
          //menuFileOpen.Click += new EventHandler( this.commonFileOpen_Click );
            // 
            // menuFileSave
            // 
            menuFileSave.setName( "menuFileSave" );
            menuFileSave.setText( "Save(S)" );
            menuFileSave.addMouseListener( new MenuDescriptionActivator( statusLabel, "Save current project." ) );
            menuFileSave.setActionCommand( "commonFileSave_Click" );
            menuFileSave.addActionListener( this );
            // 
            // menuFileSaveNamed
            // 
            menuFileSaveNamed.setName( "menuFileSaveNamed" );
            menuFileSaveNamed.setText( "Save As(A)" );
            menuFileSaveNamed.addMouseListener( new MenuDescriptionActivator( statusLabel, "Save current project with new name." ) );
            menuFileSaveNamed.setActionCommand( "menuFileSaveNamed_Click" );
            menuFileSaveNamed.addActionListener( this );
            // 
            // menuFileOpenVsq
            // 
            menuFileOpenVsq.setName( "menuFileOpenVsq" );
            menuFileOpenVsq.setText( "Open VSQ/Vocaloid Midi(V)" );
            menuFileOpenVsq.addMouseListener( new MenuDescriptionActivator( statusLabel, "Open VSQ / VOCALOID MIDI and create new project." ) );
            menuFileOpenVsq.setActionCommand( "menuFileOpenVsq_Click" );
            menuFileOpenVsq.addActionListener( this );
            // 
            // menuFileOpenUst
            // 
            menuFileOpenUst.setName( "menuFileOpenUst" );
            menuFileOpenUst.setText( "Open UTAU Project File(U)" );
            menuFileOpenUst.addMouseListener( new MenuDescriptionActivator( statusLabel, "Open UTAU project and create new project." ) );
            menuFileOpenUst.setActionCommand( "menuFileOpenUst_Click" );
            menuFileOpenUst.addActionListener( this );
            // 
            // menuFileImportVsq
            // 
            menuFileImportVsq.setName( "menuFileImportVsq" );
            menuFileImportVsq.setText( "VSQ File" );
            menuFileImportVsq.addMouseListener( new MenuDescriptionActivator( statusLabel, "Import VSQ / VOCALOID MIDI." ) );
            menuFileImportVsq.setActionCommand( "menuFileImportVsq_Click" );
            menuFileImportVsq.addActionListener( this );
            // 
            // menuFileImportMidi
            // 
            menuFileImportMidi.setName( "menuFileImportMidi" );
            menuFileImportMidi.setText( "Standard MIDI" );
            menuFileImportMidi.addMouseListener( new MenuDescriptionActivator( statusLabel, "Import Standard MIDI." ) );
            menuFileImportMidi.setActionCommand( "menuFileImportMidi_Click" );
            menuFileImportMidi.addActionListener( this );
            // 
            // menuFileImport
            // 
            menuFileImport.add( menuFileImportVsq );
            menuFileImport.add( menuFileImportMidi );
            menuFileImport.setName( "menuFileImport" );
            menuFileImport.setText( "Import(I)" );
            menuFileImport.addMouseListener( new MenuDescriptionActivator( statusLabel, "Import." ) );
            // 
            // menuFileExportWave
            // 
            menuFileExportWave.setName( "menuFileExportWave" );
            menuFileExportWave.setText( "Wave" );
            menuFileExportWave.addMouseListener( new MenuDescriptionActivator( statusLabel, "Export to WAVE file." ) );
            menuFileExportWave.setActionCommand( "menuFileExportWave_Click" );
            menuFileExportWave.addActionListener( this );
            // 
            // menuFileExportMidi
            // 
            menuFileExportMidi.setName( "menuFileExportMidi" );
            menuFileExportMidi.setText( "MIDI" );
            menuFileExportMidi.addMouseListener( new MenuDescriptionActivator( statusLabel, "Export to Standard MIDI." ) );
            menuFileExportMidi.setActionCommand( "menuFileExportMidi_Click" );
            menuFileExportMidi.addActionListener( this );
            // 
            // menuFileExport
            // 
            menuFileExport.add( menuFileExportWave );
            menuFileExport.add( menuFileExportMidi );
            menuFileExport.setName( "menuFileExport" );
            menuFileExport.setText( "Export(E)" );
            menuFileExport.addMouseListener( new MenuDescriptionActivator( statusLabel, "Export." ) );
            // 
            // menuFileRecent
            // 
            menuFileRecent.setName( "menuFileRecent" );
            menuFileRecent.setText( "Recent Files(R)" );
            menuFileRecent.addMouseListener( new MenuDescriptionActivator( statusLabel, "Recent projects." ) );
            // 
            // menuFileQuit
            // 
            menuFileQuit.setName( "menuFileQuit" );
            menuFileQuit.setText( "Quit(Q)" );
            menuFileQuit.addMouseListener( new MenuDescriptionActivator( statusLabel, "Close this window." ) );
            menuFileQuit.setActionCommand( "menuFileQuit_Click" );
            menuFileQuit.addActionListener( this );
            // 
            // menuEdit
            // 
            menuEdit.add( menuEditUndo );
            menuEdit.add( menuEditRedo );
            menuEdit.addSeparator();
            menuEdit.add( menuEditCut );
            menuEdit.add( menuEditCopy );
            menuEdit.add( menuEditPaste );
            menuEdit.add( menuEditDelete );
            menuEdit.addSeparator();
            menuEdit.add( menuEditAutoNormalizeMode );
            menuEdit.addSeparator();
            menuEdit.add( menuEditSelectAll );
            menuEdit.add( menuEditSelectAllEvents );
            menuEdit.setName( "menuEdit" );
            menuEdit.setText( "Edit(E)" );
            //menuEdit.DropDownOpening += new System.EventHandler( menuEdit_DropDownOpening );
            // 
            // menuEditUndo
            // 
            menuEditUndo.setName( "menuEditUndo" );
            //menuEditUndo.setSize( 220, 22 );
            menuEditUndo.setText( "Undo(U)" );
            //menuEditUndo.Click += new System.EventHandler( commonEditUndo_Click );
            // 
            // menuEditRedo
            // 
            menuEditRedo.setName( "menuEditRedo" );
            //menuEditRedo.setSize( 220, 22 );
            menuEditRedo.setText( "Redo(R)" );
            //menuEditRedo.Click += new System.EventHandler( commonEditRedo_Click );
            // 
            // menuEditCut
            // 
            menuEditCut.setName( "menuEditCut" );
            //menuEditCut.setSize( 220, 22 );
            menuEditCut.setText( "Cut(T)" );
            //menuEditCut.Click += new System.EventHandler( commonEditCut_Click );
            // 
            // menuEditCopy
            // 
            menuEditCopy.setName( "menuEditCopy" );
            //menuEditCopy.setSize( 220, 22 );
            menuEditCopy.setText( "Copy(C)" );
            //menuEditCopy.Click += new System.EventHandler( commonEditCopy_Click );
            // 
            // menuEditPaste
            // 
            menuEditPaste.setName( "menuEditPaste" );
            //menuEditPaste.ShortcutKeyDisplayString = "";
            //menuEditPaste.setSize( 220, 22 );
            menuEditPaste.setText( "Paste(P)" );
            //menuEditPaste.Click += new System.EventHandler( commonEditPaste_Click );
            // 
            // menuEditDelete
            // 
            menuEditDelete.setName( "menuEditDelete" );
            //menuEditDelete.ShortcutKeys = System.Windows.Forms.Keys.Delete;
            //menuEditDelete.ShowShortcutKeys = false;
            //menuEditDelete.setSize( 220, 22 );
            menuEditDelete.setText( "Delete(D)" );
            //menuEditDelete.Click += new System.EventHandler( menuEditDelete_Click );
            // 
            // menuEditAutoNormalizeMode
            // 
            menuEditAutoNormalizeMode.setName( "menuEditAutoNormalizeMode" );
            //menuEditAutoNormalizeMode.setSize( 220, 22 );
            menuEditAutoNormalizeMode.setText( "Auto Normalize Mode(N)" );
            //menuEditAutoNormalizeMode.Click += new System.EventHandler( menuEditAutoNormalizeMode_Click );
            // 
            // menuEditSelectAll
            // 
            menuEditSelectAll.setName( "menuEditSelectAll" );
            //menuEditSelectAll.setSize( 220, 22 );
            menuEditSelectAll.setText( "Select All(A)" );
            //menuEditSelectAll.Click += new System.EventHandler( menuEditSelectAll_Click );
            // 
            // menuEditSelectAllEvents
            // 
            menuEditSelectAllEvents.setName( "menuEditSelectAllEvents" );
            //menuEditSelectAllEvents.setSize( 220, 22 );
            menuEditSelectAllEvents.setText( "Select All Events(E)" );
            //menuEditSelectAllEvents.Click += new System.EventHandler( menuEditSelectAllEvents_Click );*/
            // 
            // menuVisual
            // 
            //menuVisual.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisual.add( menuVisualControlTrack );
            menuVisual.add( menuVisualMixer );
            menuVisual.add( menuVisualWaveform );
            menuVisual.add( menuVisualProperty );
            menuVisual.addSeparator();
            menuVisual.add( menuVisualGridline );
            menuVisual.addSeparator();
            menuVisual.add( menuVisualStartMarker );
            menuVisual.add( menuVisualEndMarker );
            menuVisual.addSeparator();
            menuVisual.add( menuVisualLyrics );
            menuVisual.add( menuVisualNoteProperty );
            menuVisual.add( menuVisualPitchLine );
            menuVisual.setName( "menuVisual" );
            //menuVisual.setSize( 66, 22 );
            menuVisual.setText( "View(V)" );
            // 
            // menuVisualControlTrack
            // 
            menuVisualControlTrack.setState( true );
            //menuVisualControlTrack.CheckOnClick = true;
            //menuVisualControlTrack.CheckState = System.Windows.Forms.CheckState.Checked;
            //menuVisualControlTrack.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualControlTrack.setName( "menuVisualControlTrack" );
            //menuVisualControlTrack.Size = new System.Drawing.Size( 237, 22 );
            menuVisualControlTrack.setText( "Control Track(C)" );
            //menuVisualControlTrack.CheckedChanged += new System.EventHandler( menuVisualControlTrack_CheckedChanged );
            // 
            // menuVisualMixer
            // 
            //menuVisualMixer.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualMixer.setName( "menuVisualMixer" );
            //menuVisualMixer.Size = new System.Drawing.Size( 237, 22 );
            menuVisualMixer.setText( "Mixer(X)" );
            //menuVisualMixer.Click += new System.EventHandler( menuVisualMixer_Click );
            // 
            // menuVisualWaveform
            // 
            //menuVisualWaveform.CheckOnClick = true;
            menuVisualWaveform.setState( false );
            menuVisualWaveform.setName( "menuVisualWaveform" );
            //menuVisualWaveform.Size = new System.Drawing.Size( 237, 22 );
            menuVisualWaveform.setText( "Waveform(W)" );
            //menuVisualWaveform.CheckedChanged += new System.EventHandler( menuVisualWaveform_CheckedChanged );
            // 
            // menuVisualProperty
            // 
            //menuVisualProperty.CheckOnClick = true;
            menuVisualProperty.setState( false );
            menuVisualProperty.setName( "menuVisualProperty" );
            //menuVisualProperty.Size = new System.Drawing.Size( 237, 22 );
            menuVisualProperty.setText( "Property Window(C)" );
            //menuVisualProperty.CheckedChanged += new System.EventHandler( menuVisualProperty_CheckedChanged );
            // 
            // menuVisualGridline
            // 
            menuVisualGridline.setState( false );
            //menuVisualGridline.CheckOnClick = true;
            //menuVisualGridline.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualGridline.setName( "menuVisualGridline" );
            //menuVisualGridline.Size = new System.Drawing.Size( 237, 22 );
            menuVisualGridline.setText( "Grid Line(G)" );
            //menuVisualGridline.CheckedChanged += new System.EventHandler( menuVisualGridline_CheckedChanged );
            // 
            // menuVisualStartMarker
            // 
            menuVisualStartMarker.setState( false );
            //menuVisualStartMarker.CheckOnClick = true;
            //menuVisualStartMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualStartMarker.setEnabled( false );
            menuVisualStartMarker.setName( "menuVisualStartMarker" );
            //menuVisualStartMarker.Size = new System.Drawing.Size( 237, 22 );
            menuVisualStartMarker.setText( "Start Marker(S)" );
            // 
            // menuVisualEndMarker
            // 
            menuVisualEndMarker.setState( false );
            //menuVisualEndMarker.CheckOnClick = true;
            //menuVisualEndMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualEndMarker.setEnabled( false );
            menuVisualEndMarker.setName( "menuVisualEndMarker" );
            //menuVisualEndMarker.Size = new System.Drawing.Size( 237, 22 );
            menuVisualEndMarker.setText( "End Marker(E)" );
            // 
            // menuVisualLyrics
            // 
            menuVisualLyrics.setState( true );
            //menuVisualLyrics.CheckOnClick = true;
            //menuVisualLyrics.CheckState = System.Windows.Forms.CheckState.Checked;
            //menuVisualLyrics.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualLyrics.setName( "menuVisualLyrics" );
            //menuVisualLyrics.Size = new System.Drawing.Size( 237, 22 );
            menuVisualLyrics.setText( "Lyric/Phoneme(L)" );
            //menuVisualLyrics.CheckedChanged += new System.EventHandler( menuVisualLyrics_CheckedChanged );
            // 
            // menuVisualNoteProperty
            // 
            menuVisualNoteProperty.setState( true );
            //menuVisualNoteProperty.CheckOnClick = true;
            //menuVisualNoteProperty.CheckState = System.Windows.Forms.CheckState.Checked;
            //menuVisualNoteProperty.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            menuVisualNoteProperty.setName( "menuVisualNoteProperty" );
            //menuVisualNoteProperty.Size = new System.Drawing.Size( 237, 22 );
            menuVisualNoteProperty.setText( "Note Expression/Vibrato(N)" );
            //menuVisualNoteProperty.CheckedChanged += new System.EventHandler( menuVisualNoteProperty_CheckedChanged );
            // 
            // menuVisualPitchLine
            // 
            menuVisualPitchLine.setState( false );
            //menuVisualPitchLine.CheckOnClick = true;
            menuVisualPitchLine.setName( "menuVisualPitchLine" );
            //menuVisualPitchLine.Size = new System.Drawing.Size( 237, 22 );
            menuVisualPitchLine.setText( "Pitch Line(P)" );
            //menuVisualPitchLine.CheckedChanged += new System.EventHandler( menuVisualPitchLine_CheckedChanged );*/
            // 
            // menuJob
            // 
            menuJob.add( menuJobNormalize );
            menuJob.add( menuJobInsertBar );
            menuJob.add( menuJobDeleteBar );
            menuJob.add( menuJobRandomize );
            menuJob.add( menuJobConnect );
            menuJob.add( menuJobLyric );
            menuJob.add( menuJobRewire );
            menuJob.add( menuJobRealTime );
            menuJob.add( menuJobReloadVsti );
            menuJob.setName( "menuJob" );
            //menuJob.setSize( 54, 22 );
            menuJob.setText( "Job(J)" );
            //menuJob.DropDownOpening += new System.EventHandler( menuJob_DropDownOpening );
            // 
            // menuJobNormalize
            // 
            menuJobNormalize.setName( "menuJobNormalize" );
            //menuJobNormalize.Size = new System.Drawing.Size( 256, 22 );
            menuJobNormalize.setText( "Normalize Notes(N)" );
            //menuJobNormalize.Click += new System.EventHandler( menuJobNormalize_Click );
            // 
            // menuJobInsertBar
            // 
            menuJobInsertBar.setName( "menuJobInsertBar" );
            //menuJobInsertBar.Size = new System.Drawing.Size( 256, 22 );
            menuJobInsertBar.setText( "Insert Bars(I)" );
            //menuJobInsertBar.Click += new System.EventHandler( menuJobInsertBar_Click );
            // 
            // menuJobDeleteBar
            // 
            menuJobDeleteBar.setName( "menuJobDeleteBar" );
            //menuJobDeleteBar.Size = new System.Drawing.Size( 256, 22 );
            menuJobDeleteBar.setText( "Delete Bars(D)" );
            //menuJobDeleteBar.Click += new System.EventHandler( menuJobDeleteBar_Click );
            // 
            // menuJobRandomize
            // 
            menuJobRandomize.setEnabled( false );
            menuJobRandomize.setName( "menuJobRandomize" );
            //menuJobRandomize.Size = new System.Drawing.Size( 256, 22 );
            menuJobRandomize.setText( "Randomize(R)" );
            // 
            // menuJobConnect
            // 
            menuJobConnect.setName( "menuJobConnect" );
            //menuJobConnect.Size = new System.Drawing.Size( 256, 22 );
            menuJobConnect.setText( "Connect Notes(C)" );
            //menuJobConnect.Click += new System.EventHandler( menuJobConnect_Click );
            // 
            // menuJobLyric
            // 
            menuJobLyric.setName( "menuJobLyric" );
            //menuJobLyric.Size = new System.Drawing.Size( 256, 22 );
            menuJobLyric.setText( "Insert Lyrics(L)" );
            //menuJobLyric.Click += new System.EventHandler( menuJobLyric_Click );
            // 
            // menuJobRewire
            // 
            menuJobRewire.setEnabled( false );
            menuJobRewire.setName( "menuJobRewire" );
            //menuJobRewire.Size = new System.Drawing.Size( 256, 22 );
            menuJobRewire.setText( "Import ReWire Host Tempo(T)" );
            // 
            // menuJobRealTime
            // 
            menuJobRealTime.setName( "menuJobRealTime" );
            //menuJobRealTime.Size = new System.Drawing.Size( 256, 22 );
            menuJobRealTime.setText( "Start Realtime Input" );
            //menuJobRealTime.Click += new System.EventHandler( menuJobRealTime_Click );
            // 
            // menuJobReloadVsti
            // 
            menuJobReloadVsti.setName( "menuJobReloadVsti" );
            //menuJobReloadVsti.Size = new System.Drawing.Size( 256, 22 );
            menuJobReloadVsti.setText( "Reload VSTi(R)" );
            menuJobReloadVsti.setVisible( false );
            //menuJobReloadVsti.Click += new System.EventHandler( menuJobReloadVsti_Click );*/
            // 
            // menuTrack
            // 
            menuTrack.add( menuTrackOn );
            menuTrack.addSeparator();
            menuTrack.add( menuTrackAdd );
            menuTrack.add( menuTrackCopy );
            menuTrack.add( menuTrackChangeName );
            menuTrack.add( menuTrackDelete );
            menuTrack.addSeparator();
            menuTrack.add( menuTrackRenderCurrent );
            menuTrack.add( menuTrackRenderAll );
            menuTrack.addSeparator();
            menuTrack.add( menuTrackOverlay );
            menuTrack.add( menuTrackRenderer );
            menuTrack.add( menuTrackMasterTuning );
            menuTrack.setName( "menuTrack" );
            //menuTrack.setSize( 70, 22 );
            menuTrack.setText( "Track(T)" );
            //menuTrack.DropDownOpening += new System.EventHandler( menuTrack_DropDownOpening );
            // 
            // menuTrackOn
            // 
            menuTrackOn.setName( "menuTrackOn" );
            //menuTrackOn.Size = new System.Drawing.Size( 219, 22 );
            menuTrackOn.setText( "Track On(K)" );
            //menuTrackOn.Click += new System.EventHandler( menuTrackOn_Click );
            // 
            // menuTrackAdd
            // 
            menuTrackAdd.setName( "menuTrackAdd" );
            //menuTrackAdd.Size = new System.Drawing.Size( 219, 22 );
            menuTrackAdd.setText( "Add Track(A)" );
            //menuTrackAdd.Click += new System.EventHandler( menuTrackAdd_Click );
            // 
            // menuTrackCopy
            // 
            menuTrackCopy.setName( "menuTrackCopy" );
            //menuTrackCopy.Size = new System.Drawing.Size( 219, 22 );
            menuTrackCopy.setText( "Copy Track(C)" );
            //menuTrackCopy.Click += new System.EventHandler( menuTrackCopy_Click );
            // 
            // menuTrackChangeName
            // 
            menuTrackChangeName.setName( "menuTrackChangeName" );
            //menuTrackChangeName.Size = new System.Drawing.Size( 219, 22 );
            menuTrackChangeName.setText( "Rename Track(R)" );
            //menuTrackChangeName.Click += new System.EventHandler( menuTrackChangeName_Click );
            // 
            // menuTrackDelete
            // 
            menuTrackDelete.setName( "menuTrackDelete" );
            //menuTrackDelete.Size = new System.Drawing.Size( 219, 22 );
            menuTrackDelete.setText( "Delete Track(D)" );
            //menuTrackDelete.Click += new System.EventHandler( menuTrackDelete_Click );
            // 
            // menuTrackRenderCurrent
            // 
            menuTrackRenderCurrent.setName( "menuTrackRenderCurrent" );
            //menuTrackRenderCurrent.Size = new System.Drawing.Size( 219, 22 );
            menuTrackRenderCurrent.setText( "Render Current Track(T)" );
            //menuTrackRenderCurrent.Click += new System.EventHandler( menuTrackRenderCurrent_Click );
            // 
            // menuTrackRenderAll
            // 
            menuTrackRenderAll.setEnabled( false );
            menuTrackRenderAll.setName( "menuTrackRenderAll" );
            //menuTrackRenderAll.Size = new System.Drawing.Size( 219, 22 );
            menuTrackRenderAll.setText( "Render All Tracks(S)" );
            // 
            // menuTrackOverlay
            // 
            menuTrackOverlay.setName( "menuTrackOverlay" );
            //menuTrackOverlay.Size = new System.Drawing.Size( 219, 22 );
            menuTrackOverlay.setText( "Overlay(O)" );
            //menuTrackOverlay.Click += new System.EventHandler( menuTrackOverlay_Click );
            // 
            // menuTrackRenderer
            // 
            menuTrackRenderer.add( menuTrackRendererVOCALOID1 );
            menuTrackRenderer.add( menuTrackRendererVOCALOID2 );
            menuTrackRenderer.add( menuTrackRendererUtau );
            menuTrackRenderer.setName( "menuTrackRenderer" );
            //menuTrackRenderer.Size = new System.Drawing.Size( 219, 22 );
            menuTrackRenderer.setText( "Renderer" );
            //menuTrackRenderer.DropDownOpening += new System.EventHandler( menuTrackRenderer_DropDownOpening );
            // 
            // menuTrackRendererVOCALOID1
            // 
            menuTrackRendererVOCALOID1.setName( "menuTrackRendererVOCALOID1" );
            //menuTrackRendererVOCALOID1.Size = new System.Drawing.Size( 146, 22 );
            menuTrackRendererVOCALOID1.setText( "VOCALOID1" );
            //menuTrackRendererVOCALOID1.Click += new System.EventHandler( commonRendererVOCALOID1_Click );
            // 
            // menuTrackRendererVOCALOID2
            // 
            menuTrackRendererVOCALOID2.setName( "menuTrackRendererVOCALOID2" );
            //menuTrackRendererVOCALOID2.Size = new System.Drawing.Size( 146, 22 );
            menuTrackRendererVOCALOID2.setText( "VOCALOID2" );
            //menuTrackRendererVOCALOID2.Click += new System.EventHandler( commonRendererVOCALOID2_Click );
            // 
            // menuTrackRendererUtau
            // 
            menuTrackRendererUtau.setName( "menuTrackRendererUtau" );
            //menuTrackRendererUtau.Size = new System.Drawing.Size( 146, 22 );
            menuTrackRendererUtau.setText( "UTAU" );
            //menuTrackRendererUtau.Click += new System.EventHandler( commonRendererUtau_Click );
            // 
            // menuTrackMasterTuning
            // 
            menuTrackMasterTuning.setName( "menuTrackMasterTuning" );
            //menuTrackMasterTuning.Size = new System.Drawing.Size( 219, 22 );
            menuTrackMasterTuning.setText( "Master Tuning(M)" );
            //menuTrackMasterTuning.Click += new System.EventHandler( commonMasterTuning_Click );*/
            // 
            // menuLyric
            // 
            menuLyric.add( menuLyricExpressionProperty );
            menuLyric.add( menuLyricVibratoProperty );
            menuLyric.add( menuLyricSymbol );
            menuLyric.add( menuLyricDictionary );
            menuLyric.setName( "menuLyric" );
            //menuLyric.setSize( 70, 22 );
            menuLyric.setText( "Lyrics(L)" );
            //menuLyric.DropDownOpening += new System.EventHandler( menuLyric_DropDownOpening );
            // 
            // menuLyricExpressionProperty
            // 
            menuLyricExpressionProperty.setName( "menuLyricExpressionProperty" );
            //menuLyricExpressionProperty.Size = new System.Drawing.Size( 241, 22 );
            menuLyricExpressionProperty.setText( "Note Expression Property(E)" );
            //menuLyricExpressionProperty.Click += new System.EventHandler( menuLyricExpressionProperty_Click );
            // 
            // menuLyricVibratoProperty
            // 
            menuLyricVibratoProperty.setName( "menuLyricVibratoProperty" );
            //menuLyricVibratoProperty.Size = new System.Drawing.Size( 241, 22 );
            menuLyricVibratoProperty.setText( "Note Vibrato Property(V)" );
            //menuLyricVibratoProperty.Click += new System.EventHandler( menuLyricVibratoProperty_Click );
            // 
            // menuLyricSymbol
            // 
            menuLyricSymbol.setEnabled( false );
            menuLyricSymbol.setName( "menuLyricSymbol" );
            //menuLyricSymbol.Size = new System.Drawing.Size( 241, 22 );
            menuLyricSymbol.setText( "Phoneme Transformation(T)" );
            // 
            // menuLyricDictionary
            // 
            menuLyricDictionary.setName( "menuLyricDictionary" );
            //menuLyricDictionary.Size = new System.Drawing.Size( 241, 22 );
            menuLyricDictionary.setText( "User Word Dictionary(C)" );
            //menuLyricDictionary.Click += new System.EventHandler( menuLyricDictionary_Click );
            // 
            // menuScript
            // 
            menuScript.add( menuScriptUpdate );
            menuScript.setName( "menuScript" );
            //menuScript.setSize( 72, 22 );
            menuScript.setText( "Script(C)" );
            // 
            // menuScriptUpdate
            // 
            menuScriptUpdate.setName( "menuScriptUpdate" );
            //menuScriptUpdate.Size = new System.Drawing.Size( 200, 22 );
            menuScriptUpdate.setText( "Update Script List(U)" );
            //menuScriptUpdate.Click += new System.EventHandler( menuScriptUpdate_Click );
            // 
            // menuSetting
            // 
            menuSetting.add( menuSettingPreference );
            menuSetting.add( menuSettingGameControler );
            menuSetting.add( menuSettingPaletteTool );
            menuSetting.add( menuSettingShortcut );
            menuSetting.add( menuSettingMidi );
            menuSetting.add( menuSettingUtauVoiceDB );
            menuSetting.addSeparator();
            menuSetting.add( menuSettingDefaultSingerStyle );
            menuSetting.addSeparator();
            menuSetting.add( menuSettingPositionQuantize );
            menuSetting.add( menuSettingLengthQuantize );
            menuSetting.addSeparator();
            menuSetting.add( menuSettingSingerProperty );
            menuSetting.setName( "menuSetting" );
            //menuSetting.setSize( 80, 22 );
            menuSetting.setText( "Setting(S)" );
            //menuSetting.DropDownOpening += new System.EventHandler( menuSetting_DropDownOpening );
            // 
            // menuSettingPreference
            // 
            menuSettingPreference.setName( "menuSettingPreference" );
            //menuSettingPreference.Size = new System.Drawing.Size( 223, 22 );
            menuSettingPreference.setText( "Preference(P)" );
            //menuSettingPreference.Click += new System.EventHandler( menuSettingPreference_Click );
            // 
            // menuSettingGameControler
            // 
            menuSettingGameControler.add( menuSettingGameControlerSetting );
            menuSettingGameControler.add( menuSettingGameControlerLoad );
            menuSettingGameControler.add( menuSettingGameControlerRemove );
            menuSettingGameControler.setName( "menuSettingGameControler" );
            //menuSettingGameControler.Size = new System.Drawing.Size( 223, 22 );
            menuSettingGameControler.setText( "Game Controler(G)" );
            // 
            // menuSettingGameControlerSetting
            // 
            menuSettingGameControlerSetting.setName( "menuSettingGameControlerSetting" );
            //menuSettingGameControlerSetting.Size = new System.Drawing.Size( 142, 22 );
            menuSettingGameControlerSetting.setText( "Setting(S)" );
            //menuSettingGameControlerSetting.Click += new System.EventHandler( menuSettingGameControlerSetting_Click );
            // 
            // menuSettingGameControlerLoad
            // 
            menuSettingGameControlerLoad.setName( "menuSettingGameControlerLoad" );
            //menuSettingGameControlerLoad.Size = new System.Drawing.Size( 142, 22 );
            menuSettingGameControlerLoad.setText( "Load(L)" );
            //menuSettingGameControlerLoad.Click += new System.EventHandler( menuSettingGameControlerLoad_Click );
            // 
            // menuSettingGameControlerRemove
            // 
            menuSettingGameControlerRemove.setName( "menuSettingGameControlerRemove" );
            //menuSettingGameControlerRemove.Size = new System.Drawing.Size( 142, 22 );
            menuSettingGameControlerRemove.setText( "Remove(R)" );
            //menuSettingGameControlerRemove.Click += new System.EventHandler( menuSettingGameControlerRemove_Click );
            // 
            // menuSettingPaletteTool
            // 
            menuSettingPaletteTool.setName( "menuSettingPaletteTool" );
            //menuSettingPaletteTool.Size = new System.Drawing.Size( 223, 22 );
            menuSettingPaletteTool.setText( "Palette Tool(T)" );
            // 
            // menuSettingShortcut
            // 
            menuSettingShortcut.setName( "menuSettingShortcut" );
            //menuSettingShortcut.Size = new System.Drawing.Size( 223, 22 );
            menuSettingShortcut.setText( "Shortcut Key(S)" );
            //menuSettingShortcut.Click += new System.EventHandler( menuSettingShortcut_Click );
            // 
            // menuSettingMidi
            // 
            menuSettingMidi.setName( "menuSettingMidi" );
            //menuSettingMidi.Size = new System.Drawing.Size( 223, 22 );
            menuSettingMidi.setText( "MIDI(M)" );
            //menuSettingMidi.Click += new System.EventHandler( menuSettingMidi_Click );
            // 
            // menuSettingUtauVoiceDB
            // 
            menuSettingUtauVoiceDB.setName( "menuSettingUtauVoiceDB" );
            //menuSettingUtauVoiceDB.Size = new System.Drawing.Size( 223, 22 );
            menuSettingUtauVoiceDB.setText( "UTAU Voice DB(U)" );
            //menuSettingUtauVoiceDB.Click += new System.EventHandler( menuSettingUtauVoiceDB_Click );
            // 
            // menuSettingDefaultSingerStyle
            // 
            menuSettingDefaultSingerStyle.setName( "menuSettingDefaultSingerStyle" );
            //menuSettingDefaultSingerStyle.Size = new System.Drawing.Size( 223, 22 );
            menuSettingDefaultSingerStyle.setText( "Singing Style Defaults(D)" );
            //menuSettingDefaultSingerStyle.Click += new System.EventHandler( menuSettingDefaultSingerStyle_Click );
            // 
            // menuSettingPositionQuantize
            // 
            menuSettingPositionQuantize.add( menuSettingPositionQuantize04 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantize08 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantize16 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantize32 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantize64 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantize128 );
            menuSettingPositionQuantize.add( menuSettingPositionQuantizeOff );
            menuSettingPositionQuantize.addSeparator();
            menuSettingPositionQuantize.add( menuSettingPositionQuantizeTriplet );
            menuSettingPositionQuantize.setName( "menuSettingPositionQuantize" );
            //menuSettingPositionQuantize.Size = new System.Drawing.Size( 223, 22 );
            menuSettingPositionQuantize.setText( "Quantize(Q)" );
            // 
            // menuSettingPositionQuantize04
            // 
            menuSettingPositionQuantize04.setName( "menuSettingPositionQuantize04" );
            //menuSettingPositionQuantize04.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize04.setText( "1/4" );
            //menuSettingPositionQuantize04.Click += new System.EventHandler( h_positionQuantize04 );
            // 
            // menuSettingPositionQuantize08
            // 
            menuSettingPositionQuantize08.setName( "menuSettingPositionQuantize08" );
            //menuSettingPositionQuantize08.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize08.setText( "1/8" );
            //menuSettingPositionQuantize08.Click += new System.EventHandler( h_positionQuantize08 );
            // 
            // menuSettingPositionQuantize16
            // 
            menuSettingPositionQuantize16.setName( "menuSettingPositionQuantize16" );
            //menuSettingPositionQuantize16.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize16.setText( "1/16" );
            //menuSettingPositionQuantize16.Click += new System.EventHandler( h_positionQuantize16 );
            // 
            // menuSettingPositionQuantize32
            // 
            menuSettingPositionQuantize32.setName( "menuSettingPositionQuantize32" );
            //menuSettingPositionQuantize32.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize32.setText( "1/32" );
            //menuSettingPositionQuantize32.Click += new System.EventHandler( h_positionQuantize32 );
            // 
            // menuSettingPositionQuantize64
            // 
            menuSettingPositionQuantize64.setName( "menuSettingPositionQuantize64" );
            //menuSettingPositionQuantize64.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize64.setText( "1/64" );
            //menuSettingPositionQuantize64.Click += new System.EventHandler( h_positionQuantize64 );
            // 
            // menuSettingPositionQuantize128
            // 
            menuSettingPositionQuantize128.setName( "menuSettingPositionQuantize128" );
            //menuSettingPositionQuantize128.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantize128.setText( "1/128" );
            //menuSettingPositionQuantize128.Click += new System.EventHandler( h_positionQuantize128 );
            // 
            // menuSettingPositionQuantizeOff
            // 
            menuSettingPositionQuantizeOff.setName( "menuSettingPositionQuantizeOff" );
            //menuSettingPositionQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantizeOff.setText( "Off" );
            //menuSettingPositionQuantizeOff.Click += new System.EventHandler( h_positionQuantizeOff );
            // 
            // menuSettingPositionQuantizeTriplet
            // 
            menuSettingPositionQuantizeTriplet.setName( "menuSettingPositionQuantizeTriplet" );
            //menuSettingPositionQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            menuSettingPositionQuantizeTriplet.setText( "Triplet" );
            //menuSettingPositionQuantizeTriplet.Click += new System.EventHandler( h_positionQuantizeTriplet );
            // 
            // menuSettingLengthQuantize
            // 
            menuSettingLengthQuantize.add( menuSettingLengthQuantize04 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantize08 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantize16 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantize32 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantize64 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantize128 );
            menuSettingLengthQuantize.add( menuSettingLengthQuantizeOff );
            menuSettingLengthQuantize.addSeparator();
            menuSettingLengthQuantize.add( menuSettingLengthQuantizeTriplet );
            menuSettingLengthQuantize.setName( "menuSettingLengthQuantize" );
            //menuSettingLengthQuantize.Size = new System.Drawing.Size( 223, 22 );
            menuSettingLengthQuantize.setText( "Length(L)" );
            // 
            // menuSettingLengthQuantize04
            // 
            menuSettingLengthQuantize04.setName( "menuSettingLengthQuantize04" );
            //menuSettingLengthQuantize04.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize04.setText( "1/4" );
            //menuSettingLengthQuantize04.Click += new System.EventHandler( h_lengthQuantize04 );
            // 
            // menuSettingLengthQuantize08
            // 
            menuSettingLengthQuantize08.setName( "menuSettingLengthQuantize08" );
            //menuSettingLengthQuantize08.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize08.setText( "1/8" );
            //menuSettingLengthQuantize08.Click += new System.EventHandler( h_lengthQuantize08 );
            // 
            // menuSettingLengthQuantize16
            // 
            menuSettingLengthQuantize16.setName( "menuSettingLengthQuantize16" );
            //menuSettingLengthQuantize16.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize16.setText( "1/16" );
            //menuSettingLengthQuantize16.Click += new System.EventHandler( h_lengthQuantize16 );
            // 
            // menuSettingLengthQuantize32
            // 
            menuSettingLengthQuantize32.setName( "menuSettingLengthQuantize32" );
            //menuSettingLengthQuantize32.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize32.setText( "1/32" );
            //menuSettingLengthQuantize32.Click += new System.EventHandler( h_lengthQuantize32 );
            // 
            // menuSettingLengthQuantize64
            // 
            menuSettingLengthQuantize64.setName( "menuSettingLengthQuantize64" );
            //menuSettingLengthQuantize64.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize64.setText( "1/64" );
            //menuSettingLengthQuantize64.Click += new System.EventHandler( h_lengthQuantize64 );
            // 
            // menuSettingLengthQuantize128
            // 
            menuSettingLengthQuantize128.setName( "menuSettingLengthQuantize128" );
            //menuSettingLengthQuantize128.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantize128.setText( "1/128" );
            //menuSettingLengthQuantize128.Click += new System.EventHandler( h_lengthQuantize128 );
            // 
            // menuSettingLengthQuantizeOff
            // 
            menuSettingLengthQuantizeOff.setName( "menuSettingLengthQuantizeOff" );
            //menuSettingLengthQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantizeOff.setText( "Off" );
            //menuSettingLengthQuantizeOff.Click += new System.EventHandler( h_lengthQuantizeOff );
            // 
            // menuSettingLengthQuantizeTriplet
            // 
            menuSettingLengthQuantizeTriplet.setName( "menuSettingLengthQuantizeTriplet" );
            //menuSettingLengthQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            menuSettingLengthQuantizeTriplet.setText( "Triplet" );
            //menuSettingLengthQuantizeTriplet.Click += new System.EventHandler( h_lengthQuantizeTriplet );
            // 
            // menuSettingSingerProperty
            // 
            menuSettingSingerProperty.setEnabled( false );
            menuSettingSingerProperty.setName( "menuSettingSingerProperty" );
            //menuSettingSingerProperty.Size = new System.Drawing.Size( 223, 22 );
            menuSettingSingerProperty.setText( "Singer Properties(S)" );
            // 
            // menuHelp
            // 
            menuHelp.add( menuHelpAbout );
            menuHelp.add( menuHelpDebug );
            menuHelp.setName( "menuHelp" );
            //menuHelp.setSize( 65, 22 );
            menuHelp.setText( "Help(H)" );
            // 
            // menuHelpAbout
            // 
            menuHelpAbout.setName( "menuHelpAbout" );
            //menuHelpAbout.Size = new System.Drawing.Size( 180, 22 );
            menuHelpAbout.setText( "About Cadencii(A)" );
            //menuHelpAbout.Click += new System.EventHandler( menuHelpAbout_Click );
            // 
            // menuHelpDebug
            // 
            menuHelpDebug.setName( "menuHelpDebug" );
            //menuHelpDebug.Size = new System.Drawing.Size( 180, 22 );
            menuHelpDebug.setText( "Debug" );
            menuHelpDebug.setVisible( false );
            //menuHelpDebug.Click += new System.EventHandler( menuHelpDebug_Click );
            // 
            // menuHidden
            // 
            /*menuHidden.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            menuHiddenEditLyric,
            menuHiddenEditFlipToolPointerPencil,
            menuHiddenEditFlipToolPointerEraser,
            menuHiddenVisualForwardParameter,
            menuHiddenVisualBackwardParameter,
            menuHiddenTrackNext,
            menuHiddenTrackBack,
            menuHiddenCopy,
            menuHiddenPaste,
            menuHiddenCut} );*/
            menuHidden.setName( "menuHidden" );
            //menuHidden.setSize( 91, 22 );
            menuHidden.setText( "MenuHidden" );
            menuHidden.setVisible( false );
            /*// 
            // menuHiddenEditLyric
            // 
            menuHiddenEditLyric.setName( "menuHiddenEditLyric";
            menuHiddenEditLyric.ShortcutKeys = System.Windows.Forms.Keys.F2;
            menuHiddenEditLyric.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenEditLyric.setText( "Start Lyric Input";
            menuHiddenEditLyric.Visible = false;
            menuHiddenEditLyric.Click += new System.EventHandler( menuHiddenEditLyric_Click );
            // 
            // menuHiddenEditFlipToolPointerPencil
            // 
            menuHiddenEditFlipToolPointerPencil.setName( "menuHiddenEditFlipToolPointerPencil";
            menuHiddenEditFlipToolPointerPencil.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            menuHiddenEditFlipToolPointerPencil.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenEditFlipToolPointerPencil.setText( "Change Tool Pointer / Pencil";
            menuHiddenEditFlipToolPointerPencil.Visible = false;
            menuHiddenEditFlipToolPointerPencil.Click += new System.EventHandler( menuHiddenEditFlipToolPointerPencil_Click );
            // 
            // menuHiddenEditFlipToolPointerEraser
            // 
            menuHiddenEditFlipToolPointerEraser.setName( "menuHiddenEditFlipToolPointerEraser";
            menuHiddenEditFlipToolPointerEraser.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            menuHiddenEditFlipToolPointerEraser.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenEditFlipToolPointerEraser.setText( "Change Tool Pointer/ Eraser";
            menuHiddenEditFlipToolPointerEraser.Visible = false;
            menuHiddenEditFlipToolPointerEraser.Click += new System.EventHandler( menuHiddenEditFlipToolPointerEraser_Click );
            // 
            // menuHiddenVisualForwardParameter
            // 
            menuHiddenVisualForwardParameter.setName( "menuHiddenVisualForwardParameter";
            menuHiddenVisualForwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.Next)));
            menuHiddenVisualForwardParameter.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenVisualForwardParameter.setText( "Next Control Curve";
            menuHiddenVisualForwardParameter.Visible = false;
            menuHiddenVisualForwardParameter.Click += new System.EventHandler( menuHiddenVisualForwardParameter_Click );
            // 
            // menuHiddenVisualBackwardParameter
            // 
            menuHiddenVisualBackwardParameter.setName( "menuHiddenVisualBackwardParameter";
            menuHiddenVisualBackwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.PageUp)));
            menuHiddenVisualBackwardParameter.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenVisualBackwardParameter.setText( "Previous Control Curve";
            menuHiddenVisualBackwardParameter.Visible = false;
            menuHiddenVisualBackwardParameter.Click += new System.EventHandler( menuHiddenVisualBackwardParameter_Click );
            // 
            // menuHiddenTrackNext
            // 
            menuHiddenTrackNext.setName( "menuHiddenTrackNext";
            menuHiddenTrackNext.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Next)));
            menuHiddenTrackNext.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenTrackNext.setText( "Next Track";
            menuHiddenTrackNext.Visible = false;
            menuHiddenTrackNext.Click += new System.EventHandler( menuHiddenTrackNext_Click );
            // 
            // menuHiddenTrackBack
            // 
            menuHiddenTrackBack.setName( "menuHiddenTrackBack";
            menuHiddenTrackBack.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.PageUp)));
            menuHiddenTrackBack.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenTrackBack.setText( "Previous Track";
            menuHiddenTrackBack.Visible = false;
            menuHiddenTrackBack.Click += new System.EventHandler( menuHiddenTrackBack_Click );
            // 
            // menuHiddenCopy
            // 
            menuHiddenCopy.setName( "menuHiddenCopy";
            menuHiddenCopy.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenCopy.setText( "Copy";
            menuHiddenCopy.Click += new System.EventHandler( commonEditCopy_Click );
            // 
            // menuHiddenPaste
            // 
            menuHiddenPaste.setName( "menuHiddenPaste";
            menuHiddenPaste.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenPaste.setText( "Paste";
            menuHiddenPaste.Click += new System.EventHandler( commonEditPaste_Click );
            // 
            // menuHiddenCut
            // 
            menuHiddenCut.setName( "menuHiddenCut";
            menuHiddenCut.Size = new System.Drawing.Size( 304, 22 );
            menuHiddenCut.setText( "Cut";
            menuHiddenCut.Click += new System.EventHandler( commonEditCut_Click );
            // 
            // saveXmlVsqDialog
            // 
            saveXmlVsqDialog.Filter = "VSQ Format(*.vsq)|*.vsq|Original Format(*.evsq)|*.evsq|All files(*.*)|*.*";
            // 
            // cMenuPiano
            // 
            cMenuPiano.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuPianoPointer,
            cMenuPianoPencil,
            cMenuPianoEraser,
            cMenuPianoPaletteTool,
            toolStripSeparator15,
            cMenuPianoCurve,
            toolStripMenuItem13,
            cMenuPianoFixed,
            cMenuPianoQuantize,
            cMenuPianoLength,
            cMenuPianoGrid,
            toolStripMenuItem14,
            cMenuPianoUndo,
            cMenuPianoRedo,
            toolStripMenuItem15,
            cMenuPianoCut,
            cMenuPianoCopy,
            cMenuPianoPaste,
            cMenuPianoDelete,
            toolStripMenuItem16,
            cMenuPianoSelectAll,
            cMenuPianoSelectAllEvents,
            toolStripMenuItem17,
            cMenuPianoImportLyric,
            cMenuPianoExpressionProperty,
            cMenuPianoVibratoProperty} );
            cMenuPiano.setName( "cMenuPiano";
            cMenuPiano.ShowCheckMargin = true;
            cMenuPiano.ShowImageMargin = false;
            cMenuPiano.Size = new System.Drawing.Size( 242, 480 );
            cMenuPiano.Opening += new System.ComponentModel.CancelEventHandler( cMenuPiano_Opening );
            // 
            // cMenuPianoPointer
            // 
            cMenuPianoPointer.setName( "cMenuPianoPointer";
            cMenuPianoPointer.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoPointer.setText( "Arrow(&A)";
            cMenuPianoPointer.Click += new System.EventHandler( cMenuPianoPointer_Click );
            // 
            // cMenuPianoPencil
            // 
            cMenuPianoPencil.setName( "cMenuPianoPencil";
            cMenuPianoPencil.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoPencil.setText( "Pencil(&W)";
            cMenuPianoPencil.Click += new System.EventHandler( cMenuPianoPencil_Click );
            // 
            // cMenuPianoEraser
            // 
            cMenuPianoEraser.setName( "cMenuPianoEraser";
            cMenuPianoEraser.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoEraser.setText( "Eraser(&E)";
            cMenuPianoEraser.Click += new System.EventHandler( cMenuPianoEraser_Click );
            // 
            // cMenuPianoPaletteTool
            // 
            cMenuPianoPaletteTool.setName( "cMenuPianoPaletteTool";
            cMenuPianoPaletteTool.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoPaletteTool.setText( "Palette Tool";
            // 
            // toolStripSeparator15
            // 
            toolStripSeparator15.setName( "toolStripSeparator15";
            toolStripSeparator15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCurve
            // 
            cMenuPianoCurve.setName( "cMenuPianoCurve";
            cMenuPianoCurve.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoCurve.setText( "Curve(&V)";
            cMenuPianoCurve.Click += new System.EventHandler( cMenuPianoCurve_Click );
            // 
            // toolStripMenuItem13
            // 
            toolStripMenuItem13.setName( "toolStripMenuItem13";
            toolStripMenuItem13.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoFixed
            // 
            cMenuPianoFixed.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuPianoFixed01,
            cMenuPianoFixed02,
            cMenuPianoFixed04,
            cMenuPianoFixed08,
            cMenuPianoFixed16,
            cMenuPianoFixed32,
            cMenuPianoFixed64,
            cMenuPianoFixed128,
            cMenuPianoFixedOff,
            toolStripMenuItem18,
            cMenuPianoFixedTriplet,
            cMenuPianoFixedDotted} );
            cMenuPianoFixed.setName( "cMenuPianoFixed";
            cMenuPianoFixed.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoFixed.setText( "Note Fixed Length(&N)";
            // 
            // cMenuPianoFixed01
            // 
            cMenuPianoFixed01.setName( "cMenuPianoFixed01";
            cMenuPianoFixed01.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed01.setText( "1/ 1 [1920]";
            cMenuPianoFixed01.Click += new System.EventHandler( cMenuPianoFixed01_Click );
            // 
            // cMenuPianoFixed02
            // 
            cMenuPianoFixed02.setName( "cMenuPianoFixed02";
            cMenuPianoFixed02.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed02.setText( "1/ 2 [960]";
            cMenuPianoFixed02.Click += new System.EventHandler( cMenuPianoFixed02_Click );
            // 
            // cMenuPianoFixed04
            // 
            cMenuPianoFixed04.setName( "cMenuPianoFixed04";
            cMenuPianoFixed04.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed04.setText( "1/ 4 [480]";
            cMenuPianoFixed04.Click += new System.EventHandler( cMenuPianoFixed04_Click );
            // 
            // cMenuPianoFixed08
            // 
            cMenuPianoFixed08.setName( "cMenuPianoFixed08";
            cMenuPianoFixed08.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed08.setText( "1/ 8 [240]";
            cMenuPianoFixed08.Click += new System.EventHandler( cMenuPianoFixed08_Click );
            // 
            // cMenuPianoFixed16
            // 
            cMenuPianoFixed16.setName( "cMenuPianoFixed16";
            cMenuPianoFixed16.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed16.setText( "1/16 [120]";
            cMenuPianoFixed16.Click += new System.EventHandler( cMenuPianoFixed16_Click );
            // 
            // cMenuPianoFixed32
            // 
            cMenuPianoFixed32.setName( "cMenuPianoFixed32";
            cMenuPianoFixed32.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed32.setText( "1/32 [60]";
            cMenuPianoFixed32.Click += new System.EventHandler( cMenuPianoFixed32_Click );
            // 
            // cMenuPianoFixed64
            // 
            cMenuPianoFixed64.setName( "cMenuPianoFixed64";
            cMenuPianoFixed64.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed64.setText( "1/64 [30]";
            cMenuPianoFixed64.Click += new System.EventHandler( cMenuPianoFixed64_Click );
            // 
            // cMenuPianoFixed128
            // 
            cMenuPianoFixed128.setName( "cMenuPianoFixed128";
            cMenuPianoFixed128.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixed128.setText( "1/128[15]";
            cMenuPianoFixed128.Click += new System.EventHandler( cMenuPianoFixed128_Click );
            // 
            // cMenuPianoFixedOff
            // 
            cMenuPianoFixedOff.setName( "cMenuPianoFixedOff";
            cMenuPianoFixedOff.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixedOff.setText( "オフ";
            cMenuPianoFixedOff.Click += new System.EventHandler( cMenuPianoFixedOff_Click );
            // 
            // toolStripMenuItem18
            // 
            toolStripMenuItem18.setName( "toolStripMenuItem18";
            toolStripMenuItem18.Size = new System.Drawing.Size( 138, 6 );
            // 
            // cMenuPianoFixedTriplet
            // 
            cMenuPianoFixedTriplet.setName( "cMenuPianoFixedTriplet";
            cMenuPianoFixedTriplet.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixedTriplet.setText( "3連符";
            cMenuPianoFixedTriplet.Click += new System.EventHandler( cMenuPianoFixedTriplet_Click );
            // 
            // cMenuPianoFixedDotted
            // 
            cMenuPianoFixedDotted.setName( "cMenuPianoFixedDotted";
            cMenuPianoFixedDotted.Size = new System.Drawing.Size( 141, 22 );
            cMenuPianoFixedDotted.setText( "付点";
            cMenuPianoFixedDotted.Click += new System.EventHandler( cMenuPianoFixedDotted_Click );
            // 
            // cMenuPianoQuantize
            // 
            cMenuPianoQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuPianoQuantize04,
            cMenuPianoQuantize08,
            cMenuPianoQuantize16,
            cMenuPianoQuantize32,
            cMenuPianoQuantize64,
            cMenuPianoQuantize128,
            cMenuPianoQuantizeOff,
            toolStripMenuItem26,
            cMenuPianoQuantizeTriplet} );
            cMenuPianoQuantize.setName( "cMenuPianoQuantize";
            cMenuPianoQuantize.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoQuantize.setText( "Quantize(&Q)";
            // 
            // cMenuPianoQuantize04
            // 
            cMenuPianoQuantize04.setName( "cMenuPianoQuantize04";
            cMenuPianoQuantize04.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize04.setText( "1/4";
            cMenuPianoQuantize04.Click += new System.EventHandler( h_positionQuantize04 );
            // 
            // cMenuPianoQuantize08
            // 
            cMenuPianoQuantize08.setName( "cMenuPianoQuantize08";
            cMenuPianoQuantize08.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize08.setText( "1/8";
            cMenuPianoQuantize08.Click += new System.EventHandler( h_positionQuantize08 );
            // 
            // cMenuPianoQuantize16
            // 
            cMenuPianoQuantize16.setName( "cMenuPianoQuantize16";
            cMenuPianoQuantize16.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize16.setText( "1/16";
            cMenuPianoQuantize16.Click += new System.EventHandler( h_positionQuantize16 );
            // 
            // cMenuPianoQuantize32
            // 
            cMenuPianoQuantize32.setName( "cMenuPianoQuantize32";
            cMenuPianoQuantize32.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize32.setText( "1/32";
            cMenuPianoQuantize32.Click += new System.EventHandler( h_positionQuantize32 );
            // 
            // cMenuPianoQuantize64
            // 
            cMenuPianoQuantize64.setName( "cMenuPianoQuantize64";
            cMenuPianoQuantize64.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize64.setText( "1/64";
            cMenuPianoQuantize64.Click += new System.EventHandler( h_positionQuantize64 );
            // 
            // cMenuPianoQuantize128
            // 
            cMenuPianoQuantize128.setName( "cMenuPianoQuantize128";
            cMenuPianoQuantize128.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantize128.setText( "1/128";
            cMenuPianoQuantize128.Click += new System.EventHandler( h_positionQuantize128 );
            // 
            // cMenuPianoQuantizeOff
            // 
            cMenuPianoQuantizeOff.setName( "cMenuPianoQuantizeOff";
            cMenuPianoQuantizeOff.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantizeOff.setText( "オフ";
            cMenuPianoQuantizeOff.Click += new System.EventHandler( h_positionQuantizeOff );
            // 
            // toolStripMenuItem26
            // 
            toolStripMenuItem26.setName( "toolStripMenuItem26";
            toolStripMenuItem26.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoQuantizeTriplet
            // 
            cMenuPianoQuantizeTriplet.setName( "cMenuPianoQuantizeTriplet";
            cMenuPianoQuantizeTriplet.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoQuantizeTriplet.setText( "3連符";
            cMenuPianoQuantizeTriplet.Click += new System.EventHandler( h_positionQuantizeTriplet );
            // 
            // cMenuPianoLength
            // 
            cMenuPianoLength.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuPianoLength04,
            cMenuPianoLength08,
            cMenuPianoLength16,
            cMenuPianoLength32,
            cMenuPianoLength64,
            cMenuPianoLength128,
            cMenuPianoLengthOff,
            toolStripMenuItem32,
            cMenuPianoLengthTriplet} );
            cMenuPianoLength.setName( "cMenuPianoLength";
            cMenuPianoLength.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoLength.setText( "Length(&L)";
            // 
            // cMenuPianoLength04
            // 
            cMenuPianoLength04.setName( "cMenuPianoLength04";
            cMenuPianoLength04.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength04.setText( "1/4";
            cMenuPianoLength04.Click += new System.EventHandler( h_lengthQuantize04 );
            // 
            // cMenuPianoLength08
            // 
            cMenuPianoLength08.setName( "cMenuPianoLength08";
            cMenuPianoLength08.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength08.setText( "1/8";
            cMenuPianoLength08.Click += new System.EventHandler( h_lengthQuantize08 );
            // 
            // cMenuPianoLength16
            // 
            cMenuPianoLength16.setName( "cMenuPianoLength16";
            cMenuPianoLength16.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength16.setText( "1/16";
            cMenuPianoLength16.Click += new System.EventHandler( h_lengthQuantize16 );
            // 
            // cMenuPianoLength32
            // 
            cMenuPianoLength32.setName( "cMenuPianoLength32";
            cMenuPianoLength32.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength32.setText( "1/32";
            cMenuPianoLength32.Click += new System.EventHandler( h_lengthQuantize32 );
            // 
            // cMenuPianoLength64
            // 
            cMenuPianoLength64.setName( "cMenuPianoLength64";
            cMenuPianoLength64.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength64.setText( "1/64";
            cMenuPianoLength64.Click += new System.EventHandler( h_lengthQuantize64 );
            // 
            // cMenuPianoLength128
            // 
            cMenuPianoLength128.setName( "cMenuPianoLength128";
            cMenuPianoLength128.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLength128.setText( "1/128";
            cMenuPianoLength128.Click += new System.EventHandler( h_lengthQuantize128 );
            // 
            // cMenuPianoLengthOff
            // 
            cMenuPianoLengthOff.setName( "cMenuPianoLengthOff";
            cMenuPianoLengthOff.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLengthOff.setText( "オフ";
            cMenuPianoLengthOff.Click += new System.EventHandler( h_lengthQuantizeOff );
            // 
            // toolStripMenuItem32
            // 
            toolStripMenuItem32.setName( "toolStripMenuItem32";
            toolStripMenuItem32.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoLengthTriplet
            // 
            cMenuPianoLengthTriplet.setName( "cMenuPianoLengthTriplet";
            cMenuPianoLengthTriplet.Size = new System.Drawing.Size( 109, 22 );
            cMenuPianoLengthTriplet.setText( "3連符";
            cMenuPianoLengthTriplet.Click += new System.EventHandler( h_lengthQuantizeTriplet );
            // 
            // cMenuPianoGrid
            // 
            cMenuPianoGrid.setName( "cMenuPianoGrid";
            cMenuPianoGrid.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoGrid.setText( "Show/Hide Grid Line(&S)";
            cMenuPianoGrid.Click += new System.EventHandler( cMenuPianoGrid_Click );
            // 
            // toolStripMenuItem14
            // 
            toolStripMenuItem14.setName( "toolStripMenuItem14";
            toolStripMenuItem14.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoUndo
            // 
            cMenuPianoUndo.setName( "cMenuPianoUndo";
            cMenuPianoUndo.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoUndo.setText( "Undo(&U)";
            cMenuPianoUndo.Click += new System.EventHandler( cMenuPianoUndo_Click );
            // 
            // cMenuPianoRedo
            // 
            cMenuPianoRedo.setName( "cMenuPianoRedo";
            cMenuPianoRedo.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoRedo.setText( "Redo(&R)";
            cMenuPianoRedo.Click += new System.EventHandler( cMenuPianoRedo_Click );
            // 
            // toolStripMenuItem15
            // 
            toolStripMenuItem15.setName( "toolStripMenuItem15";
            toolStripMenuItem15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCut
            // 
            cMenuPianoCut.setName( "cMenuPianoCut";
            cMenuPianoCut.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoCut.setText( "Cut(&T)";
            cMenuPianoCut.Click += new System.EventHandler( cMenuPianoCut_Click );
            // 
            // cMenuPianoCopy
            // 
            cMenuPianoCopy.setName( "cMenuPianoCopy";
            cMenuPianoCopy.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoCopy.setText( "Copy(&C)";
            cMenuPianoCopy.Click += new System.EventHandler( cMenuPianoCopy_Click );
            // 
            // cMenuPianoPaste
            // 
            cMenuPianoPaste.setName( "cMenuPianoPaste";
            cMenuPianoPaste.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoPaste.setText( "Paste(&P)";
            cMenuPianoPaste.Click += new System.EventHandler( cMenuPianoPaste_Click );
            // 
            // cMenuPianoDelete
            // 
            cMenuPianoDelete.setName( "cMenuPianoDelete";
            cMenuPianoDelete.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoDelete.setText( "Delete(&D)";
            cMenuPianoDelete.Click += new System.EventHandler( cMenuPianoDelete_Click );
            // 
            // toolStripMenuItem16
            // 
            toolStripMenuItem16.setName( "toolStripMenuItem16";
            toolStripMenuItem16.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoSelectAll
            // 
            cMenuPianoSelectAll.setName( "cMenuPianoSelectAll";
            cMenuPianoSelectAll.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoSelectAll.setText( "Select All(&A)";
            cMenuPianoSelectAll.Click += new System.EventHandler( cMenuPianoSelectAll_Click );
            // 
            // cMenuPianoSelectAllEvents
            // 
            cMenuPianoSelectAllEvents.setName( "cMenuPianoSelectAllEvents";
            cMenuPianoSelectAllEvents.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoSelectAllEvents.setText( "Select All Events(&E)";
            cMenuPianoSelectAllEvents.Click += new System.EventHandler( cMenuPianoSelectAllEvents_Click );
            // 
            // toolStripMenuItem17
            // 
            toolStripMenuItem17.setName( "toolStripMenuItem17";
            toolStripMenuItem17.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoImportLyric
            // 
            cMenuPianoImportLyric.setName( "cMenuPianoImportLyric";
            cMenuPianoImportLyric.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoImportLyric.setText( "Insert Lyrics(&L)";
            cMenuPianoImportLyric.Click += new System.EventHandler( cMenuPianoImportLyric_Click );
            // 
            // cMenuPianoExpressionProperty
            // 
            cMenuPianoExpressionProperty.setName( "cMenuPianoExpressionProperty";
            cMenuPianoExpressionProperty.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoExpressionProperty.setText( "Note Expression Property(&P)";
            cMenuPianoExpressionProperty.Click += new System.EventHandler( cMenuPianoProperty_Click );
            // 
            // cMenuPianoVibratoProperty
            // 
            cMenuPianoVibratoProperty.setName( "cMenuPianoVibratoProperty";
            cMenuPianoVibratoProperty.Size = new System.Drawing.Size( 241, 22 );
            cMenuPianoVibratoProperty.setText( "Note Vibrato Property";
            cMenuPianoVibratoProperty.Click += new System.EventHandler( cMenuPianoVibratoProperty_Click );
            // 
            // openXmlVsqDialog
            // 
            openXmlVsqDialog.Filter = "VSQ Format(*.vsq)|*.vsq|Original Format(*.evsq)|*.evsq";
            // 
            // cMenuTrackTab
            // 
            cMenuTrackTab.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuTrackTabTrackOn,
            toolStripMenuItem24,
            cMenuTrackTabAdd,
            cMenuTrackTabCopy,
            cMenuTrackTabChangeName,
            cMenuTrackTabDelete,
            toolStripMenuItem25,
            cMenuTrackTabRenderCurrent,
            cMenuTrackTabRenderAll,
            toolStripMenuItem27,
            cMenuTrackTabOverlay,
            cMenuTrackTabRenderer,
            cMenuTrackTabMasterTuning} );
            cMenuTrackTab.setName( "cMenuTrackTab";
            cMenuTrackTab.Size = new System.Drawing.Size( 220, 242 );
            cMenuTrackTab.Opening += new System.ComponentModel.CancelEventHandler( cMenuTrackTab_Opening );
            // 
            // cMenuTrackTabTrackOn
            // 
            cMenuTrackTabTrackOn.setName( "cMenuTrackTabTrackOn";
            cMenuTrackTabTrackOn.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabTrackOn.setText( "Track On(&K)";
            cMenuTrackTabTrackOn.Click += new System.EventHandler( cMenuTrackTabTrackOn_Click );
            // 
            // toolStripMenuItem24
            // 
            toolStripMenuItem24.setName( "toolStripMenuItem24";
            toolStripMenuItem24.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabAdd
            // 
            cMenuTrackTabAdd.setName( "cMenuTrackTabAdd";
            cMenuTrackTabAdd.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabAdd.setText( "Add Track(&A)";
            cMenuTrackTabAdd.Click += new System.EventHandler( cMenuTrackTabAdd_Click );
            // 
            // cMenuTrackTabCopy
            // 
            cMenuTrackTabCopy.setName( "cMenuTrackTabCopy";
            cMenuTrackTabCopy.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabCopy.setText( "Copy Track(&C)";
            cMenuTrackTabCopy.Click += new System.EventHandler( cMenuTrackTabCopy_Click );
            // 
            // cMenuTrackTabChangeName
            // 
            cMenuTrackTabChangeName.setName( "cMenuTrackTabChangeName";
            cMenuTrackTabChangeName.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabChangeName.setText( "Rename Track(&R)";
            cMenuTrackTabChangeName.Click += new System.EventHandler( cMenuTrackTabChangeName_Click );
            // 
            // cMenuTrackTabDelete
            // 
            cMenuTrackTabDelete.setName( "cMenuTrackTabDelete";
            cMenuTrackTabDelete.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabDelete.setText( "Delete Track(&D)";
            cMenuTrackTabDelete.Click += new System.EventHandler( cMenuTrackTabDelete_Click );
            // 
            // toolStripMenuItem25
            // 
            toolStripMenuItem25.setName( "toolStripMenuItem25";
            toolStripMenuItem25.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabRenderCurrent
            // 
            cMenuTrackTabRenderCurrent.setName( "cMenuTrackTabRenderCurrent";
            cMenuTrackTabRenderCurrent.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabRenderCurrent.setText( "Render Current Track(&T)";
            cMenuTrackTabRenderCurrent.Click += new System.EventHandler( cMenuTrackTabRenderCurrent_Click );
            // 
            // cMenuTrackTabRenderAll
            // 
            cMenuTrackTabRenderAll.setName( "cMenuTrackTabRenderAll";
            cMenuTrackTabRenderAll.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabRenderAll.setText( "Render All Tracks(&S)";
            // 
            // toolStripMenuItem27
            // 
            toolStripMenuItem27.setName( "toolStripMenuItem27";
            toolStripMenuItem27.Size = new System.Drawing.Size( 216, 6 );
            // 
            // cMenuTrackTabOverlay
            // 
            cMenuTrackTabOverlay.setName( "cMenuTrackTabOverlay";
            cMenuTrackTabOverlay.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabOverlay.setText( "Overlay(&O)";
            cMenuTrackTabOverlay.Click += new System.EventHandler( cMenuTrackTabOverlay_Click );
            // 
            // cMenuTrackTabRenderer
            // 
            cMenuTrackTabRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuTrackTabRendererVOCALOID1,
            cMenuTrackTabRendererVOCALOID2,
            cMenuTrackTabRendererUtau} );
            cMenuTrackTabRenderer.setName( "cMenuTrackTabRenderer";
            cMenuTrackTabRenderer.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabRenderer.setText( "Renderer";
            cMenuTrackTabRenderer.DropDownOpening += new System.EventHandler( cMenuTrackTabRenderer_DropDownOpening );
            // 
            // cMenuTrackTabRendererVOCALOID1
            // 
            cMenuTrackTabRendererVOCALOID1.setName( "cMenuTrackTabRendererVOCALOID1";
            cMenuTrackTabRendererVOCALOID1.Size = new System.Drawing.Size( 146, 22 );
            cMenuTrackTabRendererVOCALOID1.setText( "VOCALOID1";
            cMenuTrackTabRendererVOCALOID1.Click += new System.EventHandler( commonRendererVOCALOID1_Click );
            // 
            // cMenuTrackTabRendererVOCALOID2
            // 
            cMenuTrackTabRendererVOCALOID2.setName( "cMenuTrackTabRendererVOCALOID2";
            cMenuTrackTabRendererVOCALOID2.Size = new System.Drawing.Size( 146, 22 );
            cMenuTrackTabRendererVOCALOID2.setText( "VOCALOID2";
            cMenuTrackTabRendererVOCALOID2.Click += new System.EventHandler( commonRendererVOCALOID2_Click );
            // 
            // cMenuTrackTabRendererUtau
            // 
            cMenuTrackTabRendererUtau.setName( "cMenuTrackTabRendererUtau";
            cMenuTrackTabRendererUtau.Size = new System.Drawing.Size( 146, 22 );
            cMenuTrackTabRendererUtau.setText( "UTAU";
            cMenuTrackTabRendererUtau.Click += new System.EventHandler( commonRendererUtau_Click );
            // 
            // cMenuTrackTabMasterTuning
            // 
            cMenuTrackTabMasterTuning.setName( "cMenuTrackTabMasterTuning";
            cMenuTrackTabMasterTuning.Size = new System.Drawing.Size( 219, 22 );
            cMenuTrackTabMasterTuning.setText( "Master Tuning(&M)";
            cMenuTrackTabMasterTuning.Click += new System.EventHandler( commonMasterTuning_Click );
            // 
            // cMenuTrackSelector
            // 
            cMenuTrackSelector.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            cMenuTrackSelectorPointer,
            cMenuTrackSelectorPencil,
            cMenuTrackSelectorLine,
            cMenuTrackSelectorEraser,
            cMenuTrackSelectorPaletteTool,
            toolStripSeparator14,
            cMenuTrackSelectorCurve,
            toolStripMenuItem28,
            cMenuTrackSelectorUndo,
            cMenuTrackSelectorRedo,
            toolStripMenuItem29,
            cMenuTrackSelectorCut,
            cMenuTrackSelectorCopy,
            cMenuTrackSelectorPaste,
            cMenuTrackSelectorDelete,
            cMenuTrackSelectorDeleteBezier,
            toolStripMenuItem31,
            cMenuTrackSelectorSelectAll} );
            cMenuTrackSelector.setName( "cMenuTrackSelector";
            cMenuTrackSelector.Size = new System.Drawing.Size( 206, 336 );
            cMenuTrackSelector.Opening += new System.ComponentModel.CancelEventHandler( cMenuTrackSelector_Opening );
            // 
            // cMenuTrackSelectorPointer
            // 
            cMenuTrackSelectorPointer.setName( "cMenuTrackSelectorPointer";
            cMenuTrackSelectorPointer.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorPointer.setText( "Arrow(&A)";
            cMenuTrackSelectorPointer.Click += new System.EventHandler( cMenuTrackSelectorPointer_Click );
            // 
            // cMenuTrackSelectorPencil
            // 
            cMenuTrackSelectorPencil.setName( "cMenuTrackSelectorPencil";
            cMenuTrackSelectorPencil.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorPencil.setText( "Pencil(&W)";
            cMenuTrackSelectorPencil.Click += new System.EventHandler( cMenuTrackSelectorPencil_Click );
            // 
            // cMenuTrackSelectorLine
            // 
            cMenuTrackSelectorLine.setName( "cMenuTrackSelectorLine";
            cMenuTrackSelectorLine.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorLine.setText( "Line(&L)";
            cMenuTrackSelectorLine.Click += new System.EventHandler( cMenuTrackSelectorLine_Click );
            // 
            // cMenuTrackSelectorEraser
            // 
            cMenuTrackSelectorEraser.setName( "cMenuTrackSelectorEraser";
            cMenuTrackSelectorEraser.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorEraser.setText( "Eraser(&E)";
            cMenuTrackSelectorEraser.Click += new System.EventHandler( cMenuTrackSelectorEraser_Click );
            // 
            // cMenuTrackSelectorPaletteTool
            // 
            cMenuTrackSelectorPaletteTool.setName( "cMenuTrackSelectorPaletteTool";
            cMenuTrackSelectorPaletteTool.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorPaletteTool.setText( "Palette Tool";
            // 
            // toolStripSeparator14
            // 
            toolStripSeparator14.setName( "toolStripSeparator14";
            toolStripSeparator14.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorCurve
            // 
            cMenuTrackSelectorCurve.setName( "cMenuTrackSelectorCurve";
            cMenuTrackSelectorCurve.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorCurve.setText( "Curve(&V)";
            cMenuTrackSelectorCurve.Click += new System.EventHandler( cMenuTrackSelectorCurve_Click );
            // 
            // toolStripMenuItem28
            // 
            toolStripMenuItem28.setName( "toolStripMenuItem28";
            toolStripMenuItem28.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorUndo
            // 
            cMenuTrackSelectorUndo.setName( "cMenuTrackSelectorUndo";
            cMenuTrackSelectorUndo.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorUndo.setText( "Undo(&U)";
            cMenuTrackSelectorUndo.Click += new System.EventHandler( cMenuTrackSelectorUndo_Click );
            // 
            // cMenuTrackSelectorRedo
            // 
            cMenuTrackSelectorRedo.setName( "cMenuTrackSelectorRedo";
            cMenuTrackSelectorRedo.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorRedo.setText( "Redo(&R)";
            cMenuTrackSelectorRedo.Click += new System.EventHandler( cMenuTrackSelectorRedo_Click );
            // 
            // toolStripMenuItem29
            // 
            toolStripMenuItem29.setName( "toolStripMenuItem29";
            toolStripMenuItem29.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorCut
            // 
            cMenuTrackSelectorCut.setName( "cMenuTrackSelectorCut";
            cMenuTrackSelectorCut.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorCut.setText( "Cut(&T)";
            cMenuTrackSelectorCut.Click += new System.EventHandler( cMenuTrackSelectorCut_Click );
            // 
            // cMenuTrackSelectorCopy
            // 
            cMenuTrackSelectorCopy.setName( "cMenuTrackSelectorCopy";
            cMenuTrackSelectorCopy.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorCopy.setText( "Copy(&C)";
            cMenuTrackSelectorCopy.Click += new System.EventHandler( cMenuTrackSelectorCopy_Click );
            // 
            // cMenuTrackSelectorPaste
            // 
            cMenuTrackSelectorPaste.setName( "cMenuTrackSelectorPaste";
            cMenuTrackSelectorPaste.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorPaste.setText( "Paste(&P)";
            cMenuTrackSelectorPaste.Click += new System.EventHandler( cMenuTrackSelectorPaste_Click );
            // 
            // cMenuTrackSelectorDelete
            // 
            cMenuTrackSelectorDelete.setName( "cMenuTrackSelectorDelete";
            cMenuTrackSelectorDelete.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorDelete.setText( "Delete(&D)";
            cMenuTrackSelectorDelete.Click += new System.EventHandler( cMenuTrackSelectorDelete_Click );
            // 
            // cMenuTrackSelectorDeleteBezier
            // 
            cMenuTrackSelectorDeleteBezier.setName( "cMenuTrackSelectorDeleteBezier";
            cMenuTrackSelectorDeleteBezier.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorDeleteBezier.setText( "Delete Bezier Point(&B)";
            cMenuTrackSelectorDeleteBezier.Click += new System.EventHandler( cMenuTrackSelectorDeleteBezier_Click );
            // 
            // toolStripMenuItem31
            // 
            toolStripMenuItem31.setName( "toolStripMenuItem31";
            toolStripMenuItem31.Size = new System.Drawing.Size( 202, 6 );
            // 
            // cMenuTrackSelectorSelectAll
            // 
            cMenuTrackSelectorSelectAll.setName( "cMenuTrackSelectorSelectAll";
            cMenuTrackSelectorSelectAll.Size = new System.Drawing.Size( 205, 22 );
            cMenuTrackSelectorSelectAll.setText( "Select All Events(&E)";
            cMenuTrackSelectorSelectAll.Click += new System.EventHandler( cMenuTrackSelectorSelectAll_Click );*/
            // 
            // trackBar
            // 
            //trackBar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            //trackBar.AutoSize = false;
            //trackBar.Location = new System.Drawing.Point( 322, 266 );
            //trackBar.Margin = new System.Windows.Forms.Padding( 0 );
            trackBar.setMaximum( 609 );
            trackBar.setMinimum( 17 );
            trackBar.setName( "trackBar" );
            trackBar.setPreferredSize( new Dimension( 83, 16 ) );
            //trackBar.TabIndex = 15;
            //trackBar.TabStop = false;
            //trackBar.TickFrequency = 100;
            //trackBar.TickStyle = System.Windows.Forms.TickStyle.None;
            trackBar.setValue( 17 );
            //trackBar.ValueChanged += new System.EventHandler( trackBar_ValueChanged );
            //trackBar.MouseDown += new System.Windows.Forms.MouseEventHandler( trackBar_MouseDown );
            //trackBar.Enter += new System.EventHandler( trackBar_Enter );
            /*// 
            // bgWorkScreen
            // 
            bgWorkScreen.DoWork += new System.ComponentModel.DoWorkEventHandler( bgWorkScreen_DoWork );
            // 
            // timer
            // 
            timer.Interval = 200;
            timer.Tick += new System.EventHandler( timer_Tick );*/
            // 
            // panel1
            // 
            GridBagLayout gbl = new GridBagLayout();
            panel1.setLayout( gbl );
            GridBagConstraints gbc = new GridBagConstraints();
            // pitcutrePositionIndicatorをpanel1に追加
            gbc.fill = GridBagConstraints.HORIZONTAL;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 4;
            gbc.gridheight = 1;
            gbc.weightx = 0.0d;
            gbc.weighty = 0.0d;
            gbl.setConstraints( picturePositionIndicator, gbc );
            // vScrollをpanel1に追加
            gbc.fill = GridBagConstraints.VERTICAL;
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0d;
            gbc.weighty = 1.0d;
            gbl.setConstraints( vScroll, gbc );
            // hScrollをpanel1に追加
            gbc.fill = GridBagConstraints.HORIZONTAL;
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0d;
            gbc.weighty = 0.0d;
            gbl.setConstraints( hScroll, gbc );
            // pictPianoRollをpanel1に追加
            gbc.fill = GridBagConstraints.BOTH;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.gridheight = 1;
            gbc.weightx = 1.0d;
            gbc.weighty = 1.0d;
            gbl.setConstraints( pictPianoRoll, gbc );
            // pictureBox3をpanel1に追加
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0d;
            gbc.weighty = 0.0d;
            gbl.setConstraints( pictureBox3, gbc );
            // trackBarをpanel1に追加
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0d;
            gbc.weighty = 0.0d;
            gbl.setConstraints( trackBar, gbc );
            // pictureBox2をpanel1に追加
            gbc.gridx = 3;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0d;
            gbc.weighty = 0.0d;
            gbl.setConstraints( pictureBox2, gbc );
            panel1.add( picturePositionIndicator );
            panel1.add( vScroll );
            panel1.add( hScroll );
            panel1.add( pictPianoRoll );
            panel1.add( pictureBox3 );
            panel1.add( trackBar );
            panel1.add( pictureBox2 );
            panel1.setName( "panel1" );
            // 
            // vScroll
            // 
            //vScroll.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
            //            | System.Windows.Forms.AnchorStyles.Right)));
            //vScroll.LargeChange = 10;
            vScroll.setLocation( 405, 48 );
            //vScroll.Margin = new System.Windows.Forms.Padding( 0 );
            vScroll.setMaximum( 100 );
            vScroll.setMinimum( 0 );
            vScroll.setName( "vScroll" );
            //vScroll.setSize( 16, 218 );
            //vScroll.SmallChange = 1;
            //vScroll.TabIndex = 17;
            vScroll.setValue( 0 );
            vScroll.setOrientation( JScrollBar.VERTICAL );
            //vScroll.ValueChanged += new System.EventHandler( vScroll_ValueChanged );
            //vScroll.Resize += new System.EventHandler( vScroll_Resize );
            //vScroll.Enter += new System.EventHandler( vScroll_Enter );
            // 
            // hScroll
            // 
            //hScroll.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
            //            | System.Windows.Forms.AnchorStyles.Right)));
            //hScroll.LargeChange = 10;
            //hScroll.setLocation( 66, 266 );
            //hScroll.Margin = new System.Windows.Forms.Padding( 0 );
            hScroll.setMaximum( 100 );
            hScroll.setMinimum( 0 );
            hScroll.setName( "hScroll" );
            //hScroll.SmallChange = 1;
            //hScroll.TabIndex = 16;
            hScroll.setValue( 0 );
            hScroll.setOrientation( JScrollBar.HORIZONTAL );
            //hScroll.ValueChanged += new System.EventHandler( hScroll_ValueChanged );
            //hScroll.Resize += new System.EventHandler( hScroll_Resize );
            //hScroll.Enter += new System.EventHandler( hScroll_Enter );
            // 
            // picturePositionIndicator
            // 
            //picturePositionIndicator.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
            //            | System.Windows.Forms.AnchorStyles.Right)));
            //picturePositionIndicator.BackColor = System.Drawing.Color.DarkGray;
            //picturePositionIndicator.Location = new System.Drawing.Point( 0, 0 );
            //picturePositionIndicator.Margin = new System.Windows.Forms.Padding( 0 );
            picturePositionIndicator.setName( "picturePositionIndicator" );
            picturePositionIndicator.setPreferredSize( new Dimension( 421, 48 ) );
            //picturePositionIndicator.TabIndex = 10;
            //picturePositionIndicator.TabStop = false;
            //picturePositionIndicator.MouseLeave += new System.EventHandler( picturePositionIndicator_MouseLeave );
            //picturePositionIndicator.PreviewKeyDown += new System.Windows.Forms.PreviewKeyDownEventHandler( picturePositionIndicator_PreviewKeyDown );
            //picturePositionIndicator.MouseMove += new System.Windows.Forms.MouseEventHandler( picturePositionIndicator_MouseMove );
            //picturePositionIndicator.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler( picturePositionIndicator_MouseDoubleClick );
            //picturePositionIndicator.MouseClick += new System.Windows.Forms.MouseEventHandler( picturePositionIndicator_MouseClick );
            //picturePositionIndicator.MouseDown += new System.Windows.Forms.MouseEventHandler( picturePositionIndicator_MouseDown );
            //picturePositionIndicator.Paint += new System.Windows.Forms.PaintEventHandler( picturePositionIndicator_Paint );
            // 
            // pictPianoRoll
            // 
            //pictPianoRoll.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
            //            | System.Windows.Forms.AnchorStyles.Left)
            //            | System.Windows.Forms.AnchorStyles.Right)));
            //pictPianoRoll.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(240)))), ((int)(((byte)(240)))), ((int)(((byte)(240)))) );
            //pictPianoRoll.Location = new System.Drawing.Point( 0, 48 );
            //pictPianoRoll.Margin = new System.Windows.Forms.Padding( 0 );
            //pictPianoRoll.MinimumSize = new System.Drawing.Size( 0, 100 );
            pictPianoRoll.setName( "pictPianoRoll" );
            //pictPianoRoll.Size = new System.Drawing.Size( 405, 218 );
            //pictPianoRoll.TabIndex = 12;
            //pictPianoRoll.TabStop = false;
            //pictPianoRoll.PreviewKeyDown += new System.Windows.Forms.PreviewKeyDownEventHandler( pictPianoRoll_PreviewKeyDown );
            //pictPianoRoll.BKeyUp += new System.Windows.Forms.KeyEventHandler( commonCaptureSpaceKeyUp );
            //pictPianoRoll.MouseMove += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseMove );
            //pictPianoRoll.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseDoubleClick );
            //pictPianoRoll.MouseClick += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseClick );
            //pictPianoRoll.MouseDown += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseDown );
            //pictPianoRoll.Paint += new System.Windows.Forms.PaintEventHandler( pictPianoRoll_Paint );
            //pictPianoRoll.MouseUp += new System.Windows.Forms.MouseEventHandler( pictPianoRoll_MouseUp );
            //pictPianoRoll.BKeyDown += new System.Windows.Forms.KeyEventHandler( commonCaptureSpaceKeyDown );
            // 
            // pictureBox3
            // 
            //pictureBox3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            //pictureBox3.BackColor = System.Drawing.SystemColors.Control;
            //pictureBox3.Location = new System.Drawing.Point( 0, 266 );
            //pictureBox3.Margin = new System.Windows.Forms.Padding( 0 );
            pictureBox3.setName( "pictureBox3" );
            pictureBox3.setPreferredSize( new Dimension( 66, 16 ) );
            //pictureBox3.TabIndex = 8;
            //pictureBox3.TabStop = false;
            //pictureBox3.MouseDown += new System.Windows.Forms.MouseEventHandler( pictureBox3_MouseDown );
            // 
            // pictureBox2
            // 
            //pictureBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            //pictureBox2.BackColor = System.Drawing.SystemColors.Control;
            //pictureBox2.Location = new System.Drawing.Point( 405, 266 );
            //pictureBox2.Margin = new System.Windows.Forms.Padding( 0 );
            pictureBox2.setName( "pictureBox2" );
            pictureBox2.setPreferredSize( new Dimension( 16, 16 ) );
            //pictureBox2.TabIndex = 5;
            //pictureBox2.TabStop = false;
            //pictureBox2.MouseDown += new System.Windows.Forms.MouseEventHandler( pictureBox2_MouseDown );
            // 
            // toolStripTool
            // 
            //toolStripTool.Dock = System.Windows.Forms.DockStyle.None;
            toolStripTool.add( stripBtnPointer );
            toolStripTool.add( stripBtnPencil );
            toolStripTool.add( stripBtnLine );
            toolStripTool.add( stripBtnEraser );
            toolStripTool.addSeparator();
            toolStripTool.add( stripBtnGrid );
            toolStripTool.add( stripBtnCurve );
            //toolStripTool.Location = new System.Drawing.Point( 3, 50 );
            toolStripTool.setName( "toolStripTool" );
            //toolStripTool.Size = new System.Drawing.Size( 379, 25 );
            //toolStripTool.TabIndex = 17;
            //toolStripTool.setText( "toolStrip1" );
            toolStripTool.setFloatable( true );
            // 
            // stripBtnPointer
            // 
            //stripBtnPointer.Checked = true;
            //stripBtnPointer.CheckState = System.Windows.Forms.CheckState.Checked;
            //stripBtnPointer.Image = global::Boare.Cadencii.Properties.Resources.arrow_135;
            //stripBtnPointer.ImageScaling = System.Windows.Forms.ToolStripItemImageScaling.None;
            //stripBtnPointer.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnPointer.setName( "stripBtnPointer" );
            //stripBtnPointer.Overflow = System.Windows.Forms.ToolStripItemOverflow.Never;
            //stripBtnPointer.Size = new System.Drawing.Size( 69, 22 );
            stripBtnPointer.setText( "Pointer" );
            //stripBtnPointer.Click += new System.EventHandler( stripBtnArrow_Click );
            // 
            // stripBtnPencil
            // 
            //stripBtnPencil.Image = global::Boare.Cadencii.Properties.Resources.pencil;
            //stripBtnPencil.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnPencil.setName( "stripBtnPencil" );
            //stripBtnPencil.Size = new System.Drawing.Size( 61, 22 );
            stripBtnPencil.setText( "Pencil" );
            //stripBtnPencil.Click += new System.EventHandler( stripBtnPencil_Click );
            // 
            // stripBtnLine
            // 
            //stripBtnLine.Image = global::Boare.Cadencii.Properties.Resources.layer_shape_line;
            //stripBtnLine.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnLine.setName( "stripBtnLine" );
            //stripBtnLine.Size = new System.Drawing.Size( 52, 22 );
            stripBtnLine.setText( "Line" );
            //stripBtnLine.Click += new System.EventHandler( stripBtnLine_Click );
            // 
            // stripBtnEraser
            // 
            //stripBtnEraser.Image = global::Boare.Cadencii.Properties.Resources.eraser;
            //stripBtnEraser.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnEraser.setName( "stripBtnEraser" );
            //stripBtnEraser.Size = new System.Drawing.Size( 65, 22 );
            stripBtnEraser.setText( "Eraser" );
            //stripBtnEraser.Click += new System.EventHandler( stripBtnEraser_Click );
            // 
            // stripBtnGrid
            // 
            //stripBtnGrid.CheckOnClick = true;
            //stripBtnGrid.Image = global::Boare.Cadencii.Properties.Resources.ruler_crop;
            //stripBtnGrid.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnGrid.setName( "stripBtnGrid" );
            //stripBtnGrid.Size = new System.Drawing.Size( 52, 22 );
            stripBtnGrid.setText( "Grid" );
            //stripBtnGrid.CheckedChanged += new System.EventHandler( stripBtnGrid_CheckedChanged );
            // 
            // stripBtnCurve
            // 
            //stripBtnCurve.CheckOnClick = true;
            //stripBtnCurve.Image = global::Boare.Cadencii.Properties.Resources.layer_shape_curve;
            //stripBtnCurve.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnCurve.setName( "stripBtnCurve" );
            //stripBtnCurve.Size = new System.Drawing.Size( 62, 22 );
            stripBtnCurve.setText( "Curve" );
            //stripBtnCurve.CheckedChanged += new System.EventHandler( stripBtnCurve_CheckedChanged );
            /*// 
            // toolStripContainer
            // 
            // 
            // toolStripContainer.BottomToolStripPanel
            // 
            toolStripContainer.BottomToolStripPanel.Controls.Add( toolStripBottom );
            toolStripContainer.BottomToolStripPanel.Controls.Add( statusStrip1 );*/
            // 
            // toolStripContainer.ContentPanel
            // 
            //toolStripContainer.ContentPanel.AutoScroll = true;
            //toolStripContainer.ContentPanel.Controls.Add( panel2 );
            getContentPane().add( splitContainer1, BorderLayout.CENTER );
            splitContainer2.setTopComponent( new JButton( "button1" ) );
            splitContainer2.setBottomComponent( new JButton( "button2" ) );
            splitContainer1.setTopComponent( panel1 );
            splitContainer1.setBottomComponent( splitContainer2 );
            //toolStripContainer.ContentPanel.Controls.Add( splitContainer2 );
            //toolStripContainer.ContentPanel.Controls.Add( splitContainer1 );
            /*toolStripContainer.ContentPanel.Size = new System.Drawing.Size( 962, 562 );
            toolStripContainer.Dock = System.Windows.Forms.DockStyle.Fill;
            toolStripContainer.LeftToolStripPanelVisible = false;
            toolStripContainer.Location = new System.Drawing.Point( 0, 26 );
            toolStripContainer.setName( "toolStripContainer";
            toolStripContainer.RightToolStripPanelVisible = false;
            toolStripContainer.Size = new System.Drawing.Size( 962, 734 );
            toolStripContainer.TabIndex = 18;
            toolStripContainer.setText( "toolStripContainer1";*/
            // 
            // toolStripContainer.TopToolStripPanel
            // 
            JPanel p = new JPanel();
            p.setLayout( new FlowLayout( FlowLayout.LEFT ) );
            p.add( toolStripPosition );
            p.add( toolStripTool );
            getContentPane().add( p, BorderLayout.NORTH );
            //getContentPane().add( toolStripPosition, BorderLayout.NORTH );
            //toolStripContainer.TopToolStripPanel.Controls.Add( toolStripMeasure );
            //getContentPane().add( toolStripTool, BorderLayout.NORTH );
            //toolStripContainer.TopToolStripPanel.Controls.Add( toolStripFile );
            //toolStripContainer.TopToolStripPanel.Controls.Add( toolStripPaletteTools );
            /*toolStripContainer.TopToolStripPanel.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            toolStripContainer.TopToolStripPanel.SizeChanged += new System.EventHandler( toolStripContainer_TopToolStripPanel_SizeChanged );
            // 
            // toolStripBottom
            // 
            toolStripBottom.Dock = System.Windows.Forms.DockStyle.None;
            toolStripBottom.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            toolStripLabel6,
            stripLblCursor,
            toolStripSeparator8,
            toolStripLabel8,
            stripLblTempo,
            toolStripSeparator9,
            toolStripLabel10,
            stripLblBeat,
            toolStripSeparator4,
            toolStripStatusLabel1,
            stripLblGameCtrlMode,
            toolStripSeparator10,
            toolStripStatusLabel2,
            stripLblMidiIn,
            toolStripSeparator11,
            stripDDBtnSpeed} );
            toolStripBottom.Location = new System.Drawing.Point( 5, 0 );
            toolStripBottom.setName( "toolStripBottom";
            toolStripBottom.Size = new System.Drawing.Size( 768, 25 );
            toolStripBottom.TabIndex = 22;
            // 
            // toolStripLabel6
            // 
            toolStripLabel6.setName( "toolStripLabel6";
            toolStripLabel6.Size = new System.Drawing.Size( 58, 22 );
            toolStripLabel6.setText( "CURSOR";
            // 
            // stripLblCursor
            // 
            stripLblCursor.AutoSize = false;
            stripLblCursor.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripLblCursor.Font = new System.Drawing.Font( "MS UI Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
            stripLblCursor.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripLblCursor.setName( "stripLblCursor";
            stripLblCursor.Size = new System.Drawing.Size( 90, 22 );
            stripLblCursor.setText( "0 : 0 : 000";
            // 
            // toolStripSeparator8
            // 
            toolStripSeparator8.setName( "toolStripSeparator8";
            toolStripSeparator8.Size = new System.Drawing.Size( 6, 25 );
            // 
            // toolStripLabel8
            // 
            toolStripLabel8.setName( "toolStripLabel8";
            toolStripLabel8.Size = new System.Drawing.Size( 49, 22 );
            toolStripLabel8.setText( "TEMPO";
            // 
            // stripLblTempo
            // 
            stripLblTempo.AutoSize = false;
            stripLblTempo.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripLblTempo.Font = new System.Drawing.Font( "MS UI Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
            stripLblTempo.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripLblTempo.setName( "stripLblTempo";
            stripLblTempo.Size = new System.Drawing.Size( 60, 22 );
            stripLblTempo.setText( "120.00";
            // 
            // toolStripSeparator9
            // 
            toolStripSeparator9.setName( "toolStripSeparator9";
            toolStripSeparator9.Size = new System.Drawing.Size( 6, 25 );
            // 
            // toolStripLabel10
            // 
            toolStripLabel10.setName( "toolStripLabel10";
            toolStripLabel10.Size = new System.Drawing.Size( 38, 22 );
            toolStripLabel10.setText( "BEAT";
            // 
            // stripLblBeat
            // 
            stripLblBeat.AutoSize = false;
            stripLblBeat.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripLblBeat.Font = new System.Drawing.Font( "MS UI Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
            stripLblBeat.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripLblBeat.setName( "stripLblBeat";
            stripLblBeat.Size = new System.Drawing.Size( 45, 22 );
            stripLblBeat.setText( "4/4";
            // 
            // toolStripSeparator4
            // 
            toolStripSeparator4.setName( "toolStripSeparator4";
            toolStripSeparator4.Size = new System.Drawing.Size( 6, 25 );
            // 
            // toolStripStatusLabel1
            // 
            toolStripStatusLabel1.setName( "toolStripStatusLabel1";
            toolStripStatusLabel1.Size = new System.Drawing.Size( 101, 20 );
            toolStripStatusLabel1.setText( "Game Controler";
            // 
            // stripLblGameCtrlMode
            // 
            stripLblGameCtrlMode.Image = global::Boare.Cadencii.Properties.Resources.slash;
            stripLblGameCtrlMode.setName( "stripLblGameCtrlMode";
            stripLblGameCtrlMode.Size = new System.Drawing.Size( 73, 20 );
            stripLblGameCtrlMode.setText( "Disabled";
            stripLblGameCtrlMode.ToolTipText = "Game Controler";
            // 
            // toolStripSeparator10
            // 
            toolStripSeparator10.setName( "toolStripSeparator10";
            toolStripSeparator10.Size = new System.Drawing.Size( 6, 25 );
            // 
            // toolStripStatusLabel2
            // 
            toolStripStatusLabel2.setName( "toolStripStatusLabel2";
            toolStripStatusLabel2.Size = new System.Drawing.Size( 53, 20 );
            toolStripStatusLabel2.setText( "MIDI In";
            // 
            // stripLblMidiIn
            // 
            stripLblMidiIn.Image = global::Boare.Cadencii.Properties.Resources.slash;
            stripLblMidiIn.setName( "stripLblMidiIn";
            stripLblMidiIn.Size = new System.Drawing.Size( 73, 20 );
            stripLblMidiIn.setText( "Disabled";
            stripLblMidiIn.ToolTipText = "Midi In Device";
            // 
            // toolStripSeparator11
            // 
            toolStripSeparator11.setName( "toolStripSeparator11";
            toolStripSeparator11.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripDDBtnSpeed
            // 
            stripDDBtnSpeed.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripDDBtnSpeed.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            stripDDBtnSpeedTextbox,
            stripDDBtnSpeed033,
            stripDDBtnSpeed050,
            stripDDBtnSpeed100} );
            stripDDBtnSpeed.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripDDBtnSpeed.setName( "stripDDBtnSpeed";
            stripDDBtnSpeed.Size = new System.Drawing.Size( 86, 22 );
            stripDDBtnSpeed.setText( "Speed 1.0x";
            stripDDBtnSpeed.DropDownOpening += new System.EventHandler( stripDDBtnSpeed_DropDownOpening );
            // 
            // stripDDBtnSpeedTextbox
            // 
            stripDDBtnSpeedTextbox.setName( "stripDDBtnSpeedTextbox";
            stripDDBtnSpeedTextbox.Size = new System.Drawing.Size( 100, 25 );
            stripDDBtnSpeedTextbox.setText( "100";
            stripDDBtnSpeedTextbox.KeyDown += new System.Windows.Forms.KeyEventHandler( stripDDBtnSpeedTextbox_KeyDown );
            // 
            // stripDDBtnSpeed033
            // 
            stripDDBtnSpeed033.setName( "stripDDBtnSpeed033";
            stripDDBtnSpeed033.Size = new System.Drawing.Size( 160, 22 );
            stripDDBtnSpeed033.setText( "33.3%";
            stripDDBtnSpeed033.Click += new System.EventHandler( stripDDBtnSpeed033_Click );
            // 
            // stripDDBtnSpeed050
            // 
            stripDDBtnSpeed050.setName( "stripDDBtnSpeed050";
            stripDDBtnSpeed050.Size = new System.Drawing.Size( 160, 22 );
            stripDDBtnSpeed050.setText( "50%";
            stripDDBtnSpeed050.Click += new System.EventHandler( stripDDBtnSpeed050_Click );
            // 
            // stripDDBtnSpeed100
            // 
            stripDDBtnSpeed100.setName( "stripDDBtnSpeed100";
            stripDDBtnSpeed100.Size = new System.Drawing.Size( 160, 22 );
            stripDDBtnSpeed100.setText( "100%";
            stripDDBtnSpeed100.Click += new System.EventHandler( stripDDBtnSpeed100_Click );
            // 
            // statusStrip1
            // 
            statusStrip1.Dock = System.Windows.Forms.DockStyle.None;
            statusStrip1.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            statusLabel} );
            statusStrip1.Location = new System.Drawing.Point( 0, 25 );
            statusStrip1.setName( "statusStrip1";
            statusStrip1.RenderMode = System.Windows.Forms.ToolStripRenderMode.ManagerRenderMode;
            statusStrip1.Size = new System.Drawing.Size( 962, 22 );
            statusStrip1.TabIndex = 17;
            statusStrip1.setText( "statusStrip1";*/
            // 
            // statusLabel
            // 
            statusLabel.setName( "statusLabel" );
            statusLabel.setText( " " );
            Panel panelForStatusLabel = new Panel();
            panelForStatusLabel.setLayout( new BoxLayout( panelForStatusLabel, BoxLayout.X_AXIS ) );
            panelForStatusLabel.add( statusLabel );
            getContentPane().add( panelForStatusLabel, BorderLayout.SOUTH );
            /* // 
            // panel2
            // 
            panel2.BackColor = System.Drawing.Color.DarkGray;
            panel2.Controls.Add( waveView );
            panel2.Location = new System.Drawing.Point( 3, 291 );
            panel2.setName( "panel2";
            panel2.Size = new System.Drawing.Size( 421, 59 );
            panel2.TabIndex = 19;
            // 
            // waveView
            // 
            waveView.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            waveView.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(212)))), ((int)(((byte)(212)))), ((int)(((byte)(212)))) );
            waveView.Location = new System.Drawing.Point( 66, 0 );
            waveView.Margin = new System.Windows.Forms.Padding( 0 );
            waveView.setName( "waveView";
            waveView.Size = new System.Drawing.Size( 355, 59 );
            waveView.TabIndex = 17;
            // 
            // splitContainer2
            // 
            splitContainer2.FixedPanel = System.Windows.Forms.FixedPanel.Panel2;
            splitContainer2.IsSplitterFixed = false;
            splitContainer2.Location = new System.Drawing.Point( 606, 17 );
            splitContainer2.setName( "splitContainer2";
            splitContainer2.Orientation = System.Windows.Forms.Orientation.Vertical;
            // 
            // 
            // 
            splitContainer2.Panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            splitContainer2.Panel1.BorderColor = System.Drawing.Color.Black;
            splitContainer2.Panel1.Location = new System.Drawing.Point( 0, 0 );
            splitContainer2.Panel1.Margin = new System.Windows.Forms.Padding( 0, 0, 0, 4 );
            splitContainer2.Panel1.setName( "m_panel1";
            splitContainer2.Panel1.Size = new System.Drawing.Size( 115, 53 );
            splitContainer2.Panel1.TabIndex = 0;
            splitContainer2.Panel1MinSize = 25;
            // 
            // 
            // 
            splitContainer2.Panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            splitContainer2.Panel2.BorderColor = System.Drawing.Color.Black;
            splitContainer2.Panel2.Location = new System.Drawing.Point( 0, 57 );
            splitContainer2.Panel2.Margin = new System.Windows.Forms.Padding( 0 );
            splitContainer2.Panel2.setName( "m_panel2";
            splitContainer2.Panel2.Size = new System.Drawing.Size( 115, 185 );
            splitContainer2.Panel2.TabIndex = 1;
            splitContainer2.Panel2MinSize = 25;
            splitContainer2.Size = new System.Drawing.Size( 115, 242 );
            splitContainer2.SplitterDistance = 53;
            splitContainer2.SplitterWidth = 4;
            splitContainer2.TabIndex = 18;
            splitContainer2.setText( "bSplitContainer1";
            // 
            // splitContainer1
            // 
            splitContainer1.FixedPanel = System.Windows.Forms.FixedPanel.Panel2;
            splitContainer1.IsSplitterFixed = false;
            splitContainer1.Location = new System.Drawing.Point( 440, 17 );
            splitContainer1.MinimumSize = new System.Drawing.Size( 0, 54 );
            splitContainer1.setName( "splitContainer1";
            splitContainer1.Orientation = System.Windows.Forms.Orientation.Vertical;
            // 
            // 
            // 
            splitContainer1.Panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            splitContainer1.Panel1.BorderColor = System.Drawing.Color.Black;
            splitContainer1.Panel1.Location = new System.Drawing.Point( 0, 0 );
            splitContainer1.Panel1.Margin = new System.Windows.Forms.Padding( 0, 0, 0, 4 );
            splitContainer1.Panel1.setName( "m_panel1";
            splitContainer1.Panel1.Size = new System.Drawing.Size( 138, 27 );
            splitContainer1.Panel1.TabIndex = 0;
            splitContainer1.Panel1MinSize = 25;
            // 
            // 
            // 
            splitContainer1.Panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            splitContainer1.Panel2.BorderColor = System.Drawing.Color.Black;
            splitContainer1.Panel2.Location = new System.Drawing.Point( 0, 31 );
            splitContainer1.Panel2.Margin = new System.Windows.Forms.Padding( 0 );
            splitContainer1.Panel2.setName( "m_panel2";
            splitContainer1.Panel2.Size = new System.Drawing.Size( 138, 211 );
            splitContainer1.Panel2.TabIndex = 1;
            splitContainer1.Panel2MinSize = 25;
            splitContainer1.Size = new System.Drawing.Size( 138, 242 );
            splitContainer1.SplitterDistance = 27;
            splitContainer1.SplitterWidth = 4;
            splitContainer1.TabIndex = 4;
            splitContainer1.setText( "splitContainerEx1";*/
            // 
            // toolStripPosition
            // 
            toolStripPosition.add( stripBtnMoveTop );
            toolStripPosition.add( stripBtnRewind );
            toolStripPosition.add( stripBtnForward );
            toolStripPosition.add( stripBtnMoveEnd );
            toolStripPosition.add( stripBtnPlay );
            toolStripPosition.add( stripBtnStop );
            toolStripPosition.addSeparator();
            toolStripPosition.add( stripBtnScroll );
            toolStripPosition.add( stripBtnLoop );
            //toolStripPosition.Location = new System.Drawing.Point( 3, 0 );
            toolStripPosition.setName( "toolStripPosition" );
            //toolStripPosition.Size = new System.Drawing.Size( 202, 25 );
            //toolStripPosition.TabIndex = 18;
            // 
            // stripBtnMoveTop
            // 
            //stripBtnMoveTop.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnMoveTop.Image = global::Boare.Cadencii.Properties.Resources.control_stop_180;
            //stripBtnMoveTop.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnMoveTop.setName( "stripBtnMoveTop" );
            //stripBtnMoveTop.Size = new System.Drawing.Size( 23, 22 );
            stripBtnMoveTop.setText( "  <=|  " );
            //stripBtnMoveTop.ToolTipText = "MoveTop";
            //stripBtnMoveTop.Click += new System.EventHandler( stripBtnMoveTop_Click );
            // 
            // stripBtnRewind
            // 
            //stripBtnRewind.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnRewind.Image = global::Boare.Cadencii.Properties.Resources.control_double_180;
            //stripBtnRewind.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnRewind.setName( "stripBtnRewind" );
            //stripBtnRewind.Size = new System.Drawing.Size( 23, 22 );
            stripBtnRewind.setText( "  <<  " );
            //stripBtnRewind.ToolTipText = "Rewind";
            //stripBtnRewind.Click += new System.EventHandler( stripBtnRewind_Click );
            // 
            // stripBtnForward
            // 
            //stripBtnForward.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnForward.Image = global::Boare.Cadencii.Properties.Resources.control_double;
            //stripBtnForward.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnForward.setName( "stripBtnForward" );
            //stripBtnForward.Size = new System.Drawing.Size( 23, 22 );
            stripBtnForward.setText( "  >>  " );
            //stripBtnForward.ToolTipText = "Forward";
            //stripBtnForward.Click += new System.EventHandler( stripBtnForward_Click );
            // 
            // stripBtnMoveEnd
            // 
            //stripBtnMoveEnd.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnMoveEnd.Image = global::Boare.Cadencii.Properties.Resources.control_stop;
            //stripBtnMoveEnd.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnMoveEnd.setName( "stripBtnMoveEnd" );
            //stripBtnMoveEnd.Size = new System.Drawing.Size( 23, 22 );
            stripBtnMoveEnd.setText( "  |=>  " );
            //stripBtnMoveEnd.ToolTipText = "MoveEnd";
            //stripBtnMoveEnd.Click += new System.EventHandler( stripBtnMoveEnd_Click );
            // 
            // stripBtnPlay
            // 
            //stripBtnPlay.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnPlay.Image = global::Boare.Cadencii.Properties.Resources.control;
            //stripBtnPlay.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnPlay.setName( "stripBtnPlay" );
            //stripBtnPlay.Size = new System.Drawing.Size( 23, 22 );
            stripBtnPlay.setText( "  =>  " );
            //stripBtnPlay.ToolTipText = "Play";
            //stripBtnPlay.Click += new System.EventHandler( stripBtnPlay_Click );
            // 
            // stripBtnStop
            // 
            //stripBtnStop.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnStop.Image = global::Boare.Cadencii.Properties.Resources.control_pause;
            //stripBtnStop.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnStop.setName( "stripBtnStop" );
            //stripBtnStop.Size = new System.Drawing.Size( 23, 22 );
            stripBtnStop.setText( "   ||   " );
            //stripBtnStop.ToolTipText = "Stop";
            //stripBtnStop.Click += new System.EventHandler( stripBtnStop_Click );
            // 
            // stripBtnScroll
            // 
            //stripBtnScroll.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnScroll.Image = global::Boare.Cadencii.Properties.Resources.arrow_circle_double;
            //stripBtnScroll.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnScroll.setName( "stripBtnScroll" );
            //stripBtnScroll.Size = new System.Drawing.Size( 23, 22 );
            stripBtnScroll.setText( "Scroll" );
            //stripBtnScroll.Click += new System.EventHandler( stripBtnScroll_Click );
            // 
            // stripBtnLoop
            // 
            //stripBtnLoop.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            //stripBtnLoop.Image = global::Boare.Cadencii.Properties.Resources.arrow_return;
            //stripBtnLoop.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnLoop.setName( "stripBtnLoop" );
            //stripBtnLoop.Size = new System.Drawing.Size( 23, 22 );
            stripBtnLoop.setText( "Loop" );
            //stripBtnLoop.Click += new System.EventHandler( stripBtnLoop_Click );
            /* // 
            // toolStripMeasure
            // 
            toolStripMeasure.Dock = System.Windows.Forms.DockStyle.None;
            toolStripMeasure.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            toolStripLabel5,
            stripLblMeasure,
            toolStripButton1,
            stripDDBtnLength,
            stripDDBtnQuantize,
            toolStripSeparator6,
            stripBtnStartMarker,
            stripBtnEndMarker} );
            toolStripMeasure.Location = new System.Drawing.Point( 3, 25 );
            toolStripMeasure.setName( "toolStripMeasure";
            toolStripMeasure.Size = new System.Drawing.Size( 430, 25 );
            toolStripMeasure.TabIndex = 19;
            // 
            // toolStripLabel5
            // 
            toolStripLabel5.setName( "toolStripLabel5";
            toolStripLabel5.Size = new System.Drawing.Size( 65, 22 );
            toolStripLabel5.setText( "MEASURE";
            // 
            // stripLblMeasure
            // 
            stripLblMeasure.AutoSize = false;
            stripLblMeasure.Font = new System.Drawing.Font( "MS UI Gothic", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(128)) );
            stripLblMeasure.setName( "stripLblMeasure";
            stripLblMeasure.Size = new System.Drawing.Size( 90, 22 );
            stripLblMeasure.setText( "0 : 0 : 000";
            stripLblMeasure.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // toolStripButton1
            // 
            toolStripButton1.setName( "toolStripButton1";
            toolStripButton1.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripDDBtnLength
            // 
            stripDDBtnLength.AutoSize = false;
            stripDDBtnLength.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripDDBtnLength.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            stripDDBtnLength04,
            stripDDBtnLength08,
            stripDDBtnLength16,
            stripDDBtnLength32,
            stripDDBtnLength64,
            stripDDBtnLength128,
            stripDDBtnLengthOff,
            toolStripSeparator2,
            stripDDBtnLengthTriplet} );
            stripDDBtnLength.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripDDBtnLength.setName( "stripDDBtnLength";
            stripDDBtnLength.Size = new System.Drawing.Size( 95, 22 );
            stripDDBtnLength.setText( "LENGTH  1/64";
            stripDDBtnLength.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // stripDDBtnLength04
            // 
            stripDDBtnLength04.setName( "stripDDBtnLength04";
            stripDDBtnLength04.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength04.setText( "1/4";
            stripDDBtnLength04.Click += new System.EventHandler( h_lengthQuantize04 );
            // 
            // stripDDBtnLength08
            // 
            stripDDBtnLength08.setName( "stripDDBtnLength08";
            stripDDBtnLength08.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength08.setText( "1/8";
            stripDDBtnLength08.Click += new System.EventHandler( h_lengthQuantize08 );
            // 
            // stripDDBtnLength16
            // 
            stripDDBtnLength16.setName( "stripDDBtnLength16";
            stripDDBtnLength16.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength16.setText( "1/16";
            stripDDBtnLength16.Click += new System.EventHandler( h_lengthQuantize16 );
            // 
            // stripDDBtnLength32
            // 
            stripDDBtnLength32.setName( "stripDDBtnLength32";
            stripDDBtnLength32.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength32.setText( "1/32";
            stripDDBtnLength32.Click += new System.EventHandler( h_lengthQuantize32 );
            // 
            // stripDDBtnLength64
            // 
            stripDDBtnLength64.setName( "stripDDBtnLength64";
            stripDDBtnLength64.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength64.setText( "1/64";
            stripDDBtnLength64.Click += new System.EventHandler( h_lengthQuantize64 );
            // 
            // stripDDBtnLength128
            // 
            stripDDBtnLength128.setName( "stripDDBtnLength128";
            stripDDBtnLength128.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLength128.setText( "1/128";
            stripDDBtnLength128.Click += new System.EventHandler( h_lengthQuantize128 );
            // 
            // stripDDBtnLengthOff
            // 
            stripDDBtnLengthOff.setName( "stripDDBtnLengthOff";
            stripDDBtnLengthOff.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLengthOff.setText( "Off";
            stripDDBtnLengthOff.Click += new System.EventHandler( h_lengthQuantizeOff );
            // 
            // toolStripSeparator2
            // 
            toolStripSeparator2.setName( "toolStripSeparator2";
            toolStripSeparator2.Size = new System.Drawing.Size( 110, 6 );
            // 
            // stripDDBtnLengthTriplet
            // 
            stripDDBtnLengthTriplet.setName( "stripDDBtnLengthTriplet";
            stripDDBtnLengthTriplet.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnLengthTriplet.setText( "Triplet";
            stripDDBtnLengthTriplet.Click += new System.EventHandler( h_lengthQuantizeTriplet );
            // 
            // stripDDBtnQuantize
            // 
            stripDDBtnQuantize.AutoSize = false;
            stripDDBtnQuantize.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            stripDDBtnQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            stripDDBtnQuantize04,
            stripDDBtnQuantize08,
            stripDDBtnQuantize16,
            stripDDBtnQuantize32,
            stripDDBtnQuantize64,
            stripDDBtnQuantize128,
            stripDDBtnQuantizeOff,
            toolStripSeparator3,
            stripDDBtnQuantizeTriplet} );
            stripDDBtnQuantize.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripDDBtnQuantize.setName( "stripDDBtnQuantize";
            stripDDBtnQuantize.Size = new System.Drawing.Size( 110, 22 );
            stripDDBtnQuantize.setText( "QUANTIZE  1/64";
            stripDDBtnQuantize.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // stripDDBtnQuantize04
            // 
            stripDDBtnQuantize04.setName( "stripDDBtnQuantize04";
            stripDDBtnQuantize04.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize04.setText( "1/4";
            stripDDBtnQuantize04.Click += new System.EventHandler( h_positionQuantize04 );
            // 
            // stripDDBtnQuantize08
            // 
            stripDDBtnQuantize08.setName( "stripDDBtnQuantize08";
            stripDDBtnQuantize08.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize08.setText( "1/8";
            stripDDBtnQuantize08.Click += new System.EventHandler( h_positionQuantize08 );
            // 
            // stripDDBtnQuantize16
            // 
            stripDDBtnQuantize16.setName( "stripDDBtnQuantize16";
            stripDDBtnQuantize16.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize16.setText( "1/16";
            stripDDBtnQuantize16.Click += new System.EventHandler( h_positionQuantize16 );
            // 
            // stripDDBtnQuantize32
            // 
            stripDDBtnQuantize32.setName( "stripDDBtnQuantize32";
            stripDDBtnQuantize32.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize32.setText( "1/32";
            stripDDBtnQuantize32.Click += new System.EventHandler( h_positionQuantize32 );
            // 
            // stripDDBtnQuantize64
            // 
            stripDDBtnQuantize64.setName( "stripDDBtnQuantize64";
            stripDDBtnQuantize64.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize64.setText( "1/64";
            stripDDBtnQuantize64.Click += new System.EventHandler( h_positionQuantize64 );
            // 
            // stripDDBtnQuantize128
            // 
            stripDDBtnQuantize128.setName( "stripDDBtnQuantize128";
            stripDDBtnQuantize128.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantize128.setText( "1/128";
            stripDDBtnQuantize128.Click += new System.EventHandler( h_positionQuantize128 );
            // 
            // stripDDBtnQuantizeOff
            // 
            stripDDBtnQuantizeOff.setName( "stripDDBtnQuantizeOff";
            stripDDBtnQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantizeOff.setText( "Off";
            stripDDBtnQuantizeOff.Click += new System.EventHandler( h_positionQuantizeOff );
            // 
            // toolStripSeparator3
            // 
            toolStripSeparator3.setName( "toolStripSeparator3";
            toolStripSeparator3.Size = new System.Drawing.Size( 110, 6 );
            // 
            // stripDDBtnQuantizeTriplet
            // 
            stripDDBtnQuantizeTriplet.setName( "stripDDBtnQuantizeTriplet";
            stripDDBtnQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            stripDDBtnQuantizeTriplet.setText( "Triplet";
            stripDDBtnQuantizeTriplet.Click += new System.EventHandler( h_positionQuantizeTriplet );
            // 
            // toolStripSeparator6
            // 
            toolStripSeparator6.setName( "toolStripSeparator6";
            toolStripSeparator6.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripBtnStartMarker
            // 
            stripBtnStartMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnStartMarker.Image = global::Boare.Cadencii.Properties.Resources.pin__arrow;
            stripBtnStartMarker.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnStartMarker.setName( "stripBtnStartMarker";
            stripBtnStartMarker.Size = new System.Drawing.Size( 23, 22 );
            stripBtnStartMarker.setText( "StartMarker";
            stripBtnStartMarker.Click += new System.EventHandler( stripBtnStartMarker_Click );
            // 
            // stripBtnEndMarker
            // 
            stripBtnEndMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnEndMarker.Image = global::Boare.Cadencii.Properties.Resources.pin__arrow_inv;
            stripBtnEndMarker.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnEndMarker.setName( "stripBtnEndMarker";
            stripBtnEndMarker.Size = new System.Drawing.Size( 23, 22 );
            stripBtnEndMarker.setText( "EndMarker";
            stripBtnEndMarker.Click += new System.EventHandler( stripBtnEndMarker_Click );
            // 
            // toolStripFile
            // 
            toolStripFile.Dock = System.Windows.Forms.DockStyle.None;
            toolStripFile.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            stripBtnFileNew,
            stripBtnFileOpen,
            stripBtnFileSave,
            toolStripSeparator12,
            stripBtnCut,
            stripBtnCopy,
            stripBtnPaste,
            toolStripSeparator13,
            stripBtnUndo,
            stripBtnRedo} );
            toolStripFile.Location = new System.Drawing.Point( 3, 75 );
            toolStripFile.setName( "toolStripFile";
            toolStripFile.Size = new System.Drawing.Size( 208, 25 );
            toolStripFile.TabIndex = 20;
            // 
            // stripBtnFileNew
            // 
            stripBtnFileNew.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnFileNew.Image = global::Boare.Cadencii.Properties.Resources.disk__plus;
            stripBtnFileNew.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnFileNew.setName( "stripBtnFileNew";
            stripBtnFileNew.Size = new System.Drawing.Size( 23, 22 );
            stripBtnFileNew.setText( "toolStripButton6";
            stripBtnFileNew.ToolTipText = "New";
            stripBtnFileNew.Click += new System.EventHandler( commonFileNew_Click );
            // 
            // stripBtnFileOpen
            // 
            stripBtnFileOpen.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnFileOpen.Image = global::Boare.Cadencii.Properties.Resources.folder_horizontal_open;
            stripBtnFileOpen.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnFileOpen.setName( "stripBtnFileOpen";
            stripBtnFileOpen.Size = new System.Drawing.Size( 23, 22 );
            stripBtnFileOpen.setText( "toolStripButton3";
            stripBtnFileOpen.ToolTipText = "Open";
            stripBtnFileOpen.Click += new System.EventHandler( commonFileOpen_Click );
            // 
            // stripBtnFileSave
            // 
            stripBtnFileSave.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnFileSave.Image = global::Boare.Cadencii.Properties.Resources.disk;
            stripBtnFileSave.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnFileSave.setName( "stripBtnFileSave";
            stripBtnFileSave.Size = new System.Drawing.Size( 23, 22 );
            stripBtnFileSave.setText( "toolStripButton2";
            stripBtnFileSave.ToolTipText = "Save";
            stripBtnFileSave.Click += new System.EventHandler( commonFileSave_Click );
            // 
            // toolStripSeparator12
            // 
            toolStripSeparator12.setName( "toolStripSeparator12";
            toolStripSeparator12.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripBtnCut
            // 
            stripBtnCut.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnCut.Image = global::Boare.Cadencii.Properties.Resources.scissors;
            stripBtnCut.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnCut.setName( "stripBtnCut";
            stripBtnCut.Size = new System.Drawing.Size( 23, 22 );
            stripBtnCut.setText( "toolStripButton4";
            stripBtnCut.ToolTipText = "Cut";
            stripBtnCut.Click += new System.EventHandler( commonEditCut_Click );
            // 
            // stripBtnCopy
            // 
            stripBtnCopy.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnCopy.Image = global::Boare.Cadencii.Properties.Resources.documents;
            stripBtnCopy.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnCopy.setName( "stripBtnCopy";
            stripBtnCopy.Size = new System.Drawing.Size( 23, 22 );
            stripBtnCopy.setText( "toolStripButton5";
            stripBtnCopy.ToolTipText = "Copy";
            stripBtnCopy.Click += new System.EventHandler( commonEditCopy_Click );
            // 
            // stripBtnPaste
            // 
            stripBtnPaste.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnPaste.Image = global::Boare.Cadencii.Properties.Resources.clipboard_paste;
            stripBtnPaste.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnPaste.setName( "stripBtnPaste";
            stripBtnPaste.Size = new System.Drawing.Size( 23, 22 );
            stripBtnPaste.setText( "toolStripLabel1";
            stripBtnPaste.ToolTipText = "Paste";
            stripBtnPaste.Click += new System.EventHandler( commonEditPaste_Click );
            // 
            // toolStripSeparator13
            // 
            toolStripSeparator13.setName( "toolStripSeparator13";
            toolStripSeparator13.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripBtnUndo
            // 
            stripBtnUndo.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnUndo.Image = global::Boare.Cadencii.Properties.Resources.arrow_skip_180;
            stripBtnUndo.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnUndo.setName( "stripBtnUndo";
            stripBtnUndo.Size = new System.Drawing.Size( 23, 22 );
            stripBtnUndo.setText( "toolStripButton7";
            stripBtnUndo.ToolTipText = "Undo";
            stripBtnUndo.Click += new System.EventHandler( commonEditUndo_Click );
            // 
            // stripBtnRedo
            // 
            stripBtnRedo.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            stripBtnRedo.Image = global::Boare.Cadencii.Properties.Resources.arrow_skip;
            stripBtnRedo.ImageTransparentColor = System.Drawing.Color.Magenta;
            stripBtnRedo.setName( "stripBtnRedo";
            stripBtnRedo.Size = new System.Drawing.Size( 23, 22 );
            stripBtnRedo.setText( "toolStripButton8";
            stripBtnRedo.ToolTipText = "Redo";
            stripBtnRedo.Click += new System.EventHandler( commonEditRedo_Click );
            // 
            // toolStripPaletteTools
            // 
            toolStripPaletteTools.Dock = System.Windows.Forms.DockStyle.None;
            toolStripPaletteTools.Location = new System.Drawing.Point( 3, 100 );
            toolStripPaletteTools.setName( "toolStripPaletteTools";
            toolStripPaletteTools.Size = new System.Drawing.Size( 111, 25 );
            toolStripPaletteTools.TabIndex = 21;
            // 
            // openUstDialog
            // 
            openUstDialog.Filter = "UTAU Project File(*.ust)|*.ust|All Files(*.*)|*.*";
            // 
            // FormMain
            // 
            AutoScaleDimensions = new System.Drawing.SizeF( 6F, 12F );
            AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            BackColor = System.Drawing.SystemColors.Control;
            ClientSize = new System.Drawing.Size( 962, 760 );
            Controls.Add( toolStripContainer );*/
            setJMenuBar( menuStripMain );
            /*Icon = ((System.Drawing.Icon)(resources.GetObject( "$Icon" )));
            KeyPreview = true;
            MainMenuStrip = menuStripMain;
            setName( "FormMain";
            setText( "Cadencii";
            Deactivate += new System.EventHandler( FormMain_Deactivate );
            Load += new System.EventHandler( FormMain_Load );
            Activated += new System.EventHandler( FormMain_Activated );
            FormClosed += new System.Windows.Forms.FormClosedEventHandler( FormMain_FormClosed );
            FormClosing += new System.Windows.Forms.FormClosingEventHandler( FormMain_FormClosing );
            PreviewKeyDown += new System.Windows.Forms.PreviewKeyDownEventHandler( FormMain_PreviewKeyDown );
            menuStripMain.ResumeLayout( false );
            menuStripMain.PerformLayout();
            cMenuPiano.ResumeLayout( false );
            cMenuTrackTab.ResumeLayout( false );
            cMenuTrackSelector.ResumeLayout( false );
            ((System.ComponentModel.ISupportInitialize)(trackBar)).EndInit();
            panel1.ResumeLayout( false );
            ((System.ComponentModel.ISupportInitialize)(picturePositionIndicator)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(pictPianoRoll)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(pictureBox3)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(pictureBox2)).EndInit();
            toolStripTool.ResumeLayout( false );
            toolStripTool.PerformLayout();
            toolStripContainer.BottomToolStripPanel.ResumeLayout( false );
            toolStripContainer.BottomToolStripPanel.PerformLayout();
            toolStripContainer.ContentPanel.ResumeLayout( false );
            toolStripContainer.TopToolStripPanel.ResumeLayout( false );
            toolStripContainer.TopToolStripPanel.PerformLayout();
            toolStripContainer.ResumeLayout( false );
            toolStripContainer.PerformLayout();
            toolStripBottom.ResumeLayout( false );
            toolStripBottom.PerformLayout();
            statusStrip1.ResumeLayout( false );
            statusStrip1.PerformLayout();
            panel2.ResumeLayout( false );
            toolStripPosition.ResumeLayout( false );
            toolStripPosition.PerformLayout();
            toolStripMeasure.ResumeLayout( false );
            toolStripMeasure.PerformLayout();
            toolStripFile.ResumeLayout( false );
            toolStripFile.PerformLayout();
            ResumeLayout( false );
            PerformLayout();*/

            try{
                //UIManager.setLookAndFeel( "com.sun.java.swing.plaf.mac.MacLookAndFeel" );
                //UIManager.setLookAndFeel( "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" );
    		    //SwingUtilities.updateComponentTreeUI( this );
            }catch( Exception ex ){
            }
        }
        #endregion
#else
        #region UI Impl for C#
        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
        protected override void Dispose( boolean disposing ) {
            if ( disposing && (components != null) ) {
                components.Dispose();
            }
            base.Dispose( disposing );
        }

        #region Windows フォーム デザイナで生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent() {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( FormMain ) );
            this.menuStripMain = new bocoree.windows.forms.BMenuBar();
            this.menuFile = new bocoree.windows.forms.BMenuItem();
            this.menuFileNew = new bocoree.windows.forms.BMenuItem();
            this.menuFileOpen = new bocoree.windows.forms.BMenuItem();
            this.menuFileSave = new bocoree.windows.forms.BMenuItem();
            this.menuFileSaveNamed = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem10 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileOpenVsq = new bocoree.windows.forms.BMenuItem();
            this.menuFileOpenUst = new bocoree.windows.forms.BMenuItem();
            this.menuFileImport = new bocoree.windows.forms.BMenuItem();
            this.menuFileImportVsq = new bocoree.windows.forms.BMenuItem();
            this.menuFileImportMidi = new bocoree.windows.forms.BMenuItem();
            this.menuFileExport = new bocoree.windows.forms.BMenuItem();
            this.menuFileExportWave = new bocoree.windows.forms.BMenuItem();
            this.menuFileExportMidi = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem11 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileRecent = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem12 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileQuit = new bocoree.windows.forms.BMenuItem();
            this.menuEdit = new bocoree.windows.forms.BMenuItem();
            this.menuEditUndo = new bocoree.windows.forms.BMenuItem();
            this.menuEditRedo = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem5 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditCut = new bocoree.windows.forms.BMenuItem();
            this.menuEditCopy = new bocoree.windows.forms.BMenuItem();
            this.menuEditPaste = new bocoree.windows.forms.BMenuItem();
            this.menuEditDelete = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem19 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditAutoNormalizeMode = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem20 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditSelectAll = new bocoree.windows.forms.BMenuItem();
            this.menuEditSelectAllEvents = new bocoree.windows.forms.BMenuItem();
            this.menuVisual = new bocoree.windows.forms.BMenuItem();
            this.menuVisualControlTrack = new bocoree.windows.forms.BMenuItem();
            this.menuVisualMixer = new bocoree.windows.forms.BMenuItem();
            this.menuVisualWaveform = new bocoree.windows.forms.BMenuItem();
            this.menuVisualProperty = new bocoree.windows.forms.BMenuItem();
            this.menuVisualOverview = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualGridline = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem2 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualStartMarker = new bocoree.windows.forms.BMenuItem();
            this.menuVisualEndMarker = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem3 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualLyrics = new bocoree.windows.forms.BMenuItem();
            this.menuVisualNoteProperty = new bocoree.windows.forms.BMenuItem();
            this.menuVisualPitchLine = new bocoree.windows.forms.BMenuItem();
            this.menuJob = new bocoree.windows.forms.BMenuItem();
            this.menuJobNormalize = new bocoree.windows.forms.BMenuItem();
            this.menuJobInsertBar = new bocoree.windows.forms.BMenuItem();
            this.menuJobDeleteBar = new bocoree.windows.forms.BMenuItem();
            this.menuJobRandomize = new bocoree.windows.forms.BMenuItem();
            this.menuJobConnect = new bocoree.windows.forms.BMenuItem();
            this.menuJobLyric = new bocoree.windows.forms.BMenuItem();
            this.menuJobRewire = new bocoree.windows.forms.BMenuItem();
            this.menuJobRealTime = new bocoree.windows.forms.BMenuItem();
            this.menuJobReloadVsti = new bocoree.windows.forms.BMenuItem();
            this.menuTrack = new bocoree.windows.forms.BMenuItem();
            this.menuTrackOn = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem21 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackAdd = new bocoree.windows.forms.BMenuItem();
            this.menuTrackCopy = new bocoree.windows.forms.BMenuItem();
            this.menuTrackChangeName = new bocoree.windows.forms.BMenuItem();
            this.menuTrackDelete = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem22 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackRenderCurrent = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRenderAll = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem23 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackOverlay = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRenderer = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID1 = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID2 = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRendererUtau = new bocoree.windows.forms.BMenuItem();
            this.menuTrackRendererStraight = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem4 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackBgm = new bocoree.windows.forms.BMenuItem();
            this.menuTrackManager = new bocoree.windows.forms.BMenuItem();
            this.menuLyric = new bocoree.windows.forms.BMenuItem();
            this.menuLyricExpressionProperty = new bocoree.windows.forms.BMenuItem();
            this.menuLyricVibratoProperty = new bocoree.windows.forms.BMenuItem();
            this.menuLyricSymbol = new bocoree.windows.forms.BMenuItem();
            this.menuLyricDictionary = new bocoree.windows.forms.BMenuItem();
            this.menuScript = new bocoree.windows.forms.BMenuItem();
            this.menuScriptUpdate = new bocoree.windows.forms.BMenuItem();
            this.menuSetting = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPreference = new bocoree.windows.forms.BMenuItem();
            this.menuSettingGameControler = new bocoree.windows.forms.BMenuItem();
            this.menuSettingGameControlerSetting = new bocoree.windows.forms.BMenuItem();
            this.menuSettingGameControlerLoad = new bocoree.windows.forms.BMenuItem();
            this.menuSettingGameControlerRemove = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPaletteTool = new bocoree.windows.forms.BMenuItem();
            this.menuSettingShortcut = new bocoree.windows.forms.BMenuItem();
            this.menuSettingMidi = new bocoree.windows.forms.BMenuItem();
            this.menuSettingUtauVoiceDB = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem6 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingDefaultSingerStyle = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem7 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingPositionQuantize = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize04 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize08 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize16 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize32 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize64 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize128 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingPositionQuantizeOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem9 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingPositionQuantizeTriplet = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize04 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize08 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize16 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize32 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize64 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantize128 = new bocoree.windows.forms.BMenuItem();
            this.menuSettingLengthQuantizeOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingLengthQuantizeTriplet = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem8 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingSingerProperty = new bocoree.windows.forms.BMenuItem();
            this.menuHelp = new bocoree.windows.forms.BMenuItem();
            this.menuHelpAbout = new bocoree.windows.forms.BMenuItem();
            this.menuHelpDebug = new bocoree.windows.forms.BMenuItem();
            this.menuHidden = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenEditLyric = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerPencil = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerEraser = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenVisualForwardParameter = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenVisualBackwardParameter = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenTrackNext = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenTrackBack = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenCopy = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenPaste = new bocoree.windows.forms.BMenuItem();
            this.menuHiddenCut = new bocoree.windows.forms.BMenuItem();
            this.saveXmlVsqDialog = new System.Windows.Forms.SaveFileDialog();
            this.cMenuPiano = new System.Windows.Forms.ContextMenuStrip( this.components );
            this.cMenuPianoPointer = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoPencil = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoEraser = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoPaletteTool = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCurve = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem13 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixed = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed01 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed02 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed04 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed08 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed16 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed32 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed64 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixed128 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixedOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem18 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixedTriplet = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoFixedDotted = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize04 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize08 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize16 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize32 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize64 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantize128 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoQuantizeOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem26 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoQuantizeTriplet = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength04 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength08 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength16 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength32 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength64 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLength128 = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoLengthOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem32 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoLengthTriplet = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoGrid = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoUndo = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoRedo = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCut = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoCopy = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoPaste = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoDelete = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem16 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoSelectAll = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoSelectAllEvents = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem17 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoImportLyric = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoExpressionProperty = new bocoree.windows.forms.BMenuItem();
            this.cMenuPianoVibratoProperty = new bocoree.windows.forms.BMenuItem();
            this.toolTip = new System.Windows.Forms.ToolTip( this.components );
            this.openXmlVsqDialog = new System.Windows.Forms.OpenFileDialog();
            this.cMenuTrackTab = new System.Windows.Forms.ContextMenuStrip( this.components );
            this.cMenuTrackTabTrackOn = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem24 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabAdd = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabCopy = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabChangeName = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabDelete = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem25 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabRenderCurrent = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderAll = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem27 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabOverlay = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderer = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID1 = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID2 = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererUtau = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererStraight = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelector = new System.Windows.Forms.ContextMenuStrip( this.components );
            this.cMenuTrackSelectorPointer = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPencil = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorLine = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorEraser = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaletteTool = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCurve = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem28 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorUndo = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorRedo = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem29 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCut = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorCopy = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaste = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDelete = new bocoree.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDeleteBezier = new bocoree.windows.forms.BMenuItem();
            this.toolStripMenuItem31 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorSelectAll = new bocoree.windows.forms.BMenuItem();
            this.trackBar = new System.Windows.Forms.TrackBar();
            this.bgWorkScreen = new System.ComponentModel.BackgroundWorker();
            this.timer = new System.Windows.Forms.Timer( this.components );
            this.panel1 = new System.Windows.Forms.Panel();
            this.pictKeyLengthSplitter = new System.Windows.Forms.PictureBox();
            this.panelOverview = new System.Windows.Forms.Panel();
            this.btnRight1 = new System.Windows.Forms.Button();
            this.btnLeft2 = new System.Windows.Forms.Button();
            this.btnZoom = new System.Windows.Forms.Button();
            this.btnMooz = new System.Windows.Forms.Button();
            this.btnLeft1 = new System.Windows.Forms.Button();
            this.btnRight2 = new System.Windows.Forms.Button();
            this.pictOverview = new Boare.Cadencii.BPictureBox();
            this.vScroll = new Boare.Lib.AppUtil.BVScrollBar();
            this.hScroll = new Boare.Lib.AppUtil.BHScrollBar();
            this.picturePositionIndicator = new System.Windows.Forms.PictureBox();
            this.pictPianoRoll = new Boare.Cadencii.PictPianoRoll();
            this.pictureBox3 = new System.Windows.Forms.PictureBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.toolStripTool = new bocoree.windows.forms.BToolBar();
            this.stripBtnPointer = new bocoree.windows.forms.BToolStripButton();
            this.stripBtnPencil = new bocoree.windows.forms.BToolStripButton();
            this.stripBtnLine = new bocoree.windows.forms.BToolStripButton();
            this.stripBtnEraser = new bocoree.windows.forms.BToolStripButton();
            this.toolStripSeparator5 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnGrid = new bocoree.windows.forms.BToolStripButton();
            this.stripBtnCurve = new bocoree.windows.forms.BToolStripButton();
            this.toolStripContainer = new System.Windows.Forms.ToolStripContainer();
            this.toolStripBottom = new System.Windows.Forms.ToolStrip();
            this.toolStripLabel6 = new System.Windows.Forms.ToolStripLabel();
            this.stripLblCursor = new System.Windows.Forms.ToolStripLabel();
            this.toolStripSeparator8 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripLabel8 = new System.Windows.Forms.ToolStripLabel();
            this.stripLblTempo = new System.Windows.Forms.ToolStripLabel();
            this.toolStripSeparator9 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripLabel10 = new System.Windows.Forms.ToolStripLabel();
            this.stripLblBeat = new System.Windows.Forms.ToolStripLabel();
            this.toolStripSeparator4 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripStatusLabel1 = new System.Windows.Forms.ToolStripStatusLabel();
            this.stripLblGameCtrlMode = new System.Windows.Forms.ToolStripStatusLabel();
            this.toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripStatusLabel2 = new System.Windows.Forms.ToolStripStatusLabel();
            this.stripLblMidiIn = new System.Windows.Forms.ToolStripStatusLabel();
            this.toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnSpeed = new System.Windows.Forms.ToolStripDropDownButton();
            this.stripDDBtnSpeedTextbox = new System.Windows.Forms.ToolStripTextBox();
            this.stripDDBtnSpeed033 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnSpeed050 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnSpeed100 = new bocoree.windows.forms.BMenuItem();
            this.statusStrip1 = new System.Windows.Forms.StatusStrip();
            this.statusLabel = new System.Windows.Forms.ToolStripStatusLabel();
            this.splitContainerProperty = new Boare.Lib.AppUtil.BSplitContainer();
            this.panel2 = new System.Windows.Forms.Panel();
            this.waveView = new Boare.Cadencii.WaveView();
            this.splitContainer2 = new Boare.Lib.AppUtil.BSplitContainer();
            this.splitContainer1 = new Boare.Lib.AppUtil.BSplitContainer();
            this.toolStripFile = new System.Windows.Forms.ToolStrip();
            this.stripBtnFileNew = new System.Windows.Forms.ToolStripButton();
            this.stripBtnFileOpen = new System.Windows.Forms.ToolStripButton();
            this.stripBtnFileSave = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator12 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnCut = new System.Windows.Forms.ToolStripButton();
            this.stripBtnCopy = new System.Windows.Forms.ToolStripButton();
            this.stripBtnPaste = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator13 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnUndo = new System.Windows.Forms.ToolStripButton();
            this.stripBtnRedo = new System.Windows.Forms.ToolStripButton();
            this.toolStripPosition = new System.Windows.Forms.ToolStrip();
            this.stripBtnMoveTop = new System.Windows.Forms.ToolStripButton();
            this.stripBtnRewind = new System.Windows.Forms.ToolStripButton();
            this.stripBtnForward = new System.Windows.Forms.ToolStripButton();
            this.stripBtnMoveEnd = new System.Windows.Forms.ToolStripButton();
            this.stripBtnPlay = new System.Windows.Forms.ToolStripButton();
            this.stripBtnStop = new System.Windows.Forms.ToolStripButton();
            this.toolStripSeparator7 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnScroll = new System.Windows.Forms.ToolStripButton();
            this.stripBtnLoop = new System.Windows.Forms.ToolStripButton();
            this.toolStripMeasure = new System.Windows.Forms.ToolStrip();
            this.toolStripLabel5 = new System.Windows.Forms.ToolStripLabel();
            this.stripLblMeasure = new System.Windows.Forms.ToolStripLabel();
            this.toolStripButton1 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnLength = new System.Windows.Forms.ToolStripDropDownButton();
            this.stripDDBtnLength04 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLength08 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLength16 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLength32 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLength64 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLength128 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnLengthOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnLengthTriplet = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize = new System.Windows.Forms.ToolStripDropDownButton();
            this.stripDDBtnQuantize04 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize08 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize16 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize32 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize64 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantize128 = new bocoree.windows.forms.BMenuItem();
            this.stripDDBtnQuantizeOff = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnQuantizeTriplet = new bocoree.windows.forms.BMenuItem();
            this.toolStripSeparator6 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnStartMarker = new System.Windows.Forms.ToolStripButton();
            this.stripBtnEndMarker = new System.Windows.Forms.ToolStripButton();
            this.openUstDialog = new System.Windows.Forms.OpenFileDialog();
            this.openMidiDialog = new System.Windows.Forms.OpenFileDialog();
            this.saveMidiDialog = new System.Windows.Forms.SaveFileDialog();
            this.openWaveDialog = new System.Windows.Forms.OpenFileDialog();
            this.menuStripMain.SuspendLayout();
            this.cMenuPiano.SuspendLayout();
            this.cMenuTrackTab.SuspendLayout();
            this.cMenuTrackSelector.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar)).BeginInit();
            this.panel1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictKeyLengthSplitter)).BeginInit();
            this.panelOverview.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictOverview)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picturePositionIndicator)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictPianoRoll)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox3)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.toolStripTool.SuspendLayout();
            this.toolStripContainer.BottomToolStripPanel.SuspendLayout();
            this.toolStripContainer.ContentPanel.SuspendLayout();
            this.toolStripContainer.TopToolStripPanel.SuspendLayout();
            this.toolStripContainer.SuspendLayout();
            this.toolStripBottom.SuspendLayout();
            this.statusStrip1.SuspendLayout();
            this.panel2.SuspendLayout();
            this.toolStripFile.SuspendLayout();
            this.toolStripPosition.SuspendLayout();
            this.toolStripMeasure.SuspendLayout();
            this.SuspendLayout();
            // 
            // menuStripMain
            // 
            this.menuStripMain.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFile,
            this.menuEdit,
            this.menuVisual,
            this.menuJob,
            this.menuTrack,
            this.menuLyric,
            this.menuScript,
            this.menuSetting,
            this.menuHelp,
            this.menuHidden} );
            this.menuStripMain.Location = new System.Drawing.Point( 0, 0 );
            this.menuStripMain.Name = "menuStripMain";
            this.menuStripMain.Size = new System.Drawing.Size( 960, 26 );
            this.menuStripMain.TabIndex = 0;
            this.menuStripMain.Text = "menuStrip1";
            this.menuStripMain.MouseDown += new System.Windows.Forms.MouseEventHandler( this.menuStrip1_MouseDown );
            // 
            // menuFile
            // 
            this.menuFile.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileNew,
            this.menuFileOpen,
            this.menuFileSave,
            this.menuFileSaveNamed,
            this.toolStripMenuItem10,
            this.menuFileOpenVsq,
            this.menuFileOpenUst,
            this.menuFileImport,
            this.menuFileExport,
            this.toolStripMenuItem11,
            this.menuFileRecent,
            this.toolStripMenuItem12,
            this.menuFileQuit} );
            this.menuFile.ImageScaling = System.Windows.Forms.ToolStripItemImageScaling.None;
            this.menuFile.Name = "menuFile";
            this.menuFile.Size = new System.Drawing.Size( 57, 22 );
            this.menuFile.Text = "File(&F)";
            // 
            // menuFileNew
            // 
            this.menuFileNew.Name = "menuFileNew";
            this.menuFileNew.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileNew.Text = "New(N)";
            this.menuFileNew.MouseEnter += new System.EventHandler( this.menuFileNew_MouseEnter );
            this.menuFileNew.Click += new System.EventHandler( this.commonFileNew_Click );
            // 
            // menuFileOpen
            // 
            this.menuFileOpen.Name = "menuFileOpen";
            this.menuFileOpen.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpen.Text = "Open(&O)";
            this.menuFileOpen.MouseEnter += new System.EventHandler( this.menuFileOpen_MouseEnter );
            this.menuFileOpen.Click += new System.EventHandler( this.commonFileOpen_Click );
            // 
            // menuFileSave
            // 
            this.menuFileSave.Name = "menuFileSave";
            this.menuFileSave.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileSave.Text = "Save(&S)";
            this.menuFileSave.MouseEnter += new System.EventHandler( this.menuFileSave_MouseEnter );
            this.menuFileSave.Click += new System.EventHandler( this.commonFileSave_Click );
            // 
            // menuFileSaveNamed
            // 
            this.menuFileSaveNamed.Name = "menuFileSaveNamed";
            this.menuFileSaveNamed.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileSaveNamed.Text = "Save As(&A)";
            this.menuFileSaveNamed.MouseEnter += new System.EventHandler( this.menuFileSaveNamed_MouseEnter );
            this.menuFileSaveNamed.Click += new System.EventHandler( this.menuFileSaveNamed_Click );
            // 
            // toolStripMenuItem10
            // 
            this.toolStripMenuItem10.Name = "toolStripMenuItem10";
            this.toolStripMenuItem10.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileOpenVsq
            // 
            this.menuFileOpenVsq.Name = "menuFileOpenVsq";
            this.menuFileOpenVsq.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpenVsq.Text = "Open VSQ/Vocaloid Midi(&V)";
            this.menuFileOpenVsq.MouseEnter += new System.EventHandler( this.menuFileOpenVsq_MouseEnter );
            this.menuFileOpenVsq.Click += new System.EventHandler( this.menuFileOpenVsq_Click );
            // 
            // menuFileOpenUst
            // 
            this.menuFileOpenUst.Name = "menuFileOpenUst";
            this.menuFileOpenUst.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileOpenUst.Text = "Open UTAU Project File(&U)";
            this.menuFileOpenUst.MouseEnter += new System.EventHandler( this.menuFileOpenUst_MouseEnter );
            this.menuFileOpenUst.Click += new System.EventHandler( this.menuFileOpenUst_Click );
            // 
            // menuFileImport
            // 
            this.menuFileImport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileImportVsq,
            this.menuFileImportMidi} );
            this.menuFileImport.Name = "menuFileImport";
            this.menuFileImport.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileImport.Text = "Import(&I)";
            this.menuFileImport.MouseEnter += new System.EventHandler( this.menuFileImport_MouseEnter );
            // 
            // menuFileImportVsq
            // 
            this.menuFileImportVsq.Name = "menuFileImportVsq";
            this.menuFileImportVsq.Size = new System.Drawing.Size( 162, 22 );
            this.menuFileImportVsq.Text = "VSQ File";
            this.menuFileImportVsq.MouseEnter += new System.EventHandler( this.menuFileImportVsq_MouseEnter );
            this.menuFileImportVsq.Click += new System.EventHandler( this.menuFileImportVsq_Click );
            // 
            // menuFileImportMidi
            // 
            this.menuFileImportMidi.Name = "menuFileImportMidi";
            this.menuFileImportMidi.Size = new System.Drawing.Size( 162, 22 );
            this.menuFileImportMidi.Text = "Standard MIDI";
            this.menuFileImportMidi.MouseEnter += new System.EventHandler( this.menuFileImportMidi_MouseEnter );
            this.menuFileImportMidi.Click += new System.EventHandler( this.menuFileImportMidi_Click );
            // 
            // menuFileExport
            // 
            this.menuFileExport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileExportWave,
            this.menuFileExportMidi} );
            this.menuFileExport.Name = "menuFileExport";
            this.menuFileExport.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileExport.Text = "Export(&E)";
            this.menuFileExport.DropDownOpening += new System.EventHandler( this.menuFileExport_DropDownOpening );
            // 
            // menuFileExportWave
            // 
            this.menuFileExportWave.Name = "menuFileExportWave";
            this.menuFileExportWave.Size = new System.Drawing.Size( 108, 22 );
            this.menuFileExportWave.Text = "Wave";
            this.menuFileExportWave.MouseEnter += new System.EventHandler( this.menuFileExportWave_MouseEnter );
            this.menuFileExportWave.Click += new System.EventHandler( this.menuFileExportWave_Click );
            // 
            // menuFileExportMidi
            // 
            this.menuFileExportMidi.Name = "menuFileExportMidi";
            this.menuFileExportMidi.Size = new System.Drawing.Size( 108, 22 );
            this.menuFileExportMidi.Text = "MIDI";
            this.menuFileExportMidi.MouseEnter += new System.EventHandler( this.menuFileExportMidi_MouseEnter );
            this.menuFileExportMidi.Click += new System.EventHandler( this.menuFileExportMidi_Click );
            // 
            // toolStripMenuItem11
            // 
            this.toolStripMenuItem11.Name = "toolStripMenuItem11";
            this.toolStripMenuItem11.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileRecent
            // 
            this.menuFileRecent.Name = "menuFileRecent";
            this.menuFileRecent.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileRecent.Text = "Recent Files(&R)";
            this.menuFileRecent.MouseEnter += new System.EventHandler( this.menuFileRecent_MouseEnter );
            // 
            // toolStripMenuItem12
            // 
            this.toolStripMenuItem12.Name = "toolStripMenuItem12";
            this.toolStripMenuItem12.Size = new System.Drawing.Size( 229, 6 );
            // 
            // menuFileQuit
            // 
            this.menuFileQuit.Name = "menuFileQuit";
            this.menuFileQuit.Size = new System.Drawing.Size( 232, 22 );
            this.menuFileQuit.Text = "Quit(&Q)";
            this.menuFileQuit.MouseEnter += new System.EventHandler( this.menuFileQuit_MouseEnter );
            this.menuFileQuit.Click += new System.EventHandler( this.menuFileQuit_Click );
            // 
            // menuEdit
            // 
            this.menuEdit.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuEditUndo,
            this.menuEditRedo,
            this.toolStripMenuItem5,
            this.menuEditCut,
            this.menuEditCopy,
            this.menuEditPaste,
            this.menuEditDelete,
            this.toolStripMenuItem19,
            this.menuEditAutoNormalizeMode,
            this.toolStripMenuItem20,
            this.menuEditSelectAll,
            this.menuEditSelectAllEvents} );
            this.menuEdit.Name = "menuEdit";
            this.menuEdit.Size = new System.Drawing.Size( 59, 22 );
            this.menuEdit.Text = "Edit(&E)";
            this.menuEdit.DropDownOpening += new System.EventHandler( this.menuEdit_DropDownOpening );
            // 
            // menuEditUndo
            // 
            this.menuEditUndo.Name = "menuEditUndo";
            this.menuEditUndo.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditUndo.Text = "Undo(&U)";
            this.menuEditUndo.MouseEnter += new System.EventHandler( this.menuEditUndo_MouseEnter );
            this.menuEditUndo.Click += new System.EventHandler( this.commonEditUndo_Click );
            // 
            // menuEditRedo
            // 
            this.menuEditRedo.Name = "menuEditRedo";
            this.menuEditRedo.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditRedo.Text = "Redo(&R)";
            this.menuEditRedo.MouseEnter += new System.EventHandler( this.menuEditRedo_MouseEnter );
            this.menuEditRedo.Click += new System.EventHandler( this.commonEditRedo_Click );
            // 
            // toolStripMenuItem5
            // 
            this.toolStripMenuItem5.Name = "toolStripMenuItem5";
            this.toolStripMenuItem5.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditCut
            // 
            this.menuEditCut.Name = "menuEditCut";
            this.menuEditCut.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditCut.Text = "Cut(&T)";
            this.menuEditCut.MouseEnter += new System.EventHandler( this.menuEditCut_MouseEnter );
            this.menuEditCut.Click += new System.EventHandler( this.commonEditCut_Click );
            // 
            // menuEditCopy
            // 
            this.menuEditCopy.Name = "menuEditCopy";
            this.menuEditCopy.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditCopy.Text = "Copy(&C)";
            this.menuEditCopy.MouseEnter += new System.EventHandler( this.menuEditCopy_MouseEnter );
            this.menuEditCopy.Click += new System.EventHandler( this.commonEditCopy_Click );
            // 
            // menuEditPaste
            // 
            this.menuEditPaste.Name = "menuEditPaste";
            this.menuEditPaste.ShortcutKeyDisplayString = "";
            this.menuEditPaste.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditPaste.Text = "Paste(&P)";
            this.menuEditPaste.MouseEnter += new System.EventHandler( this.menuEditPaste_MouseEnter );
            this.menuEditPaste.Click += new System.EventHandler( this.commonEditPaste_Click );
            // 
            // menuEditDelete
            // 
            this.menuEditDelete.Name = "menuEditDelete";
            this.menuEditDelete.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditDelete.Text = "Delete(&D)";
            this.menuEditDelete.MouseEnter += new System.EventHandler( this.menuEditDelete_MouseEnter );
            this.menuEditDelete.Click += new System.EventHandler( this.menuEditDelete_Click );
            // 
            // toolStripMenuItem19
            // 
            this.toolStripMenuItem19.Name = "toolStripMenuItem19";
            this.toolStripMenuItem19.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditAutoNormalizeMode
            // 
            this.menuEditAutoNormalizeMode.Name = "menuEditAutoNormalizeMode";
            this.menuEditAutoNormalizeMode.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditAutoNormalizeMode.Text = "Auto Normalize Mode(&N)";
            this.menuEditAutoNormalizeMode.MouseEnter += new System.EventHandler( this.menuEditAutoNormalizeMode_MouseEnter );
            this.menuEditAutoNormalizeMode.Click += new System.EventHandler( this.menuEditAutoNormalizeMode_Click );
            // 
            // toolStripMenuItem20
            // 
            this.toolStripMenuItem20.Name = "toolStripMenuItem20";
            this.toolStripMenuItem20.Size = new System.Drawing.Size( 217, 6 );
            // 
            // menuEditSelectAll
            // 
            this.menuEditSelectAll.Name = "menuEditSelectAll";
            this.menuEditSelectAll.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditSelectAll.Text = "Select All(&A)";
            this.menuEditSelectAll.MouseEnter += new System.EventHandler( this.menuEditSelectAll_MouseEnter );
            this.menuEditSelectAll.Click += new System.EventHandler( this.menuEditSelectAll_Click );
            // 
            // menuEditSelectAllEvents
            // 
            this.menuEditSelectAllEvents.Name = "menuEditSelectAllEvents";
            this.menuEditSelectAllEvents.Size = new System.Drawing.Size( 220, 22 );
            this.menuEditSelectAllEvents.Text = "Select All Events(&E)";
            this.menuEditSelectAllEvents.MouseEnter += new System.EventHandler( this.menuEditSelectAllEvents_MouseEnter );
            this.menuEditSelectAllEvents.Click += new System.EventHandler( this.menuEditSelectAllEvents_Click );
            // 
            // menuVisual
            // 
            this.menuVisual.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisual.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuVisualControlTrack,
            this.menuVisualMixer,
            this.menuVisualWaveform,
            this.menuVisualProperty,
            this.menuVisualOverview,
            this.toolStripMenuItem1,
            this.menuVisualGridline,
            this.toolStripMenuItem2,
            this.menuVisualStartMarker,
            this.menuVisualEndMarker,
            this.toolStripMenuItem3,
            this.menuVisualLyrics,
            this.menuVisualNoteProperty,
            this.menuVisualPitchLine} );
            this.menuVisual.Name = "menuVisual";
            this.menuVisual.Size = new System.Drawing.Size( 66, 22 );
            this.menuVisual.Text = "View(&V)";
            // 
            // menuVisualControlTrack
            // 
            this.menuVisualControlTrack.Checked = true;
            this.menuVisualControlTrack.CheckOnClick = true;
            this.menuVisualControlTrack.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualControlTrack.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualControlTrack.Name = "menuVisualControlTrack";
            this.menuVisualControlTrack.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualControlTrack.Text = "Control Track(&C)";
            this.menuVisualControlTrack.CheckedChanged += new System.EventHandler( this.menuVisualControlTrack_CheckedChanged );
            this.menuVisualControlTrack.MouseEnter += new System.EventHandler( this.menuVisualControlTrack_MouseEnter );
            // 
            // menuVisualMixer
            // 
            this.menuVisualMixer.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualMixer.Name = "menuVisualMixer";
            this.menuVisualMixer.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualMixer.Text = "Mixer(&X)";
            this.menuVisualMixer.MouseEnter += new System.EventHandler( this.menuVisualMixer_MouseEnter );
            this.menuVisualMixer.Click += new System.EventHandler( this.menuVisualMixer_Click );
            // 
            // menuVisualWaveform
            // 
            this.menuVisualWaveform.CheckOnClick = true;
            this.menuVisualWaveform.Name = "menuVisualWaveform";
            this.menuVisualWaveform.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualWaveform.Text = "Waveform(&W)";
            this.menuVisualWaveform.CheckedChanged += new System.EventHandler( this.menuVisualWaveform_CheckedChanged );
            this.menuVisualWaveform.MouseEnter += new System.EventHandler( this.menuVisualWaveform_MouseEnter );
            // 
            // menuVisualProperty
            // 
            this.menuVisualProperty.CheckOnClick = true;
            this.menuVisualProperty.Name = "menuVisualProperty";
            this.menuVisualProperty.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualProperty.Text = "Property Window(&C)";
            this.menuVisualProperty.MouseEnter += new System.EventHandler( this.menuVisualProperty_MouseEnter );
            this.menuVisualProperty.Click += new System.EventHandler( this.menuVisualProperty_Click );
            // 
            // menuVisualOverview
            // 
            this.menuVisualOverview.CheckOnClick = true;
            this.menuVisualOverview.Name = "menuVisualOverview";
            this.menuVisualOverview.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualOverview.Text = "Overview(&O)";
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualGridline
            // 
            this.menuVisualGridline.CheckOnClick = true;
            this.menuVisualGridline.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualGridline.Name = "menuVisualGridline";
            this.menuVisualGridline.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualGridline.Text = "Grid Line(&G)";
            this.menuVisualGridline.CheckedChanged += new System.EventHandler( this.menuVisualGridline_CheckedChanged );
            this.menuVisualGridline.MouseEnter += new System.EventHandler( this.menuVisualGridline_MouseEnter );
            // 
            // toolStripMenuItem2
            // 
            this.toolStripMenuItem2.Name = "toolStripMenuItem2";
            this.toolStripMenuItem2.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualStartMarker
            // 
            this.menuVisualStartMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualStartMarker.Name = "menuVisualStartMarker";
            this.menuVisualStartMarker.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualStartMarker.Text = "Start Marker(&S)";
            this.menuVisualStartMarker.MouseEnter += new System.EventHandler( this.menuVisualStartMarker_MouseEnter );
            this.menuVisualStartMarker.Click += new System.EventHandler( this.handleStartMarker_Click );
            // 
            // menuVisualEndMarker
            // 
            this.menuVisualEndMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualEndMarker.Name = "menuVisualEndMarker";
            this.menuVisualEndMarker.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualEndMarker.Text = "End Marker(&E)";
            this.menuVisualEndMarker.MouseEnter += new System.EventHandler( this.menuVisualEndMarker_MouseEnter );
            this.menuVisualEndMarker.Click += new System.EventHandler( this.handleEndMarker_Click );
            // 
            // toolStripMenuItem3
            // 
            this.toolStripMenuItem3.Name = "toolStripMenuItem3";
            this.toolStripMenuItem3.Size = new System.Drawing.Size( 234, 6 );
            // 
            // menuVisualLyrics
            // 
            this.menuVisualLyrics.Checked = true;
            this.menuVisualLyrics.CheckOnClick = true;
            this.menuVisualLyrics.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualLyrics.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualLyrics.Name = "menuVisualLyrics";
            this.menuVisualLyrics.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualLyrics.Text = "Lyric/Phoneme(&L)";
            this.menuVisualLyrics.CheckedChanged += new System.EventHandler( this.menuVisualLyrics_CheckedChanged );
            this.menuVisualLyrics.MouseEnter += new System.EventHandler( this.menuVisualLyrics_MouseEnter );
            // 
            // menuVisualNoteProperty
            // 
            this.menuVisualNoteProperty.Checked = true;
            this.menuVisualNoteProperty.CheckOnClick = true;
            this.menuVisualNoteProperty.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualNoteProperty.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualNoteProperty.Name = "menuVisualNoteProperty";
            this.menuVisualNoteProperty.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualNoteProperty.Text = "Note Expression/Vibrato(&N)";
            this.menuVisualNoteProperty.CheckedChanged += new System.EventHandler( this.menuVisualNoteProperty_CheckedChanged );
            this.menuVisualNoteProperty.MouseEnter += new System.EventHandler( this.menuVisualNoteProperty_MouseEnter );
            // 
            // menuVisualPitchLine
            // 
            this.menuVisualPitchLine.CheckOnClick = true;
            this.menuVisualPitchLine.Name = "menuVisualPitchLine";
            this.menuVisualPitchLine.Size = new System.Drawing.Size( 237, 22 );
            this.menuVisualPitchLine.Text = "Pitch Line(&P)";
            this.menuVisualPitchLine.CheckedChanged += new System.EventHandler( this.menuVisualPitchLine_CheckedChanged );
            this.menuVisualPitchLine.MouseEnter += new System.EventHandler( this.menuVisualPitchLine_MouseEnter );
            // 
            // menuJob
            // 
            this.menuJob.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuJobNormalize,
            this.menuJobInsertBar,
            this.menuJobDeleteBar,
            this.menuJobRandomize,
            this.menuJobConnect,
            this.menuJobLyric,
            this.menuJobRewire,
            this.menuJobRealTime,
            this.menuJobReloadVsti} );
            this.menuJob.Name = "menuJob";
            this.menuJob.Size = new System.Drawing.Size( 54, 22 );
            this.menuJob.Text = "Job(&J)";
            this.menuJob.DropDownOpening += new System.EventHandler( this.menuJob_DropDownOpening );
            // 
            // menuJobNormalize
            // 
            this.menuJobNormalize.Name = "menuJobNormalize";
            this.menuJobNormalize.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobNormalize.Text = "Normalize Notes(&N)";
            this.menuJobNormalize.MouseEnter += new System.EventHandler( this.menuJobNormalize_MouseEnter );
            this.menuJobNormalize.Click += new System.EventHandler( this.menuJobNormalize_Click );
            // 
            // menuJobInsertBar
            // 
            this.menuJobInsertBar.Name = "menuJobInsertBar";
            this.menuJobInsertBar.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobInsertBar.Text = "Insert Bars(&I)";
            this.menuJobInsertBar.MouseEnter += new System.EventHandler( this.menuJobInsertBar_MouseEnter );
            this.menuJobInsertBar.Click += new System.EventHandler( this.menuJobInsertBar_Click );
            // 
            // menuJobDeleteBar
            // 
            this.menuJobDeleteBar.Name = "menuJobDeleteBar";
            this.menuJobDeleteBar.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobDeleteBar.Text = "Delete Bars(&D)";
            this.menuJobDeleteBar.MouseEnter += new System.EventHandler( this.menuJobDeleteBar_MouseEnter );
            this.menuJobDeleteBar.Click += new System.EventHandler( this.menuJobDeleteBar_Click );
            // 
            // menuJobRandomize
            // 
            this.menuJobRandomize.Enabled = false;
            this.menuJobRandomize.Name = "menuJobRandomize";
            this.menuJobRandomize.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRandomize.Text = "Randomize(&R)";
            this.menuJobRandomize.MouseEnter += new System.EventHandler( this.menuJobRandomize_MouseEnter );
            // 
            // menuJobConnect
            // 
            this.menuJobConnect.Name = "menuJobConnect";
            this.menuJobConnect.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobConnect.Text = "Connect Notes(&C)";
            this.menuJobConnect.MouseEnter += new System.EventHandler( this.menuJobConnect_MouseEnter );
            this.menuJobConnect.Click += new System.EventHandler( this.menuJobConnect_Click );
            // 
            // menuJobLyric
            // 
            this.menuJobLyric.Name = "menuJobLyric";
            this.menuJobLyric.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobLyric.Text = "Insert Lyrics(&L)";
            this.menuJobLyric.MouseEnter += new System.EventHandler( this.menuJobLyric_MouseEnter );
            this.menuJobLyric.Click += new System.EventHandler( this.menuJobLyric_Click );
            // 
            // menuJobRewire
            // 
            this.menuJobRewire.Enabled = false;
            this.menuJobRewire.Name = "menuJobRewire";
            this.menuJobRewire.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRewire.Text = "Import ReWire Host Tempo(&T)";
            this.menuJobRewire.MouseEnter += new System.EventHandler( this.menuJobRewire_MouseEnter );
            // 
            // menuJobRealTime
            // 
            this.menuJobRealTime.Name = "menuJobRealTime";
            this.menuJobRealTime.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobRealTime.Text = "Start Realtime Input";
            this.menuJobRealTime.MouseEnter += new System.EventHandler( this.menuJobRealTime_MouseEnter );
            this.menuJobRealTime.Click += new System.EventHandler( this.menuJobRealTime_Click );
            // 
            // menuJobReloadVsti
            // 
            this.menuJobReloadVsti.Name = "menuJobReloadVsti";
            this.menuJobReloadVsti.Size = new System.Drawing.Size( 256, 22 );
            this.menuJobReloadVsti.Text = "Reload VSTi(&R)";
            this.menuJobReloadVsti.Visible = false;
            this.menuJobReloadVsti.MouseEnter += new System.EventHandler( this.menuJobReloadVsti_MouseEnter );
            this.menuJobReloadVsti.Click += new System.EventHandler( this.menuJobReloadVsti_Click );
            // 
            // menuTrack
            // 
            this.menuTrack.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackOn,
            this.toolStripMenuItem21,
            this.menuTrackAdd,
            this.menuTrackCopy,
            this.menuTrackChangeName,
            this.menuTrackDelete,
            this.toolStripMenuItem22,
            this.menuTrackRenderCurrent,
            this.menuTrackRenderAll,
            this.toolStripMenuItem23,
            this.menuTrackOverlay,
            this.menuTrackRenderer,
            this.toolStripMenuItem4,
            this.menuTrackBgm,
            this.menuTrackManager} );
            this.menuTrack.Name = "menuTrack";
            this.menuTrack.Size = new System.Drawing.Size( 70, 22 );
            this.menuTrack.Text = "Track(&T)";
            this.menuTrack.DropDownOpening += new System.EventHandler( this.menuTrack_DropDownOpening );
            // 
            // menuTrackOn
            // 
            this.menuTrackOn.Name = "menuTrackOn";
            this.menuTrackOn.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackOn.Text = "Track On(&K)";
            this.menuTrackOn.MouseEnter += new System.EventHandler( this.menuTrackOn_MouseEnter );
            this.menuTrackOn.Click += new System.EventHandler( this.menuTrackOn_Click );
            // 
            // toolStripMenuItem21
            // 
            this.toolStripMenuItem21.Name = "toolStripMenuItem21";
            this.toolStripMenuItem21.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackAdd
            // 
            this.menuTrackAdd.Name = "menuTrackAdd";
            this.menuTrackAdd.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackAdd.Text = "Add Track(&A)";
            this.menuTrackAdd.MouseEnter += new System.EventHandler( this.menuTrackAdd_MouseEnter );
            this.menuTrackAdd.Click += new System.EventHandler( this.menuTrackAdd_Click );
            // 
            // menuTrackCopy
            // 
            this.menuTrackCopy.Name = "menuTrackCopy";
            this.menuTrackCopy.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackCopy.Text = "Copy Track(&C)";
            this.menuTrackCopy.MouseEnter += new System.EventHandler( this.menuTrackCopy_MouseEnter );
            this.menuTrackCopy.Click += new System.EventHandler( this.menuTrackCopy_Click );
            // 
            // menuTrackChangeName
            // 
            this.menuTrackChangeName.Name = "menuTrackChangeName";
            this.menuTrackChangeName.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackChangeName.Text = "Rename Track(&R)";
            this.menuTrackChangeName.MouseEnter += new System.EventHandler( this.menuTrackChangeName_MouseEnter );
            this.menuTrackChangeName.Click += new System.EventHandler( this.menuTrackChangeName_Click );
            // 
            // menuTrackDelete
            // 
            this.menuTrackDelete.Name = "menuTrackDelete";
            this.menuTrackDelete.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackDelete.Text = "Delete Track(&D)";
            this.menuTrackDelete.MouseEnter += new System.EventHandler( this.menuTrackDelete_MouseEnter );
            this.menuTrackDelete.Click += new System.EventHandler( this.menuTrackDelete_Click );
            // 
            // toolStripMenuItem22
            // 
            this.toolStripMenuItem22.Name = "toolStripMenuItem22";
            this.toolStripMenuItem22.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackRenderCurrent
            // 
            this.menuTrackRenderCurrent.Name = "menuTrackRenderCurrent";
            this.menuTrackRenderCurrent.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderCurrent.Text = "Render Current Track(&T)";
            this.menuTrackRenderCurrent.MouseEnter += new System.EventHandler( this.menuTrackRenderCurrent_MouseEnter );
            this.menuTrackRenderCurrent.Click += new System.EventHandler( this.menuTrackRenderCurrent_Click );
            // 
            // menuTrackRenderAll
            // 
            this.menuTrackRenderAll.Enabled = false;
            this.menuTrackRenderAll.Name = "menuTrackRenderAll";
            this.menuTrackRenderAll.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderAll.Text = "Render All Tracks(&S)";
            this.menuTrackRenderAll.MouseEnter += new System.EventHandler( this.menuTrackRenderAll_MouseEnter );
            this.menuTrackRenderAll.Click += new System.EventHandler( this.commonTrackRenderAll_Click );
            // 
            // toolStripMenuItem23
            // 
            this.toolStripMenuItem23.Name = "toolStripMenuItem23";
            this.toolStripMenuItem23.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackOverlay
            // 
            this.menuTrackOverlay.Name = "menuTrackOverlay";
            this.menuTrackOverlay.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackOverlay.Text = "Overlay(&O)";
            this.menuTrackOverlay.MouseEnter += new System.EventHandler( this.menuTrackOverlay_MouseEnter );
            this.menuTrackOverlay.Click += new System.EventHandler( this.menuTrackOverlay_Click );
            // 
            // menuTrackRenderer
            // 
            this.menuTrackRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackRendererVOCALOID1,
            this.menuTrackRendererVOCALOID2,
            this.menuTrackRendererUtau,
            this.menuTrackRendererStraight} );
            this.menuTrackRenderer.Name = "menuTrackRenderer";
            this.menuTrackRenderer.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackRenderer.Text = "Renderer";
            this.menuTrackRenderer.MouseEnter += new System.EventHandler( this.menuTrackRenderer_MouseEnter );
            this.menuTrackRenderer.DropDownOpening += new System.EventHandler( this.menuTrackRenderer_DropDownOpening );
            // 
            // menuTrackRendererVOCALOID1
            // 
            this.menuTrackRendererVOCALOID1.Name = "menuTrackRendererVOCALOID1";
            this.menuTrackRendererVOCALOID1.Size = new System.Drawing.Size( 172, 22 );
            this.menuTrackRendererVOCALOID1.Text = "VOCALOID1";
            this.menuTrackRendererVOCALOID1.MouseEnter += new System.EventHandler( this.menuTrackRendererVOCALOID1_MouseEnter );
            this.menuTrackRendererVOCALOID1.Click += new System.EventHandler( this.commonRendererVOCALOID1_Click );
            // 
            // menuTrackRendererVOCALOID2
            // 
            this.menuTrackRendererVOCALOID2.Name = "menuTrackRendererVOCALOID2";
            this.menuTrackRendererVOCALOID2.Size = new System.Drawing.Size( 172, 22 );
            this.menuTrackRendererVOCALOID2.Text = "VOCALOID2";
            this.menuTrackRendererVOCALOID2.MouseEnter += new System.EventHandler( this.menuTrackRendererVOCALOID2_MouseEnter );
            this.menuTrackRendererVOCALOID2.Click += new System.EventHandler( this.commonRendererVOCALOID2_Click );
            // 
            // menuTrackRendererUtau
            // 
            this.menuTrackRendererUtau.Name = "menuTrackRendererUtau";
            this.menuTrackRendererUtau.Size = new System.Drawing.Size( 172, 22 );
            this.menuTrackRendererUtau.Text = "UTAU";
            this.menuTrackRendererUtau.MouseEnter += new System.EventHandler( this.menuTrackRendererUtau_MouseEnter );
            this.menuTrackRendererUtau.Click += new System.EventHandler( this.commonRendererUtau_Click );
            // 
            // menuTrackRendererStraight
            // 
            this.menuTrackRendererStraight.Name = "menuTrackRendererStraight";
            this.menuTrackRendererStraight.Size = new System.Drawing.Size( 172, 22 );
            this.menuTrackRendererStraight.Text = "Straight X UTAU";
            this.menuTrackRendererStraight.Click += new System.EventHandler( this.commonRendererStraight_Click );
            // 
            // toolStripMenuItem4
            // 
            this.toolStripMenuItem4.Name = "toolStripMenuItem4";
            this.toolStripMenuItem4.Size = new System.Drawing.Size( 216, 6 );
            // 
            // menuTrackBgm
            // 
            this.menuTrackBgm.Name = "menuTrackBgm";
            this.menuTrackBgm.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackBgm.Text = "BGM(&B)";
            // 
            // menuTrackManager
            // 
            this.menuTrackManager.Name = "menuTrackManager";
            this.menuTrackManager.Size = new System.Drawing.Size( 219, 22 );
            this.menuTrackManager.Text = "Track Manager(&M)";
            this.menuTrackManager.Click += new System.EventHandler( this.menuTrackManager_Click );
            // 
            // menuLyric
            // 
            this.menuLyric.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuLyricExpressionProperty,
            this.menuLyricVibratoProperty,
            this.menuLyricSymbol,
            this.menuLyricDictionary} );
            this.menuLyric.Name = "menuLyric";
            this.menuLyric.Size = new System.Drawing.Size( 70, 22 );
            this.menuLyric.Text = "Lyrics(&L)";
            // 
            // menuLyricExpressionProperty
            // 
            this.menuLyricExpressionProperty.Name = "menuLyricExpressionProperty";
            this.menuLyricExpressionProperty.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricExpressionProperty.Text = "Note Expression Property(&E)";
            this.menuLyricExpressionProperty.Click += new System.EventHandler( this.menuLyricExpressionProperty_Click );
            // 
            // menuLyricVibratoProperty
            // 
            this.menuLyricVibratoProperty.Name = "menuLyricVibratoProperty";
            this.menuLyricVibratoProperty.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricVibratoProperty.Text = "Note Vibrato Property(&V)";
            this.menuLyricVibratoProperty.Click += new System.EventHandler( this.menuLyricVibratoProperty_Click );
            // 
            // menuLyricSymbol
            // 
            this.menuLyricSymbol.Enabled = false;
            this.menuLyricSymbol.Name = "menuLyricSymbol";
            this.menuLyricSymbol.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricSymbol.Text = "Phoneme Transformation(&T)";
            // 
            // menuLyricDictionary
            // 
            this.menuLyricDictionary.Name = "menuLyricDictionary";
            this.menuLyricDictionary.Size = new System.Drawing.Size( 241, 22 );
            this.menuLyricDictionary.Text = "User Word Dictionary(&C)";
            this.menuLyricDictionary.Click += new System.EventHandler( this.menuLyricDictionary_Click );
            // 
            // menuScript
            // 
            this.menuScript.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuScriptUpdate} );
            this.menuScript.Name = "menuScript";
            this.menuScript.Size = new System.Drawing.Size( 72, 22 );
            this.menuScript.Text = "Script(&C)";
            // 
            // menuScriptUpdate
            // 
            this.menuScriptUpdate.Name = "menuScriptUpdate";
            this.menuScriptUpdate.Size = new System.Drawing.Size( 200, 22 );
            this.menuScriptUpdate.Text = "Update Script List(&U)";
            this.menuScriptUpdate.Click += new System.EventHandler( this.menuScriptUpdate_Click );
            // 
            // menuSetting
            // 
            this.menuSetting.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPreference,
            this.menuSettingGameControler,
            this.menuSettingPaletteTool,
            this.menuSettingShortcut,
            this.menuSettingMidi,
            this.menuSettingUtauVoiceDB,
            this.toolStripMenuItem6,
            this.menuSettingDefaultSingerStyle,
            this.toolStripMenuItem7,
            this.menuSettingPositionQuantize,
            this.menuSettingLengthQuantize,
            this.toolStripMenuItem8,
            this.menuSettingSingerProperty} );
            this.menuSetting.Name = "menuSetting";
            this.menuSetting.Size = new System.Drawing.Size( 80, 22 );
            this.menuSetting.Text = "Setting(&S)";
            this.menuSetting.DropDownOpening += new System.EventHandler( this.menuSetting_DropDownOpening );
            // 
            // menuSettingPreference
            // 
            this.menuSettingPreference.Name = "menuSettingPreference";
            this.menuSettingPreference.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPreference.Text = "Preference(&P)";
            this.menuSettingPreference.Click += new System.EventHandler( this.menuSettingPreference_Click );
            // 
            // menuSettingGameControler
            // 
            this.menuSettingGameControler.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingGameControlerSetting,
            this.menuSettingGameControlerLoad,
            this.menuSettingGameControlerRemove} );
            this.menuSettingGameControler.Name = "menuSettingGameControler";
            this.menuSettingGameControler.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingGameControler.Text = "Game Controler(&G)";
            // 
            // menuSettingGameControlerSetting
            // 
            this.menuSettingGameControlerSetting.Name = "menuSettingGameControlerSetting";
            this.menuSettingGameControlerSetting.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerSetting.Text = "Setting(&S)";
            this.menuSettingGameControlerSetting.Click += new System.EventHandler( this.menuSettingGameControlerSetting_Click );
            // 
            // menuSettingGameControlerLoad
            // 
            this.menuSettingGameControlerLoad.Name = "menuSettingGameControlerLoad";
            this.menuSettingGameControlerLoad.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerLoad.Text = "Load(&L)";
            this.menuSettingGameControlerLoad.Click += new System.EventHandler( this.menuSettingGameControlerLoad_Click );
            // 
            // menuSettingGameControlerRemove
            // 
            this.menuSettingGameControlerRemove.Name = "menuSettingGameControlerRemove";
            this.menuSettingGameControlerRemove.Size = new System.Drawing.Size( 142, 22 );
            this.menuSettingGameControlerRemove.Text = "Remove(&R)";
            this.menuSettingGameControlerRemove.Click += new System.EventHandler( this.menuSettingGameControlerRemove_Click );
            // 
            // menuSettingPaletteTool
            // 
            this.menuSettingPaletteTool.Name = "menuSettingPaletteTool";
            this.menuSettingPaletteTool.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPaletteTool.Text = "Palette Tool(&T)";
            // 
            // menuSettingShortcut
            // 
            this.menuSettingShortcut.Name = "menuSettingShortcut";
            this.menuSettingShortcut.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingShortcut.Text = "Shortcut Key(&S)";
            this.menuSettingShortcut.Click += new System.EventHandler( this.menuSettingShortcut_Click );
            // 
            // menuSettingMidi
            // 
            this.menuSettingMidi.Name = "menuSettingMidi";
            this.menuSettingMidi.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingMidi.Text = "MIDI(&M)";
            this.menuSettingMidi.Click += new System.EventHandler( this.menuSettingMidi_Click );
            // 
            // menuSettingUtauVoiceDB
            // 
            this.menuSettingUtauVoiceDB.Name = "menuSettingUtauVoiceDB";
            this.menuSettingUtauVoiceDB.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingUtauVoiceDB.Text = "UTAU Voice DB(&U)";
            this.menuSettingUtauVoiceDB.Click += new System.EventHandler( this.menuSettingUtauVoiceDB_Click );
            // 
            // toolStripMenuItem6
            // 
            this.toolStripMenuItem6.Name = "toolStripMenuItem6";
            this.toolStripMenuItem6.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingDefaultSingerStyle
            // 
            this.menuSettingDefaultSingerStyle.Name = "menuSettingDefaultSingerStyle";
            this.menuSettingDefaultSingerStyle.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingDefaultSingerStyle.Text = "Singing Style Defaults(&D)";
            this.menuSettingDefaultSingerStyle.Click += new System.EventHandler( this.menuSettingDefaultSingerStyle_Click );
            // 
            // toolStripMenuItem7
            // 
            this.toolStripMenuItem7.Name = "toolStripMenuItem7";
            this.toolStripMenuItem7.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingPositionQuantize
            // 
            this.menuSettingPositionQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPositionQuantize04,
            this.menuSettingPositionQuantize08,
            this.menuSettingPositionQuantize16,
            this.menuSettingPositionQuantize32,
            this.menuSettingPositionQuantize64,
            this.menuSettingPositionQuantize128,
            this.menuSettingPositionQuantizeOff,
            this.toolStripMenuItem9,
            this.menuSettingPositionQuantizeTriplet} );
            this.menuSettingPositionQuantize.Name = "menuSettingPositionQuantize";
            this.menuSettingPositionQuantize.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingPositionQuantize.Text = "Quantize(&Q)";
            // 
            // menuSettingPositionQuantize04
            // 
            this.menuSettingPositionQuantize04.Name = "menuSettingPositionQuantize04";
            this.menuSettingPositionQuantize04.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize04.Text = "1/4";
            this.menuSettingPositionQuantize04.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantize08
            // 
            this.menuSettingPositionQuantize08.Name = "menuSettingPositionQuantize08";
            this.menuSettingPositionQuantize08.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize08.Text = "1/8";
            this.menuSettingPositionQuantize08.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantize16
            // 
            this.menuSettingPositionQuantize16.Name = "menuSettingPositionQuantize16";
            this.menuSettingPositionQuantize16.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize16.Text = "1/16";
            this.menuSettingPositionQuantize16.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantize32
            // 
            this.menuSettingPositionQuantize32.Name = "menuSettingPositionQuantize32";
            this.menuSettingPositionQuantize32.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize32.Text = "1/32";
            this.menuSettingPositionQuantize32.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantize64
            // 
            this.menuSettingPositionQuantize64.Name = "menuSettingPositionQuantize64";
            this.menuSettingPositionQuantize64.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize64.Text = "1/64";
            this.menuSettingPositionQuantize64.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantize128
            // 
            this.menuSettingPositionQuantize128.Name = "menuSettingPositionQuantize128";
            this.menuSettingPositionQuantize128.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantize128.Text = "1/128";
            this.menuSettingPositionQuantize128.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // menuSettingPositionQuantizeOff
            // 
            this.menuSettingPositionQuantizeOff.Name = "menuSettingPositionQuantizeOff";
            this.menuSettingPositionQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantizeOff.Text = "Off";
            this.menuSettingPositionQuantizeOff.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // toolStripMenuItem9
            // 
            this.toolStripMenuItem9.Name = "toolStripMenuItem9";
            this.toolStripMenuItem9.Size = new System.Drawing.Size( 110, 6 );
            // 
            // menuSettingPositionQuantizeTriplet
            // 
            this.menuSettingPositionQuantizeTriplet.Name = "menuSettingPositionQuantizeTriplet";
            this.menuSettingPositionQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingPositionQuantizeTriplet.Text = "Triplet";
            this.menuSettingPositionQuantizeTriplet.Click += new System.EventHandler( this.h_positionQuantizeTriplet );
            // 
            // menuSettingLengthQuantize
            // 
            this.menuSettingLengthQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingLengthQuantize04,
            this.menuSettingLengthQuantize08,
            this.menuSettingLengthQuantize16,
            this.menuSettingLengthQuantize32,
            this.menuSettingLengthQuantize64,
            this.menuSettingLengthQuantize128,
            this.menuSettingLengthQuantizeOff,
            this.toolStripSeparator1,
            this.menuSettingLengthQuantizeTriplet} );
            this.menuSettingLengthQuantize.Name = "menuSettingLengthQuantize";
            this.menuSettingLengthQuantize.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingLengthQuantize.Text = "Length(&L)";
            // 
            // menuSettingLengthQuantize04
            // 
            this.menuSettingLengthQuantize04.Name = "menuSettingLengthQuantize04";
            this.menuSettingLengthQuantize04.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize04.Text = "1/4";
            this.menuSettingLengthQuantize04.Click += new System.EventHandler( this.h_lengthQuantize04 );
            // 
            // menuSettingLengthQuantize08
            // 
            this.menuSettingLengthQuantize08.Name = "menuSettingLengthQuantize08";
            this.menuSettingLengthQuantize08.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize08.Text = "1/8";
            this.menuSettingLengthQuantize08.Click += new System.EventHandler( this.h_lengthQuantize08 );
            // 
            // menuSettingLengthQuantize16
            // 
            this.menuSettingLengthQuantize16.Name = "menuSettingLengthQuantize16";
            this.menuSettingLengthQuantize16.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize16.Text = "1/16";
            this.menuSettingLengthQuantize16.Click += new System.EventHandler( this.h_lengthQuantize16 );
            // 
            // menuSettingLengthQuantize32
            // 
            this.menuSettingLengthQuantize32.Name = "menuSettingLengthQuantize32";
            this.menuSettingLengthQuantize32.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize32.Text = "1/32";
            this.menuSettingLengthQuantize32.Click += new System.EventHandler( this.h_lengthQuantize32 );
            // 
            // menuSettingLengthQuantize64
            // 
            this.menuSettingLengthQuantize64.Name = "menuSettingLengthQuantize64";
            this.menuSettingLengthQuantize64.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize64.Text = "1/64";
            this.menuSettingLengthQuantize64.Click += new System.EventHandler( this.h_lengthQuantize64 );
            // 
            // menuSettingLengthQuantize128
            // 
            this.menuSettingLengthQuantize128.Name = "menuSettingLengthQuantize128";
            this.menuSettingLengthQuantize128.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantize128.Text = "1/128";
            this.menuSettingLengthQuantize128.Click += new System.EventHandler( this.h_lengthQuantize128 );
            // 
            // menuSettingLengthQuantizeOff
            // 
            this.menuSettingLengthQuantizeOff.Name = "menuSettingLengthQuantizeOff";
            this.menuSettingLengthQuantizeOff.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantizeOff.Text = "Off";
            this.menuSettingLengthQuantizeOff.Click += new System.EventHandler( this.h_lengthQuantizeOff );
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size( 110, 6 );
            // 
            // menuSettingLengthQuantizeTriplet
            // 
            this.menuSettingLengthQuantizeTriplet.Name = "menuSettingLengthQuantizeTriplet";
            this.menuSettingLengthQuantizeTriplet.Size = new System.Drawing.Size( 113, 22 );
            this.menuSettingLengthQuantizeTriplet.Text = "Triplet";
            this.menuSettingLengthQuantizeTriplet.Click += new System.EventHandler( this.h_lengthQuantizeTriplet );
            // 
            // toolStripMenuItem8
            // 
            this.toolStripMenuItem8.Name = "toolStripMenuItem8";
            this.toolStripMenuItem8.Size = new System.Drawing.Size( 220, 6 );
            // 
            // menuSettingSingerProperty
            // 
            this.menuSettingSingerProperty.Enabled = false;
            this.menuSettingSingerProperty.Name = "menuSettingSingerProperty";
            this.menuSettingSingerProperty.Size = new System.Drawing.Size( 223, 22 );
            this.menuSettingSingerProperty.Text = "Singer Properties(&S)";
            // 
            // menuHelp
            // 
            this.menuHelp.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHelpAbout,
            this.menuHelpDebug} );
            this.menuHelp.Name = "menuHelp";
            this.menuHelp.Size = new System.Drawing.Size( 65, 22 );
            this.menuHelp.Text = "Help(&H)";
            // 
            // menuHelpAbout
            // 
            this.menuHelpAbout.Name = "menuHelpAbout";
            this.menuHelpAbout.Size = new System.Drawing.Size( 180, 22 );
            this.menuHelpAbout.Text = "About Cadencii(&A)";
            this.menuHelpAbout.Click += new System.EventHandler( this.menuHelpAbout_Click );
            // 
            // menuHelpDebug
            // 
            this.menuHelpDebug.Name = "menuHelpDebug";
            this.menuHelpDebug.Size = new System.Drawing.Size( 180, 22 );
            this.menuHelpDebug.Text = "Debug";
            this.menuHelpDebug.Visible = false;
            this.menuHelpDebug.Click += new System.EventHandler( this.menuHelpDebug_Click );
            // 
            // menuHidden
            // 
            this.menuHidden.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHiddenEditLyric,
            this.menuHiddenEditFlipToolPointerPencil,
            this.menuHiddenEditFlipToolPointerEraser,
            this.menuHiddenVisualForwardParameter,
            this.menuHiddenVisualBackwardParameter,
            this.menuHiddenTrackNext,
            this.menuHiddenTrackBack,
            this.menuHiddenCopy,
            this.menuHiddenPaste,
            this.menuHiddenCut} );
            this.menuHidden.Name = "menuHidden";
            this.menuHidden.Size = new System.Drawing.Size( 91, 22 );
            this.menuHidden.Text = "MenuHidden";
            this.menuHidden.Visible = false;
            // 
            // menuHiddenEditLyric
            // 
            this.menuHiddenEditLyric.Name = "menuHiddenEditLyric";
            this.menuHiddenEditLyric.ShortcutKeys = System.Windows.Forms.Keys.F2;
            this.menuHiddenEditLyric.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditLyric.Text = "Start Lyric Input";
            this.menuHiddenEditLyric.Visible = false;
            this.menuHiddenEditLyric.Click += new System.EventHandler( this.menuHiddenEditLyric_Click );
            // 
            // menuHiddenEditFlipToolPointerPencil
            // 
            this.menuHiddenEditFlipToolPointerPencil.Name = "menuHiddenEditFlipToolPointerPencil";
            this.menuHiddenEditFlipToolPointerPencil.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            this.menuHiddenEditFlipToolPointerPencil.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditFlipToolPointerPencil.Text = "Change Tool Pointer / Pencil";
            this.menuHiddenEditFlipToolPointerPencil.Visible = false;
            this.menuHiddenEditFlipToolPointerPencil.Click += new System.EventHandler( this.menuHiddenEditFlipToolPointerPencil_Click );
            // 
            // menuHiddenEditFlipToolPointerEraser
            // 
            this.menuHiddenEditFlipToolPointerEraser.Name = "menuHiddenEditFlipToolPointerEraser";
            this.menuHiddenEditFlipToolPointerEraser.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.menuHiddenEditFlipToolPointerEraser.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenEditFlipToolPointerEraser.Text = "Change Tool Pointer/ Eraser";
            this.menuHiddenEditFlipToolPointerEraser.Visible = false;
            this.menuHiddenEditFlipToolPointerEraser.Click += new System.EventHandler( this.menuHiddenEditFlipToolPointerEraser_Click );
            // 
            // menuHiddenVisualForwardParameter
            // 
            this.menuHiddenVisualForwardParameter.Name = "menuHiddenVisualForwardParameter";
            this.menuHiddenVisualForwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.Next)));
            this.menuHiddenVisualForwardParameter.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenVisualForwardParameter.Text = "Next Control Curve";
            this.menuHiddenVisualForwardParameter.Visible = false;
            this.menuHiddenVisualForwardParameter.Click += new System.EventHandler( this.menuHiddenVisualForwardParameter_Click );
            // 
            // menuHiddenVisualBackwardParameter
            // 
            this.menuHiddenVisualBackwardParameter.Name = "menuHiddenVisualBackwardParameter";
            this.menuHiddenVisualBackwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenVisualBackwardParameter.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenVisualBackwardParameter.Text = "Previous Control Curve";
            this.menuHiddenVisualBackwardParameter.Visible = false;
            this.menuHiddenVisualBackwardParameter.Click += new System.EventHandler( this.menuHiddenVisualBackwardParameter_Click );
            // 
            // menuHiddenTrackNext
            // 
            this.menuHiddenTrackNext.Name = "menuHiddenTrackNext";
            this.menuHiddenTrackNext.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Next)));
            this.menuHiddenTrackNext.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenTrackNext.Text = "Next Track";
            this.menuHiddenTrackNext.Visible = false;
            this.menuHiddenTrackNext.Click += new System.EventHandler( this.menuHiddenTrackNext_Click );
            // 
            // menuHiddenTrackBack
            // 
            this.menuHiddenTrackBack.Name = "menuHiddenTrackBack";
            this.menuHiddenTrackBack.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenTrackBack.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenTrackBack.Text = "Previous Track";
            this.menuHiddenTrackBack.Visible = false;
            this.menuHiddenTrackBack.Click += new System.EventHandler( this.menuHiddenTrackBack_Click );
            // 
            // menuHiddenCopy
            // 
            this.menuHiddenCopy.Name = "menuHiddenCopy";
            this.menuHiddenCopy.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenCopy.Text = "Copy";
            this.menuHiddenCopy.Click += new System.EventHandler( this.commonEditCopy_Click );
            // 
            // menuHiddenPaste
            // 
            this.menuHiddenPaste.Name = "menuHiddenPaste";
            this.menuHiddenPaste.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenPaste.Text = "Paste";
            this.menuHiddenPaste.Click += new System.EventHandler( this.commonEditPaste_Click );
            // 
            // menuHiddenCut
            // 
            this.menuHiddenCut.Name = "menuHiddenCut";
            this.menuHiddenCut.Size = new System.Drawing.Size( 304, 22 );
            this.menuHiddenCut.Text = "Cut";
            this.menuHiddenCut.Click += new System.EventHandler( this.commonEditCut_Click );
            // 
            // saveXmlVsqDialog
            // 
            this.saveXmlVsqDialog.Filter = "VSQ Format(*.vsq)|*.vsq|Original Format(*.evsq)|*.evsq|All files(*.*)|*.*";
            // 
            // cMenuPiano
            // 
            this.cMenuPiano.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoPointer,
            this.cMenuPianoPencil,
            this.cMenuPianoEraser,
            this.cMenuPianoPaletteTool,
            this.toolStripSeparator15,
            this.cMenuPianoCurve,
            this.toolStripMenuItem13,
            this.cMenuPianoFixed,
            this.cMenuPianoQuantize,
            this.cMenuPianoLength,
            this.cMenuPianoGrid,
            this.toolStripMenuItem14,
            this.cMenuPianoUndo,
            this.cMenuPianoRedo,
            this.toolStripMenuItem15,
            this.cMenuPianoCut,
            this.cMenuPianoCopy,
            this.cMenuPianoPaste,
            this.cMenuPianoDelete,
            this.toolStripMenuItem16,
            this.cMenuPianoSelectAll,
            this.cMenuPianoSelectAllEvents,
            this.toolStripMenuItem17,
            this.cMenuPianoImportLyric,
            this.cMenuPianoExpressionProperty,
            this.cMenuPianoVibratoProperty} );
            this.cMenuPiano.Name = "cMenuPiano";
            this.cMenuPiano.ShowCheckMargin = true;
            this.cMenuPiano.ShowImageMargin = false;
            this.cMenuPiano.Size = new System.Drawing.Size( 242, 480 );
            this.cMenuPiano.Opening += new System.ComponentModel.CancelEventHandler( this.cMenuPiano_Opening );
            // 
            // cMenuPianoPointer
            // 
            this.cMenuPianoPointer.Name = "cMenuPianoPointer";
            this.cMenuPianoPointer.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPointer.Text = "Arrow(&A)";
            this.cMenuPianoPointer.Click += new System.EventHandler( this.cMenuPianoPointer_Click );
            // 
            // cMenuPianoPencil
            // 
            this.cMenuPianoPencil.Name = "cMenuPianoPencil";
            this.cMenuPianoPencil.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPencil.Text = "Pencil(&W)";
            this.cMenuPianoPencil.Click += new System.EventHandler( this.cMenuPianoPencil_Click );
            // 
            // cMenuPianoEraser
            // 
            this.cMenuPianoEraser.Name = "cMenuPianoEraser";
            this.cMenuPianoEraser.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoEraser.Text = "Eraser(&E)";
            this.cMenuPianoEraser.Click += new System.EventHandler( this.cMenuPianoEraser_Click );
            // 
            // cMenuPianoPaletteTool
            // 
            this.cMenuPianoPaletteTool.Name = "cMenuPianoPaletteTool";
            this.cMenuPianoPaletteTool.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPaletteTool.Text = "Palette Tool";
            // 
            // toolStripSeparator15
            // 
            this.toolStripSeparator15.Name = "toolStripSeparator15";
            this.toolStripSeparator15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCurve
            // 
            this.cMenuPianoCurve.Name = "cMenuPianoCurve";
            this.cMenuPianoCurve.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCurve.Text = "Curve(&V)";
            this.cMenuPianoCurve.Click += new System.EventHandler( this.cMenuPianoCurve_Click );
            // 
            // toolStripMenuItem13
            // 
            this.toolStripMenuItem13.Name = "toolStripMenuItem13";
            this.toolStripMenuItem13.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoFixed
            // 
            this.cMenuPianoFixed.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoFixed01,
            this.cMenuPianoFixed02,
            this.cMenuPianoFixed04,
            this.cMenuPianoFixed08,
            this.cMenuPianoFixed16,
            this.cMenuPianoFixed32,
            this.cMenuPianoFixed64,
            this.cMenuPianoFixed128,
            this.cMenuPianoFixedOff,
            this.toolStripMenuItem18,
            this.cMenuPianoFixedTriplet,
            this.cMenuPianoFixedDotted} );
            this.cMenuPianoFixed.Name = "cMenuPianoFixed";
            this.cMenuPianoFixed.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoFixed.Text = "Note Fixed Length(&N)";
            // 
            // cMenuPianoFixed01
            // 
            this.cMenuPianoFixed01.Name = "cMenuPianoFixed01";
            this.cMenuPianoFixed01.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed01.Text = "1/ 1 [1920]";
            this.cMenuPianoFixed01.Click += new System.EventHandler( this.cMenuPianoFixed01_Click );
            // 
            // cMenuPianoFixed02
            // 
            this.cMenuPianoFixed02.Name = "cMenuPianoFixed02";
            this.cMenuPianoFixed02.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed02.Text = "1/ 2 [960]";
            this.cMenuPianoFixed02.Click += new System.EventHandler( this.cMenuPianoFixed02_Click );
            // 
            // cMenuPianoFixed04
            // 
            this.cMenuPianoFixed04.Name = "cMenuPianoFixed04";
            this.cMenuPianoFixed04.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed04.Text = "1/ 4 [480]";
            this.cMenuPianoFixed04.Click += new System.EventHandler( this.cMenuPianoFixed04_Click );
            // 
            // cMenuPianoFixed08
            // 
            this.cMenuPianoFixed08.Name = "cMenuPianoFixed08";
            this.cMenuPianoFixed08.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed08.Text = "1/ 8 [240]";
            this.cMenuPianoFixed08.Click += new System.EventHandler( this.cMenuPianoFixed08_Click );
            // 
            // cMenuPianoFixed16
            // 
            this.cMenuPianoFixed16.Name = "cMenuPianoFixed16";
            this.cMenuPianoFixed16.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed16.Text = "1/16 [120]";
            this.cMenuPianoFixed16.Click += new System.EventHandler( this.cMenuPianoFixed16_Click );
            // 
            // cMenuPianoFixed32
            // 
            this.cMenuPianoFixed32.Name = "cMenuPianoFixed32";
            this.cMenuPianoFixed32.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed32.Text = "1/32 [60]";
            this.cMenuPianoFixed32.Click += new System.EventHandler( this.cMenuPianoFixed32_Click );
            // 
            // cMenuPianoFixed64
            // 
            this.cMenuPianoFixed64.Name = "cMenuPianoFixed64";
            this.cMenuPianoFixed64.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed64.Text = "1/64 [30]";
            this.cMenuPianoFixed64.Click += new System.EventHandler( this.cMenuPianoFixed64_Click );
            // 
            // cMenuPianoFixed128
            // 
            this.cMenuPianoFixed128.Name = "cMenuPianoFixed128";
            this.cMenuPianoFixed128.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixed128.Text = "1/128[15]";
            this.cMenuPianoFixed128.Click += new System.EventHandler( this.cMenuPianoFixed128_Click );
            // 
            // cMenuPianoFixedOff
            // 
            this.cMenuPianoFixedOff.Name = "cMenuPianoFixedOff";
            this.cMenuPianoFixedOff.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedOff.Text = "オフ";
            this.cMenuPianoFixedOff.Click += new System.EventHandler( this.cMenuPianoFixedOff_Click );
            // 
            // toolStripMenuItem18
            // 
            this.toolStripMenuItem18.Name = "toolStripMenuItem18";
            this.toolStripMenuItem18.Size = new System.Drawing.Size( 138, 6 );
            // 
            // cMenuPianoFixedTriplet
            // 
            this.cMenuPianoFixedTriplet.Name = "cMenuPianoFixedTriplet";
            this.cMenuPianoFixedTriplet.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedTriplet.Text = "3連符";
            this.cMenuPianoFixedTriplet.Click += new System.EventHandler( this.cMenuPianoFixedTriplet_Click );
            // 
            // cMenuPianoFixedDotted
            // 
            this.cMenuPianoFixedDotted.Name = "cMenuPianoFixedDotted";
            this.cMenuPianoFixedDotted.Size = new System.Drawing.Size( 141, 22 );
            this.cMenuPianoFixedDotted.Text = "付点";
            this.cMenuPianoFixedDotted.Click += new System.EventHandler( this.cMenuPianoFixedDotted_Click );
            // 
            // cMenuPianoQuantize
            // 
            this.cMenuPianoQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoQuantize04,
            this.cMenuPianoQuantize08,
            this.cMenuPianoQuantize16,
            this.cMenuPianoQuantize32,
            this.cMenuPianoQuantize64,
            this.cMenuPianoQuantize128,
            this.cMenuPianoQuantizeOff,
            this.toolStripMenuItem26,
            this.cMenuPianoQuantizeTriplet} );
            this.cMenuPianoQuantize.Name = "cMenuPianoQuantize";
            this.cMenuPianoQuantize.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoQuantize.Text = "Quantize(&Q)";
            // 
            // cMenuPianoQuantize04
            // 
            this.cMenuPianoQuantize04.Name = "cMenuPianoQuantize04";
            this.cMenuPianoQuantize04.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize04.Text = "1/4";
            this.cMenuPianoQuantize04.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantize08
            // 
            this.cMenuPianoQuantize08.Name = "cMenuPianoQuantize08";
            this.cMenuPianoQuantize08.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize08.Text = "1/8";
            this.cMenuPianoQuantize08.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantize16
            // 
            this.cMenuPianoQuantize16.Name = "cMenuPianoQuantize16";
            this.cMenuPianoQuantize16.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize16.Text = "1/16";
            this.cMenuPianoQuantize16.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantize32
            // 
            this.cMenuPianoQuantize32.Name = "cMenuPianoQuantize32";
            this.cMenuPianoQuantize32.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize32.Text = "1/32";
            this.cMenuPianoQuantize32.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantize64
            // 
            this.cMenuPianoQuantize64.Name = "cMenuPianoQuantize64";
            this.cMenuPianoQuantize64.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize64.Text = "1/64";
            this.cMenuPianoQuantize64.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantize128
            // 
            this.cMenuPianoQuantize128.Name = "cMenuPianoQuantize128";
            this.cMenuPianoQuantize128.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantize128.Text = "1/128";
            this.cMenuPianoQuantize128.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // cMenuPianoQuantizeOff
            // 
            this.cMenuPianoQuantizeOff.Name = "cMenuPianoQuantizeOff";
            this.cMenuPianoQuantizeOff.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantizeOff.Text = "オフ";
            this.cMenuPianoQuantizeOff.Click += new System.EventHandler( this.handlePositionQuantize );
            // 
            // toolStripMenuItem26
            // 
            this.toolStripMenuItem26.Name = "toolStripMenuItem26";
            this.toolStripMenuItem26.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoQuantizeTriplet
            // 
            this.cMenuPianoQuantizeTriplet.Name = "cMenuPianoQuantizeTriplet";
            this.cMenuPianoQuantizeTriplet.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoQuantizeTriplet.Text = "3連符";
            this.cMenuPianoQuantizeTriplet.Click += new System.EventHandler( this.h_positionQuantizeTriplet );
            // 
            // cMenuPianoLength
            // 
            this.cMenuPianoLength.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoLength04,
            this.cMenuPianoLength08,
            this.cMenuPianoLength16,
            this.cMenuPianoLength32,
            this.cMenuPianoLength64,
            this.cMenuPianoLength128,
            this.cMenuPianoLengthOff,
            this.toolStripMenuItem32,
            this.cMenuPianoLengthTriplet} );
            this.cMenuPianoLength.Name = "cMenuPianoLength";
            this.cMenuPianoLength.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoLength.Text = "Length(&L)";
            // 
            // cMenuPianoLength04
            // 
            this.cMenuPianoLength04.Name = "cMenuPianoLength04";
            this.cMenuPianoLength04.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength04.Text = "1/4";
            this.cMenuPianoLength04.Click += new System.EventHandler( this.h_lengthQuantize04 );
            // 
            // cMenuPianoLength08
            // 
            this.cMenuPianoLength08.Name = "cMenuPianoLength08";
            this.cMenuPianoLength08.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength08.Text = "1/8";
            this.cMenuPianoLength08.Click += new System.EventHandler( this.h_lengthQuantize08 );
            // 
            // cMenuPianoLength16
            // 
            this.cMenuPianoLength16.Name = "cMenuPianoLength16";
            this.cMenuPianoLength16.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength16.Text = "1/16";
            this.cMenuPianoLength16.Click += new System.EventHandler( this.h_lengthQuantize16 );
            // 
            // cMenuPianoLength32
            // 
            this.cMenuPianoLength32.Name = "cMenuPianoLength32";
            this.cMenuPianoLength32.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength32.Text = "1/32";
            this.cMenuPianoLength32.Click += new System.EventHandler( this.h_lengthQuantize32 );
            // 
            // cMenuPianoLength64
            // 
            this.cMenuPianoLength64.Name = "cMenuPianoLength64";
            this.cMenuPianoLength64.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength64.Text = "1/64";
            this.cMenuPianoLength64.Click += new System.EventHandler( this.h_lengthQuantize64 );
            // 
            // cMenuPianoLength128
            // 
            this.cMenuPianoLength128.Name = "cMenuPianoLength128";
            this.cMenuPianoLength128.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLength128.Text = "1/128";
            this.cMenuPianoLength128.Click += new System.EventHandler( this.h_lengthQuantize128 );
            // 
            // cMenuPianoLengthOff
            // 
            this.cMenuPianoLengthOff.Name = "cMenuPianoLengthOff";
            this.cMenuPianoLengthOff.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLengthOff.Text = "オフ";
            this.cMenuPianoLengthOff.Click += new System.EventHandler( this.h_lengthQuantizeOff );
            // 
            // toolStripMenuItem32
            // 
            this.toolStripMenuItem32.Name = "toolStripMenuItem32";
            this.toolStripMenuItem32.Size = new System.Drawing.Size( 106, 6 );
            // 
            // cMenuPianoLengthTriplet
            // 
            this.cMenuPianoLengthTriplet.Name = "cMenuPianoLengthTriplet";
            this.cMenuPianoLengthTriplet.Size = new System.Drawing.Size( 109, 22 );
            this.cMenuPianoLengthTriplet.Text = "3連符";
            this.cMenuPianoLengthTriplet.Click += new System.EventHandler( this.h_lengthQuantizeTriplet );
            // 
            // cMenuPianoGrid
            // 
            this.cMenuPianoGrid.Name = "cMenuPianoGrid";
            this.cMenuPianoGrid.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoGrid.Text = "Show/Hide Grid Line(&S)";
            this.cMenuPianoGrid.Click += new System.EventHandler( this.cMenuPianoGrid_Click );
            // 
            // toolStripMenuItem14
            // 
            this.toolStripMenuItem14.Name = "toolStripMenuItem14";
            this.toolStripMenuItem14.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoUndo
            // 
            this.cMenuPianoUndo.Name = "cMenuPianoUndo";
            this.cMenuPianoUndo.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoUndo.Text = "Undo(&U)";
            this.cMenuPianoUndo.Click += new System.EventHandler( this.cMenuPianoUndo_Click );
            // 
            // cMenuPianoRedo
            // 
            this.cMenuPianoRedo.Name = "cMenuPianoRedo";
            this.cMenuPianoRedo.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoRedo.Text = "Redo(&R)";
            this.cMenuPianoRedo.Click += new System.EventHandler( this.cMenuPianoRedo_Click );
            // 
            // toolStripMenuItem15
            // 
            this.toolStripMenuItem15.Name = "toolStripMenuItem15";
            this.toolStripMenuItem15.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoCut
            // 
            this.cMenuPianoCut.Name = "cMenuPianoCut";
            this.cMenuPianoCut.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCut.Text = "Cut(&T)";
            this.cMenuPianoCut.Click += new System.EventHandler( this.cMenuPianoCut_Click );
            // 
            // cMenuPianoCopy
            // 
            this.cMenuPianoCopy.Name = "cMenuPianoCopy";
            this.cMenuPianoCopy.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoCopy.Text = "Copy(&C)";
            this.cMenuPianoCopy.Click += new System.EventHandler( this.cMenuPianoCopy_Click );
            // 
            // cMenuPianoPaste
            // 
            this.cMenuPianoPaste.Name = "cMenuPianoPaste";
            this.cMenuPianoPaste.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoPaste.Text = "Paste(&P)";
            this.cMenuPianoPaste.Click += new System.EventHandler( this.cMenuPianoPaste_Click );
            // 
            // cMenuPianoDelete
            // 
            this.cMenuPianoDelete.Name = "cMenuPianoDelete";
            this.cMenuPianoDelete.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoDelete.Text = "Delete(&D)";
            this.cMenuPianoDelete.Click += new System.EventHandler( this.cMenuPianoDelete_Click );
            // 
            // toolStripMenuItem16
            // 
            this.toolStripMenuItem16.Name = "toolStripMenuItem16";
            this.toolStripMenuItem16.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoSelectAll
            // 
            this.cMenuPianoSelectAll.Name = "cMenuPianoSelectAll";
            this.cMenuPianoSelectAll.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoSelectAll.Text = "Select All(&A)";
            this.cMenuPianoSelectAll.Click += new System.EventHandler( this.cMenuPianoSelectAll_Click );
            // 
            // cMenuPianoSelectAllEvents
            // 
            this.cMenuPianoSelectAllEvents.Name = "cMenuPianoSelectAllEvents";
            this.cMenuPianoSelectAllEvents.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoSelectAllEvents.Text = "Select All Events(&E)";
            this.cMenuPianoSelectAllEvents.Click += new System.EventHandler( this.cMenuPianoSelectAllEvents_Click );
            // 
            // toolStripMenuItem17
            // 
            this.toolStripMenuItem17.Name = "toolStripMenuItem17";
            this.toolStripMenuItem17.Size = new System.Drawing.Size( 238, 6 );
            // 
            // cMenuPianoImportLyric
            // 
            this.cMenuPianoImportLyric.Name = "cMenuPianoImportLyric";
            this.cMenuPianoImportLyric.Size = new System.Drawing.Size( 241, 22 );
            this.cMenuPianoImportLyric.Text = "Insert Lyrics(&L)";
            this.cMenuPianoImportLyric.Click += new System.EventHandler