﻿/*
 * SelectedBezierPoint.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace Boare.Cadencii {

    public class SelectedBezierPoint {
        public int ChainID = -1;
        public int PointID = -1;
        public BezierPickedSide Picked;
        public BezierPoint Original;

        public SelectedBezierPoint() {
            ChainID = -1;
            PointID = -1;
        }

        public SelectedBezierPoint( int chain_id, int point_id, BezierPickedSide picked_side, BezierPoint original ) {
            ChainID = chain_id;
            PointID = point_id;
            Picked = picked_side;
            Original = (BezierPoint)original.Clone();
        }
    }

}
