﻿/*
 * Common.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Drawing.Imaging;

using Boare.Lib.AppUtil;
using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    //delegate void InitVsqScriptDelegate( EditorManager manager );

    static class Common {
        public static string _( string id ) {
            return Messaging.GetMessage( id );
        }

        /// <summary>
        /// fontを使って文字を描画したとき，文字の縦方向の中心線と，描画時に指定した座標との間にどれだけのオフセットが生じるかを調べる
        /// </summary>
        /// <param name="font"></param>
        /// <returns></returns>
        public static unsafe int GetStringOffset( Font font ) {
            SizeF str_size = MeasureString( "Qjp", font );
            if ( str_size.Width <= 0 || str_size.Height <= 0 ) {
                return 0;
            }
            int draw_pos = (int)(str_size.Height / 2);
            Bitmap test = new Bitmap( (int)str_size.Width * 2, (int)str_size.Height * 2, System.Drawing.Imaging.PixelFormat.Format24bppRgb );
            using ( Graphics g = Graphics.FromImage( test ) ) {
                g.DrawString(
                    "Qjp",
                    font,
                    Brushes.Black,
                    new PointF( str_size.Width / 2, draw_pos ) );
            }
            BitmapData bdat = test.LockBits(
                new Rectangle( 0, 0, test.Width, test.Height ),
                ImageLockMode.ReadOnly,
                PixelFormat.Format24bppRgb );
            int stride = bdat.Stride;
            byte* dat = (byte*)bdat.Scan0;
            bool found = false;
            int firsty = draw_pos;
            for ( int y = 0; y < bdat.Height; y++ ) {
                int pos = y * stride - 3;
                for ( int x = 0; x < bdat.Width; x++ ) {
                    pos += 3;
                    if ( dat[pos] == 0 ) {
                        found = true;
                        break;
                    }
                }
                if ( found ) {
                    firsty = y;
                    break;
                }
            }
            found = false;
            int lasty = draw_pos;
            for ( int y = bdat.Height - 1; y >= 0; y-- ) {
                int pos = y * stride - 3;
                for ( int x = 0; x < bdat.Width; x++ ) {
                    pos++;
                    if ( dat[pos] == 0 ) {
                        found = true;
                        break;
                    }
                }
                if ( found ) {
                    lasty = y;
                    break;
                }
            }
            return (lasty + firsty) / 2 - draw_pos;
        }

        public static SizeF MeasureString( string item, Font font ) {
            using ( Bitmap test = new Bitmap( 10, 10 ) )
            using ( Graphics g = Graphics.FromImage( test ) ) {
                return g.MeasureString( item, font );
            }
        }
        
        /// <summary>
        /// 文字列itemをfontを用いて描画したとき、幅widthピクセルに収まるようにitemを調節したものを返します。
        /// 例えば"1 Voice"→"1 Voi..."ナド。
        /// </summary>
        /// <param name="item"></param>
        /// <param name="font"></param>
        /// <param name="width"></param>
        /// <returns></returns>
        public static string TrimString( string item, Font font, int width ) {
            string edited = item;
            int delete_count = item.Length;
            while ( true ) {
                SizeF measured = MeasureString( edited, font );
                if ( measured.Width <= width ) {
                    return edited;
                }
                delete_count -= 1;
                if ( delete_count > 0 ) {
                    edited = item.Substring( 0, delete_count ) + "...";
                } else {
                    return edited;
                }
            }
        }

        
        public static void DebugWriteLine( string message ) {
#if DEBUG
            Console.WriteLine( message );
#endif
        }
    }

}