﻿/*
 * PlaySound.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Runtime.InteropServices;

namespace Boare.Cadencii {

    static class PlaySound {
        [DllImport( "PlaySound" )]
        private static extern void SoundInit( int block_size, int sample_rate );

        [DllImport( "PlaySound" )]
        private static extern unsafe void SoundAppend( double* left, double* right, int length );

        [DllImport( "PlaySound" )]
        private static extern void SoundWaitForExit();

        [DllImport( "PlaySound" )]
        private static extern double SoundGetPosition();

        [DllImport( "PlaySound" )]
        private static extern bool SoundIsBusy();

        [DllImport( "PlaySound" )]
        private static extern void SoundReset();

        public static void WaitForExit() {
            try {
                SoundWaitForExit();
            } catch {
            }
        }

        public static void Init( int block_size, int sample_rate ) {
            try {
                SoundInit( block_size, sample_rate );
            } catch ( Exception ex ){
                bocoree.debug.push_log( "PlaySound.Init; ex=" + ex );
            }
        }

        public static unsafe void Append( double[] left, double[] right, int length ) {
#if DEBUG
            bocoree.debug.push_log( "calling SoundAppend..." );
#endif
            try{
                fixed ( double* pl = &left[0] )
                fixed ( double* pr = &right[0] ) {
                    SoundAppend( pl, pr, length );
                }
#if DEBUG
                bocoree.debug.push_log( "...done" );
#endif
            } catch ( Exception ex ) {
                bocoree.debug.push_log( "PlaySound.Append; ex=" + ex );
            }
        }

        public static double GetPosition() {
            double ret = -1;
            try {
                ret = SoundGetPosition();
            } catch ( Exception ex ) {
#if DEBUG
                bocoree.debug.push_log( "PlaySound.GetPosition; ex=" + ex );
#endif
            }
            return ret;
        }

        public static void Reset() {
            try {
                SoundReset();
            } catch ( Exception ex ) {
#if DEBUG
                bocoree.debug.push_log( "PlaySound.Reset; ex=" + ex );
#endif
            }
        }
    }

}
