﻿/*
 * EditAreaMouseEvetArgs.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Boare.Cadencii {

    class EditAreaMouseEventArgs {
        int m_clock;
        int m_value;
        MouseEventArgs m_base;

        public Point Location {
            get {
                return m_base.Location;
            }
        }


        public int X {
            get {
                return m_base.X;
            }
        }


        public int Y {
            get {
                return m_base.Y;
            }
        }


        internal EditAreaMouseEventArgs( int clock, int value, MouseEventArgs e ) {
            m_clock = clock;
            m_value = value;
            m_base = e;
        }


        public int Clock {
            get {
                return m_clock;
            }
        }


        public int Value {
            get {
                return m_value;
            }
        }


        public MouseButtons Button {
            get {
                return m_base.Button;
            }
        }
    }

}