﻿/*
 * VsqEventList.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    /// <summary>
    /// 固有ID付きのVsqEventのリストを取り扱う
    /// </summary>
    [Serializable]
    public class VsqEventList {
        private List<VsqEvent> m_list;
        private List<int> m_ids;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public VsqEventList() {
            m_list = new List<VsqEvent>();
            m_ids = new List<int>();
        }

        public void Clear() {
            m_list.Clear();
            m_ids.Clear();
        }

        public IEnumerator<VsqEvent> GetEnumerator() {
            for ( int i = 0; i < m_list.Count; i++ ) {
                yield return m_list[i];
            }
        }

        public void Add( VsqEvent item ) {
            int new_id = GetNextId( 0 );
            item.InternalID = new_id;
            m_list.Add( item );
            m_ids.Add( new_id );
            m_list.Sort();
            for ( int i = 0; i < m_list.Count; i++ ) {
                m_ids[i] = m_list[i].InternalID;
            }
        }

        public void RemoveAt( int index ) {
            m_list.RemoveAt( index );
            m_ids.RemoveAt( index );
        }

        private int GetNextId( int next ) {
            int index = -1;
            List<int> current = new List<int>( m_ids );
            int nfound = 0;
            while ( true ) {
                index++;
                if ( !current.Contains( index ) ) {
                    nfound++;
                    if ( nfound == next + 1 ) {
                        return index;
                    } else {
                        current.Add( index );
                    }
                }
            }
        }

        public int Count {
            get {
                return m_list.Count;
            }
        }

        public VsqEvent this[int index] {
            get {
                return m_list[index];
            }
            set {
                m_list[index] = value;
            }
        }
    }

}
