/*
 * Copyright (C) 2003-2005 Kenji Aiko, 
 * based on http://ruffnex.oc.to/kenji/text/load_dll/ (browse: 13 Feb, 2010)
 */
#pragma once

#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <windowsx.h>
#include <tchar.h>
#include <winnt.h>
#include <stdio.h>
#include <vcclr.h>
#include <stdlib.h>

// DllMaiñA^b`Af^b`
#define DLL_ATTACH    0
#define DLL_DETACH    1

#define SIZE_OF_NT_SIGNATURE       (sizeof(DWORD))
#define SIZE_OF_PARAMETER_BLOCK    4096
#define IMAGE_PARAMETER_MAGIC      0xCDC31337

#define RVATOVA(base, offset) ( \
    (LPVOID)((DWORD)(base) + (DWORD)(offset)))

// NTVOl`
#define NTSIGNATURE(ptr) (  \
    (LPVOID)((PBYTE)(ptr) + \
    ((PIMAGE_DOS_HEADER)(ptr))->e_lfanew))

// PEwb_ItZbg
#define PEFHDROFFSET(ptr) ( \
    (LPVOID)((PBYTE)(ptr) + \
    ((PIMAGE_DOS_HEADER)(ptr))->e_lfanew + \
    SIZE_OF_NT_SIGNATURE))

// IvVwb_ItZbg
#define OPTHDROFFSET(ptr) ( \
    (LPVOID)((PBYTE)(ptr) + \
    ((PIMAGE_DOS_HEADER)(ptr))->e_lfanew + \
    SIZE_OF_NT_SIGNATURE +  \
    sizeof(IMAGE_FILE_HEADER)))

// ZNVwb_ItZbg
#define SECHDROFFSET(ptr) ( \
    (LPVOID)((PBYTE)(ptr) + \
    ((PIMAGE_DOS_HEADER)(ptr))->e_lfanew + \
    SIZE_OF_NT_SIGNATURE +  \
    sizeof(IMAGE_FILE_HEADER) + \
    sizeof(IMAGE_OPTIONAL_HEADER)))

// \̂̋E1oCgݒ
#pragma pack(push, 1)

typedef struct{
    DWORD dwPageRVA;
    DWORD dwBlockSize;
} IMAGE_FIXUP_BLOCK, *PIMAGE_FIXUP_BLOCK;

typedef struct{
    WORD offset:12;
    WORD type:4;
} IMAGE_FIXUP_ENTRY, *PIMAGE_FIXUP_ENTRY;

// DLLC[Wf[^̍\
typedef struct __imageparameters{
    PVOID pImageBase;
    TCHAR svName[MAX_PATH];
    DWORD dwFlags;
    int nLockCount;
    struct __imageparameters *next;
} IMAGE_PARAMETERS, *PIMAGE_PARAMETERS;

#pragma pack(pop)

// DllMaiñ|C^֐
typedef BOOL (WINAPI *DLLMAIN_T)(HMODULE, DWORD, LPVOID);

typedef struct{
    union{
        DWORD Function;
        DWORD Ordinal;
        DWORD AddressOfData;
    } u1;
} MY_IMAGE_THUNK_DATA, *PMY_IMAGE_THUNK_DATA;

// DLLf[^x[X̃gbv
PIMAGE_PARAMETERS g_pImageParamHead;
// NeBJZNVϐ
CRITICAL_SECTION g_DLLCrit;
bool g_initialized = false;

using namespace System;
using namespace System::Runtime::InteropServices;

namespace org{ namespace kbinani{ namespace cadencii{ namespace util {

	public ref class DllLoad{
	public:
        // -------------------------------------------------------------
        // 
        // -------------------------------------------------------------
        static void initialize();

		static bool isInitialized();

		// -------------------------------------------------------------
        // I
        // -------------------------------------------------------------
        static void terminate();

        // -------------------------------------------------------------
        // DLLɂGNX|[g֐
        // @FDLLnhA֐
        // ߂lFȂ֐AhXAsȂNULL
        // -------------------------------------------------------------
        static IntPtr getProcAddress( IntPtr hModule, String ^lpProcName );

        // -------------------------------------------------------------
        // DLL[h֐
        // @FDLLt@CA\iNULLŒjAtO
        // ߂lFDLLnhAsNULL
        // -------------------------------------------------------------
        static IntPtr loadDllEx( String^ lpLibFileName,
                                 IntPtr hReserved,
                                 DWORD dwFlags );

        // -------------------------------------------------------------
        // DLL[h֐iLoadDLLExւ̋nj
        // @FDLLt@C
        // ߂lFDLLnhAsNULL
        // -------------------------------------------------------------
        static IntPtr loadDll( String^ lpLibFileName );

        // -------------------------------------------------------------
        // DLLJ֐
        // @FDLLnh
        // ߂lFTRUEAsFALSE
        // -------------------------------------------------------------
        static BOOL freeDll( IntPtr hLibModule );

	private:
		static void lptstrFromString( String ^from, LPTSTR to );

		// -------------------------------------------------------------
        // f[^x[XɐVDLLǉ
        // @FDLLnhADLLiʎqj
        // ߂lFerror -1, success(find 0, make 1)
        // -------------------------------------------------------------
        static int AddDllReference( PVOID pImageBase, 
                             PTCHAR szName,
                             DWORD dwFlags );

        // -------------------------------------------------------------
        // f[^x[XDLL폜
        // @FDLLnhADLLiʎqj
        // ߂lFerror -1, success(keep 0, delete 1)
        // -------------------------------------------------------------
        static int RemoveDllReference( PVOID pImageBase, 
                                PTCHAR svName,
                                PDWORD pdwFlags );

        // -------------------------------------------------------------
        // p[^e[uDLLẴnhԂ
        // @FDLLt@C
        // ߂lF΂DLL̃nhAȂNULL
        // -------------------------------------------------------------
        static IntPtr^ GetDllHandle( PTCHAR svName );

        // -------------------------------------------------------------
        // p[^e[uDLLẴt@CԂ
        // @FDLLnhAi[|C^Ai[̈̃TCY
        // ߂lF΃t@C̃TCYAȂ0
        // -------------------------------------------------------------
        static DWORD GetDllFileName( HMODULE hModule, 
                              LPTSTR lpFileName, 
                              DWORD dwSize );

		// -------------------------------------------------------------
        // DLLDLLMain֐𑖂点֐
        // @FDLLnhADLLTCYAAttach or Detach̃tO
        // ߂lFerror -1, success(keep 0, delete 1)
        // -------------------------------------------------------------
        static BOOL RunDllMain( PVOID pImageBase, 
                                DWORD dwImageSize, 
                                BOOL bDetach );

        // -------------------------------------------------------------
        // C|[g֐̃AhX֐
        // @FDLLt@CC[WADLLt@CC[W̃TCY
        // ߂lFTRUEAsFALSE
        // -------------------------------------------------------------
        static BOOL PrepareDllImage( PVOID pMemoryImage, 
                              DWORD dwImageSize );

		// -------------------------------------------------------------
        // DLLC[WveNg
        // @FDLLt@CC[W
        // ߂lFTRUEAsFALSE
        // -------------------------------------------------------------
        static BOOL ProtectDllImage( PVOID pMemoryImage );

        // -------------------------------------------------------------
        // DLLC[WRs[֐
        // @FDLLt@CC[WARs[|C^
        // ߂lFTRUEAsFALSE
        // -------------------------------------------------------------
        static BOOL MapDllFromImage( PVOID pDLLFileImage, 
                              PVOID pMemoryImage );

		// -------------------------------------------------------------
        // DLLC[WDLL[h֐
        // @FDLLt@CC[WA}bsOiʎqjAtO
        // ߂lFDLLnhAsNULL
        // -------------------------------------------------------------
        static HMODULE LoadDllFromImage( LPVOID pDLLFileImage, 
                                  PTCHAR szMappingName,
                                  DWORD dwFlags );
	};

} } } }
