#include "org.kbinani.cadencii.util.h"

using namespace System;
using namespace org::kbinani::cadencii::util;

namespace org{ namespace kbinani{ namespace cadencii{ namespace util {

    // -------------------------------------------------------------
    // 
    // -------------------------------------------------------------
	void DllLoad::initialize(){
        if( g_initialized ){
            return;
        }
        InitializeCriticalSection( &g_DLLCrit );
        g_pImageParamHead = NULL;
        g_initialized = true;
    }

	bool DllLoad::isInitialized(){
        return g_initialized;
    }

    // -------------------------------------------------------------
    // I
    // -------------------------------------------------------------
	void DllLoad::terminate(){
        if( !g_initialized ) return;
        PIMAGE_PARAMETERS cur = g_pImageParamHead;

        while( cur != NULL ){
            PIMAGE_PARAMETERS next = cur->next;
            delete [] cur;
            cur = next;
        }

        DeleteCriticalSection( &g_DLLCrit );
    }


    // -------------------------------------------------------------
    // DLLɂGNX|[g֐
    // @FDLLnhA֐
    // ߂lFȂ֐AhXAsȂNULL
    // -------------------------------------------------------------
	IntPtr DllLoad::getProcAddress( IntPtr hModule, 
                                  String ^lpProcName ){
        // hModuleNULLȂ΃G[
		if( IntPtr::Zero == hModule ){
            return IntPtr::Zero;
        }
        
        // fBNgJEg擾
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( hModule.ToPointer() );
        int nDirCount = poh->NumberOfRvaAndSizes;
        if( nDirCount < 16 ){
            return IntPtr::Zero;
        }

        // GNX|[gfBNge[u擾
        DWORD dwIDEE = IMAGE_DIRECTORY_ENTRY_EXPORT;
        if( poh->DataDirectory[dwIDEE].Size == 0 ){
            return IntPtr::Zero;
        }
        DWORD dwAddr = poh->DataDirectory[dwIDEE].VirtualAddress;
        PIMAGE_EXPORT_DIRECTORY ped = (PIMAGE_EXPORT_DIRECTORY)RVATOVA( hModule.ToInt32(), dwAddr );
        
        // 擾
		TCHAR char_proc_name[MAX_PATH];
		_stprintf_s( char_proc_name, _T( "%s" ), lpProcName );
        int nOrdinal = (LOWORD(char_proc_name)) - ped->Base;
        
        if( HIWORD( char_proc_name ) != 0 ){
            int count = ped->NumberOfNames;
            // OƏ擾
            DWORD *pdwNamePtr = (PDWORD)RVATOVA( hModule.ToInt32(), ped->AddressOfNames );
            WORD *pwOrdinalPtr = (PWORD)RVATOVA( hModule.ToInt32(), ped->AddressOfNameOrdinals );
            // ֐
            int i;
            for( i = 0; i < count; i++, pdwNamePtr++, pwOrdinalPtr++ ){
                PTCHAR svName = (PTCHAR)RVATOVA( hModule.ToInt32(), *pdwNamePtr );
                if( lstrcmp(svName, char_proc_name ) == 0 ){
                    nOrdinal = *pwOrdinalPtr;
                    break;
                }
            }
            // ȂNULLԋp
            if( i == count ){
                return IntPtr::Zero;
            }
        }
        
        // ֐Ԃ
        PDWORD pAddrTable = (PDWORD)RVATOVA( hModule.ToInt32(), ped->AddressOfFunctions );
		IntPtr ret( RVATOVA( hModule.ToInt32(), pAddrTable[nOrdinal] ) );
        return ret;
    }

    // -------------------------------------------------------------
    // DLL[h֐
    // @FDLLt@CA\iNULLŒjAtO
    // ߂lFDLLnhAsNULL
    // -------------------------------------------------------------
	IntPtr DllLoad::loadDllEx( String^ lpLibFileName,
                             IntPtr hReserved,
                             DWORD dwFlags ){
        // փt@C@w
        // iLOAD_WITH_ALTERED_SEARCH_PATHj̓T|[gȂ
        if( dwFlags & LOAD_WITH_ALTERED_SEARCH_PATH ){
#ifdef _DEBUG
			Console::WriteLine( "DllLoad#loadDllEx; error: not supported LOAD_WITH_ALTERED_PATH" );
#endif
            return IntPtr::Zero;
        }

        // DLLpX擾
        TCHAR szPath[MAX_PATH + 1], *szFilePart;
		TCHAR char_lib_file_name[MAX_PATH + 1];
		lptstrFromString( lpLibFileName, char_lib_file_name );

#ifdef _DEBUG
		Console::WriteLine( "DllLoad#loadDllEx; lpLibFileName=" + lpLibFileName );
		Console::WriteLine( "DllLoad#loadDllEx; char_lib_file_name=" + gcnew String( char_lib_file_name ) );
#endif
		int nLen = SearchPath( NULL, char_lib_file_name, _T( ".dll" ), MAX_PATH, szPath, &szFilePart );
        if( nLen == 0 ){
#ifdef _DEBUG
			Console::WriteLine( "DllLoad#loadDllEx; SearchPath returns 0" );
#endif
            return IntPtr::Zero;
        }

        // t@C}bsO
        HANDLE hFile = CreateFile( szPath,
                                   GENERIC_READ,
                                   FILE_SHARE_READ,
                                   NULL,
                                   OPEN_EXISTING,
                                   0,
                                   NULL );
        if( hFile == INVALID_HANDLE_VALUE ){
#ifdef _DEBUG
			Console::WriteLine( "DllLoad#loadDllEx; CreateFile returns INVALID_HANDLE_VALUE" );
#endif
            return IntPtr::Zero;
        }
        HANDLE hMapping = CreateFileMapping( hFile,
                                             NULL,
                                             PAGE_READONLY,
                                             0,
                                             0,
                                             NULL );
        CloseHandle( hFile );
        LPVOID pBaseAddr = MapViewOfFile( hMapping, FILE_MAP_READ, 0, 0, 0 );
        if( pBaseAddr == NULL ){
            CloseHandle( hMapping );
#ifdef _DEBUG
			Console::WriteLine( "DllLoad#loadDllEx; MapViewOfFile returns NULL" );
#endif
			return IntPtr::Zero;
        }

        // DLLC[W̓ǂݍ
		Guid id = Guid::NewGuid();
		TCHAR mapping_name[MAX_PATH + 1];
		String ^str_id = "org.kbinani.cadencii.util." + Guid::NewGuid().ToString();
		lptstrFromString( str_id, mapping_name );
        HMODULE hRet = LoadDllFromImage( pBaseAddr,
                                         mapping_name,
                                         dwFlags & ~LOAD_WITH_ALTERED_SEARCH_PATH );

        // t@C}bsO
        UnmapViewOfFile( pBaseAddr );
        CloseHandle( hMapping );
		IntPtr ptr( hRet );
        return ptr;
    }


    // -------------------------------------------------------------
    // DLL[h֐iLoadDLLExւ̋nj
    // @FDLLt@C
    // ߂lFDLLnhAsNULL
    // -------------------------------------------------------------
	IntPtr DllLoad::loadDll( String^ lpLibFileName ){
		return loadDllEx( lpLibFileName, IntPtr::Zero, 0 );
    }


    // -------------------------------------------------------------
    // DLLJ֐
    // @FDLLnh
    // ߂lFTRUEAsFALSE
    // -------------------------------------------------------------
	BOOL DllLoad::freeDll( IntPtr hLibModule ){
        // hLibModuleNULLȂO
		if( hLibModule == IntPtr::Zero ){
            return FALSE;
        }
        
        // PEf[^̎
		PIMAGE_DOS_HEADER doshead = (PIMAGE_DOS_HEADER)hLibModule.ToPointer();
        if( doshead->e_magic != IMAGE_DOS_SIGNATURE ){
            return FALSE;
        }
		if( *(PDWORD)NTSIGNATURE(hLibModule.ToPointer()) != IMAGE_NT_SIGNATURE ){
            return FALSE;
        }
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( hLibModule.ToPointer() );
        if( poh->Magic != 0x010B ){
            return FALSE;
        }

        DWORD dwFlags;
        TCHAR szName[MAX_PATH];
        // DLLf[^x[X͂
        int dllaction = RemoveDllReference( hLibModule.ToPointer(), szName, &dwFlags );
        if( dllaction == -1 ){
            return FALSE;
        }

        // DLL̃f^b`
        if( !(dwFlags & (LOAD_LIBRARY_AS_DATAFILE | DONT_RESOLVE_DLL_REFERENCES)) ){
            // JE^0idllaction=1jȂDLLf^b`ďI
            if( dllaction ){
                RunDllMain( hLibModule.ToPointer(), poh->SizeOfImage, DLL_DETACH );
                return UnmapViewOfFile( hLibModule.ToPointer() );
            }
        }
        return TRUE;
    }

	void DllLoad::lptstrFromString( String ^from, LPTSTR to ){
		pin_ptr<const wchar_t> wch = PtrToStringChars( from );
#ifdef UNICODE
		wcscpy_s( to, wch );
#else
		size_t origsize = wcslen( wch ) + 1;
		size_t convertedChars = 0;
		wcstombs_s( &convertedChars, to, origsize, wch, _TRUNCATE );
#endif
	}

	// -------------------------------------------------------------
    // f[^x[XɐVDLLǉ
    // @FDLLnhADLLiʎqj
    // ߂lFerror -1, success(find 0, make 1)
    // -------------------------------------------------------------
	int DllLoad::AddDllReference( PVOID pImageBase, 
                         PTCHAR szName,
                         DWORD dwFlags ){
        // szNameȂ΃G[
        if( szName == NULL ) return -1;

        EnterCriticalSection( &g_DLLCrit );

        PIMAGE_PARAMETERS cur = g_pImageParamHead;
        
        // DLL
        while( cur != NULL ){
            if( cur->pImageBase != pImageBase ){
                cur = cur->next;
            }else{
                cur->nLockCount++;
                LeaveCriticalSection( &g_DLLCrit );
                return 0;
            }
        }
         
        // VDLL̐
        if( NULL == (cur = (PIMAGE_PARAMETERS)new IMAGE_PARAMETERS[1]) ){
            LeaveCriticalSection( &g_DLLCrit );
            return -1;
        }
        cur->pImageBase = pImageBase;
        cur->nLockCount = 1;
        cur->dwFlags    = dwFlags;
        cur->next       = g_pImageParamHead;
        lstrcpyn( cur->svName, szName, MAX_PATH );

        g_pImageParamHead = cur;

        LeaveCriticalSection( &g_DLLCrit );
        return 1;
    }


    // -------------------------------------------------------------
    // f[^x[XDLL폜
    // @FDLLnhADLLiʎqj
    // ߂lFerror -1, success(keep 0, delete 1)
    // -------------------------------------------------------------
	int DllLoad::RemoveDllReference( PVOID pImageBase, 
                            PTCHAR svName,
                            PDWORD pdwFlags ){
        EnterCriticalSection( &g_DLLCrit );

        PIMAGE_PARAMETERS prev, cur = g_pImageParamHead;

        // DLL
        while( cur != NULL ){
            if( cur->pImageBase == pImageBase ){
                break;
            }
            prev = cur;
            cur = cur->next;
        }

        // łȂG[
        if( NULL == cur ){
            LeaveCriticalSection( &g_DLLCrit );
            return -1;
        }
        
        cur->nLockCount--;
        *pdwFlags = cur->dwFlags;
        lstrcpyn( svName, cur->svName, MAX_PATH );

        // JE^܂0ȂȂI
        if( cur->nLockCount != 0 ){
            LeaveCriticalSection( &g_DLLCrit );
            return 0;
        }

        // AXV
        if( NULL == prev ){
            g_pImageParamHead = g_pImageParamHead->next;
        }else{
            prev->next = cur->next;
        }

        delete [] cur;
        LeaveCriticalSection( &g_DLLCrit );
        return 1;
    }


    // -------------------------------------------------------------
    // p[^e[uDLLẴnhԂ
    // @FDLLt@C
    // ߂lF΂DLL̃nhAȂNULL
    // -------------------------------------------------------------
	IntPtr^ DllLoad::GetDllHandle( PTCHAR svName ){
        if( NULL == svName ) return IntPtr::Zero;

        EnterCriticalSection( &g_DLLCrit );

        // p[[^e[ũgbv擾
        PIMAGE_PARAMETERS cur = g_pImageParamHead;
        
        // DLL
        while( cur != NULL ){
            if( lstrcmpi( cur->svName, svName ) != 0 ){
                cur = cur->next;
            }else{
                // nhԂ
                LeaveCriticalSection( &g_DLLCrit );
                return gcnew IntPtr( cur->pImageBase );
            }
        }

        // ȂΏI
        LeaveCriticalSection( &g_DLLCrit );
        return IntPtr::Zero;    
    }


    // -------------------------------------------------------------
    // p[^e[uDLLẴt@CԂ
    // @FDLLnhAi[|C^Ai[̈̃TCY
    // ߂lF΃t@C̃TCYAȂ0
    // -------------------------------------------------------------
	DWORD DllLoad::GetDllFileName( HMODULE hModule, 
                          LPTSTR lpFileName, 
                          DWORD dwSize ){
        if( NULL == hModule || NULL == lpFileName || 0 == dwSize ){
            return 0;
        }
        
        // ܂͒ʏGetModuleFileNameŒׂ
		DWORD dwRet = GetModuleFileName( hModule, lpFileName, dwSize );
        if( dwRet != 0 ){
            return dwRet;
        }

        EnterCriticalSection( &g_DLLCrit );

        PIMAGE_PARAMETERS cur = g_pImageParamHead;
        
        // DLL
        while( cur != NULL ){
            if( cur->pImageBase != hModule ){
                cur = cur->next;
            }else{
                // 當ƃTCYԂ
                LeaveCriticalSection( &g_DLLCrit );
                lstrcpyn( lpFileName, cur->svName, dwSize );
                return lstrlen( lpFileName );
            }
        } 

        LeaveCriticalSection( &g_DLLCrit );
        return 0;
    }

	// -------------------------------------------------------------
    // DLLDLLMain֐𑖂点֐
    // @FDLLnhADLLTCYAAttach or Detach̃tO
    // ߂lFerror -1, success(keep 0, delete 1)
    // -------------------------------------------------------------
	BOOL DllLoad::RunDllMain( PVOID pImageBase, 
                            DWORD dwImageSize, 
                            BOOL bDetach ){
		// tǑ
        PIMAGE_FILE_HEADER pfh = (PIMAGE_FILE_HEADER)PEFHDROFFSET( pImageBase );
        if( (pfh->Characteristics & IMAGE_FILE_DLL) == 0 ){
            return TRUE;
        }

        // DLLMain֐̃AhX擾
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( pImageBase );
		void* rawPtrMain = RVATOVA( pImageBase, poh->AddressOfEntryPoint );
		DLLMAIN_T pMain = (DLLMAIN_T)rawPtrMain;			
#ifdef _DEBUG
		Console::WriteLine( "DllLoad#RunDllMain; pMain=0x" + String::Format( "{0:X}", (int)pMain ) );
#endif
        // f^b`orA^b`
        if( bDetach ){
            return pMain( (HMODULE)pImageBase, DLL_PROCESS_DETACH, NULL );
        }else{
            return pMain( (HMODULE)pImageBase, DLL_PROCESS_ATTACH, NULL );
        }
    }


    // -------------------------------------------------------------
    // C|[g֐̃AhX֐
    // @FDLLt@CC[WADLLt@CC[W̃TCY
    // ߂lFTRUEAsFALSE
    // -------------------------------------------------------------
	BOOL DllLoad::PrepareDllImage( PVOID pMemoryImage, 
                          DWORD dwImageSize ){
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( pMemoryImage );
        int nDirCount = poh->NumberOfRvaAndSizes;
        if( nDirCount < 16 ){
            return FALSE;
        }

        PIMAGE_SECTION_HEADER psh = (PIMAGE_SECTION_HEADER)SECHDROFFSET( pMemoryImage );

        DWORD dwIDEI = IMAGE_DIRECTORY_ENTRY_IMPORT;

        if( poh->DataDirectory[dwIDEI].Size != 0 ){
            PIMAGE_IMPORT_DESCRIPTOR pid = (PIMAGE_IMPORT_DESCRIPTOR)RVATOVA( pMemoryImage, 
                                                                              poh->DataDirectory[dwIDEI].VirtualAddress );

            for( ; pid->OriginalFirstThunk != 0; pid++ ){
                PTCHAR svDllName = (PTCHAR)RVATOVA( pMemoryImage, pid->Name );
                HMODULE hDll = GetModuleHandle( svDllName );
                if( hDll == NULL ){
                    if( (hDll = LoadLibrary( svDllName )) == NULL ){
                        return FALSE;
                    }
                }

                if( pid->TimeDateStamp != 0 ){
                    continue;
                }
                
                pid->ForwarderChain = (DWORD)hDll;
                pid->TimeDateStamp  = IMAGE_PARAMETER_MAGIC;

                PMY_IMAGE_THUNK_DATA ptd_in = (PMY_IMAGE_THUNK_DATA)RVATOVA( pMemoryImage, pid->OriginalFirstThunk );
                PMY_IMAGE_THUNK_DATA ptd_out = (PMY_IMAGE_THUNK_DATA)RVATOVA( pMemoryImage, pid->FirstThunk );
                    
                for( ; ptd_in->u1.Function != NULL; ptd_in++, ptd_out++ ){
                    FARPROC func;
                    if( ptd_in->u1.Ordinal & 0x80000000 ){
                        func = GetProcAddress( hDll, MAKEINTRESOURCEA( ptd_in->u1.Ordinal ) );
                    }else{
                        PIMAGE_IMPORT_BY_NAME pibn = (PIMAGE_IMPORT_BY_NAME)RVATOVA( pMemoryImage, ptd_in->u1.AddressOfData );
                        func = GetProcAddress( hDll, (PCHAR)pibn->Name );
                    }
                    
                    if( func == NULL ){
                        return FALSE;
                    }
                        
                    ptd_out->u1.Function = (DWORD)func;
                }
            }
        }

        DWORD dwIDEB = IMAGE_DIRECTORY_ENTRY_BASERELOC;
        DWORD delta = (DWORD)pMemoryImage - (DWORD)poh->ImageBase;

        if( (delta == 0) || (poh->DataDirectory[dwIDEB].Size == 0) ){
            return TRUE;
        }
        
        PIMAGE_FIXUP_BLOCK pfb = (PIMAGE_FIXUP_BLOCK)RVATOVA( pMemoryImage, poh->DataDirectory[dwIDEB].VirtualAddress );

        while( pfb->dwPageRVA != 0 ){
            
            int count = (pfb->dwBlockSize - sizeof( IMAGE_FIXUP_BLOCK )) / sizeof( IMAGE_FIXUP_ENTRY );
            PIMAGE_FIXUP_ENTRY pfe = (PIMAGE_FIXUP_ENTRY)((PTCHAR)pfb + sizeof( IMAGE_FIXUP_BLOCK ));

            for( int i = 0; i < count; i++, pfe++ ){
                PVOID fixaddr = RVATOVA( pMemoryImage, pfb->dwPageRVA + pfe->offset );
                
                switch( pfe->type ){
                    case IMAGE_REL_BASED_ABSOLUTE:{
                        break;
                    }
                    case IMAGE_REL_BASED_HIGH:{
                        *((WORD *)fixaddr) += HIWORD( delta );
                        break;
                    }
                    case IMAGE_REL_BASED_LOW:{
                        *((WORD *)fixaddr) += LOWORD( delta );
                        break;
                    }
                    case IMAGE_REL_BASED_HIGHLOW:{
                        *((DWORD *)fixaddr) += delta;
                        break;
                    }
                    case IMAGE_REL_BASED_HIGHADJ:{
                        *((WORD *)fixaddr) = HIWORD( ((*((WORD *)fixaddr)) << 16) | (*(WORD *)(pfe+1))+ delta + 0x00008000);
                        pfe++;
                        break;
                    }
                    default:{
                        return FALSE;
                    }
                }
            }

            pfb = (PIMAGE_FIXUP_BLOCK)((PTCHAR)pfb + pfb->dwBlockSize);
        }
        return TRUE;
    }


    // -------------------------------------------------------------
    // DLLC[WveNg
    // @FDLLt@CC[W
    // ߂lFTRUEAsFALSE
    // -------------------------------------------------------------
	BOOL DllLoad::ProtectDllImage( PVOID pMemoryImage ){
        // ZNV擾
        PIMAGE_FILE_HEADER pfh = (PIMAGE_FILE_HEADER)PEFHDROFFSET( pMemoryImage );
        int nSectionCount = pfh->NumberOfSections;

        // ZNVwb_擾
        PIMAGE_SECTION_HEADER psh = (PIMAGE_SECTION_HEADER)SECHDROFFSET( pMemoryImage );

        for( int i = 0; i < nSectionCount; i++, psh++ ){

            // ZNVAhXƃTCY̎擾
            PVOID secMemAddr = (PTCHAR)RVATOVA( pMemoryImage, psh->VirtualAddress );
            
            DWORD chr = psh->Characteristics;
            // veNgtO̐ݒ
            BOOL bWrite  = (chr & IMAGE_SCN_MEM_WRITE)   ? TRUE : FALSE;
            BOOL bRead   = (chr & IMAGE_SCN_MEM_READ)    ? TRUE : FALSE;
            BOOL bExec   = (chr & IMAGE_SCN_MEM_EXECUTE) ? TRUE : FALSE;
            BOOL bShared = (chr & IMAGE_SCN_MEM_SHARED)  ? TRUE : FALSE;
            
            DWORD newProtect = 0;
            // tO
            if( bWrite && bRead && bExec && bShared ){
                newProtect = PAGE_EXECUTE_READWRITE;
            }else if( bWrite && bRead && bExec ){
                newProtect = PAGE_EXECUTE_WRITECOPY;
            }else if( bRead && bExec ){
                newProtect = PAGE_EXECUTE_READ;
            }else if( bExec ){
                newProtect = PAGE_EXECUTE;
            }else if( bWrite && bRead && bShared ){
                newProtect = PAGE_READWRITE; 
            }else if( bWrite && bRead ){
                newProtect = PAGE_WRITECOPY;
            }else if( bRead ){
                newProtect = PAGE_READONLY;
            }

            if( chr & IMAGE_SCN_MEM_NOT_CACHED ){
                newProtect |= PAGE_NOCACHE;
            }

            if( newProtect == 0 ){
                return FALSE;
            }

            DWORD oldProtect;
            // veNgs
            VirtualProtect( secMemAddr, psh->SizeOfRawData, newProtect, &oldProtect );
        }
        return TRUE;
    }


    // -------------------------------------------------------------
    // DLLC[WRs[֐
    // @FDLLt@CC[WARs[|C^
    // ߂lFTRUEAsFALSE
    // -------------------------------------------------------------
	BOOL DllLoad::MapDllFromImage( PVOID pDLLFileImage, 
                          PVOID pMemoryImage ){
        // PEwb_ƃZNVwb_Rs[
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( pDLLFileImage );
        memcpy( pMemoryImage, pDLLFileImage, poh->SizeOfHeaders );

        // ZNV擾
        PIMAGE_FILE_HEADER pfh = (PIMAGE_FILE_HEADER)PEFHDROFFSET( pDLLFileImage );
        int nSectionCount = pfh->NumberOfSections;

        // ZNVwb_|C^擾
        PIMAGE_SECTION_HEADER psh = (PIMAGE_SECTION_HEADER)SECHDROFFSET( pDLLFileImage );

        // ׂẴZNṼRs[
        for( int i = 0; i < nSectionCount; i++, psh++ ){
            PTCHAR secMemAddr  = (PTCHAR)((PTCHAR)pMemoryImage + psh->VirtualAddress);
            PTCHAR secFileAddr = (PTCHAR)((PTCHAR)pDLLFileImage + psh->PointerToRawData);
            int secLen = psh->SizeOfRawData;
            memcpy( secMemAddr, secFileAddr, secLen );
        }
        return TRUE;
    }


    // -------------------------------------------------------------
    // DLLC[WDLL[h֐
    // @FDLLt@CC[WA}bsOiʎqjAtO
    // ߂lFDLLnhAsNULL
    // -------------------------------------------------------------
	HMODULE DllLoad::LoadDllFromImage( LPVOID pDLLFileImage, 
                              PTCHAR szMappingName,
                              DWORD dwFlags ){
        // }bsOȂ΃G[
        if( szMappingName == NULL ){
            return NULL;
        }

        // }bsÕTCY𔻒
        if( lstrlen( szMappingName ) >= MAX_PATH ){
            return NULL;
        }
        
        // PEf[^̔
        PIMAGE_DOS_HEADER doshead = (PIMAGE_DOS_HEADER)pDLLFileImage;
        if( doshead->e_magic != IMAGE_DOS_SIGNATURE ){
            return NULL;
        }
        if( *(DWORD *)NTSIGNATURE( pDLLFileImage ) != IMAGE_NT_SIGNATURE ){
            return NULL;
        }
        PIMAGE_OPTIONAL_HEADER poh = (PIMAGE_OPTIONAL_HEADER)OPTHDROFFSET( pDLLFileImage );
        if( poh->Magic != 0x010B ){
            return NULL;
        }

        // ZNV擾
        PIMAGE_FILE_HEADER pfh = (PIMAGE_FILE_HEADER)PEFHDROFFSET( pDLLFileImage );
        int nSectionCount = pfh->NumberOfSections;

        DWORD pPreferredImageBase = poh->ImageBase;
        DWORD dwImageSize = poh->SizeOfImage;

        PVOID pImageBase;
        HANDLE hmapping = NULL;
        // DLLnhȂΐV
        if( (pImageBase = GetDllHandle( szMappingName )->ToPointer() ) == NULL ){
            BOOL bCreated = FALSE;
            // łɃ}bsOĂ邩ǂ
            hmapping = OpenFileMapping( FILE_MAP_WRITE, TRUE, szMappingName );
            // ĂȂȂ琶
            if( hmapping == NULL ){
                hmapping = CreateFileMapping( INVALID_HANDLE_VALUE,
                                              NULL,
                                              PAGE_READWRITE,
                                              0,
                                              dwImageSize + SIZE_OF_PARAMETER_BLOCK,
                                              szMappingName );
                if( hmapping == NULL ){
                    return NULL;
                }
                bCreated = TRUE;
            }

            // }bsOĂf[^̐擪pImageBase
            pImageBase = MapViewOfFileEx( hmapping,
                                          FILE_MAP_WRITE,
                                          0,
                                          0,
                                          0,
                                          (LPVOID)pPreferredImageBase );
            if( pImageBase == NULL ){
                pImageBase = MapViewOfFileEx( hmapping,
                                              FILE_MAP_WRITE,
                                              0,
                                              0,
                                              0,
                                              NULL );
            }
            CloseHandle( hmapping );
            if( pImageBase == NULL ){
                return NULL;
            }

            // VꂽAx[XAhXςĂ
            if( bCreated || (pImageBase != (LPVOID)pPreferredImageBase) ){
                // DLLC[W}bsO
                if( ! MapDllFromImage( pDLLFileImage, pImageBase ) ){
                    UnmapViewOfFile( pImageBase );
                    return NULL;
                }
            }
            
            // LOAD_LIBRARY_AS_DATAFILEĂȂȂ
            if( !(dwFlags & LOAD_LIBRARY_AS_DATAFILE) ){
                // 
                if( ! PrepareDllImage( pImageBase, dwImageSize ) ){
                    UnmapViewOfFile( pImageBase );
                    return NULL;
                }
                
                // tODONT_RESOLVE_DLL_REFERENCESĂȂ
                if( !(dwFlags & DONT_RESOLVE_DLL_REFERENCES) ){
                    // DLLMainsiA^b`j
                    if( !RunDllMain( pImageBase, dwImageSize, DLL_ATTACH ) ){
                        UnmapViewOfFile( pImageBase );
                        return NULL;
                    }
                }

                // veNgs
                if( !ProtectDllImage( pImageBase ) ){
                    UnmapViewOfFile( pImageBase );
                    return NULL;
                }
            }
        }
        
        // DLLf[^x[X֒ǉ
        if( AddDllReference( pImageBase, szMappingName, dwFlags ) == -1 ){
            if( hmapping != NULL ){
                UnmapViewOfFile( pImageBase );
            }
            return NULL;
        }    

        return (HMODULE)pImageBase;    
    }

} } } }


#ifdef _DEBUG
typedef int (*PADDFUNC)(int, int);
typedef int (*PSUBFUNC)(int, int);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	DllLoad::initialize();
	IntPtr hHandle = DllLoad::loadDll( "test_dll" );
	PADDFUNC pAdd = (PADDFUNC)DllLoad::getProcAddress(hHandle, _T("add_num")).ToPointer();
	int a = (*pAdd)(3, 5);  // 3 + 5 = 8
	/*PSUBFUNC pSub = (PSUBFUNC)DllLoad::getProcAddress(
		GetDLLHandle(_T("test_dll.dll")), _T("sub_num"));
	int b = (*pSub)(8, 5);  // 8 - 5 = 3
	TCHAR szFileName[MAX_PATH];
 	GetDLLFileName(hHandle, szFileName, sizeof(szFileName));
	TCHAR szBuffer[1024];
	wsprintf(szBuffer, _T(
		"FileName = %s\r\na = %d, b = %d\r\n"), szFileName, a, b);
	MessageBox(GetActiveWindow(), szBuffer, _T("Message"), MB_OK);*/
	DllLoad::freeDll(hHandle);
	DllLoad::terminate();
	return 0;
}
#endif
