﻿/*
 * SymbolTableEntry.cs
 * Copyright (C) 2010 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.vsq;

import java.io.*;
#else
using System;

namespace Boare.Lib.Vsq {
#endif

    /// <summary>
    /// SymbolTableの要素を表すクラス。
    /// </summary>
#if JAVA
    public class SymbolTableEntry implements Cloneable {
#else
    public class SymbolTableEntry : ICloneable {
#endif
        /// <summary>
        /// 単語（英語の場合、分節位置にハイフンが入る）
        /// </summary>
        public String Word = "";
        /// <summary>
        /// 発音記号列
        /// </summary>
        public String Symbol = "";

        public SymbolTableEntry( String word, String symbol ) {
            Word = word;
            if ( Word == null ) {
                Word = "";
            }
            Symbol = symbol;
            if ( Symbol == null ) {
                Symbol = "";
            }
        }

        /// <summary>
        /// このオブジェクトのSymbolフィールドのタブ文字を空白に置き換えた文字列を取得します．
        /// </summary>
        /// <returns></returns>
        public String getParsedSymbol() {
            return Symbol.Replace( '\t', ' ' );
        }

        /// <summary>
        /// このオブジェクトのディープ・コピーを取得します
        /// </summary>
        /// <returns></returns>
        public Object clone() {
            return new SymbolTableEntry( Word, Symbol );
        }

        /// <summary>
        /// このオブジェクトのディープ・コピーを取得します
        /// </summary>
        /// <returns></returns>
#if !JAVA
        public Object Clone() {
            return clone();
        }
#endif
    }

#if !JAVA
}
#endif
