﻿/*
 * UstPortamento.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.IO;

namespace Boare.Lib.Vsq {

    [Serializable]
    public class UstPortamento : ICloneable {
        public List<UstPortamentoPoint> Points = new List<UstPortamentoPoint>();
        public int Start;

        public void print( StreamWriter sw ) {
            string pbw = "";
            string pby = "";
            string pbm = "";
            for ( int i = 0; i < Points.Count; i++ ) {
                string comma = (i == 0 ? "" : ",");
                pbw += comma + Points[i].Step;
                pby += comma + Points[i].Value;
                string type = "";
                switch ( Points[i].Type ) {
                    case UstPortamentoType.S:
                        type = "";
                        break;
                    case UstPortamentoType.Linear:
                        type = "s";
                        break;
                    case UstPortamentoType.R:
                        type = "r";
                        break;
                    case UstPortamentoType.J:
                        type = "j";
                        break;
                }
                pbm += comma + type;
            }
            sw.WriteLine( "PBW=" + pbw );
            sw.WriteLine( "PBS=" + Start );
            sw.WriteLine( "PBY=" + pby );
            sw.WriteLine( "PBM=" + pbm );
        }

        public object Clone() {
            UstPortamento ret = new UstPortamento();
            for ( int i = 0; i < Points.Count; i++ ) {
                ret.Points.Add( Points[i] );
            }
            ret.Start = Start;
            return ret;
        }

        /*
        PBW=50,50,46,48,56,50,50,50,50
        PBS=-87
        PBY=-15.9,-20,-31.5,-26.6
        PBM=,s,r,j,s,s,s,s,s
        */
        public void ParseLine( string line ) {
            line = line.ToLower();
            string[] spl = line.Split( '=' );
            if ( spl.Length == 0 ) {
                return;
            }
            string[] values = spl[1].Split( ',' );
            if ( line.StartsWith( "pbs=" ) ) {
                Start = int.Parse( values[0] );
            } else if ( line.StartsWith( "pbw=" ) ) {
                for ( int i = 0; i < values.Length; i++ ) {
                    if ( i >= Points.Count ) {
                        Points.Add( new UstPortamentoPoint() );
                    }
                    UstPortamentoPoint up = Points[i];
                    up.Step = int.Parse( values[i] );
                    Points[i] = up;
                }
            } else if ( line.StartsWith( "pby=" ) ) {
                for ( int i = 0; i < values.Length; i++ ) {
                    if ( i >= Points.Count ) {
                        Points.Add( new UstPortamentoPoint() );
                    }
                    UstPortamentoPoint up = Points[i];
                    up.Value = float.Parse( values[i] );
                    Points[i] = up;
                }
            } else if ( line.StartsWith( "pbm=" ) ) {
                for ( int i = 0; i < values.Length; i++ ) {
                    if ( i >= Points.Count ) {
                        Points.Add( new UstPortamentoPoint() );
                    }
                    UstPortamentoPoint up = Points[i];
                    switch ( values[i].ToLower() ) {
                        case "s":
                            up.Type = UstPortamentoType.Linear;
                            break;
                        case "r":
                            up.Type = UstPortamentoType.R;
                            break;
                        case "j":
                            up.Type = UstPortamentoType.J;
                            break;
                        default:
                            up.Type = UstPortamentoType.S;
                            break;
                    }
                    Points[i] = up;
                }
            } else if ( line.StartsWith( "pbs=" ) ) {

            }
        }
    }

    public struct UstPortamentoPoint {
        public int Step;
        public float Value;
        public UstPortamentoType Type;
    }

    public enum UstPortamentoType{
        /// <summary>
        /// S型．表記は''(空文字)
        /// </summary>
        S,
        /// <summary>
        /// 直線型．表記は's'
        /// </summary>
        Linear,
        /// <summary>
        /// R型．表記は'r'
        /// </summary>
        R,
        /// <summary>
        /// J型．表記は'j'
        /// </summary>
        J,
    }

}
