﻿/*
 * VsqEventItemProxy.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.ComponentModel;
using System.Reflection;

using Boare.Lib.Vsq;
using Boare.Lib.AppUtil;

namespace Boare.Cadencii {

#if false
    [TypeConverter( typeof( VsqEventItemProxyTypeConverter ) )]
    class VsqEventItemProxy {
        private VsqEvent m_proxy;
        public VsqEvent Original;

        public int GetVibratoDelay() {
            return m_proxy.ID.VibratoDelay;
        }

        public int GetPortamentoUsage() {
            return m_proxy.ID.PMbPortamentoUse;
        }

        public VsqID GetVsqIDDifference() {
            VsqEvent item = Original;
            VsqID id = new VsqID();
            id.DEMaccent = Accent;
            id.DEMdecGainRate = Decay;
            id.Dynamics = Velocity;
            if ( item.ID.IconHandle != null ) {
                id.IconHandle = (IconHandle)item.ID.IconHandle.Clone();
            }
            id.Length = Length;
            if ( item.ID.LyricHandle != null ) {
                id.LyricHandle = (LyricHandle)item.ID.LyricHandle.Clone();
            }
            id.Note = Note;
            if ( id.NoteHeadHandle != null ) {
                id.NoteHeadHandle = (NoteHeadHandle)item.ID.NoteHeadHandle.Clone();
            }
            id.PMBendDepth = BendDepth;
            id.PMBendLength = BendLength;
            id.PMbPortamentoUse = GetPortamentoUsage();
            id.type = VsqIDType.Anote;
            if ( VibratoLength <= 0 ) {
                id.VibratoDelay = GetVibratoDelay();
            } else {
                id.VibratoDelay = GetVibratoDelay();
                if ( item.ID.VibratoHandle != null ) {
                    id.VibratoHandle = (VibratoHandle)item.ID.VibratoHandle.Clone();
                } else {
                    id.VibratoHandle = new VibratoHandle();
                }
            }
            id.LyricHandle = new LyricHandle( Phrase, PhoneticSymbol );
            return id;
        }

        public VsqEventItemProxy( VsqEvent item ) {
            Original = (VsqEvent)item.Clone();
            m_proxy = item;
            /*m_clock = item.Clock;
            m_length = item.ID.Length;
            m_note = item.ID.Note;
            m_velocity = item.ID.Dynamics;
            m_bend_depth = item.ID.PMBendDepth;
            m_bend_length = item.ID.PMBendLength;
            m_decay = item.ID.DEMdecGainRate;
            m_accent = item.ID.DEMaccent;
            if ( item.ID.VibratoDelay >= item.ID.Length ) {
                m_vibrato_percent = 0;
            } else {
                m_vibrato_percent = (int)((item.ID.Length - item.ID.VibratoDelay) / item.ID.Length);
            }
            m_portamento_up = false;
            m_portamento_down = false;
            if ( item.ID.PMbPortamentoUse >= 2 ) {
                m_portamento_down = true;
            }
            if ( item.ID.PMbPortamentoUse == 1 || item.ID.PMbPortamentoUse == 3 ) {
                m_portamento_up = true;
            }
            if ( item.ID.LyricHandle != null ) {
                m_phrase = item.ID.LyricHandle.L0.Phrase;
                m_phonetic_symbol = item.ID.LyricHandle.L0.getPhoneticSymbol();
            }*/
        }

        public string Phrase {
            get {
                return m_proxy.ID.LyricHandle.L0.Phrase;
            }
            set {
                m_proxy.ID.LyricHandle.L0.Phrase = value;
            }
        }

        public string PhoneticSymbol {
            get {
                return m_proxy.ID.LyricHandle.L0.getPhoneticSymbol();
            }
            set {
                m_proxy.ID.LyricHandle.L0.setPhoneticSymbol( value );
            }
        }

        public int Clock {
            get {
                return m_proxy.Clock;
            }
            set {
                m_proxy.Clock = value;
            }
        }

        public int Length {
            get {
                return m_proxy.ID.Length;
            }
            set {
                m_proxy.ID.Length = value;
            }
        }

        public int Note {
            get {
                return m_proxy.ID.Note;
            }
            set {
                m_proxy.ID.Note = value;
            }
        }

        public int Velocity {
            get {
                return m_proxy.ID.Dynamics;
            }
            set {
                m_proxy.ID.Dynamics = value;
            }
        }

        public int BendDepth {
            get {
                return m_proxy.ID.PMBendDepth;
            }
            set {
                m_proxy.ID.PMBendDepth = value;
            }
        }

        public int BendLength {
            get {
                return m_proxy.ID.PMBendLength;
            }
            set {
                m_proxy.ID.PMBendLength = value;
            }
        }

        public int Decay {
            get {
                return m_proxy.ID.DEMdecGainRate;
            }
            set {
                m_proxy.ID.DEMdecGainRate = value;
            }
        }

        public int Accent {
            get {
                return m_proxy.ID.DEMaccent;
            }
            set {
                m_proxy.ID.DEMaccent = value;
            }
        }

        public bool UpPortamento {
            get {
                if ( m_proxy.ID.PMbPortamentoUse == 1 || m_proxy.ID.PMbPortamentoUse == 3 ) {
                    return true;
                } else {
                    return false;
                }
            }
            set {
                m_proxy.ID.PMbPortamentoUse = (value ? 1 : 0) + (DownPortamento ? 2 : 0);
            }
        }

        public bool DownPortamento {
            get {
                if ( m_proxy.ID.PMbPortamentoUse >= 2 ) {
                    return true;
                } else {
                    return false;
                }
            }
            set {
                m_proxy.ID.PMbPortamentoUse = (UpPortamento ? 1 : 0) + (value ? 2 : 0);
            }
        }

        public int VibratoLength {
            get {
                if ( m_proxy.ID.VibratoHandle == null ) {
                    return 0;
                } else {
                    return 100 * (m_proxy.ID.Length - m_proxy.ID.VibratoDelay) / m_proxy.ID.Length;
                }
            }
            set {
                if ( value <= 0 ) {
                    m_proxy.ID.VibratoHandle = null;
                } else {
                    if ( m_proxy.ID.VibratoHandle == null ) {
                        m_proxy.ID.VibratoHandle = new VibratoHandle();
                    }
                    m_proxy.ID.VibratoDelay = m_proxy.ID.Length - m_proxy.ID.Length * value / 100;
                }
            }
        }
    }
#else
    [TypeConverter( typeof( VsqEventItemProxyTypeConverter ) )]
    class VsqEventItemProxy {
        private int m_clock;
        private int m_length;
        private int m_note;
        private int m_velocity;
        private int m_bend_depth;
        private int m_bend_length;
        private int m_decay;
        private int m_accent;
        private bool m_portamento_up;
        private bool m_portamento_down;
        private int m_vibrato_percent;
        private string m_phrase;
        private string m_phonetic_symbol;
        private int m_msPreUtterance;
        private int m_msOverlap;
        private int m_moduration;
        public VsqEvent Original;

        public VsqEventItemProxy( VsqEvent item ) {
            Original = (VsqEvent)item.Clone();
            m_clock = item.Clock;
            m_length = item.ID.Length;
            m_note = item.ID.Note;
            m_velocity = item.ID.Dynamics;
            m_bend_depth = item.ID.PMBendDepth;
            m_bend_length = item.ID.PMBendLength;
            m_decay = item.ID.DEMdecGainRate;
            m_accent = item.ID.DEMaccent;
            if ( item.ID.VibratoHandle == null || item.ID.VibratoDelay >= item.ID.Length ) {
                m_vibrato_percent = 0;
            } else {
                m_vibrato_percent = (int)((item.ID.Length - item.ID.VibratoDelay) / (float)item.ID.Length * 100.0f);
            }
            m_portamento_up = false;
            m_portamento_down = false;
            if ( item.ID.PMbPortamentoUse >= 2 ) {
                m_portamento_down = true;
            }
            if ( item.ID.PMbPortamentoUse == 1 || item.ID.PMbPortamentoUse == 3 ) {
                m_portamento_up = true;
            }
            if ( item.ID.LyricHandle != null ) {
                m_phrase = item.ID.LyricHandle.L0.Phrase;
                m_phonetic_symbol = item.ID.LyricHandle.L0.getPhoneticSymbol();
            }
            m_msPreUtterance = item.UstEvent.PreUtterance;
            m_msOverlap = item.UstEvent.VoiceOverlap;
            m_moduration = item.UstEvent.Moduration;
        }

        public int GetVibratoDelay() {
            if ( m_vibrato_percent <= 0 ) {
                return  m_length;
            } else {
                return m_length - (int)(m_length * m_vibrato_percent / 100.0);
            }
        }

        public int GetPortamentoUsage() {
            return (m_portamento_up ? 1 : 0) + (m_portamento_down ? 2 : 0);
        }

        public VsqEvent GetItemDifference() {
            VsqEvent item = Original;
            VsqEvent ret = new VsqEvent();
            ret.Clock = m_clock;
            ret.ID = new VsqID();
            ret.ID.DEMaccent = m_accent;
            ret.ID.DEMdecGainRate = m_decay;
            ret.ID.Dynamics = m_velocity;
            if ( item.ID.IconHandle != null ) {
                ret.ID.IconHandle = (IconHandle)item.ID.IconHandle.Clone();
            }
            ret.ID.Length = m_length;
            if ( item.ID.LyricHandle != null ) {
                ret.ID.LyricHandle = (LyricHandle)item.ID.LyricHandle.Clone();
            }
            ret.ID.Note = m_note;
            if ( ret.ID.NoteHeadHandle != null ) {
                ret.ID.NoteHeadHandle = (NoteHeadHandle)item.ID.NoteHeadHandle.Clone();
            }
            ret.ID.PMBendDepth = m_bend_depth;
            ret.ID.PMBendLength = m_bend_length;
            ret.ID.PMbPortamentoUse = GetPortamentoUsage();
            ret.ID.type = VsqIDType.Anote;
            if ( m_vibrato_percent <= 0 ) {
                ret.ID.VibratoDelay = GetVibratoDelay();
            } else {
                ret.ID.VibratoDelay = GetVibratoDelay();
                if ( item.ID.VibratoHandle != null ) {
                    ret.ID.VibratoHandle = (VibratoHandle)item.ID.VibratoHandle.Clone();
                } else {
                    ret.ID.VibratoHandle = new VibratoHandle();
                }
            }
            ret.ID.LyricHandle = new LyricHandle( m_phrase, m_phonetic_symbol );
            ret.InternalID = Original.InternalID;
            ret.UstEvent.PreUtterance = m_msPreUtterance;
            ret.UstEvent.VoiceOverlap = m_msOverlap;
            ret.UstEvent.Moduration = m_moduration;
            return ret;
        }

        [Category("UTAU")]
        public int PreUtterance {
            get {
                return m_msPreUtterance;
            }
            set {
                m_msPreUtterance = value;
            }
        }

        [Category( "UTAU" )]
        public int Overlap {
            get {
                return m_msOverlap;
            }
            set {
                m_msOverlap = value;
            }
        }

        [Category( "UTAU" )]
        public int Moduration {
            get {
                return m_moduration;
            }
            set {
                m_moduration = value;
            }
        }

        [Category( "Lyric" )]
        public string Phrase {
            get {
                return m_phrase;
            }
            set {
                m_phrase = value;
            }
        }

        [Category( "Lyric" )]
        public string PhoneticSymbol {
            get {
                return m_phonetic_symbol;
            }
            set {
                m_phonetic_symbol = value;
            }
        }

        [Category( "Note" )]
        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }

        [Category( "Note" )]
        public int Length {
            get {
                return m_length;
            }
            set {
                m_length = value;
            }
        }

        [Category( "Note" )]
        public int Note {
            get {
                return m_note;
            }
            set {
                m_note = value;
            }
        }

        [Category( "Note" )]
        public int Velocity {
            get {
                return m_velocity;
            }
            set {
                m_velocity = value;
            }
        }

        [Category( "Note" )]
        public int BendDepth {
            get {
                return m_bend_depth;
            }
            set {
                m_bend_depth = value;
            }
        }

        [Category( "Note" )]
        public int BendLength {
            get {
                return m_bend_length;
            }
            set {
                m_bend_length = value;
            }
        }

        [Category( "Note" )]
        public int Decay {
            get {
                return m_decay;
            }
            set {
                m_decay = value;
            }
        }

        [Category( "Note" )]
        public int Accent {
            get {
                return m_accent;
            }
            set {
                m_accent = value;
            }
        }

        [Category( "Note" )]
        public bool UpPortamento {
            get {
                return m_portamento_up;
            }
            set {
                m_portamento_up = value;
            }
        }

        [Category( "Note" )]
        public bool DownPortamento {
            get {
                return m_portamento_down;
            }
            set {
                m_portamento_down = value;
            }
        }

        [Category( "Vibrato" )]
        public int VibratoLength {
            get {
                return m_vibrato_percent;
            }
            set {
                m_vibrato_percent = value;
            }
        }
    }
#endif
}
