﻿/*
 * VsqPhoneticSymbol.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    public class VsqPhoneticSymbol {
        private static string[] _SYMBOL_VOWEL_JP = new string[]{
            @"a",
            @"i",
            @"M",
            @"e",
            @"o",
        };
        private static string[] _SYMBOL_CONSONANT_JP = new string[]{
            @"k",
            @"k'",
            @"g",
            @"g'",
            @"N",
            @"N'",
            @"s",
            @"S",
            @"z",
            @"Z",
            @"dz",
            @"dZ",
            @"t",
            @"t'",
            @"ts",
            @"tS",
            @"d",
            @"d'",
            @"n",
            @"J",
            @"h",
            @"h\",
            @"C",
            @"p\",
            @"p\'",
            @"b",
            @"b'",
            @"p",
            @"p'",
            @"m",
            @"m'",
            @"j",
            @"4",
            @"4'",
            @"w",
            @"N\",
        };
        private static string[] _SYMBOL_EN = new string[]{
            @"@",
            @"V",
            @"e",
            @"e",
            @"I",
            @"i:",
            @"{",
            @"O:",
            @"Q",
            @"U",
            @"u:",
            @"@r",
            @"eI",
            @"aI",
            @"OI",
            @"@U",
            @"aU",
            @"I@",
            @"e@",
            @"U@",
            @"O@",
            @"Q@",
            @"w",
            @"j",
            @"b",
            @"d",
            @"g",
            @"bh",
            @"dh",
            @"gh",
            @"dZ",
            @"v",
            @"D",
            @"z",
            @"Z",
            @"m",
            @"n",
            @"N",
            @"r",
            @"l",
            @"l0",
            @"p",
            @"t",
            @"k",
            @"ph",
            @"th",
            @"kh",
            @"tS",
            @"f",
            @"T",
            @"s",
            @"S",
            @"h",
        };

        public static bool isConsonant( string symbol ) {
            for ( int i = 0; i < _SYMBOL_CONSONANT_JP.Length; i++ ){
                string s = _SYMBOL_CONSONANT_JP[i];
                if ( s == symbol ) {
                    return true;
                }
            }
            return false;
        }

        public static bool isValidSymbol( string symbol ) {
            for ( int i = 0; i < _SYMBOL_VOWEL_JP.Length; i++ ){
                string s = _SYMBOL_VOWEL_JP[i];
                if ( s == symbol ) {
                    return true;
                }
            }
            for ( int i = 0; i < _SYMBOL_CONSONANT_JP.Length; i++ ){
                string s = _SYMBOL_CONSONANT_JP[i];
                if ( s == symbol ) {
                    return true;
                }
            }
            for ( int i = 0; i < _SYMBOL_EN.Length; i++ ){
                string s = _SYMBOL_EN[i];
                if ( s == symbol ) {
                    return true;
                }
            }
            return false;
        }
    }

}
