﻿/*
 * VsqEvent.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    /// <summary>
    /// vsqファイルのメタテキスト内に記述されるイベント。
    /// </summary>
    [Serializable]
    public class VsqEvent : IComparable<VsqEvent>, ICloneable {
        public string Tag;
        /// <summary>
        /// 内部で使用するインスタンス固有のID
        /// </summary>
        public int InternalID;
        public int Clock;
        public VsqID ID;
        public UstEvent UstEvent = new UstEvent();

        /// <summary>
        /// このオブジェクトのコピーを作成します
        /// </summary>
        /// <returns></returns>
        public object Clone() {
            VsqEvent ret = new VsqEvent( Clock, (VsqID)ID.Clone() );
            ret.InternalID = InternalID;
            if ( UstEvent != null ) {
                ret.UstEvent = (UstEvent)UstEvent.Clone();
            }
            ret.Tag = Tag;
            return ret;
        }

        public int CompareTo( VsqEvent item ) {
            int ret = this.Clock - item.Clock;
            if ( ret == 0 ) {
                if ( this.ID != null && item.ID != null ) {
                    return (int)this.ID.type - (int)item.ID.type;
                } else {
                    return ret;
                }
            } else {
                return ret;
            }
        }

        public VsqEvent( string line ) {
            string[] spl = line.Split( new char[] { '=' } );
            Clock = int.Parse( spl[0] );
            if ( spl[1] == "EOS" ) {
                ID = VsqID.EOS;
            }
        }

        public VsqEvent()
            : this( 0, new VsqID() ) {
        }

        public VsqEvent( int clock, VsqID id /*, int internal_id*/ ) {
            Clock = clock;
            ID = id;
            //InternalID = internal_id;
            InternalID = 0;
        }
    }

}
