/*
 * waveplay.h
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef __PlaySound_h__
#define __PlaySound_h__

#include <iostream>
#include <string>
#include <windows.h>
#include <fstream>
#pragma comment(lib, "winmm.lib")

using namespace std;

// ŏ̃obt@܂ꂽƂĂяoR[obN֐
typedef void (*FirstBufferWrittenCallback)();

class waveplay{
private:
    static const int _NUM_BUF = 3;              // obt@̐
    static int          s_block_size;           // 1̃obt@̃TCY(Tv)
    static int          s_sample_rate;          // TvO[g
    static WAVEFORMATEX s_wave_formatx;         // WAVEt@Cwb_
    static HWAVEOUT     s_hwave_out;            // WAVEĐfoCX
    static WAVEHDR      s_wave_header[_NUM_BUF];// WAVEwb_
    static unsigned long* s_wave[_NUM_BUF];     // obt@
    static bool         s_done[_NUM_BUF];
    static int          s_current_buffer;       // 񏑂ނׂobt@̃CfNX
    static unsigned int s_processed_count;      // ̓obt@_NUM_BUFS߂Ȃ΂Ȃ̂ŁAŏ _NUM_BUF + 1 ̓JEgsB̂߂̃JE^
    static bool         s_abort_required;       // Đ̒fvꂽtO
    static int          s_buffer_loc;           // ݒ̃obt@́A݈ʒu
    static bool         s_playing;              // Đǂ\tO
    static int          s_error_samples;        // appendꂽg`f[^̓A擪s_error_samplesȂBʏ̎gȂ0Avocaloid2 vstiŎgꍇAvZhwaveOutWriteȂ΂Ȃ̂Ŕ0ɂȂB
    static int          s_last_buffer;          // ŌɍĐobt@̔ԍBl̏ꍇAappend_lastĂ΂ĂȂƂӖB
    static double *s_wave_buffer_l;
    static double *s_wave_buffer_r;
    static FirstBufferWrittenCallback s_first_buffer_written_callback; // ŏ̃obt@܂ꂽƂĂяoR[obN֐

    /// R[obN֐
    static void CALLBACK wave_callback( HWAVEOUT hwo, unsigned int uMsg, unsigned long dwInstance, unsigned long dwParam1, unsigned long dwParam2 );
    static void append_cor( double** a_data, unsigned int length, double amp_left, double amp_right, bool is_last_mode );
    static void mix( int processed_count, float amp_left, float amp_right );
#ifdef __cplusplus_cli
    static System::String ^waveplay::util_get_errmsg( MMRESULT msg );
#else
    static string waveplay::util_get_errmsg( MMRESULT msg );
#endif
public:
#ifdef TEST
    static ofstream logger;
#endif
    static void on_your_mark();
    /// ֐
    static void init( int block_size, int sample_rate );
    /// g`f[^obt@ɒǉBobt@ĐȂǂ̗Rőɏ߂ȂꍇAobt@݉\ƂȂ܂őҋ@
	static void append( double** data, unsigned int length, double amp_left, double amp_right );
    static void flush_and_exit( double amp_left, double amp_right );
    /// Đfv
    static void abort();
    /// ݂̍Đʒu擾BĐłȂꍇ̒lƂȂB
    static double get_play_time();
    /// ZbgBabort֐łĂяoB
    static void reset();
    /// R[obN֐ݒ肷
    static void set_first_buffer_written_callback( FirstBufferWrittenCallback proc );
    static void terminate();
    /// ݍĐǂ擾
    static bool is_alive();
    /// ubNTCYύX܂
    static bool change_block_size( int block_size );
};

extern "C" {

    void SoundInit( int block_size, int sample_rate );
    void SoundAppend( double *left, double *right, int length );
    void SoundReset();
    double SoundGetPosition();
    bool SoundIsBusy();
    void SoundWaitForExit();

}

#endif // __PlaySound_h__
