﻿/*
 * FormMidiImExport.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace Boare.Cadencii {

    public partial class FormMidiImExport : Form {
        public enum FormMidiMode {
            Import,
            Export,
        }

        private FormMidiMode m_mode;
        private VsqFileEx m_vsq;

        public FormMidiImExport() {
            InitializeComponent();
            ApplyLanguage();
            Mode = FormMidiMode.Export;
            Misc.ApplyFontRecurse( this, AppManager.EditorConfig.BaseFont );
        }

        public void ApplyLanguage() {
            if ( m_mode == FormMidiMode.Export ) {
                this.Text = _( "Midi Export" );
            } else {
                this.Text = _( "Midi Import" );
            }
            columnTrack.Text = _( "track" );
            columnName.Text = _( "name" );
            columnNumNotes.Text = _( "notes" );
            btnCheckAll.Text = _( "Check All" );
            btnUnckeckAll.Text = _( "Uncheck All" );
            groupCommonOption.Text = _( "Option" );
            btnOK.Text = _( "OK" );
            btnCancel.Text = _( "Cancel" );
            chkTempo.Text = _( "tempo" );
            chkBeat.Text = _( "beat" );
            chkNote.Text = _( "note" );
            chkLyric.Text = _( "lyric" );
            chkExportVocaloidMetatext.Text = _( "vocaloid meta text" );
            chkExportVocaloidNrpn.Text = _( "vocaloid NRPN" );
        }

        public FormMidiMode Mode {
            get {
                return m_mode;
            }
            set {
                m_mode = value;
                chkExportVocaloidMetatext.Enabled = (m_mode == FormMidiMode.Export);
                chkExportVocaloidNrpn.Enabled = (m_mode == FormMidiMode.Export);
                if ( m_mode == FormMidiMode.Export ) {
                    this.Text = _( "Midi Export" );
                } else {
                    this.Text = _( "Midi Import" );
                }
            }
        }

        private static string _( string id ) {
            return Messaging.GetMessage( id );
        }

        public bool VocaloidMetatext {
            get {
                return chkExportVocaloidMetatext.Checked;
            }
        }

        public bool VocaloidNrpn {
            get {
                return chkExportVocaloidNrpn.Checked;
            }
        }

        public bool Tempo {
            get {
                return chkTempo.Checked;
            }
        }

        public bool Timesig {
            get {
                return chkBeat.Checked;
            }
        }

        public bool Notes {
            get {
                return chkNote.Checked;
            }
        }

        public bool Lyric {
            get {
                return chkLyric.Checked;
            }
        }

        private void btnCheckAll_Click( object sender, EventArgs e ) {
            for ( int i = 0; i < ListTrack.Items.Count; i++ ) {
                ListTrack.Items[i].Checked = true;
            }
        }

        private void btnUnckeckAll_Click( object sender, EventArgs e ) {
            for ( int i = 0; i < ListTrack.Items.Count; i++ ) {
                ListTrack.Items[i].Checked = false;
            }
        }
    }

}
