﻿/*
 * ClipboardEntry.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    [Serializable]
    public class ClipboardEntry {
        public List<VsqEvent> Event;
        /// <summary>
        /// コピーorカットで複製されたテンポ
        /// </summary>
        public List<TempoTableEntry> Tempo;
        /// <summary>
        /// コピーorカットで複製された拍子
        /// </summary>
        public List<TimeSigTableEntry> Timesig;
        /// <summary>
        /// コピーorカットで複製されたカーブ
        /// </summary>
        public Dictionary<CurveType, List<BPPair>> Curve;
        /// <summary>
        /// コピーorカットで複製されたベジエ曲線
        /// </summary>
        public Dictionary<CurveType, List<BezierChain>> Bezier;
        /// <summary>
        /// コピーの開始位置。貼付け時に、この値をもとにクロックのシフトを行う
        /// </summary>
        public int CopyStartedClock;
    }

}
