﻿/*
 * CadenciiCommand.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    /// <summary>
    /// Undo/Redoを実現するためのコマンド。
    /// Boare.Lib.Vsq.VsqFileレベルのコマンドは、Type=VsqCommandとして取り扱う。
    /// Boare.Cadencii.VsqFileExレベルのコマンドは、Argsに処理内容を格納して取り扱う。
    /// </summary>
    [Serializable]
    public class CadenciiCommand : ICommand {
        public CadenciiCommandType Type;
        public VsqCommand VsqCommand;
        public ICommand m_parent;
        public object[] Args;
        private List<ICommand> m_child = new List<ICommand>();

        public CadenciiCommand( VsqCommand command ) {
            Type = CadenciiCommandType.VsqCommand;
            VsqCommand = command;
            m_child = new List<ICommand>();
        }

        public CadenciiCommand() {
            m_child = new List<ICommand>();
        }

        public ICommand Parent {
            get {
                return m_parent;
            }
            set {
                m_parent = value;
            }
        }

        public List<ICommand> Child {
            get {
                return m_child;
            }
        }
    }

}
