﻿/*
 * AttachedCurve.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

using Boare.Lib.Vsq;

namespace Boare.Cadencii {

    public class AttachedCurve : ICloneable {
        public List<BezierCurves> Curves = new List<BezierCurves>();

        public void Add( BezierCurves item ) {
            Curves.Add( item );
        }

        public void RemoveAt( int index ) {
            Curves.RemoveAt( index );
        }

        public void Insert( int position, BezierCurves attached_curve ) {
            Curves.Insert( position, attached_curve );
        }

        public object Clone() {
            AttachedCurve ret = new AttachedCurve();
            ret.Curves.Clear();
            for ( int i = 0; i < Curves.Count; i++ ) {
                ret.Curves.Add( (BezierCurves)Curves[i].Clone() );
            }
            return ret;
        }

        public BezierCurves this[int index] {
            get {
                return Curves[index];
            }
            set {
                Curves[index] = value;
            }
        }
    }

}
