﻿/*
 * SingerConfigSys.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    public abstract class SingerConfigSys {
        protected SingerConfigSys() {
        }
        public SingerConfigSys( string path ) {
        }
        public abstract SingerConfig[] getInstalledSingers();
        /// <summary>
        /// Gets the VsqID of program change.
        /// </summary>
        /// <param name="program_change"></param>
        /// <returns></returns>
        public abstract VsqID getSingerID( string singer );
        /// <summary>
        /// Gets the singer information of pecified program change.
        /// </summary>
        /// <param name="program_change"></param>
        /// <returns></returns>
        public abstract SingerConfig getSingerInfo( string singer );
        /// <summary>
        /// Gets the list of singer configs.
        /// </summary>
        /// <returns></returns>
        public abstract SingerConfig[] getSingerConfigs();
    }

}
