﻿/*
 * Program.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;

using Boare.Cadencii;
using Boare.Lib.Vsq;
using Boare.Lib.Media;

namespace GenerateKeySound {
    class Program {
        const int _SAMPLE_RATE = 44100;
        static byte s_program_change = 0;
        static object s_locker;
        static double s_amp;
        static string s_dir;
        static bool s_replace = false;

        static void Main( string[] args ) {
            s_locker = new object();
            s_program_change = 0;
            s_amp = 1.0;
            s_dir = Path.Combine( Application.StartupPath, "cache" );
            int search = -1;
            while ( search + 1 < args.Length ) {
                search++;
                switch ( args[search].ToLower() ) {
                    case "-help":
                    case "-h":
                    case "/help":
                    case "/h":
                    case "-?":
                    case "/?":
                    case "--h":
                    case "--help":
                        ShowHelp();
                        return;
                    case "-amplify":
                    case "-a":
                    case "/amplify":
                    case "/a":
                        if ( search + 1 < args.Length ) {
                            double t_amp = s_amp;
                            if ( double.TryParse( args[search + 1], out t_amp ) ) {
                                if ( t_amp < 0.0 ) {
                                    Console.WriteLine( "error; amilify coefficient must be >= 0. specified value was \"" + t_amp + "\"" );
                                    return;
                                }
                                s_amp = t_amp;
                            } else {
                                InvalidNumberExpressionAt( args[search + 1] );
                                return;
                            }
                        } else {
                            TooFewArgumentFor( args[search] );
                            return;
                        }
                        search++;
                        break;
                    case "-pchange":
                    case "-p":
                    case "/pchange":
                    case "/p":
                        if ( search + 1 < args.Length ) {
                            byte t_pc = s_program_change;
                            if ( byte.TryParse( args[search + 1], out t_pc ) ) {
                                if ( t_pc < 0 ) {
                                    Console.WriteLine( "error; Program Change must be >= 0. specified value was \"" + t_pc + "\"" );
                                    return;
                                } else {
                                    s_program_change = t_pc;
                                }
                            } else {
                                InvalidNumberExpressionAt( args[search + 1] );
                                return;
                            }
                        } else {
                            TooFewArgumentFor( args[search] );
                            return;
                        }
                        search++;
                        break;
                    case "-dir":
                    case "-d":
                    case "/dir":
                    case "/d":
                        if ( search + 1 < args.Length ) {
                            s_dir = args[search + 1];
                        } else {
                            TooFewArgumentFor( args[search] );
                            return;
                        }
                        search++;
                        break;
                    case "-replace":
                    case "-r":
                    case "/replace":
                    case "/r":
                        s_replace = true;
                        break;
                    default:
                        Console.WriteLine( "error; unknown option \"" + args[search] + "\"" );
                        return;
                }
            }

            // 音源を準備
            if ( !Directory.Exists( s_dir ) ) {
                Directory.CreateDirectory( s_dir );
            }

            for ( int i = 0; i < 127; i++ ) {
                string path = Path.Combine( s_dir, i + ".wav" );
                Console.Write( "writing \"" + path + "\" ..." );
                if ( s_replace || (!s_replace && !File.Exists( path ) ) ) {
                    try {
                        GenerateSinglePhone( i, s_program_change, path );
                        if ( File.Exists( path ) ) {
                            try {
                                Wave wv = new Wave( path );
                                wv.TrimSilence();
                                wv.Monoralize();
                                wv.Write( path );
                            } catch {
                            }
                        }
                    } catch {
                    }
                }
                Console.WriteLine( " done" );
            }
        }

        static void InvalidNumberExpressionAt( string expression ) {
            Console.WriteLine( "error; string parse error. invalid number expression at \"" + expression + "\"" );
        }

        static void TooFewArgumentFor( string argument ) {
            Console.WriteLine( "error; too few argument for \"" + argument + "\"" );
        }

        static void ShowHelp() {
            Console.WriteLine( "GenerateKeySound, Copyright (C) 2008-2009, kbinani" );
            Console.WriteLine( "Usage is: GenerateKeySound [options]" );
            Console.WriteLine( "    -help            Shows this message and return (short: -h, -?)" );
            Console.WriteLine( "    -amplify AMP     Sets sound amplify coefficients (short: -a)" );
            Console.WriteLine( "                     AMP must be 0 <= AMP (defualt is 1.0)" );
            Console.WriteLine( "    -pchange NUMBER  Sets the value of Program Change (short: -p)" );
            Console.WriteLine( "    -dir DIRECTORY   Specifies the directory of output (short: -d)" );
            Console.WriteLine( "                     default of DIRECTORY is \"." + Path.DirectorySeparatorChar + "cache\"" );
            Console.WriteLine( "    -replace         Switch to overwrite exisiting WAVs (short: -r)" );
            Console.WriteLine();
            Console.WriteLine( "Options can be of the form -option or /option" );
        }

        public static unsafe void GenerateSinglePhone( int note, byte program_change, string file ) {
            VsqFile vsq = new VsqFile( program_change, 1, 4, 4, 500000 );
            VsqEvent item = new VsqEvent( 1920, new VsqID( 0 ) );
            item.ID.LyricHandle = new LyricHandle( "a", "a" );
            item.ID.Length = 480;
            item.ID.Note = note;
            item.ID.VibratoHandle = null;
            item.ID.type = VsqIDType.Anote;
            vsq.Tracks[1].Events.Add( item );
            vsq.UpdateTotalClocks();
            int ms_presend = 500;
            VSTiProxy.Render( vsq, 
                              1, 
                              file, 
                              0.0, 
                              vsq.SecFromClock( vsq.TotalClocks ) + 1.0,
                              s_amp, 
                              s_amp,
                              ms_presend,
                              false, 
                              new string[] { }, 
                              0.0,
                              false );
        }
    }

}
