﻿/*
 * DrawObject.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace Boare.Cadencii {

    /// <summary>
    /// 画面に描画するアイテムを表します
    /// </summary>
    class DrawObject {
        private Rectangle m_rect;
        private string m_text;
        private int m_accent;
        private int m_internal_id;
        private int m_vibrato_delay;
        private bool m_overwrapped;
        private bool m_symbol_protected;

        public DrawObject( Rectangle rect, string text, int accent, int internal_id, int vibrato_delay, bool overwrapped, bool symbol_protected ) {
            m_rect = rect;
            m_text = text;
            m_accent = accent;
            m_internal_id = internal_id;
            m_vibrato_delay = vibrato_delay;
            m_overwrapped = overwrapped;
            m_symbol_protected = symbol_protected;
        }

        /// <summary>
        /// 発音記号が固定されているかどうか．
        /// </summary>
        public bool SymbolProtected {
            get {
                return m_symbol_protected;
            }
            set {
                m_symbol_protected = value;
            }
        }

        /// <summary>
        /// このアイテムが他のアイテムと再生時にオーバーラップするかどうかを表すフラグ
        /// </summary>
        public bool Overwrapped {
            get {
                return m_overwrapped;
            }
            set {
                m_overwrapped = value;
            }
        }

        /// <summary>
        /// 音符の先頭から，ビブラート開始位置までの長さ(単位：ピクセル)
        /// </summary>
        public int pxVibratoDelay {
            get {
                return m_vibrato_delay;
            }
            set {
                m_vibrato_delay = value;
            }
        }

        public int InternalID {
            get {
                return m_internal_id;
            }
            set {
                m_internal_id = value;
            }
        }

        public int Accent {
            get {
                return m_accent;
            }
            set {
                m_accent = value;
            }
        }

        public string Text {
            get {
                return m_text;
            }
            set {
                m_text = value;
            }
        }

        public Rectangle pxRectangle {
            get {
                return m_rect;
            }
            set {
                m_rect = value;
            }
        }
    }

}
