﻿/*
 * BezierCurves.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
namespace Boare.Cadencii {

    public class BezierCurves {
        public BezierChain[] Dynamics;
        public BezierChain[] Brethiness;
        public BezierChain[] Brightness;
        public BezierChain[] Clearness;
        public BezierChain[] Opening;
        public BezierChain[] GenderFactor;
        public BezierChain[] PortamentoTiming;
        public BezierChain[] PitchBend;
        public BezierChain[] PitchBendSensitivity;
        public BezierChain[] VibratoRate;
        public BezierChain[] VibratoDepth;

        public BezierCurves() {
            Dynamics = new BezierChain[0];
            Brethiness = new BezierChain[0];
            Brightness = new BezierChain[0];
            Clearness = new BezierChain[0];
            Opening = new BezierChain[0];
            GenderFactor = new BezierChain[0];
            PortamentoTiming = new BezierChain[0];
            PitchBend = new BezierChain[0];
            PitchBendSensitivity = new BezierChain[0];
            VibratoRate = new BezierChain[0];
            VibratoDepth = new BezierChain[0];
        }

        public BezierCurves( AttachedCurve item ) {
            CurveType work = CurveType.DYN;
            Dynamics = new BezierChain[item[work].Count];
            int i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                Dynamics[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.BRE;
            Brethiness = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                Brethiness[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.BRI;
            Brightness = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                Brightness[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.CLE;
            Clearness = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                Clearness[i] = (BezierChain)item[work][key].Clone();
            }
            work = CurveType.OPE;
            Opening = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                Opening[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.GEN;
            GenderFactor = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                GenderFactor[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.POR;
            PortamentoTiming = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                PortamentoTiming[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.PIT;
            PitchBend = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                PitchBend[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.PBS;
            PitchBendSensitivity = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                PitchBendSensitivity[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.VibratoRate;
            VibratoRate = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                VibratoRate[i] = (BezierChain)item[work][key].Clone();
            }

            work = CurveType.VibratoDepth;
            VibratoDepth = new BezierChain[item[work].Count];
            i = -1;
            foreach ( int key in item[work].Keys ) {
                i++;
                VibratoDepth[i] = (BezierChain)item[work][key].Clone();
            }
        }
    }

}
