/*
 * UstTrack.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq{

    public class UstTrack : ICloneable {
        protected object m_tag;
        private List<UstEvent> m_events;
        
        public UstTrack(){
            m_events = new List<UstEvent>();
        }

        public object Tag {
            get {
                return m_tag;
            }
            set {
                m_tag = value;
            }
        }
        
        public List<UstEvent> Events{
            get{
                return m_events;
            }
            set{
                m_events = value;
            }
        }
        
        public object Clone(){
            UstTrack ret = new UstTrack();
            for ( int i = 0; i < m_events.Count; i++ ) {
                ret.m_events[i] = (UstEvent)m_events[i].Clone();
            }
            return ret;
        }
    }

}
