﻿/*
 * TempoTableEntry.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    [Serializable]
    public class TempoTableEntry : IComparable<TempoTableEntry>, ICloneable {
        private int m_clock;
        private int m_tempo;
        private double m_time;

        public int Tempo {
            get {
                return m_tempo;
            }
            set {
                m_tempo = value;
            }
        }

        public double Time {
            get {
                return m_time;
            }
            set {
                m_time = value;
            }
        }

        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }

        public object Clone() {
            return new TempoTableEntry( Clock, Tempo, Time );
        }

        public TempoTableEntry( int clock, int _tempo, double _time ) {
            this.Clock = clock;
            this.Tempo = _tempo;
            this.Time = _time;
        }

        public int CompareTo( TempoTableEntry entry ) {
            return this.Clock - entry.Clock;
        }

        public bool Equals( TempoTableEntry entry ) {
            if ( this.Clock == entry.Clock ) {
                return true;
            } else {
                return false;
            }
        }
    }

}
