/*
 * DynamicsMode.cs
 * Copyright © 2010-2011 kbinani
 *
 * This file is part of org.kbinani.vsq.
 *
 * org.kbinani.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * org.kbinani.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#if JAVA
package org.kbinani.vsq;
#else
namespace org {
    namespace kbinani {
        namespace vsq {
#endif

    /// <summary>
    /// VOCALOID1における、ダイナミクスモードを表す定数を格納するためのクラスです。
    /// </summary>
#if __cplusplus
            class DynamicsMode
#else
            public class DynamicsMode
#endif
            {
                /// <summary>
                /// デフォルトのダイナミクスモードです。DYNカーブが非表示になるモードです。
                /// </summary>
#if __cplusplus
            public:
#else
                public
#endif
                const int Standard = 0;
                /// <summary>
                /// エキスパートモードです。DYNカーブが表示されます。
                /// </summary>
#if __cplusplus
            public :
#else
                public
#endif
                const int Expert = 1;

#if __cplusplus
            private:
#else
                private
#endif
                DynamicsMode()
                {
                }
            };

#if !JAVA
       }
    }
}
#endif
