/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v1Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;
import org.jaudiotagger.tag.id3.ID3v1Iterator;
import org.jaudiotagger.tag.id3.ID3v1TagField;
import org.jaudiotagger.tag.id3.valuepair.GenreTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3v1Tag
extends AbstractID3v1Tag
implements Tag {
    static EnumMap<TagFieldKey, ID3v1FieldKey> tagFieldToID3v1Field = new EnumMap(TagFieldKey.class);
    protected static final String TYPE_COMMENT = "comment";
    protected static final int FIELD_COMMENT_LENGTH = 30;
    protected static final int FIELD_COMMENT_POS = 97;
    protected static final int BYTE_TO_UNSIGNED = 255;
    protected static final int GENRE_UNDEFINED = 255;
    protected String album = "";
    protected String artist = "";
    protected String comment = "";
    protected String title = "";
    protected String year = "";
    protected byte genre = (byte)-1;
    private static final byte RELEASE = 1;
    private static final byte MAJOR_VERSION = 0;
    private static final byte REVISION = 0;

    static {
        tagFieldToID3v1Field.put(TagFieldKey.ARTIST, ID3v1FieldKey.ARTIST);
        tagFieldToID3v1Field.put(TagFieldKey.ALBUM, ID3v1FieldKey.ALBUM);
        tagFieldToID3v1Field.put(TagFieldKey.TITLE, ID3v1FieldKey.TITLE);
        tagFieldToID3v1Field.put(TagFieldKey.TRACK, ID3v1FieldKey.TRACK);
        tagFieldToID3v1Field.put(TagFieldKey.YEAR, ID3v1FieldKey.YEAR);
        tagFieldToID3v1Field.put(TagFieldKey.GENRE, ID3v1FieldKey.GENRE);
        tagFieldToID3v1Field.put(TagFieldKey.COMMENT, ID3v1FieldKey.COMMENT);
    }

    @Override
    public byte getRelease() {
        return 1;
    }

    @Override
    public byte getMajorVersion() {
        return 0;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v1Tag() {
    }

    public ID3v1Tag(ID3v1Tag copyObject) {
        super(copyObject);
        this.album = new String(copyObject.album);
        this.artist = new String(copyObject.artist);
        this.comment = new String(copyObject.comment);
        this.title = new String(copyObject.title);
        this.year = new String(copyObject.year);
        this.genre = copyObject.genre;
    }

    public ID3v1Tag(AbstractTag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v1Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v11Tag convertedTag = mp3tag instanceof ID3v11Tag ? (ID3v11Tag)mp3tag : new ID3v11Tag(mp3tag);
            this.album = new String(convertedTag.album);
            this.artist = new String(convertedTag.artist);
            this.comment = new String(convertedTag.comment);
            this.title = new String(convertedTag.title);
            this.year = new String(convertedTag.year);
            this.genre = convertedTag.genre;
        }
    }

    public ID3v1Tag(RandomAccessFile file, String loggingFilename) throws TagNotFoundException, IOException {
        this.setLoggingFilename(loggingFilename);
        FileChannel fc = file.getChannel();
        fc.position(file.length() - 128L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        fc.read(byteBuffer);
        byteBuffer.flip();
        this.read(byteBuffer);
    }

    public ID3v1Tag(RandomAccessFile file) throws TagNotFoundException, IOException {
        this(file, "");
    }

    @Override
    public void add(TagField field) {
    }

    public List get(String id) {
        return null;
    }

    @Override
    public int getFieldCount() {
        return 7;
    }

    protected List returnFieldToList(ID3v1TagField field) {
        ArrayList<ID3v1TagField> fields = new ArrayList<ID3v1TagField>();
        fields.add(field);
        return fields;
    }

    @Override
    public void addAlbum(String album) {
        this.setAlbum(album);
    }

    @Override
    public void setAlbum(String album) {
        this.album = ID3Tags.truncate(album, 30);
    }

    @Override
    public String getFirstAlbum() {
        return this.album;
    }

    public List getAlbum() {
        if (this.getFirstAlbum().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.ALBUM.name(), this.getFirstAlbum());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public void addArtist(String artist) {
        this.setArtist(this.album);
    }

    @Override
    public void setArtist(String artist) {
        this.artist = ID3Tags.truncate(artist, 30);
    }

    @Override
    public String getFirstArtist() {
        return this.artist;
    }

    public List getArtist() {
        if (this.getFirstArtist().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.ARTIST.name(), this.getFirstArtist());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public void addComment(String comment) {
        this.setComment(comment);
    }

    @Override
    public void setComment(String comment) {
        this.comment = ID3Tags.truncate(comment, 30);
    }

    public List getComment() {
        if (this.getFirstComment().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.COMMENT.name(), this.getFirstComment());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public String getFirstComment() {
        return this.comment;
    }

    @Override
    public void addGenre(String genre) {
        this.setGenre(genre);
    }

    @Override
    public void setGenre(String genreVal) {
        Integer genreID = GenreTypes.getInstanceOf().getIdForValue(genreVal);
        this.genre = genreID != null ? genreID.byteValue() : (byte)-1;
    }

    @Override
    public String getFirstGenre() {
        Integer genreId = this.genre & 0xFF;
        String genreValue = GenreTypes.getInstanceOf().getValueForId(genreId);
        if (genreValue == null) {
            return "";
        }
        return genreValue;
    }

    public List getGenre() {
        if (this.getFirstGenre().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.GENRE.name(), this.getFirstGenre());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public void addTitle(String title) {
        this.setTitle(title);
    }

    @Override
    public void setTitle(String title) {
        this.title = ID3Tags.truncate(title, 30);
    }

    @Override
    public String getFirstTitle() {
        return this.title;
    }

    public List getTitle() {
        if (this.getFirstTitle().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.TITLE.name(), this.getFirstTitle());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public void addYear(String year) {
        this.setYear(year);
    }

    @Override
    public void setYear(String year) {
        this.year = ID3Tags.truncate(year, 4);
    }

    @Override
    public String getFirstYear() {
        return this.year;
    }

    public List getYear() {
        if (this.getFirstYear().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.YEAR.name(), this.getFirstYear());
            return this.returnFieldToList(field);
        }
        return new ArrayList();
    }

    @Override
    public void addTrack(String track) {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    @Override
    public String getFirstTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    @Override
    public void setTrack(String track) {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    public List getTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    @Override
    public TagField getFirstField(String id) {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public Iterator getFields() {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(String id) {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public void set(TagField field) {
        TagFieldKey genericKey = TagFieldKey.valueOf(field.getId());
        switch (genericKey) {
            case ARTIST: {
                this.setArtist(field.toString());
            }
            case ALBUM: {
                this.setAlbum(field.toString());
            }
            case TITLE: {
                this.setTitle(field.toString());
            }
            case GENRE: {
                this.setGenre(field.toString());
            }
            case YEAR: {
                this.setYear(field.toString());
            }
            case COMMENT: {
                this.setComment(field.toString());
            }
        }
    }

    @Override
    public boolean setEncoding(String encoding) {
        return true;
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) {
        return new ID3v1TagField(tagFieldToID3v1Field.get((Object)genericKey).name(), value);
    }

    public String getEncoding() {
        return "ISO-8859-1";
    }

    @Override
    public List<TagField> get(TagFieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                return this.getArtist();
            }
            case ALBUM: {
                return this.getAlbum();
            }
            case TITLE: {
                return this.getTitle();
            }
            case GENRE: {
                return this.getGenre();
            }
            case YEAR: {
                return this.getYear();
            }
            case COMMENT: {
                return this.getComment();
            }
        }
        return new ArrayList<TagField>();
    }

    @Override
    public String getFirst(String genericKey) {
        TagFieldKey matchingKey = TagFieldKey.valueOf(genericKey);
        if (matchingKey != null) {
            return this.getFirst(matchingKey);
        }
        return "";
    }

    @Override
    public String getFirst(TagFieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                return this.getFirstArtist();
            }
            case ALBUM: {
                return this.getFirstAlbum();
            }
            case TITLE: {
                return this.getFirstTitle();
            }
            case GENRE: {
                return this.getFirstGenre();
            }
            case YEAR: {
                return this.getFirstYear();
            }
            case TRACK: {
                return this.getFirstTrack();
            }
            case COMMENT: {
                return this.getFirstComment();
            }
        }
        return "";
    }

    @Override
    public void deleteTagField(TagFieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                this.setArtist("");
            }
            case ALBUM: {
                this.setAlbum("");
            }
            case TITLE: {
                this.setTitle("");
            }
            case GENRE: {
                this.setGenre("");
            }
            case YEAR: {
                this.setYear("");
            }
            case COMMENT: {
                this.setComment("");
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v1Tag)) {
            return false;
        }
        ID3v1Tag object = (ID3v1Tag)obj;
        if (!this.album.equals(object.album)) {
            return false;
        }
        if (!this.artist.equals(object.artist)) {
            return false;
        }
        if (!this.comment.equals(object.comment)) {
            return false;
        }
        if (this.genre != object.genre) {
            return false;
        }
        if (!this.title.equals(object.title)) {
            return false;
        }
        if (!this.year.equals(object.year)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Iterator iterator() {
        return new ID3v1Iterator(this);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagNotFoundException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(String.valueOf(this.getLoggingFilename()) + ":" + "ID3v1 tag not found");
        }
        byte[] dataBuffer = new byte[128];
        byteBuffer.position(0);
        byteBuffer.get(dataBuffer, 0, 128);
        this.title = Utils.getString(dataBuffer, 3, 30, "ISO-8859-1").trim();
        Matcher m = this.endofStringPattern.matcher(this.title);
        if (m.find()) {
            this.title = this.title.substring(0, m.start());
        }
        this.artist = Utils.getString(dataBuffer, 33, 30, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.artist);
        if (m.find()) {
            this.artist = this.artist.substring(0, m.start());
        }
        this.album = Utils.getString(dataBuffer, 63, 30, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.album);
        if (m.find()) {
            this.album = this.album.substring(0, m.start());
        }
        this.year = Utils.getString(dataBuffer, 93, 4, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.year);
        if (m.find()) {
            this.year = this.year.substring(0, m.start());
        }
        this.comment = Utils.getString(dataBuffer, 97, 30, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.comment);
        if (m.find()) {
            this.comment = this.comment.substring(0, m.start());
        }
        this.genre = dataBuffer[127];
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byte[] buffer = new byte[3];
        byteBuffer.get(buffer, 0, 3);
        return Arrays.equals(buffer, TAG_ID);
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i;
        String str;
        byte[] buffer = new byte[128];
        this.delete(file);
        file.seek(file.length());
        System.arraycopy(TAG_ID, 0, buffer, 0, TAG_ID.length);
        int offset = 3;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            str = ID3Tags.truncate(this.title, 30);
            i = 0;
            while (i < str.length()) {
                buffer[i + offset] = (byte)str.charAt(i);
                ++i;
            }
        }
        offset = 33;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            str = ID3Tags.truncate(this.artist, 30);
            i = 0;
            while (i < str.length()) {
                buffer[i + offset] = (byte)str.charAt(i);
                ++i;
            }
        }
        offset = 63;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            str = ID3Tags.truncate(this.album, 30);
            i = 0;
            while (i < str.length()) {
                buffer[i + offset] = (byte)str.charAt(i);
                ++i;
            }
        }
        offset = 93;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            str = ID3Tags.truncate(this.year, 4);
            i = 0;
            while (i < str.length()) {
                buffer[i + offset] = (byte)str.charAt(i);
                ++i;
            }
        }
        offset = 97;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            str = ID3Tags.truncate(this.comment, 30);
            i = 0;
            while (i < str.length()) {
                buffer[i + offset] = (byte)str.charAt(i);
                ++i;
            }
        }
        offset = 127;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            buffer[offset] = this.genre;
        }
        file.write(buffer);
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("title", this.title);
        MP3File.getStructureFormatter().addElement("artist", this.artist);
        MP3File.getStructureFormatter().addElement("album", this.album);
        MP3File.getStructureFormatter().addElement("year", this.year);
        MP3File.getStructureFormatter().addElement(TYPE_COMMENT, this.comment);
        MP3File.getStructureFormatter().addElement("genre", this.genre);
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }
}

