/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.flac;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.id3.valuepair.PictureTypes;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlacTag
implements Tag {
    VorbisCommentTag tag = null;
    List<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();

    public FlacTag(VorbisCommentTag tag, List<MetadataBlockDataPicture> images) {
        this.tag = tag;
        this.images = images;
    }

    public List<MetadataBlockDataPicture> getImages() {
        return this.images;
    }

    public VorbisCommentTag getVorbisCommentTag() {
        return this.tag;
    }

    @Override
    public void add(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            this.images.add((MetadataBlockDataPicture)field);
        } else {
            this.tag.add(field);
        }
    }

    @Override
    public void addAlbum(String album) throws FieldDataInvalidException {
        this.tag.addAlbum(album);
    }

    @Override
    public void addArtist(String artist) throws FieldDataInvalidException {
        this.tag.addArtist(artist);
    }

    @Override
    public void addComment(String comment) throws FieldDataInvalidException {
        this.tag.addComment(comment);
    }

    @Override
    public void addGenre(String genre) throws FieldDataInvalidException {
        this.tag.addGenre(genre);
    }

    @Override
    public void addTitle(String title) throws FieldDataInvalidException {
        this.tag.addTitle(title);
    }

    @Override
    public void addTrack(String track) throws FieldDataInvalidException {
        this.tag.addTrack(track);
    }

    @Override
    public void addYear(String year) throws FieldDataInvalidException {
        this.tag.addYear(year);
    }

    @Override
    public List<TagField> get(String id) {
        if (id.equals(TagFieldKey.COVER_ART.name())) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.get(id);
    }

    @Override
    public List<TagField> getAlbum() {
        return this.tag.getAlbum();
    }

    @Override
    public List<TagField> getArtist() {
        return this.tag.getArtist();
    }

    @Override
    public List<TagField> getComment() {
        return this.tag.getComment();
    }

    @Override
    public List<TagField> getGenre() {
        return this.tag.getGenre();
    }

    @Override
    public List<TagField> getTitle() {
        return this.tag.getTitle();
    }

    @Override
    public List<TagField> getTrack() {
        return this.tag.getTrack();
    }

    @Override
    public List<TagField> getYear() {
        return this.tag.getYear();
    }

    @Override
    public String getFirstAlbum() {
        return this.tag.getFirstAlbum();
    }

    @Override
    public String getFirstArtist() {
        return this.tag.getFirstArtist();
    }

    @Override
    public String getFirstComment() {
        return this.tag.getFirstComment();
    }

    @Override
    public String getFirstGenre() {
        return this.tag.getFirstGenre();
    }

    @Override
    public String getFirstTitle() {
        return this.tag.getFirstTitle();
    }

    @Override
    public String getFirstTrack() {
        return this.tag.getFirstTrack();
    }

    @Override
    public String getFirstYear() {
        return this.tag.getFirstYear();
    }

    @Override
    public boolean hasCommonFields() {
        return this.tag.hasCommonFields();
    }

    @Override
    public boolean hasField(String id) {
        if (id.equals(TagFieldKey.COVER_ART.name())) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(id);
    }

    @Override
    public boolean isEmpty() {
        return (this.tag == null || this.tag.isEmpty()) && this.images.size() == 0;
    }

    @Override
    public void set(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            if (this.images.size() == 0) {
                this.images.add(0, (MetadataBlockDataPicture)field);
            } else {
                this.images.set(0, (MetadataBlockDataPicture)field);
            }
        } else {
            this.tag.set(field);
        }
    }

    @Override
    public void setAlbum(String s) throws FieldDataInvalidException {
        this.tag.setAlbum(s);
    }

    @Override
    public void setArtist(String s) throws FieldDataInvalidException {
        this.tag.setArtist(s);
    }

    @Override
    public void setComment(String s) throws FieldDataInvalidException {
        this.tag.setComment(s);
    }

    @Override
    public void setGenre(String s) throws FieldDataInvalidException {
        this.tag.setGenre(s);
    }

    @Override
    public void setTitle(String s) throws FieldDataInvalidException {
        this.tag.setTitle(s);
    }

    @Override
    public void setTrack(String s) throws FieldDataInvalidException {
        this.tag.setTrack(s);
    }

    @Override
    public void setYear(String s) throws FieldDataInvalidException {
        this.tag.setYear(s);
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey.equals((Object)TagFieldKey.COVER_ART)) {
            throw new UnsupportedOperationException("Please use the createArtworkField methods to create coverart ");
        }
        return this.tag.createTagField(genericKey, value);
    }

    @Override
    public String getFirst(String id) {
        if (id.equals(TagFieldKey.COVER_ART.name())) {
            throw new UnsupportedOperationException("Please use the createArtworkField methods to create coverart ");
        }
        return this.tag.getFirst(id);
    }

    @Override
    public String getFirst(TagFieldKey id) throws KeyNotFoundException {
        if (id.equals((Object)TagFieldKey.COVER_ART)) {
            throw new UnsupportedOperationException("Please use the createArtworkField methods to create coverart ");
        }
        return this.tag.getFirst(id);
    }

    @Override
    public TagField getFirstField(String id) {
        if (id.equals((Object)TagFieldKey.COVER_ART)) {
            if (this.images.size() > 0) {
                return this.images.get(0);
            }
            return null;
        }
        return this.tag.getFirstField(id);
    }

    @Override
    public void deleteTagField(TagFieldKey tagFieldKey) throws KeyNotFoundException {
        if (tagFieldKey.equals((Object)TagFieldKey.COVER_ART)) {
            this.images.clear();
        } else {
            this.tag.deleteTagField(tagFieldKey);
        }
    }

    @Override
    public Iterator getFields() {
        return this.tag.getFields();
    }

    @Override
    public int getFieldCount() {
        return this.tag.getFieldCount() + this.images.size();
    }

    @Override
    public boolean setEncoding(String enc) throws FieldDataInvalidException {
        return this.tag.setEncoding(enc);
    }

    @Override
    public List<TagField> get(TagFieldKey id) throws KeyNotFoundException {
        if (id.equals((Object)TagFieldKey.COVER_ART)) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.get(id);
    }

    public TagField createArtworkField(byte[] imageData, int pictureType, String mimeType, String description, int width, int height, int colourDepth, int indexedColouredCount) throws FieldDataInvalidException {
        return new MetadataBlockDataPicture(imageData, pictureType, mimeType, description, width, height, colourDepth, indexedColouredCount);
    }

    public TagField createArtworkField(BufferedImage bi, int pictureType, String mimeType, String description, int colourDepth, int indexedColouredCount) throws FieldDataInvalidException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, ImageFormats.getFormatForMimeType(mimeType), new DataOutputStream(output));
            return new MetadataBlockDataPicture(output.toByteArray(), pictureType, mimeType, description, bi.getWidth(), bi.getHeight(), colourDepth, indexedColouredCount);
        }
        catch (IOException ioe) {
            throw new FieldDataInvalidException("Unable to convert image to bytearray, check mimetype parameter");
        }
    }

    public TagField createLinkedArtworkField(String url) {
        return new MetadataBlockDataPicture(Utils.getDefaultBytes(url, "ISO-8859-1"), PictureTypes.DEFAULT_ID, "-->", "", 0, 0, 0, 0);
    }
}

