/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;

public class Mp4BoxHeader {
    public static final int OFFSET_POS = 0;
    public static final int IDENTIFIER_POS = 4;
    public static final int OFFSET_LENGTH = 4;
    public static final int IDENTIFIER_LENGTH = 4;
    public static final int HEADER_LENGTH = 8;
    private String id;
    private int length;
    protected ByteBuffer dataBuffer;
    public static final String CHARSET_UTF_8 = "UTF-8";

    public Mp4BoxHeader() {
    }

    public Mp4BoxHeader(ByteBuffer headerData) {
        this.update(headerData);
    }

    public void update(ByteBuffer headerData) {
        byte[] b = new byte[8];
        headerData.get(b);
        this.dataBuffer = ByteBuffer.wrap(b);
        this.length = Utils.getNumberBigEndian(b, 0, 3);
        this.id = Utils.getString(b, 4, 4, "ISO-8859-1");
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        byte[] headerSize = Utils.getSizeBigEndian(length);
        this.dataBuffer.put(0, headerSize[0]);
        this.dataBuffer.put(1, headerSize[1]);
        this.dataBuffer.put(2, headerSize[2]);
        this.dataBuffer.put(3, headerSize[3]);
        this.length = length;
    }

    public ByteBuffer getHeaderData() {
        this.dataBuffer.rewind();
        return this.dataBuffer;
    }

    public int getDataLength() {
        return this.length - 8;
    }

    public String toString() {
        return "Box " + this.id + ":" + this.length;
    }

    public String getEncoding() {
        return CHARSET_UTF_8;
    }

    public static Mp4BoxHeader seekWithinLevel(RandomAccessFile raf, String id) throws IOException {
        Mp4BoxHeader boxHeader = new Mp4BoxHeader();
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        int bytesRead = raf.getChannel().read(headerBuffer);
        if (bytesRead != 8) {
            return null;
        }
        headerBuffer.rewind();
        boxHeader.update(headerBuffer);
        while (!boxHeader.getId().equals(id)) {
            if (boxHeader.getLength() < 8) {
                return null;
            }
            int noOfBytesSkipped = raf.skipBytes(boxHeader.getDataLength());
            if (noOfBytesSkipped < boxHeader.getDataLength()) {
                return null;
            }
            headerBuffer.rewind();
            bytesRead = raf.getChannel().read(headerBuffer);
            headerBuffer.rewind();
            if (bytesRead == 8) {
                boxHeader.update(headerBuffer);
                continue;
            }
            return null;
        }
        return boxHeader;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Mp4BoxHeader seekWithinLevel(ByteBuffer data, String id) throws IOException {
        Mp4BoxHeader boxHeader = new Mp4BoxHeader();
        if (data.remaining() < 8) {
            return null;
        }
        boxHeader.update(data);
        while (!boxHeader.getId().equals(id)) {
            if (boxHeader.getLength() < 8) {
                return null;
            }
            data.position(data.position() + (boxHeader.getLength() - 8));
            if (data.remaining() < 8) {
                return null;
            }
            boxHeader.update(data);
        }
        return boxHeader;
    }
}

