/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.wrapper.ContentDescriptorTagField;
import org.jaudiotagger.audio.asf.util.AsfCopyrightField;
import org.jaudiotagger.audio.generic.GenericTag;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class TagConverter {
    public static void assignCommonTagValues(Tag tag, ExtendedContentDescription description) {
        ContentDescriptor tmp = null;
        if (tag.getFirstAlbum() != null && tag.getFirstAlbum().length() > 0) {
            tmp = new ContentDescriptor("WM/AlbumTitle", 0);
            tmp.setStringValue(tag.getFirstAlbum());
            description.addOrReplace(tmp);
        } else {
            description.remove("WM/AlbumTitle");
        }
        if (tag.getFirstTrack() != null && tag.getFirstTrack().length() > 0) {
            tmp = new ContentDescriptor("WM/TrackNumber", 0);
            tmp.setStringValue(tag.getFirstTrack());
            description.addOrReplace(tmp);
        } else {
            description.remove("WM/TrackNumber");
        }
        if (tag.getFirstYear() != null && tag.getFirstYear().length() > 0) {
            tmp = new ContentDescriptor("WM/Year", 0);
            tmp.setStringValue(tag.getFirstYear());
            description.addOrReplace(tmp);
        } else {
            description.remove("WM/Year");
        }
        if (tag.getFirstGenre() != null && tag.getFirstGenre().length() > 0) {
            tmp = new ContentDescriptor("WM/Genre", 0);
            tmp.setStringValue(tag.getFirstGenre());
            description.addOrReplace(tmp);
            int index = Arrays.asList(ExtendedContentDescription.DEFAULT_GENRES).indexOf(tag.getFirstGenre());
            if (index != -1) {
                tmp = new ContentDescriptor("WM/GenreID", 0);
                tmp.setStringValue("(" + index + ")");
                description.addOrReplace(tmp);
            } else {
                description.remove("WM/GenreID");
            }
        } else {
            description.remove("WM/Genre");
            description.remove("WM/GenreID");
        }
    }

    public static void assignOptionalTagValues(Tag tag, ExtendedContentDescription descriptor) {
        Iterator it = tag.getFields();
        ContentDescriptor tmp = null;
        while (it.hasNext()) {
            try {
                TagField currentField = (TagField)it.next();
                if (currentField.isCommon()) continue;
                tmp = new ContentDescriptor(currentField.getId(), 0);
                if (currentField.isBinary()) {
                    tmp.setBinaryValue(currentField.getRawContent());
                } else {
                    tmp.setStringValue(currentField.toString());
                }
                descriptor.addOrReplace(tmp);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
    }

    public static ContentDescription createContentDescription(Tag tag) {
        ContentDescription result = new ContentDescription();
        result.setAuthor(tag.getFirstArtist());
        result.setTitle(tag.getFirstTitle());
        result.setComment(tag.getFirstComment());
        TagTextField cpField = AsfCopyrightField.getCopyright(tag);
        if (cpField != null) {
            result.setCopyRight(cpField.getContent());
        }
        return result;
    }

    public static ExtendedContentDescription createExtendedContentDescription(Tag tag) {
        ExtendedContentDescription result = new ExtendedContentDescription();
        TagConverter.assignCommonTagValues(tag, result);
        return result;
    }

    public static Tag createTagOf(AsfHeader source) {
        GenericTag result = new GenericTag();
        if (source.getContentDescription() != null) {
            result.setArtist(source.getContentDescription().getAuthor());
            result.setComment(source.getContentDescription().getComment());
            result.setTitle(source.getContentDescription().getTitle());
            AsfCopyrightField cpField = new AsfCopyrightField();
            cpField.setContent(source.getContentDescription().getCopyRight());
            result.set(cpField);
        }
        if (source.getExtendedContentDescription() != null) {
            result.setYear(source.getExtendedContentDescription().getYear());
            result.setGenre(source.getExtendedContentDescription().getGenre());
            result.setAlbum(source.getExtendedContentDescription().getAlbum());
            ExtendedContentDescription extDesc = source.getExtendedContentDescription();
            for (ContentDescriptor current : extDesc.getDescriptors()) {
                if (current.isCommon()) continue;
                result.add(new ContentDescriptorTagField(current));
            }
        }
        return result;
    }
}

