/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec.io;

import com.onionnetworks.fec.io.FECParameters;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Category;

public class PacketPlacement {
    public static final short DECODED_BLOCK = -1;
    static Category cat = Category.getInstance((String)(class$Lcom$onionnetworks$fec$io$PacketPlacement != null ? class$Lcom$onionnetworks$fec$io$PacketPlacement : (class$Lcom$onionnetworks$fec$io$PacketPlacement = PacketPlacement.class$("com.onionnetworks.fec.io.PacketPlacement"))).getName());
    FECParameters params;
    int decodedBlockCount;
    int totalPacketCount;
    int extEntryCount;
    short[] packetCount;
    ArrayList[] entries;
    HashMap[] revEntries;
    int k;
    int blockCount;
    private static /* synthetic */ Class class$Lcom$onionnetworks$fec$io$PacketPlacement;

    public synchronized int getDecodedBlockCount() {
        return this.decodedBlockCount;
    }

    public synchronized void setBlockDecoded(int blockNum) {
        if (this.packetCount[blockNum] == -1) {
            throw new IllegalStateException("This block is already decoded:" + blockNum);
        }
        this.packetCount[blockNum] = -1;
        ++this.decodedBlockCount;
        this.entries[blockNum] = null;
        this.revEntries[blockNum] = null;
    }

    public synchronized boolean isBlockDecoded(int blockNum) {
        return this.packetCount[blockNum] == -1;
    }

    public synchronized int getPacketCount(int blockNum) {
        return this.packetCount[blockNum];
    }

    public synchronized int getWrittenCount() {
        return this.totalPacketCount;
    }

    public synchronized int getPacketIndex(int blockNum, int stripeNum) {
        Integer pi;
        if (this.isBlockDecoded(blockNum)) {
            return stripeNum >= 0 && stripeNum < this.k ? blockNum * this.k + stripeNum : -1;
        }
        HashMap h = this.revEntries[blockNum];
        if (h != null && (pi = (Integer)h.get(new Integer(stripeNum))) != null) {
            return pi;
        }
        return -1;
    }

    public synchronized int addPacketEntry(int blockNum, int stripeNum) {
        if (this.isBlockDecoded(blockNum)) {
            throw new IllegalStateException("block already decoded, blockNum=" + blockNum + ",stripeNum=" + stripeNum);
        }
        if (this.getPacketIndex(blockNum, stripeNum) != -1) {
            throw new IllegalArgumentException("Duplicate entry for blockNum=" + blockNum + ",stripeNum=" + stripeNum + ",packetIndex=" + this.getPacketIndex(blockNum, stripeNum));
        }
        short blockPacketCount = (short)this.getPacketCount(blockNum);
        int packetIndex = -1;
        ArrayList<Integer> blockEntries = this.entries[blockNum];
        if (blockEntries == null) {
            this.entries[blockNum] = blockEntries = new ArrayList<Integer>();
        }
        blockEntries.add(new Integer(stripeNum));
        if (blockPacketCount < this.k) {
            packetIndex = blockNum * this.k + blockPacketCount;
        } else {
            packetIndex = this.blockCount * this.k + this.extEntryCount;
            ++this.extEntryCount;
        }
        HashMap revBlockEntries = this.revEntries[blockNum];
        if (revBlockEntries == null) {
            this.revEntries[blockNum] = revBlockEntries = new HashMap();
        }
        this.revEntries[blockNum].put(new Integer(stripeNum), new Integer(packetIndex));
        int n = blockNum;
        this.packetCount[n] = (short)(this.packetCount[n] + 1);
        ++this.totalPacketCount;
        return packetIndex;
    }

    public synchronized int[] getStripeNums(int blockNum) {
        return this.getStripeNums(blockNum, this.entries[blockNum].size());
    }

    public synchronized int[] getStripeNums(int blockNum, int count) {
        int[] result = new int[count];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)this.entries[blockNum].get(i);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PacketPlacement(FECParameters params) {
        this.params = params;
        this.k = params.getK();
        this.blockCount = params.getBlockCount();
        this.packetCount = new short[this.blockCount];
        this.entries = new ArrayList[this.blockCount];
        this.revEntries = new HashMap[this.blockCount];
    }
}

