/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class AbstractFindBugsTask
extends Task {
    public static final String FINDBUGS_JAR = "findbugs.jar";
    public static final long DEFAULT_TIMEOUT = 600000L;
    private String mainClass;
    private boolean debug = false;
    private File homeDir = null;
    private String jvm = "";
    private String jvmargs = "";
    private long timeout = 600000L;
    private boolean failOnError = false;
    private String errorProperty = null;
    private List<SystemProperty> systemPropertyList = new ArrayList<SystemProperty>();
    private Path classpath = null;
    private Path pluginList = null;
    private Java findbugsEngine = null;

    protected AbstractFindBugsTask(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setHome(File homeDir) {
        this.homeDir = homeDir;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    protected boolean getDebug() {
        return this.debug;
    }

    public void setJvmargs(String args) {
        this.jvmargs = args;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setFailOnError(boolean flag) {
        this.failOnError = flag;
    }

    public void setErrorProperty(String name) {
        this.errorProperty = name;
    }

    public SystemProperty createSystemProperty() {
        SystemProperty systemProperty = new SystemProperty();
        this.systemPropertyList.add(systemProperty);
        return systemProperty;
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        Path path = this.createClasspath();
        path.setRefid(r);
        path.toString();
    }

    public void setPluginList(Path src) {
        if (this.pluginList == null) {
            this.pluginList = src;
        } else {
            this.pluginList.append(src);
        }
    }

    public Path createPluginList() {
        if (this.pluginList == null) {
            this.pluginList = new Path(this.getProject());
        }
        return this.pluginList.createPath();
    }

    public void setPluginListRef(Reference r) {
        this.createPluginList().setRefid(r);
    }

    public void execute() throws BuildException {
        block3: {
            this.checkParameters();
            try {
                this.execFindbugs();
            }
            catch (BuildException e) {
                if (this.errorProperty != null) {
                    this.getProject().setProperty(this.errorProperty, "true");
                }
                if (!this.failOnError) break block3;
                throw e;
            }
        }
    }

    protected void checkParameters() {
        if (this.homeDir == null && (this.classpath == null || this.pluginList == null)) {
            throw new BuildException("either home attribute or classpath and pluginList attributes  must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.pluginList != null) {
            String[] pluginFileList;
            for (String pluginFile : pluginFileList = this.pluginList.list()) {
                if (pluginFile.endsWith(".jar")) continue;
                throw new BuildException("plugin file " + pluginFile + " is not a Jar file " + "in task <" + this.getTaskName() + "/>", this.getLocation());
            }
        }
        for (SystemProperty aSystemPropertyList : this.systemPropertyList) {
            SystemProperty systemProperty = aSystemPropertyList;
            if (systemProperty.getName() != null && systemProperty.getValue() != null) continue;
            throw new BuildException("systemProperty elements must have name and value attributes");
        }
    }

    protected void createFindbugsEngine() {
        this.findbugsEngine = new Java();
        this.findbugsEngine.setProject(this.getProject());
        this.findbugsEngine.setTaskName(this.getTaskName());
        this.findbugsEngine.setFork(true);
        if (this.jvm.length() > 0) {
            this.findbugsEngine.setJvm(this.jvm);
        }
        this.findbugsEngine.setTimeout(Long.valueOf(this.timeout));
        if (this.debug) {
            this.jvmargs = this.jvmargs + " -Dfindbugs.debug=true";
        }
        this.findbugsEngine.createJvmarg().setLine(this.jvmargs);
        Iterator<SystemProperty> i$ = this.systemPropertyList.iterator();
        while (i$.hasNext()) {
            SystemProperty aSystemPropertyList;
            SystemProperty systemProperty = aSystemPropertyList = i$.next();
            String jvmArg = "-D" + systemProperty.getName() + "=" + systemProperty.getValue();
            this.findbugsEngine.createJvmarg().setValue(jvmArg);
        }
        if (this.homeDir != null) {
            File findbugsLib = new File(this.homeDir, "lib");
            File findbugsLibFindBugs = new File(findbugsLib, FINDBUGS_JAR);
            File findBugsFindBugs = new File(this.homeDir, FINDBUGS_JAR);
            if (findbugsLibFindBugs.exists()) {
                this.findbugsEngine.setClasspath(new Path(this.getProject(), findbugsLibFindBugs.getPath()));
            } else if (findBugsFindBugs.exists()) {
                this.findbugsEngine.setClasspath(new Path(this.getProject(), findBugsFindBugs.getPath()));
            } else {
                throw new IllegalArgumentException("Can't find findbugs.jar in " + this.homeDir);
            }
            this.findbugsEngine.createJvmarg().setValue("-Dfindbugs.home=" + this.homeDir.getPath());
        } else {
            this.findbugsEngine.setClasspath(this.classpath);
            this.addArg("-pluginList");
            this.addArg(this.pluginList.toString());
        }
        this.findbugsEngine.setClassname(this.mainClass);
    }

    protected Java getFindbugsEngine() {
        return this.findbugsEngine;
    }

    protected void addArg(String arg) {
        this.findbugsEngine.createArg().setValue(arg);
    }

    private void execFindbugs() throws BuildException {
        System.out.println("Executing findbugs from ant task");
        this.createFindbugsEngine();
        this.configureFindbugsEngine();
        this.beforeExecuteJavaProcess();
        if (this.getDebug()) {
            this.log(this.getFindbugsEngine().getCommandLine().describeCommand());
        }
        int rc = this.getFindbugsEngine().executeJava();
        this.afterExecuteJavaProcess(rc);
    }

    protected abstract void configureFindbugsEngine();

    protected abstract void beforeExecuteJavaProcess();

    protected abstract void afterExecuteJavaProcess(int var1);

    public static class SystemProperty {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

