/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.visualization.DefaultSettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.VertexLocationFunction;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class VertexLocationUtils {
    public static VertexLocationFunction scale(VertexLocationFunction vld, double dx, double dy) {
        DefaultSettableVertexLocationFunction out = new DefaultSettableVertexLocationFunction();
        double max_x = 0.0;
        double max_y = 0.0;
        Iterator iter = vld.getVertexIterator();
        while (iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)iter.next();
            Point2D location = vld.getLocation(v);
            max_x = Math.max(max_x, location.getX());
            max_y = Math.max(max_y, location.getY());
        }
        AffineTransform at = AffineTransform.getScaleInstance(dx / max_x, dy / max_y);
        Iterator iter2 = vld.getVertexIterator();
        while (iter2.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)iter2.next();
            Point2D location = vld.getLocation(v);
            Point2D.Double new_location = new Point2D.Double();
            at.transform(location, new_location);
            out.setLocation(v, new_location);
        }
        return out;
    }
}

