/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;
import test.net.sourceforge.pmd.cpd.MatchAlgorithmTest;

public class SourceCodeTest
extends TestCase {
    public void testSimple() throws Throwable {
        String code = MatchAlgorithmTest.getSampleCode();
        JavaTokenizer tokenizer = new JavaTokenizer();
        SourceCode sourceCode = new SourceCode("Foo.java");
        Assert.assertEquals((String)"Foo.java", (String)sourceCode.getFileName());
        tokenizer.tokenize(sourceCode, new Tokens(), new StringReader(code));
        Assert.assertEquals((String)"public class Foo { ", (String)sourceCode.getSlice(0, 0));
        Assert.assertEquals((String)" public void bar() {", (String)sourceCode.getSlice(1, 1));
        Assert.assertEquals((String)("public class Foo { " + CPD.EOL + " public void bar() {"), (String)sourceCode.getSlice(0, 1));
    }
}

