/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableUsageFinderFunction;
import net.sourceforge.pmd.util.Applier;

public abstract class AbstractScope
implements Scope {
    private Scope parent;
    protected Map variableNames = new HashMap();
    protected Map methodNames = new HashMap();

    public Scope getEnclosingClassScope() {
        return this.parent.getEnclosingClassScope();
    }

    public void setParent(Scope parent) {
        this.parent = parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException("Variable " + variableDecl + " is already in the symbol table");
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    public void addDeclaration(MethodNameDeclaration methodDecl) {
        this.parent.addDeclaration(methodDecl);
    }

    public boolean contains(NameOccurrence occurrence) {
        return this.findVariableHere(occurrence) != null;
    }

    public Map getVariableDeclarations(boolean lookingForUsed) {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames, lookingForUsed);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && !occurrence.isThisOrSuper()) {
            List nameOccurrences = (List)this.variableNames.get(decl);
            nameOccurrences.add(occurrence);
        }
        return decl;
    }

    protected abstract NameDeclaration findVariableHere(NameOccurrence var1);

    protected String glomNames() {
        String result = "";
        Iterator i = this.variableNames.keySet().iterator();
        while (i.hasNext()) {
            result = result + i.next().toString() + ",";
        }
        return result;
    }
}

