/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.StringWriter;
import java.util.Iterator;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;

class TextRenderer {
    private boolean m_reportNoViolations;
    private StringWriter m_writer;

    TextRenderer() {
    }

    protected void beginRendering(boolean reportNoViolations) {
        this.m_reportNoViolations = reportNoViolations;
        this.m_writer = new StringWriter(25000);
    }

    protected String endRendering() {
        return this.m_writer.toString();
    }

    public void render(String fileName, Report report) {
        Iterator violations = report.iterator();
        if (!violations.hasNext()) {
            if (this.m_reportNoViolations) {
                this.m_writer.write("Source File: ");
                this.m_writer.write(fileName);
                this.m_writer.write(10);
                this.m_writer.write("\nNo rule violations detected.");
            }
            return;
        }
        this.m_writer.write("Source File: ");
        this.m_writer.write(fileName);
        this.m_writer.write(10);
        while (violations.hasNext()) {
            RuleViolation ruleViolation = (RuleViolation)violations.next();
            Rule rule = ruleViolation.getRule();
            this.m_writer.write(10);
            this.m_writer.write("Line: ");
            this.m_writer.write(ruleViolation.getLine());
            this.m_writer.write(10);
            String ruleMessage = ruleViolation.getDescription();
            ruleMessage = ruleMessage == null ? "" : ruleMessage.replace('\n', ' ').trim();
            this.m_writer.write("Rule: ");
            this.m_writer.write(ruleMessage);
            this.m_writer.write(10);
            this.m_writer.write("Rule Priority: ");
            this.m_writer.write(rule.getPriorityName());
            this.m_writer.write(10);
            String description = rule.getDescription();
            description = description == null ? "" : description.replace('\n', ' ').trim();
            this.m_writer.write("Description: ");
            this.m_writer.write(description);
            this.m_writer.write(10);
            String example = rule.getExample();
            if (example == null || example.length() <= 0) continue;
            this.m_writer.write("Example: ");
            this.m_writer.write(example);
            this.m_writer.write(10);
        }
        this.m_writer.write("\n\n\n");
    }
}

