/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sourceforge.pmd.swingui.ComponentFactory;

public class MessageDialog
extends JDialog {
    private JTextArea m_messageArea;
    private Exception m_exception;
    private boolean m_yesButtonWasPressed;

    private MessageDialog(Frame parentWindow, String title, String message) {
        super(parentWindow, title, true);
        this.initialize(parentWindow, message);
    }

    private MessageDialog(Dialog parentWindow, String title, String message) {
        super(parentWindow, title, true);
        this.initialize(parentWindow, message);
    }

    private void initialize(Window parentWindow, String message) {
        int dialogWidth = 600;
        int dialogHeight = 150;
        Rectangle parentWindowBounds = parentWindow.getBounds();
        int x = parentWindowBounds.x + (parentWindowBounds.width - dialogWidth) / 2;
        int y = parentWindowBounds.y + (parentWindowBounds.height - dialogHeight) / 2;
        this.setBounds(x, y, dialogWidth, dialogHeight);
        JPanel basePanel = new JPanel();
        EtchedBorder etchedBorder = new EtchedBorder(1);
        EmptyBorder emptyBorder = new EmptyBorder(15, 15, 15, 15);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, emptyBorder);
        basePanel.setBorder(compoundBorder);
        basePanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)basePanel, "Center");
        this.m_messageArea = ComponentFactory.createTextArea(message);
        this.m_messageArea.setFont(UIManager.getFont("messageFont"));
        this.m_messageArea.setEditable(false);
        basePanel.add((Component)this.m_messageArea, "Center");
    }

    private void addCloseButton() {
        JButton closeButton = ComponentFactory.createButton("Close");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        closeButton = ComponentFactory.createButton("Close");
        closeButton.setForeground(Color.white);
        closeButton.setBackground(Color.blue);
        closeButton.addActionListener(new CloseButtonActionListener());
        buttonPanel.add(closeButton);
    }

    private void addAnswerButtons() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton yesButton = ComponentFactory.createButton("Yes");
        yesButton.setForeground(Color.white);
        yesButton.setBackground(UIManager.getColor("pmdGreen"));
        yesButton.addActionListener(new YesButtonActionListener());
        buttonPanel.add(yesButton);
        JButton noButton = ComponentFactory.createButton("No");
        noButton.setForeground(Color.white);
        noButton.setBackground(Color.red);
        noButton.addActionListener(new NoButtonActionListener());
        buttonPanel.add(noButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public static void show(Window parentWindow, String message, Exception exception) {
        if (exception == null) {
            MessageDialog.show(parentWindow, message);
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(5000);
            PrintStream printStream = new PrintStream(stream);
            exception.printStackTrace(printStream);
            message = message == null ? stream.toString() : message + "\n" + stream.toString();
            printStream.close();
            MessageDialog dialog = parentWindow instanceof Frame ? new MessageDialog((Frame)parentWindow, "Exception", message) : new MessageDialog((Dialog)parentWindow, "Exception", message);
            dialog.addCloseButton();
            dialog.setVisible(true);
        }
    }

    protected static boolean answerIsYes(Window parentWindow, String message) {
        MessageDialog dialog = MessageDialog.setup(parentWindow, message);
        dialog.addAnswerButtons();
        dialog.setVisible(true);
        return dialog.m_yesButtonWasPressed;
    }

    public static void show(Window parentWindow, String message) {
        MessageDialog dialog = MessageDialog.setup(parentWindow, message);
        dialog.addCloseButton();
        dialog.setVisible(true);
    }

    private static MessageDialog setup(Window parentWindow, String message) {
        if (message == null) {
            message = "There is no message.";
        }
        String title = "Information";
        MessageDialog dialog = parentWindow instanceof Frame ? new MessageDialog((Frame)parentWindow, title, message) : new MessageDialog((Dialog)parentWindow, title, message);
        return dialog;
    }

    private class NoButtonActionListener
    implements ActionListener {
        private NoButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.this.m_yesButtonWasPressed = false;
            MessageDialog.this.setVisible(false);
        }
    }

    private class YesButtonActionListener
    implements ActionListener {
        private YesButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.this.m_yesButtonWasPressed = true;
            MessageDialog.this.setVisible(false);
        }
    }

    private class CloseButtonActionListener
    implements ActionListener {
        private CloseButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.this.setVisible(false);
        }
    }
}

