/*
 * $HeadURL: http://svn.apache.org/repos/asf/jakarta/httpcomponents/httpcore/tags/4.0-alpha6/module-nio/src/main/java/org/apache/http/nio/entity/ContentInputStream.java $
 * $Revision: 538089 $
 * $Date: 2007-05-15 10:18:16 +0200 (Tue, 15 May 2007) $
 *
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.nio.entity;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.nio.util.ContentInputBuffer;

public class ContentInputStream extends InputStream {

    private final ContentInputBuffer buffer;
    
    public ContentInputStream(final ContentInputBuffer buffer) {
        super();
        if (buffer == null) {
            throw new IllegalArgumentException("Input buffer may not be null");
        }
        this.buffer = buffer;
    }
    
    public int read(final byte[] b, int off, int len) throws IOException {
        return this.buffer.read(b, off, len);
    }
    
    public int read(final byte[] b) throws IOException {
        if (b == null) {
            return 0;
        }
        return this.buffer.read(b, 0, b.length);
    }
    
    public int read() throws IOException {
        return this.buffer.read();
    }

}
