/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.visualization.AbstractRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class BasicRenderer
extends AbstractRenderer {
    private String mSizeKey;
    private double mNodeSizeScale = 1.0;
    private int mDefaultNodeSize = 8;
    String mLabel;

    public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        Color c = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(c);
    }

    public void paintVertex(Graphics g, Vertex v, int x, int y) {
        String label = null;
        if (this.getLabel() != null) {
            label = StringLabeller.getLabeller((Graph)v.getGraph()).getLabel(v);
        }
        if (label == null) {
            label = v.toString();
        }
        if (label.length() > 15) {
            label = label.substring(0, 14);
        }
        int nodeSize = this.mDefaultNodeSize;
        if (this.mSizeKey != null) {
            Number decoratedNodeSize = (Number)v.getUserDatum(this.mSizeKey);
            nodeSize = (int)Math.ceil(decoratedNodeSize.doubleValue() * this.mNodeSizeScale);
        }
        if (this.isPicked(v)) {
            g.setColor(Color.ORANGE);
        } else {
            g.setColor(Color.RED);
        }
        int labelSize = g.getFontMetrics().stringWidth(label);
        nodeSize = Math.max(nodeSize, 10);
        nodeSize = Math.min(nodeSize, 150);
        g.fillOval(x - nodeSize / 2, y - nodeSize / 2, nodeSize, nodeSize);
        g.setColor(Color.GRAY);
        g.drawOval(x - nodeSize / 2, y - nodeSize / 2, nodeSize, nodeSize);
        g.setColor(Color.BLACK);
        Font font = new Font("Arial", 0, 12);
        Font f = g.getFont();
        g.setFont(font);
        if (nodeSize > labelSize) {
            g.drawString(label, x - labelSize / 2, y + 4);
        } else {
            g.drawString(label, x - labelSize / 2 + 20, y + 15);
        }
        g.setFont(f);
    }

    public String getSizeKey() {
        return this.mSizeKey;
    }

    public void setSizeKey(String decorationKey) {
        this.mSizeKey = decorationKey;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public double getNodeSizeScale() {
        return this.mNodeSizeScale;
    }

    public void setNodeSizeScale(double nodeSizeScale) {
        this.mNodeSizeScale = nodeSizeScale;
    }
}

