/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.ConstantEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.EdgeColorFunction;
import edu.uci.ics.jung.graph.decorators.EdgeThicknessFunction;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.VertexColorFunction;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.LevelFilter;
import edu.uci.ics.jung.graph.filters.SerialFilter;
import edu.uci.ics.jung.graph.filters.impl.DropSoloNodesFilter;
import edu.uci.ics.jung.visualization.EdgeColorToEdgePaintFunctionConverter;
import edu.uci.ics.jung.visualization.EdgeThicknessToEdgeStrokeFunctionConverter;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MouseListenerTranslator;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.StatusCallback;
import edu.uci.ics.jung.visualization.VertexColorToVertexPaintConverter;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphDraw
extends JComponent
implements StatusCallback {
    protected VisualizationViewer vv;
    protected Filter mainFilter;
    protected List allFilters = new LinkedList();
    protected List sliders = new LinkedList();
    protected JPanel toolbar;
    protected JLabel statusbar;

    public GraphDraw(Graph g) {
        this(new SpringLayout(g));
    }

    public GraphDraw(Layout layout) {
        Graph g = layout.getGraph();
        StringLabeller sl = StringLabeller.getLabeller(g);
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexStringer(sl);
        this.vv = new VisualizationViewer(layout, (Renderer)pr);
        this.setLayout(new BorderLayout());
        this.add((Component)this.vv, "Center");
        this.toolbar = new JPanel();
        this.add((Component)this.toolbar, "West");
        this.toolbar.setVisible(false);
        this.statusbar = new JLabel(" ");
        this.add((Component)this.statusbar, "South");
        this.vv.setTextCallback(this);
        this.hideStatus();
        this.mainFilter = DropSoloNodesFilter.getInstance();
    }

    public VisualizationViewer getVisualizationViewer() {
        return this.vv;
    }

    public void addGraphMouseListener(GraphMouseListener gel) {
        this.vv.addMouseListener(new MouseListenerTranslator(gel, this.vv));
    }

    public void showStatus() {
        this.statusbar.setVisible(true);
    }

    public void hideStatus() {
        this.statusbar.setVisible(false);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.vv.setBackground(bg);
    }

    public void callBack(String status) {
        this.statusbar.setText(status);
    }

    public void setRenderer(Renderer r) {
        this.vv.setRenderer(r);
    }

    public void resetRenderer() {
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexStringer(StringLabeller.getLabeller(this.vv.getGraphLayout().getGraph()));
        this.vv.setRenderer(pr);
    }

    public Renderer getRender() {
        return this.vv.getRenderer();
    }

    public Renderer getRenderer() {
        return this.vv.renderer;
    }

    public void setEdgeColor(Color c) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setEdgePaintFunction(new ConstantEdgePaintFunction(c, null));
    }

    public void setEdgeColorFunction(EdgeColorFunction ecf) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setEdgePaintFunction(new EdgeColorToEdgePaintFunctionConverter(ecf));
    }

    public void setEdgeThickness(int i) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setEdgeStrokeFunction(new ConstantEdgeStrokeFunction(new BasicStroke(i)));
    }

    public void setEdgeThicknessFunction(EdgeThicknessFunction etf) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setEdgeStrokeFunction(new EdgeThicknessToEdgeStrokeFunctionConverter(etf));
    }

    public void setVertexForegroundColor(Color vertexColor) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setVertexPaintFunction(new PickableVertexPaintFunction(this.vv.getPickedState(), vertexColor, Color.RED, Color.ORANGE));
    }

    public void setVertexPickedColor(Color vertexColor) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setVertexPaintFunction(new PickableVertexPaintFunction(this.vv.getPickedState(), Color.BLACK, Color.RED, vertexColor));
    }

    public void setVertexBGColor(Color vertexColor) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setVertexPaintFunction(new PickableVertexPaintFunction(this.vv.getPickedState(), Color.BLACK, vertexColor, Color.ORANGE));
    }

    public void setVertexColorFunction(VertexColorFunction vcf) {
        Renderer r = this.vv.getRenderer();
        if (!(r instanceof PluggableRenderer)) {
            return;
        }
        PluggableRenderer pr = (PluggableRenderer)r;
        pr.setVertexPaintFunction(new VertexColorToVertexPaintConverter(vcf));
    }

    public void setGraphLayout(Layout l) {
        this.vv.setGraphLayout(l);
    }

    public void removeAllFilters() {
        this.toolbar.removeAll();
        this.toolbar.setVisible(false);
        this.sliders.clear();
        this.allFilters.clear();
        this.mainFilter = new SerialFilter(this.allFilters);
    }

    public void addStaticFilter(Filter f) {
        this.allFilters.add(f);
        this.mainFilter = new SerialFilter(this.allFilters);
    }

    public JSlider addSlider(LevelFilter l, int low, int high, int defaultVal) {
        JSlider js = new JSlider(1, low, high, defaultVal);
        l.setValue(defaultVal);
        this.sliders.add(js);
        this.toolbar.add(js);
        this.toolbar.setVisible(true);
        js.addChangeListener(new SliderChangeListener(this, js, l));
        this.allFilters.add(l);
        this.mainFilter = new SerialFilter(this.allFilters);
        return js;
    }

    public void addTool(JComponent jc) {
        this.toolbar.add(jc);
        this.toolbar.setVisible(true);
    }

    public Layout getGraphLayout() {
        return this.vv.getGraphLayout();
    }

    public void restartLayout() {
        this.vv.restart();
    }

    public void stop() {
        this.vv.stop();
    }

    protected class SliderChangeListener
    implements ChangeListener {
        protected LevelFilter levelFilter;
        protected JSlider js;
        protected GraphDraw gd;
        int oldValue = -1;

        public SliderChangeListener(GraphDraw gd, JSlider js, LevelFilter l) {
            this.levelFilter = l;
            this.js = js;
            this.gd = gd;
        }

        public void stateChanged(ChangeEvent e) {
            int val = this.js.getValue();
            if (this.oldValue == val) {
                return;
            }
            this.oldValue = val;
            this.levelFilter.setValue(val);
            Layout l = this.gd.getVisualizationViewer().getGraphLayout();
            Graph fg = this.gd.mainFilter.filter(l.getGraph()).assemble();
            l.applyFilter(fg);
        }
    }
}

