/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.Lens;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BirdsEyeVisualizationViewer
extends JPanel {
    protected VisualizationViewer vv;
    protected Renderer renderer;
    protected VisualizationModel model;
    protected Map renderingHints = new HashMap();
    protected float scalex = 1.0f;
    protected float scaley = 1.0f;
    protected Lens lens;
    protected MutableTransformer layoutTransformer = new MutableAffineTransformer(new AffineTransform());

    public BirdsEyeVisualizationViewer(VisualizationViewer vv, float scalex, float scaley) {
        this.vv = vv;
        this.model = vv.getModel();
        this.model.setRelaxerThreadSleepTime(200L);
        this.renderer = vv.getRenderer();
        this.scalex = scalex;
        this.scaley = scaley;
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setLayoutTransformer(vv.getLayoutTransformer());
    }

    public MutableTransformer getLayoutTransformer() {
        return this.layoutTransformer;
    }

    public void setLayoutTransformer(MutableTransformer layoutTransformer) {
        this.layoutTransformer = layoutTransformer;
    }

    public void resetLens() {
        if (this.lens != null) {
            this.lens.reset();
        }
    }

    public void initLens() {
        if (this.lens != null) {
            this.lens.init();
        }
    }

    public void zoom(float percent) {
        this.vv.getViewTransformer().scale(percent, percent, this.vv.getCenter());
    }

    public void addNotify() {
        super.addNotify();
        Dimension layoutSize = this.model.getGraphLayout().getCurrentSize();
        if (layoutSize != null) {
            Dimension mySize = new Dimension((int)((float)layoutSize.width * this.scalex), (int)((float)layoutSize.height * this.scaley));
            this.setPreferredSize(mySize);
            this.initMouseClicker();
        }
    }

    protected void initMouseClicker() {
        Dimension layoutSize = this.model.getGraphLayout().getCurrentSize();
        if (layoutSize != null) {
            this.lens = new Lens(this.vv, this.scalex, this.scaley);
        }
        this.vv.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                VisualizationViewer vv = (VisualizationViewer)e.getSource();
                BirdsEyeVisualizationViewer.this.lens.setFrame(vv);
                BirdsEyeVisualizationViewer.this.repaint();
            }
        });
        this.addMouseListener(this.lens);
        this.addMouseMotionListener(this.lens);
    }

    public void setRenderer(Renderer r) {
        this.renderer = r;
        this.repaint();
    }

    public void setGraphLayout(Layout layout) {
        this.model.setGraphLayout(layout);
    }

    public Layout getGraphLayout() {
        return this.model.getGraphLayout();
    }

    private void paintGraph(Graphics g) {
        Layout layout = this.model.getGraphLayout();
        Iterator iter = layout.getGraph().getEdges().iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            Vertex v1 = (Vertex)e.getEndpoints().getFirst();
            Vertex v2 = (Vertex)e.getEndpoints().getSecond();
            Point2D p1 = layout.getLocation(v1);
            Point2D p2 = layout.getLocation(v2);
            p1 = this.layoutTransformer.transform(p1);
            p2 = this.layoutTransformer.transform(p2);
            this.renderer.paintEdge(g, e, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
        }
        iter = layout.getGraph().getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            Point2D p = layout.getLocation(v);
            p = this.layoutTransformer.transform(p);
            this.renderer.paintVertex(g, v, (int)p.getX(), (int)p.getY());
        }
    }

    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(this.renderingHints);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.scale(this.scalex, this.scaley);
        g2d.setTransform(newXform);
        this.paintGraph(g);
        Color oldColor = g.getColor();
        g2d.setColor(Color.cyan);
        g2d.setTransform(oldXform);
        if (this.lens != null) {
            g2d.draw(this.lens);
        }
        g.setColor(oldColor);
    }
}

