/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.statistics;

import cern.colt.list.DoubleArrayList;
import edu.uci.ics.jung.statistics.StatisticalMoments;
import edu.uci.ics.jung.utils.NumericalPrecision;

public class Histogram {
    private double minimum;
    private double binWidth;
    private int[] contents;
    private boolean growthAllowed = false;
    private boolean integerBinWidth = false;
    private int underflow;
    private int overflow;
    private StatisticalMoments moments;
    private boolean cached = false;
    private double[] cache;

    public Histogram() {
        this(100);
    }

    public Histogram(double from, double to) {
        this(from, to, 50);
    }

    public Histogram(double from, double to, int bins) {
        this.defineParameters(from, to, bins);
    }

    public Histogram(int n) {
        this(n, 50);
    }

    public Histogram(int n, double min, double width) throws IllegalArgumentException {
        if (width <= 0.0) {
            throw new IllegalArgumentException("Non-positive bin width: " + width);
        }
        this.contents = new int[n];
        this.minimum = min;
        this.binWidth = width;
        this.reset();
    }

    public Histogram(int n, int m) {
        this.cached = true;
        this.cache = new double[n];
        this.underflow = 0;
        this.overflow = m;
    }

    public void fill(DoubleArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.fill(list.get(i));
        }
    }

    public void fill(double x) {
        if (this.cached) {
            this.cache[this.underflow++] = x;
            if (this.underflow == this.cache.length) {
                this.flushCache();
            }
        } else if (x < this.minimum) {
            if (this.growthAllowed) {
                this.expandDown(x);
                this.moments.accumulate(x);
            } else {
                ++this.underflow;
            }
        } else {
            int index = this.binIndex(x);
            if (index < this.contents.length) {
                int n = index;
                this.contents[n] = this.contents[n] + 1;
                this.moments.accumulate(x);
            } else if (this.growthAllowed) {
                this.expandUp(x);
                this.moments.accumulate(x);
            } else {
                ++this.overflow;
            }
        }
    }

    public double average() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.average();
    }

    public int binIndex(double x) {
        return (int)Math.floor((x - this.minimum) / this.binWidth);
    }

    public long count() {
        return this.cached ? (long)this.underflow : this.moments.count();
    }

    private void defineParameters(double from, double to, int bins) throws IllegalArgumentException {
        if (from >= to) {
            throw new IllegalArgumentException("Inverted range: minimum = " + from + ", maximum = " + to);
        }
        if (bins < 1) {
            throw new IllegalArgumentException("Non-positive number of bins: " + bins);
        }
        this.binWidth = NumericalPrecision.roundToScale((to - from) / (double)bins, this.integerBinWidth);
        this.minimum = this.binWidth * Math.floor(from / this.binWidth);
        int numberOfBins = (int)Math.ceil((to - this.minimum) / this.binWidth);
        if (this.minimum + (double)numberOfBins * this.binWidth <= to) {
            ++numberOfBins;
        }
        this.contents = new int[numberOfBins];
        this.cached = false;
        this.cache = null;
        this.reset();
    }

    public double errorOnAverage() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.errorOnAverage();
    }

    private void expandDown(double x) {
        int n;
        int addSize = (int)Math.ceil((this.minimum - x) / this.binWidth);
        int[] newContents = new int[addSize + this.contents.length];
        this.minimum -= (double)addSize * this.binWidth;
        newContents[0] = 1;
        for (n = 1; n < addSize; ++n) {
            newContents[n] = 0;
        }
        for (n = 0; n < this.contents.length; ++n) {
            newContents[n + addSize] = this.contents[n];
        }
        this.contents = newContents;
    }

    private void expandUp(double x) {
        int n;
        int newSize = (int)Math.ceil((x - this.minimum) / this.binWidth);
        int[] newContents = new int[newSize];
        for (n = 0; n < this.contents.length; ++n) {
            newContents[n] = this.contents[n];
        }
        for (n = this.contents.length; n < newSize - 1; ++n) {
            newContents[n] = 0;
        }
        newContents[n] = 1;
        this.contents = newContents;
    }

    private void flushCache() {
        int n;
        double min;
        double max = min = this.cache[0];
        int cacheSize = this.underflow;
        double[] cachedValues = this.cache;
        for (n = 1; n < cacheSize; ++n) {
            if (this.cache[n] < min) {
                min = this.cache[n];
                continue;
            }
            if (!(this.cache[n] > max)) continue;
            max = this.cache[n];
        }
        this.defineParameters(min, max, this.overflow);
        for (n = 0; n < cacheSize; ++n) {
            this.fill(cachedValues[n]);
        }
    }

    public double binHeight(double x) {
        if (x < this.minimum) {
            return Double.NaN;
        }
        int n = this.binIndex(x);
        return n < this.contents.length ? this.yValueAt(n) : Double.NaN;
    }

    public double[] getBinParameters(double x) {
        int index;
        if (x >= this.minimum && (index = (int)Math.floor((x - this.minimum) / this.binWidth)) < this.contents.length) {
            double[] answer;
            answer = new double[]{this.minimum + (double)index * this.binWidth, answer[0] + this.binWidth, this.contents[index]};
            return answer;
        }
        return null;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public double getCountsBetween(double x, double y) {
        int n = this.binIndex(x);
        int m = this.binIndex(y);
        double sum = (double)this.contents[n] * ((this.minimum - x) / this.binWidth - (double)(n + 1)) + (double)this.contents[m] * ((y - this.minimum) / this.binWidth - (double)m);
        while (++n < m) {
            sum += (double)this.contents[n];
        }
        return sum;
    }

    public double getCountsUpTo(double x) {
        int n = this.binIndex(x);
        double sum = (double)this.contents[n] * ((x - this.minimum) / this.binWidth - (double)n) + (double)this.underflow;
        for (int i = 0; i < n; ++i) {
            sum += (double)this.contents[i];
        }
        return sum;
    }

    public double getDimension() {
        if (this.cached) {
            this.flushCache();
        }
        return this.contents.length;
    }

    public int getNumBins() {
        if (this.cached) {
            this.flushCache();
        }
        return this.contents.length;
    }

    public double getMaximum() {
        return this.minimum + (double)(this.contents.length - 1) * this.binWidth;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double[] getRange() {
        if (this.cached) {
            this.flushCache();
        }
        double[] range = new double[]{this.minimum, this.getMaximum(), 0.0, 0.0};
        for (int n = 0; n < this.contents.length; ++n) {
            range[3] = Math.max(range[3], (double)this.contents[n]);
        }
        return range;
    }

    public double kurtosis() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.kurtosis();
    }

    protected StatisticalMoments moments() {
        return this.moments;
    }

    public long overflow() {
        return this.cached ? 0L : (long)this.overflow;
    }

    public void reset() {
        if (this.moments == null) {
            this.moments = new StatisticalMoments();
        } else {
            this.moments.reset();
        }
        this.underflow = 0;
        this.overflow = 0;
        for (int n = 0; n < this.contents.length; ++n) {
            this.contents[n] = 0;
        }
    }

    public void setGrowthAllowed() throws RuntimeException {
        if (!(this.underflow == 0 && this.overflow == 0 || this.cached)) {
            throw new RuntimeException("Cannot allow growth to a non-empty histogram");
        }
        this.growthAllowed = true;
    }

    public void setIntegerBinWidth() throws RuntimeException {
        if (!this.cached) {
            throw new RuntimeException("Cannot change bin width of a non-empty histogram");
        }
        this.integerBinWidth = true;
    }

    public int size() {
        if (this.cached) {
            this.flushCache();
        }
        return this.contents.length;
    }

    public double skewness() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.skewness();
    }

    public double standardDeviation() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.standardDeviation();
    }

    public long totalCount() {
        return this.cached ? (long)this.underflow : this.moments.count() + (long)this.overflow + (long)this.underflow;
    }

    public long underflow() {
        return this.cached ? 0L : (long)this.underflow;
    }

    public double variance() {
        if (this.cached) {
            this.flushCache();
        }
        return this.moments.variance();
    }

    public double xValueAt(int index) {
        return (double)index * this.binWidth + this.minimum;
    }

    public double yValueAt(int index) {
        if (this.cached) {
            this.flushCache();
        }
        return index >= 0 && index < this.contents.length ? (double)this.contents[index] : 0.0;
    }
}

