/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ConfigurationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructionContext<T> {
    T currentReference;
    boolean constructing;
    List<DelegatingInvocationHandler<T>> invocationHandlers;

    ConstructionContext() {
    }

    T getCurrentReference() {
        return this.currentReference;
    }

    void removeCurrentReference() {
        this.currentReference = null;
    }

    void setCurrentReference(T currentReference) {
        this.currentReference = currentReference;
    }

    boolean isConstructing() {
        return this.constructing;
    }

    void startConstruction() {
        this.constructing = true;
    }

    void finishConstruction() {
        this.constructing = false;
        this.invocationHandlers = null;
    }

    Object createProxy(Class<?> expectedType) {
        if (!expectedType.isInterface()) {
            throw new ConfigurationException("Tried proxying " + expectedType.getName() + " to support a circular dependency, but" + " it is not an interface.");
        }
        if (this.invocationHandlers == null) {
            this.invocationHandlers = new ArrayList<DelegatingInvocationHandler<T>>();
        }
        DelegatingInvocationHandler invocationHandler = new DelegatingInvocationHandler();
        this.invocationHandlers.add(invocationHandler);
        Object object = Proxy.newProxyInstance(expectedType.getClassLoader(), new Class[]{expectedType}, invocationHandler);
        return expectedType.cast(object);
    }

    void setProxyDelegates(T delegate) {
        if (this.invocationHandlers != null) {
            for (DelegatingInvocationHandler<T> handler : this.invocationHandlers) {
                handler.setDelegate(delegate);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingInvocationHandler<T>
    implements InvocationHandler {
        T delegate;

        DelegatingInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegate == null) {
                throw new IllegalStateException("This is a proxy used to support circular references involving constructors. The object we're proxying is not constructed yet. Please wait until after injection has completed to use this object.");
            }
            try {
                return method.invoke(this.delegate, args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        void setDelegate(T delegate) {
            this.delegate = delegate;
        }
    }
}

