/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
        int cursorStyle = (style & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, cursorStyle);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 5;
        } else {
            width += 5;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x820;
        int features = 4;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control, int context) {
        this.fillBackground(control, context, null);
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        return result;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.display.setCursor(this.sizeCursor.handle);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            Point location = this.getLocation();
            this.lastX = location.x;
            this.lastY = location.y;
        }
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if ((modifiers[0] & 0x1000) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyCode[0] == 126 || keyCode[0] == 125) break;
                    xChange = keyCode[0] == 123 ? -stepSize : stepSize;
                } else {
                    if (keyCode[0] == 123 || keyCode[0] == 124) break;
                    yChange = keyCode[0] == 126 ? -stepSize : stepSize;
                }
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                Rectangle parentBounds = this.parent.getBounds();
                int parentWidth = parentBounds.width;
                int parentHeight = parentBounds.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed() || !event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                if (this.isDisposed()) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if (this.isDisposed()) {
                    return result;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int chord, short x, short y, int modifiers) {
        boolean result = super.sendMouseEvent(type, button, count, detail, send, chord, x, y, modifiers);
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        short controlX = rect.left;
        short controlY = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        OS.GetControlBounds(this.parent.handle, rect);
        int parentWidth = rect.right - rect.left;
        int parentHeight = rect.bottom - rect.top;
        switch (type) {
            case 3: {
                if (button != 1 || count != 1) break;
                this.startX = x;
                this.startY = y;
                Event event = new Event();
                event.x = controlX;
                event.y = controlY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.dragging = true;
                this.setBounds(event.x, event.y, width, height);
                break;
            }
            case 4: {
                if (!this.dragging) break;
                this.dragging = false;
                Event event = new Event();
                event.x = this.lastX;
                event.y = this.lastY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                break;
            }
            case 5: {
                if (!this.dragging) break;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, x + controlX - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, y + controlY - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.setBounds(event.x, event.y, width, height);
            }
        }
        return result;
    }

    int traversalCode(int key, int theEvent) {
        return 0;
    }
}

