/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        CGRect oldBounds;
        this.checkWidget();
        CGRect bounds = oldBounds = new CGRect();
        OS.HIViewGetFrame(this.handle, oldBounds);
        int MIN_SIZE = 100;
        if (oldBounds.width < (float)MIN_SIZE || oldBounds.height < (float)MIN_SIZE) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
            bounds = new CGRect();
            bounds.height = 100.0f;
            bounds.width = 100.0f;
            OS.HIViewSetFrame(this.handle, bounds);
        }
        int rgnHandle = OS.NewRgn();
        OS.GetControlRegion(this.handle, (short)-2, rgnHandle);
        Rect client = new Rect();
        OS.GetRegionBounds(rgnHandle, client);
        OS.DisposeRgn(rgnHandle);
        width += (int)bounds.width - (client.right - client.left);
        height += (int)bounds.height - (client.bottom - client.top);
        if (oldBounds.width < (float)MIN_SIZE || oldBounds.height < (float)MIN_SIZE) {
            OS.HIViewSetFrame(this.handle, oldBounds);
            OS.HIViewSetDrawingEnabled(this.handle, this.drawCount == 0);
        }
        return new Rectangle(-client.left, -client.top, width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateGroupBoxControl(window, null, 0, true, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control, int context) {
        this.fillBackground(control, context, null);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int rgnHandle = OS.NewRgn();
        OS.GetControlRegion(this.handle, (short)-2, rgnHandle);
        Rect client = new Rect();
        OS.GetRegionBounds(rgnHandle, client);
        OS.DisposeRgn(rgnHandle);
        return new Rectangle(client.left, client.top, client.right - client.left, client.bottom - client.top);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    float getThemeAlpha() {
        return 0.25f * this.parent.getThemeAlpha();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlTitleWithCFString(this.handle, ptr);
        OS.CFRelease(ptr);
    }
}

