/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import de.kapsi.net.daap.nio.DaapLineReaderNIO;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

class DaapRequestReaderNIO {
    private static final int MAX_HEADER_SIZE = 4096;
    private long bytesRead = 0L;
    private DaapConnectionNIO connection;
    private ByteBuffer in;
    private String requestLine;
    private List<Header> headers;
    private DaapLineReaderNIO lineReader;
    private LinkedList<DaapRequest> pending;

    DaapRequestReaderNIO(DaapConnectionNIO connection) {
        this.connection = connection;
        this.in = ByteBuffer.allocate(4096);
        this.in.clear();
        this.in.flip();
        this.lineReader = new DaapLineReaderNIO();
        this.headers = new ArrayList<Header>();
        this.pending = new LinkedList();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public DaapRequest read() throws IOException {
        DaapRequest ret = null;
        if (!this.pending.isEmpty()) {
            ret = this.pending.removeFirst();
        }
        String line = null;
        while ((line = this.lineReader.read(this.in, this.connection.getReadChannel())) != null) {
            this.bytesRead += (long)this.in.position();
            if (this.requestLine == null) {
                this.requestLine = line;
                continue;
            }
            int p = line.indexOf(58);
            if (p == -1) {
                this.requestLine = null;
                this.headers.clear();
                this.lineReader = null;
                throw new IOException("Malformed Header");
            }
            String name = line.substring(0, p).trim();
            String value = line.substring(++p).trim();
            this.headers.add((Header)new BasicHeader(name, value));
        }
        if (this.lineReader.isComplete()) {
            DaapRequest request = null;
            try {
                request = new DaapRequest(this.connection, this.requestLine);
                request.addHeaders(this.headers);
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                this.requestLine = null;
                this.headers.clear();
            }
            if (ret == null) {
                ret = request;
            } else {
                this.pending.addLast(request);
            }
        } else if (this.headers.size() >= 64) {
            this.requestLine = null;
            this.headers.clear();
            throw new IOException("Header too large");
        }
        return ret;
    }
}

